"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-4903
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.telemetry_druid_aggregator import TelemetryDruidAggregator
    from intersight.model.telemetry_druid_data_source import TelemetryDruidDataSource
    from intersight.model.telemetry_druid_dimension_spec import TelemetryDruidDimensionSpec
    from intersight.model.telemetry_druid_filter import TelemetryDruidFilter
    from intersight.model.telemetry_druid_granularity import TelemetryDruidGranularity
    from intersight.model.telemetry_druid_post_aggregator import TelemetryDruidPostAggregator
    from intersight.model.telemetry_druid_query_context import TelemetryDruidQueryContext
    from intersight.model.telemetry_druid_top_n_metric_spec import TelemetryDruidTopNMetricSpec
    globals()['TelemetryDruidAggregator'] = TelemetryDruidAggregator
    globals()['TelemetryDruidDataSource'] = TelemetryDruidDataSource
    globals()['TelemetryDruidDimensionSpec'] = TelemetryDruidDimensionSpec
    globals()['TelemetryDruidFilter'] = TelemetryDruidFilter
    globals()['TelemetryDruidGranularity'] = TelemetryDruidGranularity
    globals()['TelemetryDruidPostAggregator'] = TelemetryDruidPostAggregator
    globals()['TelemetryDruidQueryContext'] = TelemetryDruidQueryContext
    globals()['TelemetryDruidTopNMetricSpec'] = TelemetryDruidTopNMetricSpec


class TelemetryDruidTopNRequestAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'data_source': (TelemetryDruidDataSource,),  # noqa: E501
            'intervals': ([str],),  # noqa: E501
            'granularity': (TelemetryDruidGranularity,),  # noqa: E501
            'dimension': (TelemetryDruidDimensionSpec,),  # noqa: E501
            'threshold': (int,),  # noqa: E501
            'metric': (TelemetryDruidTopNMetricSpec,),  # noqa: E501
            'filter': (TelemetryDruidFilter,),  # noqa: E501
            'aggregations': ([TelemetryDruidAggregator],),  # noqa: E501
            'post_aggregations': ([TelemetryDruidPostAggregator],),  # noqa: E501
            'context': (TelemetryDruidQueryContext,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'data_source': 'dataSource',  # noqa: E501
        'intervals': 'intervals',  # noqa: E501
        'granularity': 'granularity',  # noqa: E501
        'dimension': 'dimension',  # noqa: E501
        'threshold': 'threshold',  # noqa: E501
        'metric': 'metric',  # noqa: E501
        'filter': 'filter',  # noqa: E501
        'aggregations': 'aggregations',  # noqa: E501
        'post_aggregations': 'postAggregations',  # noqa: E501
        'context': 'context',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, data_source, intervals, granularity, dimension, threshold, metric, *args, **kwargs):  # noqa: E501
        """TelemetryDruidTopNRequestAllOf - a model defined in OpenAPI

        Args:
            data_source (TelemetryDruidDataSource):
            intervals ([str]): A JSON Object representing ISO-8601 Intervals. This defines the time ranges to run the query over.
            granularity (TelemetryDruidGranularity):
            dimension (TelemetryDruidDimensionSpec):
            threshold (int): An integer defining the N in the topN (i.e. how many results you want in the top list).
            metric (TelemetryDruidTopNMetricSpec):

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            filter (TelemetryDruidFilter): [optional]  # noqa: E501
            aggregations ([TelemetryDruidAggregator]): Aggregation functions are used to summarize data in buckets. Summarization functions include counting rows, calculating the min/max/sum of metrics and retrieving the first/last value of metrics for each bucket. Additional summarization functions are available with extensions. If no aggregator is provided, the results will be empty for each bucket.. [optional]  # noqa: E501
            post_aggregations ([TelemetryDruidPostAggregator]): Post-aggregations are specifications of processing that should happen on aggregated values as they come out of Apache Druid. If you include a post aggregation as part of a query, make sure to include all aggregators the post-aggregator requires.. [optional]  # noqa: E501
            context (TelemetryDruidQueryContext): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.data_source = data_source
        self.intervals = intervals
        self.granularity = granularity
        self.dimension = dimension
        self.threshold = threshold
        self.metric = metric
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
