"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-4903
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.aaa_abstract_audit_record import AaaAbstractAuditRecord
    from intersight.model.aaa_audit_record import AaaAuditRecord
    from intersight.model.aaa_retention_config import AaaRetentionConfig
    from intersight.model.aaa_retention_policy import AaaRetentionPolicy
    from intersight.model.access_policy import AccessPolicy
    from intersight.model.adapter_config_policy import AdapterConfigPolicy
    from intersight.model.adapter_ext_eth_interface import AdapterExtEthInterface
    from intersight.model.adapter_host_eth_interface import AdapterHostEthInterface
    from intersight.model.adapter_host_fc_interface import AdapterHostFcInterface
    from intersight.model.adapter_host_iscsi_interface import AdapterHostIscsiInterface
    from intersight.model.adapter_unit import AdapterUnit
    from intersight.model.adapter_unit_expander import AdapterUnitExpander
    from intersight.model.appliance_app_status import ApplianceAppStatus
    from intersight.model.appliance_auto_rma_policy import ApplianceAutoRmaPolicy
    from intersight.model.appliance_backup import ApplianceBackup
    from intersight.model.appliance_backup_base import ApplianceBackupBase
    from intersight.model.appliance_backup_policy import ApplianceBackupPolicy
    from intersight.model.appliance_certificate_setting import ApplianceCertificateSetting
    from intersight.model.appliance_data_export_policy import ApplianceDataExportPolicy
    from intersight.model.appliance_device_certificate import ApplianceDeviceCertificate
    from intersight.model.appliance_device_claim import ApplianceDeviceClaim
    from intersight.model.appliance_device_upgrade_policy import ApplianceDeviceUpgradePolicy
    from intersight.model.appliance_diag_setting import ApplianceDiagSetting
    from intersight.model.appliance_external_syslog_setting import ApplianceExternalSyslogSetting
    from intersight.model.appliance_file_gateway import ApplianceFileGateway
    from intersight.model.appliance_file_system_status import ApplianceFileSystemStatus
    from intersight.model.appliance_group_status import ApplianceGroupStatus
    from intersight.model.appliance_image_bundle import ApplianceImageBundle
    from intersight.model.appliance_node_info import ApplianceNodeInfo
    from intersight.model.appliance_node_status import ApplianceNodeStatus
    from intersight.model.appliance_release_note import ApplianceReleaseNote
    from intersight.model.appliance_remote_file_import import ApplianceRemoteFileImport
    from intersight.model.appliance_restore import ApplianceRestore
    from intersight.model.appliance_setup_info import ApplianceSetupInfo
    from intersight.model.appliance_system_info import ApplianceSystemInfo
    from intersight.model.appliance_system_status import ApplianceSystemStatus
    from intersight.model.appliance_upgrade import ApplianceUpgrade
    from intersight.model.appliance_upgrade_policy import ApplianceUpgradePolicy
    from intersight.model.asset_cluster_member import AssetClusterMember
    from intersight.model.asset_deployment import AssetDeployment
    from intersight.model.asset_deployment_device import AssetDeploymentDevice
    from intersight.model.asset_device_claim import AssetDeviceClaim
    from intersight.model.asset_device_configuration import AssetDeviceConfiguration
    from intersight.model.asset_device_connection import AssetDeviceConnection
    from intersight.model.asset_device_connector_manager import AssetDeviceConnectorManager
    from intersight.model.asset_device_contract_information import AssetDeviceContractInformation
    from intersight.model.asset_device_registration import AssetDeviceRegistration
    from intersight.model.asset_subscription import AssetSubscription
    from intersight.model.asset_subscription_account import AssetSubscriptionAccount
    from intersight.model.asset_subscription_device_contract_information import AssetSubscriptionDeviceContractInformation
    from intersight.model.asset_target import AssetTarget
    from intersight.model.bios_boot_device import BiosBootDevice
    from intersight.model.bios_boot_mode import BiosBootMode
    from intersight.model.bios_policy import BiosPolicy
    from intersight.model.bios_system_boot_order import BiosSystemBootOrder
    from intersight.model.bios_token_settings import BiosTokenSettings
    from intersight.model.bios_unit import BiosUnit
    from intersight.model.bios_vf_select_memory_ras_configuration import BiosVfSelectMemoryRasConfiguration
    from intersight.model.boot_cdd_device import BootCddDevice
    from intersight.model.boot_configured_device import BootConfiguredDevice
    from intersight.model.boot_device_boot_mode import BootDeviceBootMode
    from intersight.model.boot_device_boot_security import BootDeviceBootSecurity
    from intersight.model.boot_hdd_device import BootHddDevice
    from intersight.model.boot_iscsi_device import BootIscsiDevice
    from intersight.model.boot_nvme_device import BootNvmeDevice
    from intersight.model.boot_pch_storage_device import BootPchStorageDevice
    from intersight.model.boot_precision_policy import BootPrecisionPolicy
    from intersight.model.boot_pxe_device import BootPxeDevice
    from intersight.model.boot_san_device import BootSanDevice
    from intersight.model.boot_sd_device import BootSdDevice
    from intersight.model.boot_uefi_shell_device import BootUefiShellDevice
    from intersight.model.boot_usb_device import BootUsbDevice
    from intersight.model.boot_vmedia_device import BootVmediaDevice
    from intersight.model.bulk_export import BulkExport
    from intersight.model.bulk_exported_item import BulkExportedItem
    from intersight.model.bulk_mo_cloner import BulkMoCloner
    from intersight.model.bulk_mo_merger import BulkMoMerger
    from intersight.model.bulk_request import BulkRequest
    from intersight.model.bulk_sub_request_obj import BulkSubRequestObj
    from intersight.model.capability_adapter_unit_descriptor import CapabilityAdapterUnitDescriptor
    from intersight.model.capability_capability import CapabilityCapability
    from intersight.model.capability_catalog import CapabilityCatalog
    from intersight.model.capability_chassis_descriptor import CapabilityChassisDescriptor
    from intersight.model.capability_chassis_manufacturing_def import CapabilityChassisManufacturingDef
    from intersight.model.capability_cimc_firmware_descriptor import CapabilityCimcFirmwareDescriptor
    from intersight.model.capability_endpoint_descriptor import CapabilityEndpointDescriptor
    from intersight.model.capability_equipment_physical_def import CapabilityEquipmentPhysicalDef
    from intersight.model.capability_equipment_slot_array import CapabilityEquipmentSlotArray
    from intersight.model.capability_fan_module_descriptor import CapabilityFanModuleDescriptor
    from intersight.model.capability_fan_module_manufacturing_def import CapabilityFanModuleManufacturingDef
    from intersight.model.capability_hardware_descriptor import CapabilityHardwareDescriptor
    from intersight.model.capability_io_card_capability_def import CapabilityIoCardCapabilityDef
    from intersight.model.capability_io_card_descriptor import CapabilityIoCardDescriptor
    from intersight.model.capability_io_card_manufacturing_def import CapabilityIoCardManufacturingDef
    from intersight.model.capability_port_group_aggregation_def import CapabilityPortGroupAggregationDef
    from intersight.model.capability_psu_descriptor import CapabilityPsuDescriptor
    from intersight.model.capability_psu_manufacturing_def import CapabilityPsuManufacturingDef
    from intersight.model.capability_server_models_capability_def import CapabilityServerModelsCapabilityDef
    from intersight.model.capability_server_schema_descriptor import CapabilityServerSchemaDescriptor
    from intersight.model.capability_sioc_module_capability_def import CapabilitySiocModuleCapabilityDef
    from intersight.model.capability_sioc_module_descriptor import CapabilitySiocModuleDescriptor
    from intersight.model.capability_sioc_module_manufacturing_def import CapabilitySiocModuleManufacturingDef
    from intersight.model.capability_switch_capability import CapabilitySwitchCapability
    from intersight.model.capability_switch_capability_def import CapabilitySwitchCapabilityDef
    from intersight.model.capability_switch_descriptor import CapabilitySwitchDescriptor
    from intersight.model.capability_switch_manufacturing_def import CapabilitySwitchManufacturingDef
    from intersight.model.certificatemanagement_policy import CertificatemanagementPolicy
    from intersight.model.chassis_config_change_detail import ChassisConfigChangeDetail
    from intersight.model.chassis_config_import import ChassisConfigImport
    from intersight.model.chassis_config_result import ChassisConfigResult
    from intersight.model.chassis_config_result_entry import ChassisConfigResultEntry
    from intersight.model.chassis_iom_profile import ChassisIomProfile
    from intersight.model.chassis_profile import ChassisProfile
    from intersight.model.cloud_aws_billing_unit import CloudAwsBillingUnit
    from intersight.model.cloud_aws_key_pair import CloudAwsKeyPair
    from intersight.model.cloud_aws_network_interface import CloudAwsNetworkInterface
    from intersight.model.cloud_aws_organizational_unit import CloudAwsOrganizationalUnit
    from intersight.model.cloud_aws_security_group import CloudAwsSecurityGroup
    from intersight.model.cloud_aws_subnet import CloudAwsSubnet
    from intersight.model.cloud_aws_virtual_machine import CloudAwsVirtualMachine
    from intersight.model.cloud_aws_volume import CloudAwsVolume
    from intersight.model.cloud_aws_vpc import CloudAwsVpc
    from intersight.model.cloud_base_billing_unit import CloudBaseBillingUnit
    from intersight.model.cloud_base_entity import CloudBaseEntity
    from intersight.model.cloud_base_network import CloudBaseNetwork
    from intersight.model.cloud_base_network_interface import CloudBaseNetworkInterface
    from intersight.model.cloud_base_placement import CloudBasePlacement
    from intersight.model.cloud_base_sku import CloudBaseSku
    from intersight.model.cloud_base_virtual_machine import CloudBaseVirtualMachine
    from intersight.model.cloud_base_volume import CloudBaseVolume
    from intersight.model.cloud_collect_inventory import CloudCollectInventory
    from intersight.model.cloud_regions import CloudRegions
    from intersight.model.cloud_sku_container_type import CloudSkuContainerType
    from intersight.model.cloud_sku_database_type import CloudSkuDatabaseType
    from intersight.model.cloud_sku_instance_type import CloudSkuInstanceType
    from intersight.model.cloud_sku_network_type import CloudSkuNetworkType
    from intersight.model.cloud_sku_region_rate_cards import CloudSkuRegionRateCards
    from intersight.model.cloud_sku_volume_type import CloudSkuVolumeType
    from intersight.model.cloud_tfc_agentpool import CloudTfcAgentpool
    from intersight.model.cloud_tfc_organization import CloudTfcOrganization
    from intersight.model.cloud_tfc_workspace import CloudTfcWorkspace
    from intersight.model.comm_abstract_http_proxy_policy import CommAbstractHttpProxyPolicy
    from intersight.model.comm_http_proxy_policy import CommHttpProxyPolicy
    from intersight.model.compute_bios_post_policy import ComputeBiosPostPolicy
    from intersight.model.compute_blade import ComputeBlade
    from intersight.model.compute_blade_identity import ComputeBladeIdentity
    from intersight.model.compute_board import ComputeBoard
    from intersight.model.compute_mapping import ComputeMapping
    from intersight.model.compute_physical import ComputePhysical
    from intersight.model.compute_physical_summary import ComputePhysicalSummary
    from intersight.model.compute_rack_unit import ComputeRackUnit
    from intersight.model.compute_rack_unit_identity import ComputeRackUnitIdentity
    from intersight.model.compute_server_power_policy import ComputeServerPowerPolicy
    from intersight.model.compute_server_setting import ComputeServerSetting
    from intersight.model.compute_vmedia import ComputeVmedia
    from intersight.model.cond_alarm import CondAlarm
    from intersight.model.cond_alarm_aggregation import CondAlarmAggregation
    from intersight.model.cond_hcl_status import CondHclStatus
    from intersight.model.cond_hcl_status_detail import CondHclStatusDetail
    from intersight.model.cond_hcl_status_job import CondHclStatusJob
    from intersight.model.connector_download_status import ConnectorDownloadStatus
    from intersight.model.connector_scoped_inventory import ConnectorScopedInventory
    from intersight.model.connectorpack_connector_pack_upgrade import ConnectorpackConnectorPackUpgrade
    from intersight.model.connectorpack_upgrade_impact import ConnectorpackUpgradeImpact
    from intersight.model.convergedinfra_base_pod import ConvergedinfraBasePod
    from intersight.model.convergedinfra_health_check_definition import ConvergedinfraHealthCheckDefinition
    from intersight.model.convergedinfra_health_check_execution import ConvergedinfraHealthCheckExecution
    from intersight.model.convergedinfra_pod import ConvergedinfraPod
    from intersight.model.crd_custom_resource import CrdCustomResource
    from intersight.model.deviceconnector_policy import DeviceconnectorPolicy
    from intersight.model.display_names import DisplayNames
    from intersight.model.equipment_abstract_device import EquipmentAbstractDevice
    from intersight.model.equipment_base import EquipmentBase
    from intersight.model.equipment_base_sensor import EquipmentBaseSensor
    from intersight.model.equipment_chassis import EquipmentChassis
    from intersight.model.equipment_chassis_identity import EquipmentChassisIdentity
    from intersight.model.equipment_chassis_operation import EquipmentChassisOperation
    from intersight.model.equipment_device_summary import EquipmentDeviceSummary
    from intersight.model.equipment_expander_module import EquipmentExpanderModule
    from intersight.model.equipment_fan import EquipmentFan
    from intersight.model.equipment_fan_control import EquipmentFanControl
    from intersight.model.equipment_fan_module import EquipmentFanModule
    from intersight.model.equipment_fex import EquipmentFex
    from intersight.model.equipment_fex_identity import EquipmentFexIdentity
    from intersight.model.equipment_fex_operation import EquipmentFexOperation
    from intersight.model.equipment_fru import EquipmentFru
    from intersight.model.equipment_identity import EquipmentIdentity
    from intersight.model.equipment_identity_summary import EquipmentIdentitySummary
    from intersight.model.equipment_io_card import EquipmentIoCard
    from intersight.model.equipment_io_card_base import EquipmentIoCardBase
    from intersight.model.equipment_io_card_operation import EquipmentIoCardOperation
    from intersight.model.equipment_io_expander import EquipmentIoExpander
    from intersight.model.equipment_locator_led import EquipmentLocatorLed
    from intersight.model.equipment_physical_identity import EquipmentPhysicalIdentity
    from intersight.model.equipment_psu import EquipmentPsu
    from intersight.model.equipment_psu_control import EquipmentPsuControl
    from intersight.model.equipment_rack_enclosure import EquipmentRackEnclosure
    from intersight.model.equipment_rack_enclosure_slot import EquipmentRackEnclosureSlot
    from intersight.model.equipment_shared_io_module import EquipmentSharedIoModule
    from intersight.model.equipment_slot import EquipmentSlot
    from intersight.model.equipment_switch_card import EquipmentSwitchCard
    from intersight.model.equipment_system_io_controller import EquipmentSystemIoController
    from intersight.model.equipment_tpm import EquipmentTpm
    from intersight.model.equipment_transceiver import EquipmentTransceiver
    from intersight.model.ether_host_port import EtherHostPort
    from intersight.model.ether_network_port import EtherNetworkPort
    from intersight.model.ether_physical_port import EtherPhysicalPort
    from intersight.model.ether_physical_port_base import EtherPhysicalPortBase
    from intersight.model.ether_port_channel import EtherPortChannel
    from intersight.model.externalsite_authorization import ExternalsiteAuthorization
    from intersight.model.fabric_appliance_pc_role import FabricAppliancePcRole
    from intersight.model.fabric_appliance_role import FabricApplianceRole
    from intersight.model.fabric_config_change_detail import FabricConfigChangeDetail
    from intersight.model.fabric_config_result import FabricConfigResult
    from intersight.model.fabric_config_result_entry import FabricConfigResultEntry
    from intersight.model.fabric_element_identity import FabricElementIdentity
    from intersight.model.fabric_estimate_impact import FabricEstimateImpact
    from intersight.model.fabric_eth_network_control_policy import FabricEthNetworkControlPolicy
    from intersight.model.fabric_eth_network_group_policy import FabricEthNetworkGroupPolicy
    from intersight.model.fabric_eth_network_policy import FabricEthNetworkPolicy
    from intersight.model.fabric_fc_network_policy import FabricFcNetworkPolicy
    from intersight.model.fabric_fc_uplink_pc_role import FabricFcUplinkPcRole
    from intersight.model.fabric_fc_uplink_role import FabricFcUplinkRole
    from intersight.model.fabric_fcoe_uplink_pc_role import FabricFcoeUplinkPcRole
    from intersight.model.fabric_fcoe_uplink_role import FabricFcoeUplinkRole
    from intersight.model.fabric_flow_control_policy import FabricFlowControlPolicy
    from intersight.model.fabric_link_aggregation_policy import FabricLinkAggregationPolicy
    from intersight.model.fabric_link_control_policy import FabricLinkControlPolicy
    from intersight.model.fabric_multicast_policy import FabricMulticastPolicy
    from intersight.model.fabric_pc_member import FabricPcMember
    from intersight.model.fabric_pc_operation import FabricPcOperation
    from intersight.model.fabric_port_base import FabricPortBase
    from intersight.model.fabric_port_channel_role import FabricPortChannelRole
    from intersight.model.fabric_port_mode import FabricPortMode
    from intersight.model.fabric_port_operation import FabricPortOperation
    from intersight.model.fabric_port_policy import FabricPortPolicy
    from intersight.model.fabric_port_role import FabricPortRole
    from intersight.model.fabric_server_role import FabricServerRole
    from intersight.model.fabric_switch_cluster_profile import FabricSwitchClusterProfile
    from intersight.model.fabric_switch_control_policy import FabricSwitchControlPolicy
    from intersight.model.fabric_switch_profile import FabricSwitchProfile
    from intersight.model.fabric_system_qos_policy import FabricSystemQosPolicy
    from intersight.model.fabric_transceiver_role import FabricTransceiverRole
    from intersight.model.fabric_uplink_pc_role import FabricUplinkPcRole
    from intersight.model.fabric_uplink_role import FabricUplinkRole
    from intersight.model.fabric_vlan import FabricVlan
    from intersight.model.fabric_vsan import FabricVsan
    from intersight.model.fault_instance import FaultInstance
    from intersight.model.fc_physical_port import FcPhysicalPort
    from intersight.model.fc_port_channel import FcPortChannel
    from intersight.model.fcpool_fc_block import FcpoolFcBlock
    from intersight.model.fcpool_lease import FcpoolLease
    from intersight.model.fcpool_pool import FcpoolPool
    from intersight.model.fcpool_pool_member import FcpoolPoolMember
    from intersight.model.fcpool_universe import FcpoolUniverse
    from intersight.model.feedback_feedback_post import FeedbackFeedbackPost
    from intersight.model.firmware_base_distributable import FirmwareBaseDistributable
    from intersight.model.firmware_bios_descriptor import FirmwareBiosDescriptor
    from intersight.model.firmware_board_controller_descriptor import FirmwareBoardControllerDescriptor
    from intersight.model.firmware_chassis_upgrade import FirmwareChassisUpgrade
    from intersight.model.firmware_cimc_descriptor import FirmwareCimcDescriptor
    from intersight.model.firmware_component_descriptor import FirmwareComponentDescriptor
    from intersight.model.firmware_dimm_descriptor import FirmwareDimmDescriptor
    from intersight.model.firmware_distributable import FirmwareDistributable
    from intersight.model.firmware_distributable_meta import FirmwareDistributableMeta
    from intersight.model.firmware_drive_descriptor import FirmwareDriveDescriptor
    from intersight.model.firmware_driver_distributable import FirmwareDriverDistributable
    from intersight.model.firmware_eula import FirmwareEula
    from intersight.model.firmware_firmware_summary import FirmwareFirmwareSummary
    from intersight.model.firmware_gpu_descriptor import FirmwareGpuDescriptor
    from intersight.model.firmware_hba_descriptor import FirmwareHbaDescriptor
    from intersight.model.firmware_iom_descriptor import FirmwareIomDescriptor
    from intersight.model.firmware_mswitch_descriptor import FirmwareMswitchDescriptor
    from intersight.model.firmware_nxos_descriptor import FirmwareNxosDescriptor
    from intersight.model.firmware_pcie_descriptor import FirmwarePcieDescriptor
    from intersight.model.firmware_psu_descriptor import FirmwarePsuDescriptor
    from intersight.model.firmware_running_firmware import FirmwareRunningFirmware
    from intersight.model.firmware_sas_expander_descriptor import FirmwareSasExpanderDescriptor
    from intersight.model.firmware_server_configuration_utility_distributable import FirmwareServerConfigurationUtilityDistributable
    from intersight.model.firmware_storage_controller_descriptor import FirmwareStorageControllerDescriptor
    from intersight.model.firmware_switch_upgrade import FirmwareSwitchUpgrade
    from intersight.model.firmware_unsupported_version_upgrade import FirmwareUnsupportedVersionUpgrade
    from intersight.model.firmware_upgrade import FirmwareUpgrade
    from intersight.model.firmware_upgrade_base import FirmwareUpgradeBase
    from intersight.model.firmware_upgrade_impact import FirmwareUpgradeImpact
    from intersight.model.firmware_upgrade_impact_base import FirmwareUpgradeImpactBase
    from intersight.model.firmware_upgrade_impact_status import FirmwareUpgradeImpactStatus
    from intersight.model.firmware_upgrade_status import FirmwareUpgradeStatus
    from intersight.model.forecast_catalog import ForecastCatalog
    from intersight.model.forecast_definition import ForecastDefinition
    from intersight.model.forecast_instance import ForecastInstance
    from intersight.model.graphics_card import GraphicsCard
    from intersight.model.graphics_controller import GraphicsController
    from intersight.model.hcl_compatibility_status import HclCompatibilityStatus
    from intersight.model.hcl_driver_image import HclDriverImage
    from intersight.model.hcl_exempted_catalog import HclExemptedCatalog
    from intersight.model.hcl_hyperflex_software_compatibility_info import HclHyperflexSoftwareCompatibilityInfo
    from intersight.model.hcl_operating_system import HclOperatingSystem
    from intersight.model.hcl_operating_system_vendor import HclOperatingSystemVendor
    from intersight.model.hcl_supported_driver_name import HclSupportedDriverName
    from intersight.model.hyperflex_alarm import HyperflexAlarm
    from intersight.model.hyperflex_app_catalog import HyperflexAppCatalog
    from intersight.model.hyperflex_auto_support_policy import HyperflexAutoSupportPolicy
    from intersight.model.hyperflex_backup_cluster import HyperflexBackupCluster
    from intersight.model.hyperflex_base_cluster import HyperflexBaseCluster
    from intersight.model.hyperflex_capability_info import HyperflexCapabilityInfo
    from intersight.model.hyperflex_cisco_hypervisor_manager import HyperflexCiscoHypervisorManager
    from intersight.model.hyperflex_cluster import HyperflexCluster
    from intersight.model.hyperflex_cluster_backup_policy import HyperflexClusterBackupPolicy
    from intersight.model.hyperflex_cluster_backup_policy_deployment import HyperflexClusterBackupPolicyDeployment
    from intersight.model.hyperflex_cluster_backup_policy_inventory import HyperflexClusterBackupPolicyInventory
    from intersight.model.hyperflex_cluster_health_check_execution_snapshot import HyperflexClusterHealthCheckExecutionSnapshot
    from intersight.model.hyperflex_cluster_network_policy import HyperflexClusterNetworkPolicy
    from intersight.model.hyperflex_cluster_profile import HyperflexClusterProfile
    from intersight.model.hyperflex_cluster_replication_network_policy import HyperflexClusterReplicationNetworkPolicy
    from intersight.model.hyperflex_cluster_replication_network_policy_deployment import HyperflexClusterReplicationNetworkPolicyDeployment
    from intersight.model.hyperflex_cluster_storage_policy import HyperflexClusterStoragePolicy
    from intersight.model.hyperflex_config_result import HyperflexConfigResult
    from intersight.model.hyperflex_config_result_entry import HyperflexConfigResultEntry
    from intersight.model.hyperflex_data_protection_peer import HyperflexDataProtectionPeer
    from intersight.model.hyperflex_datastore_statistic import HyperflexDatastoreStatistic
    from intersight.model.hyperflex_device_package_download_state import HyperflexDevicePackageDownloadState
    from intersight.model.hyperflex_drive import HyperflexDrive
    from intersight.model.hyperflex_ext_fc_storage_policy import HyperflexExtFcStoragePolicy
    from intersight.model.hyperflex_ext_iscsi_storage_policy import HyperflexExtIscsiStoragePolicy
    from intersight.model.hyperflex_feature_limit_external import HyperflexFeatureLimitExternal
    from intersight.model.hyperflex_feature_limit_internal import HyperflexFeatureLimitInternal
    from intersight.model.hyperflex_health import HyperflexHealth
    from intersight.model.hyperflex_health_check_definition import HyperflexHealthCheckDefinition
    from intersight.model.hyperflex_health_check_execution import HyperflexHealthCheckExecution
    from intersight.model.hyperflex_health_check_execution_snapshot import HyperflexHealthCheckExecutionSnapshot
    from intersight.model.hyperflex_health_check_package_checksum import HyperflexHealthCheckPackageChecksum
    from intersight.model.hyperflex_hxap_cluster import HyperflexHxapCluster
    from intersight.model.hyperflex_hxap_datacenter import HyperflexHxapDatacenter
    from intersight.model.hyperflex_hxap_dv_uplink import HyperflexHxapDvUplink
    from intersight.model.hyperflex_hxap_dvswitch import HyperflexHxapDvswitch
    from intersight.model.hyperflex_hxap_host import HyperflexHxapHost
    from intersight.model.hyperflex_hxap_host_interface import HyperflexHxapHostInterface
    from intersight.model.hyperflex_hxap_host_vswitch import HyperflexHxapHostVswitch
    from intersight.model.hyperflex_hxap_network import HyperflexHxapNetwork
    from intersight.model.hyperflex_hxap_virtual_disk import HyperflexHxapVirtualDisk
    from intersight.model.hyperflex_hxap_virtual_machine import HyperflexHxapVirtualMachine
    from intersight.model.hyperflex_hxap_virtual_machine_network_interface import HyperflexHxapVirtualMachineNetworkInterface
    from intersight.model.hyperflex_hxdp_version import HyperflexHxdpVersion
    from intersight.model.hyperflex_license import HyperflexLicense
    from intersight.model.hyperflex_local_credential_policy import HyperflexLocalCredentialPolicy
    from intersight.model.hyperflex_node import HyperflexNode
    from intersight.model.hyperflex_node_config_policy import HyperflexNodeConfigPolicy
    from intersight.model.hyperflex_node_profile import HyperflexNodeProfile
    from intersight.model.hyperflex_protected_cluster import HyperflexProtectedCluster
    from intersight.model.hyperflex_proxy_setting_policy import HyperflexProxySettingPolicy
    from intersight.model.hyperflex_server_firmware_version import HyperflexServerFirmwareVersion
    from intersight.model.hyperflex_server_firmware_version_entry import HyperflexServerFirmwareVersionEntry
    from intersight.model.hyperflex_server_model import HyperflexServerModel
    from intersight.model.hyperflex_service_auth_token import HyperflexServiceAuthToken
    from intersight.model.hyperflex_software_distribution_component import HyperflexSoftwareDistributionComponent
    from intersight.model.hyperflex_software_distribution_entry import HyperflexSoftwareDistributionEntry
    from intersight.model.hyperflex_software_distribution_version import HyperflexSoftwareDistributionVersion
    from intersight.model.hyperflex_software_version_policy import HyperflexSoftwareVersionPolicy
    from intersight.model.hyperflex_storage_container import HyperflexStorageContainer
    from intersight.model.hyperflex_sys_config_policy import HyperflexSysConfigPolicy
    from intersight.model.hyperflex_ucsm_config_policy import HyperflexUcsmConfigPolicy
    from intersight.model.hyperflex_vcenter_config_policy import HyperflexVcenterConfigPolicy
    from intersight.model.hyperflex_vm_backup_info import HyperflexVmBackupInfo
    from intersight.model.hyperflex_vm_import_operation import HyperflexVmImportOperation
    from intersight.model.hyperflex_vm_restore_operation import HyperflexVmRestoreOperation
    from intersight.model.hyperflex_vm_snapshot_info import HyperflexVmSnapshotInfo
    from intersight.model.hyperflex_volume import HyperflexVolume
    from intersight.model.hyperflex_witness_configuration import HyperflexWitnessConfiguration
    from intersight.model.iaas_connector_pack import IaasConnectorPack
    from intersight.model.iaas_device_status import IaasDeviceStatus
    from intersight.model.iaas_diagnostic_messages import IaasDiagnosticMessages
    from intersight.model.iaas_license_info import IaasLicenseInfo
    from intersight.model.iaas_most_run_tasks import IaasMostRunTasks
    from intersight.model.iaas_service_request import IaasServiceRequest
    from intersight.model.iaas_ucsd_info import IaasUcsdInfo
    from intersight.model.iaas_ucsd_managed_infra import IaasUcsdManagedInfra
    from intersight.model.iaas_ucsd_messages import IaasUcsdMessages
    from intersight.model.iam_account import IamAccount
    from intersight.model.iam_account_experience import IamAccountExperience
    from intersight.model.iam_api_key import IamApiKey
    from intersight.model.iam_app_registration import IamAppRegistration
    from intersight.model.iam_banner_message import IamBannerMessage
    from intersight.model.iam_certificate import IamCertificate
    from intersight.model.iam_certificate_request import IamCertificateRequest
    from intersight.model.iam_domain_group import IamDomainGroup
    from intersight.model.iam_end_point_privilege import IamEndPointPrivilege
    from intersight.model.iam_end_point_role import IamEndPointRole
    from intersight.model.iam_end_point_user import IamEndPointUser
    from intersight.model.iam_end_point_user_policy import IamEndPointUserPolicy
    from intersight.model.iam_end_point_user_role import IamEndPointUserRole
    from intersight.model.iam_idp import IamIdp
    from intersight.model.iam_idp_reference import IamIdpReference
    from intersight.model.iam_ip_access_management import IamIpAccessManagement
    from intersight.model.iam_ip_address import IamIpAddress
    from intersight.model.iam_ldap_group import IamLdapGroup
    from intersight.model.iam_ldap_policy import IamLdapPolicy
    from intersight.model.iam_ldap_provider import IamLdapProvider
    from intersight.model.iam_local_user_password import IamLocalUserPassword
    from intersight.model.iam_local_user_password_policy import IamLocalUserPasswordPolicy
    from intersight.model.iam_o_auth_token import IamOAuthToken
    from intersight.model.iam_permission import IamPermission
    from intersight.model.iam_private_key_spec import IamPrivateKeySpec
    from intersight.model.iam_privilege import IamPrivilege
    from intersight.model.iam_privilege_set import IamPrivilegeSet
    from intersight.model.iam_qualifier import IamQualifier
    from intersight.model.iam_resource_limits import IamResourceLimits
    from intersight.model.iam_resource_permission import IamResourcePermission
    from intersight.model.iam_resource_roles import IamResourceRoles
    from intersight.model.iam_role import IamRole
    from intersight.model.iam_security_holder import IamSecurityHolder
    from intersight.model.iam_service_provider import IamServiceProvider
    from intersight.model.iam_session import IamSession
    from intersight.model.iam_session_limits import IamSessionLimits
    from intersight.model.iam_system import IamSystem
    from intersight.model.iam_trust_point import IamTrustPoint
    from intersight.model.iam_user import IamUser
    from intersight.model.iam_user_group import IamUserGroup
    from intersight.model.iam_user_preference import IamUserPreference
    from intersight.model.inventory_base import InventoryBase
    from intersight.model.inventory_device_info import InventoryDeviceInfo
    from intersight.model.inventory_dn_mo_binding import InventoryDnMoBinding
    from intersight.model.inventory_generic_inventory import InventoryGenericInventory
    from intersight.model.inventory_generic_inventory_holder import InventoryGenericInventoryHolder
    from intersight.model.inventory_request import InventoryRequest
    from intersight.model.ipmioverlan_policy import IpmioverlanPolicy
    from intersight.model.ippool_block_lease import IppoolBlockLease
    from intersight.model.ippool_ip_lease import IppoolIpLease
    from intersight.model.ippool_pool import IppoolPool
    from intersight.model.ippool_pool_member import IppoolPoolMember
    from intersight.model.ippool_shadow_block import IppoolShadowBlock
    from intersight.model.ippool_shadow_pool import IppoolShadowPool
    from intersight.model.ippool_universe import IppoolUniverse
    from intersight.model.iqnpool_block import IqnpoolBlock
    from intersight.model.iqnpool_lease import IqnpoolLease
    from intersight.model.iqnpool_pool import IqnpoolPool
    from intersight.model.iqnpool_pool_member import IqnpoolPoolMember
    from intersight.model.iqnpool_universe import IqnpoolUniverse
    from intersight.model.iwotenant_tenant_status import IwotenantTenantStatus
    from intersight.model.kubernetes_abstract_daemon_set import KubernetesAbstractDaemonSet
    from intersight.model.kubernetes_abstract_deployment import KubernetesAbstractDeployment
    from intersight.model.kubernetes_abstract_ingress import KubernetesAbstractIngress
    from intersight.model.kubernetes_abstract_node import KubernetesAbstractNode
    from intersight.model.kubernetes_abstract_pod import KubernetesAbstractPod
    from intersight.model.kubernetes_abstract_service import KubernetesAbstractService
    from intersight.model.kubernetes_abstract_stateful_set import KubernetesAbstractStatefulSet
    from intersight.model.kubernetes_aci_cni_apic import KubernetesAciCniApic
    from intersight.model.kubernetes_aci_cni_profile import KubernetesAciCniProfile
    from intersight.model.kubernetes_aci_cni_tenant_cluster_allocation import KubernetesAciCniTenantClusterAllocation
    from intersight.model.kubernetes_addon_definition import KubernetesAddonDefinition
    from intersight.model.kubernetes_addon_policy import KubernetesAddonPolicy
    from intersight.model.kubernetes_addon_repository import KubernetesAddonRepository
    from intersight.model.kubernetes_baremetal_node_profile import KubernetesBaremetalNodeProfile
    from intersight.model.kubernetes_base_infrastructure_provider import KubernetesBaseInfrastructureProvider
    from intersight.model.kubernetes_catalog import KubernetesCatalog
    from intersight.model.kubernetes_cluster import KubernetesCluster
    from intersight.model.kubernetes_cluster_addon_profile import KubernetesClusterAddonProfile
    from intersight.model.kubernetes_cluster_profile import KubernetesClusterProfile
    from intersight.model.kubernetes_config_result import KubernetesConfigResult
    from intersight.model.kubernetes_config_result_entry import KubernetesConfigResultEntry
    from intersight.model.kubernetes_container_runtime_policy import KubernetesContainerRuntimePolicy
    from intersight.model.kubernetes_daemon_set import KubernetesDaemonSet
    from intersight.model.kubernetes_deployment import KubernetesDeployment
    from intersight.model.kubernetes_ingress import KubernetesIngress
    from intersight.model.kubernetes_kubernetes_resource import KubernetesKubernetesResource
    from intersight.model.kubernetes_network_policy import KubernetesNetworkPolicy
    from intersight.model.kubernetes_node import KubernetesNode
    from intersight.model.kubernetes_node_group_profile import KubernetesNodeGroupProfile
    from intersight.model.kubernetes_node_profile import KubernetesNodeProfile
    from intersight.model.kubernetes_pod import KubernetesPod
    from intersight.model.kubernetes_service import KubernetesService
    from intersight.model.kubernetes_stateful_set import KubernetesStatefulSet
    from intersight.model.kubernetes_sys_config_policy import KubernetesSysConfigPolicy
    from intersight.model.kubernetes_trusted_registries_policy import KubernetesTrustedRegistriesPolicy
    from intersight.model.kubernetes_version import KubernetesVersion
    from intersight.model.kubernetes_version_policy import KubernetesVersionPolicy
    from intersight.model.kubernetes_virtual_machine_infra_config_policy import KubernetesVirtualMachineInfraConfigPolicy
    from intersight.model.kubernetes_virtual_machine_infrastructure_provider import KubernetesVirtualMachineInfrastructureProvider
    from intersight.model.kubernetes_virtual_machine_instance_type import KubernetesVirtualMachineInstanceType
    from intersight.model.kubernetes_virtual_machine_node_profile import KubernetesVirtualMachineNodeProfile
    from intersight.model.kvm_policy import KvmPolicy
    from intersight.model.kvm_session import KvmSession
    from intersight.model.kvm_tunnel import KvmTunnel
    from intersight.model.license_account_license_data import LicenseAccountLicenseData
    from intersight.model.license_customer_op import LicenseCustomerOp
    from intersight.model.license_iwo_customer_op import LicenseIwoCustomerOp
    from intersight.model.license_iwo_license_count import LicenseIwoLicenseCount
    from intersight.model.license_license_info import LicenseLicenseInfo
    from intersight.model.license_license_reservation_op import LicenseLicenseReservationOp
    from intersight.model.license_smartlicense_token import LicenseSmartlicenseToken
    from intersight.model.ls_service_profile import LsServiceProfile
    from intersight.model.macpool_id_block import MacpoolIdBlock
    from intersight.model.macpool_lease import MacpoolLease
    from intersight.model.macpool_pool import MacpoolPool
    from intersight.model.macpool_pool_member import MacpoolPoolMember
    from intersight.model.macpool_universe import MacpoolUniverse
    from intersight.model.management_controller import ManagementController
    from intersight.model.management_entity import ManagementEntity
    from intersight.model.management_interface import ManagementInterface
    from intersight.model.memory_abstract_unit import MemoryAbstractUnit
    from intersight.model.memory_array import MemoryArray
    from intersight.model.memory_persistent_memory_config_result import MemoryPersistentMemoryConfigResult
    from intersight.model.memory_persistent_memory_configuration import MemoryPersistentMemoryConfiguration
    from intersight.model.memory_persistent_memory_namespace import MemoryPersistentMemoryNamespace
    from intersight.model.memory_persistent_memory_namespace_config_result import MemoryPersistentMemoryNamespaceConfigResult
    from intersight.model.memory_persistent_memory_policy import MemoryPersistentMemoryPolicy
    from intersight.model.memory_persistent_memory_region import MemoryPersistentMemoryRegion
    from intersight.model.memory_persistent_memory_unit import MemoryPersistentMemoryUnit
    from intersight.model.memory_unit import MemoryUnit
    from intersight.model.meta_definition import MetaDefinition
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.mo_tag import MoTag
    from intersight.model.mo_version_context import MoVersionContext
    from intersight.model.network_element import NetworkElement
    from intersight.model.network_element_summary import NetworkElementSummary
    from intersight.model.network_fc_zone_info import NetworkFcZoneInfo
    from intersight.model.network_vlan_port_info import NetworkVlanPortInfo
    from intersight.model.networkconfig_policy import NetworkconfigPolicy
    from intersight.model.niaapi_apic_cco_post import NiaapiApicCcoPost
    from intersight.model.niaapi_apic_field_notice import NiaapiApicFieldNotice
    from intersight.model.niaapi_apic_hweol import NiaapiApicHweol
    from intersight.model.niaapi_apic_latest_maintained_release import NiaapiApicLatestMaintainedRelease
    from intersight.model.niaapi_apic_release_recommend import NiaapiApicReleaseRecommend
    from intersight.model.niaapi_apic_sweol import NiaapiApicSweol
    from intersight.model.niaapi_dcnm_cco_post import NiaapiDcnmCcoPost
    from intersight.model.niaapi_dcnm_field_notice import NiaapiDcnmFieldNotice
    from intersight.model.niaapi_dcnm_hweol import NiaapiDcnmHweol
    from intersight.model.niaapi_dcnm_latest_maintained_release import NiaapiDcnmLatestMaintainedRelease
    from intersight.model.niaapi_dcnm_release_recommend import NiaapiDcnmReleaseRecommend
    from intersight.model.niaapi_dcnm_sweol import NiaapiDcnmSweol
    from intersight.model.niaapi_field_notice import NiaapiFieldNotice
    from intersight.model.niaapi_file_downloader import NiaapiFileDownloader
    from intersight.model.niaapi_hardware_eol import NiaapiHardwareEol
    from intersight.model.niaapi_maintained_release import NiaapiMaintainedRelease
    from intersight.model.niaapi_new_release_post import NiaapiNewReleasePost
    from intersight.model.niaapi_nia_metadata import NiaapiNiaMetadata
    from intersight.model.niaapi_nib_file_downloader import NiaapiNibFileDownloader
    from intersight.model.niaapi_nib_metadata import NiaapiNibMetadata
    from intersight.model.niaapi_release_recommend import NiaapiReleaseRecommend
    from intersight.model.niaapi_software_eol import NiaapiSoftwareEol
    from intersight.model.niaapi_version_regex import NiaapiVersionRegex
    from intersight.model.niatelemetry_aaa_ldap_provider_details import NiatelemetryAaaLdapProviderDetails
    from intersight.model.niatelemetry_aaa_radius_provider_details import NiatelemetryAaaRadiusProviderDetails
    from intersight.model.niatelemetry_aaa_tacacs_provider_details import NiatelemetryAaaTacacsProviderDetails
    from intersight.model.niatelemetry_apic_app_plugin_details import NiatelemetryApicAppPluginDetails
    from intersight.model.niatelemetry_apic_core_file_details import NiatelemetryApicCoreFileDetails
    from intersight.model.niatelemetry_apic_dbgexp_rs_export_dest import NiatelemetryApicDbgexpRsExportDest
    from intersight.model.niatelemetry_apic_dbgexp_rs_ts_scheduler import NiatelemetryApicDbgexpRsTsScheduler
    from intersight.model.niatelemetry_apic_fan_details import NiatelemetryApicFanDetails
    from intersight.model.niatelemetry_apic_fex_details import NiatelemetryApicFexDetails
    from intersight.model.niatelemetry_apic_flash_details import NiatelemetryApicFlashDetails
    from intersight.model.niatelemetry_apic_ntp_auth import NiatelemetryApicNtpAuth
    from intersight.model.niatelemetry_apic_psu_details import NiatelemetryApicPsuDetails
    from intersight.model.niatelemetry_apic_realm_details import NiatelemetryApicRealmDetails
    from intersight.model.niatelemetry_apic_snmp_client_grp_details import NiatelemetryApicSnmpClientGrpDetails
    from intersight.model.niatelemetry_apic_snmp_community_access_details import NiatelemetryApicSnmpCommunityAccessDetails
    from intersight.model.niatelemetry_apic_snmp_community_details import NiatelemetryApicSnmpCommunityDetails
    from intersight.model.niatelemetry_apic_snmp_trap_details import NiatelemetryApicSnmpTrapDetails
    from intersight.model.niatelemetry_apic_snmp_trap_fwd_server_details import NiatelemetryApicSnmpTrapFwdServerDetails
    from intersight.model.niatelemetry_apic_snmp_version_three_details import NiatelemetryApicSnmpVersionThreeDetails
    from intersight.model.niatelemetry_apic_sys_log_grp import NiatelemetryApicSysLogGrp
    from intersight.model.niatelemetry_apic_sys_log_src import NiatelemetryApicSysLogSrc
    from intersight.model.niatelemetry_apic_transceiver_details import NiatelemetryApicTransceiverDetails
    from intersight.model.niatelemetry_apic_ui_page_counts import NiatelemetryApicUiPageCounts
    from intersight.model.niatelemetry_app_details import NiatelemetryAppDetails
    from intersight.model.niatelemetry_common_policies import NiatelemetryCommonPolicies
    from intersight.model.niatelemetry_dcnm_fan_details import NiatelemetryDcnmFanDetails
    from intersight.model.niatelemetry_dcnm_fex_details import NiatelemetryDcnmFexDetails
    from intersight.model.niatelemetry_dcnm_module_details import NiatelemetryDcnmModuleDetails
    from intersight.model.niatelemetry_dcnm_psu_details import NiatelemetryDcnmPsuDetails
    from intersight.model.niatelemetry_dcnm_transceiver_details import NiatelemetryDcnmTransceiverDetails
    from intersight.model.niatelemetry_epg import NiatelemetryEpg
    from intersight.model.niatelemetry_fabric_module_details import NiatelemetryFabricModuleDetails
    from intersight.model.niatelemetry_fabric_pod_profile import NiatelemetryFabricPodProfile
    from intersight.model.niatelemetry_fabric_pod_ss import NiatelemetryFabricPodSs
    from intersight.model.niatelemetry_fault import NiatelemetryFault
    from intersight.model.niatelemetry_https_acl_contract_details import NiatelemetryHttpsAclContractDetails
    from intersight.model.niatelemetry_https_acl_contract_filter_map import NiatelemetryHttpsAclContractFilterMap
    from intersight.model.niatelemetry_https_acl_epg_contract_map import NiatelemetryHttpsAclEpgContractMap
    from intersight.model.niatelemetry_https_acl_epg_details import NiatelemetryHttpsAclEpgDetails
    from intersight.model.niatelemetry_https_acl_filter_details import NiatelemetryHttpsAclFilterDetails
    from intersight.model.niatelemetry_lc import NiatelemetryLc
    from intersight.model.niatelemetry_mso_contract_details import NiatelemetryMsoContractDetails
    from intersight.model.niatelemetry_mso_epg_details import NiatelemetryMsoEpgDetails
    from intersight.model.niatelemetry_mso_schema_details import NiatelemetryMsoSchemaDetails
    from intersight.model.niatelemetry_mso_site_details import NiatelemetryMsoSiteDetails
    from intersight.model.niatelemetry_mso_tenant_details import NiatelemetryMsoTenantDetails
    from intersight.model.niatelemetry_nexus_dashboard_controller_details import NiatelemetryNexusDashboardControllerDetails
    from intersight.model.niatelemetry_nexus_dashboard_details import NiatelemetryNexusDashboardDetails
    from intersight.model.niatelemetry_nexus_dashboard_memory_details import NiatelemetryNexusDashboardMemoryDetails
    from intersight.model.niatelemetry_nexus_dashboards import NiatelemetryNexusDashboards
    from intersight.model.niatelemetry_nia_feature_usage import NiatelemetryNiaFeatureUsage
    from intersight.model.niatelemetry_nia_inventory import NiatelemetryNiaInventory
    from intersight.model.niatelemetry_nia_inventory_dcnm import NiatelemetryNiaInventoryDcnm
    from intersight.model.niatelemetry_nia_inventory_fabric import NiatelemetryNiaInventoryFabric
    from intersight.model.niatelemetry_nia_license_state import NiatelemetryNiaLicenseState
    from intersight.model.niatelemetry_password_strength_check import NiatelemetryPasswordStrengthCheck
    from intersight.model.niatelemetry_pod_comm_policies import NiatelemetryPodCommPolicies
    from intersight.model.niatelemetry_pod_snmp_policies import NiatelemetryPodSnmpPolicies
    from intersight.model.niatelemetry_pod_time_server_policies import NiatelemetryPodTimeServerPolicies
    from intersight.model.niatelemetry_site_inventory import NiatelemetrySiteInventory
    from intersight.model.niatelemetry_snmp_src import NiatelemetrySnmpSrc
    from intersight.model.niatelemetry_ssh_version_two import NiatelemetrySshVersionTwo
    from intersight.model.niatelemetry_supervisor_module_details import NiatelemetrySupervisorModuleDetails
    from intersight.model.niatelemetry_syslog_remote_dest import NiatelemetrySyslogRemoteDest
    from intersight.model.niatelemetry_syslog_sys_msg import NiatelemetrySyslogSysMsg
    from intersight.model.niatelemetry_syslog_sys_msg_fac_filter import NiatelemetrySyslogSysMsgFacFilter
    from intersight.model.niatelemetry_system_controller_details import NiatelemetrySystemControllerDetails
    from intersight.model.niatelemetry_tenant import NiatelemetryTenant
    from intersight.model.notification_account_subscription import NotificationAccountSubscription
    from intersight.model.notification_subscription import NotificationSubscription
    from intersight.model.ntp_policy import NtpPolicy
    from intersight.model.oprs_deployment import OprsDeployment
    from intersight.model.oprs_sync_target_list_message import OprsSyncTargetListMessage
    from intersight.model.organization_organization import OrganizationOrganization
    from intersight.model.os_base_install_config import OsBaseInstallConfig
    from intersight.model.os_bulk_install_info import OsBulkInstallInfo
    from intersight.model.os_catalog import OsCatalog
    from intersight.model.os_configuration_file import OsConfigurationFile
    from intersight.model.os_distribution import OsDistribution
    from intersight.model.os_install import OsInstall
    from intersight.model.os_os_support import OsOsSupport
    from intersight.model.os_supported_version import OsSupportedVersion
    from intersight.model.os_template_file import OsTemplateFile
    from intersight.model.os_valid_install_target import OsValidInstallTarget
    from intersight.model.pci_coprocessor_card import PciCoprocessorCard
    from intersight.model.pci_device import PciDevice
    from intersight.model.pci_link import PciLink
    from intersight.model.pci_switch import PciSwitch
    from intersight.model.policy_abstract_config_change_detail import PolicyAbstractConfigChangeDetail
    from intersight.model.policy_abstract_config_profile import PolicyAbstractConfigProfile
    from intersight.model.policy_abstract_config_result import PolicyAbstractConfigResult
    from intersight.model.policy_abstract_config_result_entry import PolicyAbstractConfigResultEntry
    from intersight.model.policy_abstract_policy import PolicyAbstractPolicy
    from intersight.model.policy_abstract_profile import PolicyAbstractProfile
    from intersight.model.policyinventory_abstract_device_info import PolicyinventoryAbstractDeviceInfo
    from intersight.model.pool_abstract_block import PoolAbstractBlock
    from intersight.model.pool_abstract_block_lease import PoolAbstractBlockLease
    from intersight.model.pool_abstract_lease import PoolAbstractLease
    from intersight.model.pool_abstract_pool import PoolAbstractPool
    from intersight.model.pool_abstract_pool_member import PoolAbstractPoolMember
    from intersight.model.port_group import PortGroup
    from intersight.model.port_interface_base import PortInterfaceBase
    from intersight.model.port_mac_binding import PortMacBinding
    from intersight.model.port_physical import PortPhysical
    from intersight.model.port_sub_group import PortSubGroup
    from intersight.model.power_control_state import PowerControlState
    from intersight.model.power_policy import PowerPolicy
    from intersight.model.processor_unit import ProcessorUnit
    from intersight.model.rack_unit_personality import RackUnitPersonality
    from intersight.model.recommendation_abstract_item import RecommendationAbstractItem
    from intersight.model.recommendation_base import RecommendationBase
    from intersight.model.recommendation_capacity_runway import RecommendationCapacityRunway
    from intersight.model.recommendation_physical_item import RecommendationPhysicalItem
    from intersight.model.recovery_abstract_backup_config import RecoveryAbstractBackupConfig
    from intersight.model.recovery_abstract_backup_info import RecoveryAbstractBackupInfo
    from intersight.model.recovery_backup_config_policy import RecoveryBackupConfigPolicy
    from intersight.model.recovery_backup_profile import RecoveryBackupProfile
    from intersight.model.recovery_config_result import RecoveryConfigResult
    from intersight.model.recovery_config_result_entry import RecoveryConfigResultEntry
    from intersight.model.recovery_on_demand_backup import RecoveryOnDemandBackup
    from intersight.model.recovery_restore import RecoveryRestore
    from intersight.model.recovery_schedule_config_policy import RecoveryScheduleConfigPolicy
    from intersight.model.resource_group import ResourceGroup
    from intersight.model.resource_group_member import ResourceGroupMember
    from intersight.model.resource_license_resource_count import ResourceLicenseResourceCount
    from intersight.model.resource_membership import ResourceMembership
    from intersight.model.resource_membership_holder import ResourceMembershipHolder
    from intersight.model.resource_reservation import ResourceReservation
    from intersight.model.resourcepool_lease import ResourcepoolLease
    from intersight.model.resourcepool_lease_resource import ResourcepoolLeaseResource
    from intersight.model.resourcepool_pool import ResourcepoolPool
    from intersight.model.resourcepool_pool_member import ResourcepoolPoolMember
    from intersight.model.resourcepool_universe import ResourcepoolUniverse
    from intersight.model.rproxy_reverse_proxy import RproxyReverseProxy
    from intersight.model.sdcard_policy import SdcardPolicy
    from intersight.model.sdwan_profile import SdwanProfile
    from intersight.model.sdwan_router_node import SdwanRouterNode
    from intersight.model.sdwan_router_policy import SdwanRouterPolicy
    from intersight.model.sdwan_vmanage_account_policy import SdwanVmanageAccountPolicy
    from intersight.model.search_search_item import SearchSearchItem
    from intersight.model.search_tag_item import SearchTagItem
    from intersight.model.security_unit import SecurityUnit
    from intersight.model.server_base_profile import ServerBaseProfile
    from intersight.model.server_config_change_detail import ServerConfigChangeDetail
    from intersight.model.server_config_import import ServerConfigImport
    from intersight.model.server_config_result import ServerConfigResult
    from intersight.model.server_config_result_entry import ServerConfigResultEntry
    from intersight.model.server_profile import ServerProfile
    from intersight.model.server_profile_template import ServerProfileTemplate
    from intersight.model.session_abstract_session import SessionAbstractSession
    from intersight.model.session_abstract_sub_session import SessionAbstractSubSession
    from intersight.model.smtp_policy import SmtpPolicy
    from intersight.model.snmp_policy import SnmpPolicy
    from intersight.model.software_appliance_distributable import SoftwareApplianceDistributable
    from intersight.model.software_download_history import SoftwareDownloadHistory
    from intersight.model.software_hcl_meta import SoftwareHclMeta
    from intersight.model.software_hyperflex_bundle_distributable import SoftwareHyperflexBundleDistributable
    from intersight.model.software_hyperflex_distributable import SoftwareHyperflexDistributable
    from intersight.model.software_release_meta import SoftwareReleaseMeta
    from intersight.model.software_solution_distributable import SoftwareSolutionDistributable
    from intersight.model.software_ucsd_bundle_distributable import SoftwareUcsdBundleDistributable
    from intersight.model.software_ucsd_distributable import SoftwareUcsdDistributable
    from intersight.model.softwarerepository_authorization import SoftwarerepositoryAuthorization
    from intersight.model.softwarerepository_cached_image import SoftwarerepositoryCachedImage
    from intersight.model.softwarerepository_catalog import SoftwarerepositoryCatalog
    from intersight.model.softwarerepository_category_mapper import SoftwarerepositoryCategoryMapper
    from intersight.model.softwarerepository_category_mapper_model import SoftwarerepositoryCategoryMapperModel
    from intersight.model.softwarerepository_category_support_constraint import SoftwarerepositoryCategorySupportConstraint
    from intersight.model.softwarerepository_download_spec import SoftwarerepositoryDownloadSpec
    from intersight.model.softwarerepository_file import SoftwarerepositoryFile
    from intersight.model.softwarerepository_operating_system_file import SoftwarerepositoryOperatingSystemFile
    from intersight.model.softwarerepository_release import SoftwarerepositoryRelease
    from intersight.model.sol_policy import SolPolicy
    from intersight.model.ssh_policy import SshPolicy
    from intersight.model.storage_base_array import StorageBaseArray
    from intersight.model.storage_base_array_controller import StorageBaseArrayController
    from intersight.model.storage_base_array_disk import StorageBaseArrayDisk
    from intersight.model.storage_base_disk_pool import StorageBaseDiskPool
    from intersight.model.storage_base_host import StorageBaseHost
    from intersight.model.storage_base_host_group import StorageBaseHostGroup
    from intersight.model.storage_base_host_lun import StorageBaseHostLun
    from intersight.model.storage_base_nfs_export import StorageBaseNfsExport
    from intersight.model.storage_base_physical_port import StorageBasePhysicalPort
    from intersight.model.storage_base_protection_group import StorageBaseProtectionGroup
    from intersight.model.storage_base_protection_group_snapshot import StorageBaseProtectionGroupSnapshot
    from intersight.model.storage_base_raid_group import StorageBaseRaidGroup
    from intersight.model.storage_base_replication_schedule import StorageBaseReplicationSchedule
    from intersight.model.storage_base_snapshot import StorageBaseSnapshot
    from intersight.model.storage_base_snapshot_schedule import StorageBaseSnapshotSchedule
    from intersight.model.storage_base_storage_container import StorageBaseStorageContainer
    from intersight.model.storage_base_tenant import StorageBaseTenant
    from intersight.model.storage_base_volume import StorageBaseVolume
    from intersight.model.storage_controller import StorageController
    from intersight.model.storage_disk_group import StorageDiskGroup
    from intersight.model.storage_disk_slot import StorageDiskSlot
    from intersight.model.storage_drive_group import StorageDriveGroup
    from intersight.model.storage_enclosure import StorageEnclosure
    from intersight.model.storage_enclosure_disk import StorageEnclosureDisk
    from intersight.model.storage_enclosure_disk_slot_ep import StorageEnclosureDiskSlotEp
    from intersight.model.storage_flex_flash_controller import StorageFlexFlashController
    from intersight.model.storage_flex_flash_controller_props import StorageFlexFlashControllerProps
    from intersight.model.storage_flex_flash_physical_drive import StorageFlexFlashPhysicalDrive
    from intersight.model.storage_flex_flash_virtual_drive import StorageFlexFlashVirtualDrive
    from intersight.model.storage_flex_util_controller import StorageFlexUtilController
    from intersight.model.storage_flex_util_physical_drive import StorageFlexUtilPhysicalDrive
    from intersight.model.storage_flex_util_virtual_drive import StorageFlexUtilVirtualDrive
    from intersight.model.storage_hitachi_array import StorageHitachiArray
    from intersight.model.storage_hitachi_controller import StorageHitachiController
    from intersight.model.storage_hitachi_disk import StorageHitachiDisk
    from intersight.model.storage_hitachi_host import StorageHitachiHost
    from intersight.model.storage_hitachi_host_lun import StorageHitachiHostLun
    from intersight.model.storage_hitachi_parity_group import StorageHitachiParityGroup
    from intersight.model.storage_hitachi_pool import StorageHitachiPool
    from intersight.model.storage_hitachi_port import StorageHitachiPort
    from intersight.model.storage_hitachi_volume import StorageHitachiVolume
    from intersight.model.storage_hyper_flex_storage_container import StorageHyperFlexStorageContainer
    from intersight.model.storage_hyper_flex_volume import StorageHyperFlexVolume
    from intersight.model.storage_item import StorageItem
    from intersight.model.storage_net_app_aggregate import StorageNetAppAggregate
    from intersight.model.storage_net_app_base_disk import StorageNetAppBaseDisk
    from intersight.model.storage_net_app_cluster import StorageNetAppCluster
    from intersight.model.storage_net_app_ethernet_port import StorageNetAppEthernetPort
    from intersight.model.storage_net_app_export_policy import StorageNetAppExportPolicy
    from intersight.model.storage_net_app_fc_interface import StorageNetAppFcInterface
    from intersight.model.storage_net_app_fc_port import StorageNetAppFcPort
    from intersight.model.storage_net_app_initiator_group import StorageNetAppInitiatorGroup
    from intersight.model.storage_net_app_ip_interface import StorageNetAppIpInterface
    from intersight.model.storage_net_app_license import StorageNetAppLicense
    from intersight.model.storage_net_app_lun import StorageNetAppLun
    from intersight.model.storage_net_app_lun_map import StorageNetAppLunMap
    from intersight.model.storage_net_app_node import StorageNetAppNode
    from intersight.model.storage_net_app_ntp_server import StorageNetAppNtpServer
    from intersight.model.storage_net_app_sensor import StorageNetAppSensor
    from intersight.model.storage_net_app_storage_vm import StorageNetAppStorageVm
    from intersight.model.storage_net_app_volume import StorageNetAppVolume
    from intersight.model.storage_net_app_volume_snapshot import StorageNetAppVolumeSnapshot
    from intersight.model.storage_physical_disk import StoragePhysicalDisk
    from intersight.model.storage_physical_disk_extension import StoragePhysicalDiskExtension
    from intersight.model.storage_physical_disk_usage import StoragePhysicalDiskUsage
    from intersight.model.storage_pure_array import StoragePureArray
    from intersight.model.storage_pure_controller import StoragePureController
    from intersight.model.storage_pure_disk import StoragePureDisk
    from intersight.model.storage_pure_host import StoragePureHost
    from intersight.model.storage_pure_host_group import StoragePureHostGroup
    from intersight.model.storage_pure_host_lun import StoragePureHostLun
    from intersight.model.storage_pure_port import StoragePurePort
    from intersight.model.storage_pure_protection_group import StoragePureProtectionGroup
    from intersight.model.storage_pure_protection_group_snapshot import StoragePureProtectionGroupSnapshot
    from intersight.model.storage_pure_replication_schedule import StoragePureReplicationSchedule
    from intersight.model.storage_pure_snapshot_schedule import StoragePureSnapshotSchedule
    from intersight.model.storage_pure_volume import StoragePureVolume
    from intersight.model.storage_pure_volume_snapshot import StoragePureVolumeSnapshot
    from intersight.model.storage_sas_expander import StorageSasExpander
    from intersight.model.storage_sas_port import StorageSasPort
    from intersight.model.storage_span import StorageSpan
    from intersight.model.storage_storage_policy import StorageStoragePolicy
    from intersight.model.storage_vd_member_ep import StorageVdMemberEp
    from intersight.model.storage_virtual_drive import StorageVirtualDrive
    from intersight.model.storage_virtual_drive_container import StorageVirtualDriveContainer
    from intersight.model.storage_virtual_drive_extension import StorageVirtualDriveExtension
    from intersight.model.storage_virtual_drive_identity import StorageVirtualDriveIdentity
    from intersight.model.syslog_policy import SyslogPolicy
    from intersight.model.tam_advisory_count import TamAdvisoryCount
    from intersight.model.tam_advisory_definition import TamAdvisoryDefinition
    from intersight.model.tam_advisory_info import TamAdvisoryInfo
    from intersight.model.tam_advisory_instance import TamAdvisoryInstance
    from intersight.model.tam_base_advisory import TamBaseAdvisory
    from intersight.model.tam_security_advisory import TamSecurityAdvisory
    from intersight.model.task_hitachi_scoped_inventory import TaskHitachiScopedInventory
    from intersight.model.task_hxap_scoped_inventory import TaskHxapScopedInventory
    from intersight.model.task_net_app_scoped_inventory import TaskNetAppScopedInventory
    from intersight.model.task_public_cloud_scoped_inventory import TaskPublicCloudScopedInventory
    from intersight.model.task_pure_scoped_inventory import TaskPureScopedInventory
    from intersight.model.task_server_scoped_inventory import TaskServerScopedInventory
    from intersight.model.techsupportmanagement_collection_control_policy import TechsupportmanagementCollectionControlPolicy
    from intersight.model.techsupportmanagement_download import TechsupportmanagementDownload
    from intersight.model.techsupportmanagement_tech_support_bundle import TechsupportmanagementTechSupportBundle
    from intersight.model.techsupportmanagement_tech_support_status import TechsupportmanagementTechSupportStatus
    from intersight.model.terminal_audit_log import TerminalAuditLog
    from intersight.model.terraform_executor import TerraformExecutor
    from intersight.model.thermal_policy import ThermalPolicy
    from intersight.model.top_system import TopSystem
    from intersight.model.tunneling_tunnel import TunnelingTunnel
    from intersight.model.ucsd_backup_info import UcsdBackupInfo
    from intersight.model.uuidpool_block import UuidpoolBlock
    from intersight.model.uuidpool_pool import UuidpoolPool
    from intersight.model.uuidpool_pool_member import UuidpoolPoolMember
    from intersight.model.uuidpool_universe import UuidpoolUniverse
    from intersight.model.uuidpool_uuid_lease import UuidpoolUuidLease
    from intersight.model.views_view import ViewsView
    from intersight.model.virtualization_base_cluster import VirtualizationBaseCluster
    from intersight.model.virtualization_base_datacenter import VirtualizationBaseDatacenter
    from intersight.model.virtualization_base_datastore import VirtualizationBaseDatastore
    from intersight.model.virtualization_base_datastore_cluster import VirtualizationBaseDatastoreCluster
    from intersight.model.virtualization_base_distributed_network import VirtualizationBaseDistributedNetwork
    from intersight.model.virtualization_base_distributed_switch import VirtualizationBaseDistributedSwitch
    from intersight.model.virtualization_base_dvswitch import VirtualizationBaseDvswitch
    from intersight.model.virtualization_base_folder import VirtualizationBaseFolder
    from intersight.model.virtualization_base_host import VirtualizationBaseHost
    from intersight.model.virtualization_base_hypervisor_manager import VirtualizationBaseHypervisorManager
    from intersight.model.virtualization_base_kernel_network import VirtualizationBaseKernelNetwork
    from intersight.model.virtualization_base_network import VirtualizationBaseNetwork
    from intersight.model.virtualization_base_physical_network_interface import VirtualizationBasePhysicalNetworkInterface
    from intersight.model.virtualization_base_placement import VirtualizationBasePlacement
    from intersight.model.virtualization_base_source_device import VirtualizationBaseSourceDevice
    from intersight.model.virtualization_base_switch import VirtualizationBaseSwitch
    from intersight.model.virtualization_base_virtual_disk import VirtualizationBaseVirtualDisk
    from intersight.model.virtualization_base_virtual_machine import VirtualizationBaseVirtualMachine
    from intersight.model.virtualization_base_virtual_machine_snapshot import VirtualizationBaseVirtualMachineSnapshot
    from intersight.model.virtualization_base_virtual_network import VirtualizationBaseVirtualNetwork
    from intersight.model.virtualization_base_virtual_network_interface import VirtualizationBaseVirtualNetworkInterface
    from intersight.model.virtualization_base_virtual_network_interface_card import VirtualizationBaseVirtualNetworkInterfaceCard
    from intersight.model.virtualization_base_virtual_switch import VirtualizationBaseVirtualSwitch
    from intersight.model.virtualization_base_vswitch import VirtualizationBaseVswitch
    from intersight.model.virtualization_host import VirtualizationHost
    from intersight.model.virtualization_virtual_disk import VirtualizationVirtualDisk
    from intersight.model.virtualization_virtual_machine import VirtualizationVirtualMachine
    from intersight.model.virtualization_virtual_network import VirtualizationVirtualNetwork
    from intersight.model.virtualization_vmware_cluster import VirtualizationVmwareCluster
    from intersight.model.virtualization_vmware_datacenter import VirtualizationVmwareDatacenter
    from intersight.model.virtualization_vmware_datastore import VirtualizationVmwareDatastore
    from intersight.model.virtualization_vmware_datastore_cluster import VirtualizationVmwareDatastoreCluster
    from intersight.model.virtualization_vmware_distributed_network import VirtualizationVmwareDistributedNetwork
    from intersight.model.virtualization_vmware_distributed_switch import VirtualizationVmwareDistributedSwitch
    from intersight.model.virtualization_vmware_folder import VirtualizationVmwareFolder
    from intersight.model.virtualization_vmware_host import VirtualizationVmwareHost
    from intersight.model.virtualization_vmware_kernel_network import VirtualizationVmwareKernelNetwork
    from intersight.model.virtualization_vmware_network import VirtualizationVmwareNetwork
    from intersight.model.virtualization_vmware_physical_network_interface import VirtualizationVmwarePhysicalNetworkInterface
    from intersight.model.virtualization_vmware_uplink_port import VirtualizationVmwareUplinkPort
    from intersight.model.virtualization_vmware_vcenter import VirtualizationVmwareVcenter
    from intersight.model.virtualization_vmware_virtual_disk import VirtualizationVmwareVirtualDisk
    from intersight.model.virtualization_vmware_virtual_machine import VirtualizationVmwareVirtualMachine
    from intersight.model.virtualization_vmware_virtual_machine_snapshot import VirtualizationVmwareVirtualMachineSnapshot
    from intersight.model.virtualization_vmware_virtual_network_interface import VirtualizationVmwareVirtualNetworkInterface
    from intersight.model.virtualization_vmware_virtual_switch import VirtualizationVmwareVirtualSwitch
    from intersight.model.vmedia_policy import VmediaPolicy
    from intersight.model.vmrc_console import VmrcConsole
    from intersight.model.vnc_console import VncConsole
    from intersight.model.vnic_eth_adapter_policy import VnicEthAdapterPolicy
    from intersight.model.vnic_eth_if import VnicEthIf
    from intersight.model.vnic_eth_network_policy import VnicEthNetworkPolicy
    from intersight.model.vnic_eth_qos_policy import VnicEthQosPolicy
    from intersight.model.vnic_fc_adapter_policy import VnicFcAdapterPolicy
    from intersight.model.vnic_fc_if import VnicFcIf
    from intersight.model.vnic_fc_network_policy import VnicFcNetworkPolicy
    from intersight.model.vnic_fc_qos_policy import VnicFcQosPolicy
    from intersight.model.vnic_iscsi_adapter_policy import VnicIscsiAdapterPolicy
    from intersight.model.vnic_iscsi_boot_policy import VnicIscsiBootPolicy
    from intersight.model.vnic_iscsi_static_target_policy import VnicIscsiStaticTargetPolicy
    from intersight.model.vnic_lan_connectivity_policy import VnicLanConnectivityPolicy
    from intersight.model.vnic_lcp_status import VnicLcpStatus
    from intersight.model.vnic_san_connectivity_policy import VnicSanConnectivityPolicy
    from intersight.model.vnic_scp_status import VnicScpStatus
    from intersight.model.vrf_vrf import VrfVrf
    from intersight.model.workflow_batch_api_executor import WorkflowBatchApiExecutor
    from intersight.model.workflow_batch_executor import WorkflowBatchExecutor
    from intersight.model.workflow_build_task_meta import WorkflowBuildTaskMeta
    from intersight.model.workflow_build_task_meta_owner import WorkflowBuildTaskMetaOwner
    from intersight.model.workflow_catalog import WorkflowCatalog
    from intersight.model.workflow_custom_data_type_definition import WorkflowCustomDataTypeDefinition
    from intersight.model.workflow_error_response_handler import WorkflowErrorResponseHandler
    from intersight.model.workflow_pending_dynamic_workflow_info import WorkflowPendingDynamicWorkflowInfo
    from intersight.model.workflow_rollback_workflow import WorkflowRollbackWorkflow
    from intersight.model.workflow_solution_action_definition import WorkflowSolutionActionDefinition
    from intersight.model.workflow_solution_action_instance import WorkflowSolutionActionInstance
    from intersight.model.workflow_solution_definition import WorkflowSolutionDefinition
    from intersight.model.workflow_solution_instance import WorkflowSolutionInstance
    from intersight.model.workflow_solution_output import WorkflowSolutionOutput
    from intersight.model.workflow_task_debug_log import WorkflowTaskDebugLog
    from intersight.model.workflow_task_definition import WorkflowTaskDefinition
    from intersight.model.workflow_task_info import WorkflowTaskInfo
    from intersight.model.workflow_task_metadata import WorkflowTaskMetadata
    from intersight.model.workflow_task_notification import WorkflowTaskNotification
    from intersight.model.workflow_template_evaluation import WorkflowTemplateEvaluation
    from intersight.model.workflow_template_function_meta import WorkflowTemplateFunctionMeta
    from intersight.model.workflow_workflow_definition import WorkflowWorkflowDefinition
    from intersight.model.workflow_workflow_info import WorkflowWorkflowInfo
    from intersight.model.workflow_workflow_meta import WorkflowWorkflowMeta
    from intersight.model.workflow_workflow_metadata import WorkflowWorkflowMetadata
    from intersight.model.workflow_workflow_notification import WorkflowWorkflowNotification
    globals()['AaaAbstractAuditRecord'] = AaaAbstractAuditRecord
    globals()['AaaAuditRecord'] = AaaAuditRecord
    globals()['AaaRetentionConfig'] = AaaRetentionConfig
    globals()['AaaRetentionPolicy'] = AaaRetentionPolicy
    globals()['AccessPolicy'] = AccessPolicy
    globals()['AdapterConfigPolicy'] = AdapterConfigPolicy
    globals()['AdapterExtEthInterface'] = AdapterExtEthInterface
    globals()['AdapterHostEthInterface'] = AdapterHostEthInterface
    globals()['AdapterHostFcInterface'] = AdapterHostFcInterface
    globals()['AdapterHostIscsiInterface'] = AdapterHostIscsiInterface
    globals()['AdapterUnit'] = AdapterUnit
    globals()['AdapterUnitExpander'] = AdapterUnitExpander
    globals()['ApplianceAppStatus'] = ApplianceAppStatus
    globals()['ApplianceAutoRmaPolicy'] = ApplianceAutoRmaPolicy
    globals()['ApplianceBackup'] = ApplianceBackup
    globals()['ApplianceBackupBase'] = ApplianceBackupBase
    globals()['ApplianceBackupPolicy'] = ApplianceBackupPolicy
    globals()['ApplianceCertificateSetting'] = ApplianceCertificateSetting
    globals()['ApplianceDataExportPolicy'] = ApplianceDataExportPolicy
    globals()['ApplianceDeviceCertificate'] = ApplianceDeviceCertificate
    globals()['ApplianceDeviceClaim'] = ApplianceDeviceClaim
    globals()['ApplianceDeviceUpgradePolicy'] = ApplianceDeviceUpgradePolicy
    globals()['ApplianceDiagSetting'] = ApplianceDiagSetting
    globals()['ApplianceExternalSyslogSetting'] = ApplianceExternalSyslogSetting
    globals()['ApplianceFileGateway'] = ApplianceFileGateway
    globals()['ApplianceFileSystemStatus'] = ApplianceFileSystemStatus
    globals()['ApplianceGroupStatus'] = ApplianceGroupStatus
    globals()['ApplianceImageBundle'] = ApplianceImageBundle
    globals()['ApplianceNodeInfo'] = ApplianceNodeInfo
    globals()['ApplianceNodeStatus'] = ApplianceNodeStatus
    globals()['ApplianceReleaseNote'] = ApplianceReleaseNote
    globals()['ApplianceRemoteFileImport'] = ApplianceRemoteFileImport
    globals()['ApplianceRestore'] = ApplianceRestore
    globals()['ApplianceSetupInfo'] = ApplianceSetupInfo
    globals()['ApplianceSystemInfo'] = ApplianceSystemInfo
    globals()['ApplianceSystemStatus'] = ApplianceSystemStatus
    globals()['ApplianceUpgrade'] = ApplianceUpgrade
    globals()['ApplianceUpgradePolicy'] = ApplianceUpgradePolicy
    globals()['AssetClusterMember'] = AssetClusterMember
    globals()['AssetDeployment'] = AssetDeployment
    globals()['AssetDeploymentDevice'] = AssetDeploymentDevice
    globals()['AssetDeviceClaim'] = AssetDeviceClaim
    globals()['AssetDeviceConfiguration'] = AssetDeviceConfiguration
    globals()['AssetDeviceConnection'] = AssetDeviceConnection
    globals()['AssetDeviceConnectorManager'] = AssetDeviceConnectorManager
    globals()['AssetDeviceContractInformation'] = AssetDeviceContractInformation
    globals()['AssetDeviceRegistration'] = AssetDeviceRegistration
    globals()['AssetSubscription'] = AssetSubscription
    globals()['AssetSubscriptionAccount'] = AssetSubscriptionAccount
    globals()['AssetSubscriptionDeviceContractInformation'] = AssetSubscriptionDeviceContractInformation
    globals()['AssetTarget'] = AssetTarget
    globals()['BiosBootDevice'] = BiosBootDevice
    globals()['BiosBootMode'] = BiosBootMode
    globals()['BiosPolicy'] = BiosPolicy
    globals()['BiosSystemBootOrder'] = BiosSystemBootOrder
    globals()['BiosTokenSettings'] = BiosTokenSettings
    globals()['BiosUnit'] = BiosUnit
    globals()['BiosVfSelectMemoryRasConfiguration'] = BiosVfSelectMemoryRasConfiguration
    globals()['BootCddDevice'] = BootCddDevice
    globals()['BootConfiguredDevice'] = BootConfiguredDevice
    globals()['BootDeviceBootMode'] = BootDeviceBootMode
    globals()['BootDeviceBootSecurity'] = BootDeviceBootSecurity
    globals()['BootHddDevice'] = BootHddDevice
    globals()['BootIscsiDevice'] = BootIscsiDevice
    globals()['BootNvmeDevice'] = BootNvmeDevice
    globals()['BootPchStorageDevice'] = BootPchStorageDevice
    globals()['BootPrecisionPolicy'] = BootPrecisionPolicy
    globals()['BootPxeDevice'] = BootPxeDevice
    globals()['BootSanDevice'] = BootSanDevice
    globals()['BootSdDevice'] = BootSdDevice
    globals()['BootUefiShellDevice'] = BootUefiShellDevice
    globals()['BootUsbDevice'] = BootUsbDevice
    globals()['BootVmediaDevice'] = BootVmediaDevice
    globals()['BulkExport'] = BulkExport
    globals()['BulkExportedItem'] = BulkExportedItem
    globals()['BulkMoCloner'] = BulkMoCloner
    globals()['BulkMoMerger'] = BulkMoMerger
    globals()['BulkRequest'] = BulkRequest
    globals()['BulkSubRequestObj'] = BulkSubRequestObj
    globals()['CapabilityAdapterUnitDescriptor'] = CapabilityAdapterUnitDescriptor
    globals()['CapabilityCapability'] = CapabilityCapability
    globals()['CapabilityCatalog'] = CapabilityCatalog
    globals()['CapabilityChassisDescriptor'] = CapabilityChassisDescriptor
    globals()['CapabilityChassisManufacturingDef'] = CapabilityChassisManufacturingDef
    globals()['CapabilityCimcFirmwareDescriptor'] = CapabilityCimcFirmwareDescriptor
    globals()['CapabilityEndpointDescriptor'] = CapabilityEndpointDescriptor
    globals()['CapabilityEquipmentPhysicalDef'] = CapabilityEquipmentPhysicalDef
    globals()['CapabilityEquipmentSlotArray'] = CapabilityEquipmentSlotArray
    globals()['CapabilityFanModuleDescriptor'] = CapabilityFanModuleDescriptor
    globals()['CapabilityFanModuleManufacturingDef'] = CapabilityFanModuleManufacturingDef
    globals()['CapabilityHardwareDescriptor'] = CapabilityHardwareDescriptor
    globals()['CapabilityIoCardCapabilityDef'] = CapabilityIoCardCapabilityDef
    globals()['CapabilityIoCardDescriptor'] = CapabilityIoCardDescriptor
    globals()['CapabilityIoCardManufacturingDef'] = CapabilityIoCardManufacturingDef
    globals()['CapabilityPortGroupAggregationDef'] = CapabilityPortGroupAggregationDef
    globals()['CapabilityPsuDescriptor'] = CapabilityPsuDescriptor
    globals()['CapabilityPsuManufacturingDef'] = CapabilityPsuManufacturingDef
    globals()['CapabilityServerModelsCapabilityDef'] = CapabilityServerModelsCapabilityDef
    globals()['CapabilityServerSchemaDescriptor'] = CapabilityServerSchemaDescriptor
    globals()['CapabilitySiocModuleCapabilityDef'] = CapabilitySiocModuleCapabilityDef
    globals()['CapabilitySiocModuleDescriptor'] = CapabilitySiocModuleDescriptor
    globals()['CapabilitySiocModuleManufacturingDef'] = CapabilitySiocModuleManufacturingDef
    globals()['CapabilitySwitchCapability'] = CapabilitySwitchCapability
    globals()['CapabilitySwitchCapabilityDef'] = CapabilitySwitchCapabilityDef
    globals()['CapabilitySwitchDescriptor'] = CapabilitySwitchDescriptor
    globals()['CapabilitySwitchManufacturingDef'] = CapabilitySwitchManufacturingDef
    globals()['CertificatemanagementPolicy'] = CertificatemanagementPolicy
    globals()['ChassisConfigChangeDetail'] = ChassisConfigChangeDetail
    globals()['ChassisConfigImport'] = ChassisConfigImport
    globals()['ChassisConfigResult'] = ChassisConfigResult
    globals()['ChassisConfigResultEntry'] = ChassisConfigResultEntry
    globals()['ChassisIomProfile'] = ChassisIomProfile
    globals()['ChassisProfile'] = ChassisProfile
    globals()['CloudAwsBillingUnit'] = CloudAwsBillingUnit
    globals()['CloudAwsKeyPair'] = CloudAwsKeyPair
    globals()['CloudAwsNetworkInterface'] = CloudAwsNetworkInterface
    globals()['CloudAwsOrganizationalUnit'] = CloudAwsOrganizationalUnit
    globals()['CloudAwsSecurityGroup'] = CloudAwsSecurityGroup
    globals()['CloudAwsSubnet'] = CloudAwsSubnet
    globals()['CloudAwsVirtualMachine'] = CloudAwsVirtualMachine
    globals()['CloudAwsVolume'] = CloudAwsVolume
    globals()['CloudAwsVpc'] = CloudAwsVpc
    globals()['CloudBaseBillingUnit'] = CloudBaseBillingUnit
    globals()['CloudBaseEntity'] = CloudBaseEntity
    globals()['CloudBaseNetwork'] = CloudBaseNetwork
    globals()['CloudBaseNetworkInterface'] = CloudBaseNetworkInterface
    globals()['CloudBasePlacement'] = CloudBasePlacement
    globals()['CloudBaseSku'] = CloudBaseSku
    globals()['CloudBaseVirtualMachine'] = CloudBaseVirtualMachine
    globals()['CloudBaseVolume'] = CloudBaseVolume
    globals()['CloudCollectInventory'] = CloudCollectInventory
    globals()['CloudRegions'] = CloudRegions
    globals()['CloudSkuContainerType'] = CloudSkuContainerType
    globals()['CloudSkuDatabaseType'] = CloudSkuDatabaseType
    globals()['CloudSkuInstanceType'] = CloudSkuInstanceType
    globals()['CloudSkuNetworkType'] = CloudSkuNetworkType
    globals()['CloudSkuRegionRateCards'] = CloudSkuRegionRateCards
    globals()['CloudSkuVolumeType'] = CloudSkuVolumeType
    globals()['CloudTfcAgentpool'] = CloudTfcAgentpool
    globals()['CloudTfcOrganization'] = CloudTfcOrganization
    globals()['CloudTfcWorkspace'] = CloudTfcWorkspace
    globals()['CommAbstractHttpProxyPolicy'] = CommAbstractHttpProxyPolicy
    globals()['CommHttpProxyPolicy'] = CommHttpProxyPolicy
    globals()['ComputeBiosPostPolicy'] = ComputeBiosPostPolicy
    globals()['ComputeBlade'] = ComputeBlade
    globals()['ComputeBladeIdentity'] = ComputeBladeIdentity
    globals()['ComputeBoard'] = ComputeBoard
    globals()['ComputeMapping'] = ComputeMapping
    globals()['ComputePhysical'] = ComputePhysical
    globals()['ComputePhysicalSummary'] = ComputePhysicalSummary
    globals()['ComputeRackUnit'] = ComputeRackUnit
    globals()['ComputeRackUnitIdentity'] = ComputeRackUnitIdentity
    globals()['ComputeServerPowerPolicy'] = ComputeServerPowerPolicy
    globals()['ComputeServerSetting'] = ComputeServerSetting
    globals()['ComputeVmedia'] = ComputeVmedia
    globals()['CondAlarm'] = CondAlarm
    globals()['CondAlarmAggregation'] = CondAlarmAggregation
    globals()['CondHclStatus'] = CondHclStatus
    globals()['CondHclStatusDetail'] = CondHclStatusDetail
    globals()['CondHclStatusJob'] = CondHclStatusJob
    globals()['ConnectorDownloadStatus'] = ConnectorDownloadStatus
    globals()['ConnectorScopedInventory'] = ConnectorScopedInventory
    globals()['ConnectorpackConnectorPackUpgrade'] = ConnectorpackConnectorPackUpgrade
    globals()['ConnectorpackUpgradeImpact'] = ConnectorpackUpgradeImpact
    globals()['ConvergedinfraBasePod'] = ConvergedinfraBasePod
    globals()['ConvergedinfraHealthCheckDefinition'] = ConvergedinfraHealthCheckDefinition
    globals()['ConvergedinfraHealthCheckExecution'] = ConvergedinfraHealthCheckExecution
    globals()['ConvergedinfraPod'] = ConvergedinfraPod
    globals()['CrdCustomResource'] = CrdCustomResource
    globals()['DeviceconnectorPolicy'] = DeviceconnectorPolicy
    globals()['DisplayNames'] = DisplayNames
    globals()['EquipmentAbstractDevice'] = EquipmentAbstractDevice
    globals()['EquipmentBase'] = EquipmentBase
    globals()['EquipmentBaseSensor'] = EquipmentBaseSensor
    globals()['EquipmentChassis'] = EquipmentChassis
    globals()['EquipmentChassisIdentity'] = EquipmentChassisIdentity
    globals()['EquipmentChassisOperation'] = EquipmentChassisOperation
    globals()['EquipmentDeviceSummary'] = EquipmentDeviceSummary
    globals()['EquipmentExpanderModule'] = EquipmentExpanderModule
    globals()['EquipmentFan'] = EquipmentFan
    globals()['EquipmentFanControl'] = EquipmentFanControl
    globals()['EquipmentFanModule'] = EquipmentFanModule
    globals()['EquipmentFex'] = EquipmentFex
    globals()['EquipmentFexIdentity'] = EquipmentFexIdentity
    globals()['EquipmentFexOperation'] = EquipmentFexOperation
    globals()['EquipmentFru'] = EquipmentFru
    globals()['EquipmentIdentity'] = EquipmentIdentity
    globals()['EquipmentIdentitySummary'] = EquipmentIdentitySummary
    globals()['EquipmentIoCard'] = EquipmentIoCard
    globals()['EquipmentIoCardBase'] = EquipmentIoCardBase
    globals()['EquipmentIoCardOperation'] = EquipmentIoCardOperation
    globals()['EquipmentIoExpander'] = EquipmentIoExpander
    globals()['EquipmentLocatorLed'] = EquipmentLocatorLed
    globals()['EquipmentPhysicalIdentity'] = EquipmentPhysicalIdentity
    globals()['EquipmentPsu'] = EquipmentPsu
    globals()['EquipmentPsuControl'] = EquipmentPsuControl
    globals()['EquipmentRackEnclosure'] = EquipmentRackEnclosure
    globals()['EquipmentRackEnclosureSlot'] = EquipmentRackEnclosureSlot
    globals()['EquipmentSharedIoModule'] = EquipmentSharedIoModule
    globals()['EquipmentSlot'] = EquipmentSlot
    globals()['EquipmentSwitchCard'] = EquipmentSwitchCard
    globals()['EquipmentSystemIoController'] = EquipmentSystemIoController
    globals()['EquipmentTpm'] = EquipmentTpm
    globals()['EquipmentTransceiver'] = EquipmentTransceiver
    globals()['EtherHostPort'] = EtherHostPort
    globals()['EtherNetworkPort'] = EtherNetworkPort
    globals()['EtherPhysicalPort'] = EtherPhysicalPort
    globals()['EtherPhysicalPortBase'] = EtherPhysicalPortBase
    globals()['EtherPortChannel'] = EtherPortChannel
    globals()['ExternalsiteAuthorization'] = ExternalsiteAuthorization
    globals()['FabricAppliancePcRole'] = FabricAppliancePcRole
    globals()['FabricApplianceRole'] = FabricApplianceRole
    globals()['FabricConfigChangeDetail'] = FabricConfigChangeDetail
    globals()['FabricConfigResult'] = FabricConfigResult
    globals()['FabricConfigResultEntry'] = FabricConfigResultEntry
    globals()['FabricElementIdentity'] = FabricElementIdentity
    globals()['FabricEstimateImpact'] = FabricEstimateImpact
    globals()['FabricEthNetworkControlPolicy'] = FabricEthNetworkControlPolicy
    globals()['FabricEthNetworkGroupPolicy'] = FabricEthNetworkGroupPolicy
    globals()['FabricEthNetworkPolicy'] = FabricEthNetworkPolicy
    globals()['FabricFcNetworkPolicy'] = FabricFcNetworkPolicy
    globals()['FabricFcUplinkPcRole'] = FabricFcUplinkPcRole
    globals()['FabricFcUplinkRole'] = FabricFcUplinkRole
    globals()['FabricFcoeUplinkPcRole'] = FabricFcoeUplinkPcRole
    globals()['FabricFcoeUplinkRole'] = FabricFcoeUplinkRole
    globals()['FabricFlowControlPolicy'] = FabricFlowControlPolicy
    globals()['FabricLinkAggregationPolicy'] = FabricLinkAggregationPolicy
    globals()['FabricLinkControlPolicy'] = FabricLinkControlPolicy
    globals()['FabricMulticastPolicy'] = FabricMulticastPolicy
    globals()['FabricPcMember'] = FabricPcMember
    globals()['FabricPcOperation'] = FabricPcOperation
    globals()['FabricPortBase'] = FabricPortBase
    globals()['FabricPortChannelRole'] = FabricPortChannelRole
    globals()['FabricPortMode'] = FabricPortMode
    globals()['FabricPortOperation'] = FabricPortOperation
    globals()['FabricPortPolicy'] = FabricPortPolicy
    globals()['FabricPortRole'] = FabricPortRole
    globals()['FabricServerRole'] = FabricServerRole
    globals()['FabricSwitchClusterProfile'] = FabricSwitchClusterProfile
    globals()['FabricSwitchControlPolicy'] = FabricSwitchControlPolicy
    globals()['FabricSwitchProfile'] = FabricSwitchProfile
    globals()['FabricSystemQosPolicy'] = FabricSystemQosPolicy
    globals()['FabricTransceiverRole'] = FabricTransceiverRole
    globals()['FabricUplinkPcRole'] = FabricUplinkPcRole
    globals()['FabricUplinkRole'] = FabricUplinkRole
    globals()['FabricVlan'] = FabricVlan
    globals()['FabricVsan'] = FabricVsan
    globals()['FaultInstance'] = FaultInstance
    globals()['FcPhysicalPort'] = FcPhysicalPort
    globals()['FcPortChannel'] = FcPortChannel
    globals()['FcpoolFcBlock'] = FcpoolFcBlock
    globals()['FcpoolLease'] = FcpoolLease
    globals()['FcpoolPool'] = FcpoolPool
    globals()['FcpoolPoolMember'] = FcpoolPoolMember
    globals()['FcpoolUniverse'] = FcpoolUniverse
    globals()['FeedbackFeedbackPost'] = FeedbackFeedbackPost
    globals()['FirmwareBaseDistributable'] = FirmwareBaseDistributable
    globals()['FirmwareBiosDescriptor'] = FirmwareBiosDescriptor
    globals()['FirmwareBoardControllerDescriptor'] = FirmwareBoardControllerDescriptor
    globals()['FirmwareChassisUpgrade'] = FirmwareChassisUpgrade
    globals()['FirmwareCimcDescriptor'] = FirmwareCimcDescriptor
    globals()['FirmwareComponentDescriptor'] = FirmwareComponentDescriptor
    globals()['FirmwareDimmDescriptor'] = FirmwareDimmDescriptor
    globals()['FirmwareDistributable'] = FirmwareDistributable
    globals()['FirmwareDistributableMeta'] = FirmwareDistributableMeta
    globals()['FirmwareDriveDescriptor'] = FirmwareDriveDescriptor
    globals()['FirmwareDriverDistributable'] = FirmwareDriverDistributable
    globals()['FirmwareEula'] = FirmwareEula
    globals()['FirmwareFirmwareSummary'] = FirmwareFirmwareSummary
    globals()['FirmwareGpuDescriptor'] = FirmwareGpuDescriptor
    globals()['FirmwareHbaDescriptor'] = FirmwareHbaDescriptor
    globals()['FirmwareIomDescriptor'] = FirmwareIomDescriptor
    globals()['FirmwareMswitchDescriptor'] = FirmwareMswitchDescriptor
    globals()['FirmwareNxosDescriptor'] = FirmwareNxosDescriptor
    globals()['FirmwarePcieDescriptor'] = FirmwarePcieDescriptor
    globals()['FirmwarePsuDescriptor'] = FirmwarePsuDescriptor
    globals()['FirmwareRunningFirmware'] = FirmwareRunningFirmware
    globals()['FirmwareSasExpanderDescriptor'] = FirmwareSasExpanderDescriptor
    globals()['FirmwareServerConfigurationUtilityDistributable'] = FirmwareServerConfigurationUtilityDistributable
    globals()['FirmwareStorageControllerDescriptor'] = FirmwareStorageControllerDescriptor
    globals()['FirmwareSwitchUpgrade'] = FirmwareSwitchUpgrade
    globals()['FirmwareUnsupportedVersionUpgrade'] = FirmwareUnsupportedVersionUpgrade
    globals()['FirmwareUpgrade'] = FirmwareUpgrade
    globals()['FirmwareUpgradeBase'] = FirmwareUpgradeBase
    globals()['FirmwareUpgradeImpact'] = FirmwareUpgradeImpact
    globals()['FirmwareUpgradeImpactBase'] = FirmwareUpgradeImpactBase
    globals()['FirmwareUpgradeImpactStatus'] = FirmwareUpgradeImpactStatus
    globals()['FirmwareUpgradeStatus'] = FirmwareUpgradeStatus
    globals()['ForecastCatalog'] = ForecastCatalog
    globals()['ForecastDefinition'] = ForecastDefinition
    globals()['ForecastInstance'] = ForecastInstance
    globals()['GraphicsCard'] = GraphicsCard
    globals()['GraphicsController'] = GraphicsController
    globals()['HclCompatibilityStatus'] = HclCompatibilityStatus
    globals()['HclDriverImage'] = HclDriverImage
    globals()['HclExemptedCatalog'] = HclExemptedCatalog
    globals()['HclHyperflexSoftwareCompatibilityInfo'] = HclHyperflexSoftwareCompatibilityInfo
    globals()['HclOperatingSystem'] = HclOperatingSystem
    globals()['HclOperatingSystemVendor'] = HclOperatingSystemVendor
    globals()['HclSupportedDriverName'] = HclSupportedDriverName
    globals()['HyperflexAlarm'] = HyperflexAlarm
    globals()['HyperflexAppCatalog'] = HyperflexAppCatalog
    globals()['HyperflexAutoSupportPolicy'] = HyperflexAutoSupportPolicy
    globals()['HyperflexBackupCluster'] = HyperflexBackupCluster
    globals()['HyperflexBaseCluster'] = HyperflexBaseCluster
    globals()['HyperflexCapabilityInfo'] = HyperflexCapabilityInfo
    globals()['HyperflexCiscoHypervisorManager'] = HyperflexCiscoHypervisorManager
    globals()['HyperflexCluster'] = HyperflexCluster
    globals()['HyperflexClusterBackupPolicy'] = HyperflexClusterBackupPolicy
    globals()['HyperflexClusterBackupPolicyDeployment'] = HyperflexClusterBackupPolicyDeployment
    globals()['HyperflexClusterBackupPolicyInventory'] = HyperflexClusterBackupPolicyInventory
    globals()['HyperflexClusterHealthCheckExecutionSnapshot'] = HyperflexClusterHealthCheckExecutionSnapshot
    globals()['HyperflexClusterNetworkPolicy'] = HyperflexClusterNetworkPolicy
    globals()['HyperflexClusterProfile'] = HyperflexClusterProfile
    globals()['HyperflexClusterReplicationNetworkPolicy'] = HyperflexClusterReplicationNetworkPolicy
    globals()['HyperflexClusterReplicationNetworkPolicyDeployment'] = HyperflexClusterReplicationNetworkPolicyDeployment
    globals()['HyperflexClusterStoragePolicy'] = HyperflexClusterStoragePolicy
    globals()['HyperflexConfigResult'] = HyperflexConfigResult
    globals()['HyperflexConfigResultEntry'] = HyperflexConfigResultEntry
    globals()['HyperflexDataProtectionPeer'] = HyperflexDataProtectionPeer
    globals()['HyperflexDatastoreStatistic'] = HyperflexDatastoreStatistic
    globals()['HyperflexDevicePackageDownloadState'] = HyperflexDevicePackageDownloadState
    globals()['HyperflexDrive'] = HyperflexDrive
    globals()['HyperflexExtFcStoragePolicy'] = HyperflexExtFcStoragePolicy
    globals()['HyperflexExtIscsiStoragePolicy'] = HyperflexExtIscsiStoragePolicy
    globals()['HyperflexFeatureLimitExternal'] = HyperflexFeatureLimitExternal
    globals()['HyperflexFeatureLimitInternal'] = HyperflexFeatureLimitInternal
    globals()['HyperflexHealth'] = HyperflexHealth
    globals()['HyperflexHealthCheckDefinition'] = HyperflexHealthCheckDefinition
    globals()['HyperflexHealthCheckExecution'] = HyperflexHealthCheckExecution
    globals()['HyperflexHealthCheckExecutionSnapshot'] = HyperflexHealthCheckExecutionSnapshot
    globals()['HyperflexHealthCheckPackageChecksum'] = HyperflexHealthCheckPackageChecksum
    globals()['HyperflexHxapCluster'] = HyperflexHxapCluster
    globals()['HyperflexHxapDatacenter'] = HyperflexHxapDatacenter
    globals()['HyperflexHxapDvUplink'] = HyperflexHxapDvUplink
    globals()['HyperflexHxapDvswitch'] = HyperflexHxapDvswitch
    globals()['HyperflexHxapHost'] = HyperflexHxapHost
    globals()['HyperflexHxapHostInterface'] = HyperflexHxapHostInterface
    globals()['HyperflexHxapHostVswitch'] = HyperflexHxapHostVswitch
    globals()['HyperflexHxapNetwork'] = HyperflexHxapNetwork
    globals()['HyperflexHxapVirtualDisk'] = HyperflexHxapVirtualDisk
    globals()['HyperflexHxapVirtualMachine'] = HyperflexHxapVirtualMachine
    globals()['HyperflexHxapVirtualMachineNetworkInterface'] = HyperflexHxapVirtualMachineNetworkInterface
    globals()['HyperflexHxdpVersion'] = HyperflexHxdpVersion
    globals()['HyperflexLicense'] = HyperflexLicense
    globals()['HyperflexLocalCredentialPolicy'] = HyperflexLocalCredentialPolicy
    globals()['HyperflexNode'] = HyperflexNode
    globals()['HyperflexNodeConfigPolicy'] = HyperflexNodeConfigPolicy
    globals()['HyperflexNodeProfile'] = HyperflexNodeProfile
    globals()['HyperflexProtectedCluster'] = HyperflexProtectedCluster
    globals()['HyperflexProxySettingPolicy'] = HyperflexProxySettingPolicy
    globals()['HyperflexServerFirmwareVersion'] = HyperflexServerFirmwareVersion
    globals()['HyperflexServerFirmwareVersionEntry'] = HyperflexServerFirmwareVersionEntry
    globals()['HyperflexServerModel'] = HyperflexServerModel
    globals()['HyperflexServiceAuthToken'] = HyperflexServiceAuthToken
    globals()['HyperflexSoftwareDistributionComponent'] = HyperflexSoftwareDistributionComponent
    globals()['HyperflexSoftwareDistributionEntry'] = HyperflexSoftwareDistributionEntry
    globals()['HyperflexSoftwareDistributionVersion'] = HyperflexSoftwareDistributionVersion
    globals()['HyperflexSoftwareVersionPolicy'] = HyperflexSoftwareVersionPolicy
    globals()['HyperflexStorageContainer'] = HyperflexStorageContainer
    globals()['HyperflexSysConfigPolicy'] = HyperflexSysConfigPolicy
    globals()['HyperflexUcsmConfigPolicy'] = HyperflexUcsmConfigPolicy
    globals()['HyperflexVcenterConfigPolicy'] = HyperflexVcenterConfigPolicy
    globals()['HyperflexVmBackupInfo'] = HyperflexVmBackupInfo
    globals()['HyperflexVmImportOperation'] = HyperflexVmImportOperation
    globals()['HyperflexVmRestoreOperation'] = HyperflexVmRestoreOperation
    globals()['HyperflexVmSnapshotInfo'] = HyperflexVmSnapshotInfo
    globals()['HyperflexVolume'] = HyperflexVolume
    globals()['HyperflexWitnessConfiguration'] = HyperflexWitnessConfiguration
    globals()['IaasConnectorPack'] = IaasConnectorPack
    globals()['IaasDeviceStatus'] = IaasDeviceStatus
    globals()['IaasDiagnosticMessages'] = IaasDiagnosticMessages
    globals()['IaasLicenseInfo'] = IaasLicenseInfo
    globals()['IaasMostRunTasks'] = IaasMostRunTasks
    globals()['IaasServiceRequest'] = IaasServiceRequest
    globals()['IaasUcsdInfo'] = IaasUcsdInfo
    globals()['IaasUcsdManagedInfra'] = IaasUcsdManagedInfra
    globals()['IaasUcsdMessages'] = IaasUcsdMessages
    globals()['IamAccount'] = IamAccount
    globals()['IamAccountExperience'] = IamAccountExperience
    globals()['IamApiKey'] = IamApiKey
    globals()['IamAppRegistration'] = IamAppRegistration
    globals()['IamBannerMessage'] = IamBannerMessage
    globals()['IamCertificate'] = IamCertificate
    globals()['IamCertificateRequest'] = IamCertificateRequest
    globals()['IamDomainGroup'] = IamDomainGroup
    globals()['IamEndPointPrivilege'] = IamEndPointPrivilege
    globals()['IamEndPointRole'] = IamEndPointRole
    globals()['IamEndPointUser'] = IamEndPointUser
    globals()['IamEndPointUserPolicy'] = IamEndPointUserPolicy
    globals()['IamEndPointUserRole'] = IamEndPointUserRole
    globals()['IamIdp'] = IamIdp
    globals()['IamIdpReference'] = IamIdpReference
    globals()['IamIpAccessManagement'] = IamIpAccessManagement
    globals()['IamIpAddress'] = IamIpAddress
    globals()['IamLdapGroup'] = IamLdapGroup
    globals()['IamLdapPolicy'] = IamLdapPolicy
    globals()['IamLdapProvider'] = IamLdapProvider
    globals()['IamLocalUserPassword'] = IamLocalUserPassword
    globals()['IamLocalUserPasswordPolicy'] = IamLocalUserPasswordPolicy
    globals()['IamOAuthToken'] = IamOAuthToken
    globals()['IamPermission'] = IamPermission
    globals()['IamPrivateKeySpec'] = IamPrivateKeySpec
    globals()['IamPrivilege'] = IamPrivilege
    globals()['IamPrivilegeSet'] = IamPrivilegeSet
    globals()['IamQualifier'] = IamQualifier
    globals()['IamResourceLimits'] = IamResourceLimits
    globals()['IamResourcePermission'] = IamResourcePermission
    globals()['IamResourceRoles'] = IamResourceRoles
    globals()['IamRole'] = IamRole
    globals()['IamSecurityHolder'] = IamSecurityHolder
    globals()['IamServiceProvider'] = IamServiceProvider
    globals()['IamSession'] = IamSession
    globals()['IamSessionLimits'] = IamSessionLimits
    globals()['IamSystem'] = IamSystem
    globals()['IamTrustPoint'] = IamTrustPoint
    globals()['IamUser'] = IamUser
    globals()['IamUserGroup'] = IamUserGroup
    globals()['IamUserPreference'] = IamUserPreference
    globals()['InventoryBase'] = InventoryBase
    globals()['InventoryDeviceInfo'] = InventoryDeviceInfo
    globals()['InventoryDnMoBinding'] = InventoryDnMoBinding
    globals()['InventoryGenericInventory'] = InventoryGenericInventory
    globals()['InventoryGenericInventoryHolder'] = InventoryGenericInventoryHolder
    globals()['InventoryRequest'] = InventoryRequest
    globals()['IpmioverlanPolicy'] = IpmioverlanPolicy
    globals()['IppoolBlockLease'] = IppoolBlockLease
    globals()['IppoolIpLease'] = IppoolIpLease
    globals()['IppoolPool'] = IppoolPool
    globals()['IppoolPoolMember'] = IppoolPoolMember
    globals()['IppoolShadowBlock'] = IppoolShadowBlock
    globals()['IppoolShadowPool'] = IppoolShadowPool
    globals()['IppoolUniverse'] = IppoolUniverse
    globals()['IqnpoolBlock'] = IqnpoolBlock
    globals()['IqnpoolLease'] = IqnpoolLease
    globals()['IqnpoolPool'] = IqnpoolPool
    globals()['IqnpoolPoolMember'] = IqnpoolPoolMember
    globals()['IqnpoolUniverse'] = IqnpoolUniverse
    globals()['IwotenantTenantStatus'] = IwotenantTenantStatus
    globals()['KubernetesAbstractDaemonSet'] = KubernetesAbstractDaemonSet
    globals()['KubernetesAbstractDeployment'] = KubernetesAbstractDeployment
    globals()['KubernetesAbstractIngress'] = KubernetesAbstractIngress
    globals()['KubernetesAbstractNode'] = KubernetesAbstractNode
    globals()['KubernetesAbstractPod'] = KubernetesAbstractPod
    globals()['KubernetesAbstractService'] = KubernetesAbstractService
    globals()['KubernetesAbstractStatefulSet'] = KubernetesAbstractStatefulSet
    globals()['KubernetesAciCniApic'] = KubernetesAciCniApic
    globals()['KubernetesAciCniProfile'] = KubernetesAciCniProfile
    globals()['KubernetesAciCniTenantClusterAllocation'] = KubernetesAciCniTenantClusterAllocation
    globals()['KubernetesAddonDefinition'] = KubernetesAddonDefinition
    globals()['KubernetesAddonPolicy'] = KubernetesAddonPolicy
    globals()['KubernetesAddonRepository'] = KubernetesAddonRepository
    globals()['KubernetesBaremetalNodeProfile'] = KubernetesBaremetalNodeProfile
    globals()['KubernetesBaseInfrastructureProvider'] = KubernetesBaseInfrastructureProvider
    globals()['KubernetesCatalog'] = KubernetesCatalog
    globals()['KubernetesCluster'] = KubernetesCluster
    globals()['KubernetesClusterAddonProfile'] = KubernetesClusterAddonProfile
    globals()['KubernetesClusterProfile'] = KubernetesClusterProfile
    globals()['KubernetesConfigResult'] = KubernetesConfigResult
    globals()['KubernetesConfigResultEntry'] = KubernetesConfigResultEntry
    globals()['KubernetesContainerRuntimePolicy'] = KubernetesContainerRuntimePolicy
    globals()['KubernetesDaemonSet'] = KubernetesDaemonSet
    globals()['KubernetesDeployment'] = KubernetesDeployment
    globals()['KubernetesIngress'] = KubernetesIngress
    globals()['KubernetesKubernetesResource'] = KubernetesKubernetesResource
    globals()['KubernetesNetworkPolicy'] = KubernetesNetworkPolicy
    globals()['KubernetesNode'] = KubernetesNode
    globals()['KubernetesNodeGroupProfile'] = KubernetesNodeGroupProfile
    globals()['KubernetesNodeProfile'] = KubernetesNodeProfile
    globals()['KubernetesPod'] = KubernetesPod
    globals()['KubernetesService'] = KubernetesService
    globals()['KubernetesStatefulSet'] = KubernetesStatefulSet
    globals()['KubernetesSysConfigPolicy'] = KubernetesSysConfigPolicy
    globals()['KubernetesTrustedRegistriesPolicy'] = KubernetesTrustedRegistriesPolicy
    globals()['KubernetesVersion'] = KubernetesVersion
    globals()['KubernetesVersionPolicy'] = KubernetesVersionPolicy
    globals()['KubernetesVirtualMachineInfraConfigPolicy'] = KubernetesVirtualMachineInfraConfigPolicy
    globals()['KubernetesVirtualMachineInfrastructureProvider'] = KubernetesVirtualMachineInfrastructureProvider
    globals()['KubernetesVirtualMachineInstanceType'] = KubernetesVirtualMachineInstanceType
    globals()['KubernetesVirtualMachineNodeProfile'] = KubernetesVirtualMachineNodeProfile
    globals()['KvmPolicy'] = KvmPolicy
    globals()['KvmSession'] = KvmSession
    globals()['KvmTunnel'] = KvmTunnel
    globals()['LicenseAccountLicenseData'] = LicenseAccountLicenseData
    globals()['LicenseCustomerOp'] = LicenseCustomerOp
    globals()['LicenseIwoCustomerOp'] = LicenseIwoCustomerOp
    globals()['LicenseIwoLicenseCount'] = LicenseIwoLicenseCount
    globals()['LicenseLicenseInfo'] = LicenseLicenseInfo
    globals()['LicenseLicenseReservationOp'] = LicenseLicenseReservationOp
    globals()['LicenseSmartlicenseToken'] = LicenseSmartlicenseToken
    globals()['LsServiceProfile'] = LsServiceProfile
    globals()['MacpoolIdBlock'] = MacpoolIdBlock
    globals()['MacpoolLease'] = MacpoolLease
    globals()['MacpoolPool'] = MacpoolPool
    globals()['MacpoolPoolMember'] = MacpoolPoolMember
    globals()['MacpoolUniverse'] = MacpoolUniverse
    globals()['ManagementController'] = ManagementController
    globals()['ManagementEntity'] = ManagementEntity
    globals()['ManagementInterface'] = ManagementInterface
    globals()['MemoryAbstractUnit'] = MemoryAbstractUnit
    globals()['MemoryArray'] = MemoryArray
    globals()['MemoryPersistentMemoryConfigResult'] = MemoryPersistentMemoryConfigResult
    globals()['MemoryPersistentMemoryConfiguration'] = MemoryPersistentMemoryConfiguration
    globals()['MemoryPersistentMemoryNamespace'] = MemoryPersistentMemoryNamespace
    globals()['MemoryPersistentMemoryNamespaceConfigResult'] = MemoryPersistentMemoryNamespaceConfigResult
    globals()['MemoryPersistentMemoryPolicy'] = MemoryPersistentMemoryPolicy
    globals()['MemoryPersistentMemoryRegion'] = MemoryPersistentMemoryRegion
    globals()['MemoryPersistentMemoryUnit'] = MemoryPersistentMemoryUnit
    globals()['MemoryUnit'] = MemoryUnit
    globals()['MetaDefinition'] = MetaDefinition
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['MoTag'] = MoTag
    globals()['MoVersionContext'] = MoVersionContext
    globals()['NetworkElement'] = NetworkElement
    globals()['NetworkElementSummary'] = NetworkElementSummary
    globals()['NetworkFcZoneInfo'] = NetworkFcZoneInfo
    globals()['NetworkVlanPortInfo'] = NetworkVlanPortInfo
    globals()['NetworkconfigPolicy'] = NetworkconfigPolicy
    globals()['NiaapiApicCcoPost'] = NiaapiApicCcoPost
    globals()['NiaapiApicFieldNotice'] = NiaapiApicFieldNotice
    globals()['NiaapiApicHweol'] = NiaapiApicHweol
    globals()['NiaapiApicLatestMaintainedRelease'] = NiaapiApicLatestMaintainedRelease
    globals()['NiaapiApicReleaseRecommend'] = NiaapiApicReleaseRecommend
    globals()['NiaapiApicSweol'] = NiaapiApicSweol
    globals()['NiaapiDcnmCcoPost'] = NiaapiDcnmCcoPost
    globals()['NiaapiDcnmFieldNotice'] = NiaapiDcnmFieldNotice
    globals()['NiaapiDcnmHweol'] = NiaapiDcnmHweol
    globals()['NiaapiDcnmLatestMaintainedRelease'] = NiaapiDcnmLatestMaintainedRelease
    globals()['NiaapiDcnmReleaseRecommend'] = NiaapiDcnmReleaseRecommend
    globals()['NiaapiDcnmSweol'] = NiaapiDcnmSweol
    globals()['NiaapiFieldNotice'] = NiaapiFieldNotice
    globals()['NiaapiFileDownloader'] = NiaapiFileDownloader
    globals()['NiaapiHardwareEol'] = NiaapiHardwareEol
    globals()['NiaapiMaintainedRelease'] = NiaapiMaintainedRelease
    globals()['NiaapiNewReleasePost'] = NiaapiNewReleasePost
    globals()['NiaapiNiaMetadata'] = NiaapiNiaMetadata
    globals()['NiaapiNibFileDownloader'] = NiaapiNibFileDownloader
    globals()['NiaapiNibMetadata'] = NiaapiNibMetadata
    globals()['NiaapiReleaseRecommend'] = NiaapiReleaseRecommend
    globals()['NiaapiSoftwareEol'] = NiaapiSoftwareEol
    globals()['NiaapiVersionRegex'] = NiaapiVersionRegex
    globals()['NiatelemetryAaaLdapProviderDetails'] = NiatelemetryAaaLdapProviderDetails
    globals()['NiatelemetryAaaRadiusProviderDetails'] = NiatelemetryAaaRadiusProviderDetails
    globals()['NiatelemetryAaaTacacsProviderDetails'] = NiatelemetryAaaTacacsProviderDetails
    globals()['NiatelemetryApicAppPluginDetails'] = NiatelemetryApicAppPluginDetails
    globals()['NiatelemetryApicCoreFileDetails'] = NiatelemetryApicCoreFileDetails
    globals()['NiatelemetryApicDbgexpRsExportDest'] = NiatelemetryApicDbgexpRsExportDest
    globals()['NiatelemetryApicDbgexpRsTsScheduler'] = NiatelemetryApicDbgexpRsTsScheduler
    globals()['NiatelemetryApicFanDetails'] = NiatelemetryApicFanDetails
    globals()['NiatelemetryApicFexDetails'] = NiatelemetryApicFexDetails
    globals()['NiatelemetryApicFlashDetails'] = NiatelemetryApicFlashDetails
    globals()['NiatelemetryApicNtpAuth'] = NiatelemetryApicNtpAuth
    globals()['NiatelemetryApicPsuDetails'] = NiatelemetryApicPsuDetails
    globals()['NiatelemetryApicRealmDetails'] = NiatelemetryApicRealmDetails
    globals()['NiatelemetryApicSnmpClientGrpDetails'] = NiatelemetryApicSnmpClientGrpDetails
    globals()['NiatelemetryApicSnmpCommunityAccessDetails'] = NiatelemetryApicSnmpCommunityAccessDetails
    globals()['NiatelemetryApicSnmpCommunityDetails'] = NiatelemetryApicSnmpCommunityDetails
    globals()['NiatelemetryApicSnmpTrapDetails'] = NiatelemetryApicSnmpTrapDetails
    globals()['NiatelemetryApicSnmpTrapFwdServerDetails'] = NiatelemetryApicSnmpTrapFwdServerDetails
    globals()['NiatelemetryApicSnmpVersionThreeDetails'] = NiatelemetryApicSnmpVersionThreeDetails
    globals()['NiatelemetryApicSysLogGrp'] = NiatelemetryApicSysLogGrp
    globals()['NiatelemetryApicSysLogSrc'] = NiatelemetryApicSysLogSrc
    globals()['NiatelemetryApicTransceiverDetails'] = NiatelemetryApicTransceiverDetails
    globals()['NiatelemetryApicUiPageCounts'] = NiatelemetryApicUiPageCounts
    globals()['NiatelemetryAppDetails'] = NiatelemetryAppDetails
    globals()['NiatelemetryCommonPolicies'] = NiatelemetryCommonPolicies
    globals()['NiatelemetryDcnmFanDetails'] = NiatelemetryDcnmFanDetails
    globals()['NiatelemetryDcnmFexDetails'] = NiatelemetryDcnmFexDetails
    globals()['NiatelemetryDcnmModuleDetails'] = NiatelemetryDcnmModuleDetails
    globals()['NiatelemetryDcnmPsuDetails'] = NiatelemetryDcnmPsuDetails
    globals()['NiatelemetryDcnmTransceiverDetails'] = NiatelemetryDcnmTransceiverDetails
    globals()['NiatelemetryEpg'] = NiatelemetryEpg
    globals()['NiatelemetryFabricModuleDetails'] = NiatelemetryFabricModuleDetails
    globals()['NiatelemetryFabricPodProfile'] = NiatelemetryFabricPodProfile
    globals()['NiatelemetryFabricPodSs'] = NiatelemetryFabricPodSs
    globals()['NiatelemetryFault'] = NiatelemetryFault
    globals()['NiatelemetryHttpsAclContractDetails'] = NiatelemetryHttpsAclContractDetails
    globals()['NiatelemetryHttpsAclContractFilterMap'] = NiatelemetryHttpsAclContractFilterMap
    globals()['NiatelemetryHttpsAclEpgContractMap'] = NiatelemetryHttpsAclEpgContractMap
    globals()['NiatelemetryHttpsAclEpgDetails'] = NiatelemetryHttpsAclEpgDetails
    globals()['NiatelemetryHttpsAclFilterDetails'] = NiatelemetryHttpsAclFilterDetails
    globals()['NiatelemetryLc'] = NiatelemetryLc
    globals()['NiatelemetryMsoContractDetails'] = NiatelemetryMsoContractDetails
    globals()['NiatelemetryMsoEpgDetails'] = NiatelemetryMsoEpgDetails
    globals()['NiatelemetryMsoSchemaDetails'] = NiatelemetryMsoSchemaDetails
    globals()['NiatelemetryMsoSiteDetails'] = NiatelemetryMsoSiteDetails
    globals()['NiatelemetryMsoTenantDetails'] = NiatelemetryMsoTenantDetails
    globals()['NiatelemetryNexusDashboardControllerDetails'] = NiatelemetryNexusDashboardControllerDetails
    globals()['NiatelemetryNexusDashboardDetails'] = NiatelemetryNexusDashboardDetails
    globals()['NiatelemetryNexusDashboardMemoryDetails'] = NiatelemetryNexusDashboardMemoryDetails
    globals()['NiatelemetryNexusDashboards'] = NiatelemetryNexusDashboards
    globals()['NiatelemetryNiaFeatureUsage'] = NiatelemetryNiaFeatureUsage
    globals()['NiatelemetryNiaInventory'] = NiatelemetryNiaInventory
    globals()['NiatelemetryNiaInventoryDcnm'] = NiatelemetryNiaInventoryDcnm
    globals()['NiatelemetryNiaInventoryFabric'] = NiatelemetryNiaInventoryFabric
    globals()['NiatelemetryNiaLicenseState'] = NiatelemetryNiaLicenseState
    globals()['NiatelemetryPasswordStrengthCheck'] = NiatelemetryPasswordStrengthCheck
    globals()['NiatelemetryPodCommPolicies'] = NiatelemetryPodCommPolicies
    globals()['NiatelemetryPodSnmpPolicies'] = NiatelemetryPodSnmpPolicies
    globals()['NiatelemetryPodTimeServerPolicies'] = NiatelemetryPodTimeServerPolicies
    globals()['NiatelemetrySiteInventory'] = NiatelemetrySiteInventory
    globals()['NiatelemetrySnmpSrc'] = NiatelemetrySnmpSrc
    globals()['NiatelemetrySshVersionTwo'] = NiatelemetrySshVersionTwo
    globals()['NiatelemetrySupervisorModuleDetails'] = NiatelemetrySupervisorModuleDetails
    globals()['NiatelemetrySyslogRemoteDest'] = NiatelemetrySyslogRemoteDest
    globals()['NiatelemetrySyslogSysMsg'] = NiatelemetrySyslogSysMsg
    globals()['NiatelemetrySyslogSysMsgFacFilter'] = NiatelemetrySyslogSysMsgFacFilter
    globals()['NiatelemetrySystemControllerDetails'] = NiatelemetrySystemControllerDetails
    globals()['NiatelemetryTenant'] = NiatelemetryTenant
    globals()['NotificationAccountSubscription'] = NotificationAccountSubscription
    globals()['NotificationSubscription'] = NotificationSubscription
    globals()['NtpPolicy'] = NtpPolicy
    globals()['OprsDeployment'] = OprsDeployment
    globals()['OprsSyncTargetListMessage'] = OprsSyncTargetListMessage
    globals()['OrganizationOrganization'] = OrganizationOrganization
    globals()['OsBaseInstallConfig'] = OsBaseInstallConfig
    globals()['OsBulkInstallInfo'] = OsBulkInstallInfo
    globals()['OsCatalog'] = OsCatalog
    globals()['OsConfigurationFile'] = OsConfigurationFile
    globals()['OsDistribution'] = OsDistribution
    globals()['OsInstall'] = OsInstall
    globals()['OsOsSupport'] = OsOsSupport
    globals()['OsSupportedVersion'] = OsSupportedVersion
    globals()['OsTemplateFile'] = OsTemplateFile
    globals()['OsValidInstallTarget'] = OsValidInstallTarget
    globals()['PciCoprocessorCard'] = PciCoprocessorCard
    globals()['PciDevice'] = PciDevice
    globals()['PciLink'] = PciLink
    globals()['PciSwitch'] = PciSwitch
    globals()['PolicyAbstractConfigChangeDetail'] = PolicyAbstractConfigChangeDetail
    globals()['PolicyAbstractConfigProfile'] = PolicyAbstractConfigProfile
    globals()['PolicyAbstractConfigResult'] = PolicyAbstractConfigResult
    globals()['PolicyAbstractConfigResultEntry'] = PolicyAbstractConfigResultEntry
    globals()['PolicyAbstractPolicy'] = PolicyAbstractPolicy
    globals()['PolicyAbstractProfile'] = PolicyAbstractProfile
    globals()['PolicyinventoryAbstractDeviceInfo'] = PolicyinventoryAbstractDeviceInfo
    globals()['PoolAbstractBlock'] = PoolAbstractBlock
    globals()['PoolAbstractBlockLease'] = PoolAbstractBlockLease
    globals()['PoolAbstractLease'] = PoolAbstractLease
    globals()['PoolAbstractPool'] = PoolAbstractPool
    globals()['PoolAbstractPoolMember'] = PoolAbstractPoolMember
    globals()['PortGroup'] = PortGroup
    globals()['PortInterfaceBase'] = PortInterfaceBase
    globals()['PortMacBinding'] = PortMacBinding
    globals()['PortPhysical'] = PortPhysical
    globals()['PortSubGroup'] = PortSubGroup
    globals()['PowerControlState'] = PowerControlState
    globals()['PowerPolicy'] = PowerPolicy
    globals()['ProcessorUnit'] = ProcessorUnit
    globals()['RackUnitPersonality'] = RackUnitPersonality
    globals()['RecommendationAbstractItem'] = RecommendationAbstractItem
    globals()['RecommendationBase'] = RecommendationBase
    globals()['RecommendationCapacityRunway'] = RecommendationCapacityRunway
    globals()['RecommendationPhysicalItem'] = RecommendationPhysicalItem
    globals()['RecoveryAbstractBackupConfig'] = RecoveryAbstractBackupConfig
    globals()['RecoveryAbstractBackupInfo'] = RecoveryAbstractBackupInfo
    globals()['RecoveryBackupConfigPolicy'] = RecoveryBackupConfigPolicy
    globals()['RecoveryBackupProfile'] = RecoveryBackupProfile
    globals()['RecoveryConfigResult'] = RecoveryConfigResult
    globals()['RecoveryConfigResultEntry'] = RecoveryConfigResultEntry
    globals()['RecoveryOnDemandBackup'] = RecoveryOnDemandBackup
    globals()['RecoveryRestore'] = RecoveryRestore
    globals()['RecoveryScheduleConfigPolicy'] = RecoveryScheduleConfigPolicy
    globals()['ResourceGroup'] = ResourceGroup
    globals()['ResourceGroupMember'] = ResourceGroupMember
    globals()['ResourceLicenseResourceCount'] = ResourceLicenseResourceCount
    globals()['ResourceMembership'] = ResourceMembership
    globals()['ResourceMembershipHolder'] = ResourceMembershipHolder
    globals()['ResourceReservation'] = ResourceReservation
    globals()['ResourcepoolLease'] = ResourcepoolLease
    globals()['ResourcepoolLeaseResource'] = ResourcepoolLeaseResource
    globals()['ResourcepoolPool'] = ResourcepoolPool
    globals()['ResourcepoolPoolMember'] = ResourcepoolPoolMember
    globals()['ResourcepoolUniverse'] = ResourcepoolUniverse
    globals()['RproxyReverseProxy'] = RproxyReverseProxy
    globals()['SdcardPolicy'] = SdcardPolicy
    globals()['SdwanProfile'] = SdwanProfile
    globals()['SdwanRouterNode'] = SdwanRouterNode
    globals()['SdwanRouterPolicy'] = SdwanRouterPolicy
    globals()['SdwanVmanageAccountPolicy'] = SdwanVmanageAccountPolicy
    globals()['SearchSearchItem'] = SearchSearchItem
    globals()['SearchTagItem'] = SearchTagItem
    globals()['SecurityUnit'] = SecurityUnit
    globals()['ServerBaseProfile'] = ServerBaseProfile
    globals()['ServerConfigChangeDetail'] = ServerConfigChangeDetail
    globals()['ServerConfigImport'] = ServerConfigImport
    globals()['ServerConfigResult'] = ServerConfigResult
    globals()['ServerConfigResultEntry'] = ServerConfigResultEntry
    globals()['ServerProfile'] = ServerProfile
    globals()['ServerProfileTemplate'] = ServerProfileTemplate
    globals()['SessionAbstractSession'] = SessionAbstractSession
    globals()['SessionAbstractSubSession'] = SessionAbstractSubSession
    globals()['SmtpPolicy'] = SmtpPolicy
    globals()['SnmpPolicy'] = SnmpPolicy
    globals()['SoftwareApplianceDistributable'] = SoftwareApplianceDistributable
    globals()['SoftwareDownloadHistory'] = SoftwareDownloadHistory
    globals()['SoftwareHclMeta'] = SoftwareHclMeta
    globals()['SoftwareHyperflexBundleDistributable'] = SoftwareHyperflexBundleDistributable
    globals()['SoftwareHyperflexDistributable'] = SoftwareHyperflexDistributable
    globals()['SoftwareReleaseMeta'] = SoftwareReleaseMeta
    globals()['SoftwareSolutionDistributable'] = SoftwareSolutionDistributable
    globals()['SoftwareUcsdBundleDistributable'] = SoftwareUcsdBundleDistributable
    globals()['SoftwareUcsdDistributable'] = SoftwareUcsdDistributable
    globals()['SoftwarerepositoryAuthorization'] = SoftwarerepositoryAuthorization
    globals()['SoftwarerepositoryCachedImage'] = SoftwarerepositoryCachedImage
    globals()['SoftwarerepositoryCatalog'] = SoftwarerepositoryCatalog
    globals()['SoftwarerepositoryCategoryMapper'] = SoftwarerepositoryCategoryMapper
    globals()['SoftwarerepositoryCategoryMapperModel'] = SoftwarerepositoryCategoryMapperModel
    globals()['SoftwarerepositoryCategorySupportConstraint'] = SoftwarerepositoryCategorySupportConstraint
    globals()['SoftwarerepositoryDownloadSpec'] = SoftwarerepositoryDownloadSpec
    globals()['SoftwarerepositoryFile'] = SoftwarerepositoryFile
    globals()['SoftwarerepositoryOperatingSystemFile'] = SoftwarerepositoryOperatingSystemFile
    globals()['SoftwarerepositoryRelease'] = SoftwarerepositoryRelease
    globals()['SolPolicy'] = SolPolicy
    globals()['SshPolicy'] = SshPolicy
    globals()['StorageBaseArray'] = StorageBaseArray
    globals()['StorageBaseArrayController'] = StorageBaseArrayController
    globals()['StorageBaseArrayDisk'] = StorageBaseArrayDisk
    globals()['StorageBaseDiskPool'] = StorageBaseDiskPool
    globals()['StorageBaseHost'] = StorageBaseHost
    globals()['StorageBaseHostGroup'] = StorageBaseHostGroup
    globals()['StorageBaseHostLun'] = StorageBaseHostLun
    globals()['StorageBaseNfsExport'] = StorageBaseNfsExport
    globals()['StorageBasePhysicalPort'] = StorageBasePhysicalPort
    globals()['StorageBaseProtectionGroup'] = StorageBaseProtectionGroup
    globals()['StorageBaseProtectionGroupSnapshot'] = StorageBaseProtectionGroupSnapshot
    globals()['StorageBaseRaidGroup'] = StorageBaseRaidGroup
    globals()['StorageBaseReplicationSchedule'] = StorageBaseReplicationSchedule
    globals()['StorageBaseSnapshot'] = StorageBaseSnapshot
    globals()['StorageBaseSnapshotSchedule'] = StorageBaseSnapshotSchedule
    globals()['StorageBaseStorageContainer'] = StorageBaseStorageContainer
    globals()['StorageBaseTenant'] = StorageBaseTenant
    globals()['StorageBaseVolume'] = StorageBaseVolume
    globals()['StorageController'] = StorageController
    globals()['StorageDiskGroup'] = StorageDiskGroup
    globals()['StorageDiskSlot'] = StorageDiskSlot
    globals()['StorageDriveGroup'] = StorageDriveGroup
    globals()['StorageEnclosure'] = StorageEnclosure
    globals()['StorageEnclosureDisk'] = StorageEnclosureDisk
    globals()['StorageEnclosureDiskSlotEp'] = StorageEnclosureDiskSlotEp
    globals()['StorageFlexFlashController'] = StorageFlexFlashController
    globals()['StorageFlexFlashControllerProps'] = StorageFlexFlashControllerProps
    globals()['StorageFlexFlashPhysicalDrive'] = StorageFlexFlashPhysicalDrive
    globals()['StorageFlexFlashVirtualDrive'] = StorageFlexFlashVirtualDrive
    globals()['StorageFlexUtilController'] = StorageFlexUtilController
    globals()['StorageFlexUtilPhysicalDrive'] = StorageFlexUtilPhysicalDrive
    globals()['StorageFlexUtilVirtualDrive'] = StorageFlexUtilVirtualDrive
    globals()['StorageHitachiArray'] = StorageHitachiArray
    globals()['StorageHitachiController'] = StorageHitachiController
    globals()['StorageHitachiDisk'] = StorageHitachiDisk
    globals()['StorageHitachiHost'] = StorageHitachiHost
    globals()['StorageHitachiHostLun'] = StorageHitachiHostLun
    globals()['StorageHitachiParityGroup'] = StorageHitachiParityGroup
    globals()['StorageHitachiPool'] = StorageHitachiPool
    globals()['StorageHitachiPort'] = StorageHitachiPort
    globals()['StorageHitachiVolume'] = StorageHitachiVolume
    globals()['StorageHyperFlexStorageContainer'] = StorageHyperFlexStorageContainer
    globals()['StorageHyperFlexVolume'] = StorageHyperFlexVolume
    globals()['StorageItem'] = StorageItem
    globals()['StorageNetAppAggregate'] = StorageNetAppAggregate
    globals()['StorageNetAppBaseDisk'] = StorageNetAppBaseDisk
    globals()['StorageNetAppCluster'] = StorageNetAppCluster
    globals()['StorageNetAppEthernetPort'] = StorageNetAppEthernetPort
    globals()['StorageNetAppExportPolicy'] = StorageNetAppExportPolicy
    globals()['StorageNetAppFcInterface'] = StorageNetAppFcInterface
    globals()['StorageNetAppFcPort'] = StorageNetAppFcPort
    globals()['StorageNetAppInitiatorGroup'] = StorageNetAppInitiatorGroup
    globals()['StorageNetAppIpInterface'] = StorageNetAppIpInterface
    globals()['StorageNetAppLicense'] = StorageNetAppLicense
    globals()['StorageNetAppLun'] = StorageNetAppLun
    globals()['StorageNetAppLunMap'] = StorageNetAppLunMap
    globals()['StorageNetAppNode'] = StorageNetAppNode
    globals()['StorageNetAppNtpServer'] = StorageNetAppNtpServer
    globals()['StorageNetAppSensor'] = StorageNetAppSensor
    globals()['StorageNetAppStorageVm'] = StorageNetAppStorageVm
    globals()['StorageNetAppVolume'] = StorageNetAppVolume
    globals()['StorageNetAppVolumeSnapshot'] = StorageNetAppVolumeSnapshot
    globals()['StoragePhysicalDisk'] = StoragePhysicalDisk
    globals()['StoragePhysicalDiskExtension'] = StoragePhysicalDiskExtension
    globals()['StoragePhysicalDiskUsage'] = StoragePhysicalDiskUsage
    globals()['StoragePureArray'] = StoragePureArray
    globals()['StoragePureController'] = StoragePureController
    globals()['StoragePureDisk'] = StoragePureDisk
    globals()['StoragePureHost'] = StoragePureHost
    globals()['StoragePureHostGroup'] = StoragePureHostGroup
    globals()['StoragePureHostLun'] = StoragePureHostLun
    globals()['StoragePurePort'] = StoragePurePort
    globals()['StoragePureProtectionGroup'] = StoragePureProtectionGroup
    globals()['StoragePureProtectionGroupSnapshot'] = StoragePureProtectionGroupSnapshot
    globals()['StoragePureReplicationSchedule'] = StoragePureReplicationSchedule
    globals()['StoragePureSnapshotSchedule'] = StoragePureSnapshotSchedule
    globals()['StoragePureVolume'] = StoragePureVolume
    globals()['StoragePureVolumeSnapshot'] = StoragePureVolumeSnapshot
    globals()['StorageSasExpander'] = StorageSasExpander
    globals()['StorageSasPort'] = StorageSasPort
    globals()['StorageSpan'] = StorageSpan
    globals()['StorageStoragePolicy'] = StorageStoragePolicy
    globals()['StorageVdMemberEp'] = StorageVdMemberEp
    globals()['StorageVirtualDrive'] = StorageVirtualDrive
    globals()['StorageVirtualDriveContainer'] = StorageVirtualDriveContainer
    globals()['StorageVirtualDriveExtension'] = StorageVirtualDriveExtension
    globals()['StorageVirtualDriveIdentity'] = StorageVirtualDriveIdentity
    globals()['SyslogPolicy'] = SyslogPolicy
    globals()['TamAdvisoryCount'] = TamAdvisoryCount
    globals()['TamAdvisoryDefinition'] = TamAdvisoryDefinition
    globals()['TamAdvisoryInfo'] = TamAdvisoryInfo
    globals()['TamAdvisoryInstance'] = TamAdvisoryInstance
    globals()['TamBaseAdvisory'] = TamBaseAdvisory
    globals()['TamSecurityAdvisory'] = TamSecurityAdvisory
    globals()['TaskHitachiScopedInventory'] = TaskHitachiScopedInventory
    globals()['TaskHxapScopedInventory'] = TaskHxapScopedInventory
    globals()['TaskNetAppScopedInventory'] = TaskNetAppScopedInventory
    globals()['TaskPublicCloudScopedInventory'] = TaskPublicCloudScopedInventory
    globals()['TaskPureScopedInventory'] = TaskPureScopedInventory
    globals()['TaskServerScopedInventory'] = TaskServerScopedInventory
    globals()['TechsupportmanagementCollectionControlPolicy'] = TechsupportmanagementCollectionControlPolicy
    globals()['TechsupportmanagementDownload'] = TechsupportmanagementDownload
    globals()['TechsupportmanagementTechSupportBundle'] = TechsupportmanagementTechSupportBundle
    globals()['TechsupportmanagementTechSupportStatus'] = TechsupportmanagementTechSupportStatus
    globals()['TerminalAuditLog'] = TerminalAuditLog
    globals()['TerraformExecutor'] = TerraformExecutor
    globals()['ThermalPolicy'] = ThermalPolicy
    globals()['TopSystem'] = TopSystem
    globals()['TunnelingTunnel'] = TunnelingTunnel
    globals()['UcsdBackupInfo'] = UcsdBackupInfo
    globals()['UuidpoolBlock'] = UuidpoolBlock
    globals()['UuidpoolPool'] = UuidpoolPool
    globals()['UuidpoolPoolMember'] = UuidpoolPoolMember
    globals()['UuidpoolUniverse'] = UuidpoolUniverse
    globals()['UuidpoolUuidLease'] = UuidpoolUuidLease
    globals()['ViewsView'] = ViewsView
    globals()['VirtualizationBaseCluster'] = VirtualizationBaseCluster
    globals()['VirtualizationBaseDatacenter'] = VirtualizationBaseDatacenter
    globals()['VirtualizationBaseDatastore'] = VirtualizationBaseDatastore
    globals()['VirtualizationBaseDatastoreCluster'] = VirtualizationBaseDatastoreCluster
    globals()['VirtualizationBaseDistributedNetwork'] = VirtualizationBaseDistributedNetwork
    globals()['VirtualizationBaseDistributedSwitch'] = VirtualizationBaseDistributedSwitch
    globals()['VirtualizationBaseDvswitch'] = VirtualizationBaseDvswitch
    globals()['VirtualizationBaseFolder'] = VirtualizationBaseFolder
    globals()['VirtualizationBaseHost'] = VirtualizationBaseHost
    globals()['VirtualizationBaseHypervisorManager'] = VirtualizationBaseHypervisorManager
    globals()['VirtualizationBaseKernelNetwork'] = VirtualizationBaseKernelNetwork
    globals()['VirtualizationBaseNetwork'] = VirtualizationBaseNetwork
    globals()['VirtualizationBasePhysicalNetworkInterface'] = VirtualizationBasePhysicalNetworkInterface
    globals()['VirtualizationBasePlacement'] = VirtualizationBasePlacement
    globals()['VirtualizationBaseSourceDevice'] = VirtualizationBaseSourceDevice
    globals()['VirtualizationBaseSwitch'] = VirtualizationBaseSwitch
    globals()['VirtualizationBaseVirtualDisk'] = VirtualizationBaseVirtualDisk
    globals()['VirtualizationBaseVirtualMachine'] = VirtualizationBaseVirtualMachine
    globals()['VirtualizationBaseVirtualMachineSnapshot'] = VirtualizationBaseVirtualMachineSnapshot
    globals()['VirtualizationBaseVirtualNetwork'] = VirtualizationBaseVirtualNetwork
    globals()['VirtualizationBaseVirtualNetworkInterface'] = VirtualizationBaseVirtualNetworkInterface
    globals()['VirtualizationBaseVirtualNetworkInterfaceCard'] = VirtualizationBaseVirtualNetworkInterfaceCard
    globals()['VirtualizationBaseVirtualSwitch'] = VirtualizationBaseVirtualSwitch
    globals()['VirtualizationBaseVswitch'] = VirtualizationBaseVswitch
    globals()['VirtualizationHost'] = VirtualizationHost
    globals()['VirtualizationVirtualDisk'] = VirtualizationVirtualDisk
    globals()['VirtualizationVirtualMachine'] = VirtualizationVirtualMachine
    globals()['VirtualizationVirtualNetwork'] = VirtualizationVirtualNetwork
    globals()['VirtualizationVmwareCluster'] = VirtualizationVmwareCluster
    globals()['VirtualizationVmwareDatacenter'] = VirtualizationVmwareDatacenter
    globals()['VirtualizationVmwareDatastore'] = VirtualizationVmwareDatastore
    globals()['VirtualizationVmwareDatastoreCluster'] = VirtualizationVmwareDatastoreCluster
    globals()['VirtualizationVmwareDistributedNetwork'] = VirtualizationVmwareDistributedNetwork
    globals()['VirtualizationVmwareDistributedSwitch'] = VirtualizationVmwareDistributedSwitch
    globals()['VirtualizationVmwareFolder'] = VirtualizationVmwareFolder
    globals()['VirtualizationVmwareHost'] = VirtualizationVmwareHost
    globals()['VirtualizationVmwareKernelNetwork'] = VirtualizationVmwareKernelNetwork
    globals()['VirtualizationVmwareNetwork'] = VirtualizationVmwareNetwork
    globals()['VirtualizationVmwarePhysicalNetworkInterface'] = VirtualizationVmwarePhysicalNetworkInterface
    globals()['VirtualizationVmwareUplinkPort'] = VirtualizationVmwareUplinkPort
    globals()['VirtualizationVmwareVcenter'] = VirtualizationVmwareVcenter
    globals()['VirtualizationVmwareVirtualDisk'] = VirtualizationVmwareVirtualDisk
    globals()['VirtualizationVmwareVirtualMachine'] = VirtualizationVmwareVirtualMachine
    globals()['VirtualizationVmwareVirtualMachineSnapshot'] = VirtualizationVmwareVirtualMachineSnapshot
    globals()['VirtualizationVmwareVirtualNetworkInterface'] = VirtualizationVmwareVirtualNetworkInterface
    globals()['VirtualizationVmwareVirtualSwitch'] = VirtualizationVmwareVirtualSwitch
    globals()['VmediaPolicy'] = VmediaPolicy
    globals()['VmrcConsole'] = VmrcConsole
    globals()['VncConsole'] = VncConsole
    globals()['VnicEthAdapterPolicy'] = VnicEthAdapterPolicy
    globals()['VnicEthIf'] = VnicEthIf
    globals()['VnicEthNetworkPolicy'] = VnicEthNetworkPolicy
    globals()['VnicEthQosPolicy'] = VnicEthQosPolicy
    globals()['VnicFcAdapterPolicy'] = VnicFcAdapterPolicy
    globals()['VnicFcIf'] = VnicFcIf
    globals()['VnicFcNetworkPolicy'] = VnicFcNetworkPolicy
    globals()['VnicFcQosPolicy'] = VnicFcQosPolicy
    globals()['VnicIscsiAdapterPolicy'] = VnicIscsiAdapterPolicy
    globals()['VnicIscsiBootPolicy'] = VnicIscsiBootPolicy
    globals()['VnicIscsiStaticTargetPolicy'] = VnicIscsiStaticTargetPolicy
    globals()['VnicLanConnectivityPolicy'] = VnicLanConnectivityPolicy
    globals()['VnicLcpStatus'] = VnicLcpStatus
    globals()['VnicSanConnectivityPolicy'] = VnicSanConnectivityPolicy
    globals()['VnicScpStatus'] = VnicScpStatus
    globals()['VrfVrf'] = VrfVrf
    globals()['WorkflowBatchApiExecutor'] = WorkflowBatchApiExecutor
    globals()['WorkflowBatchExecutor'] = WorkflowBatchExecutor
    globals()['WorkflowBuildTaskMeta'] = WorkflowBuildTaskMeta
    globals()['WorkflowBuildTaskMetaOwner'] = WorkflowBuildTaskMetaOwner
    globals()['WorkflowCatalog'] = WorkflowCatalog
    globals()['WorkflowCustomDataTypeDefinition'] = WorkflowCustomDataTypeDefinition
    globals()['WorkflowErrorResponseHandler'] = WorkflowErrorResponseHandler
    globals()['WorkflowPendingDynamicWorkflowInfo'] = WorkflowPendingDynamicWorkflowInfo
    globals()['WorkflowRollbackWorkflow'] = WorkflowRollbackWorkflow
    globals()['WorkflowSolutionActionDefinition'] = WorkflowSolutionActionDefinition
    globals()['WorkflowSolutionActionInstance'] = WorkflowSolutionActionInstance
    globals()['WorkflowSolutionDefinition'] = WorkflowSolutionDefinition
    globals()['WorkflowSolutionInstance'] = WorkflowSolutionInstance
    globals()['WorkflowSolutionOutput'] = WorkflowSolutionOutput
    globals()['WorkflowTaskDebugLog'] = WorkflowTaskDebugLog
    globals()['WorkflowTaskDefinition'] = WorkflowTaskDefinition
    globals()['WorkflowTaskInfo'] = WorkflowTaskInfo
    globals()['WorkflowTaskMetadata'] = WorkflowTaskMetadata
    globals()['WorkflowTaskNotification'] = WorkflowTaskNotification
    globals()['WorkflowTemplateEvaluation'] = WorkflowTemplateEvaluation
    globals()['WorkflowTemplateFunctionMeta'] = WorkflowTemplateFunctionMeta
    globals()['WorkflowWorkflowDefinition'] = WorkflowWorkflowDefinition
    globals()['WorkflowWorkflowInfo'] = WorkflowWorkflowInfo
    globals()['WorkflowWorkflowMeta'] = WorkflowWorkflowMeta
    globals()['WorkflowWorkflowMetadata'] = WorkflowWorkflowMetadata
    globals()['WorkflowWorkflowNotification'] = WorkflowWorkflowNotification


class MoBaseMo(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'AAA.AUDITRECORD': "aaa.AuditRecord",
            'AAA.RETENTIONCONFIG': "aaa.RetentionConfig",
            'AAA.RETENTIONPOLICY': "aaa.RetentionPolicy",
            'ACCESS.POLICY': "access.Policy",
            'ADAPTER.CONFIGPOLICY': "adapter.ConfigPolicy",
            'ADAPTER.EXTETHINTERFACE': "adapter.ExtEthInterface",
            'ADAPTER.HOSTETHINTERFACE': "adapter.HostEthInterface",
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'APPLIANCE.APPSTATUS': "appliance.AppStatus",
            'APPLIANCE.AUTORMAPOLICY': "appliance.AutoRmaPolicy",
            'APPLIANCE.BACKUP': "appliance.Backup",
            'APPLIANCE.BACKUPPOLICY': "appliance.BackupPolicy",
            'APPLIANCE.CERTIFICATESETTING': "appliance.CertificateSetting",
            'APPLIANCE.DATAEXPORTPOLICY': "appliance.DataExportPolicy",
            'APPLIANCE.DEVICECERTIFICATE': "appliance.DeviceCertificate",
            'APPLIANCE.DEVICECLAIM': "appliance.DeviceClaim",
            'APPLIANCE.DEVICEUPGRADEPOLICY': "appliance.DeviceUpgradePolicy",
            'APPLIANCE.DIAGSETTING': "appliance.DiagSetting",
            'APPLIANCE.EXTERNALSYSLOGSETTING': "appliance.ExternalSyslogSetting",
            'APPLIANCE.FILEGATEWAY': "appliance.FileGateway",
            'APPLIANCE.FILESYSTEMSTATUS': "appliance.FileSystemStatus",
            'APPLIANCE.GROUPSTATUS': "appliance.GroupStatus",
            'APPLIANCE.IMAGEBUNDLE': "appliance.ImageBundle",
            'APPLIANCE.NODEINFO': "appliance.NodeInfo",
            'APPLIANCE.NODESTATUS': "appliance.NodeStatus",
            'APPLIANCE.RELEASENOTE': "appliance.ReleaseNote",
            'APPLIANCE.REMOTEFILEIMPORT': "appliance.RemoteFileImport",
            'APPLIANCE.RESTORE': "appliance.Restore",
            'APPLIANCE.SETUPINFO': "appliance.SetupInfo",
            'APPLIANCE.SYSTEMINFO': "appliance.SystemInfo",
            'APPLIANCE.SYSTEMSTATUS': "appliance.SystemStatus",
            'APPLIANCE.UPGRADE': "appliance.Upgrade",
            'APPLIANCE.UPGRADEPOLICY': "appliance.UpgradePolicy",
            'ASSET.CLUSTERMEMBER': "asset.ClusterMember",
            'ASSET.DEPLOYMENT': "asset.Deployment",
            'ASSET.DEPLOYMENTDEVICE': "asset.DeploymentDevice",
            'ASSET.DEVICECLAIM': "asset.DeviceClaim",
            'ASSET.DEVICECONFIGURATION': "asset.DeviceConfiguration",
            'ASSET.DEVICECONNECTORMANAGER': "asset.DeviceConnectorManager",
            'ASSET.DEVICECONTRACTINFORMATION': "asset.DeviceContractInformation",
            'ASSET.DEVICEREGISTRATION': "asset.DeviceRegistration",
            'ASSET.SUBSCRIPTION': "asset.Subscription",
            'ASSET.SUBSCRIPTIONACCOUNT': "asset.SubscriptionAccount",
            'ASSET.SUBSCRIPTIONDEVICECONTRACTINFORMATION': "asset.SubscriptionDeviceContractInformation",
            'ASSET.TARGET': "asset.Target",
            'BIOS.BOOTDEVICE': "bios.BootDevice",
            'BIOS.BOOTMODE': "bios.BootMode",
            'BIOS.POLICY': "bios.Policy",
            'BIOS.SYSTEMBOOTORDER': "bios.SystemBootOrder",
            'BIOS.TOKENSETTINGS': "bios.TokenSettings",
            'BIOS.UNIT': "bios.Unit",
            'BIOS.VFSELECTMEMORYRASCONFIGURATION': "bios.VfSelectMemoryRasConfiguration",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.DEVICEBOOTMODE': "boot.DeviceBootMode",
            'BOOT.DEVICEBOOTSECURITY': "boot.DeviceBootSecurity",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PRECISIONPOLICY': "boot.PrecisionPolicy",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'BULK.EXPORT': "bulk.Export",
            'BULK.EXPORTEDITEM': "bulk.ExportedItem",
            'BULK.MOCLONER': "bulk.MoCloner",
            'BULK.MOMERGER': "bulk.MoMerger",
            'BULK.REQUEST': "bulk.Request",
            'BULK.SUBREQUESTOBJ': "bulk.SubRequestObj",
            'CAPABILITY.ADAPTERUNITDESCRIPTOR': "capability.AdapterUnitDescriptor",
            'CAPABILITY.CATALOG': "capability.Catalog",
            'CAPABILITY.CHASSISDESCRIPTOR': "capability.ChassisDescriptor",
            'CAPABILITY.CHASSISMANUFACTURINGDEF': "capability.ChassisManufacturingDef",
            'CAPABILITY.CIMCFIRMWAREDESCRIPTOR': "capability.CimcFirmwareDescriptor",
            'CAPABILITY.EQUIPMENTPHYSICALDEF': "capability.EquipmentPhysicalDef",
            'CAPABILITY.EQUIPMENTSLOTARRAY': "capability.EquipmentSlotArray",
            'CAPABILITY.FANMODULEDESCRIPTOR': "capability.FanModuleDescriptor",
            'CAPABILITY.FANMODULEMANUFACTURINGDEF': "capability.FanModuleManufacturingDef",
            'CAPABILITY.IOCARDCAPABILITYDEF': "capability.IoCardCapabilityDef",
            'CAPABILITY.IOCARDDESCRIPTOR': "capability.IoCardDescriptor",
            'CAPABILITY.IOCARDMANUFACTURINGDEF': "capability.IoCardManufacturingDef",
            'CAPABILITY.PORTGROUPAGGREGATIONDEF': "capability.PortGroupAggregationDef",
            'CAPABILITY.PSUDESCRIPTOR': "capability.PsuDescriptor",
            'CAPABILITY.PSUMANUFACTURINGDEF': "capability.PsuManufacturingDef",
            'CAPABILITY.SERVERMODELSCAPABILITYDEF': "capability.ServerModelsCapabilityDef",
            'CAPABILITY.SERVERSCHEMADESCRIPTOR': "capability.ServerSchemaDescriptor",
            'CAPABILITY.SIOCMODULECAPABILITYDEF': "capability.SiocModuleCapabilityDef",
            'CAPABILITY.SIOCMODULEDESCRIPTOR': "capability.SiocModuleDescriptor",
            'CAPABILITY.SIOCMODULEMANUFACTURINGDEF': "capability.SiocModuleManufacturingDef",
            'CAPABILITY.SWITCHCAPABILITY': "capability.SwitchCapability",
            'CAPABILITY.SWITCHDESCRIPTOR': "capability.SwitchDescriptor",
            'CAPABILITY.SWITCHMANUFACTURINGDEF': "capability.SwitchManufacturingDef",
            'CERTIFICATEMANAGEMENT.POLICY': "certificatemanagement.Policy",
            'CHASSIS.CONFIGCHANGEDETAIL': "chassis.ConfigChangeDetail",
            'CHASSIS.CONFIGIMPORT': "chassis.ConfigImport",
            'CHASSIS.CONFIGRESULT': "chassis.ConfigResult",
            'CHASSIS.CONFIGRESULTENTRY': "chassis.ConfigResultEntry",
            'CHASSIS.IOMPROFILE': "chassis.IomProfile",
            'CHASSIS.PROFILE': "chassis.Profile",
            'CLOUD.AWSBILLINGUNIT': "cloud.AwsBillingUnit",
            'CLOUD.AWSKEYPAIR': "cloud.AwsKeyPair",
            'CLOUD.AWSNETWORKINTERFACE': "cloud.AwsNetworkInterface",
            'CLOUD.AWSORGANIZATIONALUNIT': "cloud.AwsOrganizationalUnit",
            'CLOUD.AWSSECURITYGROUP': "cloud.AwsSecurityGroup",
            'CLOUD.AWSSUBNET': "cloud.AwsSubnet",
            'CLOUD.AWSVIRTUALMACHINE': "cloud.AwsVirtualMachine",
            'CLOUD.AWSVOLUME': "cloud.AwsVolume",
            'CLOUD.AWSVPC': "cloud.AwsVpc",
            'CLOUD.COLLECTINVENTORY': "cloud.CollectInventory",
            'CLOUD.REGIONS': "cloud.Regions",
            'CLOUD.SKUCONTAINERTYPE': "cloud.SkuContainerType",
            'CLOUD.SKUDATABASETYPE': "cloud.SkuDatabaseType",
            'CLOUD.SKUINSTANCETYPE': "cloud.SkuInstanceType",
            'CLOUD.SKUNETWORKTYPE': "cloud.SkuNetworkType",
            'CLOUD.SKUREGIONRATECARDS': "cloud.SkuRegionRateCards",
            'CLOUD.SKUVOLUMETYPE': "cloud.SkuVolumeType",
            'CLOUD.TFCAGENTPOOL': "cloud.TfcAgentpool",
            'CLOUD.TFCORGANIZATION': "cloud.TfcOrganization",
            'CLOUD.TFCWORKSPACE': "cloud.TfcWorkspace",
            'COMM.HTTPPROXYPOLICY': "comm.HttpProxyPolicy",
            'COMPUTE.BIOSPOSTPOLICY': "compute.BiosPostPolicy",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BLADEIDENTITY': "compute.BladeIdentity",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.MAPPING': "compute.Mapping",
            'COMPUTE.PHYSICALSUMMARY': "compute.PhysicalSummary",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'COMPUTE.RACKUNITIDENTITY': "compute.RackUnitIdentity",
            'COMPUTE.SERVERPOWERPOLICY': "compute.ServerPowerPolicy",
            'COMPUTE.SERVERSETTING': "compute.ServerSetting",
            'COMPUTE.VMEDIA': "compute.Vmedia",
            'COND.ALARM': "cond.Alarm",
            'COND.ALARMAGGREGATION': "cond.AlarmAggregation",
            'COND.HCLSTATUS': "cond.HclStatus",
            'COND.HCLSTATUSDETAIL': "cond.HclStatusDetail",
            'COND.HCLSTATUSJOB': "cond.HclStatusJob",
            'CONNECTORPACK.CONNECTORPACKUPGRADE': "connectorpack.ConnectorPackUpgrade",
            'CONNECTORPACK.UPGRADEIMPACT': "connectorpack.UpgradeImpact",
            'CONVERGEDINFRA.HEALTHCHECKDEFINITION': "convergedinfra.HealthCheckDefinition",
            'CONVERGEDINFRA.HEALTHCHECKEXECUTION': "convergedinfra.HealthCheckExecution",
            'CONVERGEDINFRA.POD': "convergedinfra.Pod",
            'CRD.CUSTOMRESOURCE': "crd.CustomResource",
            'DEVICECONNECTOR.POLICY': "deviceconnector.Policy",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.CHASSISIDENTITY': "equipment.ChassisIdentity",
            'EQUIPMENT.CHASSISOPERATION': "equipment.ChassisOperation",
            'EQUIPMENT.DEVICESUMMARY': "equipment.DeviceSummary",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FEXIDENTITY': "equipment.FexIdentity",
            'EQUIPMENT.FEXOPERATION': "equipment.FexOperation",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.IDENTITYSUMMARY': "equipment.IdentitySummary",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOCARDOPERATION': "equipment.IoCardOperation",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.LOCATORLED': "equipment.LocatorLed",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'ETHER.HOSTPORT': "ether.HostPort",
            'ETHER.NETWORKPORT': "ether.NetworkPort",
            'ETHER.PHYSICALPORT': "ether.PhysicalPort",
            'ETHER.PORTCHANNEL': "ether.PortChannel",
            'EXTERNALSITE.AUTHORIZATION': "externalsite.Authorization",
            'FABRIC.APPLIANCEPCROLE': "fabric.AppliancePcRole",
            'FABRIC.APPLIANCEROLE': "fabric.ApplianceRole",
            'FABRIC.CONFIGCHANGEDETAIL': "fabric.ConfigChangeDetail",
            'FABRIC.CONFIGRESULT': "fabric.ConfigResult",
            'FABRIC.CONFIGRESULTENTRY': "fabric.ConfigResultEntry",
            'FABRIC.ELEMENTIDENTITY': "fabric.ElementIdentity",
            'FABRIC.ESTIMATEIMPACT': "fabric.EstimateImpact",
            'FABRIC.ETHNETWORKCONTROLPOLICY': "fabric.EthNetworkControlPolicy",
            'FABRIC.ETHNETWORKGROUPPOLICY': "fabric.EthNetworkGroupPolicy",
            'FABRIC.ETHNETWORKPOLICY': "fabric.EthNetworkPolicy",
            'FABRIC.FCNETWORKPOLICY': "fabric.FcNetworkPolicy",
            'FABRIC.FCUPLINKPCROLE': "fabric.FcUplinkPcRole",
            'FABRIC.FCUPLINKROLE': "fabric.FcUplinkRole",
            'FABRIC.FCOEUPLINKPCROLE': "fabric.FcoeUplinkPcRole",
            'FABRIC.FCOEUPLINKROLE': "fabric.FcoeUplinkRole",
            'FABRIC.FLOWCONTROLPOLICY': "fabric.FlowControlPolicy",
            'FABRIC.LINKAGGREGATIONPOLICY': "fabric.LinkAggregationPolicy",
            'FABRIC.LINKCONTROLPOLICY': "fabric.LinkControlPolicy",
            'FABRIC.MULTICASTPOLICY': "fabric.MulticastPolicy",
            'FABRIC.PCMEMBER': "fabric.PcMember",
            'FABRIC.PCOPERATION': "fabric.PcOperation",
            'FABRIC.PORTMODE': "fabric.PortMode",
            'FABRIC.PORTOPERATION': "fabric.PortOperation",
            'FABRIC.PORTPOLICY': "fabric.PortPolicy",
            'FABRIC.SERVERROLE': "fabric.ServerRole",
            'FABRIC.SWITCHCLUSTERPROFILE': "fabric.SwitchClusterProfile",
            'FABRIC.SWITCHCONTROLPOLICY': "fabric.SwitchControlPolicy",
            'FABRIC.SWITCHPROFILE': "fabric.SwitchProfile",
            'FABRIC.SYSTEMQOSPOLICY': "fabric.SystemQosPolicy",
            'FABRIC.UPLINKPCROLE': "fabric.UplinkPcRole",
            'FABRIC.UPLINKROLE': "fabric.UplinkRole",
            'FABRIC.VLAN': "fabric.Vlan",
            'FABRIC.VSAN': "fabric.Vsan",
            'FAULT.INSTANCE': "fault.Instance",
            'FC.PHYSICALPORT': "fc.PhysicalPort",
            'FC.PORTCHANNEL': "fc.PortChannel",
            'FCPOOL.FCBLOCK': "fcpool.FcBlock",
            'FCPOOL.LEASE': "fcpool.Lease",
            'FCPOOL.POOL': "fcpool.Pool",
            'FCPOOL.POOLMEMBER': "fcpool.PoolMember",
            'FCPOOL.UNIVERSE': "fcpool.Universe",
            'FEEDBACK.FEEDBACKPOST': "feedback.FeedbackPost",
            'FIRMWARE.BIOSDESCRIPTOR': "firmware.BiosDescriptor",
            'FIRMWARE.BOARDCONTROLLERDESCRIPTOR': "firmware.BoardControllerDescriptor",
            'FIRMWARE.CHASSISUPGRADE': "firmware.ChassisUpgrade",
            'FIRMWARE.CIMCDESCRIPTOR': "firmware.CimcDescriptor",
            'FIRMWARE.DIMMDESCRIPTOR': "firmware.DimmDescriptor",
            'FIRMWARE.DISTRIBUTABLE': "firmware.Distributable",
            'FIRMWARE.DISTRIBUTABLEMETA': "firmware.DistributableMeta",
            'FIRMWARE.DRIVEDESCRIPTOR': "firmware.DriveDescriptor",
            'FIRMWARE.DRIVERDISTRIBUTABLE': "firmware.DriverDistributable",
            'FIRMWARE.EULA': "firmware.Eula",
            'FIRMWARE.FIRMWARESUMMARY': "firmware.FirmwareSummary",
            'FIRMWARE.GPUDESCRIPTOR': "firmware.GpuDescriptor",
            'FIRMWARE.HBADESCRIPTOR': "firmware.HbaDescriptor",
            'FIRMWARE.IOMDESCRIPTOR': "firmware.IomDescriptor",
            'FIRMWARE.MSWITCHDESCRIPTOR': "firmware.MswitchDescriptor",
            'FIRMWARE.NXOSDESCRIPTOR': "firmware.NxosDescriptor",
            'FIRMWARE.PCIEDESCRIPTOR': "firmware.PcieDescriptor",
            'FIRMWARE.PSUDESCRIPTOR': "firmware.PsuDescriptor",
            'FIRMWARE.RUNNINGFIRMWARE': "firmware.RunningFirmware",
            'FIRMWARE.SASEXPANDERDESCRIPTOR': "firmware.SasExpanderDescriptor",
            'FIRMWARE.SERVERCONFIGURATIONUTILITYDISTRIBUTABLE': "firmware.ServerConfigurationUtilityDistributable",
            'FIRMWARE.STORAGECONTROLLERDESCRIPTOR': "firmware.StorageControllerDescriptor",
            'FIRMWARE.SWITCHUPGRADE': "firmware.SwitchUpgrade",
            'FIRMWARE.UNSUPPORTEDVERSIONUPGRADE': "firmware.UnsupportedVersionUpgrade",
            'FIRMWARE.UPGRADE': "firmware.Upgrade",
            'FIRMWARE.UPGRADEIMPACT': "firmware.UpgradeImpact",
            'FIRMWARE.UPGRADEIMPACTSTATUS': "firmware.UpgradeImpactStatus",
            'FIRMWARE.UPGRADESTATUS': "firmware.UpgradeStatus",
            'FORECAST.CATALOG': "forecast.Catalog",
            'FORECAST.DEFINITION': "forecast.Definition",
            'FORECAST.INSTANCE': "forecast.Instance",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'HCL.COMPATIBILITYSTATUS': "hcl.CompatibilityStatus",
            'HCL.DRIVERIMAGE': "hcl.DriverImage",
            'HCL.EXEMPTEDCATALOG': "hcl.ExemptedCatalog",
            'HCL.HYPERFLEXSOFTWARECOMPATIBILITYINFO': "hcl.HyperflexSoftwareCompatibilityInfo",
            'HCL.OPERATINGSYSTEM': "hcl.OperatingSystem",
            'HCL.OPERATINGSYSTEMVENDOR': "hcl.OperatingSystemVendor",
            'HCL.SUPPORTEDDRIVERNAME': "hcl.SupportedDriverName",
            'HYPERFLEX.ALARM': "hyperflex.Alarm",
            'HYPERFLEX.APPCATALOG': "hyperflex.AppCatalog",
            'HYPERFLEX.AUTOSUPPORTPOLICY': "hyperflex.AutoSupportPolicy",
            'HYPERFLEX.BACKUPCLUSTER': "hyperflex.BackupCluster",
            'HYPERFLEX.CAPABILITYINFO': "hyperflex.CapabilityInfo",
            'HYPERFLEX.CISCOHYPERVISORMANAGER': "hyperflex.CiscoHypervisorManager",
            'HYPERFLEX.CLUSTER': "hyperflex.Cluster",
            'HYPERFLEX.CLUSTERBACKUPPOLICY': "hyperflex.ClusterBackupPolicy",
            'HYPERFLEX.CLUSTERBACKUPPOLICYDEPLOYMENT': "hyperflex.ClusterBackupPolicyDeployment",
            'HYPERFLEX.CLUSTERBACKUPPOLICYINVENTORY': "hyperflex.ClusterBackupPolicyInventory",
            'HYPERFLEX.CLUSTERHEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.ClusterHealthCheckExecutionSnapshot",
            'HYPERFLEX.CLUSTERNETWORKPOLICY': "hyperflex.ClusterNetworkPolicy",
            'HYPERFLEX.CLUSTERPROFILE': "hyperflex.ClusterProfile",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICY': "hyperflex.ClusterReplicationNetworkPolicy",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICYDEPLOYMENT': "hyperflex.ClusterReplicationNetworkPolicyDeployment",
            'HYPERFLEX.CLUSTERSTORAGEPOLICY': "hyperflex.ClusterStoragePolicy",
            'HYPERFLEX.CONFIGRESULT': "hyperflex.ConfigResult",
            'HYPERFLEX.CONFIGRESULTENTRY': "hyperflex.ConfigResultEntry",
            'HYPERFLEX.DATAPROTECTIONPEER': "hyperflex.DataProtectionPeer",
            'HYPERFLEX.DATASTORESTATISTIC': "hyperflex.DatastoreStatistic",
            'HYPERFLEX.DEVICEPACKAGEDOWNLOADSTATE': "hyperflex.DevicePackageDownloadState",
            'HYPERFLEX.DRIVE': "hyperflex.Drive",
            'HYPERFLEX.EXTFCSTORAGEPOLICY': "hyperflex.ExtFcStoragePolicy",
            'HYPERFLEX.EXTISCSISTORAGEPOLICY': "hyperflex.ExtIscsiStoragePolicy",
            'HYPERFLEX.FEATURELIMITEXTERNAL': "hyperflex.FeatureLimitExternal",
            'HYPERFLEX.FEATURELIMITINTERNAL': "hyperflex.FeatureLimitInternal",
            'HYPERFLEX.HEALTH': "hyperflex.Health",
            'HYPERFLEX.HEALTHCHECKDEFINITION': "hyperflex.HealthCheckDefinition",
            'HYPERFLEX.HEALTHCHECKEXECUTION': "hyperflex.HealthCheckExecution",
            'HYPERFLEX.HEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.HealthCheckExecutionSnapshot",
            'HYPERFLEX.HEALTHCHECKPACKAGECHECKSUM': "hyperflex.HealthCheckPackageChecksum",
            'HYPERFLEX.HXAPCLUSTER': "hyperflex.HxapCluster",
            'HYPERFLEX.HXAPDATACENTER': "hyperflex.HxapDatacenter",
            'HYPERFLEX.HXAPDVUPLINK': "hyperflex.HxapDvUplink",
            'HYPERFLEX.HXAPDVSWITCH': "hyperflex.HxapDvswitch",
            'HYPERFLEX.HXAPHOST': "hyperflex.HxapHost",
            'HYPERFLEX.HXAPHOSTINTERFACE': "hyperflex.HxapHostInterface",
            'HYPERFLEX.HXAPHOSTVSWITCH': "hyperflex.HxapHostVswitch",
            'HYPERFLEX.HXAPNETWORK': "hyperflex.HxapNetwork",
            'HYPERFLEX.HXAPVIRTUALDISK': "hyperflex.HxapVirtualDisk",
            'HYPERFLEX.HXAPVIRTUALMACHINE': "hyperflex.HxapVirtualMachine",
            'HYPERFLEX.HXAPVIRTUALMACHINENETWORKINTERFACE': "hyperflex.HxapVirtualMachineNetworkInterface",
            'HYPERFLEX.HXDPVERSION': "hyperflex.HxdpVersion",
            'HYPERFLEX.LICENSE': "hyperflex.License",
            'HYPERFLEX.LOCALCREDENTIALPOLICY': "hyperflex.LocalCredentialPolicy",
            'HYPERFLEX.NODE': "hyperflex.Node",
            'HYPERFLEX.NODECONFIGPOLICY': "hyperflex.NodeConfigPolicy",
            'HYPERFLEX.NODEPROFILE': "hyperflex.NodeProfile",
            'HYPERFLEX.PROTECTEDCLUSTER': "hyperflex.ProtectedCluster",
            'HYPERFLEX.PROXYSETTINGPOLICY': "hyperflex.ProxySettingPolicy",
            'HYPERFLEX.SERVERFIRMWAREVERSION': "hyperflex.ServerFirmwareVersion",
            'HYPERFLEX.SERVERFIRMWAREVERSIONENTRY': "hyperflex.ServerFirmwareVersionEntry",
            'HYPERFLEX.SERVERMODEL': "hyperflex.ServerModel",
            'HYPERFLEX.SERVICEAUTHTOKEN': "hyperflex.ServiceAuthToken",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONCOMPONENT': "hyperflex.SoftwareDistributionComponent",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONENTRY': "hyperflex.SoftwareDistributionEntry",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONVERSION': "hyperflex.SoftwareDistributionVersion",
            'HYPERFLEX.SOFTWAREVERSIONPOLICY': "hyperflex.SoftwareVersionPolicy",
            'HYPERFLEX.STORAGECONTAINER': "hyperflex.StorageContainer",
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
            'HYPERFLEX.UCSMCONFIGPOLICY': "hyperflex.UcsmConfigPolicy",
            'HYPERFLEX.VCENTERCONFIGPOLICY': "hyperflex.VcenterConfigPolicy",
            'HYPERFLEX.VMBACKUPINFO': "hyperflex.VmBackupInfo",
            'HYPERFLEX.VMIMPORTOPERATION': "hyperflex.VmImportOperation",
            'HYPERFLEX.VMRESTOREOPERATION': "hyperflex.VmRestoreOperation",
            'HYPERFLEX.VMSNAPSHOTINFO': "hyperflex.VmSnapshotInfo",
            'HYPERFLEX.VOLUME': "hyperflex.Volume",
            'HYPERFLEX.WITNESSCONFIGURATION': "hyperflex.WitnessConfiguration",
            'IAAS.CONNECTORPACK': "iaas.ConnectorPack",
            'IAAS.DEVICESTATUS': "iaas.DeviceStatus",
            'IAAS.DIAGNOSTICMESSAGES': "iaas.DiagnosticMessages",
            'IAAS.LICENSEINFO': "iaas.LicenseInfo",
            'IAAS.MOSTRUNTASKS': "iaas.MostRunTasks",
            'IAAS.SERVICEREQUEST': "iaas.ServiceRequest",
            'IAAS.UCSDINFO': "iaas.UcsdInfo",
            'IAAS.UCSDMANAGEDINFRA': "iaas.UcsdManagedInfra",
            'IAAS.UCSDMESSAGES': "iaas.UcsdMessages",
            'IAM.ACCOUNT': "iam.Account",
            'IAM.ACCOUNTEXPERIENCE': "iam.AccountExperience",
            'IAM.APIKEY': "iam.ApiKey",
            'IAM.APPREGISTRATION': "iam.AppRegistration",
            'IAM.BANNERMESSAGE': "iam.BannerMessage",
            'IAM.CERTIFICATE': "iam.Certificate",
            'IAM.CERTIFICATEREQUEST': "iam.CertificateRequest",
            'IAM.DOMAINGROUP': "iam.DomainGroup",
            'IAM.ENDPOINTPRIVILEGE': "iam.EndPointPrivilege",
            'IAM.ENDPOINTROLE': "iam.EndPointRole",
            'IAM.ENDPOINTUSER': "iam.EndPointUser",
            'IAM.ENDPOINTUSERPOLICY': "iam.EndPointUserPolicy",
            'IAM.ENDPOINTUSERROLE': "iam.EndPointUserRole",
            'IAM.IDP': "iam.Idp",
            'IAM.IDPREFERENCE': "iam.IdpReference",
            'IAM.IPACCESSMANAGEMENT': "iam.IpAccessManagement",
            'IAM.IPADDRESS': "iam.IpAddress",
            'IAM.LDAPGROUP': "iam.LdapGroup",
            'IAM.LDAPPOLICY': "iam.LdapPolicy",
            'IAM.LDAPPROVIDER': "iam.LdapProvider",
            'IAM.LOCALUSERPASSWORD': "iam.LocalUserPassword",
            'IAM.LOCALUSERPASSWORDPOLICY': "iam.LocalUserPasswordPolicy",
            'IAM.OAUTHTOKEN': "iam.OAuthToken",
            'IAM.PERMISSION': "iam.Permission",
            'IAM.PRIVATEKEYSPEC': "iam.PrivateKeySpec",
            'IAM.PRIVILEGE': "iam.Privilege",
            'IAM.PRIVILEGESET': "iam.PrivilegeSet",
            'IAM.QUALIFIER': "iam.Qualifier",
            'IAM.RESOURCELIMITS': "iam.ResourceLimits",
            'IAM.RESOURCEPERMISSION': "iam.ResourcePermission",
            'IAM.RESOURCEROLES': "iam.ResourceRoles",
            'IAM.ROLE': "iam.Role",
            'IAM.SECURITYHOLDER': "iam.SecurityHolder",
            'IAM.SERVICEPROVIDER': "iam.ServiceProvider",
            'IAM.SESSION': "iam.Session",
            'IAM.SESSIONLIMITS': "iam.SessionLimits",
            'IAM.SYSTEM': "iam.System",
            'IAM.TRUSTPOINT': "iam.TrustPoint",
            'IAM.USER': "iam.User",
            'IAM.USERGROUP': "iam.UserGroup",
            'IAM.USERPREFERENCE': "iam.UserPreference",
            'INVENTORY.DEVICEINFO': "inventory.DeviceInfo",
            'INVENTORY.DNMOBINDING': "inventory.DnMoBinding",
            'INVENTORY.GENERICINVENTORY': "inventory.GenericInventory",
            'INVENTORY.GENERICINVENTORYHOLDER': "inventory.GenericInventoryHolder",
            'INVENTORY.REQUEST': "inventory.Request",
            'IPMIOVERLAN.POLICY': "ipmioverlan.Policy",
            'IPPOOL.BLOCKLEASE': "ippool.BlockLease",
            'IPPOOL.IPLEASE': "ippool.IpLease",
            'IPPOOL.POOL': "ippool.Pool",
            'IPPOOL.POOLMEMBER': "ippool.PoolMember",
            'IPPOOL.SHADOWBLOCK': "ippool.ShadowBlock",
            'IPPOOL.SHADOWPOOL': "ippool.ShadowPool",
            'IPPOOL.UNIVERSE': "ippool.Universe",
            'IQNPOOL.BLOCK': "iqnpool.Block",
            'IQNPOOL.LEASE': "iqnpool.Lease",
            'IQNPOOL.POOL': "iqnpool.Pool",
            'IQNPOOL.POOLMEMBER': "iqnpool.PoolMember",
            'IQNPOOL.UNIVERSE': "iqnpool.Universe",
            'IWOTENANT.TENANTSTATUS': "iwotenant.TenantStatus",
            'KUBERNETES.ACICNIAPIC': "kubernetes.AciCniApic",
            'KUBERNETES.ACICNIPROFILE': "kubernetes.AciCniProfile",
            'KUBERNETES.ACICNITENANTCLUSTERALLOCATION': "kubernetes.AciCniTenantClusterAllocation",
            'KUBERNETES.ADDONDEFINITION': "kubernetes.AddonDefinition",
            'KUBERNETES.ADDONPOLICY': "kubernetes.AddonPolicy",
            'KUBERNETES.ADDONREPOSITORY': "kubernetes.AddonRepository",
            'KUBERNETES.BAREMETALNODEPROFILE': "kubernetes.BaremetalNodeProfile",
            'KUBERNETES.CATALOG': "kubernetes.Catalog",
            'KUBERNETES.CLUSTER': "kubernetes.Cluster",
            'KUBERNETES.CLUSTERADDONPROFILE': "kubernetes.ClusterAddonProfile",
            'KUBERNETES.CLUSTERPROFILE': "kubernetes.ClusterProfile",
            'KUBERNETES.CONFIGRESULT': "kubernetes.ConfigResult",
            'KUBERNETES.CONFIGRESULTENTRY': "kubernetes.ConfigResultEntry",
            'KUBERNETES.CONTAINERRUNTIMEPOLICY': "kubernetes.ContainerRuntimePolicy",
            'KUBERNETES.DAEMONSET': "kubernetes.DaemonSet",
            'KUBERNETES.DEPLOYMENT': "kubernetes.Deployment",
            'KUBERNETES.INGRESS': "kubernetes.Ingress",
            'KUBERNETES.NETWORKPOLICY': "kubernetes.NetworkPolicy",
            'KUBERNETES.NODE': "kubernetes.Node",
            'KUBERNETES.NODEGROUPPROFILE': "kubernetes.NodeGroupProfile",
            'KUBERNETES.POD': "kubernetes.Pod",
            'KUBERNETES.SERVICE': "kubernetes.Service",
            'KUBERNETES.STATEFULSET': "kubernetes.StatefulSet",
            'KUBERNETES.SYSCONFIGPOLICY': "kubernetes.SysConfigPolicy",
            'KUBERNETES.TRUSTEDREGISTRIESPOLICY': "kubernetes.TrustedRegistriesPolicy",
            'KUBERNETES.VERSION': "kubernetes.Version",
            'KUBERNETES.VERSIONPOLICY': "kubernetes.VersionPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRACONFIGPOLICY': "kubernetes.VirtualMachineInfraConfigPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRASTRUCTUREPROVIDER': "kubernetes.VirtualMachineInfrastructureProvider",
            'KUBERNETES.VIRTUALMACHINEINSTANCETYPE': "kubernetes.VirtualMachineInstanceType",
            'KUBERNETES.VIRTUALMACHINENODEPROFILE': "kubernetes.VirtualMachineNodeProfile",
            'KVM.POLICY': "kvm.Policy",
            'KVM.SESSION': "kvm.Session",
            'KVM.TUNNEL': "kvm.Tunnel",
            'LICENSE.ACCOUNTLICENSEDATA': "license.AccountLicenseData",
            'LICENSE.CUSTOMEROP': "license.CustomerOp",
            'LICENSE.IWOCUSTOMEROP': "license.IwoCustomerOp",
            'LICENSE.IWOLICENSECOUNT': "license.IwoLicenseCount",
            'LICENSE.LICENSEINFO': "license.LicenseInfo",
            'LICENSE.LICENSERESERVATIONOP': "license.LicenseReservationOp",
            'LICENSE.SMARTLICENSETOKEN': "license.SmartlicenseToken",
            'LS.SERVICEPROFILE': "ls.ServiceProfile",
            'MACPOOL.IDBLOCK': "macpool.IdBlock",
            'MACPOOL.LEASE': "macpool.Lease",
            'MACPOOL.POOL': "macpool.Pool",
            'MACPOOL.POOLMEMBER': "macpool.PoolMember",
            'MACPOOL.UNIVERSE': "macpool.Universe",
            'MANAGEMENT.CONTROLLER': "management.Controller",
            'MANAGEMENT.ENTITY': "management.Entity",
            'MANAGEMENT.INTERFACE': "management.Interface",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYCONFIGRESULT': "memory.PersistentMemoryConfigResult",
            'MEMORY.PERSISTENTMEMORYCONFIGURATION': "memory.PersistentMemoryConfiguration",
            'MEMORY.PERSISTENTMEMORYNAMESPACE': "memory.PersistentMemoryNamespace",
            'MEMORY.PERSISTENTMEMORYNAMESPACECONFIGRESULT': "memory.PersistentMemoryNamespaceConfigResult",
            'MEMORY.PERSISTENTMEMORYPOLICY': "memory.PersistentMemoryPolicy",
            'MEMORY.PERSISTENTMEMORYREGION': "memory.PersistentMemoryRegion",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.UNIT': "memory.Unit",
            'META.DEFINITION': "meta.Definition",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.ELEMENTSUMMARY': "network.ElementSummary",
            'NETWORK.FCZONEINFO': "network.FcZoneInfo",
            'NETWORK.VLANPORTINFO': "network.VlanPortInfo",
            'NETWORKCONFIG.POLICY': "networkconfig.Policy",
            'NIAAPI.APICCCOPOST': "niaapi.ApicCcoPost",
            'NIAAPI.APICFIELDNOTICE': "niaapi.ApicFieldNotice",
            'NIAAPI.APICHWEOL': "niaapi.ApicHweol",
            'NIAAPI.APICLATESTMAINTAINEDRELEASE': "niaapi.ApicLatestMaintainedRelease",
            'NIAAPI.APICRELEASERECOMMEND': "niaapi.ApicReleaseRecommend",
            'NIAAPI.APICSWEOL': "niaapi.ApicSweol",
            'NIAAPI.DCNMCCOPOST': "niaapi.DcnmCcoPost",
            'NIAAPI.DCNMFIELDNOTICE': "niaapi.DcnmFieldNotice",
            'NIAAPI.DCNMHWEOL': "niaapi.DcnmHweol",
            'NIAAPI.DCNMLATESTMAINTAINEDRELEASE': "niaapi.DcnmLatestMaintainedRelease",
            'NIAAPI.DCNMRELEASERECOMMEND': "niaapi.DcnmReleaseRecommend",
            'NIAAPI.DCNMSWEOL': "niaapi.DcnmSweol",
            'NIAAPI.FILEDOWNLOADER': "niaapi.FileDownloader",
            'NIAAPI.NIAMETADATA': "niaapi.NiaMetadata",
            'NIAAPI.NIBFILEDOWNLOADER': "niaapi.NibFileDownloader",
            'NIAAPI.NIBMETADATA': "niaapi.NibMetadata",
            'NIAAPI.VERSIONREGEX': "niaapi.VersionRegex",
            'NIATELEMETRY.AAALDAPPROVIDERDETAILS': "niatelemetry.AaaLdapProviderDetails",
            'NIATELEMETRY.AAARADIUSPROVIDERDETAILS': "niatelemetry.AaaRadiusProviderDetails",
            'NIATELEMETRY.AAATACACSPROVIDERDETAILS': "niatelemetry.AaaTacacsProviderDetails",
            'NIATELEMETRY.APICAPPPLUGINDETAILS': "niatelemetry.ApicAppPluginDetails",
            'NIATELEMETRY.APICCOREFILEDETAILS': "niatelemetry.ApicCoreFileDetails",
            'NIATELEMETRY.APICDBGEXPRSEXPORTDEST': "niatelemetry.ApicDbgexpRsExportDest",
            'NIATELEMETRY.APICDBGEXPRSTSSCHEDULER': "niatelemetry.ApicDbgexpRsTsScheduler",
            'NIATELEMETRY.APICFANDETAILS': "niatelemetry.ApicFanDetails",
            'NIATELEMETRY.APICFEXDETAILS': "niatelemetry.ApicFexDetails",
            'NIATELEMETRY.APICFLASHDETAILS': "niatelemetry.ApicFlashDetails",
            'NIATELEMETRY.APICNTPAUTH': "niatelemetry.ApicNtpAuth",
            'NIATELEMETRY.APICPSUDETAILS': "niatelemetry.ApicPsuDetails",
            'NIATELEMETRY.APICREALMDETAILS': "niatelemetry.ApicRealmDetails",
            'NIATELEMETRY.APICSNMPCLIENTGRPDETAILS': "niatelemetry.ApicSnmpClientGrpDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYACCESSDETAILS': "niatelemetry.ApicSnmpCommunityAccessDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYDETAILS': "niatelemetry.ApicSnmpCommunityDetails",
            'NIATELEMETRY.APICSNMPTRAPDETAILS': "niatelemetry.ApicSnmpTrapDetails",
            'NIATELEMETRY.APICSNMPTRAPFWDSERVERDETAILS': "niatelemetry.ApicSnmpTrapFwdServerDetails",
            'NIATELEMETRY.APICSNMPVERSIONTHREEDETAILS': "niatelemetry.ApicSnmpVersionThreeDetails",
            'NIATELEMETRY.APICSYSLOGGRP': "niatelemetry.ApicSysLogGrp",
            'NIATELEMETRY.APICSYSLOGSRC': "niatelemetry.ApicSysLogSrc",
            'NIATELEMETRY.APICTRANSCEIVERDETAILS': "niatelemetry.ApicTransceiverDetails",
            'NIATELEMETRY.APICUIPAGECOUNTS': "niatelemetry.ApicUiPageCounts",
            'NIATELEMETRY.APPDETAILS': "niatelemetry.AppDetails",
            'NIATELEMETRY.COMMONPOLICIES': "niatelemetry.CommonPolicies",
            'NIATELEMETRY.DCNMFANDETAILS': "niatelemetry.DcnmFanDetails",
            'NIATELEMETRY.DCNMFEXDETAILS': "niatelemetry.DcnmFexDetails",
            'NIATELEMETRY.DCNMMODULEDETAILS': "niatelemetry.DcnmModuleDetails",
            'NIATELEMETRY.DCNMPSUDETAILS': "niatelemetry.DcnmPsuDetails",
            'NIATELEMETRY.DCNMTRANSCEIVERDETAILS': "niatelemetry.DcnmTransceiverDetails",
            'NIATELEMETRY.EPG': "niatelemetry.Epg",
            'NIATELEMETRY.FABRICMODULEDETAILS': "niatelemetry.FabricModuleDetails",
            'NIATELEMETRY.FABRICPODPROFILE': "niatelemetry.FabricPodProfile",
            'NIATELEMETRY.FABRICPODSS': "niatelemetry.FabricPodSs",
            'NIATELEMETRY.FAULT': "niatelemetry.Fault",
            'NIATELEMETRY.HTTPSACLCONTRACTDETAILS': "niatelemetry.HttpsAclContractDetails",
            'NIATELEMETRY.HTTPSACLCONTRACTFILTERMAP': "niatelemetry.HttpsAclContractFilterMap",
            'NIATELEMETRY.HTTPSACLEPGCONTRACTMAP': "niatelemetry.HttpsAclEpgContractMap",
            'NIATELEMETRY.HTTPSACLEPGDETAILS': "niatelemetry.HttpsAclEpgDetails",
            'NIATELEMETRY.HTTPSACLFILTERDETAILS': "niatelemetry.HttpsAclFilterDetails",
            'NIATELEMETRY.LC': "niatelemetry.Lc",
            'NIATELEMETRY.MSOCONTRACTDETAILS': "niatelemetry.MsoContractDetails",
            'NIATELEMETRY.MSOEPGDETAILS': "niatelemetry.MsoEpgDetails",
            'NIATELEMETRY.MSOSCHEMADETAILS': "niatelemetry.MsoSchemaDetails",
            'NIATELEMETRY.MSOSITEDETAILS': "niatelemetry.MsoSiteDetails",
            'NIATELEMETRY.MSOTENANTDETAILS': "niatelemetry.MsoTenantDetails",
            'NIATELEMETRY.NEXUSDASHBOARDCONTROLLERDETAILS': "niatelemetry.NexusDashboardControllerDetails",
            'NIATELEMETRY.NEXUSDASHBOARDDETAILS': "niatelemetry.NexusDashboardDetails",
            'NIATELEMETRY.NEXUSDASHBOARDMEMORYDETAILS': "niatelemetry.NexusDashboardMemoryDetails",
            'NIATELEMETRY.NEXUSDASHBOARDS': "niatelemetry.NexusDashboards",
            'NIATELEMETRY.NIAFEATUREUSAGE': "niatelemetry.NiaFeatureUsage",
            'NIATELEMETRY.NIAINVENTORY': "niatelemetry.NiaInventory",
            'NIATELEMETRY.NIAINVENTORYDCNM': "niatelemetry.NiaInventoryDcnm",
            'NIATELEMETRY.NIAINVENTORYFABRIC': "niatelemetry.NiaInventoryFabric",
            'NIATELEMETRY.NIALICENSESTATE': "niatelemetry.NiaLicenseState",
            'NIATELEMETRY.PASSWORDSTRENGTHCHECK': "niatelemetry.PasswordStrengthCheck",
            'NIATELEMETRY.PODCOMMPOLICIES': "niatelemetry.PodCommPolicies",
            'NIATELEMETRY.PODSNMPPOLICIES': "niatelemetry.PodSnmpPolicies",
            'NIATELEMETRY.PODTIMESERVERPOLICIES': "niatelemetry.PodTimeServerPolicies",
            'NIATELEMETRY.SITEINVENTORY': "niatelemetry.SiteInventory",
            'NIATELEMETRY.SNMPSRC': "niatelemetry.SnmpSrc",
            'NIATELEMETRY.SSHVERSIONTWO': "niatelemetry.SshVersionTwo",
            'NIATELEMETRY.SUPERVISORMODULEDETAILS': "niatelemetry.SupervisorModuleDetails",
            'NIATELEMETRY.SYSLOGREMOTEDEST': "niatelemetry.SyslogRemoteDest",
            'NIATELEMETRY.SYSLOGSYSMSG': "niatelemetry.SyslogSysMsg",
            'NIATELEMETRY.SYSLOGSYSMSGFACFILTER': "niatelemetry.SyslogSysMsgFacFilter",
            'NIATELEMETRY.SYSTEMCONTROLLERDETAILS': "niatelemetry.SystemControllerDetails",
            'NIATELEMETRY.TENANT': "niatelemetry.Tenant",
            'NOTIFICATION.ACCOUNTSUBSCRIPTION': "notification.AccountSubscription",
            'NTP.POLICY': "ntp.Policy",
            'OPRS.DEPLOYMENT': "oprs.Deployment",
            'OPRS.SYNCTARGETLISTMESSAGE': "oprs.SyncTargetListMessage",
            'ORGANIZATION.ORGANIZATION': "organization.Organization",
            'OS.BULKINSTALLINFO': "os.BulkInstallInfo",
            'OS.CATALOG': "os.Catalog",
            'OS.CONFIGURATIONFILE': "os.ConfigurationFile",
            'OS.DISTRIBUTION': "os.Distribution",
            'OS.INSTALL': "os.Install",
            'OS.OSSUPPORT': "os.OsSupport",
            'OS.SUPPORTEDVERSION': "os.SupportedVersion",
            'OS.TEMPLATEFILE': "os.TemplateFile",
            'OS.VALIDINSTALLTARGET': "os.ValidInstallTarget",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.SWITCH': "pci.Switch",
            'PORT.GROUP': "port.Group",
            'PORT.MACBINDING': "port.MacBinding",
            'PORT.SUBGROUP': "port.SubGroup",
            'POWER.CONTROLSTATE': "power.ControlState",
            'POWER.POLICY': "power.Policy",
            'PROCESSOR.UNIT': "processor.Unit",
            'RACK.UNITPERSONALITY': "rack.UnitPersonality",
            'RECOMMENDATION.CAPACITYRUNWAY': "recommendation.CapacityRunway",
            'RECOMMENDATION.PHYSICALITEM': "recommendation.PhysicalItem",
            'RECOVERY.BACKUPCONFIGPOLICY': "recovery.BackupConfigPolicy",
            'RECOVERY.BACKUPPROFILE': "recovery.BackupProfile",
            'RECOVERY.CONFIGRESULT': "recovery.ConfigResult",
            'RECOVERY.CONFIGRESULTENTRY': "recovery.ConfigResultEntry",
            'RECOVERY.ONDEMANDBACKUP': "recovery.OnDemandBackup",
            'RECOVERY.RESTORE': "recovery.Restore",
            'RECOVERY.SCHEDULECONFIGPOLICY': "recovery.ScheduleConfigPolicy",
            'RESOURCE.GROUP': "resource.Group",
            'RESOURCE.GROUPMEMBER': "resource.GroupMember",
            'RESOURCE.LICENSERESOURCECOUNT': "resource.LicenseResourceCount",
            'RESOURCE.MEMBERSHIP': "resource.Membership",
            'RESOURCE.MEMBERSHIPHOLDER': "resource.MembershipHolder",
            'RESOURCE.RESERVATION': "resource.Reservation",
            'RESOURCEPOOL.LEASE': "resourcepool.Lease",
            'RESOURCEPOOL.LEASERESOURCE': "resourcepool.LeaseResource",
            'RESOURCEPOOL.POOL': "resourcepool.Pool",
            'RESOURCEPOOL.POOLMEMBER': "resourcepool.PoolMember",
            'RESOURCEPOOL.UNIVERSE': "resourcepool.Universe",
            'RPROXY.REVERSEPROXY': "rproxy.ReverseProxy",
            'SDCARD.POLICY': "sdcard.Policy",
            'SDWAN.PROFILE': "sdwan.Profile",
            'SDWAN.ROUTERNODE': "sdwan.RouterNode",
            'SDWAN.ROUTERPOLICY': "sdwan.RouterPolicy",
            'SDWAN.VMANAGEACCOUNTPOLICY': "sdwan.VmanageAccountPolicy",
            'SEARCH.SEARCHITEM': "search.SearchItem",
            'SEARCH.TAGITEM': "search.TagItem",
            'SECURITY.UNIT': "security.Unit",
            'SERVER.CONFIGCHANGEDETAIL': "server.ConfigChangeDetail",
            'SERVER.CONFIGIMPORT': "server.ConfigImport",
            'SERVER.CONFIGRESULT': "server.ConfigResult",
            'SERVER.CONFIGRESULTENTRY': "server.ConfigResultEntry",
            'SERVER.PROFILE': "server.Profile",
            'SERVER.PROFILETEMPLATE': "server.ProfileTemplate",
            'SMTP.POLICY': "smtp.Policy",
            'SNMP.POLICY': "snmp.Policy",
            'SOFTWARE.APPLIANCEDISTRIBUTABLE': "software.ApplianceDistributable",
            'SOFTWARE.DOWNLOADHISTORY': "software.DownloadHistory",
            'SOFTWARE.HCLMETA': "software.HclMeta",
            'SOFTWARE.HYPERFLEXBUNDLEDISTRIBUTABLE': "software.HyperflexBundleDistributable",
            'SOFTWARE.HYPERFLEXDISTRIBUTABLE': "software.HyperflexDistributable",
            'SOFTWARE.RELEASEMETA': "software.ReleaseMeta",
            'SOFTWARE.SOLUTIONDISTRIBUTABLE': "software.SolutionDistributable",
            'SOFTWARE.UCSDBUNDLEDISTRIBUTABLE': "software.UcsdBundleDistributable",
            'SOFTWARE.UCSDDISTRIBUTABLE': "software.UcsdDistributable",
            'SOFTWAREREPOSITORY.AUTHORIZATION': "softwarerepository.Authorization",
            'SOFTWAREREPOSITORY.CACHEDIMAGE': "softwarerepository.CachedImage",
            'SOFTWAREREPOSITORY.CATALOG': "softwarerepository.Catalog",
            'SOFTWAREREPOSITORY.CATEGORYMAPPER': "softwarerepository.CategoryMapper",
            'SOFTWAREREPOSITORY.CATEGORYMAPPERMODEL': "softwarerepository.CategoryMapperModel",
            'SOFTWAREREPOSITORY.CATEGORYSUPPORTCONSTRAINT': "softwarerepository.CategorySupportConstraint",
            'SOFTWAREREPOSITORY.DOWNLOADSPEC': "softwarerepository.DownloadSpec",
            'SOFTWAREREPOSITORY.OPERATINGSYSTEMFILE': "softwarerepository.OperatingSystemFile",
            'SOFTWAREREPOSITORY.RELEASE': "softwarerepository.Release",
            'SOL.POLICY': "sol.Policy",
            'SSH.POLICY': "ssh.Policy",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.DISKGROUP': "storage.DiskGroup",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.DRIVEGROUP': "storage.DriveGroup",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.ENCLOSUREDISKSLOTEP': "storage.EnclosureDiskSlotEp",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILCONTROLLER': "storage.FlexUtilController",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.FLEXUTILVIRTUALDRIVE': "storage.FlexUtilVirtualDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.HITACHIHOST': "storage.HitachiHost",
            'STORAGE.HITACHIHOSTLUN': "storage.HitachiHostLun",
            'STORAGE.HITACHIPARITYGROUP': "storage.HitachiParityGroup",
            'STORAGE.HITACHIPOOL': "storage.HitachiPool",
            'STORAGE.HITACHIPORT': "storage.HitachiPort",
            'STORAGE.HITACHIVOLUME': "storage.HitachiVolume",
            'STORAGE.HYPERFLEXSTORAGECONTAINER': "storage.HyperFlexStorageContainer",
            'STORAGE.HYPERFLEXVOLUME': "storage.HyperFlexVolume",
            'STORAGE.ITEM': "storage.Item",
            'STORAGE.NETAPPAGGREGATE': "storage.NetAppAggregate",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPETHERNETPORT': "storage.NetAppEthernetPort",
            'STORAGE.NETAPPEXPORTPOLICY': "storage.NetAppExportPolicy",
            'STORAGE.NETAPPFCINTERFACE': "storage.NetAppFcInterface",
            'STORAGE.NETAPPFCPORT': "storage.NetAppFcPort",
            'STORAGE.NETAPPINITIATORGROUP': "storage.NetAppInitiatorGroup",
            'STORAGE.NETAPPIPINTERFACE': "storage.NetAppIpInterface",
            'STORAGE.NETAPPLICENSE': "storage.NetAppLicense",
            'STORAGE.NETAPPLUN': "storage.NetAppLun",
            'STORAGE.NETAPPLUNMAP': "storage.NetAppLunMap",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.NETAPPNTPSERVER': "storage.NetAppNtpServer",
            'STORAGE.NETAPPSENSOR': "storage.NetAppSensor",
            'STORAGE.NETAPPSTORAGEVM': "storage.NetAppStorageVm",
            'STORAGE.NETAPPVOLUME': "storage.NetAppVolume",
            'STORAGE.NETAPPVOLUMESNAPSHOT': "storage.NetAppVolumeSnapshot",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PHYSICALDISKUSAGE': "storage.PhysicalDiskUsage",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.PUREHOST': "storage.PureHost",
            'STORAGE.PUREHOSTGROUP': "storage.PureHostGroup",
            'STORAGE.PUREHOSTLUN': "storage.PureHostLun",
            'STORAGE.PUREPORT': "storage.PurePort",
            'STORAGE.PUREPROTECTIONGROUP': "storage.PureProtectionGroup",
            'STORAGE.PUREPROTECTIONGROUPSNAPSHOT': "storage.PureProtectionGroupSnapshot",
            'STORAGE.PUREREPLICATIONSCHEDULE': "storage.PureReplicationSchedule",
            'STORAGE.PURESNAPSHOTSCHEDULE': "storage.PureSnapshotSchedule",
            'STORAGE.PUREVOLUME': "storage.PureVolume",
            'STORAGE.PUREVOLUMESNAPSHOT': "storage.PureVolumeSnapshot",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.SASPORT': "storage.SasPort",
            'STORAGE.SPAN': "storage.Span",
            'STORAGE.STORAGEPOLICY': "storage.StoragePolicy",
            'STORAGE.VDMEMBEREP': "storage.VdMemberEp",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
            'STORAGE.VIRTUALDRIVEEXTENSION': "storage.VirtualDriveExtension",
            'STORAGE.VIRTUALDRIVEIDENTITY': "storage.VirtualDriveIdentity",
            'SYSLOG.POLICY': "syslog.Policy",
            'TAM.ADVISORYCOUNT': "tam.AdvisoryCount",
            'TAM.ADVISORYDEFINITION': "tam.AdvisoryDefinition",
            'TAM.ADVISORYINFO': "tam.AdvisoryInfo",
            'TAM.ADVISORYINSTANCE': "tam.AdvisoryInstance",
            'TAM.SECURITYADVISORY': "tam.SecurityAdvisory",
            'TASK.HITACHISCOPEDINVENTORY': "task.HitachiScopedInventory",
            'TASK.HXAPSCOPEDINVENTORY': "task.HxapScopedInventory",
            'TASK.NETAPPSCOPEDINVENTORY': "task.NetAppScopedInventory",
            'TASK.PUBLICCLOUDSCOPEDINVENTORY': "task.PublicCloudScopedInventory",
            'TASK.PURESCOPEDINVENTORY': "task.PureScopedInventory",
            'TASK.SERVERSCOPEDINVENTORY': "task.ServerScopedInventory",
            'TECHSUPPORTMANAGEMENT.COLLECTIONCONTROLPOLICY': "techsupportmanagement.CollectionControlPolicy",
            'TECHSUPPORTMANAGEMENT.DOWNLOAD': "techsupportmanagement.Download",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTBUNDLE': "techsupportmanagement.TechSupportBundle",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTSTATUS': "techsupportmanagement.TechSupportStatus",
            'TERMINAL.AUDITLOG': "terminal.AuditLog",
            'TERRAFORM.EXECUTOR': "terraform.Executor",
            'THERMAL.POLICY': "thermal.Policy",
            'TOP.SYSTEM': "top.System",
            'UCSD.BACKUPINFO': "ucsd.BackupInfo",
            'UUIDPOOL.BLOCK': "uuidpool.Block",
            'UUIDPOOL.POOL': "uuidpool.Pool",
            'UUIDPOOL.POOLMEMBER': "uuidpool.PoolMember",
            'UUIDPOOL.UNIVERSE': "uuidpool.Universe",
            'UUIDPOOL.UUIDLEASE': "uuidpool.UuidLease",
            'VIRTUALIZATION.HOST': "virtualization.Host",
            'VIRTUALIZATION.VIRTUALDISK': "virtualization.VirtualDisk",
            'VIRTUALIZATION.VIRTUALMACHINE': "virtualization.VirtualMachine",
            'VIRTUALIZATION.VIRTUALNETWORK': "virtualization.VirtualNetwork",
            'VIRTUALIZATION.VMWARECLUSTER': "virtualization.VmwareCluster",
            'VIRTUALIZATION.VMWAREDATACENTER': "virtualization.VmwareDatacenter",
            'VIRTUALIZATION.VMWAREDATASTORE': "virtualization.VmwareDatastore",
            'VIRTUALIZATION.VMWAREDATASTORECLUSTER': "virtualization.VmwareDatastoreCluster",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDNETWORK': "virtualization.VmwareDistributedNetwork",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDSWITCH': "virtualization.VmwareDistributedSwitch",
            'VIRTUALIZATION.VMWAREFOLDER': "virtualization.VmwareFolder",
            'VIRTUALIZATION.VMWAREHOST': "virtualization.VmwareHost",
            'VIRTUALIZATION.VMWAREKERNELNETWORK': "virtualization.VmwareKernelNetwork",
            'VIRTUALIZATION.VMWARENETWORK': "virtualization.VmwareNetwork",
            'VIRTUALIZATION.VMWAREPHYSICALNETWORKINTERFACE': "virtualization.VmwarePhysicalNetworkInterface",
            'VIRTUALIZATION.VMWAREUPLINKPORT': "virtualization.VmwareUplinkPort",
            'VIRTUALIZATION.VMWAREVCENTER': "virtualization.VmwareVcenter",
            'VIRTUALIZATION.VMWAREVIRTUALDISK': "virtualization.VmwareVirtualDisk",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINE': "virtualization.VmwareVirtualMachine",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINESNAPSHOT': "virtualization.VmwareVirtualMachineSnapshot",
            'VIRTUALIZATION.VMWAREVIRTUALNETWORKINTERFACE': "virtualization.VmwareVirtualNetworkInterface",
            'VIRTUALIZATION.VMWAREVIRTUALSWITCH': "virtualization.VmwareVirtualSwitch",
            'VMEDIA.POLICY': "vmedia.Policy",
            'VMRC.CONSOLE': "vmrc.Console",
            'VNC.CONSOLE': "vnc.Console",
            'VNIC.ETHADAPTERPOLICY': "vnic.EthAdapterPolicy",
            'VNIC.ETHIF': "vnic.EthIf",
            'VNIC.ETHNETWORKPOLICY': "vnic.EthNetworkPolicy",
            'VNIC.ETHQOSPOLICY': "vnic.EthQosPolicy",
            'VNIC.FCADAPTERPOLICY': "vnic.FcAdapterPolicy",
            'VNIC.FCIF': "vnic.FcIf",
            'VNIC.FCNETWORKPOLICY': "vnic.FcNetworkPolicy",
            'VNIC.FCQOSPOLICY': "vnic.FcQosPolicy",
            'VNIC.ISCSIADAPTERPOLICY': "vnic.IscsiAdapterPolicy",
            'VNIC.ISCSIBOOTPOLICY': "vnic.IscsiBootPolicy",
            'VNIC.ISCSISTATICTARGETPOLICY': "vnic.IscsiStaticTargetPolicy",
            'VNIC.LANCONNECTIVITYPOLICY': "vnic.LanConnectivityPolicy",
            'VNIC.LCPSTATUS': "vnic.LcpStatus",
            'VNIC.SANCONNECTIVITYPOLICY': "vnic.SanConnectivityPolicy",
            'VNIC.SCPSTATUS': "vnic.ScpStatus",
            'VRF.VRF': "vrf.Vrf",
            'WORKFLOW.BATCHAPIEXECUTOR': "workflow.BatchApiExecutor",
            'WORKFLOW.BUILDTASKMETA': "workflow.BuildTaskMeta",
            'WORKFLOW.BUILDTASKMETAOWNER': "workflow.BuildTaskMetaOwner",
            'WORKFLOW.CATALOG': "workflow.Catalog",
            'WORKFLOW.CUSTOMDATATYPEDEFINITION': "workflow.CustomDataTypeDefinition",
            'WORKFLOW.ERRORRESPONSEHANDLER': "workflow.ErrorResponseHandler",
            'WORKFLOW.PENDINGDYNAMICWORKFLOWINFO': "workflow.PendingDynamicWorkflowInfo",
            'WORKFLOW.ROLLBACKWORKFLOW': "workflow.RollbackWorkflow",
            'WORKFLOW.SOLUTIONACTIONDEFINITION': "workflow.SolutionActionDefinition",
            'WORKFLOW.SOLUTIONACTIONINSTANCE': "workflow.SolutionActionInstance",
            'WORKFLOW.SOLUTIONDEFINITION': "workflow.SolutionDefinition",
            'WORKFLOW.SOLUTIONINSTANCE': "workflow.SolutionInstance",
            'WORKFLOW.SOLUTIONOUTPUT': "workflow.SolutionOutput",
            'WORKFLOW.TASKDEBUGLOG': "workflow.TaskDebugLog",
            'WORKFLOW.TASKDEFINITION': "workflow.TaskDefinition",
            'WORKFLOW.TASKINFO': "workflow.TaskInfo",
            'WORKFLOW.TASKMETADATA': "workflow.TaskMetadata",
            'WORKFLOW.TASKNOTIFICATION': "workflow.TaskNotification",
            'WORKFLOW.TEMPLATEEVALUATION': "workflow.TemplateEvaluation",
            'WORKFLOW.TEMPLATEFUNCTIONMETA': "workflow.TemplateFunctionMeta",
            'WORKFLOW.WORKFLOWDEFINITION': "workflow.WorkflowDefinition",
            'WORKFLOW.WORKFLOWINFO': "workflow.WorkflowInfo",
            'WORKFLOW.WORKFLOWMETA': "workflow.WorkflowMeta",
            'WORKFLOW.WORKFLOWMETADATA': "workflow.WorkflowMetadata",
            'WORKFLOW.WORKFLOWNOTIFICATION': "workflow.WorkflowNotification",
        },
        ('object_type',): {
            'AAA.AUDITRECORD': "aaa.AuditRecord",
            'AAA.RETENTIONCONFIG': "aaa.RetentionConfig",
            'AAA.RETENTIONPOLICY': "aaa.RetentionPolicy",
            'ACCESS.POLICY': "access.Policy",
            'ADAPTER.CONFIGPOLICY': "adapter.ConfigPolicy",
            'ADAPTER.EXTETHINTERFACE': "adapter.ExtEthInterface",
            'ADAPTER.HOSTETHINTERFACE': "adapter.HostEthInterface",
            'ADAPTER.HOSTFCINTERFACE': "adapter.HostFcInterface",
            'ADAPTER.HOSTISCSIINTERFACE': "adapter.HostIscsiInterface",
            'ADAPTER.UNIT': "adapter.Unit",
            'ADAPTER.UNITEXPANDER': "adapter.UnitExpander",
            'APPLIANCE.APPSTATUS': "appliance.AppStatus",
            'APPLIANCE.AUTORMAPOLICY': "appliance.AutoRmaPolicy",
            'APPLIANCE.BACKUP': "appliance.Backup",
            'APPLIANCE.BACKUPPOLICY': "appliance.BackupPolicy",
            'APPLIANCE.CERTIFICATESETTING': "appliance.CertificateSetting",
            'APPLIANCE.DATAEXPORTPOLICY': "appliance.DataExportPolicy",
            'APPLIANCE.DEVICECERTIFICATE': "appliance.DeviceCertificate",
            'APPLIANCE.DEVICECLAIM': "appliance.DeviceClaim",
            'APPLIANCE.DEVICEUPGRADEPOLICY': "appliance.DeviceUpgradePolicy",
            'APPLIANCE.DIAGSETTING': "appliance.DiagSetting",
            'APPLIANCE.EXTERNALSYSLOGSETTING': "appliance.ExternalSyslogSetting",
            'APPLIANCE.FILEGATEWAY': "appliance.FileGateway",
            'APPLIANCE.FILESYSTEMSTATUS': "appliance.FileSystemStatus",
            'APPLIANCE.GROUPSTATUS': "appliance.GroupStatus",
            'APPLIANCE.IMAGEBUNDLE': "appliance.ImageBundle",
            'APPLIANCE.NODEINFO': "appliance.NodeInfo",
            'APPLIANCE.NODESTATUS': "appliance.NodeStatus",
            'APPLIANCE.RELEASENOTE': "appliance.ReleaseNote",
            'APPLIANCE.REMOTEFILEIMPORT': "appliance.RemoteFileImport",
            'APPLIANCE.RESTORE': "appliance.Restore",
            'APPLIANCE.SETUPINFO': "appliance.SetupInfo",
            'APPLIANCE.SYSTEMINFO': "appliance.SystemInfo",
            'APPLIANCE.SYSTEMSTATUS': "appliance.SystemStatus",
            'APPLIANCE.UPGRADE': "appliance.Upgrade",
            'APPLIANCE.UPGRADEPOLICY': "appliance.UpgradePolicy",
            'ASSET.CLUSTERMEMBER': "asset.ClusterMember",
            'ASSET.DEPLOYMENT': "asset.Deployment",
            'ASSET.DEPLOYMENTDEVICE': "asset.DeploymentDevice",
            'ASSET.DEVICECLAIM': "asset.DeviceClaim",
            'ASSET.DEVICECONFIGURATION': "asset.DeviceConfiguration",
            'ASSET.DEVICECONNECTORMANAGER': "asset.DeviceConnectorManager",
            'ASSET.DEVICECONTRACTINFORMATION': "asset.DeviceContractInformation",
            'ASSET.DEVICEREGISTRATION': "asset.DeviceRegistration",
            'ASSET.SUBSCRIPTION': "asset.Subscription",
            'ASSET.SUBSCRIPTIONACCOUNT': "asset.SubscriptionAccount",
            'ASSET.SUBSCRIPTIONDEVICECONTRACTINFORMATION': "asset.SubscriptionDeviceContractInformation",
            'ASSET.TARGET': "asset.Target",
            'BIOS.BOOTDEVICE': "bios.BootDevice",
            'BIOS.BOOTMODE': "bios.BootMode",
            'BIOS.POLICY': "bios.Policy",
            'BIOS.SYSTEMBOOTORDER': "bios.SystemBootOrder",
            'BIOS.TOKENSETTINGS': "bios.TokenSettings",
            'BIOS.UNIT': "bios.Unit",
            'BIOS.VFSELECTMEMORYRASCONFIGURATION': "bios.VfSelectMemoryRasConfiguration",
            'BOOT.CDDDEVICE': "boot.CddDevice",
            'BOOT.DEVICEBOOTMODE': "boot.DeviceBootMode",
            'BOOT.DEVICEBOOTSECURITY': "boot.DeviceBootSecurity",
            'BOOT.HDDDEVICE': "boot.HddDevice",
            'BOOT.ISCSIDEVICE': "boot.IscsiDevice",
            'BOOT.NVMEDEVICE': "boot.NvmeDevice",
            'BOOT.PCHSTORAGEDEVICE': "boot.PchStorageDevice",
            'BOOT.PRECISIONPOLICY': "boot.PrecisionPolicy",
            'BOOT.PXEDEVICE': "boot.PxeDevice",
            'BOOT.SANDEVICE': "boot.SanDevice",
            'BOOT.SDDEVICE': "boot.SdDevice",
            'BOOT.UEFISHELLDEVICE': "boot.UefiShellDevice",
            'BOOT.USBDEVICE': "boot.UsbDevice",
            'BOOT.VMEDIADEVICE': "boot.VmediaDevice",
            'BULK.EXPORT': "bulk.Export",
            'BULK.EXPORTEDITEM': "bulk.ExportedItem",
            'BULK.MOCLONER': "bulk.MoCloner",
            'BULK.MOMERGER': "bulk.MoMerger",
            'BULK.REQUEST': "bulk.Request",
            'BULK.SUBREQUESTOBJ': "bulk.SubRequestObj",
            'CAPABILITY.ADAPTERUNITDESCRIPTOR': "capability.AdapterUnitDescriptor",
            'CAPABILITY.CATALOG': "capability.Catalog",
            'CAPABILITY.CHASSISDESCRIPTOR': "capability.ChassisDescriptor",
            'CAPABILITY.CHASSISMANUFACTURINGDEF': "capability.ChassisManufacturingDef",
            'CAPABILITY.CIMCFIRMWAREDESCRIPTOR': "capability.CimcFirmwareDescriptor",
            'CAPABILITY.EQUIPMENTPHYSICALDEF': "capability.EquipmentPhysicalDef",
            'CAPABILITY.EQUIPMENTSLOTARRAY': "capability.EquipmentSlotArray",
            'CAPABILITY.FANMODULEDESCRIPTOR': "capability.FanModuleDescriptor",
            'CAPABILITY.FANMODULEMANUFACTURINGDEF': "capability.FanModuleManufacturingDef",
            'CAPABILITY.IOCARDCAPABILITYDEF': "capability.IoCardCapabilityDef",
            'CAPABILITY.IOCARDDESCRIPTOR': "capability.IoCardDescriptor",
            'CAPABILITY.IOCARDMANUFACTURINGDEF': "capability.IoCardManufacturingDef",
            'CAPABILITY.PORTGROUPAGGREGATIONDEF': "capability.PortGroupAggregationDef",
            'CAPABILITY.PSUDESCRIPTOR': "capability.PsuDescriptor",
            'CAPABILITY.PSUMANUFACTURINGDEF': "capability.PsuManufacturingDef",
            'CAPABILITY.SERVERMODELSCAPABILITYDEF': "capability.ServerModelsCapabilityDef",
            'CAPABILITY.SERVERSCHEMADESCRIPTOR': "capability.ServerSchemaDescriptor",
            'CAPABILITY.SIOCMODULECAPABILITYDEF': "capability.SiocModuleCapabilityDef",
            'CAPABILITY.SIOCMODULEDESCRIPTOR': "capability.SiocModuleDescriptor",
            'CAPABILITY.SIOCMODULEMANUFACTURINGDEF': "capability.SiocModuleManufacturingDef",
            'CAPABILITY.SWITCHCAPABILITY': "capability.SwitchCapability",
            'CAPABILITY.SWITCHDESCRIPTOR': "capability.SwitchDescriptor",
            'CAPABILITY.SWITCHMANUFACTURINGDEF': "capability.SwitchManufacturingDef",
            'CERTIFICATEMANAGEMENT.POLICY': "certificatemanagement.Policy",
            'CHASSIS.CONFIGCHANGEDETAIL': "chassis.ConfigChangeDetail",
            'CHASSIS.CONFIGIMPORT': "chassis.ConfigImport",
            'CHASSIS.CONFIGRESULT': "chassis.ConfigResult",
            'CHASSIS.CONFIGRESULTENTRY': "chassis.ConfigResultEntry",
            'CHASSIS.IOMPROFILE': "chassis.IomProfile",
            'CHASSIS.PROFILE': "chassis.Profile",
            'CLOUD.AWSBILLINGUNIT': "cloud.AwsBillingUnit",
            'CLOUD.AWSKEYPAIR': "cloud.AwsKeyPair",
            'CLOUD.AWSNETWORKINTERFACE': "cloud.AwsNetworkInterface",
            'CLOUD.AWSORGANIZATIONALUNIT': "cloud.AwsOrganizationalUnit",
            'CLOUD.AWSSECURITYGROUP': "cloud.AwsSecurityGroup",
            'CLOUD.AWSSUBNET': "cloud.AwsSubnet",
            'CLOUD.AWSVIRTUALMACHINE': "cloud.AwsVirtualMachine",
            'CLOUD.AWSVOLUME': "cloud.AwsVolume",
            'CLOUD.AWSVPC': "cloud.AwsVpc",
            'CLOUD.COLLECTINVENTORY': "cloud.CollectInventory",
            'CLOUD.REGIONS': "cloud.Regions",
            'CLOUD.SKUCONTAINERTYPE': "cloud.SkuContainerType",
            'CLOUD.SKUDATABASETYPE': "cloud.SkuDatabaseType",
            'CLOUD.SKUINSTANCETYPE': "cloud.SkuInstanceType",
            'CLOUD.SKUNETWORKTYPE': "cloud.SkuNetworkType",
            'CLOUD.SKUREGIONRATECARDS': "cloud.SkuRegionRateCards",
            'CLOUD.SKUVOLUMETYPE': "cloud.SkuVolumeType",
            'CLOUD.TFCAGENTPOOL': "cloud.TfcAgentpool",
            'CLOUD.TFCORGANIZATION': "cloud.TfcOrganization",
            'CLOUD.TFCWORKSPACE': "cloud.TfcWorkspace",
            'COMM.HTTPPROXYPOLICY': "comm.HttpProxyPolicy",
            'COMPUTE.BIOSPOSTPOLICY': "compute.BiosPostPolicy",
            'COMPUTE.BLADE': "compute.Blade",
            'COMPUTE.BLADEIDENTITY': "compute.BladeIdentity",
            'COMPUTE.BOARD': "compute.Board",
            'COMPUTE.MAPPING': "compute.Mapping",
            'COMPUTE.PHYSICALSUMMARY': "compute.PhysicalSummary",
            'COMPUTE.RACKUNIT': "compute.RackUnit",
            'COMPUTE.RACKUNITIDENTITY': "compute.RackUnitIdentity",
            'COMPUTE.SERVERPOWERPOLICY': "compute.ServerPowerPolicy",
            'COMPUTE.SERVERSETTING': "compute.ServerSetting",
            'COMPUTE.VMEDIA': "compute.Vmedia",
            'COND.ALARM': "cond.Alarm",
            'COND.ALARMAGGREGATION': "cond.AlarmAggregation",
            'COND.HCLSTATUS': "cond.HclStatus",
            'COND.HCLSTATUSDETAIL': "cond.HclStatusDetail",
            'COND.HCLSTATUSJOB': "cond.HclStatusJob",
            'CONNECTORPACK.CONNECTORPACKUPGRADE': "connectorpack.ConnectorPackUpgrade",
            'CONNECTORPACK.UPGRADEIMPACT': "connectorpack.UpgradeImpact",
            'CONVERGEDINFRA.HEALTHCHECKDEFINITION': "convergedinfra.HealthCheckDefinition",
            'CONVERGEDINFRA.HEALTHCHECKEXECUTION': "convergedinfra.HealthCheckExecution",
            'CONVERGEDINFRA.POD': "convergedinfra.Pod",
            'CRD.CUSTOMRESOURCE': "crd.CustomResource",
            'DEVICECONNECTOR.POLICY': "deviceconnector.Policy",
            'EQUIPMENT.CHASSIS': "equipment.Chassis",
            'EQUIPMENT.CHASSISIDENTITY': "equipment.ChassisIdentity",
            'EQUIPMENT.CHASSISOPERATION': "equipment.ChassisOperation",
            'EQUIPMENT.DEVICESUMMARY': "equipment.DeviceSummary",
            'EQUIPMENT.EXPANDERMODULE': "equipment.ExpanderModule",
            'EQUIPMENT.FAN': "equipment.Fan",
            'EQUIPMENT.FANCONTROL': "equipment.FanControl",
            'EQUIPMENT.FANMODULE': "equipment.FanModule",
            'EQUIPMENT.FEX': "equipment.Fex",
            'EQUIPMENT.FEXIDENTITY': "equipment.FexIdentity",
            'EQUIPMENT.FEXOPERATION': "equipment.FexOperation",
            'EQUIPMENT.FRU': "equipment.Fru",
            'EQUIPMENT.IDENTITYSUMMARY': "equipment.IdentitySummary",
            'EQUIPMENT.IOCARD': "equipment.IoCard",
            'EQUIPMENT.IOCARDOPERATION': "equipment.IoCardOperation",
            'EQUIPMENT.IOEXPANDER': "equipment.IoExpander",
            'EQUIPMENT.LOCATORLED': "equipment.LocatorLed",
            'EQUIPMENT.PSU': "equipment.Psu",
            'EQUIPMENT.PSUCONTROL': "equipment.PsuControl",
            'EQUIPMENT.RACKENCLOSURE': "equipment.RackEnclosure",
            'EQUIPMENT.RACKENCLOSURESLOT': "equipment.RackEnclosureSlot",
            'EQUIPMENT.SHAREDIOMODULE': "equipment.SharedIoModule",
            'EQUIPMENT.SWITCHCARD': "equipment.SwitchCard",
            'EQUIPMENT.SYSTEMIOCONTROLLER': "equipment.SystemIoController",
            'EQUIPMENT.TPM': "equipment.Tpm",
            'EQUIPMENT.TRANSCEIVER': "equipment.Transceiver",
            'ETHER.HOSTPORT': "ether.HostPort",
            'ETHER.NETWORKPORT': "ether.NetworkPort",
            'ETHER.PHYSICALPORT': "ether.PhysicalPort",
            'ETHER.PORTCHANNEL': "ether.PortChannel",
            'EXTERNALSITE.AUTHORIZATION': "externalsite.Authorization",
            'FABRIC.APPLIANCEPCROLE': "fabric.AppliancePcRole",
            'FABRIC.APPLIANCEROLE': "fabric.ApplianceRole",
            'FABRIC.CONFIGCHANGEDETAIL': "fabric.ConfigChangeDetail",
            'FABRIC.CONFIGRESULT': "fabric.ConfigResult",
            'FABRIC.CONFIGRESULTENTRY': "fabric.ConfigResultEntry",
            'FABRIC.ELEMENTIDENTITY': "fabric.ElementIdentity",
            'FABRIC.ESTIMATEIMPACT': "fabric.EstimateImpact",
            'FABRIC.ETHNETWORKCONTROLPOLICY': "fabric.EthNetworkControlPolicy",
            'FABRIC.ETHNETWORKGROUPPOLICY': "fabric.EthNetworkGroupPolicy",
            'FABRIC.ETHNETWORKPOLICY': "fabric.EthNetworkPolicy",
            'FABRIC.FCNETWORKPOLICY': "fabric.FcNetworkPolicy",
            'FABRIC.FCUPLINKPCROLE': "fabric.FcUplinkPcRole",
            'FABRIC.FCUPLINKROLE': "fabric.FcUplinkRole",
            'FABRIC.FCOEUPLINKPCROLE': "fabric.FcoeUplinkPcRole",
            'FABRIC.FCOEUPLINKROLE': "fabric.FcoeUplinkRole",
            'FABRIC.FLOWCONTROLPOLICY': "fabric.FlowControlPolicy",
            'FABRIC.LINKAGGREGATIONPOLICY': "fabric.LinkAggregationPolicy",
            'FABRIC.LINKCONTROLPOLICY': "fabric.LinkControlPolicy",
            'FABRIC.MULTICASTPOLICY': "fabric.MulticastPolicy",
            'FABRIC.PCMEMBER': "fabric.PcMember",
            'FABRIC.PCOPERATION': "fabric.PcOperation",
            'FABRIC.PORTMODE': "fabric.PortMode",
            'FABRIC.PORTOPERATION': "fabric.PortOperation",
            'FABRIC.PORTPOLICY': "fabric.PortPolicy",
            'FABRIC.SERVERROLE': "fabric.ServerRole",
            'FABRIC.SWITCHCLUSTERPROFILE': "fabric.SwitchClusterProfile",
            'FABRIC.SWITCHCONTROLPOLICY': "fabric.SwitchControlPolicy",
            'FABRIC.SWITCHPROFILE': "fabric.SwitchProfile",
            'FABRIC.SYSTEMQOSPOLICY': "fabric.SystemQosPolicy",
            'FABRIC.UPLINKPCROLE': "fabric.UplinkPcRole",
            'FABRIC.UPLINKROLE': "fabric.UplinkRole",
            'FABRIC.VLAN': "fabric.Vlan",
            'FABRIC.VSAN': "fabric.Vsan",
            'FAULT.INSTANCE': "fault.Instance",
            'FC.PHYSICALPORT': "fc.PhysicalPort",
            'FC.PORTCHANNEL': "fc.PortChannel",
            'FCPOOL.FCBLOCK': "fcpool.FcBlock",
            'FCPOOL.LEASE': "fcpool.Lease",
            'FCPOOL.POOL': "fcpool.Pool",
            'FCPOOL.POOLMEMBER': "fcpool.PoolMember",
            'FCPOOL.UNIVERSE': "fcpool.Universe",
            'FEEDBACK.FEEDBACKPOST': "feedback.FeedbackPost",
            'FIRMWARE.BIOSDESCRIPTOR': "firmware.BiosDescriptor",
            'FIRMWARE.BOARDCONTROLLERDESCRIPTOR': "firmware.BoardControllerDescriptor",
            'FIRMWARE.CHASSISUPGRADE': "firmware.ChassisUpgrade",
            'FIRMWARE.CIMCDESCRIPTOR': "firmware.CimcDescriptor",
            'FIRMWARE.DIMMDESCRIPTOR': "firmware.DimmDescriptor",
            'FIRMWARE.DISTRIBUTABLE': "firmware.Distributable",
            'FIRMWARE.DISTRIBUTABLEMETA': "firmware.DistributableMeta",
            'FIRMWARE.DRIVEDESCRIPTOR': "firmware.DriveDescriptor",
            'FIRMWARE.DRIVERDISTRIBUTABLE': "firmware.DriverDistributable",
            'FIRMWARE.EULA': "firmware.Eula",
            'FIRMWARE.FIRMWARESUMMARY': "firmware.FirmwareSummary",
            'FIRMWARE.GPUDESCRIPTOR': "firmware.GpuDescriptor",
            'FIRMWARE.HBADESCRIPTOR': "firmware.HbaDescriptor",
            'FIRMWARE.IOMDESCRIPTOR': "firmware.IomDescriptor",
            'FIRMWARE.MSWITCHDESCRIPTOR': "firmware.MswitchDescriptor",
            'FIRMWARE.NXOSDESCRIPTOR': "firmware.NxosDescriptor",
            'FIRMWARE.PCIEDESCRIPTOR': "firmware.PcieDescriptor",
            'FIRMWARE.PSUDESCRIPTOR': "firmware.PsuDescriptor",
            'FIRMWARE.RUNNINGFIRMWARE': "firmware.RunningFirmware",
            'FIRMWARE.SASEXPANDERDESCRIPTOR': "firmware.SasExpanderDescriptor",
            'FIRMWARE.SERVERCONFIGURATIONUTILITYDISTRIBUTABLE': "firmware.ServerConfigurationUtilityDistributable",
            'FIRMWARE.STORAGECONTROLLERDESCRIPTOR': "firmware.StorageControllerDescriptor",
            'FIRMWARE.SWITCHUPGRADE': "firmware.SwitchUpgrade",
            'FIRMWARE.UNSUPPORTEDVERSIONUPGRADE': "firmware.UnsupportedVersionUpgrade",
            'FIRMWARE.UPGRADE': "firmware.Upgrade",
            'FIRMWARE.UPGRADEIMPACT': "firmware.UpgradeImpact",
            'FIRMWARE.UPGRADEIMPACTSTATUS': "firmware.UpgradeImpactStatus",
            'FIRMWARE.UPGRADESTATUS': "firmware.UpgradeStatus",
            'FORECAST.CATALOG': "forecast.Catalog",
            'FORECAST.DEFINITION': "forecast.Definition",
            'FORECAST.INSTANCE': "forecast.Instance",
            'GRAPHICS.CARD': "graphics.Card",
            'GRAPHICS.CONTROLLER': "graphics.Controller",
            'HCL.COMPATIBILITYSTATUS': "hcl.CompatibilityStatus",
            'HCL.DRIVERIMAGE': "hcl.DriverImage",
            'HCL.EXEMPTEDCATALOG': "hcl.ExemptedCatalog",
            'HCL.HYPERFLEXSOFTWARECOMPATIBILITYINFO': "hcl.HyperflexSoftwareCompatibilityInfo",
            'HCL.OPERATINGSYSTEM': "hcl.OperatingSystem",
            'HCL.OPERATINGSYSTEMVENDOR': "hcl.OperatingSystemVendor",
            'HCL.SUPPORTEDDRIVERNAME': "hcl.SupportedDriverName",
            'HYPERFLEX.ALARM': "hyperflex.Alarm",
            'HYPERFLEX.APPCATALOG': "hyperflex.AppCatalog",
            'HYPERFLEX.AUTOSUPPORTPOLICY': "hyperflex.AutoSupportPolicy",
            'HYPERFLEX.BACKUPCLUSTER': "hyperflex.BackupCluster",
            'HYPERFLEX.CAPABILITYINFO': "hyperflex.CapabilityInfo",
            'HYPERFLEX.CISCOHYPERVISORMANAGER': "hyperflex.CiscoHypervisorManager",
            'HYPERFLEX.CLUSTER': "hyperflex.Cluster",
            'HYPERFLEX.CLUSTERBACKUPPOLICY': "hyperflex.ClusterBackupPolicy",
            'HYPERFLEX.CLUSTERBACKUPPOLICYDEPLOYMENT': "hyperflex.ClusterBackupPolicyDeployment",
            'HYPERFLEX.CLUSTERBACKUPPOLICYINVENTORY': "hyperflex.ClusterBackupPolicyInventory",
            'HYPERFLEX.CLUSTERHEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.ClusterHealthCheckExecutionSnapshot",
            'HYPERFLEX.CLUSTERNETWORKPOLICY': "hyperflex.ClusterNetworkPolicy",
            'HYPERFLEX.CLUSTERPROFILE': "hyperflex.ClusterProfile",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICY': "hyperflex.ClusterReplicationNetworkPolicy",
            'HYPERFLEX.CLUSTERREPLICATIONNETWORKPOLICYDEPLOYMENT': "hyperflex.ClusterReplicationNetworkPolicyDeployment",
            'HYPERFLEX.CLUSTERSTORAGEPOLICY': "hyperflex.ClusterStoragePolicy",
            'HYPERFLEX.CONFIGRESULT': "hyperflex.ConfigResult",
            'HYPERFLEX.CONFIGRESULTENTRY': "hyperflex.ConfigResultEntry",
            'HYPERFLEX.DATAPROTECTIONPEER': "hyperflex.DataProtectionPeer",
            'HYPERFLEX.DATASTORESTATISTIC': "hyperflex.DatastoreStatistic",
            'HYPERFLEX.DEVICEPACKAGEDOWNLOADSTATE': "hyperflex.DevicePackageDownloadState",
            'HYPERFLEX.DRIVE': "hyperflex.Drive",
            'HYPERFLEX.EXTFCSTORAGEPOLICY': "hyperflex.ExtFcStoragePolicy",
            'HYPERFLEX.EXTISCSISTORAGEPOLICY': "hyperflex.ExtIscsiStoragePolicy",
            'HYPERFLEX.FEATURELIMITEXTERNAL': "hyperflex.FeatureLimitExternal",
            'HYPERFLEX.FEATURELIMITINTERNAL': "hyperflex.FeatureLimitInternal",
            'HYPERFLEX.HEALTH': "hyperflex.Health",
            'HYPERFLEX.HEALTHCHECKDEFINITION': "hyperflex.HealthCheckDefinition",
            'HYPERFLEX.HEALTHCHECKEXECUTION': "hyperflex.HealthCheckExecution",
            'HYPERFLEX.HEALTHCHECKEXECUTIONSNAPSHOT': "hyperflex.HealthCheckExecutionSnapshot",
            'HYPERFLEX.HEALTHCHECKPACKAGECHECKSUM': "hyperflex.HealthCheckPackageChecksum",
            'HYPERFLEX.HXAPCLUSTER': "hyperflex.HxapCluster",
            'HYPERFLEX.HXAPDATACENTER': "hyperflex.HxapDatacenter",
            'HYPERFLEX.HXAPDVUPLINK': "hyperflex.HxapDvUplink",
            'HYPERFLEX.HXAPDVSWITCH': "hyperflex.HxapDvswitch",
            'HYPERFLEX.HXAPHOST': "hyperflex.HxapHost",
            'HYPERFLEX.HXAPHOSTINTERFACE': "hyperflex.HxapHostInterface",
            'HYPERFLEX.HXAPHOSTVSWITCH': "hyperflex.HxapHostVswitch",
            'HYPERFLEX.HXAPNETWORK': "hyperflex.HxapNetwork",
            'HYPERFLEX.HXAPVIRTUALDISK': "hyperflex.HxapVirtualDisk",
            'HYPERFLEX.HXAPVIRTUALMACHINE': "hyperflex.HxapVirtualMachine",
            'HYPERFLEX.HXAPVIRTUALMACHINENETWORKINTERFACE': "hyperflex.HxapVirtualMachineNetworkInterface",
            'HYPERFLEX.HXDPVERSION': "hyperflex.HxdpVersion",
            'HYPERFLEX.LICENSE': "hyperflex.License",
            'HYPERFLEX.LOCALCREDENTIALPOLICY': "hyperflex.LocalCredentialPolicy",
            'HYPERFLEX.NODE': "hyperflex.Node",
            'HYPERFLEX.NODECONFIGPOLICY': "hyperflex.NodeConfigPolicy",
            'HYPERFLEX.NODEPROFILE': "hyperflex.NodeProfile",
            'HYPERFLEX.PROTECTEDCLUSTER': "hyperflex.ProtectedCluster",
            'HYPERFLEX.PROXYSETTINGPOLICY': "hyperflex.ProxySettingPolicy",
            'HYPERFLEX.SERVERFIRMWAREVERSION': "hyperflex.ServerFirmwareVersion",
            'HYPERFLEX.SERVERFIRMWAREVERSIONENTRY': "hyperflex.ServerFirmwareVersionEntry",
            'HYPERFLEX.SERVERMODEL': "hyperflex.ServerModel",
            'HYPERFLEX.SERVICEAUTHTOKEN': "hyperflex.ServiceAuthToken",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONCOMPONENT': "hyperflex.SoftwareDistributionComponent",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONENTRY': "hyperflex.SoftwareDistributionEntry",
            'HYPERFLEX.SOFTWAREDISTRIBUTIONVERSION': "hyperflex.SoftwareDistributionVersion",
            'HYPERFLEX.SOFTWAREVERSIONPOLICY': "hyperflex.SoftwareVersionPolicy",
            'HYPERFLEX.STORAGECONTAINER': "hyperflex.StorageContainer",
            'HYPERFLEX.SYSCONFIGPOLICY': "hyperflex.SysConfigPolicy",
            'HYPERFLEX.UCSMCONFIGPOLICY': "hyperflex.UcsmConfigPolicy",
            'HYPERFLEX.VCENTERCONFIGPOLICY': "hyperflex.VcenterConfigPolicy",
            'HYPERFLEX.VMBACKUPINFO': "hyperflex.VmBackupInfo",
            'HYPERFLEX.VMIMPORTOPERATION': "hyperflex.VmImportOperation",
            'HYPERFLEX.VMRESTOREOPERATION': "hyperflex.VmRestoreOperation",
            'HYPERFLEX.VMSNAPSHOTINFO': "hyperflex.VmSnapshotInfo",
            'HYPERFLEX.VOLUME': "hyperflex.Volume",
            'HYPERFLEX.WITNESSCONFIGURATION': "hyperflex.WitnessConfiguration",
            'IAAS.CONNECTORPACK': "iaas.ConnectorPack",
            'IAAS.DEVICESTATUS': "iaas.DeviceStatus",
            'IAAS.DIAGNOSTICMESSAGES': "iaas.DiagnosticMessages",
            'IAAS.LICENSEINFO': "iaas.LicenseInfo",
            'IAAS.MOSTRUNTASKS': "iaas.MostRunTasks",
            'IAAS.SERVICEREQUEST': "iaas.ServiceRequest",
            'IAAS.UCSDINFO': "iaas.UcsdInfo",
            'IAAS.UCSDMANAGEDINFRA': "iaas.UcsdManagedInfra",
            'IAAS.UCSDMESSAGES': "iaas.UcsdMessages",
            'IAM.ACCOUNT': "iam.Account",
            'IAM.ACCOUNTEXPERIENCE': "iam.AccountExperience",
            'IAM.APIKEY': "iam.ApiKey",
            'IAM.APPREGISTRATION': "iam.AppRegistration",
            'IAM.BANNERMESSAGE': "iam.BannerMessage",
            'IAM.CERTIFICATE': "iam.Certificate",
            'IAM.CERTIFICATEREQUEST': "iam.CertificateRequest",
            'IAM.DOMAINGROUP': "iam.DomainGroup",
            'IAM.ENDPOINTPRIVILEGE': "iam.EndPointPrivilege",
            'IAM.ENDPOINTROLE': "iam.EndPointRole",
            'IAM.ENDPOINTUSER': "iam.EndPointUser",
            'IAM.ENDPOINTUSERPOLICY': "iam.EndPointUserPolicy",
            'IAM.ENDPOINTUSERROLE': "iam.EndPointUserRole",
            'IAM.IDP': "iam.Idp",
            'IAM.IDPREFERENCE': "iam.IdpReference",
            'IAM.IPACCESSMANAGEMENT': "iam.IpAccessManagement",
            'IAM.IPADDRESS': "iam.IpAddress",
            'IAM.LDAPGROUP': "iam.LdapGroup",
            'IAM.LDAPPOLICY': "iam.LdapPolicy",
            'IAM.LDAPPROVIDER': "iam.LdapProvider",
            'IAM.LOCALUSERPASSWORD': "iam.LocalUserPassword",
            'IAM.LOCALUSERPASSWORDPOLICY': "iam.LocalUserPasswordPolicy",
            'IAM.OAUTHTOKEN': "iam.OAuthToken",
            'IAM.PERMISSION': "iam.Permission",
            'IAM.PRIVATEKEYSPEC': "iam.PrivateKeySpec",
            'IAM.PRIVILEGE': "iam.Privilege",
            'IAM.PRIVILEGESET': "iam.PrivilegeSet",
            'IAM.QUALIFIER': "iam.Qualifier",
            'IAM.RESOURCELIMITS': "iam.ResourceLimits",
            'IAM.RESOURCEPERMISSION': "iam.ResourcePermission",
            'IAM.RESOURCEROLES': "iam.ResourceRoles",
            'IAM.ROLE': "iam.Role",
            'IAM.SECURITYHOLDER': "iam.SecurityHolder",
            'IAM.SERVICEPROVIDER': "iam.ServiceProvider",
            'IAM.SESSION': "iam.Session",
            'IAM.SESSIONLIMITS': "iam.SessionLimits",
            'IAM.SYSTEM': "iam.System",
            'IAM.TRUSTPOINT': "iam.TrustPoint",
            'IAM.USER': "iam.User",
            'IAM.USERGROUP': "iam.UserGroup",
            'IAM.USERPREFERENCE': "iam.UserPreference",
            'INVENTORY.DEVICEINFO': "inventory.DeviceInfo",
            'INVENTORY.DNMOBINDING': "inventory.DnMoBinding",
            'INVENTORY.GENERICINVENTORY': "inventory.GenericInventory",
            'INVENTORY.GENERICINVENTORYHOLDER': "inventory.GenericInventoryHolder",
            'INVENTORY.REQUEST': "inventory.Request",
            'IPMIOVERLAN.POLICY': "ipmioverlan.Policy",
            'IPPOOL.BLOCKLEASE': "ippool.BlockLease",
            'IPPOOL.IPLEASE': "ippool.IpLease",
            'IPPOOL.POOL': "ippool.Pool",
            'IPPOOL.POOLMEMBER': "ippool.PoolMember",
            'IPPOOL.SHADOWBLOCK': "ippool.ShadowBlock",
            'IPPOOL.SHADOWPOOL': "ippool.ShadowPool",
            'IPPOOL.UNIVERSE': "ippool.Universe",
            'IQNPOOL.BLOCK': "iqnpool.Block",
            'IQNPOOL.LEASE': "iqnpool.Lease",
            'IQNPOOL.POOL': "iqnpool.Pool",
            'IQNPOOL.POOLMEMBER': "iqnpool.PoolMember",
            'IQNPOOL.UNIVERSE': "iqnpool.Universe",
            'IWOTENANT.TENANTSTATUS': "iwotenant.TenantStatus",
            'KUBERNETES.ACICNIAPIC': "kubernetes.AciCniApic",
            'KUBERNETES.ACICNIPROFILE': "kubernetes.AciCniProfile",
            'KUBERNETES.ACICNITENANTCLUSTERALLOCATION': "kubernetes.AciCniTenantClusterAllocation",
            'KUBERNETES.ADDONDEFINITION': "kubernetes.AddonDefinition",
            'KUBERNETES.ADDONPOLICY': "kubernetes.AddonPolicy",
            'KUBERNETES.ADDONREPOSITORY': "kubernetes.AddonRepository",
            'KUBERNETES.BAREMETALNODEPROFILE': "kubernetes.BaremetalNodeProfile",
            'KUBERNETES.CATALOG': "kubernetes.Catalog",
            'KUBERNETES.CLUSTER': "kubernetes.Cluster",
            'KUBERNETES.CLUSTERADDONPROFILE': "kubernetes.ClusterAddonProfile",
            'KUBERNETES.CLUSTERPROFILE': "kubernetes.ClusterProfile",
            'KUBERNETES.CONFIGRESULT': "kubernetes.ConfigResult",
            'KUBERNETES.CONFIGRESULTENTRY': "kubernetes.ConfigResultEntry",
            'KUBERNETES.CONTAINERRUNTIMEPOLICY': "kubernetes.ContainerRuntimePolicy",
            'KUBERNETES.DAEMONSET': "kubernetes.DaemonSet",
            'KUBERNETES.DEPLOYMENT': "kubernetes.Deployment",
            'KUBERNETES.INGRESS': "kubernetes.Ingress",
            'KUBERNETES.NETWORKPOLICY': "kubernetes.NetworkPolicy",
            'KUBERNETES.NODE': "kubernetes.Node",
            'KUBERNETES.NODEGROUPPROFILE': "kubernetes.NodeGroupProfile",
            'KUBERNETES.POD': "kubernetes.Pod",
            'KUBERNETES.SERVICE': "kubernetes.Service",
            'KUBERNETES.STATEFULSET': "kubernetes.StatefulSet",
            'KUBERNETES.SYSCONFIGPOLICY': "kubernetes.SysConfigPolicy",
            'KUBERNETES.TRUSTEDREGISTRIESPOLICY': "kubernetes.TrustedRegistriesPolicy",
            'KUBERNETES.VERSION': "kubernetes.Version",
            'KUBERNETES.VERSIONPOLICY': "kubernetes.VersionPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRACONFIGPOLICY': "kubernetes.VirtualMachineInfraConfigPolicy",
            'KUBERNETES.VIRTUALMACHINEINFRASTRUCTUREPROVIDER': "kubernetes.VirtualMachineInfrastructureProvider",
            'KUBERNETES.VIRTUALMACHINEINSTANCETYPE': "kubernetes.VirtualMachineInstanceType",
            'KUBERNETES.VIRTUALMACHINENODEPROFILE': "kubernetes.VirtualMachineNodeProfile",
            'KVM.POLICY': "kvm.Policy",
            'KVM.SESSION': "kvm.Session",
            'KVM.TUNNEL': "kvm.Tunnel",
            'LICENSE.ACCOUNTLICENSEDATA': "license.AccountLicenseData",
            'LICENSE.CUSTOMEROP': "license.CustomerOp",
            'LICENSE.IWOCUSTOMEROP': "license.IwoCustomerOp",
            'LICENSE.IWOLICENSECOUNT': "license.IwoLicenseCount",
            'LICENSE.LICENSEINFO': "license.LicenseInfo",
            'LICENSE.LICENSERESERVATIONOP': "license.LicenseReservationOp",
            'LICENSE.SMARTLICENSETOKEN': "license.SmartlicenseToken",
            'LS.SERVICEPROFILE': "ls.ServiceProfile",
            'MACPOOL.IDBLOCK': "macpool.IdBlock",
            'MACPOOL.LEASE': "macpool.Lease",
            'MACPOOL.POOL': "macpool.Pool",
            'MACPOOL.POOLMEMBER': "macpool.PoolMember",
            'MACPOOL.UNIVERSE': "macpool.Universe",
            'MANAGEMENT.CONTROLLER': "management.Controller",
            'MANAGEMENT.ENTITY': "management.Entity",
            'MANAGEMENT.INTERFACE': "management.Interface",
            'MEMORY.ARRAY': "memory.Array",
            'MEMORY.PERSISTENTMEMORYCONFIGRESULT': "memory.PersistentMemoryConfigResult",
            'MEMORY.PERSISTENTMEMORYCONFIGURATION': "memory.PersistentMemoryConfiguration",
            'MEMORY.PERSISTENTMEMORYNAMESPACE': "memory.PersistentMemoryNamespace",
            'MEMORY.PERSISTENTMEMORYNAMESPACECONFIGRESULT': "memory.PersistentMemoryNamespaceConfigResult",
            'MEMORY.PERSISTENTMEMORYPOLICY': "memory.PersistentMemoryPolicy",
            'MEMORY.PERSISTENTMEMORYREGION': "memory.PersistentMemoryRegion",
            'MEMORY.PERSISTENTMEMORYUNIT': "memory.PersistentMemoryUnit",
            'MEMORY.UNIT': "memory.Unit",
            'META.DEFINITION': "meta.Definition",
            'NETWORK.ELEMENT': "network.Element",
            'NETWORK.ELEMENTSUMMARY': "network.ElementSummary",
            'NETWORK.FCZONEINFO': "network.FcZoneInfo",
            'NETWORK.VLANPORTINFO': "network.VlanPortInfo",
            'NETWORKCONFIG.POLICY': "networkconfig.Policy",
            'NIAAPI.APICCCOPOST': "niaapi.ApicCcoPost",
            'NIAAPI.APICFIELDNOTICE': "niaapi.ApicFieldNotice",
            'NIAAPI.APICHWEOL': "niaapi.ApicHweol",
            'NIAAPI.APICLATESTMAINTAINEDRELEASE': "niaapi.ApicLatestMaintainedRelease",
            'NIAAPI.APICRELEASERECOMMEND': "niaapi.ApicReleaseRecommend",
            'NIAAPI.APICSWEOL': "niaapi.ApicSweol",
            'NIAAPI.DCNMCCOPOST': "niaapi.DcnmCcoPost",
            'NIAAPI.DCNMFIELDNOTICE': "niaapi.DcnmFieldNotice",
            'NIAAPI.DCNMHWEOL': "niaapi.DcnmHweol",
            'NIAAPI.DCNMLATESTMAINTAINEDRELEASE': "niaapi.DcnmLatestMaintainedRelease",
            'NIAAPI.DCNMRELEASERECOMMEND': "niaapi.DcnmReleaseRecommend",
            'NIAAPI.DCNMSWEOL': "niaapi.DcnmSweol",
            'NIAAPI.FILEDOWNLOADER': "niaapi.FileDownloader",
            'NIAAPI.NIAMETADATA': "niaapi.NiaMetadata",
            'NIAAPI.NIBFILEDOWNLOADER': "niaapi.NibFileDownloader",
            'NIAAPI.NIBMETADATA': "niaapi.NibMetadata",
            'NIAAPI.VERSIONREGEX': "niaapi.VersionRegex",
            'NIATELEMETRY.AAALDAPPROVIDERDETAILS': "niatelemetry.AaaLdapProviderDetails",
            'NIATELEMETRY.AAARADIUSPROVIDERDETAILS': "niatelemetry.AaaRadiusProviderDetails",
            'NIATELEMETRY.AAATACACSPROVIDERDETAILS': "niatelemetry.AaaTacacsProviderDetails",
            'NIATELEMETRY.APICAPPPLUGINDETAILS': "niatelemetry.ApicAppPluginDetails",
            'NIATELEMETRY.APICCOREFILEDETAILS': "niatelemetry.ApicCoreFileDetails",
            'NIATELEMETRY.APICDBGEXPRSEXPORTDEST': "niatelemetry.ApicDbgexpRsExportDest",
            'NIATELEMETRY.APICDBGEXPRSTSSCHEDULER': "niatelemetry.ApicDbgexpRsTsScheduler",
            'NIATELEMETRY.APICFANDETAILS': "niatelemetry.ApicFanDetails",
            'NIATELEMETRY.APICFEXDETAILS': "niatelemetry.ApicFexDetails",
            'NIATELEMETRY.APICFLASHDETAILS': "niatelemetry.ApicFlashDetails",
            'NIATELEMETRY.APICNTPAUTH': "niatelemetry.ApicNtpAuth",
            'NIATELEMETRY.APICPSUDETAILS': "niatelemetry.ApicPsuDetails",
            'NIATELEMETRY.APICREALMDETAILS': "niatelemetry.ApicRealmDetails",
            'NIATELEMETRY.APICSNMPCLIENTGRPDETAILS': "niatelemetry.ApicSnmpClientGrpDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYACCESSDETAILS': "niatelemetry.ApicSnmpCommunityAccessDetails",
            'NIATELEMETRY.APICSNMPCOMMUNITYDETAILS': "niatelemetry.ApicSnmpCommunityDetails",
            'NIATELEMETRY.APICSNMPTRAPDETAILS': "niatelemetry.ApicSnmpTrapDetails",
            'NIATELEMETRY.APICSNMPTRAPFWDSERVERDETAILS': "niatelemetry.ApicSnmpTrapFwdServerDetails",
            'NIATELEMETRY.APICSNMPVERSIONTHREEDETAILS': "niatelemetry.ApicSnmpVersionThreeDetails",
            'NIATELEMETRY.APICSYSLOGGRP': "niatelemetry.ApicSysLogGrp",
            'NIATELEMETRY.APICSYSLOGSRC': "niatelemetry.ApicSysLogSrc",
            'NIATELEMETRY.APICTRANSCEIVERDETAILS': "niatelemetry.ApicTransceiverDetails",
            'NIATELEMETRY.APICUIPAGECOUNTS': "niatelemetry.ApicUiPageCounts",
            'NIATELEMETRY.APPDETAILS': "niatelemetry.AppDetails",
            'NIATELEMETRY.COMMONPOLICIES': "niatelemetry.CommonPolicies",
            'NIATELEMETRY.DCNMFANDETAILS': "niatelemetry.DcnmFanDetails",
            'NIATELEMETRY.DCNMFEXDETAILS': "niatelemetry.DcnmFexDetails",
            'NIATELEMETRY.DCNMMODULEDETAILS': "niatelemetry.DcnmModuleDetails",
            'NIATELEMETRY.DCNMPSUDETAILS': "niatelemetry.DcnmPsuDetails",
            'NIATELEMETRY.DCNMTRANSCEIVERDETAILS': "niatelemetry.DcnmTransceiverDetails",
            'NIATELEMETRY.EPG': "niatelemetry.Epg",
            'NIATELEMETRY.FABRICMODULEDETAILS': "niatelemetry.FabricModuleDetails",
            'NIATELEMETRY.FABRICPODPROFILE': "niatelemetry.FabricPodProfile",
            'NIATELEMETRY.FABRICPODSS': "niatelemetry.FabricPodSs",
            'NIATELEMETRY.FAULT': "niatelemetry.Fault",
            'NIATELEMETRY.HTTPSACLCONTRACTDETAILS': "niatelemetry.HttpsAclContractDetails",
            'NIATELEMETRY.HTTPSACLCONTRACTFILTERMAP': "niatelemetry.HttpsAclContractFilterMap",
            'NIATELEMETRY.HTTPSACLEPGCONTRACTMAP': "niatelemetry.HttpsAclEpgContractMap",
            'NIATELEMETRY.HTTPSACLEPGDETAILS': "niatelemetry.HttpsAclEpgDetails",
            'NIATELEMETRY.HTTPSACLFILTERDETAILS': "niatelemetry.HttpsAclFilterDetails",
            'NIATELEMETRY.LC': "niatelemetry.Lc",
            'NIATELEMETRY.MSOCONTRACTDETAILS': "niatelemetry.MsoContractDetails",
            'NIATELEMETRY.MSOEPGDETAILS': "niatelemetry.MsoEpgDetails",
            'NIATELEMETRY.MSOSCHEMADETAILS': "niatelemetry.MsoSchemaDetails",
            'NIATELEMETRY.MSOSITEDETAILS': "niatelemetry.MsoSiteDetails",
            'NIATELEMETRY.MSOTENANTDETAILS': "niatelemetry.MsoTenantDetails",
            'NIATELEMETRY.NEXUSDASHBOARDCONTROLLERDETAILS': "niatelemetry.NexusDashboardControllerDetails",
            'NIATELEMETRY.NEXUSDASHBOARDDETAILS': "niatelemetry.NexusDashboardDetails",
            'NIATELEMETRY.NEXUSDASHBOARDMEMORYDETAILS': "niatelemetry.NexusDashboardMemoryDetails",
            'NIATELEMETRY.NEXUSDASHBOARDS': "niatelemetry.NexusDashboards",
            'NIATELEMETRY.NIAFEATUREUSAGE': "niatelemetry.NiaFeatureUsage",
            'NIATELEMETRY.NIAINVENTORY': "niatelemetry.NiaInventory",
            'NIATELEMETRY.NIAINVENTORYDCNM': "niatelemetry.NiaInventoryDcnm",
            'NIATELEMETRY.NIAINVENTORYFABRIC': "niatelemetry.NiaInventoryFabric",
            'NIATELEMETRY.NIALICENSESTATE': "niatelemetry.NiaLicenseState",
            'NIATELEMETRY.PASSWORDSTRENGTHCHECK': "niatelemetry.PasswordStrengthCheck",
            'NIATELEMETRY.PODCOMMPOLICIES': "niatelemetry.PodCommPolicies",
            'NIATELEMETRY.PODSNMPPOLICIES': "niatelemetry.PodSnmpPolicies",
            'NIATELEMETRY.PODTIMESERVERPOLICIES': "niatelemetry.PodTimeServerPolicies",
            'NIATELEMETRY.SITEINVENTORY': "niatelemetry.SiteInventory",
            'NIATELEMETRY.SNMPSRC': "niatelemetry.SnmpSrc",
            'NIATELEMETRY.SSHVERSIONTWO': "niatelemetry.SshVersionTwo",
            'NIATELEMETRY.SUPERVISORMODULEDETAILS': "niatelemetry.SupervisorModuleDetails",
            'NIATELEMETRY.SYSLOGREMOTEDEST': "niatelemetry.SyslogRemoteDest",
            'NIATELEMETRY.SYSLOGSYSMSG': "niatelemetry.SyslogSysMsg",
            'NIATELEMETRY.SYSLOGSYSMSGFACFILTER': "niatelemetry.SyslogSysMsgFacFilter",
            'NIATELEMETRY.SYSTEMCONTROLLERDETAILS': "niatelemetry.SystemControllerDetails",
            'NIATELEMETRY.TENANT': "niatelemetry.Tenant",
            'NOTIFICATION.ACCOUNTSUBSCRIPTION': "notification.AccountSubscription",
            'NTP.POLICY': "ntp.Policy",
            'OPRS.DEPLOYMENT': "oprs.Deployment",
            'OPRS.SYNCTARGETLISTMESSAGE': "oprs.SyncTargetListMessage",
            'ORGANIZATION.ORGANIZATION': "organization.Organization",
            'OS.BULKINSTALLINFO': "os.BulkInstallInfo",
            'OS.CATALOG': "os.Catalog",
            'OS.CONFIGURATIONFILE': "os.ConfigurationFile",
            'OS.DISTRIBUTION': "os.Distribution",
            'OS.INSTALL': "os.Install",
            'OS.OSSUPPORT': "os.OsSupport",
            'OS.SUPPORTEDVERSION': "os.SupportedVersion",
            'OS.TEMPLATEFILE': "os.TemplateFile",
            'OS.VALIDINSTALLTARGET': "os.ValidInstallTarget",
            'PCI.COPROCESSORCARD': "pci.CoprocessorCard",
            'PCI.DEVICE': "pci.Device",
            'PCI.LINK': "pci.Link",
            'PCI.SWITCH': "pci.Switch",
            'PORT.GROUP': "port.Group",
            'PORT.MACBINDING': "port.MacBinding",
            'PORT.SUBGROUP': "port.SubGroup",
            'POWER.CONTROLSTATE': "power.ControlState",
            'POWER.POLICY': "power.Policy",
            'PROCESSOR.UNIT': "processor.Unit",
            'RACK.UNITPERSONALITY': "rack.UnitPersonality",
            'RECOMMENDATION.CAPACITYRUNWAY': "recommendation.CapacityRunway",
            'RECOMMENDATION.PHYSICALITEM': "recommendation.PhysicalItem",
            'RECOVERY.BACKUPCONFIGPOLICY': "recovery.BackupConfigPolicy",
            'RECOVERY.BACKUPPROFILE': "recovery.BackupProfile",
            'RECOVERY.CONFIGRESULT': "recovery.ConfigResult",
            'RECOVERY.CONFIGRESULTENTRY': "recovery.ConfigResultEntry",
            'RECOVERY.ONDEMANDBACKUP': "recovery.OnDemandBackup",
            'RECOVERY.RESTORE': "recovery.Restore",
            'RECOVERY.SCHEDULECONFIGPOLICY': "recovery.ScheduleConfigPolicy",
            'RESOURCE.GROUP': "resource.Group",
            'RESOURCE.GROUPMEMBER': "resource.GroupMember",
            'RESOURCE.LICENSERESOURCECOUNT': "resource.LicenseResourceCount",
            'RESOURCE.MEMBERSHIP': "resource.Membership",
            'RESOURCE.MEMBERSHIPHOLDER': "resource.MembershipHolder",
            'RESOURCE.RESERVATION': "resource.Reservation",
            'RESOURCEPOOL.LEASE': "resourcepool.Lease",
            'RESOURCEPOOL.LEASERESOURCE': "resourcepool.LeaseResource",
            'RESOURCEPOOL.POOL': "resourcepool.Pool",
            'RESOURCEPOOL.POOLMEMBER': "resourcepool.PoolMember",
            'RESOURCEPOOL.UNIVERSE': "resourcepool.Universe",
            'RPROXY.REVERSEPROXY': "rproxy.ReverseProxy",
            'SDCARD.POLICY': "sdcard.Policy",
            'SDWAN.PROFILE': "sdwan.Profile",
            'SDWAN.ROUTERNODE': "sdwan.RouterNode",
            'SDWAN.ROUTERPOLICY': "sdwan.RouterPolicy",
            'SDWAN.VMANAGEACCOUNTPOLICY': "sdwan.VmanageAccountPolicy",
            'SEARCH.SEARCHITEM': "search.SearchItem",
            'SEARCH.TAGITEM': "search.TagItem",
            'SECURITY.UNIT': "security.Unit",
            'SERVER.CONFIGCHANGEDETAIL': "server.ConfigChangeDetail",
            'SERVER.CONFIGIMPORT': "server.ConfigImport",
            'SERVER.CONFIGRESULT': "server.ConfigResult",
            'SERVER.CONFIGRESULTENTRY': "server.ConfigResultEntry",
            'SERVER.PROFILE': "server.Profile",
            'SERVER.PROFILETEMPLATE': "server.ProfileTemplate",
            'SMTP.POLICY': "smtp.Policy",
            'SNMP.POLICY': "snmp.Policy",
            'SOFTWARE.APPLIANCEDISTRIBUTABLE': "software.ApplianceDistributable",
            'SOFTWARE.DOWNLOADHISTORY': "software.DownloadHistory",
            'SOFTWARE.HCLMETA': "software.HclMeta",
            'SOFTWARE.HYPERFLEXBUNDLEDISTRIBUTABLE': "software.HyperflexBundleDistributable",
            'SOFTWARE.HYPERFLEXDISTRIBUTABLE': "software.HyperflexDistributable",
            'SOFTWARE.RELEASEMETA': "software.ReleaseMeta",
            'SOFTWARE.SOLUTIONDISTRIBUTABLE': "software.SolutionDistributable",
            'SOFTWARE.UCSDBUNDLEDISTRIBUTABLE': "software.UcsdBundleDistributable",
            'SOFTWARE.UCSDDISTRIBUTABLE': "software.UcsdDistributable",
            'SOFTWAREREPOSITORY.AUTHORIZATION': "softwarerepository.Authorization",
            'SOFTWAREREPOSITORY.CACHEDIMAGE': "softwarerepository.CachedImage",
            'SOFTWAREREPOSITORY.CATALOG': "softwarerepository.Catalog",
            'SOFTWAREREPOSITORY.CATEGORYMAPPER': "softwarerepository.CategoryMapper",
            'SOFTWAREREPOSITORY.CATEGORYMAPPERMODEL': "softwarerepository.CategoryMapperModel",
            'SOFTWAREREPOSITORY.CATEGORYSUPPORTCONSTRAINT': "softwarerepository.CategorySupportConstraint",
            'SOFTWAREREPOSITORY.DOWNLOADSPEC': "softwarerepository.DownloadSpec",
            'SOFTWAREREPOSITORY.OPERATINGSYSTEMFILE': "softwarerepository.OperatingSystemFile",
            'SOFTWAREREPOSITORY.RELEASE': "softwarerepository.Release",
            'SOL.POLICY': "sol.Policy",
            'SSH.POLICY': "ssh.Policy",
            'STORAGE.CONTROLLER': "storage.Controller",
            'STORAGE.DISKGROUP': "storage.DiskGroup",
            'STORAGE.DISKSLOT': "storage.DiskSlot",
            'STORAGE.DRIVEGROUP': "storage.DriveGroup",
            'STORAGE.ENCLOSURE': "storage.Enclosure",
            'STORAGE.ENCLOSUREDISK': "storage.EnclosureDisk",
            'STORAGE.ENCLOSUREDISKSLOTEP': "storage.EnclosureDiskSlotEp",
            'STORAGE.FLEXFLASHCONTROLLER': "storage.FlexFlashController",
            'STORAGE.FLEXFLASHCONTROLLERPROPS': "storage.FlexFlashControllerProps",
            'STORAGE.FLEXFLASHPHYSICALDRIVE': "storage.FlexFlashPhysicalDrive",
            'STORAGE.FLEXFLASHVIRTUALDRIVE': "storage.FlexFlashVirtualDrive",
            'STORAGE.FLEXUTILCONTROLLER': "storage.FlexUtilController",
            'STORAGE.FLEXUTILPHYSICALDRIVE': "storage.FlexUtilPhysicalDrive",
            'STORAGE.FLEXUTILVIRTUALDRIVE': "storage.FlexUtilVirtualDrive",
            'STORAGE.HITACHIARRAY': "storage.HitachiArray",
            'STORAGE.HITACHICONTROLLER': "storage.HitachiController",
            'STORAGE.HITACHIDISK': "storage.HitachiDisk",
            'STORAGE.HITACHIHOST': "storage.HitachiHost",
            'STORAGE.HITACHIHOSTLUN': "storage.HitachiHostLun",
            'STORAGE.HITACHIPARITYGROUP': "storage.HitachiParityGroup",
            'STORAGE.HITACHIPOOL': "storage.HitachiPool",
            'STORAGE.HITACHIPORT': "storage.HitachiPort",
            'STORAGE.HITACHIVOLUME': "storage.HitachiVolume",
            'STORAGE.HYPERFLEXSTORAGECONTAINER': "storage.HyperFlexStorageContainer",
            'STORAGE.HYPERFLEXVOLUME': "storage.HyperFlexVolume",
            'STORAGE.ITEM': "storage.Item",
            'STORAGE.NETAPPAGGREGATE': "storage.NetAppAggregate",
            'STORAGE.NETAPPBASEDISK': "storage.NetAppBaseDisk",
            'STORAGE.NETAPPCLUSTER': "storage.NetAppCluster",
            'STORAGE.NETAPPETHERNETPORT': "storage.NetAppEthernetPort",
            'STORAGE.NETAPPEXPORTPOLICY': "storage.NetAppExportPolicy",
            'STORAGE.NETAPPFCINTERFACE': "storage.NetAppFcInterface",
            'STORAGE.NETAPPFCPORT': "storage.NetAppFcPort",
            'STORAGE.NETAPPINITIATORGROUP': "storage.NetAppInitiatorGroup",
            'STORAGE.NETAPPIPINTERFACE': "storage.NetAppIpInterface",
            'STORAGE.NETAPPLICENSE': "storage.NetAppLicense",
            'STORAGE.NETAPPLUN': "storage.NetAppLun",
            'STORAGE.NETAPPLUNMAP': "storage.NetAppLunMap",
            'STORAGE.NETAPPNODE': "storage.NetAppNode",
            'STORAGE.NETAPPNTPSERVER': "storage.NetAppNtpServer",
            'STORAGE.NETAPPSENSOR': "storage.NetAppSensor",
            'STORAGE.NETAPPSTORAGEVM': "storage.NetAppStorageVm",
            'STORAGE.NETAPPVOLUME': "storage.NetAppVolume",
            'STORAGE.NETAPPVOLUMESNAPSHOT': "storage.NetAppVolumeSnapshot",
            'STORAGE.PHYSICALDISK': "storage.PhysicalDisk",
            'STORAGE.PHYSICALDISKEXTENSION': "storage.PhysicalDiskExtension",
            'STORAGE.PHYSICALDISKUSAGE': "storage.PhysicalDiskUsage",
            'STORAGE.PUREARRAY': "storage.PureArray",
            'STORAGE.PURECONTROLLER': "storage.PureController",
            'STORAGE.PUREDISK': "storage.PureDisk",
            'STORAGE.PUREHOST': "storage.PureHost",
            'STORAGE.PUREHOSTGROUP': "storage.PureHostGroup",
            'STORAGE.PUREHOSTLUN': "storage.PureHostLun",
            'STORAGE.PUREPORT': "storage.PurePort",
            'STORAGE.PUREPROTECTIONGROUP': "storage.PureProtectionGroup",
            'STORAGE.PUREPROTECTIONGROUPSNAPSHOT': "storage.PureProtectionGroupSnapshot",
            'STORAGE.PUREREPLICATIONSCHEDULE': "storage.PureReplicationSchedule",
            'STORAGE.PURESNAPSHOTSCHEDULE': "storage.PureSnapshotSchedule",
            'STORAGE.PUREVOLUME': "storage.PureVolume",
            'STORAGE.PUREVOLUMESNAPSHOT': "storage.PureVolumeSnapshot",
            'STORAGE.SASEXPANDER': "storage.SasExpander",
            'STORAGE.SASPORT': "storage.SasPort",
            'STORAGE.SPAN': "storage.Span",
            'STORAGE.STORAGEPOLICY': "storage.StoragePolicy",
            'STORAGE.VDMEMBEREP': "storage.VdMemberEp",
            'STORAGE.VIRTUALDRIVE': "storage.VirtualDrive",
            'STORAGE.VIRTUALDRIVECONTAINER': "storage.VirtualDriveContainer",
            'STORAGE.VIRTUALDRIVEEXTENSION': "storage.VirtualDriveExtension",
            'STORAGE.VIRTUALDRIVEIDENTITY': "storage.VirtualDriveIdentity",
            'SYSLOG.POLICY': "syslog.Policy",
            'TAM.ADVISORYCOUNT': "tam.AdvisoryCount",
            'TAM.ADVISORYDEFINITION': "tam.AdvisoryDefinition",
            'TAM.ADVISORYINFO': "tam.AdvisoryInfo",
            'TAM.ADVISORYINSTANCE': "tam.AdvisoryInstance",
            'TAM.SECURITYADVISORY': "tam.SecurityAdvisory",
            'TASK.HITACHISCOPEDINVENTORY': "task.HitachiScopedInventory",
            'TASK.HXAPSCOPEDINVENTORY': "task.HxapScopedInventory",
            'TASK.NETAPPSCOPEDINVENTORY': "task.NetAppScopedInventory",
            'TASK.PUBLICCLOUDSCOPEDINVENTORY': "task.PublicCloudScopedInventory",
            'TASK.PURESCOPEDINVENTORY': "task.PureScopedInventory",
            'TASK.SERVERSCOPEDINVENTORY': "task.ServerScopedInventory",
            'TECHSUPPORTMANAGEMENT.COLLECTIONCONTROLPOLICY': "techsupportmanagement.CollectionControlPolicy",
            'TECHSUPPORTMANAGEMENT.DOWNLOAD': "techsupportmanagement.Download",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTBUNDLE': "techsupportmanagement.TechSupportBundle",
            'TECHSUPPORTMANAGEMENT.TECHSUPPORTSTATUS': "techsupportmanagement.TechSupportStatus",
            'TERMINAL.AUDITLOG': "terminal.AuditLog",
            'TERRAFORM.EXECUTOR': "terraform.Executor",
            'THERMAL.POLICY': "thermal.Policy",
            'TOP.SYSTEM': "top.System",
            'UCSD.BACKUPINFO': "ucsd.BackupInfo",
            'UUIDPOOL.BLOCK': "uuidpool.Block",
            'UUIDPOOL.POOL': "uuidpool.Pool",
            'UUIDPOOL.POOLMEMBER': "uuidpool.PoolMember",
            'UUIDPOOL.UNIVERSE': "uuidpool.Universe",
            'UUIDPOOL.UUIDLEASE': "uuidpool.UuidLease",
            'VIRTUALIZATION.HOST': "virtualization.Host",
            'VIRTUALIZATION.VIRTUALDISK': "virtualization.VirtualDisk",
            'VIRTUALIZATION.VIRTUALMACHINE': "virtualization.VirtualMachine",
            'VIRTUALIZATION.VIRTUALNETWORK': "virtualization.VirtualNetwork",
            'VIRTUALIZATION.VMWARECLUSTER': "virtualization.VmwareCluster",
            'VIRTUALIZATION.VMWAREDATACENTER': "virtualization.VmwareDatacenter",
            'VIRTUALIZATION.VMWAREDATASTORE': "virtualization.VmwareDatastore",
            'VIRTUALIZATION.VMWAREDATASTORECLUSTER': "virtualization.VmwareDatastoreCluster",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDNETWORK': "virtualization.VmwareDistributedNetwork",
            'VIRTUALIZATION.VMWAREDISTRIBUTEDSWITCH': "virtualization.VmwareDistributedSwitch",
            'VIRTUALIZATION.VMWAREFOLDER': "virtualization.VmwareFolder",
            'VIRTUALIZATION.VMWAREHOST': "virtualization.VmwareHost",
            'VIRTUALIZATION.VMWAREKERNELNETWORK': "virtualization.VmwareKernelNetwork",
            'VIRTUALIZATION.VMWARENETWORK': "virtualization.VmwareNetwork",
            'VIRTUALIZATION.VMWAREPHYSICALNETWORKINTERFACE': "virtualization.VmwarePhysicalNetworkInterface",
            'VIRTUALIZATION.VMWAREUPLINKPORT': "virtualization.VmwareUplinkPort",
            'VIRTUALIZATION.VMWAREVCENTER': "virtualization.VmwareVcenter",
            'VIRTUALIZATION.VMWAREVIRTUALDISK': "virtualization.VmwareVirtualDisk",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINE': "virtualization.VmwareVirtualMachine",
            'VIRTUALIZATION.VMWAREVIRTUALMACHINESNAPSHOT': "virtualization.VmwareVirtualMachineSnapshot",
            'VIRTUALIZATION.VMWAREVIRTUALNETWORKINTERFACE': "virtualization.VmwareVirtualNetworkInterface",
            'VIRTUALIZATION.VMWAREVIRTUALSWITCH': "virtualization.VmwareVirtualSwitch",
            'VMEDIA.POLICY': "vmedia.Policy",
            'VMRC.CONSOLE': "vmrc.Console",
            'VNC.CONSOLE': "vnc.Console",
            'VNIC.ETHADAPTERPOLICY': "vnic.EthAdapterPolicy",
            'VNIC.ETHIF': "vnic.EthIf",
            'VNIC.ETHNETWORKPOLICY': "vnic.EthNetworkPolicy",
            'VNIC.ETHQOSPOLICY': "vnic.EthQosPolicy",
            'VNIC.FCADAPTERPOLICY': "vnic.FcAdapterPolicy",
            'VNIC.FCIF': "vnic.FcIf",
            'VNIC.FCNETWORKPOLICY': "vnic.FcNetworkPolicy",
            'VNIC.FCQOSPOLICY': "vnic.FcQosPolicy",
            'VNIC.ISCSIADAPTERPOLICY': "vnic.IscsiAdapterPolicy",
            'VNIC.ISCSIBOOTPOLICY': "vnic.IscsiBootPolicy",
            'VNIC.ISCSISTATICTARGETPOLICY': "vnic.IscsiStaticTargetPolicy",
            'VNIC.LANCONNECTIVITYPOLICY': "vnic.LanConnectivityPolicy",
            'VNIC.LCPSTATUS': "vnic.LcpStatus",
            'VNIC.SANCONNECTIVITYPOLICY': "vnic.SanConnectivityPolicy",
            'VNIC.SCPSTATUS': "vnic.ScpStatus",
            'VRF.VRF': "vrf.Vrf",
            'WORKFLOW.BATCHAPIEXECUTOR': "workflow.BatchApiExecutor",
            'WORKFLOW.BUILDTASKMETA': "workflow.BuildTaskMeta",
            'WORKFLOW.BUILDTASKMETAOWNER': "workflow.BuildTaskMetaOwner",
            'WORKFLOW.CATALOG': "workflow.Catalog",
            'WORKFLOW.CUSTOMDATATYPEDEFINITION': "workflow.CustomDataTypeDefinition",
            'WORKFLOW.ERRORRESPONSEHANDLER': "workflow.ErrorResponseHandler",
            'WORKFLOW.PENDINGDYNAMICWORKFLOWINFO': "workflow.PendingDynamicWorkflowInfo",
            'WORKFLOW.ROLLBACKWORKFLOW': "workflow.RollbackWorkflow",
            'WORKFLOW.SOLUTIONACTIONDEFINITION': "workflow.SolutionActionDefinition",
            'WORKFLOW.SOLUTIONACTIONINSTANCE': "workflow.SolutionActionInstance",
            'WORKFLOW.SOLUTIONDEFINITION': "workflow.SolutionDefinition",
            'WORKFLOW.SOLUTIONINSTANCE': "workflow.SolutionInstance",
            'WORKFLOW.SOLUTIONOUTPUT': "workflow.SolutionOutput",
            'WORKFLOW.TASKDEBUGLOG': "workflow.TaskDebugLog",
            'WORKFLOW.TASKDEFINITION': "workflow.TaskDefinition",
            'WORKFLOW.TASKINFO': "workflow.TaskInfo",
            'WORKFLOW.TASKMETADATA': "workflow.TaskMetadata",
            'WORKFLOW.TASKNOTIFICATION': "workflow.TaskNotification",
            'WORKFLOW.TEMPLATEEVALUATION': "workflow.TemplateEvaluation",
            'WORKFLOW.TEMPLATEFUNCTIONMETA': "workflow.TemplateFunctionMeta",
            'WORKFLOW.WORKFLOWDEFINITION': "workflow.WorkflowDefinition",
            'WORKFLOW.WORKFLOWINFO': "workflow.WorkflowInfo",
            'WORKFLOW.WORKFLOWMETA': "workflow.WorkflowMeta",
            'WORKFLOW.WORKFLOWMETADATA': "workflow.WorkflowMetadata",
            'WORKFLOW.WORKFLOWNOTIFICATION': "workflow.WorkflowNotification",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'account_moid': (str,),  # noqa: E501
            'create_time': (datetime,),  # noqa: E501
            'domain_group_moid': (str,),  # noqa: E501
            'mod_time': (datetime,),  # noqa: E501
            'moid': (str,),  # noqa: E501
            'owners': ([str], none_type,),  # noqa: E501
            'shared_scope': (str,),  # noqa: E501
            'tags': ([MoTag], none_type,),  # noqa: E501
            'version_context': (MoVersionContext,),  # noqa: E501
            'ancestors': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'parent': (MoBaseMoRelationship,),  # noqa: E501
            'permission_resources': ([MoBaseMoRelationship], none_type,),  # noqa: E501
            'display_names': (DisplayNames,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        lazy_import()
        val = {
            'aaa.AbstractAuditRecord': AaaAbstractAuditRecord,
            'aaa.AuditRecord': AaaAuditRecord,
            'aaa.RetentionConfig': AaaRetentionConfig,
            'aaa.RetentionPolicy': AaaRetentionPolicy,
            'access.Policy': AccessPolicy,
            'adapter.ConfigPolicy': AdapterConfigPolicy,
            'adapter.ExtEthInterface': AdapterExtEthInterface,
            'adapter.HostEthInterface': AdapterHostEthInterface,
            'adapter.HostFcInterface': AdapterHostFcInterface,
            'adapter.HostIscsiInterface': AdapterHostIscsiInterface,
            'adapter.Unit': AdapterUnit,
            'adapter.UnitExpander': AdapterUnitExpander,
            'appliance.AppStatus': ApplianceAppStatus,
            'appliance.AutoRmaPolicy': ApplianceAutoRmaPolicy,
            'appliance.Backup': ApplianceBackup,
            'appliance.BackupBase': ApplianceBackupBase,
            'appliance.BackupPolicy': ApplianceBackupPolicy,
            'appliance.CertificateSetting': ApplianceCertificateSetting,
            'appliance.DataExportPolicy': ApplianceDataExportPolicy,
            'appliance.DeviceCertificate': ApplianceDeviceCertificate,
            'appliance.DeviceClaim': ApplianceDeviceClaim,
            'appliance.DeviceUpgradePolicy': ApplianceDeviceUpgradePolicy,
            'appliance.DiagSetting': ApplianceDiagSetting,
            'appliance.ExternalSyslogSetting': ApplianceExternalSyslogSetting,
            'appliance.FileGateway': ApplianceFileGateway,
            'appliance.FileSystemStatus': ApplianceFileSystemStatus,
            'appliance.GroupStatus': ApplianceGroupStatus,
            'appliance.ImageBundle': ApplianceImageBundle,
            'appliance.NodeInfo': ApplianceNodeInfo,
            'appliance.NodeStatus': ApplianceNodeStatus,
            'appliance.ReleaseNote': ApplianceReleaseNote,
            'appliance.RemoteFileImport': ApplianceRemoteFileImport,
            'appliance.Restore': ApplianceRestore,
            'appliance.SetupInfo': ApplianceSetupInfo,
            'appliance.SystemInfo': ApplianceSystemInfo,
            'appliance.SystemStatus': ApplianceSystemStatus,
            'appliance.Upgrade': ApplianceUpgrade,
            'appliance.UpgradePolicy': ApplianceUpgradePolicy,
            'asset.ClusterMember': AssetClusterMember,
            'asset.Deployment': AssetDeployment,
            'asset.DeploymentDevice': AssetDeploymentDevice,
            'asset.DeviceClaim': AssetDeviceClaim,
            'asset.DeviceConfiguration': AssetDeviceConfiguration,
            'asset.DeviceConnection': AssetDeviceConnection,
            'asset.DeviceConnectorManager': AssetDeviceConnectorManager,
            'asset.DeviceContractInformation': AssetDeviceContractInformation,
            'asset.DeviceRegistration': AssetDeviceRegistration,
            'asset.Subscription': AssetSubscription,
            'asset.SubscriptionAccount': AssetSubscriptionAccount,
            'asset.SubscriptionDeviceContractInformation': AssetSubscriptionDeviceContractInformation,
            'asset.Target': AssetTarget,
            'bios.BootDevice': BiosBootDevice,
            'bios.BootMode': BiosBootMode,
            'bios.Policy': BiosPolicy,
            'bios.SystemBootOrder': BiosSystemBootOrder,
            'bios.TokenSettings': BiosTokenSettings,
            'bios.Unit': BiosUnit,
            'bios.VfSelectMemoryRasConfiguration': BiosVfSelectMemoryRasConfiguration,
            'boot.CddDevice': BootCddDevice,
            'boot.ConfiguredDevice': BootConfiguredDevice,
            'boot.DeviceBootMode': BootDeviceBootMode,
            'boot.DeviceBootSecurity': BootDeviceBootSecurity,
            'boot.HddDevice': BootHddDevice,
            'boot.IscsiDevice': BootIscsiDevice,
            'boot.NvmeDevice': BootNvmeDevice,
            'boot.PchStorageDevice': BootPchStorageDevice,
            'boot.PrecisionPolicy': BootPrecisionPolicy,
            'boot.PxeDevice': BootPxeDevice,
            'boot.SanDevice': BootSanDevice,
            'boot.SdDevice': BootSdDevice,
            'boot.UefiShellDevice': BootUefiShellDevice,
            'boot.UsbDevice': BootUsbDevice,
            'boot.VmediaDevice': BootVmediaDevice,
            'bulk.Export': BulkExport,
            'bulk.ExportedItem': BulkExportedItem,
            'bulk.MoCloner': BulkMoCloner,
            'bulk.MoMerger': BulkMoMerger,
            'bulk.Request': BulkRequest,
            'bulk.SubRequestObj': BulkSubRequestObj,
            'capability.AdapterUnitDescriptor': CapabilityAdapterUnitDescriptor,
            'capability.Capability': CapabilityCapability,
            'capability.Catalog': CapabilityCatalog,
            'capability.ChassisDescriptor': CapabilityChassisDescriptor,
            'capability.ChassisManufacturingDef': CapabilityChassisManufacturingDef,
            'capability.CimcFirmwareDescriptor': CapabilityCimcFirmwareDescriptor,
            'capability.EndpointDescriptor': CapabilityEndpointDescriptor,
            'capability.EquipmentPhysicalDef': CapabilityEquipmentPhysicalDef,
            'capability.EquipmentSlotArray': CapabilityEquipmentSlotArray,
            'capability.FanModuleDescriptor': CapabilityFanModuleDescriptor,
            'capability.FanModuleManufacturingDef': CapabilityFanModuleManufacturingDef,
            'capability.HardwareDescriptor': CapabilityHardwareDescriptor,
            'capability.IoCardCapabilityDef': CapabilityIoCardCapabilityDef,
            'capability.IoCardDescriptor': CapabilityIoCardDescriptor,
            'capability.IoCardManufacturingDef': CapabilityIoCardManufacturingDef,
            'capability.PortGroupAggregationDef': CapabilityPortGroupAggregationDef,
            'capability.PsuDescriptor': CapabilityPsuDescriptor,
            'capability.PsuManufacturingDef': CapabilityPsuManufacturingDef,
            'capability.ServerModelsCapabilityDef': CapabilityServerModelsCapabilityDef,
            'capability.ServerSchemaDescriptor': CapabilityServerSchemaDescriptor,
            'capability.SiocModuleCapabilityDef': CapabilitySiocModuleCapabilityDef,
            'capability.SiocModuleDescriptor': CapabilitySiocModuleDescriptor,
            'capability.SiocModuleManufacturingDef': CapabilitySiocModuleManufacturingDef,
            'capability.SwitchCapability': CapabilitySwitchCapability,
            'capability.SwitchCapabilityDef': CapabilitySwitchCapabilityDef,
            'capability.SwitchDescriptor': CapabilitySwitchDescriptor,
            'capability.SwitchManufacturingDef': CapabilitySwitchManufacturingDef,
            'certificatemanagement.Policy': CertificatemanagementPolicy,
            'chassis.ConfigChangeDetail': ChassisConfigChangeDetail,
            'chassis.ConfigImport': ChassisConfigImport,
            'chassis.ConfigResult': ChassisConfigResult,
            'chassis.ConfigResultEntry': ChassisConfigResultEntry,
            'chassis.IomProfile': ChassisIomProfile,
            'chassis.Profile': ChassisProfile,
            'cloud.AwsBillingUnit': CloudAwsBillingUnit,
            'cloud.AwsKeyPair': CloudAwsKeyPair,
            'cloud.AwsNetworkInterface': CloudAwsNetworkInterface,
            'cloud.AwsOrganizationalUnit': CloudAwsOrganizationalUnit,
            'cloud.AwsSecurityGroup': CloudAwsSecurityGroup,
            'cloud.AwsSubnet': CloudAwsSubnet,
            'cloud.AwsVirtualMachine': CloudAwsVirtualMachine,
            'cloud.AwsVolume': CloudAwsVolume,
            'cloud.AwsVpc': CloudAwsVpc,
            'cloud.BaseBillingUnit': CloudBaseBillingUnit,
            'cloud.BaseEntity': CloudBaseEntity,
            'cloud.BaseNetwork': CloudBaseNetwork,
            'cloud.BaseNetworkInterface': CloudBaseNetworkInterface,
            'cloud.BasePlacement': CloudBasePlacement,
            'cloud.BaseSku': CloudBaseSku,
            'cloud.BaseVirtualMachine': CloudBaseVirtualMachine,
            'cloud.BaseVolume': CloudBaseVolume,
            'cloud.CollectInventory': CloudCollectInventory,
            'cloud.Regions': CloudRegions,
            'cloud.SkuContainerType': CloudSkuContainerType,
            'cloud.SkuDatabaseType': CloudSkuDatabaseType,
            'cloud.SkuInstanceType': CloudSkuInstanceType,
            'cloud.SkuNetworkType': CloudSkuNetworkType,
            'cloud.SkuRegionRateCards': CloudSkuRegionRateCards,
            'cloud.SkuVolumeType': CloudSkuVolumeType,
            'cloud.TfcAgentpool': CloudTfcAgentpool,
            'cloud.TfcOrganization': CloudTfcOrganization,
            'cloud.TfcWorkspace': CloudTfcWorkspace,
            'comm.AbstractHttpProxyPolicy': CommAbstractHttpProxyPolicy,
            'comm.HttpProxyPolicy': CommHttpProxyPolicy,
            'compute.BiosPostPolicy': ComputeBiosPostPolicy,
            'compute.Blade': ComputeBlade,
            'compute.BladeIdentity': ComputeBladeIdentity,
            'compute.Board': ComputeBoard,
            'compute.Mapping': ComputeMapping,
            'compute.Physical': ComputePhysical,
            'compute.PhysicalSummary': ComputePhysicalSummary,
            'compute.RackUnit': ComputeRackUnit,
            'compute.RackUnitIdentity': ComputeRackUnitIdentity,
            'compute.ServerPowerPolicy': ComputeServerPowerPolicy,
            'compute.ServerSetting': ComputeServerSetting,
            'compute.Vmedia': ComputeVmedia,
            'cond.Alarm': CondAlarm,
            'cond.AlarmAggregation': CondAlarmAggregation,
            'cond.HclStatus': CondHclStatus,
            'cond.HclStatusDetail': CondHclStatusDetail,
            'cond.HclStatusJob': CondHclStatusJob,
            'connector.DownloadStatus': ConnectorDownloadStatus,
            'connector.ScopedInventory': ConnectorScopedInventory,
            'connectorpack.ConnectorPackUpgrade': ConnectorpackConnectorPackUpgrade,
            'connectorpack.UpgradeImpact': ConnectorpackUpgradeImpact,
            'convergedinfra.BasePod': ConvergedinfraBasePod,
            'convergedinfra.HealthCheckDefinition': ConvergedinfraHealthCheckDefinition,
            'convergedinfra.HealthCheckExecution': ConvergedinfraHealthCheckExecution,
            'convergedinfra.Pod': ConvergedinfraPod,
            'crd.CustomResource': CrdCustomResource,
            'deviceconnector.Policy': DeviceconnectorPolicy,
            'equipment.AbstractDevice': EquipmentAbstractDevice,
            'equipment.Base': EquipmentBase,
            'equipment.BaseSensor': EquipmentBaseSensor,
            'equipment.Chassis': EquipmentChassis,
            'equipment.ChassisIdentity': EquipmentChassisIdentity,
            'equipment.ChassisOperation': EquipmentChassisOperation,
            'equipment.DeviceSummary': EquipmentDeviceSummary,
            'equipment.ExpanderModule': EquipmentExpanderModule,
            'equipment.Fan': EquipmentFan,
            'equipment.FanControl': EquipmentFanControl,
            'equipment.FanModule': EquipmentFanModule,
            'equipment.Fex': EquipmentFex,
            'equipment.FexIdentity': EquipmentFexIdentity,
            'equipment.FexOperation': EquipmentFexOperation,
            'equipment.Fru': EquipmentFru,
            'equipment.Identity': EquipmentIdentity,
            'equipment.IdentitySummary': EquipmentIdentitySummary,
            'equipment.IoCard': EquipmentIoCard,
            'equipment.IoCardBase': EquipmentIoCardBase,
            'equipment.IoCardOperation': EquipmentIoCardOperation,
            'equipment.IoExpander': EquipmentIoExpander,
            'equipment.LocatorLed': EquipmentLocatorLed,
            'equipment.PhysicalIdentity': EquipmentPhysicalIdentity,
            'equipment.Psu': EquipmentPsu,
            'equipment.PsuControl': EquipmentPsuControl,
            'equipment.RackEnclosure': EquipmentRackEnclosure,
            'equipment.RackEnclosureSlot': EquipmentRackEnclosureSlot,
            'equipment.SharedIoModule': EquipmentSharedIoModule,
            'equipment.Slot': EquipmentSlot,
            'equipment.SwitchCard': EquipmentSwitchCard,
            'equipment.SystemIoController': EquipmentSystemIoController,
            'equipment.Tpm': EquipmentTpm,
            'equipment.Transceiver': EquipmentTransceiver,
            'ether.HostPort': EtherHostPort,
            'ether.NetworkPort': EtherNetworkPort,
            'ether.PhysicalPort': EtherPhysicalPort,
            'ether.PhysicalPortBase': EtherPhysicalPortBase,
            'ether.PortChannel': EtherPortChannel,
            'externalsite.Authorization': ExternalsiteAuthorization,
            'fabric.AppliancePcRole': FabricAppliancePcRole,
            'fabric.ApplianceRole': FabricApplianceRole,
            'fabric.ConfigChangeDetail': FabricConfigChangeDetail,
            'fabric.ConfigResult': FabricConfigResult,
            'fabric.ConfigResultEntry': FabricConfigResultEntry,
            'fabric.ElementIdentity': FabricElementIdentity,
            'fabric.EstimateImpact': FabricEstimateImpact,
            'fabric.EthNetworkControlPolicy': FabricEthNetworkControlPolicy,
            'fabric.EthNetworkGroupPolicy': FabricEthNetworkGroupPolicy,
            'fabric.EthNetworkPolicy': FabricEthNetworkPolicy,
            'fabric.FcNetworkPolicy': FabricFcNetworkPolicy,
            'fabric.FcUplinkPcRole': FabricFcUplinkPcRole,
            'fabric.FcUplinkRole': FabricFcUplinkRole,
            'fabric.FcoeUplinkPcRole': FabricFcoeUplinkPcRole,
            'fabric.FcoeUplinkRole': FabricFcoeUplinkRole,
            'fabric.FlowControlPolicy': FabricFlowControlPolicy,
            'fabric.LinkAggregationPolicy': FabricLinkAggregationPolicy,
            'fabric.LinkControlPolicy': FabricLinkControlPolicy,
            'fabric.MulticastPolicy': FabricMulticastPolicy,
            'fabric.PcMember': FabricPcMember,
            'fabric.PcOperation': FabricPcOperation,
            'fabric.PortBase': FabricPortBase,
            'fabric.PortChannelRole': FabricPortChannelRole,
            'fabric.PortMode': FabricPortMode,
            'fabric.PortOperation': FabricPortOperation,
            'fabric.PortPolicy': FabricPortPolicy,
            'fabric.PortRole': FabricPortRole,
            'fabric.ServerRole': FabricServerRole,
            'fabric.SwitchClusterProfile': FabricSwitchClusterProfile,
            'fabric.SwitchControlPolicy': FabricSwitchControlPolicy,
            'fabric.SwitchProfile': FabricSwitchProfile,
            'fabric.SystemQosPolicy': FabricSystemQosPolicy,
            'fabric.TransceiverRole': FabricTransceiverRole,
            'fabric.UplinkPcRole': FabricUplinkPcRole,
            'fabric.UplinkRole': FabricUplinkRole,
            'fabric.Vlan': FabricVlan,
            'fabric.Vsan': FabricVsan,
            'fault.Instance': FaultInstance,
            'fc.PhysicalPort': FcPhysicalPort,
            'fc.PortChannel': FcPortChannel,
            'fcpool.FcBlock': FcpoolFcBlock,
            'fcpool.Lease': FcpoolLease,
            'fcpool.Pool': FcpoolPool,
            'fcpool.PoolMember': FcpoolPoolMember,
            'fcpool.Universe': FcpoolUniverse,
            'feedback.FeedbackPost': FeedbackFeedbackPost,
            'firmware.BaseDistributable': FirmwareBaseDistributable,
            'firmware.BiosDescriptor': FirmwareBiosDescriptor,
            'firmware.BoardControllerDescriptor': FirmwareBoardControllerDescriptor,
            'firmware.ChassisUpgrade': FirmwareChassisUpgrade,
            'firmware.CimcDescriptor': FirmwareCimcDescriptor,
            'firmware.ComponentDescriptor': FirmwareComponentDescriptor,
            'firmware.DimmDescriptor': FirmwareDimmDescriptor,
            'firmware.Distributable': FirmwareDistributable,
            'firmware.DistributableMeta': FirmwareDistributableMeta,
            'firmware.DriveDescriptor': FirmwareDriveDescriptor,
            'firmware.DriverDistributable': FirmwareDriverDistributable,
            'firmware.Eula': FirmwareEula,
            'firmware.FirmwareSummary': FirmwareFirmwareSummary,
            'firmware.GpuDescriptor': FirmwareGpuDescriptor,
            'firmware.HbaDescriptor': FirmwareHbaDescriptor,
            'firmware.IomDescriptor': FirmwareIomDescriptor,
            'firmware.MswitchDescriptor': FirmwareMswitchDescriptor,
            'firmware.NxosDescriptor': FirmwareNxosDescriptor,
            'firmware.PcieDescriptor': FirmwarePcieDescriptor,
            'firmware.PsuDescriptor': FirmwarePsuDescriptor,
            'firmware.RunningFirmware': FirmwareRunningFirmware,
            'firmware.SasExpanderDescriptor': FirmwareSasExpanderDescriptor,
            'firmware.ServerConfigurationUtilityDistributable': FirmwareServerConfigurationUtilityDistributable,
            'firmware.StorageControllerDescriptor': FirmwareStorageControllerDescriptor,
            'firmware.SwitchUpgrade': FirmwareSwitchUpgrade,
            'firmware.UnsupportedVersionUpgrade': FirmwareUnsupportedVersionUpgrade,
            'firmware.Upgrade': FirmwareUpgrade,
            'firmware.UpgradeBase': FirmwareUpgradeBase,
            'firmware.UpgradeImpact': FirmwareUpgradeImpact,
            'firmware.UpgradeImpactBase': FirmwareUpgradeImpactBase,
            'firmware.UpgradeImpactStatus': FirmwareUpgradeImpactStatus,
            'firmware.UpgradeStatus': FirmwareUpgradeStatus,
            'forecast.Catalog': ForecastCatalog,
            'forecast.Definition': ForecastDefinition,
            'forecast.Instance': ForecastInstance,
            'graphics.Card': GraphicsCard,
            'graphics.Controller': GraphicsController,
            'hcl.CompatibilityStatus': HclCompatibilityStatus,
            'hcl.DriverImage': HclDriverImage,
            'hcl.ExemptedCatalog': HclExemptedCatalog,
            'hcl.HyperflexSoftwareCompatibilityInfo': HclHyperflexSoftwareCompatibilityInfo,
            'hcl.OperatingSystem': HclOperatingSystem,
            'hcl.OperatingSystemVendor': HclOperatingSystemVendor,
            'hcl.SupportedDriverName': HclSupportedDriverName,
            'hyperflex.Alarm': HyperflexAlarm,
            'hyperflex.AppCatalog': HyperflexAppCatalog,
            'hyperflex.AutoSupportPolicy': HyperflexAutoSupportPolicy,
            'hyperflex.BackupCluster': HyperflexBackupCluster,
            'hyperflex.BaseCluster': HyperflexBaseCluster,
            'hyperflex.CapabilityInfo': HyperflexCapabilityInfo,
            'hyperflex.CiscoHypervisorManager': HyperflexCiscoHypervisorManager,
            'hyperflex.Cluster': HyperflexCluster,
            'hyperflex.ClusterBackupPolicy': HyperflexClusterBackupPolicy,
            'hyperflex.ClusterBackupPolicyDeployment': HyperflexClusterBackupPolicyDeployment,
            'hyperflex.ClusterBackupPolicyInventory': HyperflexClusterBackupPolicyInventory,
            'hyperflex.ClusterHealthCheckExecutionSnapshot': HyperflexClusterHealthCheckExecutionSnapshot,
            'hyperflex.ClusterNetworkPolicy': HyperflexClusterNetworkPolicy,
            'hyperflex.ClusterProfile': HyperflexClusterProfile,
            'hyperflex.ClusterReplicationNetworkPolicy': HyperflexClusterReplicationNetworkPolicy,
            'hyperflex.ClusterReplicationNetworkPolicyDeployment': HyperflexClusterReplicationNetworkPolicyDeployment,
            'hyperflex.ClusterStoragePolicy': HyperflexClusterStoragePolicy,
            'hyperflex.ConfigResult': HyperflexConfigResult,
            'hyperflex.ConfigResultEntry': HyperflexConfigResultEntry,
            'hyperflex.DataProtectionPeer': HyperflexDataProtectionPeer,
            'hyperflex.DatastoreStatistic': HyperflexDatastoreStatistic,
            'hyperflex.DevicePackageDownloadState': HyperflexDevicePackageDownloadState,
            'hyperflex.Drive': HyperflexDrive,
            'hyperflex.ExtFcStoragePolicy': HyperflexExtFcStoragePolicy,
            'hyperflex.ExtIscsiStoragePolicy': HyperflexExtIscsiStoragePolicy,
            'hyperflex.FeatureLimitExternal': HyperflexFeatureLimitExternal,
            'hyperflex.FeatureLimitInternal': HyperflexFeatureLimitInternal,
            'hyperflex.Health': HyperflexHealth,
            'hyperflex.HealthCheckDefinition': HyperflexHealthCheckDefinition,
            'hyperflex.HealthCheckExecution': HyperflexHealthCheckExecution,
            'hyperflex.HealthCheckExecutionSnapshot': HyperflexHealthCheckExecutionSnapshot,
            'hyperflex.HealthCheckPackageChecksum': HyperflexHealthCheckPackageChecksum,
            'hyperflex.HxapCluster': HyperflexHxapCluster,
            'hyperflex.HxapDatacenter': HyperflexHxapDatacenter,
            'hyperflex.HxapDvUplink': HyperflexHxapDvUplink,
            'hyperflex.HxapDvswitch': HyperflexHxapDvswitch,
            'hyperflex.HxapHost': HyperflexHxapHost,
            'hyperflex.HxapHostInterface': HyperflexHxapHostInterface,
            'hyperflex.HxapHostVswitch': HyperflexHxapHostVswitch,
            'hyperflex.HxapNetwork': HyperflexHxapNetwork,
            'hyperflex.HxapVirtualDisk': HyperflexHxapVirtualDisk,
            'hyperflex.HxapVirtualMachine': HyperflexHxapVirtualMachine,
            'hyperflex.HxapVirtualMachineNetworkInterface': HyperflexHxapVirtualMachineNetworkInterface,
            'hyperflex.HxdpVersion': HyperflexHxdpVersion,
            'hyperflex.License': HyperflexLicense,
            'hyperflex.LocalCredentialPolicy': HyperflexLocalCredentialPolicy,
            'hyperflex.Node': HyperflexNode,
            'hyperflex.NodeConfigPolicy': HyperflexNodeConfigPolicy,
            'hyperflex.NodeProfile': HyperflexNodeProfile,
            'hyperflex.ProtectedCluster': HyperflexProtectedCluster,
            'hyperflex.ProxySettingPolicy': HyperflexProxySettingPolicy,
            'hyperflex.ServerFirmwareVersion': HyperflexServerFirmwareVersion,
            'hyperflex.ServerFirmwareVersionEntry': HyperflexServerFirmwareVersionEntry,
            'hyperflex.ServerModel': HyperflexServerModel,
            'hyperflex.ServiceAuthToken': HyperflexServiceAuthToken,
            'hyperflex.SoftwareDistributionComponent': HyperflexSoftwareDistributionComponent,
            'hyperflex.SoftwareDistributionEntry': HyperflexSoftwareDistributionEntry,
            'hyperflex.SoftwareDistributionVersion': HyperflexSoftwareDistributionVersion,
            'hyperflex.SoftwareVersionPolicy': HyperflexSoftwareVersionPolicy,
            'hyperflex.StorageContainer': HyperflexStorageContainer,
            'hyperflex.SysConfigPolicy': HyperflexSysConfigPolicy,
            'hyperflex.UcsmConfigPolicy': HyperflexUcsmConfigPolicy,
            'hyperflex.VcenterConfigPolicy': HyperflexVcenterConfigPolicy,
            'hyperflex.VmBackupInfo': HyperflexVmBackupInfo,
            'hyperflex.VmImportOperation': HyperflexVmImportOperation,
            'hyperflex.VmRestoreOperation': HyperflexVmRestoreOperation,
            'hyperflex.VmSnapshotInfo': HyperflexVmSnapshotInfo,
            'hyperflex.Volume': HyperflexVolume,
            'hyperflex.WitnessConfiguration': HyperflexWitnessConfiguration,
            'iaas.ConnectorPack': IaasConnectorPack,
            'iaas.DeviceStatus': IaasDeviceStatus,
            'iaas.DiagnosticMessages': IaasDiagnosticMessages,
            'iaas.LicenseInfo': IaasLicenseInfo,
            'iaas.MostRunTasks': IaasMostRunTasks,
            'iaas.ServiceRequest': IaasServiceRequest,
            'iaas.UcsdInfo': IaasUcsdInfo,
            'iaas.UcsdManagedInfra': IaasUcsdManagedInfra,
            'iaas.UcsdMessages': IaasUcsdMessages,
            'iam.Account': IamAccount,
            'iam.AccountExperience': IamAccountExperience,
            'iam.ApiKey': IamApiKey,
            'iam.AppRegistration': IamAppRegistration,
            'iam.BannerMessage': IamBannerMessage,
            'iam.Certificate': IamCertificate,
            'iam.CertificateRequest': IamCertificateRequest,
            'iam.DomainGroup': IamDomainGroup,
            'iam.EndPointPrivilege': IamEndPointPrivilege,
            'iam.EndPointRole': IamEndPointRole,
            'iam.EndPointUser': IamEndPointUser,
            'iam.EndPointUserPolicy': IamEndPointUserPolicy,
            'iam.EndPointUserRole': IamEndPointUserRole,
            'iam.Idp': IamIdp,
            'iam.IdpReference': IamIdpReference,
            'iam.IpAccessManagement': IamIpAccessManagement,
            'iam.IpAddress': IamIpAddress,
            'iam.LdapGroup': IamLdapGroup,
            'iam.LdapPolicy': IamLdapPolicy,
            'iam.LdapProvider': IamLdapProvider,
            'iam.LocalUserPassword': IamLocalUserPassword,
            'iam.LocalUserPasswordPolicy': IamLocalUserPasswordPolicy,
            'iam.OAuthToken': IamOAuthToken,
            'iam.Permission': IamPermission,
            'iam.PrivateKeySpec': IamPrivateKeySpec,
            'iam.Privilege': IamPrivilege,
            'iam.PrivilegeSet': IamPrivilegeSet,
            'iam.Qualifier': IamQualifier,
            'iam.ResourceLimits': IamResourceLimits,
            'iam.ResourcePermission': IamResourcePermission,
            'iam.ResourceRoles': IamResourceRoles,
            'iam.Role': IamRole,
            'iam.SecurityHolder': IamSecurityHolder,
            'iam.ServiceProvider': IamServiceProvider,
            'iam.Session': IamSession,
            'iam.SessionLimits': IamSessionLimits,
            'iam.System': IamSystem,
            'iam.TrustPoint': IamTrustPoint,
            'iam.User': IamUser,
            'iam.UserGroup': IamUserGroup,
            'iam.UserPreference': IamUserPreference,
            'inventory.Base': InventoryBase,
            'inventory.DeviceInfo': InventoryDeviceInfo,
            'inventory.DnMoBinding': InventoryDnMoBinding,
            'inventory.GenericInventory': InventoryGenericInventory,
            'inventory.GenericInventoryHolder': InventoryGenericInventoryHolder,
            'inventory.Request': InventoryRequest,
            'ipmioverlan.Policy': IpmioverlanPolicy,
            'ippool.BlockLease': IppoolBlockLease,
            'ippool.IpLease': IppoolIpLease,
            'ippool.Pool': IppoolPool,
            'ippool.PoolMember': IppoolPoolMember,
            'ippool.ShadowBlock': IppoolShadowBlock,
            'ippool.ShadowPool': IppoolShadowPool,
            'ippool.Universe': IppoolUniverse,
            'iqnpool.Block': IqnpoolBlock,
            'iqnpool.Lease': IqnpoolLease,
            'iqnpool.Pool': IqnpoolPool,
            'iqnpool.PoolMember': IqnpoolPoolMember,
            'iqnpool.Universe': IqnpoolUniverse,
            'iwotenant.TenantStatus': IwotenantTenantStatus,
            'kubernetes.AbstractDaemonSet': KubernetesAbstractDaemonSet,
            'kubernetes.AbstractDeployment': KubernetesAbstractDeployment,
            'kubernetes.AbstractIngress': KubernetesAbstractIngress,
            'kubernetes.AbstractNode': KubernetesAbstractNode,
            'kubernetes.AbstractPod': KubernetesAbstractPod,
            'kubernetes.AbstractService': KubernetesAbstractService,
            'kubernetes.AbstractStatefulSet': KubernetesAbstractStatefulSet,
            'kubernetes.AciCniApic': KubernetesAciCniApic,
            'kubernetes.AciCniProfile': KubernetesAciCniProfile,
            'kubernetes.AciCniTenantClusterAllocation': KubernetesAciCniTenantClusterAllocation,
            'kubernetes.AddonDefinition': KubernetesAddonDefinition,
            'kubernetes.AddonPolicy': KubernetesAddonPolicy,
            'kubernetes.AddonRepository': KubernetesAddonRepository,
            'kubernetes.BaremetalNodeProfile': KubernetesBaremetalNodeProfile,
            'kubernetes.BaseInfrastructureProvider': KubernetesBaseInfrastructureProvider,
            'kubernetes.Catalog': KubernetesCatalog,
            'kubernetes.Cluster': KubernetesCluster,
            'kubernetes.ClusterAddonProfile': KubernetesClusterAddonProfile,
            'kubernetes.ClusterProfile': KubernetesClusterProfile,
            'kubernetes.ConfigResult': KubernetesConfigResult,
            'kubernetes.ConfigResultEntry': KubernetesConfigResultEntry,
            'kubernetes.ContainerRuntimePolicy': KubernetesContainerRuntimePolicy,
            'kubernetes.DaemonSet': KubernetesDaemonSet,
            'kubernetes.Deployment': KubernetesDeployment,
            'kubernetes.Ingress': KubernetesIngress,
            'kubernetes.KubernetesResource': KubernetesKubernetesResource,
            'kubernetes.NetworkPolicy': KubernetesNetworkPolicy,
            'kubernetes.Node': KubernetesNode,
            'kubernetes.NodeGroupProfile': KubernetesNodeGroupProfile,
            'kubernetes.NodeProfile': KubernetesNodeProfile,
            'kubernetes.Pod': KubernetesPod,
            'kubernetes.Service': KubernetesService,
            'kubernetes.StatefulSet': KubernetesStatefulSet,
            'kubernetes.SysConfigPolicy': KubernetesSysConfigPolicy,
            'kubernetes.TrustedRegistriesPolicy': KubernetesTrustedRegistriesPolicy,
            'kubernetes.Version': KubernetesVersion,
            'kubernetes.VersionPolicy': KubernetesVersionPolicy,
            'kubernetes.VirtualMachineInfraConfigPolicy': KubernetesVirtualMachineInfraConfigPolicy,
            'kubernetes.VirtualMachineInfrastructureProvider': KubernetesVirtualMachineInfrastructureProvider,
            'kubernetes.VirtualMachineInstanceType': KubernetesVirtualMachineInstanceType,
            'kubernetes.VirtualMachineNodeProfile': KubernetesVirtualMachineNodeProfile,
            'kvm.Policy': KvmPolicy,
            'kvm.Session': KvmSession,
            'kvm.Tunnel': KvmTunnel,
            'license.AccountLicenseData': LicenseAccountLicenseData,
            'license.CustomerOp': LicenseCustomerOp,
            'license.IwoCustomerOp': LicenseIwoCustomerOp,
            'license.IwoLicenseCount': LicenseIwoLicenseCount,
            'license.LicenseInfo': LicenseLicenseInfo,
            'license.LicenseReservationOp': LicenseLicenseReservationOp,
            'license.SmartlicenseToken': LicenseSmartlicenseToken,
            'ls.ServiceProfile': LsServiceProfile,
            'macpool.IdBlock': MacpoolIdBlock,
            'macpool.Lease': MacpoolLease,
            'macpool.Pool': MacpoolPool,
            'macpool.PoolMember': MacpoolPoolMember,
            'macpool.Universe': MacpoolUniverse,
            'management.Controller': ManagementController,
            'management.Entity': ManagementEntity,
            'management.Interface': ManagementInterface,
            'memory.AbstractUnit': MemoryAbstractUnit,
            'memory.Array': MemoryArray,
            'memory.PersistentMemoryConfigResult': MemoryPersistentMemoryConfigResult,
            'memory.PersistentMemoryConfiguration': MemoryPersistentMemoryConfiguration,
            'memory.PersistentMemoryNamespace': MemoryPersistentMemoryNamespace,
            'memory.PersistentMemoryNamespaceConfigResult': MemoryPersistentMemoryNamespaceConfigResult,
            'memory.PersistentMemoryPolicy': MemoryPersistentMemoryPolicy,
            'memory.PersistentMemoryRegion': MemoryPersistentMemoryRegion,
            'memory.PersistentMemoryUnit': MemoryPersistentMemoryUnit,
            'memory.Unit': MemoryUnit,
            'meta.Definition': MetaDefinition,
            'network.Element': NetworkElement,
            'network.ElementSummary': NetworkElementSummary,
            'network.FcZoneInfo': NetworkFcZoneInfo,
            'network.VlanPortInfo': NetworkVlanPortInfo,
            'networkconfig.Policy': NetworkconfigPolicy,
            'niaapi.ApicCcoPost': NiaapiApicCcoPost,
            'niaapi.ApicFieldNotice': NiaapiApicFieldNotice,
            'niaapi.ApicHweol': NiaapiApicHweol,
            'niaapi.ApicLatestMaintainedRelease': NiaapiApicLatestMaintainedRelease,
            'niaapi.ApicReleaseRecommend': NiaapiApicReleaseRecommend,
            'niaapi.ApicSweol': NiaapiApicSweol,
            'niaapi.DcnmCcoPost': NiaapiDcnmCcoPost,
            'niaapi.DcnmFieldNotice': NiaapiDcnmFieldNotice,
            'niaapi.DcnmHweol': NiaapiDcnmHweol,
            'niaapi.DcnmLatestMaintainedRelease': NiaapiDcnmLatestMaintainedRelease,
            'niaapi.DcnmReleaseRecommend': NiaapiDcnmReleaseRecommend,
            'niaapi.DcnmSweol': NiaapiDcnmSweol,
            'niaapi.FieldNotice': NiaapiFieldNotice,
            'niaapi.FileDownloader': NiaapiFileDownloader,
            'niaapi.HardwareEol': NiaapiHardwareEol,
            'niaapi.MaintainedRelease': NiaapiMaintainedRelease,
            'niaapi.NewReleasePost': NiaapiNewReleasePost,
            'niaapi.NiaMetadata': NiaapiNiaMetadata,
            'niaapi.NibFileDownloader': NiaapiNibFileDownloader,
            'niaapi.NibMetadata': NiaapiNibMetadata,
            'niaapi.ReleaseRecommend': NiaapiReleaseRecommend,
            'niaapi.SoftwareEol': NiaapiSoftwareEol,
            'niaapi.VersionRegex': NiaapiVersionRegex,
            'niatelemetry.AaaLdapProviderDetails': NiatelemetryAaaLdapProviderDetails,
            'niatelemetry.AaaRadiusProviderDetails': NiatelemetryAaaRadiusProviderDetails,
            'niatelemetry.AaaTacacsProviderDetails': NiatelemetryAaaTacacsProviderDetails,
            'niatelemetry.ApicAppPluginDetails': NiatelemetryApicAppPluginDetails,
            'niatelemetry.ApicCoreFileDetails': NiatelemetryApicCoreFileDetails,
            'niatelemetry.ApicDbgexpRsExportDest': NiatelemetryApicDbgexpRsExportDest,
            'niatelemetry.ApicDbgexpRsTsScheduler': NiatelemetryApicDbgexpRsTsScheduler,
            'niatelemetry.ApicFanDetails': NiatelemetryApicFanDetails,
            'niatelemetry.ApicFexDetails': NiatelemetryApicFexDetails,
            'niatelemetry.ApicFlashDetails': NiatelemetryApicFlashDetails,
            'niatelemetry.ApicNtpAuth': NiatelemetryApicNtpAuth,
            'niatelemetry.ApicPsuDetails': NiatelemetryApicPsuDetails,
            'niatelemetry.ApicRealmDetails': NiatelemetryApicRealmDetails,
            'niatelemetry.ApicSnmpClientGrpDetails': NiatelemetryApicSnmpClientGrpDetails,
            'niatelemetry.ApicSnmpCommunityAccessDetails': NiatelemetryApicSnmpCommunityAccessDetails,
            'niatelemetry.ApicSnmpCommunityDetails': NiatelemetryApicSnmpCommunityDetails,
            'niatelemetry.ApicSnmpTrapDetails': NiatelemetryApicSnmpTrapDetails,
            'niatelemetry.ApicSnmpTrapFwdServerDetails': NiatelemetryApicSnmpTrapFwdServerDetails,
            'niatelemetry.ApicSnmpVersionThreeDetails': NiatelemetryApicSnmpVersionThreeDetails,
            'niatelemetry.ApicSysLogGrp': NiatelemetryApicSysLogGrp,
            'niatelemetry.ApicSysLogSrc': NiatelemetryApicSysLogSrc,
            'niatelemetry.ApicTransceiverDetails': NiatelemetryApicTransceiverDetails,
            'niatelemetry.ApicUiPageCounts': NiatelemetryApicUiPageCounts,
            'niatelemetry.AppDetails': NiatelemetryAppDetails,
            'niatelemetry.CommonPolicies': NiatelemetryCommonPolicies,
            'niatelemetry.DcnmFanDetails': NiatelemetryDcnmFanDetails,
            'niatelemetry.DcnmFexDetails': NiatelemetryDcnmFexDetails,
            'niatelemetry.DcnmModuleDetails': NiatelemetryDcnmModuleDetails,
            'niatelemetry.DcnmPsuDetails': NiatelemetryDcnmPsuDetails,
            'niatelemetry.DcnmTransceiverDetails': NiatelemetryDcnmTransceiverDetails,
            'niatelemetry.Epg': NiatelemetryEpg,
            'niatelemetry.FabricModuleDetails': NiatelemetryFabricModuleDetails,
            'niatelemetry.FabricPodProfile': NiatelemetryFabricPodProfile,
            'niatelemetry.FabricPodSs': NiatelemetryFabricPodSs,
            'niatelemetry.Fault': NiatelemetryFault,
            'niatelemetry.HttpsAclContractDetails': NiatelemetryHttpsAclContractDetails,
            'niatelemetry.HttpsAclContractFilterMap': NiatelemetryHttpsAclContractFilterMap,
            'niatelemetry.HttpsAclEpgContractMap': NiatelemetryHttpsAclEpgContractMap,
            'niatelemetry.HttpsAclEpgDetails': NiatelemetryHttpsAclEpgDetails,
            'niatelemetry.HttpsAclFilterDetails': NiatelemetryHttpsAclFilterDetails,
            'niatelemetry.Lc': NiatelemetryLc,
            'niatelemetry.MsoContractDetails': NiatelemetryMsoContractDetails,
            'niatelemetry.MsoEpgDetails': NiatelemetryMsoEpgDetails,
            'niatelemetry.MsoSchemaDetails': NiatelemetryMsoSchemaDetails,
            'niatelemetry.MsoSiteDetails': NiatelemetryMsoSiteDetails,
            'niatelemetry.MsoTenantDetails': NiatelemetryMsoTenantDetails,
            'niatelemetry.NexusDashboardControllerDetails': NiatelemetryNexusDashboardControllerDetails,
            'niatelemetry.NexusDashboardDetails': NiatelemetryNexusDashboardDetails,
            'niatelemetry.NexusDashboardMemoryDetails': NiatelemetryNexusDashboardMemoryDetails,
            'niatelemetry.NexusDashboards': NiatelemetryNexusDashboards,
            'niatelemetry.NiaFeatureUsage': NiatelemetryNiaFeatureUsage,
            'niatelemetry.NiaInventory': NiatelemetryNiaInventory,
            'niatelemetry.NiaInventoryDcnm': NiatelemetryNiaInventoryDcnm,
            'niatelemetry.NiaInventoryFabric': NiatelemetryNiaInventoryFabric,
            'niatelemetry.NiaLicenseState': NiatelemetryNiaLicenseState,
            'niatelemetry.PasswordStrengthCheck': NiatelemetryPasswordStrengthCheck,
            'niatelemetry.PodCommPolicies': NiatelemetryPodCommPolicies,
            'niatelemetry.PodSnmpPolicies': NiatelemetryPodSnmpPolicies,
            'niatelemetry.PodTimeServerPolicies': NiatelemetryPodTimeServerPolicies,
            'niatelemetry.SiteInventory': NiatelemetrySiteInventory,
            'niatelemetry.SnmpSrc': NiatelemetrySnmpSrc,
            'niatelemetry.SshVersionTwo': NiatelemetrySshVersionTwo,
            'niatelemetry.SupervisorModuleDetails': NiatelemetrySupervisorModuleDetails,
            'niatelemetry.SyslogRemoteDest': NiatelemetrySyslogRemoteDest,
            'niatelemetry.SyslogSysMsg': NiatelemetrySyslogSysMsg,
            'niatelemetry.SyslogSysMsgFacFilter': NiatelemetrySyslogSysMsgFacFilter,
            'niatelemetry.SystemControllerDetails': NiatelemetrySystemControllerDetails,
            'niatelemetry.Tenant': NiatelemetryTenant,
            'notification.AccountSubscription': NotificationAccountSubscription,
            'notification.Subscription': NotificationSubscription,
            'ntp.Policy': NtpPolicy,
            'oprs.Deployment': OprsDeployment,
            'oprs.SyncTargetListMessage': OprsSyncTargetListMessage,
            'organization.Organization': OrganizationOrganization,
            'os.BaseInstallConfig': OsBaseInstallConfig,
            'os.BulkInstallInfo': OsBulkInstallInfo,
            'os.Catalog': OsCatalog,
            'os.ConfigurationFile': OsConfigurationFile,
            'os.Distribution': OsDistribution,
            'os.Install': OsInstall,
            'os.OsSupport': OsOsSupport,
            'os.SupportedVersion': OsSupportedVersion,
            'os.TemplateFile': OsTemplateFile,
            'os.ValidInstallTarget': OsValidInstallTarget,
            'pci.CoprocessorCard': PciCoprocessorCard,
            'pci.Device': PciDevice,
            'pci.Link': PciLink,
            'pci.Switch': PciSwitch,
            'policy.AbstractConfigChangeDetail': PolicyAbstractConfigChangeDetail,
            'policy.AbstractConfigProfile': PolicyAbstractConfigProfile,
            'policy.AbstractConfigResult': PolicyAbstractConfigResult,
            'policy.AbstractConfigResultEntry': PolicyAbstractConfigResultEntry,
            'policy.AbstractPolicy': PolicyAbstractPolicy,
            'policy.AbstractProfile': PolicyAbstractProfile,
            'policyinventory.AbstractDeviceInfo': PolicyinventoryAbstractDeviceInfo,
            'pool.AbstractBlock': PoolAbstractBlock,
            'pool.AbstractBlockLease': PoolAbstractBlockLease,
            'pool.AbstractLease': PoolAbstractLease,
            'pool.AbstractPool': PoolAbstractPool,
            'pool.AbstractPoolMember': PoolAbstractPoolMember,
            'port.Group': PortGroup,
            'port.InterfaceBase': PortInterfaceBase,
            'port.MacBinding': PortMacBinding,
            'port.Physical': PortPhysical,
            'port.SubGroup': PortSubGroup,
            'power.ControlState': PowerControlState,
            'power.Policy': PowerPolicy,
            'processor.Unit': ProcessorUnit,
            'rack.UnitPersonality': RackUnitPersonality,
            'recommendation.AbstractItem': RecommendationAbstractItem,
            'recommendation.Base': RecommendationBase,
            'recommendation.CapacityRunway': RecommendationCapacityRunway,
            'recommendation.PhysicalItem': RecommendationPhysicalItem,
            'recovery.AbstractBackupConfig': RecoveryAbstractBackupConfig,
            'recovery.AbstractBackupInfo': RecoveryAbstractBackupInfo,
            'recovery.BackupConfigPolicy': RecoveryBackupConfigPolicy,
            'recovery.BackupProfile': RecoveryBackupProfile,
            'recovery.ConfigResult': RecoveryConfigResult,
            'recovery.ConfigResultEntry': RecoveryConfigResultEntry,
            'recovery.OnDemandBackup': RecoveryOnDemandBackup,
            'recovery.Restore': RecoveryRestore,
            'recovery.ScheduleConfigPolicy': RecoveryScheduleConfigPolicy,
            'resource.Group': ResourceGroup,
            'resource.GroupMember': ResourceGroupMember,
            'resource.LicenseResourceCount': ResourceLicenseResourceCount,
            'resource.Membership': ResourceMembership,
            'resource.MembershipHolder': ResourceMembershipHolder,
            'resource.Reservation': ResourceReservation,
            'resourcepool.Lease': ResourcepoolLease,
            'resourcepool.LeaseResource': ResourcepoolLeaseResource,
            'resourcepool.Pool': ResourcepoolPool,
            'resourcepool.PoolMember': ResourcepoolPoolMember,
            'resourcepool.Universe': ResourcepoolUniverse,
            'rproxy.ReverseProxy': RproxyReverseProxy,
            'sdcard.Policy': SdcardPolicy,
            'sdwan.Profile': SdwanProfile,
            'sdwan.RouterNode': SdwanRouterNode,
            'sdwan.RouterPolicy': SdwanRouterPolicy,
            'sdwan.VmanageAccountPolicy': SdwanVmanageAccountPolicy,
            'search.SearchItem': SearchSearchItem,
            'search.TagItem': SearchTagItem,
            'security.Unit': SecurityUnit,
            'server.BaseProfile': ServerBaseProfile,
            'server.ConfigChangeDetail': ServerConfigChangeDetail,
            'server.ConfigImport': ServerConfigImport,
            'server.ConfigResult': ServerConfigResult,
            'server.ConfigResultEntry': ServerConfigResultEntry,
            'server.Profile': ServerProfile,
            'server.ProfileTemplate': ServerProfileTemplate,
            'session.AbstractSession': SessionAbstractSession,
            'session.AbstractSubSession': SessionAbstractSubSession,
            'smtp.Policy': SmtpPolicy,
            'snmp.Policy': SnmpPolicy,
            'software.ApplianceDistributable': SoftwareApplianceDistributable,
            'software.DownloadHistory': SoftwareDownloadHistory,
            'software.HclMeta': SoftwareHclMeta,
            'software.HyperflexBundleDistributable': SoftwareHyperflexBundleDistributable,
            'software.HyperflexDistributable': SoftwareHyperflexDistributable,
            'software.ReleaseMeta': SoftwareReleaseMeta,
            'software.SolutionDistributable': SoftwareSolutionDistributable,
            'software.UcsdBundleDistributable': SoftwareUcsdBundleDistributable,
            'software.UcsdDistributable': SoftwareUcsdDistributable,
            'softwarerepository.Authorization': SoftwarerepositoryAuthorization,
            'softwarerepository.CachedImage': SoftwarerepositoryCachedImage,
            'softwarerepository.Catalog': SoftwarerepositoryCatalog,
            'softwarerepository.CategoryMapper': SoftwarerepositoryCategoryMapper,
            'softwarerepository.CategoryMapperModel': SoftwarerepositoryCategoryMapperModel,
            'softwarerepository.CategorySupportConstraint': SoftwarerepositoryCategorySupportConstraint,
            'softwarerepository.DownloadSpec': SoftwarerepositoryDownloadSpec,
            'softwarerepository.File': SoftwarerepositoryFile,
            'softwarerepository.OperatingSystemFile': SoftwarerepositoryOperatingSystemFile,
            'softwarerepository.Release': SoftwarerepositoryRelease,
            'sol.Policy': SolPolicy,
            'ssh.Policy': SshPolicy,
            'storage.BaseArray': StorageBaseArray,
            'storage.BaseArrayController': StorageBaseArrayController,
            'storage.BaseArrayDisk': StorageBaseArrayDisk,
            'storage.BaseDiskPool': StorageBaseDiskPool,
            'storage.BaseHost': StorageBaseHost,
            'storage.BaseHostGroup': StorageBaseHostGroup,
            'storage.BaseHostLun': StorageBaseHostLun,
            'storage.BaseNfsExport': StorageBaseNfsExport,
            'storage.BasePhysicalPort': StorageBasePhysicalPort,
            'storage.BaseProtectionGroup': StorageBaseProtectionGroup,
            'storage.BaseProtectionGroupSnapshot': StorageBaseProtectionGroupSnapshot,
            'storage.BaseRaidGroup': StorageBaseRaidGroup,
            'storage.BaseReplicationSchedule': StorageBaseReplicationSchedule,
            'storage.BaseSnapshot': StorageBaseSnapshot,
            'storage.BaseSnapshotSchedule': StorageBaseSnapshotSchedule,
            'storage.BaseStorageContainer': StorageBaseStorageContainer,
            'storage.BaseTenant': StorageBaseTenant,
            'storage.BaseVolume': StorageBaseVolume,
            'storage.Controller': StorageController,
            'storage.DiskGroup': StorageDiskGroup,
            'storage.DiskSlot': StorageDiskSlot,
            'storage.DriveGroup': StorageDriveGroup,
            'storage.Enclosure': StorageEnclosure,
            'storage.EnclosureDisk': StorageEnclosureDisk,
            'storage.EnclosureDiskSlotEp': StorageEnclosureDiskSlotEp,
            'storage.FlexFlashController': StorageFlexFlashController,
            'storage.FlexFlashControllerProps': StorageFlexFlashControllerProps,
            'storage.FlexFlashPhysicalDrive': StorageFlexFlashPhysicalDrive,
            'storage.FlexFlashVirtualDrive': StorageFlexFlashVirtualDrive,
            'storage.FlexUtilController': StorageFlexUtilController,
            'storage.FlexUtilPhysicalDrive': StorageFlexUtilPhysicalDrive,
            'storage.FlexUtilVirtualDrive': StorageFlexUtilVirtualDrive,
            'storage.HitachiArray': StorageHitachiArray,
            'storage.HitachiController': StorageHitachiController,
            'storage.HitachiDisk': StorageHitachiDisk,
            'storage.HitachiHost': StorageHitachiHost,
            'storage.HitachiHostLun': StorageHitachiHostLun,
            'storage.HitachiParityGroup': StorageHitachiParityGroup,
            'storage.HitachiPool': StorageHitachiPool,
            'storage.HitachiPort': StorageHitachiPort,
            'storage.HitachiVolume': StorageHitachiVolume,
            'storage.HyperFlexStorageContainer': StorageHyperFlexStorageContainer,
            'storage.HyperFlexVolume': StorageHyperFlexVolume,
            'storage.Item': StorageItem,
            'storage.NetAppAggregate': StorageNetAppAggregate,
            'storage.NetAppBaseDisk': StorageNetAppBaseDisk,
            'storage.NetAppCluster': StorageNetAppCluster,
            'storage.NetAppEthernetPort': StorageNetAppEthernetPort,
            'storage.NetAppExportPolicy': StorageNetAppExportPolicy,
            'storage.NetAppFcInterface': StorageNetAppFcInterface,
            'storage.NetAppFcPort': StorageNetAppFcPort,
            'storage.NetAppInitiatorGroup': StorageNetAppInitiatorGroup,
            'storage.NetAppIpInterface': StorageNetAppIpInterface,
            'storage.NetAppLicense': StorageNetAppLicense,
            'storage.NetAppLun': StorageNetAppLun,
            'storage.NetAppLunMap': StorageNetAppLunMap,
            'storage.NetAppNode': StorageNetAppNode,
            'storage.NetAppNtpServer': StorageNetAppNtpServer,
            'storage.NetAppSensor': StorageNetAppSensor,
            'storage.NetAppStorageVm': StorageNetAppStorageVm,
            'storage.NetAppVolume': StorageNetAppVolume,
            'storage.NetAppVolumeSnapshot': StorageNetAppVolumeSnapshot,
            'storage.PhysicalDisk': StoragePhysicalDisk,
            'storage.PhysicalDiskExtension': StoragePhysicalDiskExtension,
            'storage.PhysicalDiskUsage': StoragePhysicalDiskUsage,
            'storage.PureArray': StoragePureArray,
            'storage.PureController': StoragePureController,
            'storage.PureDisk': StoragePureDisk,
            'storage.PureHost': StoragePureHost,
            'storage.PureHostGroup': StoragePureHostGroup,
            'storage.PureHostLun': StoragePureHostLun,
            'storage.PurePort': StoragePurePort,
            'storage.PureProtectionGroup': StoragePureProtectionGroup,
            'storage.PureProtectionGroupSnapshot': StoragePureProtectionGroupSnapshot,
            'storage.PureReplicationSchedule': StoragePureReplicationSchedule,
            'storage.PureSnapshotSchedule': StoragePureSnapshotSchedule,
            'storage.PureVolume': StoragePureVolume,
            'storage.PureVolumeSnapshot': StoragePureVolumeSnapshot,
            'storage.SasExpander': StorageSasExpander,
            'storage.SasPort': StorageSasPort,
            'storage.Span': StorageSpan,
            'storage.StoragePolicy': StorageStoragePolicy,
            'storage.VdMemberEp': StorageVdMemberEp,
            'storage.VirtualDrive': StorageVirtualDrive,
            'storage.VirtualDriveContainer': StorageVirtualDriveContainer,
            'storage.VirtualDriveExtension': StorageVirtualDriveExtension,
            'storage.VirtualDriveIdentity': StorageVirtualDriveIdentity,
            'syslog.Policy': SyslogPolicy,
            'tam.AdvisoryCount': TamAdvisoryCount,
            'tam.AdvisoryDefinition': TamAdvisoryDefinition,
            'tam.AdvisoryInfo': TamAdvisoryInfo,
            'tam.AdvisoryInstance': TamAdvisoryInstance,
            'tam.BaseAdvisory': TamBaseAdvisory,
            'tam.SecurityAdvisory': TamSecurityAdvisory,
            'task.HitachiScopedInventory': TaskHitachiScopedInventory,
            'task.HxapScopedInventory': TaskHxapScopedInventory,
            'task.NetAppScopedInventory': TaskNetAppScopedInventory,
            'task.PublicCloudScopedInventory': TaskPublicCloudScopedInventory,
            'task.PureScopedInventory': TaskPureScopedInventory,
            'task.ServerScopedInventory': TaskServerScopedInventory,
            'techsupportmanagement.CollectionControlPolicy': TechsupportmanagementCollectionControlPolicy,
            'techsupportmanagement.Download': TechsupportmanagementDownload,
            'techsupportmanagement.TechSupportBundle': TechsupportmanagementTechSupportBundle,
            'techsupportmanagement.TechSupportStatus': TechsupportmanagementTechSupportStatus,
            'terminal.AuditLog': TerminalAuditLog,
            'terraform.Executor': TerraformExecutor,
            'thermal.Policy': ThermalPolicy,
            'top.System': TopSystem,
            'tunneling.Tunnel': TunnelingTunnel,
            'ucsd.BackupInfo': UcsdBackupInfo,
            'uuidpool.Block': UuidpoolBlock,
            'uuidpool.Pool': UuidpoolPool,
            'uuidpool.PoolMember': UuidpoolPoolMember,
            'uuidpool.Universe': UuidpoolUniverse,
            'uuidpool.UuidLease': UuidpoolUuidLease,
            'views.View': ViewsView,
            'virtualization.BaseCluster': VirtualizationBaseCluster,
            'virtualization.BaseDatacenter': VirtualizationBaseDatacenter,
            'virtualization.BaseDatastore': VirtualizationBaseDatastore,
            'virtualization.BaseDatastoreCluster': VirtualizationBaseDatastoreCluster,
            'virtualization.BaseDistributedNetwork': VirtualizationBaseDistributedNetwork,
            'virtualization.BaseDistributedSwitch': VirtualizationBaseDistributedSwitch,
            'virtualization.BaseDvswitch': VirtualizationBaseDvswitch,
            'virtualization.BaseFolder': VirtualizationBaseFolder,
            'virtualization.BaseHost': VirtualizationBaseHost,
            'virtualization.BaseHypervisorManager': VirtualizationBaseHypervisorManager,
            'virtualization.BaseKernelNetwork': VirtualizationBaseKernelNetwork,
            'virtualization.BaseNetwork': VirtualizationBaseNetwork,
            'virtualization.BasePhysicalNetworkInterface': VirtualizationBasePhysicalNetworkInterface,
            'virtualization.BasePlacement': VirtualizationBasePlacement,
            'virtualization.BaseSourceDevice': VirtualizationBaseSourceDevice,
            'virtualization.BaseSwitch': VirtualizationBaseSwitch,
            'virtualization.BaseVirtualDisk': VirtualizationBaseVirtualDisk,
            'virtualization.BaseVirtualMachine': VirtualizationBaseVirtualMachine,
            'virtualization.BaseVirtualMachineSnapshot': VirtualizationBaseVirtualMachineSnapshot,
            'virtualization.BaseVirtualNetwork': VirtualizationBaseVirtualNetwork,
            'virtualization.BaseVirtualNetworkInterface': VirtualizationBaseVirtualNetworkInterface,
            'virtualization.BaseVirtualNetworkInterfaceCard': VirtualizationBaseVirtualNetworkInterfaceCard,
            'virtualization.BaseVirtualSwitch': VirtualizationBaseVirtualSwitch,
            'virtualization.BaseVswitch': VirtualizationBaseVswitch,
            'virtualization.Host': VirtualizationHost,
            'virtualization.VirtualDisk': VirtualizationVirtualDisk,
            'virtualization.VirtualMachine': VirtualizationVirtualMachine,
            'virtualization.VirtualNetwork': VirtualizationVirtualNetwork,
            'virtualization.VmwareCluster': VirtualizationVmwareCluster,
            'virtualization.VmwareDatacenter': VirtualizationVmwareDatacenter,
            'virtualization.VmwareDatastore': VirtualizationVmwareDatastore,
            'virtualization.VmwareDatastoreCluster': VirtualizationVmwareDatastoreCluster,
            'virtualization.VmwareDistributedNetwork': VirtualizationVmwareDistributedNetwork,
            'virtualization.VmwareDistributedSwitch': VirtualizationVmwareDistributedSwitch,
            'virtualization.VmwareFolder': VirtualizationVmwareFolder,
            'virtualization.VmwareHost': VirtualizationVmwareHost,
            'virtualization.VmwareKernelNetwork': VirtualizationVmwareKernelNetwork,
            'virtualization.VmwareNetwork': VirtualizationVmwareNetwork,
            'virtualization.VmwarePhysicalNetworkInterface': VirtualizationVmwarePhysicalNetworkInterface,
            'virtualization.VmwareUplinkPort': VirtualizationVmwareUplinkPort,
            'virtualization.VmwareVcenter': VirtualizationVmwareVcenter,
            'virtualization.VmwareVirtualDisk': VirtualizationVmwareVirtualDisk,
            'virtualization.VmwareVirtualMachine': VirtualizationVmwareVirtualMachine,
            'virtualization.VmwareVirtualMachineSnapshot': VirtualizationVmwareVirtualMachineSnapshot,
            'virtualization.VmwareVirtualNetworkInterface': VirtualizationVmwareVirtualNetworkInterface,
            'virtualization.VmwareVirtualSwitch': VirtualizationVmwareVirtualSwitch,
            'vmedia.Policy': VmediaPolicy,
            'vmrc.Console': VmrcConsole,
            'vnc.Console': VncConsole,
            'vnic.EthAdapterPolicy': VnicEthAdapterPolicy,
            'vnic.EthIf': VnicEthIf,
            'vnic.EthNetworkPolicy': VnicEthNetworkPolicy,
            'vnic.EthQosPolicy': VnicEthQosPolicy,
            'vnic.FcAdapterPolicy': VnicFcAdapterPolicy,
            'vnic.FcIf': VnicFcIf,
            'vnic.FcNetworkPolicy': VnicFcNetworkPolicy,
            'vnic.FcQosPolicy': VnicFcQosPolicy,
            'vnic.IscsiAdapterPolicy': VnicIscsiAdapterPolicy,
            'vnic.IscsiBootPolicy': VnicIscsiBootPolicy,
            'vnic.IscsiStaticTargetPolicy': VnicIscsiStaticTargetPolicy,
            'vnic.LanConnectivityPolicy': VnicLanConnectivityPolicy,
            'vnic.LcpStatus': VnicLcpStatus,
            'vnic.SanConnectivityPolicy': VnicSanConnectivityPolicy,
            'vnic.ScpStatus': VnicScpStatus,
            'vrf.Vrf': VrfVrf,
            'workflow.BatchApiExecutor': WorkflowBatchApiExecutor,
            'workflow.BatchExecutor': WorkflowBatchExecutor,
            'workflow.BuildTaskMeta': WorkflowBuildTaskMeta,
            'workflow.BuildTaskMetaOwner': WorkflowBuildTaskMetaOwner,
            'workflow.Catalog': WorkflowCatalog,
            'workflow.CustomDataTypeDefinition': WorkflowCustomDataTypeDefinition,
            'workflow.ErrorResponseHandler': WorkflowErrorResponseHandler,
            'workflow.PendingDynamicWorkflowInfo': WorkflowPendingDynamicWorkflowInfo,
            'workflow.RollbackWorkflow': WorkflowRollbackWorkflow,
            'workflow.SolutionActionDefinition': WorkflowSolutionActionDefinition,
            'workflow.SolutionActionInstance': WorkflowSolutionActionInstance,
            'workflow.SolutionDefinition': WorkflowSolutionDefinition,
            'workflow.SolutionInstance': WorkflowSolutionInstance,
            'workflow.SolutionOutput': WorkflowSolutionOutput,
            'workflow.TaskDebugLog': WorkflowTaskDebugLog,
            'workflow.TaskDefinition': WorkflowTaskDefinition,
            'workflow.TaskInfo': WorkflowTaskInfo,
            'workflow.TaskMetadata': WorkflowTaskMetadata,
            'workflow.TaskNotification': WorkflowTaskNotification,
            'workflow.TemplateEvaluation': WorkflowTemplateEvaluation,
            'workflow.TemplateFunctionMeta': WorkflowTemplateFunctionMeta,
            'workflow.WorkflowDefinition': WorkflowWorkflowDefinition,
            'workflow.WorkflowInfo': WorkflowWorkflowInfo,
            'workflow.WorkflowMeta': WorkflowWorkflowMeta,
            'workflow.WorkflowMetadata': WorkflowWorkflowMetadata,
            'workflow.WorkflowNotification': WorkflowWorkflowNotification,
        }
        if not val:
            return None
        return {'class_id': val}

    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'account_moid': 'AccountMoid',  # noqa: E501
        'create_time': 'CreateTime',  # noqa: E501
        'domain_group_moid': 'DomainGroupMoid',  # noqa: E501
        'mod_time': 'ModTime',  # noqa: E501
        'moid': 'Moid',  # noqa: E501
        'owners': 'Owners',  # noqa: E501
        'shared_scope': 'SharedScope',  # noqa: E501
        'tags': 'Tags',  # noqa: E501
        'version_context': 'VersionContext',  # noqa: E501
        'ancestors': 'Ancestors',  # noqa: E501
        'parent': 'Parent',  # noqa: E501
        'permission_resources': 'PermissionResources',  # noqa: E501
        'display_names': 'DisplayNames',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, class_id, object_type, *args, **kwargs):  # noqa: E501
        """MoBaseMo - a model defined in OpenAPI

        Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data. The enum values provides the list of concrete types that can be instantiated from this abstract type.
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property. The enum values provides the list of concrete types that can be instantiated from this abstract type.

        Keyword Args:
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            account_moid (str): The Account ID for this managed object.. [optional]  # noqa: E501
            create_time (datetime): The time when this managed object was created.. [optional]  # noqa: E501
            domain_group_moid (str): The DomainGroup ID for this managed object.. [optional]  # noqa: E501
            mod_time (datetime): The time when this managed object was last modified.. [optional]  # noqa: E501
            moid (str): The unique identifier of this Managed Object instance.. [optional]  # noqa: E501
            owners ([str], none_type): [optional]  # noqa: E501
            shared_scope (str): Intersight provides pre-built workflows, tasks and policies to end users through global catalogs. Objects that are made available through global catalogs are said to have a 'shared' ownership. Shared objects are either made globally available to all end users or restricted to end users based on their license entitlement. Users can use this property to differentiate the scope (global or a specific license tier) to which a shared MO belongs.. [optional]  # noqa: E501
            tags ([MoTag], none_type): [optional]  # noqa: E501
            version_context (MoVersionContext): [optional]  # noqa: E501
            ancestors ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            parent (MoBaseMoRelationship): [optional]  # noqa: E501
            permission_resources ([MoBaseMoRelationship], none_type): An array of relationships to moBaseMo resources.. [optional]  # noqa: E501
            display_names (DisplayNames): [optional]  # noqa: E501
        """

        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
