"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-4903
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
)

def lazy_import():
    from intersight.model.ippool_ip_lease_relationship import IppoolIpLeaseRelationship
    from intersight.model.ippool_pool_relationship import IppoolPoolRelationship
    from intersight.model.kubernetes_aci_cni_profile_relationship import KubernetesAciCniProfileRelationship
    from intersight.model.kubernetes_action_info import KubernetesActionInfo
    from intersight.model.kubernetes_cluster_certificate_configuration import KubernetesClusterCertificateConfiguration
    from intersight.model.kubernetes_cluster_management_config import KubernetesClusterManagementConfig
    from intersight.model.kubernetes_cluster_relationship import KubernetesClusterRelationship
    from intersight.model.kubernetes_configuration import KubernetesConfiguration
    from intersight.model.kubernetes_container_runtime_policy_relationship import KubernetesContainerRuntimePolicyRelationship
    from intersight.model.kubernetes_essential_addon import KubernetesEssentialAddon
    from intersight.model.kubernetes_network_policy_relationship import KubernetesNetworkPolicyRelationship
    from intersight.model.kubernetes_node_group_profile_relationship import KubernetesNodeGroupProfileRelationship
    from intersight.model.kubernetes_sys_config_policy_relationship import KubernetesSysConfigPolicyRelationship
    from intersight.model.kubernetes_trusted_registries_policy_relationship import KubernetesTrustedRegistriesPolicyRelationship
    from intersight.model.mo_base_mo_relationship import MoBaseMoRelationship
    from intersight.model.organization_organization_relationship import OrganizationOrganizationRelationship
    from intersight.model.workflow_workflow_info_relationship import WorkflowWorkflowInfoRelationship
    globals()['IppoolIpLeaseRelationship'] = IppoolIpLeaseRelationship
    globals()['IppoolPoolRelationship'] = IppoolPoolRelationship
    globals()['KubernetesAciCniProfileRelationship'] = KubernetesAciCniProfileRelationship
    globals()['KubernetesActionInfo'] = KubernetesActionInfo
    globals()['KubernetesClusterCertificateConfiguration'] = KubernetesClusterCertificateConfiguration
    globals()['KubernetesClusterManagementConfig'] = KubernetesClusterManagementConfig
    globals()['KubernetesClusterRelationship'] = KubernetesClusterRelationship
    globals()['KubernetesConfiguration'] = KubernetesConfiguration
    globals()['KubernetesContainerRuntimePolicyRelationship'] = KubernetesContainerRuntimePolicyRelationship
    globals()['KubernetesEssentialAddon'] = KubernetesEssentialAddon
    globals()['KubernetesNetworkPolicyRelationship'] = KubernetesNetworkPolicyRelationship
    globals()['KubernetesNodeGroupProfileRelationship'] = KubernetesNodeGroupProfileRelationship
    globals()['KubernetesSysConfigPolicyRelationship'] = KubernetesSysConfigPolicyRelationship
    globals()['KubernetesTrustedRegistriesPolicyRelationship'] = KubernetesTrustedRegistriesPolicyRelationship
    globals()['MoBaseMoRelationship'] = MoBaseMoRelationship
    globals()['OrganizationOrganizationRelationship'] = OrganizationOrganizationRelationship
    globals()['WorkflowWorkflowInfoRelationship'] = WorkflowWorkflowInfoRelationship


class KubernetesClusterProfileAllOf(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('class_id',): {
            'KUBERNETES.CLUSTERPROFILE': "kubernetes.ClusterProfile",
        },
        ('object_type',): {
            'KUBERNETES.CLUSTERPROFILE': "kubernetes.ClusterProfile",
        },
        ('managed_mode',): {
            'PROVIDED': "Provided",
            'MANAGED': "Managed",
        },
        ('status',): {
            'UNDEPLOYED': "Undeployed",
            'CONFIGURING': "Configuring",
            'DEPLOYING': "Deploying",
            'UNDEPLOYING': "Undeploying",
            'DEPLOYFAILEDTERMINAL': "DeployFailedTerminal",
            'DEPLOYFAILED': "DeployFailed",
            'UPGRADING': "Upgrading",
            'DELETING': "Deleting",
            'DELETEFAILED': "DeleteFailed",
            'READY': "Ready",
            'ACTIVE': "Active",
            'SHUTDOWN': "Shutdown",
            'TERMINATED': "Terminated",
            'DEPLOYED': "Deployed",
            'UNDEPLOYFAILED': "UndeployFailed",
            'NOTREADY': "NotReady",
        },
    }

    validations = {
    }

    additional_properties_type = None

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        lazy_import()
        return {
            'class_id': (str,),  # noqa: E501
            'object_type': (str,),  # noqa: E501
            'action_info': (KubernetesActionInfo,),  # noqa: E501
            'cert_config': (KubernetesClusterCertificateConfiguration,),  # noqa: E501
            'essential_addons': ([KubernetesEssentialAddon], none_type,),  # noqa: E501
            'kube_config': (KubernetesConfiguration,),  # noqa: E501
            'managed_mode': (str,),  # noqa: E501
            'management_config': (KubernetesClusterManagementConfig,),  # noqa: E501
            'status': (str,),  # noqa: E501
            'aci_cni_profile': (KubernetesAciCniProfileRelationship,),  # noqa: E501
            'associated_cluster': (KubernetesClusterRelationship,),  # noqa: E501
            'cluster_ip_pools': ([IppoolPoolRelationship], none_type,),  # noqa: E501
            'container_runtime_config': (KubernetesContainerRuntimePolicyRelationship,),  # noqa: E501
            'loadbalancer_ip_leases': ([IppoolIpLeaseRelationship], none_type,),  # noqa: E501
            'master_vip_lease': (IppoolIpLeaseRelationship,),  # noqa: E501
            'net_config': (KubernetesNetworkPolicyRelationship,),  # noqa: E501
            'node_groups': ([KubernetesNodeGroupProfileRelationship], none_type,),  # noqa: E501
            'organization': (OrganizationOrganizationRelationship,),  # noqa: E501
            'parent_solution_profile': (MoBaseMoRelationship,),  # noqa: E501
            'sys_config': (KubernetesSysConfigPolicyRelationship,),  # noqa: E501
            'trusted_registries': (KubernetesTrustedRegistriesPolicyRelationship,),  # noqa: E501
            'workflow_info': (WorkflowWorkflowInfoRelationship,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'class_id': 'ClassId',  # noqa: E501
        'object_type': 'ObjectType',  # noqa: E501
        'action_info': 'ActionInfo',  # noqa: E501
        'cert_config': 'CertConfig',  # noqa: E501
        'essential_addons': 'EssentialAddons',  # noqa: E501
        'kube_config': 'KubeConfig',  # noqa: E501
        'managed_mode': 'ManagedMode',  # noqa: E501
        'management_config': 'ManagementConfig',  # noqa: E501
        'status': 'Status',  # noqa: E501
        'aci_cni_profile': 'AciCniProfile',  # noqa: E501
        'associated_cluster': 'AssociatedCluster',  # noqa: E501
        'cluster_ip_pools': 'ClusterIpPools',  # noqa: E501
        'container_runtime_config': 'ContainerRuntimeConfig',  # noqa: E501
        'loadbalancer_ip_leases': 'LoadbalancerIpLeases',  # noqa: E501
        'master_vip_lease': 'MasterVipLease',  # noqa: E501
        'net_config': 'NetConfig',  # noqa: E501
        'node_groups': 'NodeGroups',  # noqa: E501
        'organization': 'Organization',  # noqa: E501
        'parent_solution_profile': 'ParentSolutionProfile',  # noqa: E501
        'sys_config': 'SysConfig',  # noqa: E501
        'trusted_registries': 'TrustedRegistries',  # noqa: E501
        'workflow_info': 'WorkflowInfo',  # noqa: E501
    }

    _composed_schemas = {}

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """KubernetesClusterProfileAllOf - a model defined in OpenAPI

        Args:

        Keyword Args:
            class_id (str): The fully-qualified name of the instantiated, concrete type. This property is used as a discriminator to identify the type of the payload when marshaling and unmarshaling data.. defaults to "kubernetes.ClusterProfile", must be one of ["kubernetes.ClusterProfile", ]  # noqa: E501
            object_type (str): The fully-qualified name of the instantiated, concrete type. The value should be the same as the 'ClassId' property.. defaults to "kubernetes.ClusterProfile", must be one of ["kubernetes.ClusterProfile", ]  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            action_info (KubernetesActionInfo): [optional]  # noqa: E501
            cert_config (KubernetesClusterCertificateConfiguration): [optional]  # noqa: E501
            essential_addons ([KubernetesEssentialAddon], none_type): [optional]  # noqa: E501
            kube_config (KubernetesConfiguration): [optional]  # noqa: E501
            managed_mode (str): Management mode for the cluster. In some cases Intersight kubernetes service is not required to provision and manage the management entities and endpoints (for e.g. EKS). In most other cases it will be required to provision and manage these entities and endpoints. * `Provided` - Cluster management entities and endpoints are provided by the infrastructure platform. * `Managed` - Cluster management entities and endpoints are provisioned and managed by Intersight kubernetes service.. [optional] if omitted the server will use the default value of "Provided"  # noqa: E501
            management_config (KubernetesClusterManagementConfig): [optional]  # noqa: E501
            status (str): Status of the Kubernetes cluster and its nodes. * `Undeployed` - The cluster is undeployed. * `Configuring` - The cluster is being configured. * `Deploying` - The cluster is being deployed. * `Undeploying` - The cluster is being undeployed. * `DeployFailedTerminal` - The cluster deployment failed terminally and can not be recovered. * `DeployFailed` - The cluster deployment failed. * `Upgrading` - The cluster is being upgraded. * `Deleting` - The cluster is being deleted. * `DeleteFailed` - The cluster delete failed. * `Ready` - The cluster is ready for use. * `Active` - The cluster is being active. * `Shutdown` - All the nodes in the cluster are powered off. * `Terminated` - The cluster is terminated. * `Deployed` - The cluster is deployed. The cluster may not yet be ready for use. * `UndeployFailed` - The cluster undeploy action failed. * `NotReady` - The cluster is created and some nodes are not ready.. [optional] if omitted the server will use the default value of "Undeployed"  # noqa: E501
            aci_cni_profile (KubernetesAciCniProfileRelationship): [optional]  # noqa: E501
            associated_cluster (KubernetesClusterRelationship): [optional]  # noqa: E501
            cluster_ip_pools ([IppoolPoolRelationship], none_type): An array of relationships to ippoolPool resources.. [optional]  # noqa: E501
            container_runtime_config (KubernetesContainerRuntimePolicyRelationship): [optional]  # noqa: E501
            loadbalancer_ip_leases ([IppoolIpLeaseRelationship], none_type): An array of relationships to ippoolIpLease resources.. [optional]  # noqa: E501
            master_vip_lease (IppoolIpLeaseRelationship): [optional]  # noqa: E501
            net_config (KubernetesNetworkPolicyRelationship): [optional]  # noqa: E501
            node_groups ([KubernetesNodeGroupProfileRelationship], none_type): An array of relationships to kubernetesNodeGroupProfile resources.. [optional]  # noqa: E501
            organization (OrganizationOrganizationRelationship): [optional]  # noqa: E501
            parent_solution_profile (MoBaseMoRelationship): [optional]  # noqa: E501
            sys_config (KubernetesSysConfigPolicyRelationship): [optional]  # noqa: E501
            trusted_registries (KubernetesTrustedRegistriesPolicyRelationship): [optional]  # noqa: E501
            workflow_info (WorkflowWorkflowInfoRelationship): [optional]  # noqa: E501
        """

        class_id = kwargs.get('class_id', "kubernetes.ClusterProfile")
        object_type = kwargs.get('object_type', "kubernetes.ClusterProfile")
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            raise ApiTypeError(
                "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                    args,
                    self.__class__.__name__,
                ),
                path_to_item=_path_to_item,
                valid_classes=(self.__class__,),
            )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.class_id = class_id
        self.object_type = object_type
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
