"""
    Cisco Intersight

    Cisco Intersight is a management platform delivered as a service with embedded analytics for your Cisco and 3rd party IT infrastructure. This platform offers an intelligent level of management that enables IT organizations to analyze, simplify, and automate their environments in more advanced ways than the prior generations of tools. Cisco Intersight provides an integrated and intuitive management experience for resources in the traditional data center as well as at the edge. With flexible deployment options to address complex security needs, getting started with Intersight is quick and easy. Cisco Intersight has deep integration with Cisco UCS and HyperFlex systems allowing for remote deployment, configuration, and ongoing maintenance. The model-based deployment works for a single system in a remote location or hundreds of systems in a data center and enables rapid, standardized configuration and deployment. It also streamlines maintaining those systems whether you are working with small or very large configurations. The Intersight OpenAPI document defines the complete set of properties that are returned in the HTTP response. From that perspective, a client can expect that no additional properties are returned, unless these properties are explicitly defined in the OpenAPI document. However, when a client uses an older version of the Intersight OpenAPI document, the server may send additional properties because the software is more recent than the client. In that case, the client may receive properties that it does not know about. Some generated SDKs perform a strict validation of the HTTP response body against the OpenAPI document.  # noqa: E501

    The version of the OpenAPI document: 1.0.9-4903
    Contact: intersight@cisco.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from intersight.api_client import ApiClient, Endpoint as _Endpoint
from intersight.model_utils import (  # noqa: F401
    check_allowed_values,
    check_validations,
    date,
    datetime,
    file_type,
    none_type,
    validate_and_convert_types
)
from intersight.model.error import Error
from intersight.model.hyperflex_alarm import HyperflexAlarm
from intersight.model.hyperflex_alarm_response import HyperflexAlarmResponse
from intersight.model.hyperflex_app_catalog import HyperflexAppCatalog
from intersight.model.hyperflex_app_catalog_response import HyperflexAppCatalogResponse
from intersight.model.hyperflex_auto_support_policy import HyperflexAutoSupportPolicy
from intersight.model.hyperflex_auto_support_policy_response import HyperflexAutoSupportPolicyResponse
from intersight.model.hyperflex_backup_cluster import HyperflexBackupCluster
from intersight.model.hyperflex_backup_cluster_response import HyperflexBackupClusterResponse
from intersight.model.hyperflex_capability_info import HyperflexCapabilityInfo
from intersight.model.hyperflex_capability_info_response import HyperflexCapabilityInfoResponse
from intersight.model.hyperflex_cisco_hypervisor_manager import HyperflexCiscoHypervisorManager
from intersight.model.hyperflex_cisco_hypervisor_manager_response import HyperflexCiscoHypervisorManagerResponse
from intersight.model.hyperflex_cluster import HyperflexCluster
from intersight.model.hyperflex_cluster_backup_policy import HyperflexClusterBackupPolicy
from intersight.model.hyperflex_cluster_backup_policy_deployment import HyperflexClusterBackupPolicyDeployment
from intersight.model.hyperflex_cluster_backup_policy_deployment_response import HyperflexClusterBackupPolicyDeploymentResponse
from intersight.model.hyperflex_cluster_backup_policy_inventory import HyperflexClusterBackupPolicyInventory
from intersight.model.hyperflex_cluster_backup_policy_inventory_response import HyperflexClusterBackupPolicyInventoryResponse
from intersight.model.hyperflex_cluster_backup_policy_response import HyperflexClusterBackupPolicyResponse
from intersight.model.hyperflex_cluster_health_check_execution_snapshot import HyperflexClusterHealthCheckExecutionSnapshot
from intersight.model.hyperflex_cluster_health_check_execution_snapshot_response import HyperflexClusterHealthCheckExecutionSnapshotResponse
from intersight.model.hyperflex_cluster_network_policy import HyperflexClusterNetworkPolicy
from intersight.model.hyperflex_cluster_network_policy_response import HyperflexClusterNetworkPolicyResponse
from intersight.model.hyperflex_cluster_profile import HyperflexClusterProfile
from intersight.model.hyperflex_cluster_profile_response import HyperflexClusterProfileResponse
from intersight.model.hyperflex_cluster_replication_network_policy import HyperflexClusterReplicationNetworkPolicy
from intersight.model.hyperflex_cluster_replication_network_policy_deployment import HyperflexClusterReplicationNetworkPolicyDeployment
from intersight.model.hyperflex_cluster_replication_network_policy_deployment_response import HyperflexClusterReplicationNetworkPolicyDeploymentResponse
from intersight.model.hyperflex_cluster_replication_network_policy_response import HyperflexClusterReplicationNetworkPolicyResponse
from intersight.model.hyperflex_cluster_response import HyperflexClusterResponse
from intersight.model.hyperflex_cluster_storage_policy import HyperflexClusterStoragePolicy
from intersight.model.hyperflex_cluster_storage_policy_response import HyperflexClusterStoragePolicyResponse
from intersight.model.hyperflex_config_result import HyperflexConfigResult
from intersight.model.hyperflex_config_result_entry import HyperflexConfigResultEntry
from intersight.model.hyperflex_config_result_entry_response import HyperflexConfigResultEntryResponse
from intersight.model.hyperflex_config_result_response import HyperflexConfigResultResponse
from intersight.model.hyperflex_data_protection_peer import HyperflexDataProtectionPeer
from intersight.model.hyperflex_data_protection_peer_response import HyperflexDataProtectionPeerResponse
from intersight.model.hyperflex_datastore_statistic import HyperflexDatastoreStatistic
from intersight.model.hyperflex_datastore_statistic_response import HyperflexDatastoreStatisticResponse
from intersight.model.hyperflex_device_package_download_state import HyperflexDevicePackageDownloadState
from intersight.model.hyperflex_device_package_download_state_response import HyperflexDevicePackageDownloadStateResponse
from intersight.model.hyperflex_drive import HyperflexDrive
from intersight.model.hyperflex_drive_response import HyperflexDriveResponse
from intersight.model.hyperflex_ext_fc_storage_policy import HyperflexExtFcStoragePolicy
from intersight.model.hyperflex_ext_fc_storage_policy_response import HyperflexExtFcStoragePolicyResponse
from intersight.model.hyperflex_ext_iscsi_storage_policy import HyperflexExtIscsiStoragePolicy
from intersight.model.hyperflex_ext_iscsi_storage_policy_response import HyperflexExtIscsiStoragePolicyResponse
from intersight.model.hyperflex_feature_limit_external import HyperflexFeatureLimitExternal
from intersight.model.hyperflex_feature_limit_external_response import HyperflexFeatureLimitExternalResponse
from intersight.model.hyperflex_feature_limit_internal import HyperflexFeatureLimitInternal
from intersight.model.hyperflex_feature_limit_internal_response import HyperflexFeatureLimitInternalResponse
from intersight.model.hyperflex_health import HyperflexHealth
from intersight.model.hyperflex_health_check_definition import HyperflexHealthCheckDefinition
from intersight.model.hyperflex_health_check_definition_response import HyperflexHealthCheckDefinitionResponse
from intersight.model.hyperflex_health_check_execution import HyperflexHealthCheckExecution
from intersight.model.hyperflex_health_check_execution_response import HyperflexHealthCheckExecutionResponse
from intersight.model.hyperflex_health_check_execution_snapshot import HyperflexHealthCheckExecutionSnapshot
from intersight.model.hyperflex_health_check_execution_snapshot_response import HyperflexHealthCheckExecutionSnapshotResponse
from intersight.model.hyperflex_health_check_package_checksum import HyperflexHealthCheckPackageChecksum
from intersight.model.hyperflex_health_check_package_checksum_response import HyperflexHealthCheckPackageChecksumResponse
from intersight.model.hyperflex_health_response import HyperflexHealthResponse
from intersight.model.hyperflex_hxap_cluster import HyperflexHxapCluster
from intersight.model.hyperflex_hxap_cluster_response import HyperflexHxapClusterResponse
from intersight.model.hyperflex_hxap_datacenter import HyperflexHxapDatacenter
from intersight.model.hyperflex_hxap_datacenter_response import HyperflexHxapDatacenterResponse
from intersight.model.hyperflex_hxap_dv_uplink import HyperflexHxapDvUplink
from intersight.model.hyperflex_hxap_dv_uplink_response import HyperflexHxapDvUplinkResponse
from intersight.model.hyperflex_hxap_dvswitch import HyperflexHxapDvswitch
from intersight.model.hyperflex_hxap_dvswitch_response import HyperflexHxapDvswitchResponse
from intersight.model.hyperflex_hxap_host import HyperflexHxapHost
from intersight.model.hyperflex_hxap_host_interface import HyperflexHxapHostInterface
from intersight.model.hyperflex_hxap_host_interface_response import HyperflexHxapHostInterfaceResponse
from intersight.model.hyperflex_hxap_host_response import HyperflexHxapHostResponse
from intersight.model.hyperflex_hxap_host_vswitch import HyperflexHxapHostVswitch
from intersight.model.hyperflex_hxap_host_vswitch_response import HyperflexHxapHostVswitchResponse
from intersight.model.hyperflex_hxap_network import HyperflexHxapNetwork
from intersight.model.hyperflex_hxap_network_response import HyperflexHxapNetworkResponse
from intersight.model.hyperflex_hxap_virtual_disk import HyperflexHxapVirtualDisk
from intersight.model.hyperflex_hxap_virtual_disk_response import HyperflexHxapVirtualDiskResponse
from intersight.model.hyperflex_hxap_virtual_machine import HyperflexHxapVirtualMachine
from intersight.model.hyperflex_hxap_virtual_machine_network_interface import HyperflexHxapVirtualMachineNetworkInterface
from intersight.model.hyperflex_hxap_virtual_machine_network_interface_response import HyperflexHxapVirtualMachineNetworkInterfaceResponse
from intersight.model.hyperflex_hxap_virtual_machine_response import HyperflexHxapVirtualMachineResponse
from intersight.model.hyperflex_hxdp_version import HyperflexHxdpVersion
from intersight.model.hyperflex_hxdp_version_response import HyperflexHxdpVersionResponse
from intersight.model.hyperflex_license import HyperflexLicense
from intersight.model.hyperflex_license_response import HyperflexLicenseResponse
from intersight.model.hyperflex_local_credential_policy import HyperflexLocalCredentialPolicy
from intersight.model.hyperflex_local_credential_policy_response import HyperflexLocalCredentialPolicyResponse
from intersight.model.hyperflex_node import HyperflexNode
from intersight.model.hyperflex_node_config_policy import HyperflexNodeConfigPolicy
from intersight.model.hyperflex_node_config_policy_response import HyperflexNodeConfigPolicyResponse
from intersight.model.hyperflex_node_profile import HyperflexNodeProfile
from intersight.model.hyperflex_node_profile_response import HyperflexNodeProfileResponse
from intersight.model.hyperflex_node_response import HyperflexNodeResponse
from intersight.model.hyperflex_protected_cluster import HyperflexProtectedCluster
from intersight.model.hyperflex_protected_cluster_response import HyperflexProtectedClusterResponse
from intersight.model.hyperflex_proxy_setting_policy import HyperflexProxySettingPolicy
from intersight.model.hyperflex_proxy_setting_policy_response import HyperflexProxySettingPolicyResponse
from intersight.model.hyperflex_server_firmware_version import HyperflexServerFirmwareVersion
from intersight.model.hyperflex_server_firmware_version_entry import HyperflexServerFirmwareVersionEntry
from intersight.model.hyperflex_server_firmware_version_entry_response import HyperflexServerFirmwareVersionEntryResponse
from intersight.model.hyperflex_server_firmware_version_response import HyperflexServerFirmwareVersionResponse
from intersight.model.hyperflex_server_model import HyperflexServerModel
from intersight.model.hyperflex_server_model_response import HyperflexServerModelResponse
from intersight.model.hyperflex_service_auth_token import HyperflexServiceAuthToken
from intersight.model.hyperflex_service_auth_token_response import HyperflexServiceAuthTokenResponse
from intersight.model.hyperflex_software_distribution_component import HyperflexSoftwareDistributionComponent
from intersight.model.hyperflex_software_distribution_component_response import HyperflexSoftwareDistributionComponentResponse
from intersight.model.hyperflex_software_distribution_entry import HyperflexSoftwareDistributionEntry
from intersight.model.hyperflex_software_distribution_entry_response import HyperflexSoftwareDistributionEntryResponse
from intersight.model.hyperflex_software_distribution_version import HyperflexSoftwareDistributionVersion
from intersight.model.hyperflex_software_distribution_version_response import HyperflexSoftwareDistributionVersionResponse
from intersight.model.hyperflex_software_version_policy import HyperflexSoftwareVersionPolicy
from intersight.model.hyperflex_software_version_policy_response import HyperflexSoftwareVersionPolicyResponse
from intersight.model.hyperflex_storage_container import HyperflexStorageContainer
from intersight.model.hyperflex_storage_container_response import HyperflexStorageContainerResponse
from intersight.model.hyperflex_sys_config_policy import HyperflexSysConfigPolicy
from intersight.model.hyperflex_sys_config_policy_response import HyperflexSysConfigPolicyResponse
from intersight.model.hyperflex_ucsm_config_policy import HyperflexUcsmConfigPolicy
from intersight.model.hyperflex_ucsm_config_policy_response import HyperflexUcsmConfigPolicyResponse
from intersight.model.hyperflex_vcenter_config_policy import HyperflexVcenterConfigPolicy
from intersight.model.hyperflex_vcenter_config_policy_response import HyperflexVcenterConfigPolicyResponse
from intersight.model.hyperflex_vm_backup_info import HyperflexVmBackupInfo
from intersight.model.hyperflex_vm_backup_info_response import HyperflexVmBackupInfoResponse
from intersight.model.hyperflex_vm_import_operation import HyperflexVmImportOperation
from intersight.model.hyperflex_vm_import_operation_response import HyperflexVmImportOperationResponse
from intersight.model.hyperflex_vm_restore_operation import HyperflexVmRestoreOperation
from intersight.model.hyperflex_vm_restore_operation_response import HyperflexVmRestoreOperationResponse
from intersight.model.hyperflex_vm_snapshot_info import HyperflexVmSnapshotInfo
from intersight.model.hyperflex_vm_snapshot_info_response import HyperflexVmSnapshotInfoResponse
from intersight.model.hyperflex_volume import HyperflexVolume
from intersight.model.hyperflex_volume_response import HyperflexVolumeResponse
from intersight.model.hyperflex_witness_configuration import HyperflexWitnessConfiguration
from intersight.model.hyperflex_witness_configuration_response import HyperflexWitnessConfigurationResponse


class HyperflexApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

        def __create_hyperflex_app_catalog(
            self,
            hyperflex_app_catalog,
            **kwargs
        ):
            """Create a 'hyperflex.AppCatalog' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_app_catalog(hyperflex_app_catalog, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_app_catalog (HyperflexAppCatalog): The 'hyperflex.AppCatalog' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexAppCatalog
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_app_catalog'] = \
                hyperflex_app_catalog
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_app_catalog = _Endpoint(
            settings={
                'response_type': (HyperflexAppCatalog,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/AppCatalogs',
                'operation_id': 'create_hyperflex_app_catalog',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_app_catalog',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_app_catalog',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_app_catalog':
                        (HyperflexAppCatalog,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_app_catalog': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_app_catalog
        )

        def __create_hyperflex_auto_support_policy(
            self,
            hyperflex_auto_support_policy,
            **kwargs
        ):
            """Create a 'hyperflex.AutoSupportPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_auto_support_policy(hyperflex_auto_support_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_auto_support_policy (HyperflexAutoSupportPolicy): The 'hyperflex.AutoSupportPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexAutoSupportPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_auto_support_policy'] = \
                hyperflex_auto_support_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_auto_support_policy = _Endpoint(
            settings={
                'response_type': (HyperflexAutoSupportPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/AutoSupportPolicies',
                'operation_id': 'create_hyperflex_auto_support_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_auto_support_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_auto_support_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_auto_support_policy':
                        (HyperflexAutoSupportPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_auto_support_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_auto_support_policy
        )

        def __create_hyperflex_capability_info(
            self,
            hyperflex_capability_info,
            **kwargs
        ):
            """Create a 'hyperflex.CapabilityInfo' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_capability_info(hyperflex_capability_info, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_capability_info (HyperflexCapabilityInfo): The 'hyperflex.CapabilityInfo' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexCapabilityInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_capability_info'] = \
                hyperflex_capability_info
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_capability_info = _Endpoint(
            settings={
                'response_type': (HyperflexCapabilityInfo,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/CapabilityInfos',
                'operation_id': 'create_hyperflex_capability_info',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_capability_info',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_capability_info',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_capability_info':
                        (HyperflexCapabilityInfo,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_capability_info': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_capability_info
        )

        def __create_hyperflex_cisco_hypervisor_manager(
            self,
            hyperflex_cisco_hypervisor_manager,
            **kwargs
        ):
            """Create a 'hyperflex.CiscoHypervisorManager' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_cisco_hypervisor_manager(hyperflex_cisco_hypervisor_manager, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_cisco_hypervisor_manager (HyperflexCiscoHypervisorManager): The 'hyperflex.CiscoHypervisorManager' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexCiscoHypervisorManager
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_cisco_hypervisor_manager'] = \
                hyperflex_cisco_hypervisor_manager
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_cisco_hypervisor_manager = _Endpoint(
            settings={
                'response_type': (HyperflexCiscoHypervisorManager,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/CiscoHypervisorManagers',
                'operation_id': 'create_hyperflex_cisco_hypervisor_manager',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_cisco_hypervisor_manager',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_cisco_hypervisor_manager',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_cisco_hypervisor_manager':
                        (HyperflexCiscoHypervisorManager,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_cisco_hypervisor_manager': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_cisco_hypervisor_manager
        )

        def __create_hyperflex_cluster_backup_policy(
            self,
            hyperflex_cluster_backup_policy,
            **kwargs
        ):
            """Create a 'hyperflex.ClusterBackupPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_cluster_backup_policy(hyperflex_cluster_backup_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_cluster_backup_policy (HyperflexClusterBackupPolicy): The 'hyperflex.ClusterBackupPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterBackupPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_cluster_backup_policy'] = \
                hyperflex_cluster_backup_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_cluster_backup_policy = _Endpoint(
            settings={
                'response_type': (HyperflexClusterBackupPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicies',
                'operation_id': 'create_hyperflex_cluster_backup_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_cluster_backup_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_cluster_backup_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_cluster_backup_policy':
                        (HyperflexClusterBackupPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_cluster_backup_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_cluster_backup_policy
        )

        def __create_hyperflex_cluster_backup_policy_deployment(
            self,
            hyperflex_cluster_backup_policy_deployment,
            **kwargs
        ):
            """Create a 'hyperflex.ClusterBackupPolicyDeployment' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_cluster_backup_policy_deployment(hyperflex_cluster_backup_policy_deployment, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_cluster_backup_policy_deployment (HyperflexClusterBackupPolicyDeployment): The 'hyperflex.ClusterBackupPolicyDeployment' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterBackupPolicyDeployment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_cluster_backup_policy_deployment'] = \
                hyperflex_cluster_backup_policy_deployment
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_cluster_backup_policy_deployment = _Endpoint(
            settings={
                'response_type': (HyperflexClusterBackupPolicyDeployment,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicyDeployments',
                'operation_id': 'create_hyperflex_cluster_backup_policy_deployment',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_cluster_backup_policy_deployment',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_cluster_backup_policy_deployment',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_cluster_backup_policy_deployment':
                        (HyperflexClusterBackupPolicyDeployment,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_cluster_backup_policy_deployment': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_cluster_backup_policy_deployment
        )

        def __create_hyperflex_cluster_network_policy(
            self,
            hyperflex_cluster_network_policy,
            **kwargs
        ):
            """Create a 'hyperflex.ClusterNetworkPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_cluster_network_policy(hyperflex_cluster_network_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_cluster_network_policy (HyperflexClusterNetworkPolicy): The 'hyperflex.ClusterNetworkPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterNetworkPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_cluster_network_policy'] = \
                hyperflex_cluster_network_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_cluster_network_policy = _Endpoint(
            settings={
                'response_type': (HyperflexClusterNetworkPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterNetworkPolicies',
                'operation_id': 'create_hyperflex_cluster_network_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_cluster_network_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_cluster_network_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_cluster_network_policy':
                        (HyperflexClusterNetworkPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_cluster_network_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_cluster_network_policy
        )

        def __create_hyperflex_cluster_profile(
            self,
            hyperflex_cluster_profile,
            **kwargs
        ):
            """Create a 'hyperflex.ClusterProfile' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_cluster_profile(hyperflex_cluster_profile, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_cluster_profile (HyperflexClusterProfile): The 'hyperflex.ClusterProfile' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_cluster_profile'] = \
                hyperflex_cluster_profile
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_cluster_profile = _Endpoint(
            settings={
                'response_type': (HyperflexClusterProfile,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterProfiles',
                'operation_id': 'create_hyperflex_cluster_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_cluster_profile',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_cluster_profile',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_cluster_profile':
                        (HyperflexClusterProfile,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_cluster_profile': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_cluster_profile
        )

        def __create_hyperflex_cluster_replication_network_policy(
            self,
            hyperflex_cluster_replication_network_policy,
            **kwargs
        ):
            """Create a 'hyperflex.ClusterReplicationNetworkPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_cluster_replication_network_policy(hyperflex_cluster_replication_network_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_cluster_replication_network_policy (HyperflexClusterReplicationNetworkPolicy): The 'hyperflex.ClusterReplicationNetworkPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterReplicationNetworkPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_cluster_replication_network_policy'] = \
                hyperflex_cluster_replication_network_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_cluster_replication_network_policy = _Endpoint(
            settings={
                'response_type': (HyperflexClusterReplicationNetworkPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterReplicationNetworkPolicies',
                'operation_id': 'create_hyperflex_cluster_replication_network_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_cluster_replication_network_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_cluster_replication_network_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_cluster_replication_network_policy':
                        (HyperflexClusterReplicationNetworkPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_cluster_replication_network_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_cluster_replication_network_policy
        )

        def __create_hyperflex_cluster_replication_network_policy_deployment(
            self,
            hyperflex_cluster_replication_network_policy_deployment,
            **kwargs
        ):
            """Create a 'hyperflex.ClusterReplicationNetworkPolicyDeployment' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_cluster_replication_network_policy_deployment(hyperflex_cluster_replication_network_policy_deployment, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_cluster_replication_network_policy_deployment (HyperflexClusterReplicationNetworkPolicyDeployment): The 'hyperflex.ClusterReplicationNetworkPolicyDeployment' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterReplicationNetworkPolicyDeployment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_cluster_replication_network_policy_deployment'] = \
                hyperflex_cluster_replication_network_policy_deployment
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_cluster_replication_network_policy_deployment = _Endpoint(
            settings={
                'response_type': (HyperflexClusterReplicationNetworkPolicyDeployment,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterReplicationNetworkPolicyDeployments',
                'operation_id': 'create_hyperflex_cluster_replication_network_policy_deployment',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_cluster_replication_network_policy_deployment',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_cluster_replication_network_policy_deployment',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_cluster_replication_network_policy_deployment':
                        (HyperflexClusterReplicationNetworkPolicyDeployment,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_cluster_replication_network_policy_deployment': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_cluster_replication_network_policy_deployment
        )

        def __create_hyperflex_cluster_storage_policy(
            self,
            hyperflex_cluster_storage_policy,
            **kwargs
        ):
            """Create a 'hyperflex.ClusterStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_cluster_storage_policy(hyperflex_cluster_storage_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_cluster_storage_policy (HyperflexClusterStoragePolicy): The 'hyperflex.ClusterStoragePolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterStoragePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_cluster_storage_policy'] = \
                hyperflex_cluster_storage_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_cluster_storage_policy = _Endpoint(
            settings={
                'response_type': (HyperflexClusterStoragePolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterStoragePolicies',
                'operation_id': 'create_hyperflex_cluster_storage_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_cluster_storage_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_cluster_storage_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_cluster_storage_policy':
                        (HyperflexClusterStoragePolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_cluster_storage_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_cluster_storage_policy
        )

        def __create_hyperflex_ext_fc_storage_policy(
            self,
            hyperflex_ext_fc_storage_policy,
            **kwargs
        ):
            """Create a 'hyperflex.ExtFcStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_ext_fc_storage_policy(hyperflex_ext_fc_storage_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_ext_fc_storage_policy (HyperflexExtFcStoragePolicy): The 'hyperflex.ExtFcStoragePolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexExtFcStoragePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_ext_fc_storage_policy'] = \
                hyperflex_ext_fc_storage_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_ext_fc_storage_policy = _Endpoint(
            settings={
                'response_type': (HyperflexExtFcStoragePolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ExtFcStoragePolicies',
                'operation_id': 'create_hyperflex_ext_fc_storage_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_ext_fc_storage_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_ext_fc_storage_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_ext_fc_storage_policy':
                        (HyperflexExtFcStoragePolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_ext_fc_storage_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_ext_fc_storage_policy
        )

        def __create_hyperflex_ext_iscsi_storage_policy(
            self,
            hyperflex_ext_iscsi_storage_policy,
            **kwargs
        ):
            """Create a 'hyperflex.ExtIscsiStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_ext_iscsi_storage_policy(hyperflex_ext_iscsi_storage_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_ext_iscsi_storage_policy (HyperflexExtIscsiStoragePolicy): The 'hyperflex.ExtIscsiStoragePolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexExtIscsiStoragePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_ext_iscsi_storage_policy'] = \
                hyperflex_ext_iscsi_storage_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_ext_iscsi_storage_policy = _Endpoint(
            settings={
                'response_type': (HyperflexExtIscsiStoragePolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ExtIscsiStoragePolicies',
                'operation_id': 'create_hyperflex_ext_iscsi_storage_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_ext_iscsi_storage_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_ext_iscsi_storage_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_ext_iscsi_storage_policy':
                        (HyperflexExtIscsiStoragePolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_ext_iscsi_storage_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_ext_iscsi_storage_policy
        )

        def __create_hyperflex_feature_limit_external(
            self,
            hyperflex_feature_limit_external,
            **kwargs
        ):
            """Create a 'hyperflex.FeatureLimitExternal' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_feature_limit_external(hyperflex_feature_limit_external, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_feature_limit_external (HyperflexFeatureLimitExternal): The 'hyperflex.FeatureLimitExternal' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexFeatureLimitExternal
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_feature_limit_external'] = \
                hyperflex_feature_limit_external
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_feature_limit_external = _Endpoint(
            settings={
                'response_type': (HyperflexFeatureLimitExternal,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/FeatureLimitExternals',
                'operation_id': 'create_hyperflex_feature_limit_external',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_feature_limit_external',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_feature_limit_external',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_feature_limit_external':
                        (HyperflexFeatureLimitExternal,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_feature_limit_external': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_feature_limit_external
        )

        def __create_hyperflex_feature_limit_internal(
            self,
            hyperflex_feature_limit_internal,
            **kwargs
        ):
            """Create a 'hyperflex.FeatureLimitInternal' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_feature_limit_internal(hyperflex_feature_limit_internal, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_feature_limit_internal (HyperflexFeatureLimitInternal): The 'hyperflex.FeatureLimitInternal' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexFeatureLimitInternal
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_feature_limit_internal'] = \
                hyperflex_feature_limit_internal
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_feature_limit_internal = _Endpoint(
            settings={
                'response_type': (HyperflexFeatureLimitInternal,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/FeatureLimitInternals',
                'operation_id': 'create_hyperflex_feature_limit_internal',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_feature_limit_internal',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_feature_limit_internal',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_feature_limit_internal':
                        (HyperflexFeatureLimitInternal,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_feature_limit_internal': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_feature_limit_internal
        )

        def __create_hyperflex_health_check_definition(
            self,
            hyperflex_health_check_definition,
            **kwargs
        ):
            """Create a 'hyperflex.HealthCheckDefinition' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_health_check_definition(hyperflex_health_check_definition, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_health_check_definition (HyperflexHealthCheckDefinition): The 'hyperflex.HealthCheckDefinition' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckDefinition
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_health_check_definition'] = \
                hyperflex_health_check_definition
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_health_check_definition = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckDefinition,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckDefinitions',
                'operation_id': 'create_hyperflex_health_check_definition',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_health_check_definition',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_health_check_definition',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_health_check_definition':
                        (HyperflexHealthCheckDefinition,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_health_check_definition': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_health_check_definition
        )

        def __create_hyperflex_health_check_package_checksum(
            self,
            hyperflex_health_check_package_checksum,
            **kwargs
        ):
            """Create a 'hyperflex.HealthCheckPackageChecksum' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_health_check_package_checksum(hyperflex_health_check_package_checksum, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_health_check_package_checksum (HyperflexHealthCheckPackageChecksum): The 'hyperflex.HealthCheckPackageChecksum' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckPackageChecksum
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_health_check_package_checksum'] = \
                hyperflex_health_check_package_checksum
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_health_check_package_checksum = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckPackageChecksum,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckPackageChecksums',
                'operation_id': 'create_hyperflex_health_check_package_checksum',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_health_check_package_checksum',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_health_check_package_checksum',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_health_check_package_checksum':
                        (HyperflexHealthCheckPackageChecksum,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_health_check_package_checksum': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_health_check_package_checksum
        )

        def __create_hyperflex_hxap_datacenter(
            self,
            hyperflex_hxap_datacenter,
            **kwargs
        ):
            """Create a 'hyperflex.HxapDatacenter' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_hxap_datacenter(hyperflex_hxap_datacenter, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_hxap_datacenter (HyperflexHxapDatacenter): The 'hyperflex.HxapDatacenter' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapDatacenter
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_hxap_datacenter'] = \
                hyperflex_hxap_datacenter
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_hxap_datacenter = _Endpoint(
            settings={
                'response_type': (HyperflexHxapDatacenter,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapDatacenters',
                'operation_id': 'create_hyperflex_hxap_datacenter',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_hxap_datacenter',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_hxap_datacenter',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_hxap_datacenter':
                        (HyperflexHxapDatacenter,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_hxap_datacenter': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_hxap_datacenter
        )

        def __create_hyperflex_hxdp_version(
            self,
            hyperflex_hxdp_version,
            **kwargs
        ):
            """Create a 'hyperflex.HxdpVersion' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_hxdp_version(hyperflex_hxdp_version, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_hxdp_version (HyperflexHxdpVersion): The 'hyperflex.HxdpVersion' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxdpVersion
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_hxdp_version'] = \
                hyperflex_hxdp_version
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_hxdp_version = _Endpoint(
            settings={
                'response_type': (HyperflexHxdpVersion,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxdpVersions',
                'operation_id': 'create_hyperflex_hxdp_version',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_hxdp_version',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_hxdp_version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_hxdp_version':
                        (HyperflexHxdpVersion,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_hxdp_version': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_hxdp_version
        )

        def __create_hyperflex_local_credential_policy(
            self,
            hyperflex_local_credential_policy,
            **kwargs
        ):
            """Create a 'hyperflex.LocalCredentialPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_local_credential_policy(hyperflex_local_credential_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_local_credential_policy (HyperflexLocalCredentialPolicy): The 'hyperflex.LocalCredentialPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexLocalCredentialPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_local_credential_policy'] = \
                hyperflex_local_credential_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_local_credential_policy = _Endpoint(
            settings={
                'response_type': (HyperflexLocalCredentialPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/LocalCredentialPolicies',
                'operation_id': 'create_hyperflex_local_credential_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_local_credential_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_local_credential_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_local_credential_policy':
                        (HyperflexLocalCredentialPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_local_credential_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_local_credential_policy
        )

        def __create_hyperflex_node_config_policy(
            self,
            hyperflex_node_config_policy,
            **kwargs
        ):
            """Create a 'hyperflex.NodeConfigPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_node_config_policy(hyperflex_node_config_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_node_config_policy (HyperflexNodeConfigPolicy): The 'hyperflex.NodeConfigPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexNodeConfigPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_node_config_policy'] = \
                hyperflex_node_config_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_node_config_policy = _Endpoint(
            settings={
                'response_type': (HyperflexNodeConfigPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/NodeConfigPolicies',
                'operation_id': 'create_hyperflex_node_config_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_node_config_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_node_config_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_node_config_policy':
                        (HyperflexNodeConfigPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_node_config_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_node_config_policy
        )

        def __create_hyperflex_node_profile(
            self,
            hyperflex_node_profile,
            **kwargs
        ):
            """Create a 'hyperflex.NodeProfile' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_node_profile(hyperflex_node_profile, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_node_profile (HyperflexNodeProfile): The 'hyperflex.NodeProfile' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexNodeProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_node_profile'] = \
                hyperflex_node_profile
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_node_profile = _Endpoint(
            settings={
                'response_type': (HyperflexNodeProfile,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/NodeProfiles',
                'operation_id': 'create_hyperflex_node_profile',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_node_profile',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_node_profile',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_node_profile':
                        (HyperflexNodeProfile,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_node_profile': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_node_profile
        )

        def __create_hyperflex_proxy_setting_policy(
            self,
            hyperflex_proxy_setting_policy,
            **kwargs
        ):
            """Create a 'hyperflex.ProxySettingPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_proxy_setting_policy(hyperflex_proxy_setting_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_proxy_setting_policy (HyperflexProxySettingPolicy): The 'hyperflex.ProxySettingPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexProxySettingPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_proxy_setting_policy'] = \
                hyperflex_proxy_setting_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_proxy_setting_policy = _Endpoint(
            settings={
                'response_type': (HyperflexProxySettingPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ProxySettingPolicies',
                'operation_id': 'create_hyperflex_proxy_setting_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_proxy_setting_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_proxy_setting_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_proxy_setting_policy':
                        (HyperflexProxySettingPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_proxy_setting_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_proxy_setting_policy
        )

        def __create_hyperflex_server_firmware_version(
            self,
            hyperflex_server_firmware_version,
            **kwargs
        ):
            """Create a 'hyperflex.ServerFirmwareVersion' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_server_firmware_version(hyperflex_server_firmware_version, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_server_firmware_version (HyperflexServerFirmwareVersion): The 'hyperflex.ServerFirmwareVersion' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexServerFirmwareVersion
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_server_firmware_version'] = \
                hyperflex_server_firmware_version
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_server_firmware_version = _Endpoint(
            settings={
                'response_type': (HyperflexServerFirmwareVersion,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ServerFirmwareVersions',
                'operation_id': 'create_hyperflex_server_firmware_version',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_server_firmware_version',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_server_firmware_version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_server_firmware_version':
                        (HyperflexServerFirmwareVersion,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_server_firmware_version': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_server_firmware_version
        )

        def __create_hyperflex_server_firmware_version_entry(
            self,
            hyperflex_server_firmware_version_entry,
            **kwargs
        ):
            """Create a 'hyperflex.ServerFirmwareVersionEntry' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_server_firmware_version_entry(hyperflex_server_firmware_version_entry, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_server_firmware_version_entry (HyperflexServerFirmwareVersionEntry): The 'hyperflex.ServerFirmwareVersionEntry' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexServerFirmwareVersionEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_server_firmware_version_entry'] = \
                hyperflex_server_firmware_version_entry
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_server_firmware_version_entry = _Endpoint(
            settings={
                'response_type': (HyperflexServerFirmwareVersionEntry,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ServerFirmwareVersionEntries',
                'operation_id': 'create_hyperflex_server_firmware_version_entry',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_server_firmware_version_entry',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_server_firmware_version_entry',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_server_firmware_version_entry':
                        (HyperflexServerFirmwareVersionEntry,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_server_firmware_version_entry': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_server_firmware_version_entry
        )

        def __create_hyperflex_server_model(
            self,
            hyperflex_server_model,
            **kwargs
        ):
            """Create a 'hyperflex.ServerModel' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_server_model(hyperflex_server_model, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_server_model (HyperflexServerModel): The 'hyperflex.ServerModel' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexServerModel
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_server_model'] = \
                hyperflex_server_model
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_server_model = _Endpoint(
            settings={
                'response_type': (HyperflexServerModel,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ServerModels',
                'operation_id': 'create_hyperflex_server_model',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_server_model',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_server_model',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_server_model':
                        (HyperflexServerModel,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_server_model': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_server_model
        )

        def __create_hyperflex_service_auth_token(
            self,
            hyperflex_service_auth_token,
            **kwargs
        ):
            """Create a 'hyperflex.ServiceAuthToken' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_service_auth_token(hyperflex_service_auth_token, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_service_auth_token (HyperflexServiceAuthToken): The 'hyperflex.ServiceAuthToken' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexServiceAuthToken
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_service_auth_token'] = \
                hyperflex_service_auth_token
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_service_auth_token = _Endpoint(
            settings={
                'response_type': (HyperflexServiceAuthToken,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ServiceAuthTokens',
                'operation_id': 'create_hyperflex_service_auth_token',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_service_auth_token',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_service_auth_token',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_service_auth_token':
                        (HyperflexServiceAuthToken,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_service_auth_token': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_service_auth_token
        )

        def __create_hyperflex_software_distribution_component(
            self,
            hyperflex_software_distribution_component,
            **kwargs
        ):
            """Create a 'hyperflex.SoftwareDistributionComponent' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_software_distribution_component(hyperflex_software_distribution_component, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_software_distribution_component (HyperflexSoftwareDistributionComponent): The 'hyperflex.SoftwareDistributionComponent' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexSoftwareDistributionComponent
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_software_distribution_component'] = \
                hyperflex_software_distribution_component
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_software_distribution_component = _Endpoint(
            settings={
                'response_type': (HyperflexSoftwareDistributionComponent,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SoftwareDistributionComponents',
                'operation_id': 'create_hyperflex_software_distribution_component',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_software_distribution_component',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_software_distribution_component',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_software_distribution_component':
                        (HyperflexSoftwareDistributionComponent,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_software_distribution_component': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_software_distribution_component
        )

        def __create_hyperflex_software_distribution_entry(
            self,
            hyperflex_software_distribution_entry,
            **kwargs
        ):
            """Create a 'hyperflex.SoftwareDistributionEntry' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_software_distribution_entry(hyperflex_software_distribution_entry, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_software_distribution_entry (HyperflexSoftwareDistributionEntry): The 'hyperflex.SoftwareDistributionEntry' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexSoftwareDistributionEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_software_distribution_entry'] = \
                hyperflex_software_distribution_entry
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_software_distribution_entry = _Endpoint(
            settings={
                'response_type': (HyperflexSoftwareDistributionEntry,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SoftwareDistributionEntries',
                'operation_id': 'create_hyperflex_software_distribution_entry',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_software_distribution_entry',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_software_distribution_entry',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_software_distribution_entry':
                        (HyperflexSoftwareDistributionEntry,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_software_distribution_entry': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_software_distribution_entry
        )

        def __create_hyperflex_software_distribution_version(
            self,
            hyperflex_software_distribution_version,
            **kwargs
        ):
            """Create a 'hyperflex.SoftwareDistributionVersion' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_software_distribution_version(hyperflex_software_distribution_version, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_software_distribution_version (HyperflexSoftwareDistributionVersion): The 'hyperflex.SoftwareDistributionVersion' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexSoftwareDistributionVersion
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_software_distribution_version'] = \
                hyperflex_software_distribution_version
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_software_distribution_version = _Endpoint(
            settings={
                'response_type': (HyperflexSoftwareDistributionVersion,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SoftwareDistributionVersions',
                'operation_id': 'create_hyperflex_software_distribution_version',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_software_distribution_version',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_software_distribution_version',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_software_distribution_version':
                        (HyperflexSoftwareDistributionVersion,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_software_distribution_version': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_software_distribution_version
        )

        def __create_hyperflex_software_version_policy(
            self,
            hyperflex_software_version_policy,
            **kwargs
        ):
            """Create a 'hyperflex.SoftwareVersionPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_software_version_policy(hyperflex_software_version_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_software_version_policy (HyperflexSoftwareVersionPolicy): The 'hyperflex.SoftwareVersionPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexSoftwareVersionPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_software_version_policy'] = \
                hyperflex_software_version_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_software_version_policy = _Endpoint(
            settings={
                'response_type': (HyperflexSoftwareVersionPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SoftwareVersionPolicies',
                'operation_id': 'create_hyperflex_software_version_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_software_version_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_software_version_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_software_version_policy':
                        (HyperflexSoftwareVersionPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_software_version_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_software_version_policy
        )

        def __create_hyperflex_sys_config_policy(
            self,
            hyperflex_sys_config_policy,
            **kwargs
        ):
            """Create a 'hyperflex.SysConfigPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_sys_config_policy(hyperflex_sys_config_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_sys_config_policy (HyperflexSysConfigPolicy): The 'hyperflex.SysConfigPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexSysConfigPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_sys_config_policy'] = \
                hyperflex_sys_config_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_sys_config_policy = _Endpoint(
            settings={
                'response_type': (HyperflexSysConfigPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SysConfigPolicies',
                'operation_id': 'create_hyperflex_sys_config_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_sys_config_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_sys_config_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_sys_config_policy':
                        (HyperflexSysConfigPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_sys_config_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_sys_config_policy
        )

        def __create_hyperflex_ucsm_config_policy(
            self,
            hyperflex_ucsm_config_policy,
            **kwargs
        ):
            """Create a 'hyperflex.UcsmConfigPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_ucsm_config_policy(hyperflex_ucsm_config_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_ucsm_config_policy (HyperflexUcsmConfigPolicy): The 'hyperflex.UcsmConfigPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexUcsmConfigPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_ucsm_config_policy'] = \
                hyperflex_ucsm_config_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_ucsm_config_policy = _Endpoint(
            settings={
                'response_type': (HyperflexUcsmConfigPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/UcsmConfigPolicies',
                'operation_id': 'create_hyperflex_ucsm_config_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_ucsm_config_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_ucsm_config_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_ucsm_config_policy':
                        (HyperflexUcsmConfigPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_ucsm_config_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_ucsm_config_policy
        )

        def __create_hyperflex_vcenter_config_policy(
            self,
            hyperflex_vcenter_config_policy,
            **kwargs
        ):
            """Create a 'hyperflex.VcenterConfigPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_vcenter_config_policy(hyperflex_vcenter_config_policy, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_vcenter_config_policy (HyperflexVcenterConfigPolicy): The 'hyperflex.VcenterConfigPolicy' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexVcenterConfigPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_vcenter_config_policy'] = \
                hyperflex_vcenter_config_policy
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_vcenter_config_policy = _Endpoint(
            settings={
                'response_type': (HyperflexVcenterConfigPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/VcenterConfigPolicies',
                'operation_id': 'create_hyperflex_vcenter_config_policy',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_vcenter_config_policy',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_vcenter_config_policy',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_vcenter_config_policy':
                        (HyperflexVcenterConfigPolicy,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_vcenter_config_policy': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_vcenter_config_policy
        )

        def __create_hyperflex_vm_import_operation(
            self,
            hyperflex_vm_import_operation,
            **kwargs
        ):
            """Create a 'hyperflex.VmImportOperation' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_vm_import_operation(hyperflex_vm_import_operation, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_vm_import_operation (HyperflexVmImportOperation): The 'hyperflex.VmImportOperation' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexVmImportOperation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_vm_import_operation'] = \
                hyperflex_vm_import_operation
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_vm_import_operation = _Endpoint(
            settings={
                'response_type': (HyperflexVmImportOperation,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/VmImportOperations',
                'operation_id': 'create_hyperflex_vm_import_operation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_vm_import_operation',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_vm_import_operation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_vm_import_operation':
                        (HyperflexVmImportOperation,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_vm_import_operation': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_vm_import_operation
        )

        def __create_hyperflex_vm_restore_operation(
            self,
            hyperflex_vm_restore_operation,
            **kwargs
        ):
            """Create a 'hyperflex.VmRestoreOperation' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.create_hyperflex_vm_restore_operation(hyperflex_vm_restore_operation, async_req=True)
            >>> result = thread.get()

            Args:
                hyperflex_vm_restore_operation (HyperflexVmRestoreOperation): The 'hyperflex.VmRestoreOperation' resource to create.

            Keyword Args:
                if_match (str): For methods that apply server-side changes, and in particular for PUT, If-Match can be used to prevent the lost update problem. It can check if the modification of a resource that the user wants to upload will not override another change that has been done since the original resource was fetched. If the request cannot be fulfilled, the 412 (Precondition Failed) response is returned. When modifying a resource using POST or PUT, the If-Match header must be set to the value of the resource ModTime property after which no lost update problem should occur. For example, a client send a GET request to obtain a resource, which includes the ModTime property. The ModTime indicates the last time the resource was created or modified. The client then sends a POST or PUT request with the If-Match header set to the ModTime property of the resource as obtained in the GET request.. [optional]
                if_none_match (str): For methods that apply server-side changes, If-None-Match used with the * value can be used to create a resource not known to exist, guaranteeing that another resource creation didn't happen before, losing the data of the previous put. The request will be processed only if the eventually existing resource's ETag doesn't match any of the values listed. Otherwise, the status code 412 (Precondition Failed) is used. The asterisk is a special value representing any resource. It is only useful when creating a resource, usually with PUT, to check if another resource with the identity has already been created before. The comparison with the stored ETag uses the weak comparison algorithm, meaning two resources are considered identical if the content is equivalent - they don't have to be identical byte for byte.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexVmRestoreOperation
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['hyperflex_vm_restore_operation'] = \
                hyperflex_vm_restore_operation
            return self.call_with_http_info(**kwargs)

        self.create_hyperflex_vm_restore_operation = _Endpoint(
            settings={
                'response_type': (HyperflexVmRestoreOperation,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/VmRestoreOperations',
                'operation_id': 'create_hyperflex_vm_restore_operation',
                'http_method': 'POST',
                'servers': None,
            },
            params_map={
                'all': [
                    'hyperflex_vm_restore_operation',
                    'if_match',
                    'if_none_match',
                ],
                'required': [
                    'hyperflex_vm_restore_operation',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'hyperflex_vm_restore_operation':
                        (HyperflexVmRestoreOperation,),
                    'if_match':
                        (str,),
                    'if_none_match':
                        (str,),
                },
                'attribute_map': {
                    'if_match': 'If-Match',
                    'if_none_match': 'If-None-Match',
                },
                'location_map': {
                    'hyperflex_vm_restore_operation': 'body',
                    'if_match': 'header',
                    'if_none_match': 'header',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [
                    'application/json'
                ]
            },
            api_client=api_client,
            callable=__create_hyperflex_vm_restore_operation
        )

        def __delete_hyperflex_app_catalog(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.AppCatalog' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_app_catalog(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_app_catalog = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/AppCatalogs/{Moid}',
                'operation_id': 'delete_hyperflex_app_catalog',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_app_catalog
        )

        def __delete_hyperflex_auto_support_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.AutoSupportPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_auto_support_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_auto_support_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/AutoSupportPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_auto_support_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_auto_support_policy
        )

        def __delete_hyperflex_backup_cluster(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.BackupCluster' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_backup_cluster(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_backup_cluster = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/BackupClusters/{Moid}',
                'operation_id': 'delete_hyperflex_backup_cluster',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_backup_cluster
        )

        def __delete_hyperflex_capability_info(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.CapabilityInfo' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_capability_info(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_capability_info = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/CapabilityInfos/{Moid}',
                'operation_id': 'delete_hyperflex_capability_info',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_capability_info
        )

        def __delete_hyperflex_cluster_backup_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ClusterBackupPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_cluster_backup_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_cluster_backup_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_cluster_backup_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_cluster_backup_policy
        )

        def __delete_hyperflex_cluster_backup_policy_deployment(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ClusterBackupPolicyDeployment' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_cluster_backup_policy_deployment(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_cluster_backup_policy_deployment = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicyDeployments/{Moid}',
                'operation_id': 'delete_hyperflex_cluster_backup_policy_deployment',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_cluster_backup_policy_deployment
        )

        def __delete_hyperflex_cluster_backup_policy_inventory(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ClusterBackupPolicyInventory' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_cluster_backup_policy_inventory(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_cluster_backup_policy_inventory = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicyInventories/{Moid}',
                'operation_id': 'delete_hyperflex_cluster_backup_policy_inventory',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_cluster_backup_policy_inventory
        )

        def __delete_hyperflex_cluster_network_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ClusterNetworkPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_cluster_network_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_cluster_network_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterNetworkPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_cluster_network_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_cluster_network_policy
        )

        def __delete_hyperflex_cluster_profile(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ClusterProfile' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_cluster_profile(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_cluster_profile = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterProfiles/{Moid}',
                'operation_id': 'delete_hyperflex_cluster_profile',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_cluster_profile
        )

        def __delete_hyperflex_cluster_replication_network_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ClusterReplicationNetworkPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_cluster_replication_network_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_cluster_replication_network_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterReplicationNetworkPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_cluster_replication_network_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_cluster_replication_network_policy
        )

        def __delete_hyperflex_cluster_replication_network_policy_deployment(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ClusterReplicationNetworkPolicyDeployment' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_cluster_replication_network_policy_deployment(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_cluster_replication_network_policy_deployment = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterReplicationNetworkPolicyDeployments/{Moid}',
                'operation_id': 'delete_hyperflex_cluster_replication_network_policy_deployment',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_cluster_replication_network_policy_deployment
        )

        def __delete_hyperflex_cluster_storage_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ClusterStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_cluster_storage_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_cluster_storage_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterStoragePolicies/{Moid}',
                'operation_id': 'delete_hyperflex_cluster_storage_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_cluster_storage_policy
        )

        def __delete_hyperflex_ext_fc_storage_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ExtFcStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_ext_fc_storage_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_ext_fc_storage_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ExtFcStoragePolicies/{Moid}',
                'operation_id': 'delete_hyperflex_ext_fc_storage_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_ext_fc_storage_policy
        )

        def __delete_hyperflex_ext_iscsi_storage_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ExtIscsiStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_ext_iscsi_storage_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_ext_iscsi_storage_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ExtIscsiStoragePolicies/{Moid}',
                'operation_id': 'delete_hyperflex_ext_iscsi_storage_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_ext_iscsi_storage_policy
        )

        def __delete_hyperflex_feature_limit_external(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.FeatureLimitExternal' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_feature_limit_external(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_feature_limit_external = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/FeatureLimitExternals/{Moid}',
                'operation_id': 'delete_hyperflex_feature_limit_external',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_feature_limit_external
        )

        def __delete_hyperflex_feature_limit_internal(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.FeatureLimitInternal' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_feature_limit_internal(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_feature_limit_internal = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/FeatureLimitInternals/{Moid}',
                'operation_id': 'delete_hyperflex_feature_limit_internal',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_feature_limit_internal
        )

        def __delete_hyperflex_health_check_definition(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.HealthCheckDefinition' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_health_check_definition(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_health_check_definition = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckDefinitions/{Moid}',
                'operation_id': 'delete_hyperflex_health_check_definition',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_health_check_definition
        )

        def __delete_hyperflex_health_check_package_checksum(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.HealthCheckPackageChecksum' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_health_check_package_checksum(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_health_check_package_checksum = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckPackageChecksums/{Moid}',
                'operation_id': 'delete_hyperflex_health_check_package_checksum',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_health_check_package_checksum
        )

        def __delete_hyperflex_hxap_cluster(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.HxapCluster' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_hxap_cluster(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_hxap_cluster = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapClusters/{Moid}',
                'operation_id': 'delete_hyperflex_hxap_cluster',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_hxap_cluster
        )

        def __delete_hyperflex_hxap_datacenter(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.HxapDatacenter' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_hxap_datacenter(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_hxap_datacenter = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapDatacenters/{Moid}',
                'operation_id': 'delete_hyperflex_hxap_datacenter',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_hxap_datacenter
        )

        def __delete_hyperflex_hxap_virtual_machine_network_interface(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.HxapVirtualMachineNetworkInterface' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_hxap_virtual_machine_network_interface(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_hxap_virtual_machine_network_interface = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapVirtualMachineNetworkInterfaces/{Moid}',
                'operation_id': 'delete_hyperflex_hxap_virtual_machine_network_interface',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_hxap_virtual_machine_network_interface
        )

        def __delete_hyperflex_hxdp_version(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.HxdpVersion' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_hxdp_version(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_hxdp_version = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxdpVersions/{Moid}',
                'operation_id': 'delete_hyperflex_hxdp_version',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_hxdp_version
        )

        def __delete_hyperflex_local_credential_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.LocalCredentialPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_local_credential_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_local_credential_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/LocalCredentialPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_local_credential_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_local_credential_policy
        )

        def __delete_hyperflex_node_config_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.NodeConfigPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_node_config_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_node_config_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/NodeConfigPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_node_config_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_node_config_policy
        )

        def __delete_hyperflex_node_profile(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.NodeProfile' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_node_profile(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_node_profile = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/NodeProfiles/{Moid}',
                'operation_id': 'delete_hyperflex_node_profile',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_node_profile
        )

        def __delete_hyperflex_proxy_setting_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ProxySettingPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_proxy_setting_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_proxy_setting_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ProxySettingPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_proxy_setting_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_proxy_setting_policy
        )

        def __delete_hyperflex_server_firmware_version(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ServerFirmwareVersion' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_server_firmware_version(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_server_firmware_version = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ServerFirmwareVersions/{Moid}',
                'operation_id': 'delete_hyperflex_server_firmware_version',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_server_firmware_version
        )

        def __delete_hyperflex_server_firmware_version_entry(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ServerFirmwareVersionEntry' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_server_firmware_version_entry(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_server_firmware_version_entry = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ServerFirmwareVersionEntries/{Moid}',
                'operation_id': 'delete_hyperflex_server_firmware_version_entry',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_server_firmware_version_entry
        )

        def __delete_hyperflex_server_model(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ServerModel' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_server_model(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_server_model = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ServerModels/{Moid}',
                'operation_id': 'delete_hyperflex_server_model',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_server_model
        )

        def __delete_hyperflex_service_auth_token(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.ServiceAuthToken' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_service_auth_token(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_service_auth_token = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ServiceAuthTokens/{Moid}',
                'operation_id': 'delete_hyperflex_service_auth_token',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_service_auth_token
        )

        def __delete_hyperflex_software_distribution_component(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.SoftwareDistributionComponent' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_software_distribution_component(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_software_distribution_component = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SoftwareDistributionComponents/{Moid}',
                'operation_id': 'delete_hyperflex_software_distribution_component',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_software_distribution_component
        )

        def __delete_hyperflex_software_distribution_entry(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.SoftwareDistributionEntry' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_software_distribution_entry(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_software_distribution_entry = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SoftwareDistributionEntries/{Moid}',
                'operation_id': 'delete_hyperflex_software_distribution_entry',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_software_distribution_entry
        )

        def __delete_hyperflex_software_distribution_version(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.SoftwareDistributionVersion' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_software_distribution_version(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_software_distribution_version = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SoftwareDistributionVersions/{Moid}',
                'operation_id': 'delete_hyperflex_software_distribution_version',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_software_distribution_version
        )

        def __delete_hyperflex_software_version_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.SoftwareVersionPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_software_version_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_software_version_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SoftwareVersionPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_software_version_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_software_version_policy
        )

        def __delete_hyperflex_sys_config_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.SysConfigPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_sys_config_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_sys_config_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/SysConfigPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_sys_config_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_sys_config_policy
        )

        def __delete_hyperflex_ucsm_config_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.UcsmConfigPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_ucsm_config_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_ucsm_config_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/UcsmConfigPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_ucsm_config_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_ucsm_config_policy
        )

        def __delete_hyperflex_vcenter_config_policy(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.VcenterConfigPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_vcenter_config_policy(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_vcenter_config_policy = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/VcenterConfigPolicies/{Moid}',
                'operation_id': 'delete_hyperflex_vcenter_config_policy',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_vcenter_config_policy
        )

        def __delete_hyperflex_vm_backup_info(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.VmBackupInfo' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_vm_backup_info(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_vm_backup_info = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/VmBackupInfos/{Moid}',
                'operation_id': 'delete_hyperflex_vm_backup_info',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_vm_backup_info
        )

        def __delete_hyperflex_vm_import_operation(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.VmImportOperation' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_vm_import_operation(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_vm_import_operation = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/VmImportOperations/{Moid}',
                'operation_id': 'delete_hyperflex_vm_import_operation',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_vm_import_operation
        )

        def __delete_hyperflex_vm_restore_operation(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.VmRestoreOperation' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_vm_restore_operation(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_vm_restore_operation = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/VmRestoreOperations/{Moid}',
                'operation_id': 'delete_hyperflex_vm_restore_operation',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_vm_restore_operation
        )

        def __delete_hyperflex_vm_snapshot_info(
            self,
            moid,
            **kwargs
        ):
            """Delete a 'hyperflex.VmSnapshotInfo' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.delete_hyperflex_vm_snapshot_info(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                None
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.delete_hyperflex_vm_snapshot_info = _Endpoint(
            settings={
                'response_type': None,
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/VmSnapshotInfos/{Moid}',
                'operation_id': 'delete_hyperflex_vm_snapshot_info',
                'http_method': 'DELETE',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__delete_hyperflex_vm_snapshot_info
        )

        def __get_hyperflex_alarm_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.Alarm' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_alarm_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexAlarm
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_alarm_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexAlarm,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/Alarms/{Moid}',
                'operation_id': 'get_hyperflex_alarm_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_alarm_by_moid
        )

        def __get_hyperflex_alarm_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.Alarm' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_alarm_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexAlarmResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_alarm_list = _Endpoint(
            settings={
                'response_type': (HyperflexAlarmResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/Alarms',
                'operation_id': 'get_hyperflex_alarm_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_alarm_list
        )

        def __get_hyperflex_app_catalog_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.AppCatalog' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_app_catalog_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexAppCatalog
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_app_catalog_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexAppCatalog,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/AppCatalogs/{Moid}',
                'operation_id': 'get_hyperflex_app_catalog_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_app_catalog_by_moid
        )

        def __get_hyperflex_app_catalog_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.AppCatalog' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_app_catalog_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexAppCatalogResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_app_catalog_list = _Endpoint(
            settings={
                'response_type': (HyperflexAppCatalogResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/AppCatalogs',
                'operation_id': 'get_hyperflex_app_catalog_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_app_catalog_list
        )

        def __get_hyperflex_auto_support_policy_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.AutoSupportPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_auto_support_policy_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexAutoSupportPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_auto_support_policy_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexAutoSupportPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/AutoSupportPolicies/{Moid}',
                'operation_id': 'get_hyperflex_auto_support_policy_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_auto_support_policy_by_moid
        )

        def __get_hyperflex_auto_support_policy_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.AutoSupportPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_auto_support_policy_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexAutoSupportPolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_auto_support_policy_list = _Endpoint(
            settings={
                'response_type': (HyperflexAutoSupportPolicyResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/AutoSupportPolicies',
                'operation_id': 'get_hyperflex_auto_support_policy_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_auto_support_policy_list
        )

        def __get_hyperflex_backup_cluster_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.BackupCluster' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_backup_cluster_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexBackupCluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_backup_cluster_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexBackupCluster,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/BackupClusters/{Moid}',
                'operation_id': 'get_hyperflex_backup_cluster_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_backup_cluster_by_moid
        )

        def __get_hyperflex_backup_cluster_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.BackupCluster' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_backup_cluster_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexBackupClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_backup_cluster_list = _Endpoint(
            settings={
                'response_type': (HyperflexBackupClusterResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/BackupClusters',
                'operation_id': 'get_hyperflex_backup_cluster_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_backup_cluster_list
        )

        def __get_hyperflex_capability_info_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.CapabilityInfo' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_capability_info_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexCapabilityInfo
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_capability_info_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexCapabilityInfo,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/CapabilityInfos/{Moid}',
                'operation_id': 'get_hyperflex_capability_info_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_capability_info_by_moid
        )

        def __get_hyperflex_capability_info_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.CapabilityInfo' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_capability_info_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexCapabilityInfoResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_capability_info_list = _Endpoint(
            settings={
                'response_type': (HyperflexCapabilityInfoResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/CapabilityInfos',
                'operation_id': 'get_hyperflex_capability_info_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_capability_info_list
        )

        def __get_hyperflex_cisco_hypervisor_manager_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.CiscoHypervisorManager' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cisco_hypervisor_manager_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexCiscoHypervisorManager
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cisco_hypervisor_manager_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexCiscoHypervisorManager,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/CiscoHypervisorManagers/{Moid}',
                'operation_id': 'get_hyperflex_cisco_hypervisor_manager_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cisco_hypervisor_manager_by_moid
        )

        def __get_hyperflex_cisco_hypervisor_manager_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.CiscoHypervisorManager' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cisco_hypervisor_manager_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexCiscoHypervisorManagerResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cisco_hypervisor_manager_list = _Endpoint(
            settings={
                'response_type': (HyperflexCiscoHypervisorManagerResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/CiscoHypervisorManagers',
                'operation_id': 'get_hyperflex_cisco_hypervisor_manager_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cisco_hypervisor_manager_list
        )

        def __get_hyperflex_cluster_backup_policy_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterBackupPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_backup_policy_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterBackupPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_backup_policy_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterBackupPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicies/{Moid}',
                'operation_id': 'get_hyperflex_cluster_backup_policy_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_backup_policy_by_moid
        )

        def __get_hyperflex_cluster_backup_policy_deployment_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterBackupPolicyDeployment' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_backup_policy_deployment_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterBackupPolicyDeployment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_backup_policy_deployment_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterBackupPolicyDeployment,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicyDeployments/{Moid}',
                'operation_id': 'get_hyperflex_cluster_backup_policy_deployment_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_backup_policy_deployment_by_moid
        )

        def __get_hyperflex_cluster_backup_policy_deployment_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterBackupPolicyDeployment' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_backup_policy_deployment_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterBackupPolicyDeploymentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_backup_policy_deployment_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterBackupPolicyDeploymentResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicyDeployments',
                'operation_id': 'get_hyperflex_cluster_backup_policy_deployment_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_backup_policy_deployment_list
        )

        def __get_hyperflex_cluster_backup_policy_inventory_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterBackupPolicyInventory' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_backup_policy_inventory_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterBackupPolicyInventory
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_backup_policy_inventory_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterBackupPolicyInventory,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicyInventories/{Moid}',
                'operation_id': 'get_hyperflex_cluster_backup_policy_inventory_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_backup_policy_inventory_by_moid
        )

        def __get_hyperflex_cluster_backup_policy_inventory_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterBackupPolicyInventory' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_backup_policy_inventory_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterBackupPolicyInventoryResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_backup_policy_inventory_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterBackupPolicyInventoryResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicyInventories',
                'operation_id': 'get_hyperflex_cluster_backup_policy_inventory_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_backup_policy_inventory_list
        )

        def __get_hyperflex_cluster_backup_policy_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterBackupPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_backup_policy_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterBackupPolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_backup_policy_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterBackupPolicyResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterBackupPolicies',
                'operation_id': 'get_hyperflex_cluster_backup_policy_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_backup_policy_list
        )

        def __get_hyperflex_cluster_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.Cluster' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexCluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexCluster,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/Clusters/{Moid}',
                'operation_id': 'get_hyperflex_cluster_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_by_moid
        )

        def __get_hyperflex_cluster_health_check_execution_snapshot_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterHealthCheckExecutionSnapshot' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_health_check_execution_snapshot_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterHealthCheckExecutionSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_health_check_execution_snapshot_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterHealthCheckExecutionSnapshot,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterHealthCheckExecutionSnapshots/{Moid}',
                'operation_id': 'get_hyperflex_cluster_health_check_execution_snapshot_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_health_check_execution_snapshot_by_moid
        )

        def __get_hyperflex_cluster_health_check_execution_snapshot_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterHealthCheckExecutionSnapshot' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_health_check_execution_snapshot_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterHealthCheckExecutionSnapshotResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_health_check_execution_snapshot_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterHealthCheckExecutionSnapshotResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterHealthCheckExecutionSnapshots',
                'operation_id': 'get_hyperflex_cluster_health_check_execution_snapshot_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_health_check_execution_snapshot_list
        )

        def __get_hyperflex_cluster_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.Cluster' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/Clusters',
                'operation_id': 'get_hyperflex_cluster_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_list
        )

        def __get_hyperflex_cluster_network_policy_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterNetworkPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_network_policy_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterNetworkPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_network_policy_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterNetworkPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterNetworkPolicies/{Moid}',
                'operation_id': 'get_hyperflex_cluster_network_policy_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_network_policy_by_moid
        )

        def __get_hyperflex_cluster_network_policy_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterNetworkPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_network_policy_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterNetworkPolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_network_policy_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterNetworkPolicyResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterNetworkPolicies',
                'operation_id': 'get_hyperflex_cluster_network_policy_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_network_policy_list
        )

        def __get_hyperflex_cluster_profile_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterProfile' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_profile_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterProfile
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_profile_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterProfile,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterProfiles/{Moid}',
                'operation_id': 'get_hyperflex_cluster_profile_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_profile_by_moid
        )

        def __get_hyperflex_cluster_profile_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterProfile' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_profile_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterProfileResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_profile_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterProfileResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterProfiles',
                'operation_id': 'get_hyperflex_cluster_profile_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_profile_list
        )

        def __get_hyperflex_cluster_replication_network_policy_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterReplicationNetworkPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_replication_network_policy_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterReplicationNetworkPolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_replication_network_policy_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterReplicationNetworkPolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterReplicationNetworkPolicies/{Moid}',
                'operation_id': 'get_hyperflex_cluster_replication_network_policy_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_replication_network_policy_by_moid
        )

        def __get_hyperflex_cluster_replication_network_policy_deployment_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterReplicationNetworkPolicyDeployment' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_replication_network_policy_deployment_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterReplicationNetworkPolicyDeployment
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_replication_network_policy_deployment_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterReplicationNetworkPolicyDeployment,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterReplicationNetworkPolicyDeployments/{Moid}',
                'operation_id': 'get_hyperflex_cluster_replication_network_policy_deployment_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_replication_network_policy_deployment_by_moid
        )

        def __get_hyperflex_cluster_replication_network_policy_deployment_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterReplicationNetworkPolicyDeployment' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_replication_network_policy_deployment_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterReplicationNetworkPolicyDeploymentResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_replication_network_policy_deployment_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterReplicationNetworkPolicyDeploymentResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterReplicationNetworkPolicyDeployments',
                'operation_id': 'get_hyperflex_cluster_replication_network_policy_deployment_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_replication_network_policy_deployment_list
        )

        def __get_hyperflex_cluster_replication_network_policy_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterReplicationNetworkPolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_replication_network_policy_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterReplicationNetworkPolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_replication_network_policy_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterReplicationNetworkPolicyResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterReplicationNetworkPolicies',
                'operation_id': 'get_hyperflex_cluster_replication_network_policy_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_replication_network_policy_list
        )

        def __get_hyperflex_cluster_storage_policy_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_storage_policy_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterStoragePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_storage_policy_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexClusterStoragePolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterStoragePolicies/{Moid}',
                'operation_id': 'get_hyperflex_cluster_storage_policy_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_storage_policy_by_moid
        )

        def __get_hyperflex_cluster_storage_policy_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ClusterStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_cluster_storage_policy_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexClusterStoragePolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_cluster_storage_policy_list = _Endpoint(
            settings={
                'response_type': (HyperflexClusterStoragePolicyResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ClusterStoragePolicies',
                'operation_id': 'get_hyperflex_cluster_storage_policy_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_cluster_storage_policy_list
        )

        def __get_hyperflex_config_result_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ConfigResult' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_config_result_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexConfigResult
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_config_result_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexConfigResult,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ConfigResults/{Moid}',
                'operation_id': 'get_hyperflex_config_result_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_config_result_by_moid
        )

        def __get_hyperflex_config_result_entry_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ConfigResultEntry' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_config_result_entry_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexConfigResultEntry
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_config_result_entry_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexConfigResultEntry,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ConfigResultEntries/{Moid}',
                'operation_id': 'get_hyperflex_config_result_entry_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_config_result_entry_by_moid
        )

        def __get_hyperflex_config_result_entry_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ConfigResultEntry' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_config_result_entry_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexConfigResultEntryResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_config_result_entry_list = _Endpoint(
            settings={
                'response_type': (HyperflexConfigResultEntryResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ConfigResultEntries',
                'operation_id': 'get_hyperflex_config_result_entry_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_config_result_entry_list
        )

        def __get_hyperflex_config_result_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ConfigResult' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_config_result_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexConfigResultResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_config_result_list = _Endpoint(
            settings={
                'response_type': (HyperflexConfigResultResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ConfigResults',
                'operation_id': 'get_hyperflex_config_result_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_config_result_list
        )

        def __get_hyperflex_data_protection_peer_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.DataProtectionPeer' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_data_protection_peer_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexDataProtectionPeer
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_data_protection_peer_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexDataProtectionPeer,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/DataProtectionPeers/{Moid}',
                'operation_id': 'get_hyperflex_data_protection_peer_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_data_protection_peer_by_moid
        )

        def __get_hyperflex_data_protection_peer_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.DataProtectionPeer' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_data_protection_peer_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexDataProtectionPeerResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_data_protection_peer_list = _Endpoint(
            settings={
                'response_type': (HyperflexDataProtectionPeerResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/DataProtectionPeers',
                'operation_id': 'get_hyperflex_data_protection_peer_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_data_protection_peer_list
        )

        def __get_hyperflex_datastore_statistic_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.DatastoreStatistic' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_datastore_statistic_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexDatastoreStatistic
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_datastore_statistic_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexDatastoreStatistic,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/DatastoreStatistics/{Moid}',
                'operation_id': 'get_hyperflex_datastore_statistic_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_datastore_statistic_by_moid
        )

        def __get_hyperflex_datastore_statistic_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.DatastoreStatistic' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_datastore_statistic_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexDatastoreStatisticResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_datastore_statistic_list = _Endpoint(
            settings={
                'response_type': (HyperflexDatastoreStatisticResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/DatastoreStatistics',
                'operation_id': 'get_hyperflex_datastore_statistic_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_datastore_statistic_list
        )

        def __get_hyperflex_device_package_download_state_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.DevicePackageDownloadState' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_device_package_download_state_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexDevicePackageDownloadState
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_device_package_download_state_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexDevicePackageDownloadState,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/DevicePackageDownloadStates/{Moid}',
                'operation_id': 'get_hyperflex_device_package_download_state_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_device_package_download_state_by_moid
        )

        def __get_hyperflex_device_package_download_state_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.DevicePackageDownloadState' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_device_package_download_state_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexDevicePackageDownloadStateResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_device_package_download_state_list = _Endpoint(
            settings={
                'response_type': (HyperflexDevicePackageDownloadStateResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/DevicePackageDownloadStates',
                'operation_id': 'get_hyperflex_device_package_download_state_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_device_package_download_state_list
        )

        def __get_hyperflex_drive_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.Drive' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_drive_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexDrive
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_drive_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexDrive,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/Drives/{Moid}',
                'operation_id': 'get_hyperflex_drive_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_drive_by_moid
        )

        def __get_hyperflex_drive_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.Drive' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_drive_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexDriveResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_drive_list = _Endpoint(
            settings={
                'response_type': (HyperflexDriveResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/Drives',
                'operation_id': 'get_hyperflex_drive_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_drive_list
        )

        def __get_hyperflex_ext_fc_storage_policy_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ExtFcStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_ext_fc_storage_policy_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexExtFcStoragePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_ext_fc_storage_policy_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexExtFcStoragePolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ExtFcStoragePolicies/{Moid}',
                'operation_id': 'get_hyperflex_ext_fc_storage_policy_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_ext_fc_storage_policy_by_moid
        )

        def __get_hyperflex_ext_fc_storage_policy_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ExtFcStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_ext_fc_storage_policy_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexExtFcStoragePolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_ext_fc_storage_policy_list = _Endpoint(
            settings={
                'response_type': (HyperflexExtFcStoragePolicyResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ExtFcStoragePolicies',
                'operation_id': 'get_hyperflex_ext_fc_storage_policy_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_ext_fc_storage_policy_list
        )

        def __get_hyperflex_ext_iscsi_storage_policy_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.ExtIscsiStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_ext_iscsi_storage_policy_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexExtIscsiStoragePolicy
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_ext_iscsi_storage_policy_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexExtIscsiStoragePolicy,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ExtIscsiStoragePolicies/{Moid}',
                'operation_id': 'get_hyperflex_ext_iscsi_storage_policy_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_ext_iscsi_storage_policy_by_moid
        )

        def __get_hyperflex_ext_iscsi_storage_policy_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.ExtIscsiStoragePolicy' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_ext_iscsi_storage_policy_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexExtIscsiStoragePolicyResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_ext_iscsi_storage_policy_list = _Endpoint(
            settings={
                'response_type': (HyperflexExtIscsiStoragePolicyResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/ExtIscsiStoragePolicies',
                'operation_id': 'get_hyperflex_ext_iscsi_storage_policy_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_ext_iscsi_storage_policy_list
        )

        def __get_hyperflex_feature_limit_external_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.FeatureLimitExternal' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_feature_limit_external_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexFeatureLimitExternal
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_feature_limit_external_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexFeatureLimitExternal,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/FeatureLimitExternals/{Moid}',
                'operation_id': 'get_hyperflex_feature_limit_external_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_feature_limit_external_by_moid
        )

        def __get_hyperflex_feature_limit_external_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.FeatureLimitExternal' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_feature_limit_external_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexFeatureLimitExternalResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_feature_limit_external_list = _Endpoint(
            settings={
                'response_type': (HyperflexFeatureLimitExternalResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/FeatureLimitExternals',
                'operation_id': 'get_hyperflex_feature_limit_external_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_feature_limit_external_list
        )

        def __get_hyperflex_feature_limit_internal_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.FeatureLimitInternal' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_feature_limit_internal_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexFeatureLimitInternal
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_feature_limit_internal_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexFeatureLimitInternal,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/FeatureLimitInternals/{Moid}',
                'operation_id': 'get_hyperflex_feature_limit_internal_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_feature_limit_internal_by_moid
        )

        def __get_hyperflex_feature_limit_internal_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.FeatureLimitInternal' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_feature_limit_internal_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexFeatureLimitInternalResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_feature_limit_internal_list = _Endpoint(
            settings={
                'response_type': (HyperflexFeatureLimitInternalResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/FeatureLimitInternals',
                'operation_id': 'get_hyperflex_feature_limit_internal_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_feature_limit_internal_list
        )

        def __get_hyperflex_health_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.Health' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealth
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHealth,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/Healths/{Moid}',
                'operation_id': 'get_hyperflex_health_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_by_moid
        )

        def __get_hyperflex_health_check_definition_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HealthCheckDefinition' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_check_definition_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckDefinition
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_check_definition_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckDefinition,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckDefinitions/{Moid}',
                'operation_id': 'get_hyperflex_health_check_definition_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_check_definition_by_moid
        )

        def __get_hyperflex_health_check_definition_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HealthCheckDefinition' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_check_definition_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckDefinitionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_check_definition_list = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckDefinitionResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckDefinitions',
                'operation_id': 'get_hyperflex_health_check_definition_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_check_definition_list
        )

        def __get_hyperflex_health_check_execution_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HealthCheckExecution' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_check_execution_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckExecution
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_check_execution_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckExecution,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckExecutions/{Moid}',
                'operation_id': 'get_hyperflex_health_check_execution_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_check_execution_by_moid
        )

        def __get_hyperflex_health_check_execution_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HealthCheckExecution' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_check_execution_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckExecutionResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_check_execution_list = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckExecutionResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckExecutions',
                'operation_id': 'get_hyperflex_health_check_execution_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_check_execution_list
        )

        def __get_hyperflex_health_check_execution_snapshot_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HealthCheckExecutionSnapshot' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_check_execution_snapshot_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckExecutionSnapshot
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_check_execution_snapshot_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckExecutionSnapshot,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckExecutionSnapshots/{Moid}',
                'operation_id': 'get_hyperflex_health_check_execution_snapshot_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_check_execution_snapshot_by_moid
        )

        def __get_hyperflex_health_check_execution_snapshot_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HealthCheckExecutionSnapshot' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_check_execution_snapshot_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckExecutionSnapshotResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_check_execution_snapshot_list = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckExecutionSnapshotResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckExecutionSnapshots',
                'operation_id': 'get_hyperflex_health_check_execution_snapshot_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_check_execution_snapshot_list
        )

        def __get_hyperflex_health_check_package_checksum_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HealthCheckPackageChecksum' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_check_package_checksum_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckPackageChecksum
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_check_package_checksum_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckPackageChecksum,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckPackageChecksums/{Moid}',
                'operation_id': 'get_hyperflex_health_check_package_checksum_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_check_package_checksum_by_moid
        )

        def __get_hyperflex_health_check_package_checksum_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HealthCheckPackageChecksum' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_check_package_checksum_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthCheckPackageChecksumResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_check_package_checksum_list = _Endpoint(
            settings={
                'response_type': (HyperflexHealthCheckPackageChecksumResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HealthCheckPackageChecksums',
                'operation_id': 'get_hyperflex_health_check_package_checksum_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_check_package_checksum_list
        )

        def __get_hyperflex_health_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.Health' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_health_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHealthResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_health_list = _Endpoint(
            settings={
                'response_type': (HyperflexHealthResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/Healths',
                'operation_id': 'get_hyperflex_health_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_health_list
        )

        def __get_hyperflex_hxap_cluster_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HxapCluster' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_cluster_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapCluster
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_cluster_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHxapCluster,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapClusters/{Moid}',
                'operation_id': 'get_hyperflex_hxap_cluster_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_cluster_by_moid
        )

        def __get_hyperflex_hxap_cluster_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HxapCluster' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_cluster_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapClusterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_cluster_list = _Endpoint(
            settings={
                'response_type': (HyperflexHxapClusterResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapClusters',
                'operation_id': 'get_hyperflex_hxap_cluster_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_cluster_list
        )

        def __get_hyperflex_hxap_datacenter_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HxapDatacenter' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_datacenter_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapDatacenter
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_datacenter_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHxapDatacenter,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapDatacenters/{Moid}',
                'operation_id': 'get_hyperflex_hxap_datacenter_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_datacenter_by_moid
        )

        def __get_hyperflex_hxap_datacenter_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HxapDatacenter' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_datacenter_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapDatacenterResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_datacenter_list = _Endpoint(
            settings={
                'response_type': (HyperflexHxapDatacenterResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapDatacenters',
                'operation_id': 'get_hyperflex_hxap_datacenter_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_datacenter_list
        )

        def __get_hyperflex_hxap_dv_uplink_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HxapDvUplink' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_dv_uplink_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapDvUplink
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_dv_uplink_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHxapDvUplink,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapDvUplinks/{Moid}',
                'operation_id': 'get_hyperflex_hxap_dv_uplink_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_dv_uplink_by_moid
        )

        def __get_hyperflex_hxap_dv_uplink_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HxapDvUplink' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_dv_uplink_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapDvUplinkResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_dv_uplink_list = _Endpoint(
            settings={
                'response_type': (HyperflexHxapDvUplinkResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapDvUplinks',
                'operation_id': 'get_hyperflex_hxap_dv_uplink_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_dv_uplink_list
        )

        def __get_hyperflex_hxap_dvswitch_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HxapDvswitch' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_dvswitch_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapDvswitch
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_dvswitch_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHxapDvswitch,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapDvswitches/{Moid}',
                'operation_id': 'get_hyperflex_hxap_dvswitch_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_dvswitch_by_moid
        )

        def __get_hyperflex_hxap_dvswitch_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HxapDvswitch' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_dvswitch_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapDvswitchResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_dvswitch_list = _Endpoint(
            settings={
                'response_type': (HyperflexHxapDvswitchResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapDvswitches',
                'operation_id': 'get_hyperflex_hxap_dvswitch_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_dvswitch_list
        )

        def __get_hyperflex_hxap_host_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HxapHost' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_host_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapHost
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_host_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHxapHost,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapHosts/{Moid}',
                'operation_id': 'get_hyperflex_hxap_host_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_host_by_moid
        )

        def __get_hyperflex_hxap_host_interface_by_moid(
            self,
            moid,
            **kwargs
        ):
            """Read a 'hyperflex.HxapHostInterface' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_host_interface_by_moid(moid, async_req=True)
            >>> result = thread.get()

            Args:
                moid (str): The unique Moid identifier of a resource instance.

            Keyword Args:
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapHostInterface
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            kwargs['moid'] = \
                moid
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_host_interface_by_moid = _Endpoint(
            settings={
                'response_type': (HyperflexHxapHostInterface,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapHostInterfaces/{Moid}',
                'operation_id': 'get_hyperflex_hxap_host_interface_by_moid',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'moid',
                ],
                'required': [
                    'moid',
                ],
                'nullable': [
                ],
                'enum': [
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                },
                'openapi_types': {
                    'moid':
                        (str,),
                },
                'attribute_map': {
                    'moid': 'Moid',
                },
                'location_map': {
                    'moid': 'path',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_host_interface_by_moid
        )

        def __get_hyperflex_hxap_host_interface_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HxapHostInterface' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_host_interface_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter queries supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false).. [optional] if omitted the server will use the default value of ""
                orderby (str): Determines what properties are used to sort the collection of resources.. [optional]
                top (int): Specifies the maximum number of resources to return in the response.. [optional] if omitted the server will use the default value of 100
                skip (int): Specifies the number of resources to skip in the response.. [optional] if omitted the server will use the default value of 0
                select (str): Specifies a subset of properties to return.. [optional] if omitted the server will use the default value of ""
                expand (str): Specify additional attributes or related resources to return in addition to the primary resources.. [optional]
                apply (str): Specify one or more transformation operations to perform aggregation on the resources. The transformations are processed in order with the output from a transformation being used as input for the subsequent transformation. The \"$apply\" query takes a sequence of set transformations, separated by forward slashes to express that they are consecutively applied, i.e. the result of each transformation is the input to the next transformation. Supported aggregation methods are \"aggregate\" and \"groupby\". The **aggregate** transformation takes a comma-separated list of one or more aggregate expressions as parameters and returns a result set with a single instance, representing the aggregated value for all instances in the input set. The **groupby** transformation takes one or two parameters and 1. Splits the initial set into subsets where all instances in a subset have the same values for the grouping properties specified in the first parameter, 2. Applies set transformations to each subset according to the second parameter, resulting in a new set of potentially different structure and cardinality, 3. Ensures that the instances in the result set contain all grouping properties with the correct values for the group, 4. Concatenates the intermediate result sets into one result set. A groupby transformation affects the structure of the result set.. [optional]
                count (bool): The $count query specifies the service should return the count of the matching resources, instead of returning the resources.. [optional]
                inlinecount (str): The $inlinecount query option allows clients to request an inline count of the matching resources included with the resources in the response.. [optional] if omitted the server will use the default value of "allpages"
                at (str): Similar to \"$filter\", but \"at\" is specifically used to filter versioning information properties for resources to return. A URI with an \"at\" Query Option identifies a subset of the Entries from the Collection of Entries identified by the Resource Path section of the URI. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the query option. The expression language that is used in at operators supports references to properties and literals. The literal values can be strings enclosed in single quotes, numbers and boolean values (true or false) or any of the additional literal representations shown in the Abstract Type System section.. [optional]
                tags (str): The 'tags' parameter is used to request a summary of the Tag utilization for this resource. When the 'tags' parameter is specified, the response provides a list of tag keys, the number of times the key has been used across all documents, and the tag values that have been assigned to the tag key.. [optional]
                _return_http_data_only (bool): response data without head status
                    code and headers. Default is True.
                _preload_content (bool): if False, the urllib3.HTTPResponse object
                    will be returned without reading/decoding response data.
                    Default is True.
                _request_timeout (float/tuple): timeout setting for this request. If one
                    number provided, it will be total request timeout. It can also
                    be a pair (tuple) of (connection, read) timeouts.
                    Default is None.
                _check_input_type (bool): specifies if type checking
                    should be done one the data sent to the server.
                    Default is True.
                _check_return_type (bool): specifies if type checking
                    should be done one the data received from the server.
                    Default is True.
                _host_index (int/None): specifies the index of the server
                    that we want to use.
                    Default is read from the configuration.
                async_req (bool): execute request asynchronously

            Returns:
                HyperflexHxapHostInterfaceResponse
                    If the method is called asynchronously, returns the request
                    thread.
            """
            kwargs['async_req'] = kwargs.get(
                'async_req', False
            )
            kwargs['_return_http_data_only'] = kwargs.get(
                '_return_http_data_only', True
            )
            kwargs['_preload_content'] = kwargs.get(
                '_preload_content', True
            )
            kwargs['_request_timeout'] = kwargs.get(
                '_request_timeout', None
            )
            kwargs['_check_input_type'] = kwargs.get(
                '_check_input_type', True
            )
            kwargs['_check_return_type'] = kwargs.get(
                '_check_return_type', True
            )
            kwargs['_host_index'] = kwargs.get('_host_index')
            return self.call_with_http_info(**kwargs)

        self.get_hyperflex_hxap_host_interface_list = _Endpoint(
            settings={
                'response_type': (HyperflexHxapHostInterfaceResponse,),
                'auth': [
                    'cookieAuth',
                    'http_signature',
                    'oAuth2',
                    'oAuth2'
                ],
                'endpoint_path': '/api/v1/hyperflex/HxapHostInterfaces',
                'operation_id': 'get_hyperflex_hxap_host_interface_list',
                'http_method': 'GET',
                'servers': None,
            },
            params_map={
                'all': [
                    'filter',
                    'orderby',
                    'top',
                    'skip',
                    'select',
                    'expand',
                    'apply',
                    'count',
                    'inlinecount',
                    'at',
                    'tags',
                ],
                'required': [],
                'nullable': [
                ],
                'enum': [
                    'inlinecount',
                ],
                'validation': [
                ]
            },
            root_map={
                'validations': {
                },
                'allowed_values': {
                    ('inlinecount',): {

                        "ALLPAGES": "allpages",
                        "NONE": "none"
                    },
                },
                'openapi_types': {
                    'filter':
                        (str,),
                    'orderby':
                        (str,),
                    'top':
                        (int,),
                    'skip':
                        (int,),
                    'select':
                        (str,),
                    'expand':
                        (str,),
                    'apply':
                        (str,),
                    'count':
                        (bool,),
                    'inlinecount':
                        (str,),
                    'at':
                        (str,),
                    'tags':
                        (str,),
                },
                'attribute_map': {
                    'filter': '$filter',
                    'orderby': '$orderby',
                    'top': '$top',
                    'skip': '$skip',
                    'select': '$select',
                    'expand': '$expand',
                    'apply': '$apply',
                    'count': '$count',
                    'inlinecount': '$inlinecount',
                    'at': 'at',
                    'tags': 'tags',
                },
                'location_map': {
                    'filter': 'query',
                    'orderby': 'query',
                    'top': 'query',
                    'skip': 'query',
                    'select': 'query',
                    'expand': 'query',
                    'apply': 'query',
                    'count': 'query',
                    'inlinecount': 'query',
                    'at': 'query',
                    'tags': 'query',
                },
                'collection_format_map': {
                }
            },
            headers_map={
                'accept': [
                    'application/json',
                    'text/csv',
                    'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'
                ],
                'content_type': [],
            },
            api_client=api_client,
            callable=__get_hyperflex_hxap_host_interface_list
        )

        def __get_hyperflex_hxap_host_list(
            self,
            **kwargs
        ):
            """Read a 'hyperflex.HxapHost' resource.  # noqa: E501

            This method makes a synchronous HTTP request by default. To make an
            asynchronous HTTP request, please pass async_req=True

            >>> thread = api.get_hyperflex_hxap_host_list(async_req=True)
            >>> result = thread.get()


            Keyword Args:
                filter (str): Filter criteria for the resources to return. A URI with a $filter query option identifies a subset of the entries from the Collection of Entries. The subset is determined by selecting only the Entries that satisfy the predicate expression specified by the $filter option. The expression language that is used in $filter q