"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MavenPackaging = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const component_1 = require("../component");
/**
 * Configures a maven project to produce a .jar archive with sources and javadocs.
 */
class MavenPackaging extends component_1.Component {
    constructor(project, pom, options = {}) {
        super(project);
        pom.addPlugin("org.apache.maven.plugins/maven-jar-plugin@3.2.0", {
            configuration: {
                archive: {
                    index: true,
                    manifest: {
                        addDefaultImplementationEntries: true,
                        addDefaultSpecificationEntries: true,
                    },
                },
            },
        });
        if (options.sources ?? true) {
            pom.addPlugin("org.apache.maven.plugins/maven-source-plugin@3.2.1", {
                executions: [{ id: "attach-sources", goals: ["jar"] }],
            });
        }
        if (options.javadocs ?? true) {
            pom.addPlugin("org.apache.maven.plugins/maven-javadoc-plugin@3.2.0", {
                executions: [{ id: "attach-javadocs", goals: ["jar"] }],
                configuration: {
                    failOnError: false,
                    show: "protected",
                    sourceFileExcludes: { exclude: options.javadocsExclude },
                    detectJavaApiLink: false,
                    additionalJOptions: {
                        additionalJOption: [
                            "-J-XX:+TieredCompilation",
                            "-J-XX:TieredStopAtLevel=1",
                        ],
                    },
                },
            });
        }
        const env = {
            MAVEN_OPTS: "-XX:+TieredCompilation -XX:TieredStopAtLevel=1",
        };
        const distdir = options.distdir ?? "dist/java";
        for (const [k, v] of Object.entries(env)) {
            this.project.packageTask.env(k, v);
        }
        this.project.packageTask.exec(`mkdir -p ${distdir}`);
        this.project.packageTask.exec(`mvn deploy -D=altDeploymentRepository=local::default::file:///$PWD/${distdir}`);
        project.gitignore.exclude(distdir);
    }
}
exports.MavenPackaging = MavenPackaging;
_a = JSII_RTTI_SYMBOL_1;
MavenPackaging[_a] = { fqn: "projen.java.MavenPackaging", version: "0.67.87" };
//# sourceMappingURL=data:application/json;base64,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