import { __rest } from "tslib";
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
import React, { useState } from 'react';
import clsx from 'clsx';
import Option from '../internal/components/option';
import { fireNonCancelableEvent } from '../internal/events';
import checkControlled from '../internal/hooks/check-controlled';
import { useUniqueId } from '../internal/hooks/use-unique-id';
import { getBaseProps } from '../internal/base-component';
import SpaceBetween from '../space-between/internal';
import DismissButton from './dismiss-button';
import SelectToggle from './toggle';
import styles from './styles.css.js';
export default function InternalTokenGroup(_a) {
    var { items, alignment, onDismiss, __internalRootRef, limit } = _a, props = __rest(_a, ["items", "alignment", "onDismiss", "__internalRootRef", "limit"]);
    checkControlled('TokenGroup', 'items', items, 'onDismiss', onDismiss);
    const [expanded, setExpanded] = useState(false);
    const controlId = useUniqueId();
    const hasItems = items.length > 0;
    const hasHiddenItems = hasItems && limit !== undefined && items.length > limit;
    const slicedItems = hasHiddenItems && !expanded ? items.slice(0, limit) : items;
    const baseProps = getBaseProps(props);
    const className = clsx(baseProps.className, styles.root, hasItems && styles['has-items']);
    return (React.createElement("div", Object.assign({}, baseProps, { className: className, ref: __internalRootRef }),
        hasItems && (React.createElement(SpaceBetween, { id: controlId, direction: alignment, size: "xs" }, slicedItems.map((item, itemIndex) => (React.createElement(Token, Object.assign({ key: itemIndex }, item, { onDismiss: () => fireNonCancelableEvent(onDismiss, { itemIndex }) })))))),
        hasHiddenItems && (React.createElement(SelectToggle, { controlId: controlId, allHidden: limit === 0, expanded: expanded, numberOfHiddenOptions: items.length - slicedItems.length, i18nStrings: props.i18nStrings, onClick: () => setExpanded(!expanded) }))));
}
export function Token(_a) {
    var { disabled, dismissLabel, onDismiss } = _a, props = __rest(_a, ["disabled", "dismissLabel", "onDismiss"]);
    return (React.createElement("div", { className: clsx(styles.token, disabled && styles['token-disabled']), "aria-disabled": disabled ? 'true' : undefined },
        React.createElement(Option, { option: Object.assign(Object.assign({}, props), { disabled }) }),
        React.createElement(DismissButton, { disabled: disabled, dismissLabel: dismissLabel, onDismiss: onDismiss })));
}
//# sourceMappingURL=internal.js.map