"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const styles_selectors_js_1 = require("../../../property-filter/styles.selectors.js");
const autosuggest_1 = require("../autosuggest");
const filtering_token_1 = require("../internal/filtering-token");
class PropertyFilterWrapper extends autosuggest_1.default {
    findResultsCount() {
        return this.findByClassName(styles_selectors_js_1.default.results);
    }
    findTokens() {
        return this.findAllByClassName(filtering_token_1.default.rootSelector).map((elementWrapper) => new filtering_token_1.default(elementWrapper.getElement()));
    }
    /**
     * Returns the button that toggles if the tokens above `tokenLimit` are visible.
     */
    findTokenToggle() {
        return this.findByClassName(styles_selectors_js_1.default['toggle-collapsed']);
    }
    /**
     * Returns the button that removes all current tokens.
     */
    findRemoveAllButton() {
        return this.findByClassName(styles_selectors_js_1.default['remove-all']);
    }
}
exports.default = PropertyFilterWrapper;
PropertyFilterWrapper.rootSelector = styles_selectors_js_1.default.root;
//# sourceMappingURL=index.js.map