# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'AuthenticationResponse',
    'CustomAccountResponse',
    'GoogleAccountResponse',
    'IapCredentialResponse',
    'IapTestServiceAccountInfoResponse',
    'ScheduleResponse',
]

@pulumi.output_type
class AuthenticationResponse(dict):
    """
    Scan authentication configuration.
    """
    def __init__(__self__, *,
                 custom_account: 'outputs.CustomAccountResponse',
                 google_account: 'outputs.GoogleAccountResponse',
                 iap_credential: 'outputs.IapCredentialResponse'):
        """
        Scan authentication configuration.
        :param 'CustomAccountResponseArgs' custom_account: Authentication using a custom account.
        :param 'GoogleAccountResponseArgs' google_account: Authentication using a Google account.
        :param 'IapCredentialResponseArgs' iap_credential: Authentication using Identity-Aware-Proxy (IAP).
        """
        pulumi.set(__self__, "custom_account", custom_account)
        pulumi.set(__self__, "google_account", google_account)
        pulumi.set(__self__, "iap_credential", iap_credential)

    @property
    @pulumi.getter(name="customAccount")
    def custom_account(self) -> 'outputs.CustomAccountResponse':
        """
        Authentication using a custom account.
        """
        return pulumi.get(self, "custom_account")

    @property
    @pulumi.getter(name="googleAccount")
    def google_account(self) -> 'outputs.GoogleAccountResponse':
        """
        Authentication using a Google account.
        """
        return pulumi.get(self, "google_account")

    @property
    @pulumi.getter(name="iapCredential")
    def iap_credential(self) -> 'outputs.IapCredentialResponse':
        """
        Authentication using Identity-Aware-Proxy (IAP).
        """
        return pulumi.get(self, "iap_credential")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CustomAccountResponse(dict):
    """
    Describes authentication configuration that uses a custom account.
    """
    def __init__(__self__, *,
                 login_url: str,
                 password: str,
                 username: str):
        """
        Describes authentication configuration that uses a custom account.
        :param str login_url: Required. The login form URL of the website.
        :param str password: Required. Input only. The password of the custom account. The credential is stored encrypted and not returned in any response nor included in audit logs.
        :param str username: Required. The user name of the custom account.
        """
        pulumi.set(__self__, "login_url", login_url)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> str:
        """
        Required. The login form URL of the website.
        """
        return pulumi.get(self, "login_url")

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Required. Input only. The password of the custom account. The credential is stored encrypted and not returned in any response nor included in audit logs.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Required. The user name of the custom account.
        """
        return pulumi.get(self, "username")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GoogleAccountResponse(dict):
    """
    Describes authentication configuration that uses a Google account.
    """
    def __init__(__self__, *,
                 password: str,
                 username: str):
        """
        Describes authentication configuration that uses a Google account.
        :param str password: Required. Input only. The password of the Google account. The credential is stored encrypted and not returned in any response nor included in audit logs.
        :param str username: Required. The user name of the Google account.
        """
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> str:
        """
        Required. Input only. The password of the Google account. The credential is stored encrypted and not returned in any response nor included in audit logs.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def username(self) -> str:
        """
        Required. The user name of the Google account.
        """
        return pulumi.get(self, "username")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IapCredentialResponse(dict):
    """
    Describes authentication configuration for Identity-Aware-Proxy (IAP).
    """
    def __init__(__self__, *,
                 iap_test_service_account_info: 'outputs.IapTestServiceAccountInfoResponse'):
        """
        Describes authentication configuration for Identity-Aware-Proxy (IAP).
        :param 'IapTestServiceAccountInfoResponseArgs' iap_test_service_account_info: Authentication configuration when Web-Security-Scanner service account is added in Identity-Aware-Proxy (IAP) access policies.
        """
        pulumi.set(__self__, "iap_test_service_account_info", iap_test_service_account_info)

    @property
    @pulumi.getter(name="iapTestServiceAccountInfo")
    def iap_test_service_account_info(self) -> 'outputs.IapTestServiceAccountInfoResponse':
        """
        Authentication configuration when Web-Security-Scanner service account is added in Identity-Aware-Proxy (IAP) access policies.
        """
        return pulumi.get(self, "iap_test_service_account_info")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IapTestServiceAccountInfoResponse(dict):
    """
    Describes authentication configuration when Web-Security-Scanner service account is added in Identity-Aware-Proxy (IAP) access policies.
    """
    def __init__(__self__, *,
                 target_audience_client_id: str):
        """
        Describes authentication configuration when Web-Security-Scanner service account is added in Identity-Aware-Proxy (IAP) access policies.
        :param str target_audience_client_id: Required. Describes OAuth2 client id of resources protected by Identity-Aware-Proxy (IAP).
        """
        pulumi.set(__self__, "target_audience_client_id", target_audience_client_id)

    @property
    @pulumi.getter(name="targetAudienceClientId")
    def target_audience_client_id(self) -> str:
        """
        Required. Describes OAuth2 client id of resources protected by Identity-Aware-Proxy (IAP).
        """
        return pulumi.get(self, "target_audience_client_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ScheduleResponse(dict):
    """
    Scan schedule configuration.
    """
    def __init__(__self__, *,
                 interval_duration_days: int,
                 schedule_time: str):
        """
        Scan schedule configuration.
        :param int interval_duration_days: Required. The duration of time between executions in days.
        :param str schedule_time: A timestamp indicates when the next run will be scheduled. The value is refreshed by the server after each run. If unspecified, it will default to current server time, which means the scan will be scheduled to start immediately.
        """
        pulumi.set(__self__, "interval_duration_days", interval_duration_days)
        pulumi.set(__self__, "schedule_time", schedule_time)

    @property
    @pulumi.getter(name="intervalDurationDays")
    def interval_duration_days(self) -> int:
        """
        Required. The duration of time between executions in days.
        """
        return pulumi.get(self, "interval_duration_days")

    @property
    @pulumi.getter(name="scheduleTime")
    def schedule_time(self) -> str:
        """
        A timestamp indicates when the next run will be scheduled. The value is refreshed by the server after each run. If unspecified, it will default to current server time, which means the scan will be scheduled to start immediately.
        """
        return pulumi.get(self, "schedule_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


