# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'AuthenticationArgs',
    'CustomAccountArgs',
    'GoogleAccountArgs',
    'IapCredentialArgs',
    'IapTestServiceAccountInfoArgs',
    'ScheduleArgs',
]

@pulumi.input_type
class AuthenticationArgs:
    def __init__(__self__, *,
                 custom_account: Optional[pulumi.Input['CustomAccountArgs']] = None,
                 google_account: Optional[pulumi.Input['GoogleAccountArgs']] = None,
                 iap_credential: Optional[pulumi.Input['IapCredentialArgs']] = None):
        """
        Scan authentication configuration.
        :param pulumi.Input['CustomAccountArgs'] custom_account: Authentication using a custom account.
        :param pulumi.Input['GoogleAccountArgs'] google_account: Authentication using a Google account.
        :param pulumi.Input['IapCredentialArgs'] iap_credential: Authentication using Identity-Aware-Proxy (IAP).
        """
        if custom_account is not None:
            pulumi.set(__self__, "custom_account", custom_account)
        if google_account is not None:
            pulumi.set(__self__, "google_account", google_account)
        if iap_credential is not None:
            pulumi.set(__self__, "iap_credential", iap_credential)

    @property
    @pulumi.getter(name="customAccount")
    def custom_account(self) -> Optional[pulumi.Input['CustomAccountArgs']]:
        """
        Authentication using a custom account.
        """
        return pulumi.get(self, "custom_account")

    @custom_account.setter
    def custom_account(self, value: Optional[pulumi.Input['CustomAccountArgs']]):
        pulumi.set(self, "custom_account", value)

    @property
    @pulumi.getter(name="googleAccount")
    def google_account(self) -> Optional[pulumi.Input['GoogleAccountArgs']]:
        """
        Authentication using a Google account.
        """
        return pulumi.get(self, "google_account")

    @google_account.setter
    def google_account(self, value: Optional[pulumi.Input['GoogleAccountArgs']]):
        pulumi.set(self, "google_account", value)

    @property
    @pulumi.getter(name="iapCredential")
    def iap_credential(self) -> Optional[pulumi.Input['IapCredentialArgs']]:
        """
        Authentication using Identity-Aware-Proxy (IAP).
        """
        return pulumi.get(self, "iap_credential")

    @iap_credential.setter
    def iap_credential(self, value: Optional[pulumi.Input['IapCredentialArgs']]):
        pulumi.set(self, "iap_credential", value)


@pulumi.input_type
class CustomAccountArgs:
    def __init__(__self__, *,
                 login_url: Optional[pulumi.Input[str]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Describes authentication configuration that uses a custom account.
        :param pulumi.Input[str] login_url: Required. The login form URL of the website.
        :param pulumi.Input[str] password: Required. Input only. The password of the custom account. The credential is stored encrypted and not returned in any response nor included in audit logs.
        :param pulumi.Input[str] username: Required. The user name of the custom account.
        """
        if login_url is not None:
            pulumi.set(__self__, "login_url", login_url)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter(name="loginUrl")
    def login_url(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The login form URL of the website.
        """
        return pulumi.get(self, "login_url")

    @login_url.setter
    def login_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "login_url", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Input only. The password of the custom account. The credential is stored encrypted and not returned in any response nor included in audit logs.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The user name of the custom account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class GoogleAccountArgs:
    def __init__(__self__, *,
                 password: Optional[pulumi.Input[str]] = None,
                 username: Optional[pulumi.Input[str]] = None):
        """
        Describes authentication configuration that uses a Google account.
        :param pulumi.Input[str] password: Required. Input only. The password of the Google account. The credential is stored encrypted and not returned in any response nor included in audit logs.
        :param pulumi.Input[str] username: Required. The user name of the Google account.
        """
        if password is not None:
            pulumi.set(__self__, "password", password)
        if username is not None:
            pulumi.set(__self__, "username", username)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Input only. The password of the Google account. The credential is stored encrypted and not returned in any response nor included in audit logs.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def username(self) -> Optional[pulumi.Input[str]]:
        """
        Required. The user name of the Google account.
        """
        return pulumi.get(self, "username")

    @username.setter
    def username(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "username", value)


@pulumi.input_type
class IapCredentialArgs:
    def __init__(__self__, *,
                 iap_test_service_account_info: Optional[pulumi.Input['IapTestServiceAccountInfoArgs']] = None):
        """
        Describes authentication configuration for Identity-Aware-Proxy (IAP).
        :param pulumi.Input['IapTestServiceAccountInfoArgs'] iap_test_service_account_info: Authentication configuration when Web-Security-Scanner service account is added in Identity-Aware-Proxy (IAP) access policies.
        """
        if iap_test_service_account_info is not None:
            pulumi.set(__self__, "iap_test_service_account_info", iap_test_service_account_info)

    @property
    @pulumi.getter(name="iapTestServiceAccountInfo")
    def iap_test_service_account_info(self) -> Optional[pulumi.Input['IapTestServiceAccountInfoArgs']]:
        """
        Authentication configuration when Web-Security-Scanner service account is added in Identity-Aware-Proxy (IAP) access policies.
        """
        return pulumi.get(self, "iap_test_service_account_info")

    @iap_test_service_account_info.setter
    def iap_test_service_account_info(self, value: Optional[pulumi.Input['IapTestServiceAccountInfoArgs']]):
        pulumi.set(self, "iap_test_service_account_info", value)


@pulumi.input_type
class IapTestServiceAccountInfoArgs:
    def __init__(__self__, *,
                 target_audience_client_id: Optional[pulumi.Input[str]] = None):
        """
        Describes authentication configuration when Web-Security-Scanner service account is added in Identity-Aware-Proxy (IAP) access policies.
        :param pulumi.Input[str] target_audience_client_id: Required. Describes OAuth2 client id of resources protected by Identity-Aware-Proxy (IAP).
        """
        if target_audience_client_id is not None:
            pulumi.set(__self__, "target_audience_client_id", target_audience_client_id)

    @property
    @pulumi.getter(name="targetAudienceClientId")
    def target_audience_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Describes OAuth2 client id of resources protected by Identity-Aware-Proxy (IAP).
        """
        return pulumi.get(self, "target_audience_client_id")

    @target_audience_client_id.setter
    def target_audience_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_audience_client_id", value)


@pulumi.input_type
class ScheduleArgs:
    def __init__(__self__, *,
                 interval_duration_days: Optional[pulumi.Input[int]] = None,
                 schedule_time: Optional[pulumi.Input[str]] = None):
        """
        Scan schedule configuration.
        :param pulumi.Input[int] interval_duration_days: Required. The duration of time between executions in days.
        :param pulumi.Input[str] schedule_time: A timestamp indicates when the next run will be scheduled. The value is refreshed by the server after each run. If unspecified, it will default to current server time, which means the scan will be scheduled to start immediately.
        """
        if interval_duration_days is not None:
            pulumi.set(__self__, "interval_duration_days", interval_duration_days)
        if schedule_time is not None:
            pulumi.set(__self__, "schedule_time", schedule_time)

    @property
    @pulumi.getter(name="intervalDurationDays")
    def interval_duration_days(self) -> Optional[pulumi.Input[int]]:
        """
        Required. The duration of time between executions in days.
        """
        return pulumi.get(self, "interval_duration_days")

    @interval_duration_days.setter
    def interval_duration_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "interval_duration_days", value)

    @property
    @pulumi.getter(name="scheduleTime")
    def schedule_time(self) -> Optional[pulumi.Input[str]]:
        """
        A timestamp indicates when the next run will be scheduled. The value is refreshed by the server after each run. If unspecified, it will default to current server time, which means the scan will be scheduled to start immediately.
        """
        return pulumi.get(self, "schedule_time")

    @schedule_time.setter
    def schedule_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "schedule_time", value)


