# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from ._inputs import *

__all__ = ['HistoryExecutionStepPerfMetricsSummary']


class HistoryExecutionStepPerfMetricsSummary(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 app_start_time: Optional[pulumi.Input[pulumi.InputType['AppStartTimeArgs']]] = None,
                 execution_id: Optional[pulumi.Input[str]] = None,
                 graphics_stats: Optional[pulumi.Input[pulumi.InputType['GraphicsStatsArgs']]] = None,
                 history_id: Optional[pulumi.Input[str]] = None,
                 perf_environment: Optional[pulumi.Input[pulumi.InputType['PerfEnvironmentArgs']]] = None,
                 perf_metrics: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 step_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a PerfMetricsSummary resource. Returns the existing one if it has already been created. May return any of the following error code(s): - NOT_FOUND - The containing Step does not exist

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] execution_id: A tool results execution ID. @OutputOnly
        :param pulumi.Input[pulumi.InputType['GraphicsStatsArgs']] graphics_stats: Graphics statistics for the entire run. Statistics are reset at the beginning of the run and collected at the end of the run.
        :param pulumi.Input[str] history_id: A tool results history ID. @OutputOnly
        :param pulumi.Input[pulumi.InputType['PerfEnvironmentArgs']] perf_environment: Describes the environment in which the performance metrics were collected
        :param pulumi.Input[Sequence[pulumi.Input[str]]] perf_metrics: Set of resource collected
        :param pulumi.Input[str] project_id: The cloud project @OutputOnly
        :param pulumi.Input[str] step_id: A tool results step ID. @OutputOnly
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['app_start_time'] = app_start_time
            if execution_id is None and not opts.urn:
                raise TypeError("Missing required property 'execution_id'")
            __props__['execution_id'] = execution_id
            __props__['graphics_stats'] = graphics_stats
            if history_id is None and not opts.urn:
                raise TypeError("Missing required property 'history_id'")
            __props__['history_id'] = history_id
            __props__['perf_environment'] = perf_environment
            __props__['perf_metrics'] = perf_metrics
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            if step_id is None and not opts.urn:
                raise TypeError("Missing required property 'step_id'")
            __props__['step_id'] = step_id
        super(HistoryExecutionStepPerfMetricsSummary, __self__).__init__(
            'gcp-native:toolresults/v1beta3:HistoryExecutionStepPerfMetricsSummary',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'HistoryExecutionStepPerfMetricsSummary':
        """
        Get an existing HistoryExecutionStepPerfMetricsSummary resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        return HistoryExecutionStepPerfMetricsSummary(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

