# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = ['ServiceConsumerQuotaMetricLimitProducerOverride']


class ServiceConsumerQuotaMetricLimitProducerOverride(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 admin_override_ancestor: Optional[pulumi.Input[str]] = None,
                 consumer_quota_metrics_id: Optional[pulumi.Input[str]] = None,
                 dimensions: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 limits_id: Optional[pulumi.Input[str]] = None,
                 metric: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 override_value: Optional[pulumi.Input[str]] = None,
                 producer_overrides_id: Optional[pulumi.Input[str]] = None,
                 services_id: Optional[pulumi.Input[str]] = None,
                 services_id1: Optional[pulumi.Input[str]] = None,
                 services_id2: Optional[pulumi.Input[str]] = None,
                 unit: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a producer override. A producer override is applied by the owner or administrator of a service to increase or decrease the amount of quota a consumer of the service is allowed to use. To create multiple overrides at once, use ImportProducerOverrides instead. If an override with the specified dimensions already exists, this call will fail. To overwrite an existing override if one is already present ("upsert" semantics), use ImportProducerOverrides instead.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] admin_override_ancestor: The resource name of the ancestor that requested the override. For example: "organizations/12345" or "folders/67890". Used by admin overrides only.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] dimensions:  If this map is nonempty, then this override applies only to specific values for dimensions defined in the limit unit. For example, an override on a limit with the unit 1/{project}/{region} could contain an entry with the key "region" and the value "us-east-1"; the override is only applied to quota consumed in that region. This map has the following restrictions: * Keys that are not defined in the limit's unit are not valid keys. Any string appearing in {brackets} in the unit (besides {project} or {user}) is a defined key. * "project" is not a valid key; the project is already specified in the parent resource name. * "user" is not a valid key; the API does not support quota overrides that apply only to a specific user. * If "region" appears as a key, its value must be a valid Cloud region. * If "zone" appears as a key, its value must be a valid Cloud zone. * If any valid key other than "region" or "zone" appears in the map, then all valid keys other than "region" or "zone" must also appear in the map.
        :param pulumi.Input[str] metric: The name of the metric to which this override applies. An example name would be: `compute.googleapis.com/cpus`
        :param pulumi.Input[str] name: The resource name of the producer override. An example name would be: `services/compute.googleapis.com/projects/123/consumerQuotaMetrics/compute.googleapis.com%2Fcpus/limits/%2Fproject%2Fregion/producerOverrides/4a3f2c1d`
        :param pulumi.Input[str] override_value: The overriding quota limit value. Can be any nonnegative integer, or -1 (unlimited quota).
        :param pulumi.Input[str] unit: The limit unit of the limit to which this override applies. An example unit would be: `1/{project}/{region}` Note that `{project}` and `{region}` are not placeholders in this example; the literal characters `{` and `}` occur in the string.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['admin_override_ancestor'] = admin_override_ancestor
            if consumer_quota_metrics_id is None and not opts.urn:
                raise TypeError("Missing required property 'consumer_quota_metrics_id'")
            __props__['consumer_quota_metrics_id'] = consumer_quota_metrics_id
            __props__['dimensions'] = dimensions
            if limits_id is None and not opts.urn:
                raise TypeError("Missing required property 'limits_id'")
            __props__['limits_id'] = limits_id
            __props__['metric'] = metric
            __props__['name'] = name
            __props__['override_value'] = override_value
            if producer_overrides_id is None and not opts.urn:
                raise TypeError("Missing required property 'producer_overrides_id'")
            __props__['producer_overrides_id'] = producer_overrides_id
            if services_id is None and not opts.urn:
                raise TypeError("Missing required property 'services_id'")
            __props__['services_id'] = services_id
            if services_id1 is None and not opts.urn:
                raise TypeError("Missing required property 'services_id1'")
            __props__['services_id1'] = services_id1
            if services_id2 is None and not opts.urn:
                raise TypeError("Missing required property 'services_id2'")
            __props__['services_id2'] = services_id2
            __props__['unit'] = unit
        super(ServiceConsumerQuotaMetricLimitProducerOverride, __self__).__init__(
            'gcp-native:serviceconsumermanagement/v1beta1:ServiceConsumerQuotaMetricLimitProducerOverride',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'ServiceConsumerQuotaMetricLimitProducerOverride':
        """
        Get an existing ServiceConsumerQuotaMetricLimitProducerOverride resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        return ServiceConsumerQuotaMetricLimitProducerOverride(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

