# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'AddressableResponse',
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'CapabilitiesResponse',
    'ConfigMapEnvSourceResponse',
    'ConfigMapKeySelectorResponse',
    'ConfigMapVolumeSourceResponse',
    'ConfigurationSpecResponse',
    'ContainerPortResponse',
    'ContainerResponse',
    'DomainMappingConditionResponse',
    'DomainMappingSpecResponse',
    'DomainMappingStatusResponse',
    'EnvFromSourceResponse',
    'EnvVarResponse',
    'EnvVarSourceResponse',
    'ExecActionResponse',
    'ExprResponse',
    'HTTPGetActionResponse',
    'HTTPHeaderResponse',
    'HandlerResponse',
    'InstanceSpecResponse',
    'InstanceStatusResponse',
    'InstanceTemplateSpecResponse',
    'IntOrStringResponse',
    'JobConditionResponse',
    'JobSpecResponse',
    'JobStatusResponse',
    'KeyToPathResponse',
    'LifecycleResponse',
    'LocalObjectReferenceResponse',
    'ObjectMetaResponse',
    'OwnerReferenceResponse',
    'ProbeResponse',
    'ResourceRecordResponse',
    'ResourceRequirementsResponse',
    'RevisionSpecResponse',
    'RevisionTemplateResponse',
    'SELinuxOptionsResponse',
    'SecretEnvSourceResponse',
    'SecretKeySelectorResponse',
    'SecretVolumeSourceResponse',
    'SecurityContextResponse',
    'ServiceConditionResponse',
    'ServiceSpecManualTypeResponse',
    'ServiceSpecPinnedTypeResponse',
    'ServiceSpecReleaseTypeResponse',
    'ServiceSpecResponse',
    'ServiceSpecRunLatestResponse',
    'ServiceStatusResponse',
    'TCPSocketActionResponse',
    'TrafficTargetResponse',
    'VolumeDeviceResponse',
    'VolumeMountResponse',
    'VolumeResponse',
]

@pulumi.output_type
class AddressableResponse(dict):
    """
    Information for connecting over HTTP(s).
    """
    def __init__(__self__, *,
                 hostname: str,
                 url: str):
        """
        Information for connecting over HTTP(s).
        :param str hostname: Deprecated - use url instead.
        """
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def hostname(self) -> str:
        """
        Deprecated - use url instead.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter
    def url(self) -> str:
        return pulumi.get(self, "url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponseArgs'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members` with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members` with a `role`.
        :param 'ExprResponseArgs' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to `members`. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class CapabilitiesResponse(dict):
    """
    Adds and removes POSIX capabilities from running containers.
    """
    def __init__(__self__, *,
                 add: Sequence[str],
                 drop: Sequence[str]):
        """
        Adds and removes POSIX capabilities from running containers.
        :param Sequence[str] add: Added capabilities +optional
        :param Sequence[str] drop: Removed capabilities +optional
        """
        pulumi.set(__self__, "add", add)
        pulumi.set(__self__, "drop", drop)

    @property
    @pulumi.getter
    def add(self) -> Sequence[str]:
        """
        Added capabilities +optional
        """
        return pulumi.get(self, "add")

    @property
    @pulumi.getter
    def drop(self) -> Sequence[str]:
        """
        Removed capabilities +optional
        """
        return pulumi.get(self, "drop")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConfigMapEnvSourceResponse(dict):
    """
    ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
    """
    def __init__(__self__, *,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        ConfigMapEnvSource selects a ConfigMap to populate the environment variables with. The contents of the target ConfigMap's Data field will represent the key-value pairs as environment variables.
        :param 'LocalObjectReferenceResponseArgs' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: Cloud Run fully managed: not supported Cloud Run for Anthos: supported The ConfigMap to select from.
        :param bool optional: Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the ConfigMap must be defined +optional
        """
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the ConfigMap must be defined +optional
        """
        return pulumi.get(self, "optional")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConfigMapKeySelectorResponse(dict):
    """
    Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key from a ConfigMap.
    """
    def __init__(__self__, *,
                 key: str,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key from a ConfigMap.
        :param str key: Cloud Run fully managed: not supported Cloud Run on GKE: supported The key to select.
        :param 'LocalObjectReferenceResponseArgs' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: Cloud Run fully managed: not supported Cloud Run on GKE: supported The ConfigMap to select from.
        :param bool optional: Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the ConfigMap or its key must be defined +optional
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The key to select.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The ConfigMap to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the ConfigMap or its key must be defined +optional
        """
        return pulumi.get(self, "optional")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConfigMapVolumeSourceResponse(dict):
    """
    Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
    """
    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.KeyToPathResponse'],
                 name: str,
                 optional: bool):
        """
        Adapts a ConfigMap into a volume. The contents of the target ConfigMap's Data field will be presented in a volume as files using the keys in the Data field as the file names, unless the items element is populated with specific mappings of keys to paths.
        :param int default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathResponseArgs'] items: If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        :param str name: Name of the config.
        :param bool optional: Specify whether the Secret or its keys must be defined.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.KeyToPathResponse']:
        """
        If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the config.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ConfigurationSpecResponse(dict):
    """
    ConfigurationSpec holds the desired state of the Configuration (from the client).
    """
    def __init__(__self__, *,
                 generation: int,
                 revision_template: 'outputs.RevisionTemplateResponse',
                 template: 'outputs.RevisionTemplateResponse'):
        """
        ConfigurationSpec holds the desired state of the Configuration (from the client).
        :param int generation: Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        :param 'RevisionTemplateResponseArgs' revision_template: RevisionTemplate holds the latest specification for the Revision to be stamped out. The template references the container image, and may also include labels and annotations that should be attached to the Revision. To correlate a Revision, and/or to force a Revision to be created when the spec doesn't otherwise change, a nonce label may be provided in the template metadata. For more details, see: https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions Cloud Run does not currently support referencing a build that is responsible for materializing the container image from source.
        :param 'RevisionTemplateResponseArgs' template: Template holds the latest specification for the Revision to be stamped out.
        """
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "revision_template", revision_template)
        pulumi.set(__self__, "template", template)

    @property
    @pulumi.getter
    def generation(self) -> int:
        """
        Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter(name="revisionTemplate")
    def revision_template(self) -> 'outputs.RevisionTemplateResponse':
        """
        RevisionTemplate holds the latest specification for the Revision to be stamped out. The template references the container image, and may also include labels and annotations that should be attached to the Revision. To correlate a Revision, and/or to force a Revision to be created when the spec doesn't otherwise change, a nonce label may be provided in the template metadata. For more details, see: https://github.com/knative/serving/blob/master/docs/client-conventions.md#associate-modifications-with-revisions Cloud Run does not currently support referencing a build that is responsible for materializing the container image from source.
        """
        return pulumi.get(self, "revision_template")

    @property
    @pulumi.getter
    def template(self) -> 'outputs.RevisionTemplateResponse':
        """
        Template holds the latest specification for the Revision to be stamped out.
        """
        return pulumi.get(self, "template")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ContainerPortResponse(dict):
    """
    ContainerPort represents a network port in a single container.
    """
    def __init__(__self__, *,
                 container_port: int,
                 host_ip: str,
                 host_port: int,
                 name: str,
                 protocol: str):
        """
        ContainerPort represents a network port in a single container.
        :param int container_port: Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        :param str host_ip: What host IP to bind the external port to. +optional
        :param int host_port: Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this. +optional
        :param str name: If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. +optional
        :param str protocol: Protocol for port. Must be UDP or TCP. Defaults to "TCP". +optional
        """
        pulumi.set(__self__, "container_port", container_port)
        pulumi.set(__self__, "host_ip", host_ip)
        pulumi.set(__self__, "host_port", host_port)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "protocol", protocol)

    @property
    @pulumi.getter(name="containerPort")
    def container_port(self) -> int:
        """
        Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
        """
        return pulumi.get(self, "container_port")

    @property
    @pulumi.getter(name="hostIP")
    def host_ip(self) -> str:
        """
        What host IP to bind the external port to. +optional
        """
        return pulumi.get(self, "host_ip")

    @property
    @pulumi.getter(name="hostPort")
    def host_port(self) -> int:
        """
        Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this. +optional
        """
        return pulumi.get(self, "host_port")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services. +optional
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def protocol(self) -> str:
        """
        Protocol for port. Must be UDP or TCP. Defaults to "TCP". +optional
        """
        return pulumi.get(self, "protocol")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ContainerResponse(dict):
    """
    A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
    """
    def __init__(__self__, *,
                 args: Sequence[str],
                 command: Sequence[str],
                 env: Sequence['outputs.EnvVarResponse'],
                 env_from: Sequence['outputs.EnvFromSourceResponse'],
                 image: str,
                 image_pull_policy: str,
                 lifecycle: 'outputs.LifecycleResponse',
                 liveness_probe: 'outputs.ProbeResponse',
                 name: str,
                 ports: Sequence['outputs.ContainerPortResponse'],
                 readiness_probe: 'outputs.ProbeResponse',
                 resources: 'outputs.ResourceRequirementsResponse',
                 security_context: 'outputs.SecurityContextResponse',
                 stdin: bool,
                 stdin_once: bool,
                 termination_message_path: str,
                 termination_message_policy: str,
                 tty: bool,
                 volume_devices: Sequence['outputs.VolumeDeviceResponse'],
                 volume_mounts: Sequence['outputs.VolumeMountResponse'],
                 working_dir: str):
        """
        A single application container. This specifies both the container to run, the command to run in the container and the arguments to supply to it. Note that additional arguments may be supplied by the system to the container at runtime.
        :param Sequence[str] args: Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        :param Sequence[str] command: Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        :param Sequence['EnvVarResponseArgs'] env: List of environment variables to set in the container. Cannot be updated. +optional
        :param Sequence['EnvFromSourceResponseArgs'] env_from: List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated. +optional
        :param str image: Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
        :param str image_pull_policy: Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images +optional
        :param 'LifecycleResponseArgs' lifecycle: Actions that the management system should take in response to container lifecycle events. Cannot be updated. +optional
        :param 'ProbeResponseArgs' liveness_probe: Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param str name: Name of the container specified as a DNS_LABEL. Each container must have a unique name (DNS_LABEL). Cannot be updated.
        :param Sequence['ContainerPortResponseArgs'] ports: List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated. +optional
        :param 'ProbeResponseArgs' readiness_probe: Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param 'ResourceRequirementsResponseArgs' resources: Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources +optional
        :param 'SecurityContextResponseArgs' security_context: Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/ +optional
        :param bool stdin: Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. +optional
        :param bool stdin_once: Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false +optional
        :param str termination_message_path: Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. +optional
        :param str termination_message_policy: Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. +optional
        :param bool tty: Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. +optional
        :param Sequence['VolumeDeviceResponseArgs'] volume_devices: volumeDevices is the list of block devices to be used by the container. This is an alpha feature and may change in the future. +optional
        :param Sequence['VolumeMountResponseArgs'] volume_mounts: Pod volumes to mount into the container's filesystem. Cannot be updated. +optional
        :param str working_dir: Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. +optional
        """
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "command", command)
        pulumi.set(__self__, "env", env)
        pulumi.set(__self__, "env_from", env_from)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "image_pull_policy", image_pull_policy)
        pulumi.set(__self__, "lifecycle", lifecycle)
        pulumi.set(__self__, "liveness_probe", liveness_probe)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "ports", ports)
        pulumi.set(__self__, "readiness_probe", readiness_probe)
        pulumi.set(__self__, "resources", resources)
        pulumi.set(__self__, "security_context", security_context)
        pulumi.set(__self__, "stdin", stdin)
        pulumi.set(__self__, "stdin_once", stdin_once)
        pulumi.set(__self__, "termination_message_path", termination_message_path)
        pulumi.set(__self__, "termination_message_policy", termination_message_policy)
        pulumi.set(__self__, "tty", tty)
        pulumi.set(__self__, "volume_devices", volume_devices)
        pulumi.set(__self__, "volume_mounts", volume_mounts)
        pulumi.set(__self__, "working_dir", working_dir)

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Cannot be updated. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell +optional
        """
        return pulumi.get(self, "command")

    @property
    @pulumi.getter
    def env(self) -> Sequence['outputs.EnvVarResponse']:
        """
        List of environment variables to set in the container. Cannot be updated. +optional
        """
        return pulumi.get(self, "env")

    @property
    @pulumi.getter(name="envFrom")
    def env_from(self) -> Sequence['outputs.EnvFromSourceResponse']:
        """
        List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence. Cannot be updated. +optional
        """
        return pulumi.get(self, "env_from")

    @property
    @pulumi.getter
    def image(self) -> str:
        """
        Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="imagePullPolicy")
    def image_pull_policy(self) -> str:
        """
        Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always if :latest tag is specified, or IfNotPresent otherwise. Cannot be updated. More info: https://kubernetes.io/docs/concepts/containers/images#updating-images +optional
        """
        return pulumi.get(self, "image_pull_policy")

    @property
    @pulumi.getter
    def lifecycle(self) -> 'outputs.LifecycleResponse':
        """
        Actions that the management system should take in response to container lifecycle events. Cannot be updated. +optional
        """
        return pulumi.get(self, "lifecycle")

    @property
    @pulumi.getter(name="livenessProbe")
    def liveness_probe(self) -> 'outputs.ProbeResponse':
        """
        Periodic probe of container liveness. Container will be restarted if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "liveness_probe")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the container specified as a DNS_LABEL. Each container must have a unique name (DNS_LABEL). Cannot be updated.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def ports(self) -> Sequence['outputs.ContainerPortResponse']:
        """
        List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network. Cannot be updated. +optional
        """
        return pulumi.get(self, "ports")

    @property
    @pulumi.getter(name="readinessProbe")
    def readiness_probe(self) -> 'outputs.ProbeResponse':
        """
        Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails. Cannot be updated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "readiness_probe")

    @property
    @pulumi.getter
    def resources(self) -> 'outputs.ResourceRequirementsResponse':
        """
        Compute Resources required by this container. Cannot be updated. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources +optional
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> 'outputs.SecurityContextResponse':
        """
        Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/ +optional
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter
    def stdin(self) -> bool:
        """
        Whether this container should allocate a buffer for stdin in the container runtime. If this is not set, reads from stdin in the container will always result in EOF. Default is false. +optional
        """
        return pulumi.get(self, "stdin")

    @property
    @pulumi.getter(name="stdinOnce")
    def stdin_once(self) -> bool:
        """
        Whether the container runtime should close the stdin channel after it has been opened by a single attach. When stdin is true the stdin stream will remain open across multiple attach sessions. If stdinOnce is set to true, stdin is opened on container start, is empty until the first client attaches to stdin, and then remains open and accepts data until the client disconnects, at which time stdin is closed and remains closed until the container is restarted. If this flag is false, a container processes that reads from stdin will never receive an EOF. Default is false +optional
        """
        return pulumi.get(self, "stdin_once")

    @property
    @pulumi.getter(name="terminationMessagePath")
    def termination_message_path(self) -> str:
        """
        Optional: Path at which the file to which the container's termination message will be written is mounted into the container's filesystem. Message written is intended to be brief final status, such as an assertion failure message. Will be truncated by the node if greater than 4096 bytes. The total message length across all containers will be limited to 12kb. Defaults to /dev/termination-log. Cannot be updated. +optional
        """
        return pulumi.get(self, "termination_message_path")

    @property
    @pulumi.getter(name="terminationMessagePolicy")
    def termination_message_policy(self) -> str:
        """
        Indicate how the termination message should be populated. File will use the contents of terminationMessagePath to populate the container status message on both success and failure. FallbackToLogsOnError will use the last chunk of container log output if the termination message file is empty and the container exited with an error. The log output is limited to 2048 bytes or 80 lines, whichever is smaller. Defaults to File. Cannot be updated. +optional
        """
        return pulumi.get(self, "termination_message_policy")

    @property
    @pulumi.getter
    def tty(self) -> bool:
        """
        Whether this container should allocate a TTY for itself, also requires 'stdin' to be true. Default is false. +optional
        """
        return pulumi.get(self, "tty")

    @property
    @pulumi.getter(name="volumeDevices")
    def volume_devices(self) -> Sequence['outputs.VolumeDeviceResponse']:
        """
        volumeDevices is the list of block devices to be used by the container. This is an alpha feature and may change in the future. +optional
        """
        return pulumi.get(self, "volume_devices")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Sequence['outputs.VolumeMountResponse']:
        """
        Pod volumes to mount into the container's filesystem. Cannot be updated. +optional
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDir")
    def working_dir(self) -> str:
        """
        Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image. Cannot be updated. +optional
        """
        return pulumi.get(self, "working_dir")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainMappingConditionResponse(dict):
    """
    DomainMappingCondition contains state information for a DomainMapping.
    """
    def __init__(__self__, *,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 severity: str,
                 status: str,
                 type: str):
        """
        DomainMappingCondition contains state information for a DomainMapping.
        :param str last_transition_time: Last time the condition transitioned from one status to another. +optional
        :param str message: Human readable message indicating details about the current status. +optional
        :param str reason: One-word CamelCase reason for the condition's current status. +optional
        :param str severity: How to interpret failures of this condition, one of Error, Warning, Info +optional
        :param str status: Status of the condition, one of True, False, Unknown.
        :param str type: Type of domain mapping condition.
        """
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Last time the condition transitioned from one status to another. +optional
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human readable message indicating details about the current status. +optional
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        One-word CamelCase reason for the condition's current status. +optional
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info +optional
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of domain mapping condition.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainMappingSpecResponse(dict):
    """
    The desired state of the Domain Mapping.
    """
    def __init__(__self__, *,
                 certificate_mode: str,
                 force_override: bool,
                 route_name: str):
        """
        The desired state of the Domain Mapping.
        :param str certificate_mode: The mode of the certificate.
        :param bool force_override: If set, the mapping will override any mapping set before this spec was set. It is recommended that the user leaves this empty to receive an error warning about a potential conflict and only set it once the respective UI has given such a warning.
        :param str route_name: The name of the Knative Route that this DomainMapping applies to. The route must exist.
        """
        pulumi.set(__self__, "certificate_mode", certificate_mode)
        pulumi.set(__self__, "force_override", force_override)
        pulumi.set(__self__, "route_name", route_name)

    @property
    @pulumi.getter(name="certificateMode")
    def certificate_mode(self) -> str:
        """
        The mode of the certificate.
        """
        return pulumi.get(self, "certificate_mode")

    @property
    @pulumi.getter(name="forceOverride")
    def force_override(self) -> bool:
        """
        If set, the mapping will override any mapping set before this spec was set. It is recommended that the user leaves this empty to receive an error warning about a potential conflict and only set it once the respective UI has given such a warning.
        """
        return pulumi.get(self, "force_override")

    @property
    @pulumi.getter(name="routeName")
    def route_name(self) -> str:
        """
        The name of the Knative Route that this DomainMapping applies to. The route must exist.
        """
        return pulumi.get(self, "route_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DomainMappingStatusResponse(dict):
    """
    The current state of the Domain Mapping.
    """
    def __init__(__self__, *,
                 conditions: Sequence['outputs.DomainMappingConditionResponse'],
                 mapped_route_name: str,
                 observed_generation: int,
                 resource_records: Sequence['outputs.ResourceRecordResponse'],
                 url: str):
        """
        The current state of the Domain Mapping.
        :param Sequence['DomainMappingConditionResponseArgs'] conditions: Array of observed DomainMappingConditions, indicating the current state of the DomainMapping.
        :param str mapped_route_name: The name of the route that the mapping currently points to.
        :param int observed_generation: ObservedGeneration is the 'Generation' of the DomainMapping that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        :param Sequence['ResourceRecordResponseArgs'] resource_records: The resource records required to configure this domain mapping. These records must be added to the domain's DNS configuration in order to serve the application via this domain mapping.
        :param str url: Cloud Run fully managed: not supported Cloud Run on GKE: supported Holds the URL that will serve the traffic of the DomainMapping. +optional
        """
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "mapped_route_name", mapped_route_name)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "resource_records", resource_records)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.DomainMappingConditionResponse']:
        """
        Array of observed DomainMappingConditions, indicating the current state of the DomainMapping.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter(name="mappedRouteName")
    def mapped_route_name(self) -> str:
        """
        The name of the route that the mapping currently points to.
        """
        return pulumi.get(self, "mapped_route_name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        """
        ObservedGeneration is the 'Generation' of the DomainMapping that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="resourceRecords")
    def resource_records(self) -> Sequence['outputs.ResourceRecordResponse']:
        """
        The resource records required to configure this domain mapping. These records must be added to the domain's DNS configuration in order to serve the application via this domain mapping.
        """
        return pulumi.get(self, "resource_records")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Holds the URL that will serve the traffic of the DomainMapping. +optional
        """
        return pulumi.get(self, "url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EnvFromSourceResponse(dict):
    """
    EnvFromSource represents the source of a set of ConfigMaps
    """
    def __init__(__self__, *,
                 config_map_ref: 'outputs.ConfigMapEnvSourceResponse',
                 prefix: str,
                 secret_ref: 'outputs.SecretEnvSourceResponse'):
        """
        EnvFromSource represents the source of a set of ConfigMaps
        :param 'ConfigMapEnvSourceResponseArgs' config_map_ref: The ConfigMap to select from +optional
        :param str prefix: An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER. +optional
        :param 'SecretEnvSourceResponseArgs' secret_ref: The Secret to select from +optional
        """
        pulumi.set(__self__, "config_map_ref", config_map_ref)
        pulumi.set(__self__, "prefix", prefix)
        pulumi.set(__self__, "secret_ref", secret_ref)

    @property
    @pulumi.getter(name="configMapRef")
    def config_map_ref(self) -> 'outputs.ConfigMapEnvSourceResponse':
        """
        The ConfigMap to select from +optional
        """
        return pulumi.get(self, "config_map_ref")

    @property
    @pulumi.getter
    def prefix(self) -> str:
        """
        An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER. +optional
        """
        return pulumi.get(self, "prefix")

    @property
    @pulumi.getter(name="secretRef")
    def secret_ref(self) -> 'outputs.SecretEnvSourceResponse':
        """
        The Secret to select from +optional
        """
        return pulumi.get(self, "secret_ref")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EnvVarResponse(dict):
    """
    EnvVar represents an environment variable present in a Container.
    """
    def __init__(__self__, *,
                 name: str,
                 value: str,
                 value_from: 'outputs.EnvVarSourceResponse'):
        """
        EnvVar represents an environment variable present in a Container.
        :param str name: Name of the environment variable. Must be a C_IDENTIFIER.
        :param str value: Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". +optional
        :param 'EnvVarSourceResponseArgs' value_from: Cloud Run fully managed: not supported Cloud Run on GKE: supported Source for the environment variable's value. Cannot be used if value is not empty. +optional
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)
        pulumi.set(__self__, "value_from", value_from)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the environment variable. Must be a C_IDENTIFIER.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any route environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "". +optional
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueFrom")
    def value_from(self) -> 'outputs.EnvVarSourceResponse':
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Source for the environment variable's value. Cannot be used if value is not empty. +optional
        """
        return pulumi.get(self, "value_from")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EnvVarSourceResponse(dict):
    """
    Cloud Run fully managed: not supported Cloud Run on GKE: supported EnvVarSource represents a source for the value of an EnvVar.
    """
    def __init__(__self__, *,
                 config_map_key_ref: 'outputs.ConfigMapKeySelectorResponse',
                 secret_key_ref: 'outputs.SecretKeySelectorResponse'):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported EnvVarSource represents a source for the value of an EnvVar.
        :param 'ConfigMapKeySelectorResponseArgs' config_map_key_ref: Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a ConfigMap. +optional
        :param 'SecretKeySelectorResponseArgs' secret_key_ref: Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a secret in the pod's namespace +optional
        """
        pulumi.set(__self__, "config_map_key_ref", config_map_key_ref)
        pulumi.set(__self__, "secret_key_ref", secret_key_ref)

    @property
    @pulumi.getter(name="configMapKeyRef")
    def config_map_key_ref(self) -> 'outputs.ConfigMapKeySelectorResponse':
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a ConfigMap. +optional
        """
        return pulumi.get(self, "config_map_key_ref")

    @property
    @pulumi.getter(name="secretKeyRef")
    def secret_key_ref(self) -> 'outputs.SecretKeySelectorResponse':
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Selects a key of a secret in the pod's namespace +optional
        """
        return pulumi.get(self, "secret_key_ref")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ExecActionResponse(dict):
    """
    ExecAction describes a "run in container" action.
    """
    def __init__(__self__, *,
                 command: Sequence[str]):
        """
        ExecAction describes a "run in container" action.
        :param Sequence[str] command: Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy. +optional
        """
        pulumi.set(__self__, "command", command)

    @property
    @pulumi.getter
    def command(self) -> Sequence[str]:
        """
        Command is the command line to execute inside the container, the working directory for the command is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy. +optional
        """
        return pulumi.get(self, "command")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HTTPGetActionResponse(dict):
    """
    HTTPGetAction describes an action based on HTTP Get requests.
    """
    def __init__(__self__, *,
                 host: str,
                 http_headers: Sequence['outputs.HTTPHeaderResponse'],
                 path: str,
                 port: 'outputs.IntOrStringResponse',
                 scheme: str):
        """
        HTTPGetAction describes an action based on HTTP Get requests.
        :param str host: Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead. +optional
        :param Sequence['HTTPHeaderResponseArgs'] http_headers: Custom headers to set in the request. HTTP allows repeated headers. +optional
        :param str path: Path to access on the HTTP server. +optional
        :param 'IntOrStringResponseArgs' port: Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        :param str scheme: Scheme to use for connecting to the host. Defaults to HTTP. +optional
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "http_headers", http_headers)
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "scheme", scheme)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead. +optional
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Sequence['outputs.HTTPHeaderResponse']:
        """
        Custom headers to set in the request. HTTP allows repeated headers. +optional
        """
        return pulumi.get(self, "http_headers")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        Path to access on the HTTP server. +optional
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> 'outputs.IntOrStringResponse':
        """
        Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def scheme(self) -> str:
        """
        Scheme to use for connecting to the host. Defaults to HTTP. +optional
        """
        return pulumi.get(self, "scheme")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HTTPHeaderResponse(dict):
    """
    HTTPHeader describes a custom header to be used in HTTP probes
    """
    def __init__(__self__, *,
                 name: str,
                 value: str):
        """
        HTTPHeader describes a custom header to be used in HTTP probes
        :param str name: The header field name
        :param str value: The header field value
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The header field name
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The header field value
        """
        return pulumi.get(self, "value")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HandlerResponse(dict):
    """
    Handler defines a specific action that should be taken
    """
    def __init__(__self__, *,
                 exec_: 'outputs.ExecActionResponse',
                 http_get: 'outputs.HTTPGetActionResponse',
                 tcp_socket: 'outputs.TCPSocketActionResponse'):
        """
        Handler defines a specific action that should be taken
        :param 'ExecActionResponseArgs' exec_: One and only one of the following should be specified. Exec specifies the action to take. +optional
        :param 'HTTPGetActionResponseArgs' http_get: HTTPGet specifies the http request to perform. +optional
        :param 'TCPSocketActionResponseArgs' tcp_socket: TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        pulumi.set(__self__, "exec_", exec_)
        pulumi.set(__self__, "http_get", http_get)
        pulumi.set(__self__, "tcp_socket", tcp_socket)

    @property
    @pulumi.getter(name="exec")
    def exec_(self) -> 'outputs.ExecActionResponse':
        """
        One and only one of the following should be specified. Exec specifies the action to take. +optional
        """
        return pulumi.get(self, "exec_")

    @property
    @pulumi.getter(name="httpGet")
    def http_get(self) -> 'outputs.HTTPGetActionResponse':
        """
        HTTPGet specifies the http request to perform. +optional
        """
        return pulumi.get(self, "http_get")

    @property
    @pulumi.getter(name="tcpSocket")
    def tcp_socket(self) -> 'outputs.TCPSocketActionResponse':
        """
        TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported
        """
        return pulumi.get(self, "tcp_socket")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceSpecResponse(dict):
    """
    InstanceSpec is a description of an instance.
    """
    def __init__(__self__, *,
                 active_deadline_seconds: str,
                 containers: Sequence['outputs.ContainerResponse'],
                 restart_policy: str,
                 service_account_name: str,
                 termination_grace_period_seconds: str,
                 volumes: Sequence['outputs.VolumeResponse']):
        """
        InstanceSpec is a description of an instance.
        :param str active_deadline_seconds: Optional. Optional duration in seconds the instance may be active relative to StartTime before the system will actively try to mark it failed and kill associated containers. If set to zero, the system will never attempt to kill an instance based on time. Otherwise, value must be a positive integer. +optional
        :param Sequence['ContainerResponseArgs'] containers: Optional. List of containers belonging to the instance. We disallow a number of fields on this Container. Only a single container may be provided.
        :param str restart_policy: Optional. Restart policy for all containers within the instance. Allowed values are: - OnFailure: Instances will always be restarted on failure if the backoffLimit has not been reached. - Never: Instances are never restarted and all failures are permanent. Cannot be used if backoffLimit is set. +optional
        :param str service_account_name: Optional. Email address of the IAM service account associated with the instance of a Job. The service account represents the identity of the running instance, and determines what permissions the instance has. If not provided, the instance will use the project's default service account. +optional
        :param str termination_grace_period_seconds: Optional. Optional duration in seconds the instance needs to terminate gracefully. Value must be non-negative integer. The value zero indicates delete immediately. The grace period is the duration in seconds after the processes running in the instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. +optional
        :param Sequence['VolumeResponseArgs'] volumes: Optional. List of volumes that can be mounted by containers belonging to the instance. More info: https://kubernetes.io/docs/concepts/storage/volumes +optional
        """
        pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "restart_policy", restart_policy)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "termination_grace_period_seconds", termination_grace_period_seconds)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> str:
        """
        Optional. Optional duration in seconds the instance may be active relative to StartTime before the system will actively try to mark it failed and kill associated containers. If set to zero, the system will never attempt to kill an instance based on time. Otherwise, value must be a positive integer. +optional
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ContainerResponse']:
        """
        Optional. List of containers belonging to the instance. We disallow a number of fields on this Container. Only a single container may be provided.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter(name="restartPolicy")
    def restart_policy(self) -> str:
        """
        Optional. Restart policy for all containers within the instance. Allowed values are: - OnFailure: Instances will always be restarted on failure if the backoffLimit has not been reached. - Never: Instances are never restarted and all failures are permanent. Cannot be used if backoffLimit is set. +optional
        """
        return pulumi.get(self, "restart_policy")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> str:
        """
        Optional. Email address of the IAM service account associated with the instance of a Job. The service account represents the identity of the running instance, and determines what permissions the instance has. If not provided, the instance will use the project's default service account. +optional
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="terminationGracePeriodSeconds")
    def termination_grace_period_seconds(self) -> str:
        """
        Optional. Optional duration in seconds the instance needs to terminate gracefully. Value must be non-negative integer. The value zero indicates delete immediately. The grace period is the duration in seconds after the processes running in the instance are sent a termination signal and the time when the processes are forcibly halted with a kill signal. Set this value longer than the expected cleanup time for your process. +optional
        """
        return pulumi.get(self, "termination_grace_period_seconds")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        """
        Optional. List of volumes that can be mounted by containers belonging to the instance. More info: https://kubernetes.io/docs/concepts/storage/volumes +optional
        """
        return pulumi.get(self, "volumes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceStatusResponse(dict):
    """
    Instance represents the status of an instance of a Job.
    """
    def __init__(__self__, *,
                 completion_time: str,
                 failed: int,
                 index: int,
                 last_exit_code: int,
                 restarted: int,
                 start_time: str,
                 succeeded: int):
        """
        Instance represents the status of an instance of a Job.
        :param str completion_time: Optional. Represents time when the instance was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int failed: Optional. The number of times this instance exited with code > 0; +optional
        :param int index: Required. Index of the instance, unique per Job, and beginning at 0.
        :param int last_exit_code: Optional. Last exit code seen for this instance. +optional
        :param int restarted: Optional. The number of times this instance was restarted. Instances are restarted according the restartPolicy configured in the Job template. +optional
        :param str start_time: Optional. Represents time when the instance was created by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int succeeded: Optional. The number of times this instance exited with code == 0. +optional
        """
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "failed", failed)
        pulumi.set(__self__, "index", index)
        pulumi.set(__self__, "last_exit_code", last_exit_code)
        pulumi.set(__self__, "restarted", restarted)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> str:
        """
        Optional. Represents time when the instance was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter
    def failed(self) -> int:
        """
        Optional. The number of times this instance exited with code > 0; +optional
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter
    def index(self) -> int:
        """
        Required. Index of the instance, unique per Job, and beginning at 0.
        """
        return pulumi.get(self, "index")

    @property
    @pulumi.getter(name="lastExitCode")
    def last_exit_code(self) -> int:
        """
        Optional. Last exit code seen for this instance. +optional
        """
        return pulumi.get(self, "last_exit_code")

    @property
    @pulumi.getter
    def restarted(self) -> int:
        """
        Optional. The number of times this instance was restarted. Instances are restarted according the restartPolicy configured in the Job template. +optional
        """
        return pulumi.get(self, "restarted")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. Represents time when the instance was created by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def succeeded(self) -> int:
        """
        Optional. The number of times this instance exited with code == 0. +optional
        """
        return pulumi.get(self, "succeeded")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceTemplateSpecResponse(dict):
    """
    InstanceTemplateSpec describes the data an instance should have when created from a template.
    """
    def __init__(__self__, *,
                 spec: 'outputs.InstanceSpecResponse'):
        """
        InstanceTemplateSpec describes the data an instance should have when created from a template.
        :param 'InstanceSpecResponseArgs' spec: Optional. Specification of the desired behavior of the instance. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status +optional
        """
        pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.InstanceSpecResponse':
        """
        Optional. Specification of the desired behavior of the instance. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#spec-and-status +optional
        """
        return pulumi.get(self, "spec")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IntOrStringResponse(dict):
    """
    IntOrString is a type that can hold an int32 or a string. When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type. This allows you to have, for example, a JSON field that can accept a name or number.
    """
    def __init__(__self__, *,
                 int_val: int,
                 str_val: str,
                 type: int):
        """
        IntOrString is a type that can hold an int32 or a string. When used in JSON or YAML marshalling and unmarshalling, it produces or consumes the inner type. This allows you to have, for example, a JSON field that can accept a name or number.
        :param int int_val: The int value.
        :param str str_val: The string value.
        :param int type: The type of the value.
        """
        pulumi.set(__self__, "int_val", int_val)
        pulumi.set(__self__, "str_val", str_val)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="intVal")
    def int_val(self) -> int:
        """
        The int value.
        """
        return pulumi.get(self, "int_val")

    @property
    @pulumi.getter(name="strVal")
    def str_val(self) -> str:
        """
        The string value.
        """
        return pulumi.get(self, "str_val")

    @property
    @pulumi.getter
    def type(self) -> int:
        """
        The type of the value.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobConditionResponse(dict):
    """
    JobCondition defines a readiness condition for a Revision.
    """
    def __init__(__self__, *,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 severity: str,
                 status: str,
                 type: str):
        """
        JobCondition defines a readiness condition for a Revision.
        :param str last_transition_time: Optional. Last time the condition transitioned from one status to another.
        :param str message: Optional. Human readable message indicating details about the current status.
        :param str reason: Optional. One-word CamelCase reason for the condition's last transition.
        :param str severity: Optional. How to interpret failures of this condition, one of Error, Warning, Info
        :param str status: Required. Status of the condition, one of True, False, Unknown.
        :param str type: Required. Type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: * "Completed": True when the Job has successfully completed. * "Started": True when the Job has successfully started running. * "ResourcesAvailable": True when underlying resources have been provisioned.
        """
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Optional. Last time the condition transitioned from one status to another.
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Optional. Human readable message indicating details about the current status.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        Optional. One-word CamelCase reason for the condition's last transition.
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        Optional. How to interpret failures of this condition, one of Error, Warning, Info
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Required. Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Required. Type is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: * "Completed": True when the Job has successfully completed. * "Started": True when the Job has successfully started running. * "ResourcesAvailable": True when underlying resources have been provisioned.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobSpecResponse(dict):
    """
    JobSpec describes how the job execution will look like.
    """
    def __init__(__self__, *,
                 active_deadline_seconds: str,
                 backoff_limit: int,
                 completions: int,
                 parallelism: int,
                 template: 'outputs.InstanceTemplateSpecResponse',
                 ttl_seconds_after_finished: int):
        """
        JobSpec describes how the job execution will look like.
        :param str active_deadline_seconds: Optional. Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it. If set to zero, the system will never attempt to terminate the job based on time. Otherwise, the value must be positive integer. +optional
        :param int backoff_limit: Optional. Specifies the number of retries per instance, before marking this job failed. If set to zero, instances will never retry on failure. +optional
        :param int completions: Optional. Specifies the desired number of successfully finished instances the job should be run with. Setting to 1 means that parallelism is limited to 1 and the success of that instance signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param int parallelism: Optional. Specifies the maximum desired number of instances the job should run at any given time. Must be <= completions. The actual number of instances running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param 'InstanceTemplateSpecResponseArgs' template: Optional. Describes the instance that will be created when executing a job.
        :param int ttl_seconds_after_finished: Optional. ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job won't be automatically deleted. +optional
        """
        pulumi.set(__self__, "active_deadline_seconds", active_deadline_seconds)
        pulumi.set(__self__, "backoff_limit", backoff_limit)
        pulumi.set(__self__, "completions", completions)
        pulumi.set(__self__, "parallelism", parallelism)
        pulumi.set(__self__, "template", template)
        pulumi.set(__self__, "ttl_seconds_after_finished", ttl_seconds_after_finished)

    @property
    @pulumi.getter(name="activeDeadlineSeconds")
    def active_deadline_seconds(self) -> str:
        """
        Optional. Specifies the duration in seconds relative to the startTime that the job may be active before the system tries to terminate it. If set to zero, the system will never attempt to terminate the job based on time. Otherwise, the value must be positive integer. +optional
        """
        return pulumi.get(self, "active_deadline_seconds")

    @property
    @pulumi.getter(name="backoffLimit")
    def backoff_limit(self) -> int:
        """
        Optional. Specifies the number of retries per instance, before marking this job failed. If set to zero, instances will never retry on failure. +optional
        """
        return pulumi.get(self, "backoff_limit")

    @property
    @pulumi.getter
    def completions(self) -> int:
        """
        Optional. Specifies the desired number of successfully finished instances the job should be run with. Setting to 1 means that parallelism is limited to 1 and the success of that instance signals the success of the job. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "completions")

    @property
    @pulumi.getter
    def parallelism(self) -> int:
        """
        Optional. Specifies the maximum desired number of instances the job should run at any given time. Must be <= completions. The actual number of instances running in steady state will be less than this number when ((.spec.completions - .status.successful) < .spec.parallelism), i.e. when the work left to do is less than max parallelism. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "parallelism")

    @property
    @pulumi.getter
    def template(self) -> 'outputs.InstanceTemplateSpecResponse':
        """
        Optional. Describes the instance that will be created when executing a job.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter(name="ttlSecondsAfterFinished")
    def ttl_seconds_after_finished(self) -> int:
        """
        Optional. ttlSecondsAfterFinished limits the lifetime of a Job that has finished execution (either Complete or Failed). If this field is set, ttlSecondsAfterFinished after the Job finishes, it is eligible to be automatically deleted. When the Job is being deleted, its lifecycle guarantees (e.g. finalizers) will be honored. If this field is set to zero, the Job won't be automatically deleted. +optional
        """
        return pulumi.get(self, "ttl_seconds_after_finished")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobStatusResponse(dict):
    """
    JobStatus represents the current state of a Job.
    """
    def __init__(__self__, *,
                 active: int,
                 completion_time: str,
                 conditions: Sequence['outputs.JobConditionResponse'],
                 failed: int,
                 image_digest: str,
                 instances: Sequence['outputs.InstanceStatusResponse'],
                 observed_generation: int,
                 start_time: str,
                 succeeded: int):
        """
        JobStatus represents the current state of a Job.
        :param int active: Optional. The number of actively running instances. +optional
        :param str completion_time: Optional. Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param Sequence['JobConditionResponseArgs'] conditions: Optional. The latest available observations of a job's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        :param int failed: Optional. The number of instances which reached phase Failed. +optional
        :param str image_digest: Optional. ImageDigest holds the resolved digest for the image specified within .Spec.Template.Spec.Container.Image. The digest is resolved during the creation of the Job. This field holds the digest value regardless of whether a tag or digest was originally specified in the Container object.
        :param Sequence['InstanceStatusResponseArgs'] instances: Optional. Status of completed, failed, and running instances. +optional
        :param int observed_generation: Optional. The 'generation' of the job that was last processed by the controller.
        :param str start_time: Optional. Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        :param int succeeded: Optional. The number of instances which reached phase Succeeded. +optional
        """
        pulumi.set(__self__, "active", active)
        pulumi.set(__self__, "completion_time", completion_time)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "failed", failed)
        pulumi.set(__self__, "image_digest", image_digest)
        pulumi.set(__self__, "instances", instances)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "succeeded", succeeded)

    @property
    @pulumi.getter
    def active(self) -> int:
        """
        Optional. The number of actively running instances. +optional
        """
        return pulumi.get(self, "active")

    @property
    @pulumi.getter(name="completionTime")
    def completion_time(self) -> str:
        """
        Optional. Represents time when the job was completed. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "completion_time")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.JobConditionResponse']:
        """
        Optional. The latest available observations of a job's current state. More info: https://kubernetes.io/docs/concepts/workloads/controllers/jobs-run-to-completion/ +optional
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def failed(self) -> int:
        """
        Optional. The number of instances which reached phase Failed. +optional
        """
        return pulumi.get(self, "failed")

    @property
    @pulumi.getter(name="imageDigest")
    def image_digest(self) -> str:
        """
        Optional. ImageDigest holds the resolved digest for the image specified within .Spec.Template.Spec.Container.Image. The digest is resolved during the creation of the Job. This field holds the digest value regardless of whether a tag or digest was originally specified in the Container object.
        """
        return pulumi.get(self, "image_digest")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.InstanceStatusResponse']:
        """
        Optional. Status of completed, failed, and running instances. +optional
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        """
        Optional. The 'generation' of the job that was last processed by the controller.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        Optional. Represents time when the job was acknowledged by the job controller. It is not guaranteed to be set in happens-before order across separate operations. It is represented in RFC3339 form and is in UTC. +optional
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def succeeded(self) -> int:
        """
        Optional. The number of instances which reached phase Succeeded. +optional
        """
        return pulumi.get(self, "succeeded")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class KeyToPathResponse(dict):
    """
    Maps a string key to a path within a volume.
    """
    def __init__(__self__, *,
                 key: str,
                 mode: int,
                 path: str):
        """
        Maps a string key to a path within a volume.
        :param str key: The key to project.
        :param int mode: Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. +optional
        :param str path: The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "mode", mode)
        pulumi.set(__self__, "path", path)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key to project.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def mode(self) -> int:
        """
        Mode bits to use on this file, must be a value between 0 and 0777. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set. +optional
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter
    def path(self) -> str:
        """
        The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
        """
        return pulumi.get(self, "path")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LifecycleResponse(dict):
    """
    Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
    """
    def __init__(__self__, *,
                 post_start: 'outputs.HandlerResponse',
                 pre_stop: 'outputs.HandlerResponse'):
        """
        Lifecycle describes actions that the management system should take in response to container lifecycle events. For the PostStart and PreStop lifecycle handlers, management of the container blocks until the action is complete, unless the container process fails, in which case the handler is aborted.
        :param 'HandlerResponseArgs' post_start: PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        :param 'HandlerResponseArgs' pre_stop: PreStop is called immediately before a container is terminated. The container is terminated after the handler completes. The reason for termination is passed to the handler. Regardless of the outcome of the handler, the container is eventually terminated. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        pulumi.set(__self__, "post_start", post_start)
        pulumi.set(__self__, "pre_stop", pre_stop)

    @property
    @pulumi.getter(name="postStart")
    def post_start(self) -> 'outputs.HandlerResponse':
        """
        PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        return pulumi.get(self, "post_start")

    @property
    @pulumi.getter(name="preStop")
    def pre_stop(self) -> 'outputs.HandlerResponse':
        """
        PreStop is called immediately before a container is terminated. The container is terminated after the handler completes. The reason for termination is passed to the handler. Regardless of the outcome of the handler, the container is eventually terminated. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks +optional
        """
        return pulumi.get(self, "pre_stop")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LocalObjectReferenceResponse(dict):
    """
    LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
    """
    def __init__(__self__, *,
                 name: str):
        """
        LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
        :param str name: Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
        """
        return pulumi.get(self, "name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ObjectMetaResponse(dict):
    """
    ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
    """
    def __init__(__self__, *,
                 annotations: Mapping[str, str],
                 cluster_name: str,
                 creation_timestamp: str,
                 deletion_grace_period_seconds: int,
                 deletion_timestamp: str,
                 finalizers: Sequence[str],
                 generate_name: str,
                 generation: int,
                 labels: Mapping[str, str],
                 name: str,
                 namespace: str,
                 owner_references: Sequence['outputs.OwnerReferenceResponse'],
                 resource_version: str,
                 self_link: str,
                 uid: str):
        """
        ObjectMeta is metadata that all persisted resources must have, which includes all objects users must create.
        :param Mapping[str, str] annotations: Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations +optional
        :param str cluster_name: Not currently supported by Cloud Run. The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request. +optional
        :param str creation_timestamp: CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC. Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        :param int deletion_grace_period_seconds: Not currently supported by Cloud Run. Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only. +optional
        :param str deletion_timestamp: DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested. Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        :param Sequence[str] finalizers: Not currently supported by Cloud Run. Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. +optional +patchStrategy=merge
        :param str generate_name: Not currently supported by Cloud Run. GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server. If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header). Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency +optional string generateName = 2;
        :param int generation: A sequence number representing a specific generation of the desired state. Populated by the system. Read-only. +optional
        :param Mapping[str, str] labels: Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels +optional
        :param str name: Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional
        :param str namespace: Namespace defines the space within each name must be unique, within a Cloud Run region. In Cloud Run the namespace must be equal to either the project ID or project number.
        :param Sequence['OwnerReferenceResponseArgs'] owner_references: List of objects that own this object. If ALL objects in the list have been deleted, this object will be garbage collected. +optional
        :param str resource_version: An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources. Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency +optional
        :param str self_link: SelfLink is a URL representing this object. Populated by the system. Read-only. +optional string selfLink = 4;
        :param str uid: UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations. Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids +optional
        """
        pulumi.set(__self__, "annotations", annotations)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "creation_timestamp", creation_timestamp)
        pulumi.set(__self__, "deletion_grace_period_seconds", deletion_grace_period_seconds)
        pulumi.set(__self__, "deletion_timestamp", deletion_timestamp)
        pulumi.set(__self__, "finalizers", finalizers)
        pulumi.set(__self__, "generate_name", generate_name)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "owner_references", owner_references)
        pulumi.set(__self__, "resource_version", resource_version)
        pulumi.set(__self__, "self_link", self_link)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter
    def annotations(self) -> Mapping[str, str]:
        """
        Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations +optional
        """
        return pulumi.get(self, "annotations")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Not currently supported by Cloud Run. The name of the cluster which the object belongs to. This is used to distinguish resources with same name and namespace in different clusters. This field is not set anywhere right now and apiserver is going to ignore it if set in create or update request. +optional
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> str:
        """
        CreationTimestamp is a timestamp representing the server time when this object was created. It is not guaranteed to be set in happens-before order across separate operations. Clients may not set this value. It is represented in RFC3339 form and is in UTC. Populated by the system. Read-only. Null for lists. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter(name="deletionGracePeriodSeconds")
    def deletion_grace_period_seconds(self) -> int:
        """
        Not currently supported by Cloud Run. Number of seconds allowed for this object to gracefully terminate before it will be removed from the system. Only set when deletionTimestamp is also set. May only be shortened. Read-only. +optional
        """
        return pulumi.get(self, "deletion_grace_period_seconds")

    @property
    @pulumi.getter(name="deletionTimestamp")
    def deletion_timestamp(self) -> str:
        """
        DeletionTimestamp is RFC 3339 date and time at which this resource will be deleted. This field is set by the server when a graceful deletion is requested by the user, and is not directly settable by a client. The resource is expected to be deleted (no longer visible from resource lists, and not reachable by name) after the time in this field, once the finalizers list is empty. As long as the finalizers list contains items, deletion is blocked. Once the deletionTimestamp is set, this value may not be unset or be set further into the future, although it may be shortened or the resource may be deleted prior to this time. For example, a user may request that a pod is deleted in 30 seconds. The Kubelet will react by sending a graceful termination signal to the containers in the pod. After that 30 seconds, the Kubelet will send a hard termination signal (SIGKILL) to the container and after cleanup, remove the pod from the API. In the presence of network partitions, this object may still exist after this timestamp, until an administrator or automated process can determine the resource is fully terminated. If not set, graceful deletion of the object has not been requested. Populated by the system when a graceful deletion is requested. Read-only. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#metadata +optional
        """
        return pulumi.get(self, "deletion_timestamp")

    @property
    @pulumi.getter
    def finalizers(self) -> Sequence[str]:
        """
        Not currently supported by Cloud Run. Must be empty before the object is deleted from the registry. Each entry is an identifier for the responsible component that will remove the entry from the list. If the deletionTimestamp of the object is non-nil, entries in this list can only be removed. +optional +patchStrategy=merge
        """
        return pulumi.get(self, "finalizers")

    @property
    @pulumi.getter(name="generateName")
    def generate_name(self) -> str:
        """
        Not currently supported by Cloud Run. GenerateName is an optional prefix, used by the server, to generate a unique name ONLY IF the Name field has not been provided. If this field is used, the name returned to the client will be different than the name passed. This value will also be combined with a unique suffix. The provided value has the same validation rules as the Name field, and may be truncated by the length of the suffix required to make the value unique on the server. If this field is specified and the generated name exists, the server will NOT return a 409 - instead, it will either return 201 Created or 500 with Reason ServerTimeout indicating a unique name could not be found in the time allotted, and the client should retry (optionally after the time indicated in the Retry-After header). Applied only if Name is not specified. More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#idempotency +optional string generateName = 2;
        """
        return pulumi.get(self, "generate_name")

    @property
    @pulumi.getter
    def generation(self) -> int:
        """
        A sequence number representing a specific generation of the desired state. Populated by the system. Read-only. +optional
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and routes. More info: http://kubernetes.io/docs/user-guide/labels +optional
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name must be unique within a namespace, within a Cloud Run region. Is required when creating resources, although some resources may allow a client to request the generation of an appropriate name automatically. Name is primarily intended for creation idempotence and configuration definition. Cannot be updated. More info: http://kubernetes.io/docs/user-guide/identifiers#names +optional
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        Namespace defines the space within each name must be unique, within a Cloud Run region. In Cloud Run the namespace must be equal to either the project ID or project number.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="ownerReferences")
    def owner_references(self) -> Sequence['outputs.OwnerReferenceResponse']:
        """
        List of objects that own this object. If ALL objects in the list have been deleted, this object will be garbage collected. +optional
        """
        return pulumi.get(self, "owner_references")

    @property
    @pulumi.getter(name="resourceVersion")
    def resource_version(self) -> str:
        """
        An opaque value that represents the internal version of this object that can be used by clients to determine when objects have changed. May be used for optimistic concurrency, change detection, and the watch operation on a resource or set of resources. Clients must treat these values as opaque and passed unmodified back to the server. They may only be valid for a particular resource or set of resources. Populated by the system. Read-only. Value must be treated as opaque by clients and . More info: https://git.k8s.io/community/contributors/devel/api-conventions.md#concurrency-control-and-consistency +optional
        """
        return pulumi.get(self, "resource_version")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> str:
        """
        SelfLink is a URL representing this object. Populated by the system. Read-only. +optional string selfLink = 4;
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        UID is the unique in time and space value for this object. It is typically generated by the server on successful creation of a resource and is not allowed to change on PUT operations. Populated by the system. Read-only. More info: http://kubernetes.io/docs/user-guide/identifiers#uids +optional
        """
        return pulumi.get(self, "uid")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OwnerReferenceResponse(dict):
    """
    OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.
    """
    def __init__(__self__, *,
                 api_version: str,
                 block_owner_deletion: bool,
                 controller: bool,
                 kind: str,
                 name: str,
                 uid: str):
        """
        OwnerReference contains enough information to let you identify an owning object. Currently, an owning object must be in the same namespace, so there is no namespace field.
        :param str api_version: API version of the referent.
        :param bool block_owner_deletion: If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. +optional
        :param bool controller: If true, this reference points to the managing controller. +optional
        :param str kind: Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        :param str name: Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        :param str uid: UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        pulumi.set(__self__, "api_version", api_version)
        pulumi.set(__self__, "block_owner_deletion", block_owner_deletion)
        pulumi.set(__self__, "controller", controller)
        pulumi.set(__self__, "kind", kind)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="apiVersion")
    def api_version(self) -> str:
        """
        API version of the referent.
        """
        return pulumi.get(self, "api_version")

    @property
    @pulumi.getter(name="blockOwnerDeletion")
    def block_owner_deletion(self) -> bool:
        """
        If true, AND if the owner has the "foregroundDeletion" finalizer, then the owner cannot be deleted from the key-value store until this reference is removed. Defaults to false. To set this field, a user needs "delete" permission of the owner, otherwise 422 (Unprocessable Entity) will be returned. +optional
        """
        return pulumi.get(self, "block_owner_deletion")

    @property
    @pulumi.getter
    def controller(self) -> bool:
        """
        If true, this reference points to the managing controller. +optional
        """
        return pulumi.get(self, "controller")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        Kind of the referent. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#names
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def uid(self) -> str:
        """
        UID of the referent. More info: http://kubernetes.io/docs/user-guide/identifiers#uids
        """
        return pulumi.get(self, "uid")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ProbeResponse(dict):
    """
    Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
    """
    def __init__(__self__, *,
                 failure_threshold: int,
                 handler: 'outputs.HandlerResponse',
                 initial_delay_seconds: int,
                 period_seconds: int,
                 success_threshold: int,
                 timeout_seconds: int):
        """
        Probe describes a health check to be performed against a container to determine whether it is alive or ready to receive traffic.
        :param int failure_threshold: Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. +optional
        :param 'HandlerResponseArgs' handler: The action taken to determine the health of a container
        :param int initial_delay_seconds: Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        :param int period_seconds: How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. +optional
        :param int success_threshold: Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1. +optional
        :param int timeout_seconds: Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        pulumi.set(__self__, "failure_threshold", failure_threshold)
        pulumi.set(__self__, "handler", handler)
        pulumi.set(__self__, "initial_delay_seconds", initial_delay_seconds)
        pulumi.set(__self__, "period_seconds", period_seconds)
        pulumi.set(__self__, "success_threshold", success_threshold)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> int:
        """
        Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1. +optional
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def handler(self) -> 'outputs.HandlerResponse':
        """
        The action taken to determine the health of a container
        """
        return pulumi.get(self, "handler")

    @property
    @pulumi.getter(name="initialDelaySeconds")
    def initial_delay_seconds(self) -> int:
        """
        Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "initial_delay_seconds")

    @property
    @pulumi.getter(name="periodSeconds")
    def period_seconds(self) -> int:
        """
        How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1. +optional
        """
        return pulumi.get(self, "period_seconds")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> int:
        """
        Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness. Minimum value is 1. +optional
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        """
        Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes +optional
        """
        return pulumi.get(self, "timeout_seconds")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ResourceRecordResponse(dict):
    """
    A DNS resource record.
    """
    def __init__(__self__, *,
                 name: str,
                 rrdata: str,
                 type: str):
        """
        A DNS resource record.
        :param str name: Relative name of the object affected by this record. Only applicable for `CNAME` records. Example: 'www'.
        :param str rrdata: Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        :param str type: Resource record type. Example: `AAAA`.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "rrdata", rrdata)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Relative name of the object affected by this record. Only applicable for `CNAME` records. Example: 'www'.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def rrdata(self) -> str:
        """
        Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        """
        return pulumi.get(self, "rrdata")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Resource record type. Example: `AAAA`.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ResourceRequirementsResponse(dict):
    """
    ResourceRequirements describes the compute resource requirements.
    """
    def __init__(__self__, *,
                 limits: Mapping[str, str],
                 limits_in_map: Mapping[str, str],
                 requests: Mapping[str, str],
                 requests_in_map: Mapping[str, str]):
        """
        ResourceRequirements describes the compute resource requirements.
        :param Mapping[str, str] limits: Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, str] limits_in_map: Limits describes the maximum amount of compute resources allowed. This is a temporary field created to migrate away from the map limits field. This is done to become compliant with k8s style API. This field is deprecated in favor of limits field.
        :param Mapping[str, str] requests: Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        :param Mapping[str, str] requests_in_map: Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. This is a temporary field created to migrate away from the map requests field. This is done to become compliant with k8s style API. This field is deprecated in favor of requests field.
        """
        pulumi.set(__self__, "limits", limits)
        pulumi.set(__self__, "limits_in_map", limits_in_map)
        pulumi.set(__self__, "requests", requests)
        pulumi.set(__self__, "requests_in_map", requests_in_map)

    @property
    @pulumi.getter
    def limits(self) -> Mapping[str, str]:
        """
        Limits describes the maximum amount of compute resources allowed. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "limits")

    @property
    @pulumi.getter(name="limitsInMap")
    def limits_in_map(self) -> Mapping[str, str]:
        """
        Limits describes the maximum amount of compute resources allowed. This is a temporary field created to migrate away from the map limits field. This is done to become compliant with k8s style API. This field is deprecated in favor of limits field.
        """
        return pulumi.get(self, "limits_in_map")

    @property
    @pulumi.getter
    def requests(self) -> Mapping[str, str]:
        """
        Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. The values of the map is string form of the 'quantity' k8s type: https://github.com/kubernetes/kubernetes/blob/master/staging/src/k8s.io/apimachinery/pkg/api/resource/quantity.go
        """
        return pulumi.get(self, "requests")

    @property
    @pulumi.getter(name="requestsInMap")
    def requests_in_map(self) -> Mapping[str, str]:
        """
        Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. This is a temporary field created to migrate away from the map requests field. This is done to become compliant with k8s style API. This field is deprecated in favor of requests field.
        """
        return pulumi.get(self, "requests_in_map")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RevisionSpecResponse(dict):
    """
    RevisionSpec holds the desired state of the Revision (from the client).
    """
    def __init__(__self__, *,
                 concurrency_model: str,
                 container: 'outputs.ContainerResponse',
                 container_concurrency: int,
                 containers: Sequence['outputs.ContainerResponse'],
                 generation: int,
                 service_account_name: str,
                 serving_state: str,
                 timeout_seconds: int,
                 volumes: Sequence['outputs.VolumeResponse']):
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        :param str concurrency_model: ConcurrencyModel specifies the desired concurrency model (Single or Multi) for the Revision. Defaults to Multi. Deprecated in favor of ContainerConcurrency. +optional
        :param 'ContainerResponseArgs' container: Container defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of the fields of this Container, including: name, ports, and volumeMounts. The runtime contract is documented here: https://github.com/knative/serving/blob/master/docs/runtime-contract.md
        :param int container_concurrency: (Optional) ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container instance of the Revision. Cloud Run fully managed: supported, defaults to 80 Cloud Run on GKE: supported, defaults to 0, which means concurrency to the application is not limited, and the system decides the target concurrency for the autoscaler.
        :param Sequence['ContainerResponseArgs'] containers: Containers holds the single container that defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of fields on this Container, including: name and lifecycle. In Cloud Run, only a single container may be provided.
        :param int generation: Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        :param str service_account_name: Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        :param str serving_state: ServingState holds a value describing the state the resources are in for this Revision. Users must not specify this when creating a revision. It is expected that the system will manipulate this based on routability and load. Populated by the system. Read-only.
        :param int timeout_seconds: TimeoutSeconds holds the max duration the instance is allowed for responding to a request. Not currently used by Cloud Run.
        """
        pulumi.set(__self__, "concurrency_model", concurrency_model)
        pulumi.set(__self__, "container", container)
        pulumi.set(__self__, "container_concurrency", container_concurrency)
        pulumi.set(__self__, "containers", containers)
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "service_account_name", service_account_name)
        pulumi.set(__self__, "serving_state", serving_state)
        pulumi.set(__self__, "timeout_seconds", timeout_seconds)
        pulumi.set(__self__, "volumes", volumes)

    @property
    @pulumi.getter(name="concurrencyModel")
    def concurrency_model(self) -> str:
        """
        ConcurrencyModel specifies the desired concurrency model (Single or Multi) for the Revision. Defaults to Multi. Deprecated in favor of ContainerConcurrency. +optional
        """
        return pulumi.get(self, "concurrency_model")

    @property
    @pulumi.getter
    def container(self) -> 'outputs.ContainerResponse':
        """
        Container defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of the fields of this Container, including: name, ports, and volumeMounts. The runtime contract is documented here: https://github.com/knative/serving/blob/master/docs/runtime-contract.md
        """
        return pulumi.get(self, "container")

    @property
    @pulumi.getter(name="containerConcurrency")
    def container_concurrency(self) -> int:
        """
        (Optional) ContainerConcurrency specifies the maximum allowed in-flight (concurrent) requests per container instance of the Revision. Cloud Run fully managed: supported, defaults to 80 Cloud Run on GKE: supported, defaults to 0, which means concurrency to the application is not limited, and the system decides the target concurrency for the autoscaler.
        """
        return pulumi.get(self, "container_concurrency")

    @property
    @pulumi.getter
    def containers(self) -> Sequence['outputs.ContainerResponse']:
        """
        Containers holds the single container that defines the unit of execution for this Revision. In the context of a Revision, we disallow a number of fields on this Container, including: name and lifecycle. In Cloud Run, only a single container may be provided.
        """
        return pulumi.get(self, "containers")

    @property
    @pulumi.getter
    def generation(self) -> int:
        """
        Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter(name="serviceAccountName")
    def service_account_name(self) -> str:
        """
        Email address of the IAM service account associated with the revision of the service. The service account represents the identity of the running revision, and determines what permissions the revision has. If not provided, the revision will use the project's default service account.
        """
        return pulumi.get(self, "service_account_name")

    @property
    @pulumi.getter(name="servingState")
    def serving_state(self) -> str:
        """
        ServingState holds a value describing the state the resources are in for this Revision. Users must not specify this when creating a revision. It is expected that the system will manipulate this based on routability and load. Populated by the system. Read-only.
        """
        return pulumi.get(self, "serving_state")

    @property
    @pulumi.getter(name="timeoutSeconds")
    def timeout_seconds(self) -> int:
        """
        TimeoutSeconds holds the max duration the instance is allowed for responding to a request. Not currently used by Cloud Run.
        """
        return pulumi.get(self, "timeout_seconds")

    @property
    @pulumi.getter
    def volumes(self) -> Sequence['outputs.VolumeResponse']:
        return pulumi.get(self, "volumes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RevisionTemplateResponse(dict):
    """
    RevisionTemplateSpec describes the data a revision should have when created from a template. Based on: https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190
    """
    def __init__(__self__, *,
                 metadata: 'outputs.ObjectMetaResponse',
                 spec: 'outputs.RevisionSpecResponse'):
        """
        RevisionTemplateSpec describes the data a revision should have when created from a template. Based on: https://github.com/kubernetes/api/blob/e771f807/core/v1/types.go#L3179-L3190
        :param 'ObjectMetaResponseArgs' metadata: Optional metadata for this Revision, including labels and annotations. Name will be generated by the Configuration. To set minimum instances for this revision, use the "autoscaling.knative.dev/minScale" annotation key. (Cloud Run on GKE only). To set maximum instances for this revision, use the "autoscaling.knative.dev/maxScale" annotation key. To set Cloud SQL connections for the revision, use the "run.googleapis.com/cloudsql-instances" annotation key. Values should be comma separated.
        :param 'RevisionSpecResponseArgs' spec: RevisionSpec holds the desired state of the Revision (from the client).
        """
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def metadata(self) -> 'outputs.ObjectMetaResponse':
        """
        Optional metadata for this Revision, including labels and annotations. Name will be generated by the Configuration. To set minimum instances for this revision, use the "autoscaling.knative.dev/minScale" annotation key. (Cloud Run on GKE only). To set maximum instances for this revision, use the "autoscaling.knative.dev/maxScale" annotation key. To set Cloud SQL connections for the revision, use the "run.googleapis.com/cloudsql-instances" annotation key. Values should be comma separated.
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter
    def spec(self) -> 'outputs.RevisionSpecResponse':
        """
        RevisionSpec holds the desired state of the Revision (from the client).
        """
        return pulumi.get(self, "spec")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SELinuxOptionsResponse(dict):
    """
    SELinuxOptions are the labels to be applied to the container
    """
    def __init__(__self__, *,
                 level: str,
                 role: str,
                 type: str,
                 user: str):
        """
        SELinuxOptions are the labels to be applied to the container
        :param str level: Level is SELinux level label that applies to the container. +optional
        :param str role: Role is a SELinux role label that applies to the container. +optional
        :param str type: Type is a SELinux type label that applies to the container. +optional
        :param str user: User is a SELinux user label that applies to the container. +optional
        """
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "user", user)

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        Level is SELinux level label that applies to the container. +optional
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role is a SELinux role label that applies to the container. +optional
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type is a SELinux type label that applies to the container. +optional
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def user(self) -> str:
        """
        User is a SELinux user label that applies to the container. +optional
        """
        return pulumi.get(self, "user")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretEnvSourceResponse(dict):
    """
    SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
    """
    def __init__(__self__, *,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        SecretEnvSource selects a Secret to populate the environment variables with. The contents of the target Secret's Data field will represent the key-value pairs as environment variables.
        :param 'LocalObjectReferenceResponseArgs' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: Cloud Run fully managed: not supported Cloud Run for Anthos: supported The Secret to select from.
        :param bool optional: Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the Secret must be defined +optional
        """
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported The Secret to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Cloud Run fully managed: not supported Cloud Run for Anthos: supported Specify whether the Secret must be defined +optional
        """
        return pulumi.get(self, "optional")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretKeySelectorResponse(dict):
    """
    Cloud Run fully managed: not supported Cloud Run on GKE: supported SecretKeySelector selects a key of a Secret.
    """
    def __init__(__self__, *,
                 key: str,
                 local_object_reference: 'outputs.LocalObjectReferenceResponse',
                 name: str,
                 optional: bool):
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported SecretKeySelector selects a key of a Secret.
        :param str key: Cloud Run fully managed: not supported Cloud Run on GKE: supported The key of the secret to select from. Must be a valid secret key.
        :param 'LocalObjectReferenceResponseArgs' local_object_reference: This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        :param str name: Cloud Run fully managed: not supported Cloud Run on GKE: supported The name of the secret in the pod's namespace to select from.
        :param bool optional: Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the Secret or its key must be defined +optional
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "local_object_reference", local_object_reference)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "optional", optional)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The key of the secret to select from. Must be a valid secret key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="localObjectReference")
    def local_object_reference(self) -> 'outputs.LocalObjectReferenceResponse':
        """
        This field should not be used directly as it is meant to be inlined directly into the message. Use the "name" field instead.
        """
        return pulumi.get(self, "local_object_reference")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported The name of the secret in the pod's namespace to select from.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Cloud Run fully managed: not supported Cloud Run on GKE: supported Specify whether the Secret or its key must be defined +optional
        """
        return pulumi.get(self, "optional")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecretVolumeSourceResponse(dict):
    """
    The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
    """
    def __init__(__self__, *,
                 default_mode: int,
                 items: Sequence['outputs.KeyToPathResponse'],
                 optional: bool,
                 secret_name: str):
        """
        The contents of the target Secret's Data field will be presented in a volume as files using the keys in the Data field as the file names.
        :param int default_mode: Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        :param Sequence['KeyToPathResponseArgs'] items: If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        :param bool optional: Specify whether the Secret or its keys must be defined.
        :param str secret_name: Name of the secret in the container's namespace to use.
        """
        pulumi.set(__self__, "default_mode", default_mode)
        pulumi.set(__self__, "items", items)
        pulumi.set(__self__, "optional", optional)
        pulumi.set(__self__, "secret_name", secret_name)

    @property
    @pulumi.getter(name="defaultMode")
    def default_mode(self) -> int:
        """
        Mode bits to use on created files by default. Must be a value between 0 and 0777. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
        """
        return pulumi.get(self, "default_mode")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.KeyToPathResponse']:
        """
        If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter
    def optional(self) -> bool:
        """
        Specify whether the Secret or its keys must be defined.
        """
        return pulumi.get(self, "optional")

    @property
    @pulumi.getter(name="secretName")
    def secret_name(self) -> str:
        """
        Name of the secret in the container's namespace to use.
        """
        return pulumi.get(self, "secret_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecurityContextResponse(dict):
    """
    SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
    """
    def __init__(__self__, *,
                 allow_privilege_escalation: bool,
                 capabilities: 'outputs.CapabilitiesResponse',
                 privileged: bool,
                 read_only_root_filesystem: bool,
                 run_as_group: int,
                 run_as_non_root: bool,
                 run_as_user: int,
                 se_linux_options: 'outputs.SELinuxOptionsResponse'):
        """
        SecurityContext holds security configuration that will be applied to a container. Some fields are present in both SecurityContext and PodSecurityContext. When both are set, the values in SecurityContext take precedence.
        :param bool allow_privilege_escalation: AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN +optional
        :param 'CapabilitiesResponseArgs' capabilities: The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. +optional
        :param bool privileged: Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. +optional
        :param bool read_only_root_filesystem: Whether this container has a read-only root filesystem. Default is false. +optional
        :param int run_as_group: The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param bool run_as_non_root: Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param int run_as_user: The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        :param 'SELinuxOptionsResponseArgs' se_linux_options: The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        pulumi.set(__self__, "allow_privilege_escalation", allow_privilege_escalation)
        pulumi.set(__self__, "capabilities", capabilities)
        pulumi.set(__self__, "privileged", privileged)
        pulumi.set(__self__, "read_only_root_filesystem", read_only_root_filesystem)
        pulumi.set(__self__, "run_as_group", run_as_group)
        pulumi.set(__self__, "run_as_non_root", run_as_non_root)
        pulumi.set(__self__, "run_as_user", run_as_user)
        pulumi.set(__self__, "se_linux_options", se_linux_options)

    @property
    @pulumi.getter(name="allowPrivilegeEscalation")
    def allow_privilege_escalation(self) -> bool:
        """
        AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN +optional
        """
        return pulumi.get(self, "allow_privilege_escalation")

    @property
    @pulumi.getter
    def capabilities(self) -> 'outputs.CapabilitiesResponse':
        """
        The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime. +optional
        """
        return pulumi.get(self, "capabilities")

    @property
    @pulumi.getter
    def privileged(self) -> bool:
        """
        Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false. +optional
        """
        return pulumi.get(self, "privileged")

    @property
    @pulumi.getter(name="readOnlyRootFilesystem")
    def read_only_root_filesystem(self) -> bool:
        """
        Whether this container has a read-only root filesystem. Default is false. +optional
        """
        return pulumi.get(self, "read_only_root_filesystem")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> int:
        """
        The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsNonRoot")
    def run_as_non_root(self) -> bool:
        """
        Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_non_root")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> int:
        """
        The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "run_as_user")

    @property
    @pulumi.getter(name="seLinuxOptions")
    def se_linux_options(self) -> 'outputs.SELinuxOptionsResponse':
        """
        The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence. +optional
        """
        return pulumi.get(self, "se_linux_options")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceConditionResponse(dict):
    """
    ServiceCondition defines a readiness condition for a Service.
    """
    def __init__(__self__, *,
                 last_transition_time: str,
                 message: str,
                 reason: str,
                 severity: str,
                 status: str,
                 type: str):
        """
        ServiceCondition defines a readiness condition for a Service.
        :param str last_transition_time: Last time the condition transitioned from one status to another. +optional
        :param str message: Human-readable message indicating details about last transition. +optional
        :param str reason: One-word CamelCase reason for the condition's last transition. +optional
        :param str severity: How to interpret failures of this condition, one of Error, Warning, Info +optional
        :param str status: Status of the condition, one of True, False, Unknown.
        :param str type: ServiceConditionType is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: "Ready", "ConfigurationsReady", and "RoutesReady". "Ready" will be true when the underlying Route and Configuration are ready.
        """
        pulumi.set(__self__, "last_transition_time", last_transition_time)
        pulumi.set(__self__, "message", message)
        pulumi.set(__self__, "reason", reason)
        pulumi.set(__self__, "severity", severity)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="lastTransitionTime")
    def last_transition_time(self) -> str:
        """
        Last time the condition transitioned from one status to another. +optional
        """
        return pulumi.get(self, "last_transition_time")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        Human-readable message indicating details about last transition. +optional
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def reason(self) -> str:
        """
        One-word CamelCase reason for the condition's last transition. +optional
        """
        return pulumi.get(self, "reason")

    @property
    @pulumi.getter
    def severity(self) -> str:
        """
        How to interpret failures of this condition, one of Error, Warning, Info +optional
        """
        return pulumi.get(self, "severity")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the condition, one of True, False, Unknown.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        ServiceConditionType is used to communicate the status of the reconciliation process. See also: https://github.com/knative/serving/blob/master/docs/spec/errors.md#error-conditions-and-reporting Types include: "Ready", "ConfigurationsReady", and "RoutesReady". "Ready" will be true when the underlying Route and Configuration are ready.
        """
        return pulumi.get(self, "type")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceSpecManualTypeResponse(dict):
    """
    ServiceSpecManualType contains the options for configuring a manual service. See ServiceSpec for more details. Not currently supported by Cloud Run.
    """
    def __init__(__self__):
        """
        ServiceSpecManualType contains the options for configuring a manual service. See ServiceSpec for more details. Not currently supported by Cloud Run.
        """
        pass

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceSpecPinnedTypeResponse(dict):
    """
    ServiceSpecPinnedType Pins this service to a specific revision name. The revision must be owned by the configuration provided. Deprecated and not supported by Cloud Run.
    """
    def __init__(__self__, *,
                 configuration: 'outputs.ConfigurationSpecResponse',
                 revision_name: str):
        """
        ServiceSpecPinnedType Pins this service to a specific revision name. The revision must be owned by the configuration provided. Deprecated and not supported by Cloud Run.
        :param 'ConfigurationSpecResponseArgs' configuration: The configuration for this service.
        :param str revision_name: The revision name to pin this service to until changed to a different service type.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "revision_name", revision_name)

    @property
    @pulumi.getter
    def configuration(self) -> 'outputs.ConfigurationSpecResponse':
        """
        The configuration for this service.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> str:
        """
        The revision name to pin this service to until changed to a different service type.
        """
        return pulumi.get(self, "revision_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceSpecReleaseTypeResponse(dict):
    """
    ServiceSpecReleaseType contains the options for slowly releasing revisions. See ServiceSpec for more details. Not currently supported by Cloud Run.
    """
    def __init__(__self__, *,
                 configuration: 'outputs.ConfigurationSpecResponse',
                 revisions: Sequence[str],
                 rollout_percent: int):
        """
        ServiceSpecReleaseType contains the options for slowly releasing revisions. See ServiceSpec for more details. Not currently supported by Cloud Run.
        :param 'ConfigurationSpecResponseArgs' configuration: The configuration for this service. All revisions from this service must come from a single configuration.
        :param Sequence[str] revisions: Revisions is an ordered list of 1 or 2 revisions. The first is the current revision, and the second is the candidate revision. If a single revision is provided, traffic will be pinned at that revision. "@latest" is a shortcut for usage that refers to the latest created revision by the configuration.
        :param int rollout_percent: RolloutPercent is the percent of traffic that should be sent to the candidate revision, i.e. the 2nd revision in the revisions list. Valid values are between 0 and 99 inclusive.
        """
        pulumi.set(__self__, "configuration", configuration)
        pulumi.set(__self__, "revisions", revisions)
        pulumi.set(__self__, "rollout_percent", rollout_percent)

    @property
    @pulumi.getter
    def configuration(self) -> 'outputs.ConfigurationSpecResponse':
        """
        The configuration for this service. All revisions from this service must come from a single configuration.
        """
        return pulumi.get(self, "configuration")

    @property
    @pulumi.getter
    def revisions(self) -> Sequence[str]:
        """
        Revisions is an ordered list of 1 or 2 revisions. The first is the current revision, and the second is the candidate revision. If a single revision is provided, traffic will be pinned at that revision. "@latest" is a shortcut for usage that refers to the latest created revision by the configuration.
        """
        return pulumi.get(self, "revisions")

    @property
    @pulumi.getter(name="rolloutPercent")
    def rollout_percent(self) -> int:
        """
        RolloutPercent is the percent of traffic that should be sent to the candidate revision, i.e. the 2nd revision in the revisions list. Valid values are between 0 and 99 inclusive.
        """
        return pulumi.get(self, "rollout_percent")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceSpecResponse(dict):
    """
    ServiceSpec holds the desired state of the Route (from the client), which is used to manipulate the underlying Route and Configuration(s).
    """
    def __init__(__self__, *,
                 generation: int,
                 manual: 'outputs.ServiceSpecManualTypeResponse',
                 pinned: 'outputs.ServiceSpecPinnedTypeResponse',
                 release: 'outputs.ServiceSpecReleaseTypeResponse',
                 run_latest: 'outputs.ServiceSpecRunLatestResponse',
                 template: 'outputs.RevisionTemplateResponse',
                 traffic: Sequence['outputs.TrafficTargetResponse']):
        """
        ServiceSpec holds the desired state of the Route (from the client), which is used to manipulate the underlying Route and Configuration(s).
        :param int generation: Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        :param 'ServiceSpecManualTypeResponseArgs' manual: Manual contains the options for configuring a manual service. See ServiceSpec for more details. Not currently supported by Cloud Run.
        :param 'ServiceSpecPinnedTypeResponseArgs' pinned: Pins this service to a specific revision name. The revision must be owned by the configuration provided. Deprecated and not supported by Cloud Run. +optional
        :param 'ServiceSpecReleaseTypeResponseArgs' release: Release enables gradual promotion of new revisions by allowing traffic to be split between two revisions. This type replaces the deprecated Pinned type. Not currently supported by Cloud Run.
        :param 'ServiceSpecRunLatestResponseArgs' run_latest: RunLatest defines a simple Service. It will automatically configure a route that keeps the latest ready revision from the supplied configuration running. +optional
        :param 'RevisionTemplateResponseArgs' template: Template holds the latest specification for the Revision to be stamped out.
        :param Sequence['TrafficTargetResponseArgs'] traffic: Traffic specifies how to distribute traffic over a collection of Knative Revisions and Configurations.
        """
        pulumi.set(__self__, "generation", generation)
        pulumi.set(__self__, "manual", manual)
        pulumi.set(__self__, "pinned", pinned)
        pulumi.set(__self__, "release", release)
        pulumi.set(__self__, "run_latest", run_latest)
        pulumi.set(__self__, "template", template)
        pulumi.set(__self__, "traffic", traffic)

    @property
    @pulumi.getter
    def generation(self) -> int:
        """
        Deprecated and not currently populated by Cloud Run. See metadata.generation instead, which is the sequence number containing the latest generation of the desired state. Read-only.
        """
        return pulumi.get(self, "generation")

    @property
    @pulumi.getter
    def manual(self) -> 'outputs.ServiceSpecManualTypeResponse':
        """
        Manual contains the options for configuring a manual service. See ServiceSpec for more details. Not currently supported by Cloud Run.
        """
        return pulumi.get(self, "manual")

    @property
    @pulumi.getter
    def pinned(self) -> 'outputs.ServiceSpecPinnedTypeResponse':
        """
        Pins this service to a specific revision name. The revision must be owned by the configuration provided. Deprecated and not supported by Cloud Run. +optional
        """
        return pulumi.get(self, "pinned")

    @property
    @pulumi.getter
    def release(self) -> 'outputs.ServiceSpecReleaseTypeResponse':
        """
        Release enables gradual promotion of new revisions by allowing traffic to be split between two revisions. This type replaces the deprecated Pinned type. Not currently supported by Cloud Run.
        """
        return pulumi.get(self, "release")

    @property
    @pulumi.getter(name="runLatest")
    def run_latest(self) -> 'outputs.ServiceSpecRunLatestResponse':
        """
        RunLatest defines a simple Service. It will automatically configure a route that keeps the latest ready revision from the supplied configuration running. +optional
        """
        return pulumi.get(self, "run_latest")

    @property
    @pulumi.getter
    def template(self) -> 'outputs.RevisionTemplateResponse':
        """
        Template holds the latest specification for the Revision to be stamped out.
        """
        return pulumi.get(self, "template")

    @property
    @pulumi.getter
    def traffic(self) -> Sequence['outputs.TrafficTargetResponse']:
        """
        Traffic specifies how to distribute traffic over a collection of Knative Revisions and Configurations.
        """
        return pulumi.get(self, "traffic")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceSpecRunLatestResponse(dict):
    """
    ServiceSpecRunLatest contains the options for always having a route to the latest configuration. See ServiceSpec for more details.
    """
    def __init__(__self__, *,
                 configuration: 'outputs.ConfigurationSpecResponse'):
        """
        ServiceSpecRunLatest contains the options for always having a route to the latest configuration. See ServiceSpec for more details.
        :param 'ConfigurationSpecResponseArgs' configuration: The configuration for this service.
        """
        pulumi.set(__self__, "configuration", configuration)

    @property
    @pulumi.getter
    def configuration(self) -> 'outputs.ConfigurationSpecResponse':
        """
        The configuration for this service.
        """
        return pulumi.get(self, "configuration")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ServiceStatusResponse(dict):
    """
    The current state of the Service. Output only.
    """
    def __init__(__self__, *,
                 address: 'outputs.AddressableResponse',
                 conditions: Sequence['outputs.ServiceConditionResponse'],
                 domain: str,
                 latest_created_revision_name: str,
                 latest_ready_revision_name: str,
                 observed_generation: int,
                 traffic: Sequence['outputs.TrafficTargetResponse'],
                 url: str):
        """
        The current state of the Service. Output only.
        :param 'AddressableResponseArgs' address: From RouteStatus. Similar to url, information on where the service is available on HTTP.
        :param Sequence['ServiceConditionResponseArgs'] conditions: Conditions communicates information about ongoing/complete reconciliation processes that bring the "spec" inline with the observed state of the world.
        :param str domain: From RouteStatus. Domain holds the top-level domain that will distribute traffic over the provided targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        :param str latest_created_revision_name: From ConfigurationStatus. LatestCreatedRevisionName is the last revision that was created from this Service's Configuration. It might not be ready yet, for that use LatestReadyRevisionName.
        :param str latest_ready_revision_name: From ConfigurationStatus. LatestReadyRevisionName holds the name of the latest Revision stamped out from this Service's Configuration that has had its "Ready" condition become "True".
        :param int observed_generation: ObservedGeneration is the 'Generation' of the Route that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        :param Sequence['TrafficTargetResponseArgs'] traffic: From RouteStatus. Traffic holds the configured traffic distribution. These entries will always contain RevisionName references. When ConfigurationName appears in the spec, this will hold the LatestReadyRevisionName that we last observed.
        :param str url: From RouteStatus. URL holds the url that will distribute traffic over the provided traffic targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "conditions", conditions)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "latest_created_revision_name", latest_created_revision_name)
        pulumi.set(__self__, "latest_ready_revision_name", latest_ready_revision_name)
        pulumi.set(__self__, "observed_generation", observed_generation)
        pulumi.set(__self__, "traffic", traffic)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def address(self) -> 'outputs.AddressableResponse':
        """
        From RouteStatus. Similar to url, information on where the service is available on HTTP.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def conditions(self) -> Sequence['outputs.ServiceConditionResponse']:
        """
        Conditions communicates information about ongoing/complete reconciliation processes that bring the "spec" inline with the observed state of the world.
        """
        return pulumi.get(self, "conditions")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        From RouteStatus. Domain holds the top-level domain that will distribute traffic over the provided targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="latestCreatedRevisionName")
    def latest_created_revision_name(self) -> str:
        """
        From ConfigurationStatus. LatestCreatedRevisionName is the last revision that was created from this Service's Configuration. It might not be ready yet, for that use LatestReadyRevisionName.
        """
        return pulumi.get(self, "latest_created_revision_name")

    @property
    @pulumi.getter(name="latestReadyRevisionName")
    def latest_ready_revision_name(self) -> str:
        """
        From ConfigurationStatus. LatestReadyRevisionName holds the name of the latest Revision stamped out from this Service's Configuration that has had its "Ready" condition become "True".
        """
        return pulumi.get(self, "latest_ready_revision_name")

    @property
    @pulumi.getter(name="observedGeneration")
    def observed_generation(self) -> int:
        """
        ObservedGeneration is the 'Generation' of the Route that was last processed by the controller. Clients polling for completed reconciliation should poll until observedGeneration = metadata.generation and the Ready condition's status is True or False.
        """
        return pulumi.get(self, "observed_generation")

    @property
    @pulumi.getter
    def traffic(self) -> Sequence['outputs.TrafficTargetResponse']:
        """
        From RouteStatus. Traffic holds the configured traffic distribution. These entries will always contain RevisionName references. When ConfigurationName appears in the spec, this will hold the LatestReadyRevisionName that we last observed.
        """
        return pulumi.get(self, "traffic")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        From RouteStatus. URL holds the url that will distribute traffic over the provided traffic targets. It generally has the form https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app
        """
        return pulumi.get(self, "url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TCPSocketActionResponse(dict):
    """
    TCPSocketAction describes an action based on opening a socket
    """
    def __init__(__self__, *,
                 host: str,
                 port: 'outputs.IntOrStringResponse'):
        """
        TCPSocketAction describes an action based on opening a socket
        :param str host: Optional: Host name to connect to, defaults to the pod IP. +optional
        :param 'IntOrStringResponseArgs' port: Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        pulumi.set(__self__, "host", host)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def host(self) -> str:
        """
        Optional: Host name to connect to, defaults to the pod IP. +optional
        """
        return pulumi.get(self, "host")

    @property
    @pulumi.getter
    def port(self) -> 'outputs.IntOrStringResponse':
        """
        Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
        """
        return pulumi.get(self, "port")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TrafficTargetResponse(dict):
    """
    TrafficTarget holds a single entry of the routing table for a Route.
    """
    def __init__(__self__, *,
                 configuration_name: str,
                 latest_revision: bool,
                 name: str,
                 percent: int,
                 revision_name: str,
                 tag: str,
                 url: str):
        """
        TrafficTarget holds a single entry of the routing table for a Route.
        :param str configuration_name: ConfigurationName of a configuration to whose latest revision we will send this portion of traffic. When the "status.latestReadyRevisionName" of the referenced configuration changes, we will automatically migrate traffic from the prior "latest ready" revision to the new one. This field is never set in Route's status, only its spec. This is mutually exclusive with RevisionName. Cloud Run currently supports a single ConfigurationName.
        :param bool latest_revision: LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target. When provided LatestRevision must be true if RevisionName is empty; it must be false when RevisionName is non-empty. +optional
        :param str name: Name is optionally used to expose a dedicated hostname for referencing this target exclusively. Not currently supported by Cloud Run. +optional
        :param int percent: Percent specifies percent of the traffic to this Revision or Configuration. This defaults to zero if unspecified. Cloud Run currently requires 100 percent for a single ConfigurationName TrafficTarget entry.
        :param str revision_name: RevisionName of a specific revision to which to send this portion of traffic. This is mutually exclusive with ConfigurationName. Providing RevisionName in spec is not currently supported by Cloud Run.
        :param str tag: Tag is optionally used to expose a dedicated url for referencing this target exclusively. Not currently supported in Cloud Run. +optional
        :param str url: URL displays the URL for accessing named traffic targets. URL is displayed in status, and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname, but may not contain anything else (e.g. basic auth, url path, etc. Not currently supported in Cloud Run.
        """
        pulumi.set(__self__, "configuration_name", configuration_name)
        pulumi.set(__self__, "latest_revision", latest_revision)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "percent", percent)
        pulumi.set(__self__, "revision_name", revision_name)
        pulumi.set(__self__, "tag", tag)
        pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="configurationName")
    def configuration_name(self) -> str:
        """
        ConfigurationName of a configuration to whose latest revision we will send this portion of traffic. When the "status.latestReadyRevisionName" of the referenced configuration changes, we will automatically migrate traffic from the prior "latest ready" revision to the new one. This field is never set in Route's status, only its spec. This is mutually exclusive with RevisionName. Cloud Run currently supports a single ConfigurationName.
        """
        return pulumi.get(self, "configuration_name")

    @property
    @pulumi.getter(name="latestRevision")
    def latest_revision(self) -> bool:
        """
        LatestRevision may be optionally provided to indicate that the latest ready Revision of the Configuration should be used for this traffic target. When provided LatestRevision must be true if RevisionName is empty; it must be false when RevisionName is non-empty. +optional
        """
        return pulumi.get(self, "latest_revision")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name is optionally used to expose a dedicated hostname for referencing this target exclusively. Not currently supported by Cloud Run. +optional
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def percent(self) -> int:
        """
        Percent specifies percent of the traffic to this Revision or Configuration. This defaults to zero if unspecified. Cloud Run currently requires 100 percent for a single ConfigurationName TrafficTarget entry.
        """
        return pulumi.get(self, "percent")

    @property
    @pulumi.getter(name="revisionName")
    def revision_name(self) -> str:
        """
        RevisionName of a specific revision to which to send this portion of traffic. This is mutually exclusive with ConfigurationName. Providing RevisionName in spec is not currently supported by Cloud Run.
        """
        return pulumi.get(self, "revision_name")

    @property
    @pulumi.getter
    def tag(self) -> str:
        """
        Tag is optionally used to expose a dedicated url for referencing this target exclusively. Not currently supported in Cloud Run. +optional
        """
        return pulumi.get(self, "tag")

    @property
    @pulumi.getter
    def url(self) -> str:
        """
        URL displays the URL for accessing named traffic targets. URL is displayed in status, and is disallowed on spec. URL must contain a scheme (e.g. http://) and a hostname, but may not contain anything else (e.g. basic auth, url path, etc. Not currently supported in Cloud Run.
        """
        return pulumi.get(self, "url")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VolumeDeviceResponse(dict):
    """
    volumeDevice describes a mapping of a raw block device within a container.
    """
    def __init__(__self__, *,
                 device_path: str,
                 name: str):
        """
        volumeDevice describes a mapping of a raw block device within a container.
        :param str device_path: devicePath is the path inside of the container that the device will be mapped to.
        :param str name: name must match the name of a persistentVolumeClaim in the pod
        """
        pulumi.set(__self__, "device_path", device_path)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="devicePath")
    def device_path(self) -> str:
        """
        devicePath is the path inside of the container that the device will be mapped to.
        """
        return pulumi.get(self, "device_path")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        name must match the name of a persistentVolumeClaim in the pod
        """
        return pulumi.get(self, "name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VolumeMountResponse(dict):
    """
    VolumeMount describes a mounting of a Volume within a container.
    """
    def __init__(__self__, *,
                 mount_path: str,
                 mount_propagation: str,
                 name: str,
                 read_only: bool,
                 sub_path: str):
        """
        VolumeMount describes a mounting of a Volume within a container.
        :param str mount_path: Path within the container at which the volume should be mounted. Must not contain ':'.
        :param str mount_propagation: mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationHostToContainer is used. This field is beta in 1.10. +optional
        :param str name: This must match the Name of a Volume.
        :param bool read_only: Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. +optional
        :param str sub_path: Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root). +optional
        """
        pulumi.set(__self__, "mount_path", mount_path)
        pulumi.set(__self__, "mount_propagation", mount_propagation)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "read_only", read_only)
        pulumi.set(__self__, "sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        Path within the container at which the volume should be mounted. Must not contain ':'.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="mountPropagation")
    def mount_propagation(self) -> str:
        """
        mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationHostToContainer is used. This field is beta in 1.10. +optional
        """
        return pulumi.get(self, "mount_propagation")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        This must match the Name of a Volume.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="readOnly")
    def read_only(self) -> bool:
        """
        Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false. +optional
        """
        return pulumi.get(self, "read_only")

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> str:
        """
        Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root). +optional
        """
        return pulumi.get(self, "sub_path")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class VolumeResponse(dict):
    """
    Volume represents a named volume in a container.
    """
    def __init__(__self__, *,
                 config_map: 'outputs.ConfigMapVolumeSourceResponse',
                 name: str,
                 secret: 'outputs.SecretVolumeSourceResponse'):
        """
        Volume represents a named volume in a container.
        :param str name: Volume's name.
        """
        pulumi.set(__self__, "config_map", config_map)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "secret", secret)

    @property
    @pulumi.getter(name="configMap")
    def config_map(self) -> 'outputs.ConfigMapVolumeSourceResponse':
        return pulumi.get(self, "config_map")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Volume's name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def secret(self) -> 'outputs.SecretVolumeSourceResponse':
        return pulumi.get(self, "secret")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


