# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from ._inputs import *

__all__ = ['SiteVersion']


class SiteVersion(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[pulumi.InputType['ServingConfigArgs']]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 create_user: Optional[pulumi.Input[pulumi.InputType['ActingUserArgs']]] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 delete_user: Optional[pulumi.Input[pulumi.InputType['ActingUserArgs']]] = None,
                 file_count: Optional[pulumi.Input[str]] = None,
                 finalize_time: Optional[pulumi.Input[str]] = None,
                 finalize_user: Optional[pulumi.Input[pulumi.InputType['ActingUserArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 preview: Optional[pulumi.Input[pulumi.InputType['PreviewConfigArgs']]] = None,
                 sites_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 version_bytes: Optional[pulumi.Input[str]] = None,
                 versions_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a new version for the specified site.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['ServingConfigArgs']] config: The configuration for the behavior of the site. This configuration exists in the [`firebase.json`](https://firebase.google.com/docs/cli/#the_firebasejson_file) file.
        :param pulumi.Input[str] create_time: The time at which the version was created.
        :param pulumi.Input[pulumi.InputType['ActingUserArgs']] create_user: Identifies the user who created the version.
        :param pulumi.Input[str] delete_time: The time at which the version was `DELETED`.
        :param pulumi.Input[pulumi.InputType['ActingUserArgs']] delete_user: Identifies the user who `DELETED` the version.
        :param pulumi.Input[str] file_count: The total number of files associated with the version. This value is calculated after a version is `FINALIZED`.
        :param pulumi.Input[str] finalize_time: The time at which the version was `FINALIZED`.
        :param pulumi.Input[pulumi.InputType['ActingUserArgs']] finalize_user: Identifies the user who `FINALIZED` the version.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: The labels used for extra metadata and/or filtering.
        :param pulumi.Input[str] name: The fully-qualified resource name for the version, in the format: sites/ SITE_ID/versions/VERSION_ID This name is provided in the response body when you call [`CreateVersion`](sites.versions/create).
        :param pulumi.Input[pulumi.InputType['PreviewConfigArgs']] preview: Deprecated in favor of [site channels](sites.channels).
        :param pulumi.Input[str] status: The deploy status of the version. For a successful deploy, call [`CreateVersion`](sites.versions/create) to make a new version (`CREATED` status), [upload all desired files](sites.versions/populateFiles) to the version, then [update](sites.versions/patch) the version to the `FINALIZED` status. Note that if you leave the version in the `CREATED` state for more than 12 hours, the system will automatically mark the version as `ABANDONED`. You can also change the status of a version to `DELETED` by calling [`DeleteVersion`](sites.versions/delete).
        :param pulumi.Input[str] version_bytes: The total stored bytesize of the version. This value is calculated after a version is `FINALIZED`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['config'] = config
            __props__['create_time'] = create_time
            __props__['create_user'] = create_user
            __props__['delete_time'] = delete_time
            __props__['delete_user'] = delete_user
            __props__['file_count'] = file_count
            __props__['finalize_time'] = finalize_time
            __props__['finalize_user'] = finalize_user
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['preview'] = preview
            if sites_id is None and not opts.urn:
                raise TypeError("Missing required property 'sites_id'")
            __props__['sites_id'] = sites_id
            __props__['status'] = status
            __props__['version_bytes'] = version_bytes
            if versions_id is None and not opts.urn:
                raise TypeError("Missing required property 'versions_id'")
            __props__['versions_id'] = versions_id
        super(SiteVersion, __self__).__init__(
            'gcp-native:firebasehosting/v1beta1:SiteVersion',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SiteVersion':
        """
        Get an existing SiteVersion resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        return SiteVersion(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

