# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'AnalyticsInfoArgs',
    'AndroidInfoArgs',
    'DesktopInfoArgs',
    'DynamicLinkInfoArgs',
    'GooglePlayAnalyticsArgs',
    'ITunesConnectAnalyticsArgs',
    'IosInfoArgs',
    'NavigationInfoArgs',
    'SocialMetaTagInfoArgs',
    'SuffixArgs',
]

@pulumi.input_type
class AnalyticsInfoArgs:
    def __init__(__self__, *,
                 google_play_analytics: Optional[pulumi.Input['GooglePlayAnalyticsArgs']] = None,
                 itunes_connect_analytics: Optional[pulumi.Input['ITunesConnectAnalyticsArgs']] = None):
        """
        Tracking parameters supported by Dynamic Link.
        :param pulumi.Input['GooglePlayAnalyticsArgs'] google_play_analytics: Google Play Campaign Measurements.
        :param pulumi.Input['ITunesConnectAnalyticsArgs'] itunes_connect_analytics: iTunes Connect App Analytics.
        """
        if google_play_analytics is not None:
            pulumi.set(__self__, "google_play_analytics", google_play_analytics)
        if itunes_connect_analytics is not None:
            pulumi.set(__self__, "itunes_connect_analytics", itunes_connect_analytics)

    @property
    @pulumi.getter(name="googlePlayAnalytics")
    def google_play_analytics(self) -> Optional[pulumi.Input['GooglePlayAnalyticsArgs']]:
        """
        Google Play Campaign Measurements.
        """
        return pulumi.get(self, "google_play_analytics")

    @google_play_analytics.setter
    def google_play_analytics(self, value: Optional[pulumi.Input['GooglePlayAnalyticsArgs']]):
        pulumi.set(self, "google_play_analytics", value)

    @property
    @pulumi.getter(name="itunesConnectAnalytics")
    def itunes_connect_analytics(self) -> Optional[pulumi.Input['ITunesConnectAnalyticsArgs']]:
        """
        iTunes Connect App Analytics.
        """
        return pulumi.get(self, "itunes_connect_analytics")

    @itunes_connect_analytics.setter
    def itunes_connect_analytics(self, value: Optional[pulumi.Input['ITunesConnectAnalyticsArgs']]):
        pulumi.set(self, "itunes_connect_analytics", value)


@pulumi.input_type
class AndroidInfoArgs:
    def __init__(__self__, *,
                 android_fallback_link: Optional[pulumi.Input[str]] = None,
                 android_link: Optional[pulumi.Input[str]] = None,
                 android_min_package_version_code: Optional[pulumi.Input[str]] = None,
                 android_package_name: Optional[pulumi.Input[str]] = None):
        """
        Android related attributes to the Dynamic Link.
        :param pulumi.Input[str] android_fallback_link: Link to open on Android if the app is not installed.
        :param pulumi.Input[str] android_link: If specified, this overrides the ‘link’ parameter on Android.
        :param pulumi.Input[str] android_min_package_version_code: Minimum version code for the Android app. If the installed app’s version code is lower, then the user is taken to the Play Store.
        :param pulumi.Input[str] android_package_name: Android package name of the app.
        """
        if android_fallback_link is not None:
            pulumi.set(__self__, "android_fallback_link", android_fallback_link)
        if android_link is not None:
            pulumi.set(__self__, "android_link", android_link)
        if android_min_package_version_code is not None:
            pulumi.set(__self__, "android_min_package_version_code", android_min_package_version_code)
        if android_package_name is not None:
            pulumi.set(__self__, "android_package_name", android_package_name)

    @property
    @pulumi.getter(name="androidFallbackLink")
    def android_fallback_link(self) -> Optional[pulumi.Input[str]]:
        """
        Link to open on Android if the app is not installed.
        """
        return pulumi.get(self, "android_fallback_link")

    @android_fallback_link.setter
    def android_fallback_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "android_fallback_link", value)

    @property
    @pulumi.getter(name="androidLink")
    def android_link(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, this overrides the ‘link’ parameter on Android.
        """
        return pulumi.get(self, "android_link")

    @android_link.setter
    def android_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "android_link", value)

    @property
    @pulumi.getter(name="androidMinPackageVersionCode")
    def android_min_package_version_code(self) -> Optional[pulumi.Input[str]]:
        """
        Minimum version code for the Android app. If the installed app’s version code is lower, then the user is taken to the Play Store.
        """
        return pulumi.get(self, "android_min_package_version_code")

    @android_min_package_version_code.setter
    def android_min_package_version_code(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "android_min_package_version_code", value)

    @property
    @pulumi.getter(name="androidPackageName")
    def android_package_name(self) -> Optional[pulumi.Input[str]]:
        """
        Android package name of the app.
        """
        return pulumi.get(self, "android_package_name")

    @android_package_name.setter
    def android_package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "android_package_name", value)


@pulumi.input_type
class DesktopInfoArgs:
    def __init__(__self__, *,
                 desktop_fallback_link: Optional[pulumi.Input[str]] = None):
        """
        Desktop related attributes to the Dynamic Link.
        :param pulumi.Input[str] desktop_fallback_link: Link to open on desktop.
        """
        if desktop_fallback_link is not None:
            pulumi.set(__self__, "desktop_fallback_link", desktop_fallback_link)

    @property
    @pulumi.getter(name="desktopFallbackLink")
    def desktop_fallback_link(self) -> Optional[pulumi.Input[str]]:
        """
        Link to open on desktop.
        """
        return pulumi.get(self, "desktop_fallback_link")

    @desktop_fallback_link.setter
    def desktop_fallback_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "desktop_fallback_link", value)


@pulumi.input_type
class DynamicLinkInfoArgs:
    def __init__(__self__, *,
                 analytics_info: Optional[pulumi.Input['AnalyticsInfoArgs']] = None,
                 android_info: Optional[pulumi.Input['AndroidInfoArgs']] = None,
                 desktop_info: Optional[pulumi.Input['DesktopInfoArgs']] = None,
                 domain_uri_prefix: Optional[pulumi.Input[str]] = None,
                 dynamic_link_domain: Optional[pulumi.Input[str]] = None,
                 ios_info: Optional[pulumi.Input['IosInfoArgs']] = None,
                 link: Optional[pulumi.Input[str]] = None,
                 navigation_info: Optional[pulumi.Input['NavigationInfoArgs']] = None,
                 social_meta_tag_info: Optional[pulumi.Input['SocialMetaTagInfoArgs']] = None):
        """
        Information about a Dynamic Link.
        :param pulumi.Input['AnalyticsInfoArgs'] analytics_info: Parameters used for tracking. See all tracking parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually).
        :param pulumi.Input['AndroidInfoArgs'] android_info: Android related information. See Android related parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually).
        :param pulumi.Input['DesktopInfoArgs'] desktop_info: Desktop related information. See desktop related parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually).
        :param pulumi.Input[str] domain_uri_prefix: E.g. https://maps.app.goo.gl, https://maps.page.link, https://g.co/maps More examples can be found in description of getNormalizedUriPrefix in j/c/g/firebase/dynamiclinks/uri/DdlDomain.java Will fallback to dynamic_link_domain is this field is missing
        :param pulumi.Input[str] dynamic_link_domain: Dynamic Links domain that the project owns, e.g. abcd.app.goo.gl [Learn more](https://firebase.google.com/docs/dynamic-links/android/receive) on how to set up Dynamic Link domain associated with your Firebase project. Required if missing domain_uri_prefix.
        :param pulumi.Input['IosInfoArgs'] ios_info: iOS related information. See iOS related parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually).
        :param pulumi.Input[str] link: The link your app will open, You can specify any URL your app can handle. This link must be a well-formatted URL, be properly URL-encoded, and use the HTTP or HTTPS scheme. See 'link' parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually). Required.
        :param pulumi.Input['NavigationInfoArgs'] navigation_info: Information of navigation behavior of a Firebase Dynamic Links.
        :param pulumi.Input['SocialMetaTagInfoArgs'] social_meta_tag_info: Parameters for social meta tag params. Used to set meta tag data for link previews on social sites.
        """
        if analytics_info is not None:
            pulumi.set(__self__, "analytics_info", analytics_info)
        if android_info is not None:
            pulumi.set(__self__, "android_info", android_info)
        if desktop_info is not None:
            pulumi.set(__self__, "desktop_info", desktop_info)
        if domain_uri_prefix is not None:
            pulumi.set(__self__, "domain_uri_prefix", domain_uri_prefix)
        if dynamic_link_domain is not None:
            pulumi.set(__self__, "dynamic_link_domain", dynamic_link_domain)
        if ios_info is not None:
            pulumi.set(__self__, "ios_info", ios_info)
        if link is not None:
            pulumi.set(__self__, "link", link)
        if navigation_info is not None:
            pulumi.set(__self__, "navigation_info", navigation_info)
        if social_meta_tag_info is not None:
            pulumi.set(__self__, "social_meta_tag_info", social_meta_tag_info)

    @property
    @pulumi.getter(name="analyticsInfo")
    def analytics_info(self) -> Optional[pulumi.Input['AnalyticsInfoArgs']]:
        """
        Parameters used for tracking. See all tracking parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually).
        """
        return pulumi.get(self, "analytics_info")

    @analytics_info.setter
    def analytics_info(self, value: Optional[pulumi.Input['AnalyticsInfoArgs']]):
        pulumi.set(self, "analytics_info", value)

    @property
    @pulumi.getter(name="androidInfo")
    def android_info(self) -> Optional[pulumi.Input['AndroidInfoArgs']]:
        """
        Android related information. See Android related parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually).
        """
        return pulumi.get(self, "android_info")

    @android_info.setter
    def android_info(self, value: Optional[pulumi.Input['AndroidInfoArgs']]):
        pulumi.set(self, "android_info", value)

    @property
    @pulumi.getter(name="desktopInfo")
    def desktop_info(self) -> Optional[pulumi.Input['DesktopInfoArgs']]:
        """
        Desktop related information. See desktop related parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually).
        """
        return pulumi.get(self, "desktop_info")

    @desktop_info.setter
    def desktop_info(self, value: Optional[pulumi.Input['DesktopInfoArgs']]):
        pulumi.set(self, "desktop_info", value)

    @property
    @pulumi.getter(name="domainUriPrefix")
    def domain_uri_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        E.g. https://maps.app.goo.gl, https://maps.page.link, https://g.co/maps More examples can be found in description of getNormalizedUriPrefix in j/c/g/firebase/dynamiclinks/uri/DdlDomain.java Will fallback to dynamic_link_domain is this field is missing
        """
        return pulumi.get(self, "domain_uri_prefix")

    @domain_uri_prefix.setter
    def domain_uri_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain_uri_prefix", value)

    @property
    @pulumi.getter(name="dynamicLinkDomain")
    def dynamic_link_domain(self) -> Optional[pulumi.Input[str]]:
        """
        Dynamic Links domain that the project owns, e.g. abcd.app.goo.gl [Learn more](https://firebase.google.com/docs/dynamic-links/android/receive) on how to set up Dynamic Link domain associated with your Firebase project. Required if missing domain_uri_prefix.
        """
        return pulumi.get(self, "dynamic_link_domain")

    @dynamic_link_domain.setter
    def dynamic_link_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dynamic_link_domain", value)

    @property
    @pulumi.getter(name="iosInfo")
    def ios_info(self) -> Optional[pulumi.Input['IosInfoArgs']]:
        """
        iOS related information. See iOS related parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually).
        """
        return pulumi.get(self, "ios_info")

    @ios_info.setter
    def ios_info(self, value: Optional[pulumi.Input['IosInfoArgs']]):
        pulumi.set(self, "ios_info", value)

    @property
    @pulumi.getter
    def link(self) -> Optional[pulumi.Input[str]]:
        """
        The link your app will open, You can specify any URL your app can handle. This link must be a well-formatted URL, be properly URL-encoded, and use the HTTP or HTTPS scheme. See 'link' parameters in the [documentation](https://firebase.google.com/docs/dynamic-links/create-manually). Required.
        """
        return pulumi.get(self, "link")

    @link.setter
    def link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "link", value)

    @property
    @pulumi.getter(name="navigationInfo")
    def navigation_info(self) -> Optional[pulumi.Input['NavigationInfoArgs']]:
        """
        Information of navigation behavior of a Firebase Dynamic Links.
        """
        return pulumi.get(self, "navigation_info")

    @navigation_info.setter
    def navigation_info(self, value: Optional[pulumi.Input['NavigationInfoArgs']]):
        pulumi.set(self, "navigation_info", value)

    @property
    @pulumi.getter(name="socialMetaTagInfo")
    def social_meta_tag_info(self) -> Optional[pulumi.Input['SocialMetaTagInfoArgs']]:
        """
        Parameters for social meta tag params. Used to set meta tag data for link previews on social sites.
        """
        return pulumi.get(self, "social_meta_tag_info")

    @social_meta_tag_info.setter
    def social_meta_tag_info(self, value: Optional[pulumi.Input['SocialMetaTagInfoArgs']]):
        pulumi.set(self, "social_meta_tag_info", value)


@pulumi.input_type
class GooglePlayAnalyticsArgs:
    def __init__(__self__, *,
                 gclid: Optional[pulumi.Input[str]] = None,
                 utm_campaign: Optional[pulumi.Input[str]] = None,
                 utm_content: Optional[pulumi.Input[str]] = None,
                 utm_medium: Optional[pulumi.Input[str]] = None,
                 utm_source: Optional[pulumi.Input[str]] = None,
                 utm_term: Optional[pulumi.Input[str]] = None):
        """
        Parameters for Google Play Campaign Measurements. [Learn more](https://developers.google.com/analytics/devguides/collection/android/v4/campaigns#campaign-params)
        :param pulumi.Input[str] gclid: [AdWords autotagging parameter](https://support.google.com/analytics/answer/1033981?hl=en); used to measure Google AdWords ads. This value is generated dynamically and should never be modified.
        :param pulumi.Input[str] utm_campaign: Campaign name; used for keyword analysis to identify a specific product promotion or strategic campaign.
        :param pulumi.Input[str] utm_content: Campaign content; used for A/B testing and content-targeted ads to differentiate ads or links that point to the same URL.
        :param pulumi.Input[str] utm_medium: Campaign medium; used to identify a medium such as email or cost-per-click.
        :param pulumi.Input[str] utm_source: Campaign source; used to identify a search engine, newsletter, or other source.
        :param pulumi.Input[str] utm_term: Campaign term; used with paid search to supply the keywords for ads.
        """
        if gclid is not None:
            pulumi.set(__self__, "gclid", gclid)
        if utm_campaign is not None:
            pulumi.set(__self__, "utm_campaign", utm_campaign)
        if utm_content is not None:
            pulumi.set(__self__, "utm_content", utm_content)
        if utm_medium is not None:
            pulumi.set(__self__, "utm_medium", utm_medium)
        if utm_source is not None:
            pulumi.set(__self__, "utm_source", utm_source)
        if utm_term is not None:
            pulumi.set(__self__, "utm_term", utm_term)

    @property
    @pulumi.getter
    def gclid(self) -> Optional[pulumi.Input[str]]:
        """
        [AdWords autotagging parameter](https://support.google.com/analytics/answer/1033981?hl=en); used to measure Google AdWords ads. This value is generated dynamically and should never be modified.
        """
        return pulumi.get(self, "gclid")

    @gclid.setter
    def gclid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gclid", value)

    @property
    @pulumi.getter(name="utmCampaign")
    def utm_campaign(self) -> Optional[pulumi.Input[str]]:
        """
        Campaign name; used for keyword analysis to identify a specific product promotion or strategic campaign.
        """
        return pulumi.get(self, "utm_campaign")

    @utm_campaign.setter
    def utm_campaign(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "utm_campaign", value)

    @property
    @pulumi.getter(name="utmContent")
    def utm_content(self) -> Optional[pulumi.Input[str]]:
        """
        Campaign content; used for A/B testing and content-targeted ads to differentiate ads or links that point to the same URL.
        """
        return pulumi.get(self, "utm_content")

    @utm_content.setter
    def utm_content(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "utm_content", value)

    @property
    @pulumi.getter(name="utmMedium")
    def utm_medium(self) -> Optional[pulumi.Input[str]]:
        """
        Campaign medium; used to identify a medium such as email or cost-per-click.
        """
        return pulumi.get(self, "utm_medium")

    @utm_medium.setter
    def utm_medium(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "utm_medium", value)

    @property
    @pulumi.getter(name="utmSource")
    def utm_source(self) -> Optional[pulumi.Input[str]]:
        """
        Campaign source; used to identify a search engine, newsletter, or other source.
        """
        return pulumi.get(self, "utm_source")

    @utm_source.setter
    def utm_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "utm_source", value)

    @property
    @pulumi.getter(name="utmTerm")
    def utm_term(self) -> Optional[pulumi.Input[str]]:
        """
        Campaign term; used with paid search to supply the keywords for ads.
        """
        return pulumi.get(self, "utm_term")

    @utm_term.setter
    def utm_term(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "utm_term", value)


@pulumi.input_type
class ITunesConnectAnalyticsArgs:
    def __init__(__self__, *,
                 at: Optional[pulumi.Input[str]] = None,
                 ct: Optional[pulumi.Input[str]] = None,
                 mt: Optional[pulumi.Input[str]] = None,
                 pt: Optional[pulumi.Input[str]] = None):
        """
        Parameters for iTunes Connect App Analytics.
        :param pulumi.Input[str] at: Affiliate token used to create affiliate-coded links.
        :param pulumi.Input[str] ct: Campaign text that developers can optionally add to any link in order to track sales from a specific marketing campaign.
        :param pulumi.Input[str] mt: iTune media types, including music, podcasts, audiobooks and so on.
        :param pulumi.Input[str] pt: Provider token that enables analytics for Dynamic Links from within iTunes Connect.
        """
        if at is not None:
            pulumi.set(__self__, "at", at)
        if ct is not None:
            pulumi.set(__self__, "ct", ct)
        if mt is not None:
            pulumi.set(__self__, "mt", mt)
        if pt is not None:
            pulumi.set(__self__, "pt", pt)

    @property
    @pulumi.getter
    def at(self) -> Optional[pulumi.Input[str]]:
        """
        Affiliate token used to create affiliate-coded links.
        """
        return pulumi.get(self, "at")

    @at.setter
    def at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "at", value)

    @property
    @pulumi.getter
    def ct(self) -> Optional[pulumi.Input[str]]:
        """
        Campaign text that developers can optionally add to any link in order to track sales from a specific marketing campaign.
        """
        return pulumi.get(self, "ct")

    @ct.setter
    def ct(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ct", value)

    @property
    @pulumi.getter
    def mt(self) -> Optional[pulumi.Input[str]]:
        """
        iTune media types, including music, podcasts, audiobooks and so on.
        """
        return pulumi.get(self, "mt")

    @mt.setter
    def mt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mt", value)

    @property
    @pulumi.getter
    def pt(self) -> Optional[pulumi.Input[str]]:
        """
        Provider token that enables analytics for Dynamic Links from within iTunes Connect.
        """
        return pulumi.get(self, "pt")

    @pt.setter
    def pt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pt", value)


@pulumi.input_type
class IosInfoArgs:
    def __init__(__self__, *,
                 ios_app_store_id: Optional[pulumi.Input[str]] = None,
                 ios_bundle_id: Optional[pulumi.Input[str]] = None,
                 ios_custom_scheme: Optional[pulumi.Input[str]] = None,
                 ios_fallback_link: Optional[pulumi.Input[str]] = None,
                 ios_ipad_bundle_id: Optional[pulumi.Input[str]] = None,
                 ios_ipad_fallback_link: Optional[pulumi.Input[str]] = None,
                 ios_minimum_version: Optional[pulumi.Input[str]] = None):
        """
        iOS related attributes to the Dynamic Link..
        :param pulumi.Input[str] ios_app_store_id: iOS App Store ID.
        :param pulumi.Input[str] ios_bundle_id: iOS bundle ID of the app.
        :param pulumi.Input[str] ios_custom_scheme: Custom (destination) scheme to use for iOS. By default, we’ll use the bundle ID as the custom scheme. Developer can override this behavior using this param.
        :param pulumi.Input[str] ios_fallback_link: Link to open on iOS if the app is not installed.
        :param pulumi.Input[str] ios_ipad_bundle_id: iPad bundle ID of the app.
        :param pulumi.Input[str] ios_ipad_fallback_link: If specified, this overrides the ios_fallback_link value on iPads.
        :param pulumi.Input[str] ios_minimum_version: iOS minimum version.
        """
        if ios_app_store_id is not None:
            pulumi.set(__self__, "ios_app_store_id", ios_app_store_id)
        if ios_bundle_id is not None:
            pulumi.set(__self__, "ios_bundle_id", ios_bundle_id)
        if ios_custom_scheme is not None:
            pulumi.set(__self__, "ios_custom_scheme", ios_custom_scheme)
        if ios_fallback_link is not None:
            pulumi.set(__self__, "ios_fallback_link", ios_fallback_link)
        if ios_ipad_bundle_id is not None:
            pulumi.set(__self__, "ios_ipad_bundle_id", ios_ipad_bundle_id)
        if ios_ipad_fallback_link is not None:
            pulumi.set(__self__, "ios_ipad_fallback_link", ios_ipad_fallback_link)
        if ios_minimum_version is not None:
            pulumi.set(__self__, "ios_minimum_version", ios_minimum_version)

    @property
    @pulumi.getter(name="iosAppStoreId")
    def ios_app_store_id(self) -> Optional[pulumi.Input[str]]:
        """
        iOS App Store ID.
        """
        return pulumi.get(self, "ios_app_store_id")

    @ios_app_store_id.setter
    def ios_app_store_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ios_app_store_id", value)

    @property
    @pulumi.getter(name="iosBundleId")
    def ios_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        iOS bundle ID of the app.
        """
        return pulumi.get(self, "ios_bundle_id")

    @ios_bundle_id.setter
    def ios_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ios_bundle_id", value)

    @property
    @pulumi.getter(name="iosCustomScheme")
    def ios_custom_scheme(self) -> Optional[pulumi.Input[str]]:
        """
        Custom (destination) scheme to use for iOS. By default, we’ll use the bundle ID as the custom scheme. Developer can override this behavior using this param.
        """
        return pulumi.get(self, "ios_custom_scheme")

    @ios_custom_scheme.setter
    def ios_custom_scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ios_custom_scheme", value)

    @property
    @pulumi.getter(name="iosFallbackLink")
    def ios_fallback_link(self) -> Optional[pulumi.Input[str]]:
        """
        Link to open on iOS if the app is not installed.
        """
        return pulumi.get(self, "ios_fallback_link")

    @ios_fallback_link.setter
    def ios_fallback_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ios_fallback_link", value)

    @property
    @pulumi.getter(name="iosIpadBundleId")
    def ios_ipad_bundle_id(self) -> Optional[pulumi.Input[str]]:
        """
        iPad bundle ID of the app.
        """
        return pulumi.get(self, "ios_ipad_bundle_id")

    @ios_ipad_bundle_id.setter
    def ios_ipad_bundle_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ios_ipad_bundle_id", value)

    @property
    @pulumi.getter(name="iosIpadFallbackLink")
    def ios_ipad_fallback_link(self) -> Optional[pulumi.Input[str]]:
        """
        If specified, this overrides the ios_fallback_link value on iPads.
        """
        return pulumi.get(self, "ios_ipad_fallback_link")

    @ios_ipad_fallback_link.setter
    def ios_ipad_fallback_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ios_ipad_fallback_link", value)

    @property
    @pulumi.getter(name="iosMinimumVersion")
    def ios_minimum_version(self) -> Optional[pulumi.Input[str]]:
        """
        iOS minimum version.
        """
        return pulumi.get(self, "ios_minimum_version")

    @ios_minimum_version.setter
    def ios_minimum_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ios_minimum_version", value)


@pulumi.input_type
class NavigationInfoArgs:
    def __init__(__self__, *,
                 enable_forced_redirect: Optional[pulumi.Input[bool]] = None):
        """
        Information of navigation behavior.
        :param pulumi.Input[bool] enable_forced_redirect: If this option is on, FDL click will be forced to redirect rather than show an interstitial page.
        """
        if enable_forced_redirect is not None:
            pulumi.set(__self__, "enable_forced_redirect", enable_forced_redirect)

    @property
    @pulumi.getter(name="enableForcedRedirect")
    def enable_forced_redirect(self) -> Optional[pulumi.Input[bool]]:
        """
        If this option is on, FDL click will be forced to redirect rather than show an interstitial page.
        """
        return pulumi.get(self, "enable_forced_redirect")

    @enable_forced_redirect.setter
    def enable_forced_redirect(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_forced_redirect", value)


@pulumi.input_type
class SocialMetaTagInfoArgs:
    def __init__(__self__, *,
                 social_description: Optional[pulumi.Input[str]] = None,
                 social_image_link: Optional[pulumi.Input[str]] = None,
                 social_title: Optional[pulumi.Input[str]] = None):
        """
        Parameters for social meta tag params. Used to set meta tag data for link previews on social sites.
        :param pulumi.Input[str] social_description: A short description of the link. Optional.
        :param pulumi.Input[str] social_image_link: An image url string. Optional.
        :param pulumi.Input[str] social_title: Title to be displayed. Optional.
        """
        if social_description is not None:
            pulumi.set(__self__, "social_description", social_description)
        if social_image_link is not None:
            pulumi.set(__self__, "social_image_link", social_image_link)
        if social_title is not None:
            pulumi.set(__self__, "social_title", social_title)

    @property
    @pulumi.getter(name="socialDescription")
    def social_description(self) -> Optional[pulumi.Input[str]]:
        """
        A short description of the link. Optional.
        """
        return pulumi.get(self, "social_description")

    @social_description.setter
    def social_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "social_description", value)

    @property
    @pulumi.getter(name="socialImageLink")
    def social_image_link(self) -> Optional[pulumi.Input[str]]:
        """
        An image url string. Optional.
        """
        return pulumi.get(self, "social_image_link")

    @social_image_link.setter
    def social_image_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "social_image_link", value)

    @property
    @pulumi.getter(name="socialTitle")
    def social_title(self) -> Optional[pulumi.Input[str]]:
        """
        Title to be displayed. Optional.
        """
        return pulumi.get(self, "social_title")

    @social_title.setter
    def social_title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "social_title", value)


@pulumi.input_type
class SuffixArgs:
    def __init__(__self__, *,
                 custom_suffix: Optional[pulumi.Input[str]] = None,
                 option: Optional[pulumi.Input[str]] = None):
        """
        Short Dynamic Link suffix.
        :param pulumi.Input[str] custom_suffix: Only applies to Option.CUSTOM.
        :param pulumi.Input[str] option: Suffix option.
        """
        if custom_suffix is not None:
            pulumi.set(__self__, "custom_suffix", custom_suffix)
        if option is not None:
            pulumi.set(__self__, "option", option)

    @property
    @pulumi.getter(name="customSuffix")
    def custom_suffix(self) -> Optional[pulumi.Input[str]]:
        """
        Only applies to Option.CUSTOM.
        """
        return pulumi.get(self, "custom_suffix")

    @custom_suffix.setter
    def custom_suffix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "custom_suffix", value)

    @property
    @pulumi.getter
    def option(self) -> Optional[pulumi.Input[str]]:
        """
        Suffix option.
        """
        return pulumi.get(self, "option")

    @option.setter
    def option(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "option", value)


