# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs

__all__ = [
    'AcceleratorConfigResponse',
    'AutoscalingConfigResponse',
    'BasicAutoscalingAlgorithmResponse',
    'BasicYarnAutoscalingConfigResponse',
    'BindingResponse',
    'ClusterConfigResponse',
    'ClusterMetricsResponse',
    'ClusterSelectorResponse',
    'ClusterStatusResponse',
    'DiskConfigResponse',
    'EncryptionConfigResponse',
    'EndpointConfigResponse',
    'ExprResponse',
    'GceClusterConfigResponse',
    'GkeClusterConfigResponse',
    'HadoopJobResponse',
    'HiveJobResponse',
    'IdentityConfigResponse',
    'InstanceGroupAutoscalingPolicyConfigResponse',
    'InstanceGroupConfigResponse',
    'InstanceReferenceResponse',
    'JobSchedulingResponse',
    'KerberosConfigResponse',
    'LifecycleConfigResponse',
    'LoggingConfigResponse',
    'ManagedClusterResponse',
    'ManagedGroupConfigResponse',
    'MetastoreConfigResponse',
    'NamespacedGkeDeploymentTargetResponse',
    'NodeGroupAffinityResponse',
    'NodeInitializationActionResponse',
    'OrderedJobResponse',
    'ParameterValidationResponse',
    'PigJobResponse',
    'PrestoJobResponse',
    'PySparkJobResponse',
    'QueryListResponse',
    'RegexValidationResponse',
    'ReservationAffinityResponse',
    'SecurityConfigResponse',
    'ShieldedInstanceConfigResponse',
    'SoftwareConfigResponse',
    'SparkJobResponse',
    'SparkRJobResponse',
    'SparkSqlJobResponse',
    'TemplateParameterResponse',
    'ValueValidationResponse',
    'WorkflowTemplatePlacementResponse',
]

@pulumi.output_type
class AcceleratorConfigResponse(dict):
    """
    Specifies the type and number of accelerator cards attached to the instances of an instance. See GPUs on Compute Engine (https://cloud.google.com/compute/docs/gpus/).
    """
    def __init__(__self__, *,
                 accelerator_count: int,
                 accelerator_type_uri: str):
        """
        Specifies the type and number of accelerator cards attached to the instances of an instance. See GPUs on Compute Engine (https://cloud.google.com/compute/docs/gpus/).
        :param int accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param str accelerator_type_uri: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See Compute Engine AcceleratorTypes (https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).Examples: https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 nvidia-tesla-k80Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, nvidia-tesla-k80.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type_uri", accelerator_type_uri)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> int:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorTypeUri")
    def accelerator_type_uri(self) -> str:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See Compute Engine AcceleratorTypes (https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).Examples: https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 nvidia-tesla-k80Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, nvidia-tesla-k80.
        """
        return pulumi.get(self, "accelerator_type_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class AutoscalingConfigResponse(dict):
    """
    Autoscaling Policy config associated with the cluster.
    """
    def __init__(__self__, *,
                 policy_uri: str):
        """
        Autoscaling Policy config associated with the cluster.
        :param str policy_uri: Optional. The autoscaling policy used by the cluster.Only resource names including projectid and location (region) are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id] projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]Note that the policy must be in the same project and Dataproc region.
        """
        pulumi.set(__self__, "policy_uri", policy_uri)

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> str:
        """
        Optional. The autoscaling policy used by the cluster.Only resource names including projectid and location (region) are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id] projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]Note that the policy must be in the same project and Dataproc region.
        """
        return pulumi.get(self, "policy_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BasicAutoscalingAlgorithmResponse(dict):
    """
    Basic algorithm for autoscaling.
    """
    def __init__(__self__, *,
                 cooldown_period: str,
                 yarn_config: 'outputs.BasicYarnAutoscalingConfigResponse'):
        """
        Basic algorithm for autoscaling.
        :param str cooldown_period: Optional. Duration between scaling events. A scaling period starts after the update operation from the previous event has completed.Bounds: 2m, 1d. Default: 2m.
        :param 'BasicYarnAutoscalingConfigResponseArgs' yarn_config: Required. YARN autoscaling configuration.
        """
        pulumi.set(__self__, "cooldown_period", cooldown_period)
        pulumi.set(__self__, "yarn_config", yarn_config)

    @property
    @pulumi.getter(name="cooldownPeriod")
    def cooldown_period(self) -> str:
        """
        Optional. Duration between scaling events. A scaling period starts after the update operation from the previous event has completed.Bounds: 2m, 1d. Default: 2m.
        """
        return pulumi.get(self, "cooldown_period")

    @property
    @pulumi.getter(name="yarnConfig")
    def yarn_config(self) -> 'outputs.BasicYarnAutoscalingConfigResponse':
        """
        Required. YARN autoscaling configuration.
        """
        return pulumi.get(self, "yarn_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BasicYarnAutoscalingConfigResponse(dict):
    """
    Basic autoscaling configurations for YARN.
    """
    def __init__(__self__, *,
                 graceful_decommission_timeout: str,
                 scale_down_factor: float,
                 scale_down_min_worker_fraction: float,
                 scale_up_factor: float,
                 scale_up_min_worker_fraction: float):
        """
        Basic autoscaling configurations for YARN.
        :param str graceful_decommission_timeout: Required. Timeout for YARN graceful decommissioning of Node Managers. Specifies the duration to wait for jobs to complete before forcefully removing workers (and potentially interrupting jobs). Only applicable to downscaling operations.Bounds: 0s, 1d.
        :param float scale_down_factor: Required. Fraction of average YARN pending memory in the last cooldown period for which to remove workers. A scale-down factor of 1 will result in scaling down so that there is no available memory remaining after the update (more aggressive scaling). A scale-down factor of 0 disables removing workers, which can be beneficial for autoscaling a single job. See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        :param float scale_down_min_worker_fraction: Optional. Minimum scale-down threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0 means the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        :param float scale_up_factor: Required. Fraction of average YARN pending memory in the last cooldown period for which to add workers. A scale-up factor of 1.0 will result in scaling up so that there is no pending memory remaining after the update (more aggressive scaling). A scale-up factor closer to 0 will result in a smaller magnitude of scaling up (less aggressive scaling). See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        :param float scale_up_min_worker_fraction: Optional. Minimum scale-up threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of 0 means the autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        pulumi.set(__self__, "scale_down_factor", scale_down_factor)
        pulumi.set(__self__, "scale_down_min_worker_fraction", scale_down_min_worker_fraction)
        pulumi.set(__self__, "scale_up_factor", scale_up_factor)
        pulumi.set(__self__, "scale_up_min_worker_fraction", scale_up_min_worker_fraction)

    @property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> str:
        """
        Required. Timeout for YARN graceful decommissioning of Node Managers. Specifies the duration to wait for jobs to complete before forcefully removing workers (and potentially interrupting jobs). Only applicable to downscaling operations.Bounds: 0s, 1d.
        """
        return pulumi.get(self, "graceful_decommission_timeout")

    @property
    @pulumi.getter(name="scaleDownFactor")
    def scale_down_factor(self) -> float:
        """
        Required. Fraction of average YARN pending memory in the last cooldown period for which to remove workers. A scale-down factor of 1 will result in scaling down so that there is no available memory remaining after the update (more aggressive scaling). A scale-down factor of 0 disables removing workers, which can be beneficial for autoscaling a single job. See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        """
        return pulumi.get(self, "scale_down_factor")

    @property
    @pulumi.getter(name="scaleDownMinWorkerFraction")
    def scale_down_min_worker_fraction(self) -> float:
        """
        Optional. Minimum scale-down threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0 means the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        return pulumi.get(self, "scale_down_min_worker_fraction")

    @property
    @pulumi.getter(name="scaleUpFactor")
    def scale_up_factor(self) -> float:
        """
        Required. Fraction of average YARN pending memory in the last cooldown period for which to add workers. A scale-up factor of 1.0 will result in scaling up so that there is no pending memory remaining after the update (more aggressive scaling). A scale-up factor closer to 0 will result in a smaller magnitude of scaling up (less aggressive scaling). See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        """
        return pulumi.get(self, "scale_up_factor")

    @property
    @pulumi.getter(name="scaleUpMinWorkerFraction")
    def scale_up_min_worker_fraction(self) -> float:
        """
        Optional. Minimum scale-up threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of 0 means the autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        return pulumi.get(self, "scale_up_min_worker_fraction")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates members with a role.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates members with a role.
        :param 'ExprResponseArgs' condition: The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the identities requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        :param str role: Role that is assigned to members. For example, roles/viewer, roles/editor, or roles/owner.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the members in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the identities requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to members. For example, roles/viewer, roles/editor, or roles/owner.
        """
        return pulumi.get(self, "role")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterConfigResponse(dict):
    """
    The cluster config.
    """
    def __init__(__self__, *,
                 autoscaling_config: 'outputs.AutoscalingConfigResponse',
                 config_bucket: str,
                 encryption_config: 'outputs.EncryptionConfigResponse',
                 endpoint_config: 'outputs.EndpointConfigResponse',
                 gce_cluster_config: 'outputs.GceClusterConfigResponse',
                 gke_cluster_config: 'outputs.GkeClusterConfigResponse',
                 initialization_actions: Sequence['outputs.NodeInitializationActionResponse'],
                 lifecycle_config: 'outputs.LifecycleConfigResponse',
                 master_config: 'outputs.InstanceGroupConfigResponse',
                 metastore_config: 'outputs.MetastoreConfigResponse',
                 secondary_worker_config: 'outputs.InstanceGroupConfigResponse',
                 security_config: 'outputs.SecurityConfigResponse',
                 software_config: 'outputs.SoftwareConfigResponse',
                 temp_bucket: str,
                 worker_config: 'outputs.InstanceGroupConfigResponse'):
        """
        The cluster config.
        :param 'AutoscalingConfigResponseArgs' autoscaling_config: Optional. Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        :param str config_bucket: Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see Dataproc staging bucket (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.
        :param 'EncryptionConfigResponseArgs' encryption_config: Optional. Encryption settings for the cluster.
        :param 'EndpointConfigResponseArgs' endpoint_config: Optional. Port/endpoint configuration for this cluster
        :param 'GceClusterConfigResponseArgs' gce_cluster_config: Optional. The shared Compute Engine config settings for all instances in a cluster.
        :param 'GkeClusterConfigResponseArgs' gke_cluster_config: Optional. BETA. The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as gce_cluster_config, master_config, worker_config, secondary_worker_config, and autoscaling_config.
        :param Sequence['NodeInitializationActionResponseArgs'] initialization_actions: Optional. Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's role metadata to run an executable on a master or worker node, as shown below using curl (you can also use wget): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if [[ "${ROLE}" == 'Master' ]]; then ... master specific actions ... else ... worker specific actions ... fi 
        :param 'LifecycleConfigResponseArgs' lifecycle_config: Optional. Lifecycle setting for the cluster.
        :param 'InstanceGroupConfigResponseArgs' master_config: Optional. The Compute Engine config settings for the master instance in a cluster.
        :param 'MetastoreConfigResponseArgs' metastore_config: Optional. Metastore configuration.
        :param 'InstanceGroupConfigResponseArgs' secondary_worker_config: Optional. The Compute Engine config settings for additional worker instances in a cluster.
        :param 'SecurityConfigResponseArgs' security_config: Optional. Security settings for the cluster.
        :param 'SoftwareConfigResponseArgs' software_config: Optional. The config settings for software inside the cluster.
        :param str temp_bucket: Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket. This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.
        :param 'InstanceGroupConfigResponseArgs' worker_config: Optional. The Compute Engine config settings for worker instances in a cluster.
        """
        pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        pulumi.set(__self__, "config_bucket", config_bucket)
        pulumi.set(__self__, "encryption_config", encryption_config)
        pulumi.set(__self__, "endpoint_config", endpoint_config)
        pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        pulumi.set(__self__, "gke_cluster_config", gke_cluster_config)
        pulumi.set(__self__, "initialization_actions", initialization_actions)
        pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        pulumi.set(__self__, "master_config", master_config)
        pulumi.set(__self__, "metastore_config", metastore_config)
        pulumi.set(__self__, "secondary_worker_config", secondary_worker_config)
        pulumi.set(__self__, "security_config", security_config)
        pulumi.set(__self__, "software_config", software_config)
        pulumi.set(__self__, "temp_bucket", temp_bucket)
        pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> 'outputs.AutoscalingConfigResponse':
        """
        Optional. Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        """
        return pulumi.get(self, "autoscaling_config")

    @property
    @pulumi.getter(name="configBucket")
    def config_bucket(self) -> str:
        """
        Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see Dataproc staging bucket (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.
        """
        return pulumi.get(self, "config_bucket")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> 'outputs.EncryptionConfigResponse':
        """
        Optional. Encryption settings for the cluster.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> 'outputs.EndpointConfigResponse':
        """
        Optional. Port/endpoint configuration for this cluster
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> 'outputs.GceClusterConfigResponse':
        """
        Optional. The shared Compute Engine config settings for all instances in a cluster.
        """
        return pulumi.get(self, "gce_cluster_config")

    @property
    @pulumi.getter(name="gkeClusterConfig")
    def gke_cluster_config(self) -> 'outputs.GkeClusterConfigResponse':
        """
        Optional. BETA. The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as gce_cluster_config, master_config, worker_config, secondary_worker_config, and autoscaling_config.
        """
        return pulumi.get(self, "gke_cluster_config")

    @property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Sequence['outputs.NodeInitializationActionResponse']:
        """
        Optional. Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's role metadata to run an executable on a master or worker node, as shown below using curl (you can also use wget): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if [[ "${ROLE}" == 'Master' ]]; then ... master specific actions ... else ... worker specific actions ... fi 
        """
        return pulumi.get(self, "initialization_actions")

    @property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> 'outputs.LifecycleConfigResponse':
        """
        Optional. Lifecycle setting for the cluster.
        """
        return pulumi.get(self, "lifecycle_config")

    @property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> 'outputs.InstanceGroupConfigResponse':
        """
        Optional. The Compute Engine config settings for the master instance in a cluster.
        """
        return pulumi.get(self, "master_config")

    @property
    @pulumi.getter(name="metastoreConfig")
    def metastore_config(self) -> 'outputs.MetastoreConfigResponse':
        """
        Optional. Metastore configuration.
        """
        return pulumi.get(self, "metastore_config")

    @property
    @pulumi.getter(name="secondaryWorkerConfig")
    def secondary_worker_config(self) -> 'outputs.InstanceGroupConfigResponse':
        """
        Optional. The Compute Engine config settings for additional worker instances in a cluster.
        """
        return pulumi.get(self, "secondary_worker_config")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> 'outputs.SecurityConfigResponse':
        """
        Optional. Security settings for the cluster.
        """
        return pulumi.get(self, "security_config")

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> 'outputs.SoftwareConfigResponse':
        """
        Optional. The config settings for software inside the cluster.
        """
        return pulumi.get(self, "software_config")

    @property
    @pulumi.getter(name="tempBucket")
    def temp_bucket(self) -> str:
        """
        Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket. This field requires a Cloud Storage bucket name, not a URI to a Cloud Storage bucket.
        """
        return pulumi.get(self, "temp_bucket")

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> 'outputs.InstanceGroupConfigResponse':
        """
        Optional. The Compute Engine config settings for worker instances in a cluster.
        """
        return pulumi.get(self, "worker_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterMetricsResponse(dict):
    """
    Contains cluster daemon metrics, such as HDFS and YARN stats.Beta Feature: This report is available for testing purposes only. It may be changed before final release.
    """
    def __init__(__self__, *,
                 hdfs_metrics: Mapping[str, str],
                 yarn_metrics: Mapping[str, str]):
        """
        Contains cluster daemon metrics, such as HDFS and YARN stats.Beta Feature: This report is available for testing purposes only. It may be changed before final release.
        :param Mapping[str, str] hdfs_metrics: The HDFS metrics.
        :param Mapping[str, str] yarn_metrics: The YARN metrics.
        """
        pulumi.set(__self__, "hdfs_metrics", hdfs_metrics)
        pulumi.set(__self__, "yarn_metrics", yarn_metrics)

    @property
    @pulumi.getter(name="hdfsMetrics")
    def hdfs_metrics(self) -> Mapping[str, str]:
        """
        The HDFS metrics.
        """
        return pulumi.get(self, "hdfs_metrics")

    @property
    @pulumi.getter(name="yarnMetrics")
    def yarn_metrics(self) -> Mapping[str, str]:
        """
        The YARN metrics.
        """
        return pulumi.get(self, "yarn_metrics")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterSelectorResponse(dict):
    """
    A selector that chooses target cluster for jobs based on metadata.
    """
    def __init__(__self__, *,
                 cluster_labels: Mapping[str, str],
                 zone: str):
        """
        A selector that chooses target cluster for jobs based on metadata.
        :param Mapping[str, str] cluster_labels: Required. The cluster labels. Cluster must have all labels to match.
        :param str zone: Optional. The zone where workflow process executes. This parameter does not affect the selection of the cluster.If unspecified, the zone of the first cluster matching the selector is used.
        """
        pulumi.set(__self__, "cluster_labels", cluster_labels)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="clusterLabels")
    def cluster_labels(self) -> Mapping[str, str]:
        """
        Required. The cluster labels. Cluster must have all labels to match.
        """
        return pulumi.get(self, "cluster_labels")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        Optional. The zone where workflow process executes. This parameter does not affect the selection of the cluster.If unspecified, the zone of the first cluster matching the selector is used.
        """
        return pulumi.get(self, "zone")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ClusterStatusResponse(dict):
    """
    The status of a cluster and its instances.
    """
    def __init__(__self__, *,
                 detail: str,
                 state: str,
                 state_start_time: str,
                 substate: str):
        """
        The status of a cluster and its instances.
        :param str detail: Optional. Output only. Details of cluster's state.
        :param str state: The cluster's state.
        :param str state_start_time: Time when this state was entered (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param str substate: Additional state information that includes status reported by the agent.
        """
        pulumi.set(__self__, "detail", detail)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_start_time", state_start_time)
        pulumi.set(__self__, "substate", substate)

    @property
    @pulumi.getter
    def detail(self) -> str:
        """
        Optional. Output only. Details of cluster's state.
        """
        return pulumi.get(self, "detail")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The cluster's state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> str:
        """
        Time when this state was entered (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "state_start_time")

    @property
    @pulumi.getter
    def substate(self) -> str:
        """
        Additional state information that includes status reported by the agent.
        """
        return pulumi.get(self, "substate")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class DiskConfigResponse(dict):
    """
    Specifies the config of disk options for a group of VM instances.
    """
    def __init__(__self__, *,
                 boot_disk_size_gb: int,
                 boot_disk_type: str,
                 num_local_ssds: int):
        """
        Specifies the config of disk options for a group of VM instances.
        :param int boot_disk_size_gb: Optional. Size in GB of the boot disk (default is 500GB).
        :param str boot_disk_type: Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See Disk types (https://cloud.google.com/compute/docs/disks#disk-types).
        :param int num_local_ssds: Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and HDFS (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> int:
        """
        Optional. Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> str:
        """
        Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See Disk types (https://cloud.google.com/compute/docs/disks#disk-types).
        """
        return pulumi.get(self, "boot_disk_type")

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> int:
        """
        Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and HDFS (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EncryptionConfigResponse(dict):
    """
    Encryption settings for the cluster.
    """
    def __init__(__self__, *,
                 gce_pd_kms_key_name: str):
        """
        Encryption settings for the cluster.
        :param str gce_pd_kms_key_name: Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        pulumi.set(__self__, "gce_pd_kms_key_name", gce_pd_kms_key_name)

    @property
    @pulumi.getter(name="gcePdKmsKeyName")
    def gce_pd_kms_key_name(self) -> str:
        """
        Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        return pulumi.get(self, "gce_pd_kms_key_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class EndpointConfigResponse(dict):
    """
    Endpoint config for this cluster
    """
    def __init__(__self__, *,
                 enable_http_port_access: bool,
                 http_ports: Mapping[str, str]):
        """
        Endpoint config for this cluster
        :param bool enable_http_port_access: Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        :param Mapping[str, str] http_ports: The map of port descriptions to URLs. Will only be populated if enable_http_port_access is true.
        """
        pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)
        pulumi.set(__self__, "http_ports", http_ports)

    @property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> bool:
        """
        Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Mapping[str, str]:
        """
        The map of port descriptions to URLs. Will only be populated if enable_http_port_access is true.
        """
        return pulumi.get(self, "http_ports")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GceClusterConfigResponse(dict):
    """
    Common config settings for resources of Compute Engine cluster instances, applicable to all instances in the cluster.
    """
    def __init__(__self__, *,
                 internal_ip_only: bool,
                 metadata: Mapping[str, str],
                 network_uri: str,
                 node_group_affinity: 'outputs.NodeGroupAffinityResponse',
                 private_ipv6_google_access: str,
                 reservation_affinity: 'outputs.ReservationAffinityResponse',
                 service_account: str,
                 service_account_scopes: Sequence[str],
                 shielded_instance_config: 'outputs.ShieldedInstanceConfigResponse',
                 subnetwork_uri: str,
                 tags: Sequence[str],
                 zone_uri: str):
        """
        Common config settings for resources of Compute Engine cluster instances, applicable to all instances in the cluster.
        :param bool internal_ip_only: Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This internal_ip_only restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        :param Mapping[str, str] metadata: The Compute Engine metadata entries to add to all instances (see Project and instance metadata (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param str network_uri: Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither network_uri nor subnetwork_uri is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see Using Subnetworks (https://cloud.google.com/compute/docs/subnetworks) for more information).A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default projects/[project_id]/regions/global/default default
        :param 'NodeGroupAffinityResponseArgs' node_group_affinity: Optional. Node Group Affinity for sole-tenant clusters.
        :param str private_ipv6_google_access: Optional. The type of IPv6 access for a cluster.
        :param 'ReservationAffinityResponseArgs' reservation_affinity: Optional. Reservation Affinity for consuming Zonal reservation.
        :param str service_account: Optional. The Dataproc service account (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see VM Data Plane identity (https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services.If not specified, the Compute Engine default service account (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        :param Sequence[str] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: https://www.googleapis.com/auth/cloud.useraccounts.readonly https://www.googleapis.com/auth/devstorage.read_write https://www.googleapis.com/auth/logging.writeIf no scopes are specified, the following defaults are also provided: https://www.googleapis.com/auth/bigquery https://www.googleapis.com/auth/bigtable.admin.table https://www.googleapis.com/auth/bigtable.data https://www.googleapis.com/auth/devstorage.full_control
        :param 'ShieldedInstanceConfigResponseArgs' shielded_instance_config: Optional. Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        :param str subnetwork_uri: Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0 projects/[project_id]/regions/us-east1/subnetworks/sub0 sub0
        :param Sequence[str] tags: The Compute Engine tags to add to all instances (see Tagging instances (https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        :param str zone_uri: Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone] projects/[project_id]/zones/[zone] us-central1-f
        """
        pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "node_group_affinity", node_group_affinity)
        pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "subnetwork_uri", subnetwork_uri)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "zone_uri", zone_uri)

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> bool:
        """
        Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This internal_ip_only restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        """
        return pulumi.get(self, "internal_ip_only")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The Compute Engine metadata entries to add to all instances (see Project and instance metadata (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither network_uri nor subnetwork_uri is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see Using Subnetworks (https://cloud.google.com/compute/docs/subnetworks) for more information).A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default projects/[project_id]/regions/global/default default
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter(name="nodeGroupAffinity")
    def node_group_affinity(self) -> 'outputs.NodeGroupAffinityResponse':
        """
        Optional. Node Group Affinity for sole-tenant clusters.
        """
        return pulumi.get(self, "node_group_affinity")

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> str:
        """
        Optional. The type of IPv6 access for a cluster.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> 'outputs.ReservationAffinityResponse':
        """
        Optional. Reservation Affinity for consuming Zonal reservation.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Optional. The Dataproc service account (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see VM Data Plane identity (https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services.If not specified, the Compute Engine default service account (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Sequence[str]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: https://www.googleapis.com/auth/cloud.useraccounts.readonly https://www.googleapis.com/auth/devstorage.read_write https://www.googleapis.com/auth/logging.writeIf no scopes are specified, the following defaults are also provided: https://www.googleapis.com/auth/bigquery https://www.googleapis.com/auth/bigtable.admin.table https://www.googleapis.com/auth/bigtable.data https://www.googleapis.com/auth/devstorage.full_control
        """
        return pulumi.get(self, "service_account_scopes")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.ShieldedInstanceConfigResponse':
        """
        Optional. Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter(name="subnetworkUri")
    def subnetwork_uri(self) -> str:
        """
        Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0 projects/[project_id]/regions/us-east1/subnetworks/sub0 sub0
        """
        return pulumi.get(self, "subnetwork_uri")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        The Compute Engine tags to add to all instances (see Tagging instances (https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zoneUri")
    def zone_uri(self) -> str:
        """
        Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone] projects/[project_id]/zones/[zone] us-central1-f
        """
        return pulumi.get(self, "zone_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class GkeClusterConfigResponse(dict):
    """
    The GKE config for this cluster.
    """
    def __init__(__self__, *,
                 namespaced_gke_deployment_target: 'outputs.NamespacedGkeDeploymentTargetResponse'):
        """
        The GKE config for this cluster.
        :param 'NamespacedGkeDeploymentTargetResponseArgs' namespaced_gke_deployment_target: Optional. A target for the deployment.
        """
        pulumi.set(__self__, "namespaced_gke_deployment_target", namespaced_gke_deployment_target)

    @property
    @pulumi.getter(name="namespacedGkeDeploymentTarget")
    def namespaced_gke_deployment_target(self) -> 'outputs.NamespacedGkeDeploymentTargetResponse':
        """
        Optional. A target for the deployment.
        """
        return pulumi.get(self, "namespaced_gke_deployment_target")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HadoopJobResponse(dict):
    """
    A Dataproc job for running Apache Hadoop MapReduce (https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html) jobs on Apache Hadoop YARN (https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
    """
    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 main_class: str,
                 main_jar_file_uri: str,
                 properties: Mapping[str, str]):
        """
        A Dataproc job for running Apache Hadoop MapReduce (https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html) jobs on Apache Hadoop YARN (https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[str] file_uris: Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param Sequence[str] jar_file_uris: Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
        :param 'LoggingConfigResponseArgs' logging_config: Optional. The runtime log config for job execution.
        :param str main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in jar_file_uris.
        :param str main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "main_class", main_class)
        pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> str:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in jar_file_uris.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> str:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
        """
        return pulumi.get(self, "main_jar_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
        """
        return pulumi.get(self, "properties")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class HiveJobResponse(dict):
    """
    A Dataproc job for running Apache Hive (https://hive.apache.org/) queries on YARN.
    """
    def __init__(__self__, *,
                 continue_on_failure: bool,
                 jar_file_uris: Sequence[str],
                 properties: Mapping[str, str],
                 query_file_uri: str,
                 query_list: 'outputs.QueryListResponse',
                 script_variables: Mapping[str, str]):
        """
        A Dataproc job for running Apache Hive (https://hive.apache.org/) queries on YARN.
        :param bool continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        :param Mapping[str, str] properties: Optional. A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
        :param str query_file_uri: The HCFS URI of the script that contains Hive queries.
        :param 'QueryListResponseArgs' query_list: A list of queries.
        :param Mapping[str, str] script_variables: Optional. Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
        """
        pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_list", query_list)
        pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> bool:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains Hive queries.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> 'outputs.QueryListResponse':
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Mapping[str, str]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
        """
        return pulumi.get(self, "script_variables")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class IdentityConfigResponse(dict):
    """
    Identity related configuration, including service account based secure multi-tenancy user mappings.
    """
    def __init__(__self__, *,
                 user_service_account_mapping: Mapping[str, str]):
        """
        Identity related configuration, including service account based secure multi-tenancy user mappings.
        :param Mapping[str, str] user_service_account_mapping: Required. Map of user to service account.
        """
        pulumi.set(__self__, "user_service_account_mapping", user_service_account_mapping)

    @property
    @pulumi.getter(name="userServiceAccountMapping")
    def user_service_account_mapping(self) -> Mapping[str, str]:
        """
        Required. Map of user to service account.
        """
        return pulumi.get(self, "user_service_account_mapping")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceGroupAutoscalingPolicyConfigResponse(dict):
    """
    Configuration for the size bounds of an instance group, including its proportional size to other groups.
    """
    def __init__(__self__, *,
                 max_instances: int,
                 min_instances: int,
                 weight: int):
        """
        Configuration for the size bounds of an instance group, including its proportional size to other groups.
        :param int max_instances: Required. Maximum number of instances for this group. Required for primary workers. Note that by default, clusters will not use secondary workers. Required for secondary workers if the minimum secondary instances is set.Primary workers - Bounds: [min_instances, ). Secondary workers - Bounds: [min_instances, ). Default: 0.
        :param int min_instances: Optional. Minimum number of instances for this group.Primary workers - Bounds: 2, max_instances. Default: 2. Secondary workers - Bounds: 0, max_instances. Default: 0.
        :param int weight: Optional. Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group. For example, if primary workers have weight 2, and secondary workers have weight 1, the cluster will have approximately 2 primary workers for each secondary worker.The cluster may not reach the specified balance if constrained by min/max bounds or other autoscaling settings. For example, if max_instances for secondary workers is 0, then only primary workers will be added. The cluster can also be out of balance when created.If weight is not set on any instance group, the cluster will default to equal weight for all groups: the cluster will attempt to maintain an equal number of workers in each group within the configured size bounds for each group. If weight is set for one group only, the cluster will default to zero weight on the unset group. For example if weight is set only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        pulumi.set(__self__, "max_instances", max_instances)
        pulumi.set(__self__, "min_instances", min_instances)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> int:
        """
        Required. Maximum number of instances for this group. Required for primary workers. Note that by default, clusters will not use secondary workers. Required for secondary workers if the minimum secondary instances is set.Primary workers - Bounds: [min_instances, ). Secondary workers - Bounds: [min_instances, ). Default: 0.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> int:
        """
        Optional. Minimum number of instances for this group.Primary workers - Bounds: 2, max_instances. Default: 2. Secondary workers - Bounds: 0, max_instances. Default: 0.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Optional. Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group. For example, if primary workers have weight 2, and secondary workers have weight 1, the cluster will have approximately 2 primary workers for each secondary worker.The cluster may not reach the specified balance if constrained by min/max bounds or other autoscaling settings. For example, if max_instances for secondary workers is 0, then only primary workers will be added. The cluster can also be out of balance when created.If weight is not set on any instance group, the cluster will default to equal weight for all groups: the cluster will attempt to maintain an equal number of workers in each group within the configured size bounds for each group. If weight is set for one group only, the cluster will default to zero weight on the unset group. For example if weight is set only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceGroupConfigResponse(dict):
    """
    The config settings for Compute Engine resources in an instance group, such as a master or worker group.
    """
    def __init__(__self__, *,
                 accelerators: Sequence['outputs.AcceleratorConfigResponse'],
                 disk_config: 'outputs.DiskConfigResponse',
                 image_uri: str,
                 instance_names: Sequence[str],
                 instance_references: Sequence['outputs.InstanceReferenceResponse'],
                 is_preemptible: bool,
                 machine_type_uri: str,
                 managed_group_config: 'outputs.ManagedGroupConfigResponse',
                 min_cpu_platform: str,
                 num_instances: int,
                 preemptibility: str):
        """
        The config settings for Compute Engine resources in an instance group, such as a master or worker group.
        :param Sequence['AcceleratorConfigResponseArgs'] accelerators: Optional. The Compute Engine accelerator configuration for these instances.
        :param 'DiskConfigResponseArgs' disk_config: Optional. Disk option config settings.
        :param str image_uri: Optional. The Compute Engine image resource used for cluster instances.The URI can represent an image or image family.Image examples: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id] projects/[project_id]/global/images/[image-id] image-idImage family examples. Dataproc will use the most recent image from the family: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name] projects/[project_id]/global/images/family/[custom-image-family-name]If the URI is unspecified, it will be inferred from SoftwareConfig.image_version or the system default.
        :param Sequence[str] instance_names: The list of instance names. Dataproc derives the names from cluster_name, num_instances, and the instance group.
        :param Sequence['InstanceReferenceResponseArgs'] instance_references: List of references to Compute Engine instances.
        :param bool is_preemptible: Specifies that this instance group contains preemptible instances.
        :param str machine_type_uri: Optional. The Compute Engine machine type used for cluster instances.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 n1-standard-2Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, n1-standard-2.
        :param 'ManagedGroupConfigResponseArgs' managed_group_config: The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        :param str min_cpu_platform: Optional. Specifies the minimum cpu platform for the Instance Group. See Dataproc -> Minimum CPU Platform (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param int num_instances: Optional. The number of VM instances in the instance group. For HA cluster master_config groups, must be set to 3. For standard cluster master_config groups, must be set to 1.
        :param str preemptibility: Optional. Specifies the preemptibility of the instance group.The default value for master and worker groups is NON_PREEMPTIBLE. This default cannot be changed.The default value for secondary instances is PREEMPTIBLE.
        """
        pulumi.set(__self__, "accelerators", accelerators)
        pulumi.set(__self__, "disk_config", disk_config)
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "instance_names", instance_names)
        pulumi.set(__self__, "instance_references", instance_references)
        pulumi.set(__self__, "is_preemptible", is_preemptible)
        pulumi.set(__self__, "machine_type_uri", machine_type_uri)
        pulumi.set(__self__, "managed_group_config", managed_group_config)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "num_instances", num_instances)
        pulumi.set(__self__, "preemptibility", preemptibility)

    @property
    @pulumi.getter
    def accelerators(self) -> Sequence['outputs.AcceleratorConfigResponse']:
        """
        Optional. The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> 'outputs.DiskConfigResponse':
        """
        Optional. Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        Optional. The Compute Engine image resource used for cluster instances.The URI can represent an image or image family.Image examples: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id] projects/[project_id]/global/images/[image-id] image-idImage family examples. Dataproc will use the most recent image from the family: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name] projects/[project_id]/global/images/family/[custom-image-family-name]If the URI is unspecified, it will be inferred from SoftwareConfig.image_version or the system default.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Sequence[str]:
        """
        The list of instance names. Dataproc derives the names from cluster_name, num_instances, and the instance group.
        """
        return pulumi.get(self, "instance_names")

    @property
    @pulumi.getter(name="instanceReferences")
    def instance_references(self) -> Sequence['outputs.InstanceReferenceResponse']:
        """
        List of references to Compute Engine instances.
        """
        return pulumi.get(self, "instance_references")

    @property
    @pulumi.getter(name="isPreemptible")
    def is_preemptible(self) -> bool:
        """
        Specifies that this instance group contains preemptible instances.
        """
        return pulumi.get(self, "is_preemptible")

    @property
    @pulumi.getter(name="machineTypeUri")
    def machine_type_uri(self) -> str:
        """
        Optional. The Compute Engine machine type used for cluster instances.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 n1-standard-2Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, n1-standard-2.
        """
        return pulumi.get(self, "machine_type_uri")

    @property
    @pulumi.getter(name="managedGroupConfig")
    def managed_group_config(self) -> 'outputs.ManagedGroupConfigResponse':
        """
        The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        """
        return pulumi.get(self, "managed_group_config")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Optional. Specifies the minimum cpu platform for the Instance Group. See Dataproc -> Minimum CPU Platform (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> int:
        """
        Optional. The number of VM instances in the instance group. For HA cluster master_config groups, must be set to 3. For standard cluster master_config groups, must be set to 1.
        """
        return pulumi.get(self, "num_instances")

    @property
    @pulumi.getter
    def preemptibility(self) -> str:
        """
        Optional. Specifies the preemptibility of the instance group.The default value for master and worker groups is NON_PREEMPTIBLE. This default cannot be changed.The default value for secondary instances is PREEMPTIBLE.
        """
        return pulumi.get(self, "preemptibility")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class InstanceReferenceResponse(dict):
    """
    A reference to a Compute Engine instance.
    """
    def __init__(__self__, *,
                 instance_id: str,
                 instance_name: str,
                 public_key: str):
        """
        A reference to a Compute Engine instance.
        :param str instance_id: The unique identifier of the Compute Engine instance.
        :param str instance_name: The user-friendly name of the Compute Engine instance.
        :param str public_key: The public key used for sharing data with this instance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The unique identifier of the Compute Engine instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The user-friendly name of the Compute Engine instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The public key used for sharing data with this instance.
        """
        return pulumi.get(self, "public_key")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class JobSchedulingResponse(dict):
    """
    Job scheduling options.
    """
    def __init__(__self__, *,
                 max_failures_per_hour: int,
                 max_failures_total: int):
        """
        Job scheduling options.
        :param int max_failures_per_hour: Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window.Maximum value is 10.
        :param int max_failures_total: Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.
        """
        pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)
        pulumi.set(__self__, "max_failures_total", max_failures_total)

    @property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> int:
        """
        Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window.Maximum value is 10.
        """
        return pulumi.get(self, "max_failures_per_hour")

    @property
    @pulumi.getter(name="maxFailuresTotal")
    def max_failures_total(self) -> int:
        """
        Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.
        """
        return pulumi.get(self, "max_failures_total")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class KerberosConfigResponse(dict):
    """
    Specifies Kerberos related configuration.
    """
    def __init__(__self__, *,
                 cross_realm_trust_admin_server: str,
                 cross_realm_trust_kdc: str,
                 cross_realm_trust_realm: str,
                 cross_realm_trust_shared_password_uri: str,
                 enable_kerberos: bool,
                 kdc_db_key_uri: str,
                 key_password_uri: str,
                 keystore_password_uri: str,
                 keystore_uri: str,
                 kms_key_uri: str,
                 realm: str,
                 root_principal_password_uri: str,
                 tgt_lifetime_hours: int,
                 truststore_password_uri: str,
                 truststore_uri: str):
        """
        Specifies Kerberos related configuration.
        :param str cross_realm_trust_admin_server: Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param str cross_realm_trust_kdc: Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param str cross_realm_trust_realm: Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        :param str cross_realm_trust_shared_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        :param bool enable_kerberos: Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        :param str kdc_db_key_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        :param str key_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        :param str keystore_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        :param str keystore_uri: Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        :param str kms_key_uri: Optional. The uri of the KMS key used to encrypt various sensitive files.
        :param str realm: Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        :param str root_principal_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        :param int tgt_lifetime_hours: Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        :param str truststore_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        :param str truststore_uri: Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        pulumi.set(__self__, "cross_realm_trust_shared_password_uri", cross_realm_trust_shared_password_uri)
        pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        pulumi.set(__self__, "kdc_db_key_uri", kdc_db_key_uri)
        pulumi.set(__self__, "key_password_uri", key_password_uri)
        pulumi.set(__self__, "keystore_password_uri", keystore_password_uri)
        pulumi.set(__self__, "keystore_uri", keystore_uri)
        pulumi.set(__self__, "kms_key_uri", kms_key_uri)
        pulumi.set(__self__, "realm", realm)
        pulumi.set(__self__, "root_principal_password_uri", root_principal_password_uri)
        pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        pulumi.set(__self__, "truststore_password_uri", truststore_password_uri)
        pulumi.set(__self__, "truststore_uri", truststore_uri)

    @property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> str:
        """
        Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> str:
        """
        Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> str:
        """
        Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @property
    @pulumi.getter(name="crossRealmTrustSharedPasswordUri")
    def cross_realm_trust_shared_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password_uri")

    @property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> bool:
        """
        Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @property
    @pulumi.getter(name="kdcDbKeyUri")
    def kdc_db_key_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key_uri")

    @property
    @pulumi.getter(name="keyPasswordUri")
    def key_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "key_password_uri")

    @property
    @pulumi.getter(name="keystorePasswordUri")
    def keystore_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password_uri")

    @property
    @pulumi.getter(name="keystoreUri")
    def keystore_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore_uri")

    @property
    @pulumi.getter(name="kmsKeyUri")
    def kms_key_uri(self) -> str:
        """
        Optional. The uri of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key_uri")

    @property
    @pulumi.getter
    def realm(self) -> str:
        """
        Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="rootPrincipalPasswordUri")
    def root_principal_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password_uri")

    @property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> int:
        """
        Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @property
    @pulumi.getter(name="truststorePasswordUri")
    def truststore_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password_uri")

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LifecycleConfigResponse(dict):
    """
    Specifies the cluster auto-delete schedule configuration.
    """
    def __init__(__self__, *,
                 auto_delete_time: str,
                 auto_delete_ttl: str,
                 idle_delete_ttl: str,
                 idle_start_time: str):
        """
        Specifies the cluster auto-delete schedule configuration.
        :param str auto_delete_time: Optional. The time when cluster will be auto-deleted (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param str auto_delete_ttl: Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param str idle_delete_ttl: Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param str idle_start_time: The time when cluster became idle (most recent job finished) and became eligible for deletion due to idleness (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        pulumi.set(__self__, "auto_delete_ttl", auto_delete_ttl)
        pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)
        pulumi.set(__self__, "idle_start_time", idle_start_time)

    @property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> str:
        """
        Optional. The time when cluster will be auto-deleted (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_time")

    @property
    @pulumi.getter(name="autoDeleteTtl")
    def auto_delete_ttl(self) -> str:
        """
        Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_ttl")

    @property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> str:
        """
        Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "idle_delete_ttl")

    @property
    @pulumi.getter(name="idleStartTime")
    def idle_start_time(self) -> str:
        """
        The time when cluster became idle (most recent job finished) and became eligible for deletion due to idleness (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "idle_start_time")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class LoggingConfigResponse(dict):
    """
    The runtime logging config of the job.
    """
    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, str]):
        """
        The runtime logging config of the job.
        :param Mapping[str, str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, str]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ManagedClusterResponse(dict):
    """
    Cluster that is managed by the workflow.
    """
    def __init__(__self__, *,
                 cluster_name: str,
                 config: 'outputs.ClusterConfigResponse',
                 labels: Mapping[str, str]):
        """
        Cluster that is managed by the workflow.
        :param str cluster_name: Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        :param 'ClusterConfigResponseArgs' config: Required. The cluster configuration.
        :param Mapping[str, str] labels: Optional. The labels to associate with this cluster.Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given cluster.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        Required. The cluster name prefix. A unique cluster name will be formed by appending a random suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def config(self) -> 'outputs.ClusterConfigResponse':
        """
        Required. The cluster configuration.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. The labels to associate with this cluster.Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given cluster.
        """
        return pulumi.get(self, "labels")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ManagedGroupConfigResponse(dict):
    """
    Specifies the resources used to actively manage an instance group.
    """
    def __init__(__self__, *,
                 instance_group_manager_name: str,
                 instance_template_name: str):
        """
        Specifies the resources used to actively manage an instance group.
        :param str instance_group_manager_name: The name of the Instance Group Manager for this group.
        :param str instance_template_name: The name of the Instance Template used for the Managed Instance Group.
        """
        pulumi.set(__self__, "instance_group_manager_name", instance_group_manager_name)
        pulumi.set(__self__, "instance_template_name", instance_template_name)

    @property
    @pulumi.getter(name="instanceGroupManagerName")
    def instance_group_manager_name(self) -> str:
        """
        The name of the Instance Group Manager for this group.
        """
        return pulumi.get(self, "instance_group_manager_name")

    @property
    @pulumi.getter(name="instanceTemplateName")
    def instance_template_name(self) -> str:
        """
        The name of the Instance Template used for the Managed Instance Group.
        """
        return pulumi.get(self, "instance_template_name")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class MetastoreConfigResponse(dict):
    """
    Specifies a Metastore configuration.
    """
    def __init__(__self__, *,
                 dataproc_metastore_service: str):
        """
        Specifies a Metastore configuration.
        :param str dataproc_metastore_service: Required. Resource name of an existing Dataproc Metastore service.Example: projects/[project_id]/locations/[dataproc_region]/services/[service-name]
        """
        pulumi.set(__self__, "dataproc_metastore_service", dataproc_metastore_service)

    @property
    @pulumi.getter(name="dataprocMetastoreService")
    def dataproc_metastore_service(self) -> str:
        """
        Required. Resource name of an existing Dataproc Metastore service.Example: projects/[project_id]/locations/[dataproc_region]/services/[service-name]
        """
        return pulumi.get(self, "dataproc_metastore_service")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NamespacedGkeDeploymentTargetResponse(dict):
    """
    A full, namespace-isolated deployment target for an existing GKE cluster.
    """
    def __init__(__self__, *,
                 cluster_namespace: str,
                 target_gke_cluster: str):
        """
        A full, namespace-isolated deployment target for an existing GKE cluster.
        :param str cluster_namespace: Optional. A namespace within the GKE cluster to deploy into.
        :param str target_gke_cluster: Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        pulumi.set(__self__, "cluster_namespace", cluster_namespace)
        pulumi.set(__self__, "target_gke_cluster", target_gke_cluster)

    @property
    @pulumi.getter(name="clusterNamespace")
    def cluster_namespace(self) -> str:
        """
        Optional. A namespace within the GKE cluster to deploy into.
        """
        return pulumi.get(self, "cluster_namespace")

    @property
    @pulumi.getter(name="targetGkeCluster")
    def target_gke_cluster(self) -> str:
        """
        Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "target_gke_cluster")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodeGroupAffinityResponse(dict):
    """
    Node Group Affinity for clusters using sole-tenant node groups.
    """
    def __init__(__self__, *,
                 node_group_uri: str):
        """
        Node Group Affinity for clusters using sole-tenant node groups.
        :param str node_group_uri: Required. The URI of a sole-tenant node group resource (https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on.A full URL, partial URI, or node group name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 node-group-1
        """
        pulumi.set(__self__, "node_group_uri", node_group_uri)

    @property
    @pulumi.getter(name="nodeGroupUri")
    def node_group_uri(self) -> str:
        """
        Required. The URI of a sole-tenant node group resource (https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on.A full URL, partial URI, or node group name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 node-group-1
        """
        return pulumi.get(self, "node_group_uri")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class NodeInitializationActionResponse(dict):
    """
    Specifies an executable to run on a fully configured node and a timeout period for executable completion.
    """
    def __init__(__self__, *,
                 executable_file: str,
                 execution_timeout: str):
        """
        Specifies an executable to run on a fully configured node and a timeout period for executable completion.
        :param str executable_file: Required. Cloud Storage URI of executable file.
        :param str execution_timeout: Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        pulumi.set(__self__, "executable_file", executable_file)
        pulumi.set(__self__, "execution_timeout", execution_timeout)

    @property
    @pulumi.getter(name="executableFile")
    def executable_file(self) -> str:
        """
        Required. Cloud Storage URI of executable file.
        """
        return pulumi.get(self, "executable_file")

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> str:
        """
        Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        return pulumi.get(self, "execution_timeout")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class OrderedJobResponse(dict):
    """
    A job executed by the workflow.
    """
    def __init__(__self__, *,
                 hadoop_job: 'outputs.HadoopJobResponse',
                 hive_job: 'outputs.HiveJobResponse',
                 labels: Mapping[str, str],
                 pig_job: 'outputs.PigJobResponse',
                 prerequisite_step_ids: Sequence[str],
                 presto_job: 'outputs.PrestoJobResponse',
                 pyspark_job: 'outputs.PySparkJobResponse',
                 scheduling: 'outputs.JobSchedulingResponse',
                 spark_job: 'outputs.SparkJobResponse',
                 spark_r_job: 'outputs.SparkRJobResponse',
                 spark_sql_job: 'outputs.SparkSqlJobResponse',
                 step_id: str):
        """
        A job executed by the workflow.
        :param 'HadoopJobResponseArgs' hadoop_job: Optional. Job is a Hadoop job.
        :param 'HiveJobResponseArgs' hive_job: Optional. Job is a Hive job.
        :param Mapping[str, str] labels: Optional. The labels to associate with this job.Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given job.
        :param 'PigJobResponseArgs' pig_job: Optional. Job is a Pig job.
        :param Sequence[str] prerequisite_step_ids: Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        :param 'PrestoJobResponseArgs' presto_job: Optional. Job is a Presto job.
        :param 'PySparkJobResponseArgs' pyspark_job: Optional. Job is a PySpark job.
        :param 'JobSchedulingResponseArgs' scheduling: Optional. Job scheduling configuration.
        :param 'SparkJobResponseArgs' spark_job: Optional. Job is a Spark job.
        :param 'SparkRJobResponseArgs' spark_r_job: Optional. Job is a SparkR job.
        :param 'SparkSqlJobResponseArgs' spark_sql_job: Optional. Job is a SparkSql job.
        :param str step_id: Required. The step id. The id must be unique among all jobs within the template.The step id is used as prefix for job id, as job goog-dataproc-workflow-step-id label, and in prerequisiteStepIds field from other steps.The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        """
        pulumi.set(__self__, "hadoop_job", hadoop_job)
        pulumi.set(__self__, "hive_job", hive_job)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "pig_job", pig_job)
        pulumi.set(__self__, "prerequisite_step_ids", prerequisite_step_ids)
        pulumi.set(__self__, "presto_job", presto_job)
        pulumi.set(__self__, "pyspark_job", pyspark_job)
        pulumi.set(__self__, "scheduling", scheduling)
        pulumi.set(__self__, "spark_job", spark_job)
        pulumi.set(__self__, "spark_r_job", spark_r_job)
        pulumi.set(__self__, "spark_sql_job", spark_sql_job)
        pulumi.set(__self__, "step_id", step_id)

    @property
    @pulumi.getter(name="hadoopJob")
    def hadoop_job(self) -> 'outputs.HadoopJobResponse':
        """
        Optional. Job is a Hadoop job.
        """
        return pulumi.get(self, "hadoop_job")

    @property
    @pulumi.getter(name="hiveJob")
    def hive_job(self) -> 'outputs.HiveJobResponse':
        """
        Optional. Job is a Hive job.
        """
        return pulumi.get(self, "hive_job")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. The labels to associate with this job.Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given job.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="pigJob")
    def pig_job(self) -> 'outputs.PigJobResponse':
        """
        Optional. Job is a Pig job.
        """
        return pulumi.get(self, "pig_job")

    @property
    @pulumi.getter(name="prerequisiteStepIds")
    def prerequisite_step_ids(self) -> Sequence[str]:
        """
        Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        """
        return pulumi.get(self, "prerequisite_step_ids")

    @property
    @pulumi.getter(name="prestoJob")
    def presto_job(self) -> 'outputs.PrestoJobResponse':
        """
        Optional. Job is a Presto job.
        """
        return pulumi.get(self, "presto_job")

    @property
    @pulumi.getter(name="pysparkJob")
    def pyspark_job(self) -> 'outputs.PySparkJobResponse':
        """
        Optional. Job is a PySpark job.
        """
        return pulumi.get(self, "pyspark_job")

    @property
    @pulumi.getter
    def scheduling(self) -> 'outputs.JobSchedulingResponse':
        """
        Optional. Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="sparkJob")
    def spark_job(self) -> 'outputs.SparkJobResponse':
        """
        Optional. Job is a Spark job.
        """
        return pulumi.get(self, "spark_job")

    @property
    @pulumi.getter(name="sparkRJob")
    def spark_r_job(self) -> 'outputs.SparkRJobResponse':
        """
        Optional. Job is a SparkR job.
        """
        return pulumi.get(self, "spark_r_job")

    @property
    @pulumi.getter(name="sparkSqlJob")
    def spark_sql_job(self) -> 'outputs.SparkSqlJobResponse':
        """
        Optional. Job is a SparkSql job.
        """
        return pulumi.get(self, "spark_sql_job")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> str:
        """
        Required. The step id. The id must be unique among all jobs within the template.The step id is used as prefix for job id, as job goog-dataproc-workflow-step-id label, and in prerequisiteStepIds field from other steps.The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        """
        return pulumi.get(self, "step_id")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ParameterValidationResponse(dict):
    """
    Configuration for parameter validation.
    """
    def __init__(__self__, *,
                 regex: 'outputs.RegexValidationResponse',
                 values: 'outputs.ValueValidationResponse'):
        """
        Configuration for parameter validation.
        :param 'RegexValidationResponseArgs' regex: Validation based on regular expressions.
        :param 'ValueValidationResponseArgs' values: Validation based on a list of allowed values.
        """
        pulumi.set(__self__, "regex", regex)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def regex(self) -> 'outputs.RegexValidationResponse':
        """
        Validation based on regular expressions.
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter
    def values(self) -> 'outputs.ValueValidationResponse':
        """
        Validation based on a list of allowed values.
        """
        return pulumi.get(self, "values")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PigJobResponse(dict):
    """
    A Dataproc job for running Apache Pig (https://pig.apache.org/) queries on YARN.
    """
    def __init__(__self__, *,
                 continue_on_failure: bool,
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 properties: Mapping[str, str],
                 query_file_uri: str,
                 query_list: 'outputs.QueryListResponse',
                 script_variables: Mapping[str, str]):
        """
        A Dataproc job for running Apache Pig (https://pig.apache.org/) queries on YARN.
        :param bool continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
        :param 'LoggingConfigResponseArgs' logging_config: Optional. The runtime log config for job execution.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
        :param str query_file_uri: The HCFS URI of the script that contains the Pig queries.
        :param 'QueryListResponseArgs' query_list: A list of queries.
        :param Mapping[str, str] script_variables: Optional. Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
        """
        pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_list", query_list)
        pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> bool:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains the Pig queries.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> 'outputs.QueryListResponse':
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Mapping[str, str]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
        """
        return pulumi.get(self, "script_variables")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PrestoJobResponse(dict):
    """
    A Dataproc job for running Presto (https://prestosql.io/) queries. IMPORTANT: The Dataproc Presto Optional Component (https://cloud.google.com/dataproc/docs/concepts/components/presto) must be enabled when the cluster is created to submit a Presto job to the cluster.
    """
    def __init__(__self__, *,
                 client_tags: Sequence[str],
                 continue_on_failure: bool,
                 logging_config: 'outputs.LoggingConfigResponse',
                 output_format: str,
                 properties: Mapping[str, str],
                 query_file_uri: str,
                 query_list: 'outputs.QueryListResponse'):
        """
        A Dataproc job for running Presto (https://prestosql.io/) queries. IMPORTANT: The Dataproc Presto Optional Component (https://cloud.google.com/dataproc/docs/concepts/components/presto) must be enabled when the cluster is created to submit a Presto job to the cluster.
        :param Sequence[str] client_tags: Optional. Presto client tags to attach to this query
        :param bool continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param 'LoggingConfigResponseArgs' logging_config: Optional. The runtime log config for job execution.
        :param str output_format: Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
        :param Mapping[str, str] properties: Optional. A mapping of property names to values. Used to set Presto session properties (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
        :param str query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param 'QueryListResponseArgs' query_list: A list of queries.
        """
        pulumi.set(__self__, "client_tags", client_tags)
        pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "output_format", output_format)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_list", query_list)

    @property
    @pulumi.getter(name="clientTags")
    def client_tags(self) -> Sequence[str]:
        """
        Optional. Presto client tags to attach to this query
        """
        return pulumi.get(self, "client_tags")

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> bool:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> str:
        """
        Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values. Used to set Presto session properties (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> 'outputs.QueryListResponse':
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class PySparkJobResponse(dict):
    """
    A Dataproc job for running Apache PySpark (https://spark.apache.org/docs/0.9.0/python-programming-guide.html) applications on YARN.
    """
    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 main_python_file_uri: str,
                 properties: Mapping[str, str],
                 python_file_uris: Sequence[str]):
        """
        A Dataproc job for running Apache PySpark (https://spark.apache.org/docs/0.9.0/python-programming-guide.html) applications on YARN.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        :param 'LoggingConfigResponseArgs' logging_config: Optional. The runtime log config for job execution.
        :param str main_python_file_uri: Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        :param Sequence[str] python_file_uris: Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "python_file_uris", python_file_uris)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> str:
        """
        Required. The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class QueryListResponse(dict):
    """
    A list of queries to run on a cluster.
    """
    def __init__(__self__, *,
                 queries: Sequence[str]):
        """
        A list of queries to run on a cluster.
        :param Sequence[str] queries: Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } } 
        """
        pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> Sequence[str]:
        """
        Required. The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } } 
        """
        return pulumi.get(self, "queries")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class RegexValidationResponse(dict):
    """
    Validation based on regular expressions.
    """
    def __init__(__self__, *,
                 regexes: Sequence[str]):
        """
        Validation based on regular expressions.
        :param Sequence[str] regexes: Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        pulumi.set(__self__, "regexes", regexes)

    @property
    @pulumi.getter
    def regexes(self) -> Sequence[str]:
        """
        Required. RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        return pulumi.get(self, "regexes")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ReservationAffinityResponse(dict):
    """
    Reservation Affinity for consuming Zonal reservation.
    """
    def __init__(__self__, *,
                 consume_reservation_type: str,
                 key: str,
                 values: Sequence[str]):
        """
        Reservation Affinity for consuming Zonal reservation.
        :param str consume_reservation_type: Optional. Type of reservation to consume
        :param str key: Optional. Corresponds to the label key of reservation resource.
        :param Sequence[str] values: Optional. Corresponds to the label values of reservation resource.
        """
        pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> str:
        """
        Optional. Type of reservation to consume
        """
        return pulumi.get(self, "consume_reservation_type")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Optional. Corresponds to the label key of reservation resource.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Optional. Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SecurityConfigResponse(dict):
    """
    Security related configuration, including encryption, Kerberos, etc.
    """
    def __init__(__self__, *,
                 identity_config: 'outputs.IdentityConfigResponse',
                 kerberos_config: 'outputs.KerberosConfigResponse'):
        """
        Security related configuration, including encryption, Kerberos, etc.
        :param 'IdentityConfigResponseArgs' identity_config: Optional. Identity related configuration, including service account based secure multi-tenancy user mappings.
        :param 'KerberosConfigResponseArgs' kerberos_config: Optional. Kerberos related configuration.
        """
        pulumi.set(__self__, "identity_config", identity_config)
        pulumi.set(__self__, "kerberos_config", kerberos_config)

    @property
    @pulumi.getter(name="identityConfig")
    def identity_config(self) -> 'outputs.IdentityConfigResponse':
        """
        Optional. Identity related configuration, including service account based secure multi-tenancy user mappings.
        """
        return pulumi.get(self, "identity_config")

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> 'outputs.KerberosConfigResponse':
        """
        Optional. Kerberos related configuration.
        """
        return pulumi.get(self, "kerberos_config")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ShieldedInstanceConfigResponse(dict):
    """
    Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
    """
    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool,
                 enable_vtpm: bool):
        """
        Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        :param bool enable_integrity_monitoring: Optional. Defines whether instances have integrity monitoring enabled.
        :param bool enable_secure_boot: Optional. Defines whether instances have Secure Boot enabled.
        :param bool enable_vtpm: Optional. Defines whether instances have the vTPM enabled.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Optional. Defines whether instances have integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Optional. Defines whether instances have Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> bool:
        """
        Optional. Defines whether instances have the vTPM enabled.
        """
        return pulumi.get(self, "enable_vtpm")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SoftwareConfigResponse(dict):
    """
    Specifies the selection and config of software inside the cluster.
    """
    def __init__(__self__, *,
                 image_version: str,
                 optional_components: Sequence[str],
                 properties: Mapping[str, str]):
        """
        Specifies the selection and config of software inside the cluster.
        :param str image_version: Optional. The version of software inside the cluster. It must be one of the supported Dataproc Versions (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the "preview" version (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        :param Sequence[str] optional_components: Optional. The set of components to activate on the cluster.
        :param Mapping[str, str] properties: Optional. The properties to set on daemon config files.Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. The following are supported prefixes and their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        pulumi.set(__self__, "image_version", image_version)
        pulumi.set(__self__, "optional_components", optional_components)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> str:
        """
        Optional. The version of software inside the cluster. It must be one of the supported Dataproc Versions (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the "preview" version (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        """
        return pulumi.get(self, "image_version")

    @property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Sequence[str]:
        """
        Optional. The set of components to activate on the cluster.
        """
        return pulumi.get(self, "optional_components")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. The properties to set on daemon config files.Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. The following are supported prefixes and their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SparkJobResponse(dict):
    """
    A Dataproc job for running Apache Spark (http://spark.apache.org/) applications on YARN.
    """
    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 main_class: str,
                 main_jar_file_uri: str,
                 properties: Mapping[str, str]):
        """
        A Dataproc job for running Apache Spark (http://spark.apache.org/) applications on YARN.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        :param 'LoggingConfigResponseArgs' logging_config: Optional. The runtime log config for job execution.
        :param str main_class: The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris.
        :param str main_jar_file_uri: The HCFS URI of the jar file that contains the main class.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "main_class", main_class)
        pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> str:
        """
        The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> str:
        """
        The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SparkRJobResponse(dict):
    """
    A Dataproc job for running Apache SparkR (https://spark.apache.org/docs/latest/sparkr.html) applications on YARN.
    """
    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 main_r_file_uri: str,
                 properties: Mapping[str, str]):
        """
        A Dataproc job for running Apache SparkR (https://spark.apache.org/docs/latest/sparkr.html) applications on YARN.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param 'LoggingConfigResponseArgs' logging_config: Optional. The runtime log config for job execution.
        :param str main_r_file_uri: Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "main_r_file_uri", main_r_file_uri)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainRFileUri")
    def main_r_file_uri(self) -> str:
        """
        Required. The HCFS URI of the main R file to use as the driver. Must be a .R file.
        """
        return pulumi.get(self, "main_r_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class SparkSqlJobResponse(dict):
    """
    A Dataproc job for running Apache Spark SQL (http://spark.apache.org/sql/) queries.
    """
    def __init__(__self__, *,
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 properties: Mapping[str, str],
                 query_file_uri: str,
                 query_list: 'outputs.QueryListResponse',
                 script_variables: Mapping[str, str]):
        """
        A Dataproc job for running Apache Spark SQL (http://spark.apache.org/sql/) queries.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param 'LoggingConfigResponseArgs' logging_config: Optional. The runtime log config for job execution.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
        :param str query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param 'QueryListResponseArgs' query_list: A list of queries.
        :param Mapping[str, str] script_variables: Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_list", query_list)
        pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> 'outputs.QueryListResponse':
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Mapping[str, str]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        return pulumi.get(self, "script_variables")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class TemplateParameterResponse(dict):
    """
    A configurable parameter that replaces one or more fields in the template. Parameterizable fields: - Labels - File uris - Job properties - Job arguments - Script variables - Main class (in HadoopJob and SparkJob) - Zone (in ClusterSelector)
    """
    def __init__(__self__, *,
                 description: str,
                 fields: Sequence[str],
                 name: str,
                 validation: 'outputs.ParameterValidationResponse'):
        """
        A configurable parameter that replaces one or more fields in the template. Parameterizable fields: - Labels - File uris - Job properties - Job arguments - Script variables - Main class (in HadoopJob and SparkJob) - Zone (in ClusterSelector)
        :param str description: Optional. Brief description of the parameter. Must not exceed 1024 characters.
        :param Sequence[str] fields: Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths.A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as placement.clusterSelector.zone.Also, field paths can reference fields using the following syntax: Values in maps can be referenced by key: labels'key' placement.clusterSelector.clusterLabels'key' placement.managedCluster.labels'key' placement.clusterSelector.clusterLabels'key' jobs'step-id'.labels'key' Jobs in the jobs list can be referenced by step-id: jobs'step-id'.hadoopJob.mainJarFileUri jobs'step-id'.hiveJob.queryFileUri jobs'step-id'.pySparkJob.mainPythonFileUri jobs'step-id'.hadoopJob.jarFileUris0 jobs'step-id'.hadoopJob.archiveUris0 jobs'step-id'.hadoopJob.fileUris0 jobs'step-id'.pySparkJob.pythonFileUris0 Items in repeated fields can be referenced by a zero-based index: jobs'step-id'.sparkJob.args0 Other examples: jobs'step-id'.hadoopJob.properties'key' jobs'step-id'.hadoopJob.args0 jobs'step-id'.hiveJob.scriptVariables'key' jobs'step-id'.hadoopJob.mainJarFileUri placement.clusterSelector.zoneIt may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: placement.clusterSelector.clusterLabels jobs'step-id'.sparkJob.args
        :param str name: Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        :param 'ParameterValidationResponseArgs' validation: Optional. Validation rules to be applied to this parameter's value.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Brief description of the parameter. Must not exceed 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> Sequence[str]:
        """
        Required. Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths.A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as placement.clusterSelector.zone.Also, field paths can reference fields using the following syntax: Values in maps can be referenced by key: labels'key' placement.clusterSelector.clusterLabels'key' placement.managedCluster.labels'key' placement.clusterSelector.clusterLabels'key' jobs'step-id'.labels'key' Jobs in the jobs list can be referenced by step-id: jobs'step-id'.hadoopJob.mainJarFileUri jobs'step-id'.hiveJob.queryFileUri jobs'step-id'.pySparkJob.mainPythonFileUri jobs'step-id'.hadoopJob.jarFileUris0 jobs'step-id'.hadoopJob.archiveUris0 jobs'step-id'.hadoopJob.fileUris0 jobs'step-id'.pySparkJob.pythonFileUris0 Items in repeated fields can be referenced by a zero-based index: jobs'step-id'.sparkJob.args0 Other examples: jobs'step-id'.hadoopJob.properties'key' jobs'step-id'.hadoopJob.args0 jobs'step-id'.hiveJob.scriptVariables'key' jobs'step-id'.hadoopJob.mainJarFileUri placement.clusterSelector.zoneIt may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: placement.clusterSelector.clusterLabels jobs'step-id'.sparkJob.args
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Required. Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def validation(self) -> 'outputs.ParameterValidationResponse':
        """
        Optional. Validation rules to be applied to this parameter's value.
        """
        return pulumi.get(self, "validation")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class ValueValidationResponse(dict):
    """
    Validation based on a list of allowed values.
    """
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        Validation based on a list of allowed values.
        :param Sequence[str] values: Required. List of allowed values for the parameter.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Required. List of allowed values for the parameter.
        """
        return pulumi.get(self, "values")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


@pulumi.output_type
class WorkflowTemplatePlacementResponse(dict):
    """
    Specifies workflow execution target.Either managed_cluster or cluster_selector is required.
    """
    def __init__(__self__, *,
                 cluster_selector: 'outputs.ClusterSelectorResponse',
                 managed_cluster: 'outputs.ManagedClusterResponse'):
        """
        Specifies workflow execution target.Either managed_cluster or cluster_selector is required.
        :param 'ClusterSelectorResponseArgs' cluster_selector: Optional. A selector that chooses target cluster for jobs based on metadata.The selector is evaluated at the time each job is submitted.
        :param 'ManagedClusterResponseArgs' managed_cluster: A cluster that is managed by the workflow.
        """
        pulumi.set(__self__, "cluster_selector", cluster_selector)
        pulumi.set(__self__, "managed_cluster", managed_cluster)

    @property
    @pulumi.getter(name="clusterSelector")
    def cluster_selector(self) -> 'outputs.ClusterSelectorResponse':
        """
        Optional. A selector that chooses target cluster for jobs based on metadata.The selector is evaluated at the time each job is submitted.
        """
        return pulumi.get(self, "cluster_selector")

    @property
    @pulumi.getter(name="managedCluster")
    def managed_cluster(self) -> 'outputs.ManagedClusterResponse':
        """
        A cluster that is managed by the workflow.
        """
        return pulumi.get(self, "managed_cluster")

    def _translate_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop


