# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = ['VpnTunnel']


class VpnTunnel(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 creation_timestamp: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 detailed_status: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 ike_version: Optional[pulumi.Input[int]] = None,
                 kind: Optional[pulumi.Input[str]] = None,
                 local_traffic_selector: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 peer_external_gateway: Optional[pulumi.Input[str]] = None,
                 peer_external_gateway_interface: Optional[pulumi.Input[int]] = None,
                 peer_gcp_gateway: Optional[pulumi.Input[str]] = None,
                 peer_ip: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 remote_traffic_selector: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 router: Optional[pulumi.Input[str]] = None,
                 self_link: Optional[pulumi.Input[str]] = None,
                 shared_secret: Optional[pulumi.Input[str]] = None,
                 shared_secret_hash: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 target_vpn_gateway: Optional[pulumi.Input[str]] = None,
                 vpn_gateway: Optional[pulumi.Input[str]] = None,
                 vpn_gateway_interface: Optional[pulumi.Input[int]] = None,
                 vpn_tunnel: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a VpnTunnel resource in the specified project and region using the data included in the request.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_timestamp: [Output Only] Creation timestamp in RFC3339 text format.
        :param pulumi.Input[str] description: An optional description of this resource. Provide this property when you create the resource.
        :param pulumi.Input[str] detailed_status: [Output Only] Detailed status message for the VPN tunnel.
        :param pulumi.Input[str] id: [Output Only] The unique identifier for the resource. This identifier is defined by the server.
        :param pulumi.Input[int] ike_version: IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
        :param pulumi.Input[str] kind: [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] local_traffic_selector: Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported.
        :param pulumi.Input[str] name: Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        :param pulumi.Input[str] peer_external_gateway: URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
        :param pulumi.Input[int] peer_external_gateway_interface: The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created.
        :param pulumi.Input[str] peer_gcp_gateway: URL of the peer side HA GCP VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer GCP VPN gateway.
        :param pulumi.Input[str] peer_ip: IP address of the peer VPN gateway. Only IPv4 is supported.
        :param pulumi.Input[str] region: [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] remote_traffic_selector: Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported.
        :param pulumi.Input[str] router: URL of the router resource to be used for dynamic routing.
        :param pulumi.Input[str] self_link: [Output Only] Server-defined URL for the resource.
        :param pulumi.Input[str] shared_secret: Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
        :param pulumi.Input[str] shared_secret_hash: Hash of the shared secret.
        :param pulumi.Input[str] status: [Output Only] The status of the VPN tunnel, which can be one of the following: 
               - PROVISIONING: Resource is being allocated for the VPN tunnel. 
               - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. 
               - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. 
               - ESTABLISHED: Secure session is successfully established with the peer VPN. 
               - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS 
               - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). 
               - NEGOTIATION_FAILURE: Handshake failed. 
               - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. 
               - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. 
               - NO_INCOMING_PACKETS: No incoming packets from peer. 
               - REJECTED: Tunnel configuration was rejected, can be result of being denied access. 
               - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. 
               - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. 
               - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. 
               - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
        :param pulumi.Input[str] target_vpn_gateway: URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created.
        :param pulumi.Input[str] vpn_gateway: URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
        :param pulumi.Input[int] vpn_gateway_interface: The interface ID of the VPN gateway with which this VPN tunnel is associated.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['creation_timestamp'] = creation_timestamp
            __props__['description'] = description
            __props__['detailed_status'] = detailed_status
            __props__['id'] = id
            __props__['ike_version'] = ike_version
            __props__['kind'] = kind
            __props__['local_traffic_selector'] = local_traffic_selector
            __props__['name'] = name
            __props__['peer_external_gateway'] = peer_external_gateway
            __props__['peer_external_gateway_interface'] = peer_external_gateway_interface
            __props__['peer_gcp_gateway'] = peer_gcp_gateway
            __props__['peer_ip'] = peer_ip
            if project is None and not opts.urn:
                raise TypeError("Missing required property 'project'")
            __props__['project'] = project
            if region is None and not opts.urn:
                raise TypeError("Missing required property 'region'")
            __props__['region'] = region
            __props__['remote_traffic_selector'] = remote_traffic_selector
            __props__['router'] = router
            __props__['self_link'] = self_link
            __props__['shared_secret'] = shared_secret
            __props__['shared_secret_hash'] = shared_secret_hash
            __props__['status'] = status
            __props__['target_vpn_gateway'] = target_vpn_gateway
            __props__['vpn_gateway'] = vpn_gateway
            __props__['vpn_gateway_interface'] = vpn_gateway_interface
            if vpn_tunnel is None and not opts.urn:
                raise TypeError("Missing required property 'vpn_tunnel'")
            __props__['vpn_tunnel'] = vpn_tunnel
        super(VpnTunnel, __self__).__init__(
            'gcp-native:compute/v1:VpnTunnel',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'VpnTunnel':
        """
        Get an existing VpnTunnel resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["creation_timestamp"] = None
        __props__["description"] = None
        __props__["detailed_status"] = None
        __props__["ike_version"] = None
        __props__["kind"] = None
        __props__["local_traffic_selector"] = None
        __props__["name"] = None
        __props__["peer_external_gateway"] = None
        __props__["peer_external_gateway_interface"] = None
        __props__["peer_gcp_gateway"] = None
        __props__["peer_ip"] = None
        __props__["region"] = None
        __props__["remote_traffic_selector"] = None
        __props__["router"] = None
        __props__["self_link"] = None
        __props__["shared_secret"] = None
        __props__["shared_secret_hash"] = None
        __props__["status"] = None
        __props__["target_vpn_gateway"] = None
        __props__["vpn_gateway"] = None
        __props__["vpn_gateway_interface"] = None
        return VpnTunnel(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTimestamp")
    def creation_timestamp(self) -> pulumi.Output[str]:
        """
        [Output Only] Creation timestamp in RFC3339 text format.
        """
        return pulumi.get(self, "creation_timestamp")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        An optional description of this resource. Provide this property when you create the resource.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="detailedStatus")
    def detailed_status(self) -> pulumi.Output[str]:
        """
        [Output Only] Detailed status message for the VPN tunnel.
        """
        return pulumi.get(self, "detailed_status")

    @property
    @pulumi.getter(name="ikeVersion")
    def ike_version(self) -> pulumi.Output[int]:
        """
        IKE protocol version to use when establishing the VPN tunnel with the peer VPN gateway. Acceptable IKE versions are 1 or 2. The default version is 2.
        """
        return pulumi.get(self, "ike_version")

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Output[str]:
        """
        [Output Only] Type of resource. Always compute#vpnTunnel for VPN tunnels.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="localTrafficSelector")
    def local_traffic_selector(self) -> pulumi.Output[Sequence[str]]:
        """
        Local traffic selector to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges must be disjoint. Only IPv4 is supported.
        """
        return pulumi.get(self, "local_traffic_selector")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="peerExternalGateway")
    def peer_external_gateway(self) -> pulumi.Output[str]:
        """
        URL of the peer side external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field is exclusive with the field peerGcpGateway.
        """
        return pulumi.get(self, "peer_external_gateway")

    @property
    @pulumi.getter(name="peerExternalGatewayInterface")
    def peer_external_gateway_interface(self) -> pulumi.Output[int]:
        """
        The interface ID of the external VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created.
        """
        return pulumi.get(self, "peer_external_gateway_interface")

    @property
    @pulumi.getter(name="peerGcpGateway")
    def peer_gcp_gateway(self) -> pulumi.Output[str]:
        """
        URL of the peer side HA GCP VPN gateway to which this VPN tunnel is connected. Provided by the client when the VPN tunnel is created. This field can be used when creating highly available VPN from VPC network to VPC network, the field is exclusive with the field peerExternalGateway. If provided, the VPN tunnel will automatically use the same vpnGatewayInterface ID in the peer GCP VPN gateway.
        """
        return pulumi.get(self, "peer_gcp_gateway")

    @property
    @pulumi.getter(name="peerIp")
    def peer_ip(self) -> pulumi.Output[str]:
        """
        IP address of the peer VPN gateway. Only IPv4 is supported.
        """
        return pulumi.get(self, "peer_ip")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[str]:
        """
        [Output Only] URL of the region where the VPN tunnel resides. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="remoteTrafficSelector")
    def remote_traffic_selector(self) -> pulumi.Output[Sequence[str]]:
        """
        Remote traffic selectors to use when establishing the VPN tunnel with the peer VPN gateway. The value should be a CIDR formatted string, for example: 192.168.0.0/16. The ranges should be disjoint. Only IPv4 is supported.
        """
        return pulumi.get(self, "remote_traffic_selector")

    @property
    @pulumi.getter
    def router(self) -> pulumi.Output[str]:
        """
        URL of the router resource to be used for dynamic routing.
        """
        return pulumi.get(self, "router")

    @property
    @pulumi.getter(name="selfLink")
    def self_link(self) -> pulumi.Output[str]:
        """
        [Output Only] Server-defined URL for the resource.
        """
        return pulumi.get(self, "self_link")

    @property
    @pulumi.getter(name="sharedSecret")
    def shared_secret(self) -> pulumi.Output[str]:
        """
        Shared secret used to set the secure session between the Cloud VPN gateway and the peer VPN gateway.
        """
        return pulumi.get(self, "shared_secret")

    @property
    @pulumi.getter(name="sharedSecretHash")
    def shared_secret_hash(self) -> pulumi.Output[str]:
        """
        Hash of the shared secret.
        """
        return pulumi.get(self, "shared_secret_hash")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        [Output Only] The status of the VPN tunnel, which can be one of the following: 
        - PROVISIONING: Resource is being allocated for the VPN tunnel. 
        - WAITING_FOR_FULL_CONFIG: Waiting to receive all VPN-related configs from the user. Network, TargetVpnGateway, VpnTunnel, ForwardingRule, and Route resources are needed to setup the VPN tunnel. 
        - FIRST_HANDSHAKE: Successful first handshake with the peer VPN. 
        - ESTABLISHED: Secure session is successfully established with the peer VPN. 
        - NETWORK_ERROR: Deprecated, replaced by NO_INCOMING_PACKETS 
        - AUTHORIZATION_ERROR: Auth error (for example, bad shared secret). 
        - NEGOTIATION_FAILURE: Handshake failed. 
        - DEPROVISIONING: Resources are being deallocated for the VPN tunnel. 
        - FAILED: Tunnel creation has failed and the tunnel is not ready to be used. 
        - NO_INCOMING_PACKETS: No incoming packets from peer. 
        - REJECTED: Tunnel configuration was rejected, can be result of being denied access. 
        - ALLOCATING_RESOURCES: Cloud VPN is in the process of allocating all required resources. 
        - STOPPED: Tunnel is stopped due to its Forwarding Rules being deleted for Classic VPN tunnels or the project is in frozen state. 
        - PEER_IDENTITY_MISMATCH: Peer identity does not match peer IP, probably behind NAT. 
        - TS_NARROWING_NOT_ALLOWED: Traffic selector narrowing not allowed for an HA-VPN tunnel.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="targetVpnGateway")
    def target_vpn_gateway(self) -> pulumi.Output[str]:
        """
        URL of the Target VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created.
        """
        return pulumi.get(self, "target_vpn_gateway")

    @property
    @pulumi.getter(name="vpnGateway")
    def vpn_gateway(self) -> pulumi.Output[str]:
        """
        URL of the VPN gateway with which this VPN tunnel is associated. Provided by the client when the VPN tunnel is created. This must be used (instead of target_vpn_gateway) if a High Availability VPN gateway resource is created.
        """
        return pulumi.get(self, "vpn_gateway")

    @property
    @pulumi.getter(name="vpnGatewayInterface")
    def vpn_gateway_interface(self) -> pulumi.Output[int]:
        """
        The interface ID of the VPN gateway with which this VPN tunnel is associated.
        """
        return pulumi.get(self, "vpn_gateway_interface")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

