# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables

__all__ = [
    'AllowedIpRangeArgs',
    'DatabaseConfigArgs',
    'EncryptionConfigArgs',
    'EnvironmentConfigArgs',
    'IPAllocationPolicyArgs',
    'MaintenanceWindowArgs',
    'NodeConfigArgs',
    'PrivateClusterConfigArgs',
    'PrivateEnvironmentConfigArgs',
    'SoftwareConfigArgs',
    'WebServerConfigArgs',
    'WebServerNetworkAccessControlArgs',
]

@pulumi.input_type
class AllowedIpRangeArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 value: Optional[pulumi.Input[str]] = None):
        """
        Allowed IP range with user-provided description.
        :param pulumi.Input[str] description: Optional. User-provided description. It must contain at most 300 characters.
        :param pulumi.Input[str] value: IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32` or `2001:0db8:0000:0042:0000:8a2e:0370:7334`. IP range prefixes should be properly truncated. For example, `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6, `2001:db8::1/32` should be truncated to `2001:db8::/32`.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if value is not None:
            pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. User-provided description. It must contain at most 300 characters.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def value(self) -> Optional[pulumi.Input[str]]:
        """
        IP address or range, defined using CIDR notation, of requests that this rule applies to. Examples: `192.168.1.1` or `192.168.0.0/16` or `2001:db8::/32` or `2001:0db8:0000:0042:0000:8a2e:0370:7334`. IP range prefixes should be properly truncated. For example, `1.2.3.4/24` should be truncated to `1.2.3.0/24`. Similarly, for IPv6, `2001:db8::1/32` should be truncated to `2001:db8::/32`.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class DatabaseConfigArgs:
    def __init__(__self__, *,
                 machine_type: Optional[pulumi.Input[str]] = None):
        """
        The configuration of Cloud SQL instance that is used by the Apache Airflow software.
        :param pulumi.Input[str] machine_type: Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Cloud SQL machine type used by Airflow database. It has to be one of: db-n1-standard-2, db-n1-standard-4, db-n1-standard-8 or db-n1-standard-16. If not specified, db-n1-standard-2 will be used.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)


@pulumi.input_type
class EncryptionConfigArgs:
    def __init__(__self__, *,
                 kms_key_name: Optional[pulumi.Input[str]] = None):
        """
        The encryption options for the Composer environment and its dependencies.
        :param pulumi.Input[str] kms_key_name: Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated. If not specified, Google-managed key will be used.
        """
        if kms_key_name is not None:
            pulumi.set(__self__, "kms_key_name", kms_key_name)

    @property
    @pulumi.getter(name="kmsKeyName")
    def kms_key_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Customer-managed Encryption Key available through Google's Key Management Service. Cannot be updated. If not specified, Google-managed key will be used.
        """
        return pulumi.get(self, "kms_key_name")

    @kms_key_name.setter
    def kms_key_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_name", value)


@pulumi.input_type
class EnvironmentConfigArgs:
    def __init__(__self__, *,
                 database_config: Optional[pulumi.Input['DatabaseConfigArgs']] = None,
                 encryption_config: Optional[pulumi.Input['EncryptionConfigArgs']] = None,
                 maintenance_window: Optional[pulumi.Input['MaintenanceWindowArgs']] = None,
                 node_config: Optional[pulumi.Input['NodeConfigArgs']] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 private_environment_config: Optional[pulumi.Input['PrivateEnvironmentConfigArgs']] = None,
                 software_config: Optional[pulumi.Input['SoftwareConfigArgs']] = None,
                 web_server_config: Optional[pulumi.Input['WebServerConfigArgs']] = None,
                 web_server_network_access_control: Optional[pulumi.Input['WebServerNetworkAccessControlArgs']] = None):
        """
        Configuration information for an environment.
        :param pulumi.Input['DatabaseConfigArgs'] database_config: Optional. The configuration settings for Cloud SQL instance used internally by Apache Airflow software.
        :param pulumi.Input['EncryptionConfigArgs'] encryption_config: Optional. The encryption options for the Composer environment and its dependencies. Cannot be updated.
        :param pulumi.Input['MaintenanceWindowArgs'] maintenance_window: Optional. The maintenance window is the period when Cloud Composer components may undergo maintenance. It is defined so that maintenance is not executed during peak hours or critical time periods. The system will not be under maintenance for every occurrence of this window, but when maintenance is planned, it will be scheduled during the window. The maintenance window period must encompass at least 12 hours per week. This may be split into multiple chunks, each with a size of at least 4 hours. If this value is omitted, Cloud Composer components may be subject to maintenance at any time.
        :param pulumi.Input['NodeConfigArgs'] node_config: The configuration used for the Kubernetes Engine cluster.
        :param pulumi.Input[int] node_count: The number of nodes in the Kubernetes Engine cluster that will be used to run this environment.
        :param pulumi.Input['PrivateEnvironmentConfigArgs'] private_environment_config: The configuration used for the Private IP Cloud Composer environment.
        :param pulumi.Input['SoftwareConfigArgs'] software_config: The configuration settings for software inside the environment.
        :param pulumi.Input['WebServerConfigArgs'] web_server_config: Optional. The configuration settings for the Airflow web server App Engine instance.
        :param pulumi.Input['WebServerNetworkAccessControlArgs'] web_server_network_access_control: Optional. The network-level access control policy for the Airflow web server. If unspecified, no network-level access restrictions will be applied.
        """
        if database_config is not None:
            pulumi.set(__self__, "database_config", database_config)
        if encryption_config is not None:
            pulumi.set(__self__, "encryption_config", encryption_config)
        if maintenance_window is not None:
            pulumi.set(__self__, "maintenance_window", maintenance_window)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if private_environment_config is not None:
            pulumi.set(__self__, "private_environment_config", private_environment_config)
        if software_config is not None:
            pulumi.set(__self__, "software_config", software_config)
        if web_server_config is not None:
            pulumi.set(__self__, "web_server_config", web_server_config)
        if web_server_network_access_control is not None:
            pulumi.set(__self__, "web_server_network_access_control", web_server_network_access_control)

    @property
    @pulumi.getter(name="databaseConfig")
    def database_config(self) -> Optional[pulumi.Input['DatabaseConfigArgs']]:
        """
        Optional. The configuration settings for Cloud SQL instance used internally by Apache Airflow software.
        """
        return pulumi.get(self, "database_config")

    @database_config.setter
    def database_config(self, value: Optional[pulumi.Input['DatabaseConfigArgs']]):
        pulumi.set(self, "database_config", value)

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> Optional[pulumi.Input['EncryptionConfigArgs']]:
        """
        Optional. The encryption options for the Composer environment and its dependencies. Cannot be updated.
        """
        return pulumi.get(self, "encryption_config")

    @encryption_config.setter
    def encryption_config(self, value: Optional[pulumi.Input['EncryptionConfigArgs']]):
        pulumi.set(self, "encryption_config", value)

    @property
    @pulumi.getter(name="maintenanceWindow")
    def maintenance_window(self) -> Optional[pulumi.Input['MaintenanceWindowArgs']]:
        """
        Optional. The maintenance window is the period when Cloud Composer components may undergo maintenance. It is defined so that maintenance is not executed during peak hours or critical time periods. The system will not be under maintenance for every occurrence of this window, but when maintenance is planned, it will be scheduled during the window. The maintenance window period must encompass at least 12 hours per week. This may be split into multiple chunks, each with a size of at least 4 hours. If this value is omitted, Cloud Composer components may be subject to maintenance at any time.
        """
        return pulumi.get(self, "maintenance_window")

    @maintenance_window.setter
    def maintenance_window(self, value: Optional[pulumi.Input['MaintenanceWindowArgs']]):
        pulumi.set(self, "maintenance_window", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['NodeConfigArgs']]:
        """
        The configuration used for the Kubernetes Engine cluster.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['NodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the Kubernetes Engine cluster that will be used to run this environment.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="privateEnvironmentConfig")
    def private_environment_config(self) -> Optional[pulumi.Input['PrivateEnvironmentConfigArgs']]:
        """
        The configuration used for the Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_environment_config")

    @private_environment_config.setter
    def private_environment_config(self, value: Optional[pulumi.Input['PrivateEnvironmentConfigArgs']]):
        pulumi.set(self, "private_environment_config", value)

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> Optional[pulumi.Input['SoftwareConfigArgs']]:
        """
        The configuration settings for software inside the environment.
        """
        return pulumi.get(self, "software_config")

    @software_config.setter
    def software_config(self, value: Optional[pulumi.Input['SoftwareConfigArgs']]):
        pulumi.set(self, "software_config", value)

    @property
    @pulumi.getter(name="webServerConfig")
    def web_server_config(self) -> Optional[pulumi.Input['WebServerConfigArgs']]:
        """
        Optional. The configuration settings for the Airflow web server App Engine instance.
        """
        return pulumi.get(self, "web_server_config")

    @web_server_config.setter
    def web_server_config(self, value: Optional[pulumi.Input['WebServerConfigArgs']]):
        pulumi.set(self, "web_server_config", value)

    @property
    @pulumi.getter(name="webServerNetworkAccessControl")
    def web_server_network_access_control(self) -> Optional[pulumi.Input['WebServerNetworkAccessControlArgs']]:
        """
        Optional. The network-level access control policy for the Airflow web server. If unspecified, no network-level access restrictions will be applied.
        """
        return pulumi.get(self, "web_server_network_access_control")

    @web_server_network_access_control.setter
    def web_server_network_access_control(self, value: Optional[pulumi.Input['WebServerNetworkAccessControlArgs']]):
        pulumi.set(self, "web_server_network_access_control", value)


@pulumi.input_type
class IPAllocationPolicyArgs:
    def __init__(__self__, *,
                 cluster_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 cluster_secondary_range_name: Optional[pulumi.Input[str]] = None,
                 services_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 services_secondary_range_name: Optional[pulumi.Input[str]] = None,
                 use_ip_aliases: Optional[pulumi.Input[bool]] = None):
        """
        Configuration for controlling how IPs are allocated in the GKE cluster.
        :param pulumi.Input[str] cluster_ipv4_cidr_block: Optional. The IP address range used to allocate IP addresses to pods in the cluster. This field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block` but not both.
        :param pulumi.Input[str] cluster_secondary_range_name: Optional. The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either `cluster_secondary_range_name` or `cluster_ipv4_cidr_block` but not both. This field is applicable only when `use_ip_aliases` is true.
        :param pulumi.Input[str] services_ipv4_cidr_block: Optional. The IP address range of the services IP addresses in this cluster. This field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. Specify `services_secondary_range_name` or `services_ipv4_cidr_block` but not both.
        :param pulumi.Input[str] services_secondary_range_name: Optional. The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either `services_secondary_range_name` or `services_ipv4_cidr_block` but not both. This field is applicable only when `use_ip_aliases` is true.
        :param pulumi.Input[bool] use_ip_aliases: Optional. Whether or not to enable Alias IPs in the GKE cluster. If `true`, a VPC-native cluster is created.
        """
        if cluster_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cluster_ipv4_cidr_block", cluster_ipv4_cidr_block)
        if cluster_secondary_range_name is not None:
            pulumi.set(__self__, "cluster_secondary_range_name", cluster_secondary_range_name)
        if services_ipv4_cidr_block is not None:
            pulumi.set(__self__, "services_ipv4_cidr_block", services_ipv4_cidr_block)
        if services_secondary_range_name is not None:
            pulumi.set(__self__, "services_secondary_range_name", services_secondary_range_name)
        if use_ip_aliases is not None:
            pulumi.set(__self__, "use_ip_aliases", use_ip_aliases)

    @property
    @pulumi.getter(name="clusterIpv4CidrBlock")
    def cluster_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The IP address range used to allocate IP addresses to pods in the cluster. This field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. Specify `cluster_secondary_range_name` or `cluster_ipv4_cidr_block` but not both.
        """
        return pulumi.get(self, "cluster_ipv4_cidr_block")

    @cluster_ipv4_cidr_block.setter
    def cluster_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="clusterSecondaryRangeName")
    def cluster_secondary_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the cluster's secondary range used to allocate IP addresses to pods. Specify either `cluster_secondary_range_name` or `cluster_ipv4_cidr_block` but not both. This field is applicable only when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "cluster_secondary_range_name")

    @cluster_secondary_range_name.setter
    def cluster_secondary_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_secondary_range_name", value)

    @property
    @pulumi.getter(name="servicesIpv4CidrBlock")
    def services_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The IP address range of the services IP addresses in this cluster. This field is applicable only when `use_ip_aliases` is true. Set to blank to have GKE choose a range with the default size. Set to /netmask (e.g. `/14`) to have GKE choose a range with a specific netmask. Set to a [CIDR](http://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing) notation (e.g. `10.96.0.0/14`) from the RFC-1918 private networks (e.g. `10.0.0.0/8`, `172.16.0.0/12`, `192.168.0.0/16`) to pick a specific range to use. Specify `services_secondary_range_name` or `services_ipv4_cidr_block` but not both.
        """
        return pulumi.get(self, "services_ipv4_cidr_block")

    @services_ipv4_cidr_block.setter
    def services_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="servicesSecondaryRangeName")
    def services_secondary_range_name(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The name of the services' secondary range used to allocate IP addresses to the cluster. Specify either `services_secondary_range_name` or `services_ipv4_cidr_block` but not both. This field is applicable only when `use_ip_aliases` is true.
        """
        return pulumi.get(self, "services_secondary_range_name")

    @services_secondary_range_name.setter
    def services_secondary_range_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "services_secondary_range_name", value)

    @property
    @pulumi.getter(name="useIpAliases")
    def use_ip_aliases(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. Whether or not to enable Alias IPs in the GKE cluster. If `true`, a VPC-native cluster is created.
        """
        return pulumi.get(self, "use_ip_aliases")

    @use_ip_aliases.setter
    def use_ip_aliases(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "use_ip_aliases", value)


@pulumi.input_type
class MaintenanceWindowArgs:
    def __init__(__self__, *,
                 end_time: Optional[pulumi.Input[str]] = None,
                 recurrence: Optional[pulumi.Input[str]] = None,
                 start_time: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings for Cloud Composer maintenance window. The following example: { "startTime":"2019-08-01T01:00:00Z" "endTime":"2019-08-01T07:00:00Z" "recurrence":"FREQ=WEEKLY;BYDAY=TU,WE" } would define a maintenance window between 01 and 07 hours UTC during each Tuesday and Wednesday.
        :param pulumi.Input[str] end_time: Required. Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end_time must be in the future, relative to `start_time`.
        :param pulumi.Input[str] recurrence: Required. Maintenance window recurrence. Format is a subset of [RFC-5545](https://tools.ietf.org/html/rfc5545) `RRULE`. The only allowed values for `FREQ` field are `FREQ=DAILY` and `FREQ=WEEKLY;BYDAY=...` Example values: `FREQ=WEEKLY;BYDAY=TU,WE`, `FREQ=DAILY`.
        :param pulumi.Input[str] start_time: Required. Start time of the first recurrence of the maintenance window.
        """
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if recurrence is not None:
            pulumi.set(__self__, "recurrence", recurrence)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Maintenance window end time. It is used only to calculate the duration of the maintenance window. The value for end_time must be in the future, relative to `start_time`.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter
    def recurrence(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Maintenance window recurrence. Format is a subset of [RFC-5545](https://tools.ietf.org/html/rfc5545) `RRULE`. The only allowed values for `FREQ` field are `FREQ=DAILY` and `FREQ=WEEKLY;BYDAY=...` Example values: `FREQ=WEEKLY;BYDAY=TU,WE`, `FREQ=DAILY`.
        """
        return pulumi.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "recurrence", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Required. Start time of the first recurrence of the maintenance window.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class NodeConfigArgs:
    def __init__(__self__, *,
                 disk_size_gb: Optional[pulumi.Input[int]] = None,
                 ip_allocation_policy: Optional[pulumi.Input['IPAllocationPolicyArgs']] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 machine_type: Optional[pulumi.Input[str]] = None,
                 max_pods_per_node: Optional[pulumi.Input[int]] = None,
                 network: Optional[pulumi.Input[str]] = None,
                 oauth_scopes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_account: Optional[pulumi.Input[str]] = None,
                 subnetwork: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The configuration information for the Kubernetes Engine nodes running the Apache Airflow software.
        :param pulumi.Input[int] disk_size_gb: Optional. The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated.
        :param pulumi.Input['IPAllocationPolicyArgs'] ip_allocation_policy: Optional. The IPAllocationPolicy fields for the GKE cluster.
        :param pulumi.Input[str] location: Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which to deploy the VMs used to run the Apache Airflow software, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}". This `location` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.machineType` are specified, `nodeConfig.machineType` must belong to this `location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If only one field (`location` or `nodeConfig.machineType`) is specified, the location information from the specified field will be propagated to the unspecified field.
        :param pulumi.Input[str] machine_type: Optional. The Compute Engine [machine type](/compute/docs/machine-types) used for cluster instances, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}". The `machineType` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.location` are specified, this `machineType` must belong to the `nodeConfig.location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If exactly one of this field and `nodeConfig.location` is specified, the location information from the specified field will be propagated to the unspecified field. The `machineTypeId` must not be a [shared-core machine type](/compute/docs/machine-types#sharedcore). If this field is unspecified, the `machineTypeId` defaults to "n1-standard-1".
        :param pulumi.Input[int] max_pods_per_node: Optional. The maximum number of pods per node in the Cloud Composer GKE cluster. The value must be between 8 and 110 and it can be set only if the environment is VPC-native. The default value is 32. Values of this field will be propagated both to the `default-pool` node pool of the newly created GKE cluster, and to the default "Maximum Pods per Node" value which is used for newly created node pools if their value is not explicitly set during node pool creation. For more information, see [Optimizing IP address allocation] (https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr). Cannot be updated.
        :param pulumi.Input[str] network: Optional. The Compute Engine network to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/global/networks/{networkId}". If unspecified, the default network in the environment's project is used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets) is provided, `nodeConfig.subnetwork` must also be provided. For [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see `nodeConfig.subnetwork`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oauth_scopes: Optional. The set of Google API scopes to be made available on all node VMs. If `oauth_scopes` is empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
        :param pulumi.Input[str] service_account: Optional. The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated.
        :param pulumi.Input[str] subnetwork: Optional. The Compute Engine subnetwork to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}" If a subnetwork is provided, `nodeConfig.network` must also be provided, and the subnetwork must belong to the enclosing environment's project and location.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: Optional. The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Cannot be updated.
        """
        if disk_size_gb is not None:
            pulumi.set(__self__, "disk_size_gb", disk_size_gb)
        if ip_allocation_policy is not None:
            pulumi.set(__self__, "ip_allocation_policy", ip_allocation_policy)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)
        if max_pods_per_node is not None:
            pulumi.set(__self__, "max_pods_per_node", max_pods_per_node)
        if network is not None:
            pulumi.set(__self__, "network", network)
        if oauth_scopes is not None:
            pulumi.set(__self__, "oauth_scopes", oauth_scopes)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="diskSizeGb")
    def disk_size_gb(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The disk size in GB used for node VMs. Minimum size is 20GB. If unspecified, defaults to 100GB. Cannot be updated.
        """
        return pulumi.get(self, "disk_size_gb")

    @disk_size_gb.setter
    def disk_size_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "disk_size_gb", value)

    @property
    @pulumi.getter(name="ipAllocationPolicy")
    def ip_allocation_policy(self) -> Optional[pulumi.Input['IPAllocationPolicyArgs']]:
        """
        Optional. The IPAllocationPolicy fields for the GKE cluster.
        """
        return pulumi.get(self, "ip_allocation_policy")

    @ip_allocation_policy.setter
    def ip_allocation_policy(self, value: Optional[pulumi.Input['IPAllocationPolicyArgs']]):
        pulumi.set(self, "ip_allocation_policy", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine [zone](/compute/docs/regions-zones) in which to deploy the VMs used to run the Apache Airflow software, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}". This `location` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.machineType` are specified, `nodeConfig.machineType` must belong to this `location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If only one field (`location` or `nodeConfig.machineType`) is specified, the location information from the specified field will be propagated to the unspecified field.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine [machine type](/compute/docs/machine-types) used for cluster instances, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/zones/{zoneId}/machineTypes/{machineTypeId}". The `machineType` must belong to the enclosing environment's project and location. If both this field and `nodeConfig.location` are specified, this `machineType` must belong to the `nodeConfig.location`; if both are unspecified, the service will pick a zone in the Compute Engine region corresponding to the Cloud Composer location, and propagate that choice to both fields. If exactly one of this field and `nodeConfig.location` is specified, the location information from the specified field will be propagated to the unspecified field. The `machineTypeId` must not be a [shared-core machine type](/compute/docs/machine-types#sharedcore). If this field is unspecified, the `machineTypeId` defaults to "n1-standard-1".
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[pulumi.Input[int]]:
        """
        Optional. The maximum number of pods per node in the Cloud Composer GKE cluster. The value must be between 8 and 110 and it can be set only if the environment is VPC-native. The default value is 32. Values of this field will be propagated both to the `default-pool` node pool of the newly created GKE cluster, and to the default "Maximum Pods per Node" value which is used for newly created node pools if their value is not explicitly set during node pool creation. For more information, see [Optimizing IP address allocation] (https://cloud.google.com/kubernetes-engine/docs/how-to/flexible-pod-cidr). Cannot be updated.
        """
        return pulumi.get(self, "max_pods_per_node")

    @max_pods_per_node.setter
    def max_pods_per_node(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_pods_per_node", value)

    @property
    @pulumi.getter
    def network(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine network to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/global/networks/{networkId}". If unspecified, the default network in the environment's project is used. If a [Custom Subnet Network](/vpc/docs/vpc#vpc_networks_and_subnets) is provided, `nodeConfig.subnetwork` must also be provided. For [Shared VPC](/vpc/docs/shared-vpc) subnetwork requirements, see `nodeConfig.subnetwork`.
        """
        return pulumi.get(self, "network")

    @network.setter
    def network(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network", value)

    @property
    @pulumi.getter(name="oauthScopes")
    def oauth_scopes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The set of Google API scopes to be made available on all node VMs. If `oauth_scopes` is empty, defaults to ["https://www.googleapis.com/auth/cloud-platform"]. Cannot be updated.
        """
        return pulumi.get(self, "oauth_scopes")

    @oauth_scopes.setter
    def oauth_scopes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oauth_scopes", value)

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Google Cloud Platform Service Account to be used by the node VMs. If a service account is not specified, the "default" Compute Engine service account is used. Cannot be updated.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_account", value)

    @property
    @pulumi.getter
    def subnetwork(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The Compute Engine subnetwork to be used for machine communications, specified as a [relative resource name](/apis/design/resource_names#relative_resource_name). For example: "projects/{projectId}/regions/{regionId}/subnetworks/{subnetworkId}" If a subnetwork is provided, `nodeConfig.network` must also be provided, and the subnetwork must belong to the enclosing environment's project and location.
        """
        return pulumi.get(self, "subnetwork")

    @subnetwork.setter
    def subnetwork(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnetwork", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The list of instance tags applied to all node VMs. Tags are used to identify valid sources or targets for network firewalls. Each tag within the list must comply with [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Cannot be updated.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class PrivateClusterConfigArgs:
    def __init__(__self__, *,
                 enable_private_endpoint: Optional[pulumi.Input[bool]] = None,
                 master_ipv4_cidr_block: Optional[pulumi.Input[str]] = None):
        """
        Configuration options for the private GKE cluster in a Cloud Composer environment.
        :param pulumi.Input[bool] enable_private_endpoint: Optional. If `true`, access to the public endpoint of the GKE cluster is denied.
        :param pulumi.Input[str] master_ipv4_cidr_block: Optional. The CIDR block from which IPv4 range for GKE master will be reserved. If left blank, the default value of '172.16.0.0/23' is used.
        """
        if enable_private_endpoint is not None:
            pulumi.set(__self__, "enable_private_endpoint", enable_private_endpoint)
        if master_ipv4_cidr_block is not None:
            pulumi.set(__self__, "master_ipv4_cidr_block", master_ipv4_cidr_block)

    @property
    @pulumi.getter(name="enablePrivateEndpoint")
    def enable_private_endpoint(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If `true`, access to the public endpoint of the GKE cluster is denied.
        """
        return pulumi.get(self, "enable_private_endpoint")

    @enable_private_endpoint.setter
    def enable_private_endpoint(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_endpoint", value)

    @property
    @pulumi.getter(name="masterIpv4CidrBlock")
    def master_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The CIDR block from which IPv4 range for GKE master will be reserved. If left blank, the default value of '172.16.0.0/23' is used.
        """
        return pulumi.get(self, "master_ipv4_cidr_block")

    @master_ipv4_cidr_block.setter
    def master_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_ipv4_cidr_block", value)


@pulumi.input_type
class PrivateEnvironmentConfigArgs:
    def __init__(__self__, *,
                 cloud_sql_ipv4_cidr_block: Optional[pulumi.Input[str]] = None,
                 enable_private_environment: Optional[pulumi.Input[bool]] = None,
                 private_cluster_config: Optional[pulumi.Input['PrivateClusterConfigArgs']] = None,
                 web_server_ipv4_cidr_block: Optional[pulumi.Input[str]] = None):
        """
        The configuration information for configuring a Private IP Cloud Composer environment.
        :param pulumi.Input[str] cloud_sql_ipv4_cidr_block: Optional. The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block
        :param pulumi.Input[bool] enable_private_environment: Optional. If `true`, a Private IP Cloud Composer environment is created. If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be set to true.
        :param pulumi.Input['PrivateClusterConfigArgs'] private_cluster_config: Optional. Configuration for the private GKE cluster for a Private IP Cloud Composer environment.
        :param pulumi.Input[str] web_server_ipv4_cidr_block: Optional. The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block.
        """
        if cloud_sql_ipv4_cidr_block is not None:
            pulumi.set(__self__, "cloud_sql_ipv4_cidr_block", cloud_sql_ipv4_cidr_block)
        if enable_private_environment is not None:
            pulumi.set(__self__, "enable_private_environment", enable_private_environment)
        if private_cluster_config is not None:
            pulumi.set(__self__, "private_cluster_config", private_cluster_config)
        if web_server_ipv4_cidr_block is not None:
            pulumi.set(__self__, "web_server_ipv4_cidr_block", web_server_ipv4_cidr_block)

    @property
    @pulumi.getter(name="cloudSqlIpv4CidrBlock")
    def cloud_sql_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The CIDR block from which IP range in tenant project will be reserved for Cloud SQL. Needs to be disjoint from web_server_ipv4_cidr_block
        """
        return pulumi.get(self, "cloud_sql_ipv4_cidr_block")

    @cloud_sql_ipv4_cidr_block.setter
    def cloud_sql_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloud_sql_ipv4_cidr_block", value)

    @property
    @pulumi.getter(name="enablePrivateEnvironment")
    def enable_private_environment(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If `true`, a Private IP Cloud Composer environment is created. If this field is set to true, `IPAllocationPolicy.use_ip_aliases` must be set to true.
        """
        return pulumi.get(self, "enable_private_environment")

    @enable_private_environment.setter
    def enable_private_environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_private_environment", value)

    @property
    @pulumi.getter(name="privateClusterConfig")
    def private_cluster_config(self) -> Optional[pulumi.Input['PrivateClusterConfigArgs']]:
        """
        Optional. Configuration for the private GKE cluster for a Private IP Cloud Composer environment.
        """
        return pulumi.get(self, "private_cluster_config")

    @private_cluster_config.setter
    def private_cluster_config(self, value: Optional[pulumi.Input['PrivateClusterConfigArgs']]):
        pulumi.set(self, "private_cluster_config", value)

    @property
    @pulumi.getter(name="webServerIpv4CidrBlock")
    def web_server_ipv4_cidr_block(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The CIDR block from which IP range for web server will be reserved. Needs to be disjoint from private_cluster_config.master_ipv4_cidr_block and cloud_sql_ipv4_cidr_block.
        """
        return pulumi.get(self, "web_server_ipv4_cidr_block")

    @web_server_ipv4_cidr_block.setter
    def web_server_ipv4_cidr_block(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "web_server_ipv4_cidr_block", value)


@pulumi.input_type
class SoftwareConfigArgs:
    def __init__(__self__, *,
                 airflow_config_overrides: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 env_variables: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 image_version: Optional[pulumi.Input[str]] = None,
                 pypi_packages: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 python_version: Optional[pulumi.Input[str]] = None):
        """
        Specifies the selection and configuration of software inside the environment.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] airflow_config_overrides: Optional. Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and must not contain an equals sign ("=") or semicolon (";"). Section and property names must not contain a period ("."). Apache Airflow configuration property names must be written in [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are [blocked](/composer/docs/concepts/airflow-configurations), and cannot be overridden.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_variables: Optional. Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression `a-zA-Z_*`. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the following reserved names: * `AIRFLOW_HOME` * `C_FORCE_ROOT` * `CONTAINER_NAME` * `DAGS_FOLDER` * `GCP_PROJECT` * `GCS_BUCKET` * `GKE_CLUSTER_NAME` * `SQL_DATABASE` * `SQL_INSTANCE` * `SQL_PASSWORD` * `SQL_PROJECT` * `SQL_REGION` * `SQL_USER`
        :param pulumi.Input[str] image_version: The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression `composer-([0-9]+\.[0-9]+\.[0-9]+|latest)-airflow-[0-9]+\.[0-9]+(\.[0-9]+.*)?`. When used as input, the server also checks if the provided version is supported and denies the request for an unsupported version. The Cloud Composer portion of the version is a [semantic version](https://semver.org) or `latest`. When the patch version is omitted, the current Cloud Composer patch version is selected. When `latest` is provided instead of an explicit version number, the server replaces `latest` with the current Cloud Composer version and stores that version number in the same field. The portion of the image version that follows *airflow-* is an official Apache Airflow repository [release name](https://github.com/apache/incubator-airflow/releases). See also [Version List](/composer/docs/concepts/versioning/composer-versions).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] pypi_packages: Optional. Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name such as "numpy" and values are the lowercase extras and version specifier such as "==1.12.0", "[devel,gcp_api]", or "[devel]>=1.8.2, <1.9.2". To specify a package without pinning it to a version specifier, use the empty string as the value.
        :param pulumi.Input[str] python_version: Optional. The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated.
        """
        if airflow_config_overrides is not None:
            pulumi.set(__self__, "airflow_config_overrides", airflow_config_overrides)
        if env_variables is not None:
            pulumi.set(__self__, "env_variables", env_variables)
        if image_version is not None:
            pulumi.set(__self__, "image_version", image_version)
        if pypi_packages is not None:
            pulumi.set(__self__, "pypi_packages", pypi_packages)
        if python_version is not None:
            pulumi.set(__self__, "python_version", python_version)

    @property
    @pulumi.getter(name="airflowConfigOverrides")
    def airflow_config_overrides(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Apache Airflow configuration properties to override. Property keys contain the section and property names, separated by a hyphen, for example "core-dags_are_paused_at_creation". Section names must not contain hyphens ("-"), opening square brackets ("["), or closing square brackets ("]"). The property name must not be empty and must not contain an equals sign ("=") or semicolon (";"). Section and property names must not contain a period ("."). Apache Airflow configuration property names must be written in [snake_case](https://en.wikipedia.org/wiki/Snake_case). Property values can contain any character, and can be written in any lower/upper case format. Certain Apache Airflow configuration property values are [blocked](/composer/docs/concepts/airflow-configurations), and cannot be overridden.
        """
        return pulumi.get(self, "airflow_config_overrides")

    @airflow_config_overrides.setter
    def airflow_config_overrides(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "airflow_config_overrides", value)

    @property
    @pulumi.getter(name="envVariables")
    def env_variables(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Additional environment variables to provide to the Apache Airflow scheduler, worker, and webserver processes. Environment variable names must match the regular expression `a-zA-Z_*`. They cannot specify Apache Airflow software configuration overrides (they cannot match the regular expression `AIRFLOW__[A-Z0-9_]+__[A-Z0-9_]+`), and they cannot match any of the following reserved names: * `AIRFLOW_HOME` * `C_FORCE_ROOT` * `CONTAINER_NAME` * `DAGS_FOLDER` * `GCP_PROJECT` * `GCS_BUCKET` * `GKE_CLUSTER_NAME` * `SQL_DATABASE` * `SQL_INSTANCE` * `SQL_PASSWORD` * `SQL_PROJECT` * `SQL_REGION` * `SQL_USER`
        """
        return pulumi.get(self, "env_variables")

    @env_variables.setter
    def env_variables(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env_variables", value)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the software running in the environment. This encapsulates both the version of Cloud Composer functionality and the version of Apache Airflow. It must match the regular expression `composer-([0-9]+\.[0-9]+\.[0-9]+|latest)-airflow-[0-9]+\.[0-9]+(\.[0-9]+.*)?`. When used as input, the server also checks if the provided version is supported and denies the request for an unsupported version. The Cloud Composer portion of the version is a [semantic version](https://semver.org) or `latest`. When the patch version is omitted, the current Cloud Composer patch version is selected. When `latest` is provided instead of an explicit version number, the server replaces `latest` with the current Cloud Composer version and stores that version number in the same field. The portion of the image version that follows *airflow-* is an official Apache Airflow repository [release name](https://github.com/apache/incubator-airflow/releases). See also [Version List](/composer/docs/concepts/versioning/composer-versions).
        """
        return pulumi.get(self, "image_version")

    @image_version.setter
    def image_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "image_version", value)

    @property
    @pulumi.getter(name="pypiPackages")
    def pypi_packages(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. Custom Python Package Index (PyPI) packages to be installed in the environment. Keys refer to the lowercase package name such as "numpy" and values are the lowercase extras and version specifier such as "==1.12.0", "[devel,gcp_api]", or "[devel]>=1.8.2, <1.9.2". To specify a package without pinning it to a version specifier, use the empty string as the value.
        """
        return pulumi.get(self, "pypi_packages")

    @pypi_packages.setter
    def pypi_packages(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "pypi_packages", value)

    @property
    @pulumi.getter(name="pythonVersion")
    def python_version(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. The major version of Python used to run the Apache Airflow scheduler, worker, and webserver processes. Can be set to '2' or '3'. If not specified, the default is '2'. Cannot be updated.
        """
        return pulumi.get(self, "python_version")

    @python_version.setter
    def python_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "python_version", value)


@pulumi.input_type
class WebServerConfigArgs:
    def __init__(__self__, *,
                 machine_type: Optional[pulumi.Input[str]] = None):
        """
        The configuration settings for the Airflow web server App Engine instance.
        :param pulumi.Input[str] machine_type: Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        if machine_type is not None:
            pulumi.set(__self__, "machine_type", machine_type)

    @property
    @pulumi.getter(name="machineType")
    def machine_type(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Machine type on which Airflow web server is running. It has to be one of: composer-n1-webserver-2, composer-n1-webserver-4 or composer-n1-webserver-8. If not specified, composer-n1-webserver-2 will be used. Value custom is returned only in response, if Airflow web server parameters were manually changed to a non-standard values.
        """
        return pulumi.get(self, "machine_type")

    @machine_type.setter
    def machine_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "machine_type", value)


@pulumi.input_type
class WebServerNetworkAccessControlArgs:
    def __init__(__self__, *,
                 allowed_ip_ranges: Optional[pulumi.Input[Sequence[pulumi.Input['AllowedIpRangeArgs']]]] = None):
        """
        Network-level access control policy for the Airflow web server.
        :param pulumi.Input[Sequence[pulumi.Input['AllowedIpRangeArgs']]] allowed_ip_ranges: A collection of allowed IP ranges with descriptions.
        """
        if allowed_ip_ranges is not None:
            pulumi.set(__self__, "allowed_ip_ranges", allowed_ip_ranges)

    @property
    @pulumi.getter(name="allowedIpRanges")
    def allowed_ip_ranges(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AllowedIpRangeArgs']]]]:
        """
        A collection of allowed IP ranges with descriptions.
        """
        return pulumi.get(self, "allowed_ip_ranges")

    @allowed_ip_ranges.setter
    def allowed_ip_ranges(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AllowedIpRangeArgs']]]]):
        pulumi.set(self, "allowed_ip_ranges", value)


