# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['SettingSearchapplication']


class SettingSearchapplication(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 data_source_restrictions: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSourceRestrictionArgs']]]]] = None,
                 default_facet_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FacetOptionsArgs']]]]] = None,
                 default_sort_options: Optional[pulumi.Input[pulumi.InputType['SortOptionsArgs']]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 scoring_config: Optional[pulumi.Input[pulumi.InputType['ScoringConfigArgs']]] = None,
                 searchapplications_id: Optional[pulumi.Input[str]] = None,
                 source_config: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceConfigArgs']]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a search application. **Note:** This API requires an admin account to execute.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DataSourceRestrictionArgs']]]] data_source_restrictions: Retrictions applied to the configurations. The maximum number of elements is 10.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['FacetOptionsArgs']]]] default_facet_options: The default fields for returning facet results. The sources specified here also have been included in data_source_restrictions above.
        :param pulumi.Input[pulumi.InputType['SortOptionsArgs']] default_sort_options: The default options for sorting the search results
        :param pulumi.Input[str] display_name: Display name of the Search Application. The maximum length is 300 characters.
        :param pulumi.Input[str] name: Name of the Search Application. Format: searchapplications/{application_id}.
        :param pulumi.Input[pulumi.InputType['ScoringConfigArgs']] scoring_config: Configuration for ranking results.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SourceConfigArgs']]]] source_config: Configuration for a sources specified in data_source_restrictions.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['data_source_restrictions'] = data_source_restrictions
            __props__['default_facet_options'] = default_facet_options
            __props__['default_sort_options'] = default_sort_options
            __props__['display_name'] = display_name
            __props__['name'] = name
            __props__['scoring_config'] = scoring_config
            if searchapplications_id is None and not opts.urn:
                raise TypeError("Missing required property 'searchapplications_id'")
            __props__['searchapplications_id'] = searchapplications_id
            __props__['source_config'] = source_config
            __props__['operation_ids'] = None
        super(SettingSearchapplication, __self__).__init__(
            'gcp-native:cloudsearch/v1:SettingSearchapplication',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'SettingSearchapplication':
        """
        Get an existing SettingSearchapplication resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["data_source_restrictions"] = None
        __props__["default_facet_options"] = None
        __props__["default_sort_options"] = None
        __props__["display_name"] = None
        __props__["name"] = None
        __props__["operation_ids"] = None
        __props__["scoring_config"] = None
        __props__["source_config"] = None
        return SettingSearchapplication(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="dataSourceRestrictions")
    def data_source_restrictions(self) -> pulumi.Output[Sequence['outputs.DataSourceRestrictionResponse']]:
        """
        Retrictions applied to the configurations. The maximum number of elements is 10.
        """
        return pulumi.get(self, "data_source_restrictions")

    @property
    @pulumi.getter(name="defaultFacetOptions")
    def default_facet_options(self) -> pulumi.Output[Sequence['outputs.FacetOptionsResponse']]:
        """
        The default fields for returning facet results. The sources specified here also have been included in data_source_restrictions above.
        """
        return pulumi.get(self, "default_facet_options")

    @property
    @pulumi.getter(name="defaultSortOptions")
    def default_sort_options(self) -> pulumi.Output['outputs.SortOptionsResponse']:
        """
        The default options for sorting the search results
        """
        return pulumi.get(self, "default_sort_options")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        Display name of the Search Application. The maximum length is 300 characters.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Search Application. Format: searchapplications/{application_id}.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="operationIds")
    def operation_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        IDs of the Long Running Operations (LROs) currently running for this schema. Output only field.
        """
        return pulumi.get(self, "operation_ids")

    @property
    @pulumi.getter(name="scoringConfig")
    def scoring_config(self) -> pulumi.Output['outputs.ScoringConfigResponse']:
        """
        Configuration for ranking results.
        """
        return pulumi.get(self, "scoring_config")

    @property
    @pulumi.getter(name="sourceConfig")
    def source_config(self) -> pulumi.Output[Sequence['outputs.SourceConfigResponse']]:
        """
        Configuration for a sources specified in data_source_restrictions.
        """
        return pulumi.get(self, "source_config")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

