# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['WorkerPool']


class WorkerPool(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 projects_id: Optional[pulumi.Input[str]] = None,
                 regions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 service_account_email: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 worker_config: Optional[pulumi.Input[pulumi.InputType['WorkerConfigArgs']]] = None,
                 worker_count: Optional[pulumi.Input[str]] = None,
                 worker_pools_id: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates a `WorkerPool` to run the builds, and returns the new worker pool.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: Time at which the request to create the `WorkerPool` was received.
        :param pulumi.Input[str] delete_time: Time at which the request to delete the `WorkerPool` was received.
        :param pulumi.Input[str] name: User-defined name of the `WorkerPool`.
        :param pulumi.Input[str] project_id: The project ID of the GCP project for which the `WorkerPool` is created.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] regions: List of regions to create the `WorkerPool`. Regions can't be empty. If Cloud Build adds a new GCP region in the future, the existing `WorkerPool` will not be enabled in the new region automatically; you must add the new region to the `regions` field to enable the `WorkerPool` in that region.
        :param pulumi.Input[str] service_account_email: The service account used to manage the `WorkerPool`. The service account must have the Compute Instance Admin (Beta) permission at the project level.
        :param pulumi.Input[str] status: WorkerPool Status.
        :param pulumi.Input[str] update_time: Time at which the request to update the `WorkerPool` was received.
        :param pulumi.Input[pulumi.InputType['WorkerConfigArgs']] worker_config: Configuration to be used for a creating workers in the `WorkerPool`.
        :param pulumi.Input[str] worker_count: Total number of workers to be created across all requested regions.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['create_time'] = create_time
            __props__['delete_time'] = delete_time
            __props__['name'] = name
            __props__['project_id'] = project_id
            if projects_id is None and not opts.urn:
                raise TypeError("Missing required property 'projects_id'")
            __props__['projects_id'] = projects_id
            __props__['regions'] = regions
            __props__['service_account_email'] = service_account_email
            __props__['status'] = status
            __props__['update_time'] = update_time
            __props__['worker_config'] = worker_config
            __props__['worker_count'] = worker_count
            if worker_pools_id is None and not opts.urn:
                raise TypeError("Missing required property 'worker_pools_id'")
            __props__['worker_pools_id'] = worker_pools_id
        super(WorkerPool, __self__).__init__(
            'gcp-native:cloudbuild/v1alpha1:WorkerPool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'WorkerPool':
        """
        Get an existing WorkerPool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["create_time"] = None
        __props__["delete_time"] = None
        __props__["name"] = None
        __props__["project_id"] = None
        __props__["regions"] = None
        __props__["service_account_email"] = None
        __props__["status"] = None
        __props__["update_time"] = None
        __props__["worker_config"] = None
        __props__["worker_count"] = None
        return WorkerPool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Time at which the request to create the `WorkerPool` was received.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        Time at which the request to delete the `WorkerPool` was received.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        User-defined name of the `WorkerPool`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The project ID of the GCP project for which the `WorkerPool` is created.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def regions(self) -> pulumi.Output[Sequence[str]]:
        """
        List of regions to create the `WorkerPool`. Regions can't be empty. If Cloud Build adds a new GCP region in the future, the existing `WorkerPool` will not be enabled in the new region automatically; you must add the new region to the `regions` field to enable the `WorkerPool` in that region.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="serviceAccountEmail")
    def service_account_email(self) -> pulumi.Output[str]:
        """
        The service account used to manage the `WorkerPool`. The service account must have the Compute Instance Admin (Beta) permission at the project level.
        """
        return pulumi.get(self, "service_account_email")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        WorkerPool Status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        Time at which the request to update the `WorkerPool` was received.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> pulumi.Output['outputs.WorkerConfigResponse']:
        """
        Configuration to be used for a creating workers in the `WorkerPool`.
        """
        return pulumi.get(self, "worker_config")

    @property
    @pulumi.getter(name="workerCount")
    def worker_count(self) -> pulumi.Output[str]:
        """
        Total number of workers to be created across all requested regions.
        """
        return pulumi.get(self, "worker_count")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

