# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from ... import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Organization']


class Organization(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 analytics_region: Optional[pulumi.Input[str]] = None,
                 attributes: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 authorized_network: Optional[pulumi.Input[str]] = None,
                 billing_type: Optional[pulumi.Input[str]] = None,
                 customer_name: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 organizations_id: Optional[pulumi.Input[str]] = None,
                 properties: Optional[pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1PropertiesArgs']]] = None,
                 runtime_database_encryption_key_name: Optional[pulumi.Input[str]] = None,
                 runtime_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Creates an Apigee organization. See [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] analytics_region: Required. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] attributes: Not used by Apigee.
        :param pulumi.Input[str] authorized_network: Compute Engine network used for Service Networking to be peered with Apigee runtime instances. See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started). Valid only when [RuntimeType](#RuntimeType) is set to `CLOUD`. The value must be set before the creation of a runtime instance and can be updated only when there are no runtime instances. For example: `default`. Apigee also supports shared VPC (that is, the host network project is not the same as the one that is peering with Apigee). See [Shared VPC overview](https://cloud.google.com/vpc/docs/shared-vpc). To use a shared VPC network, use the following format: `projects/{host-project-id}/{region}/networks/{network-name}`. For example: `projects/my-sharedvpc-host/global/networks/mynetwork` **Note:** Not supported for Apigee hybrid.
        :param pulumi.Input[str] billing_type: Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        :param pulumi.Input[str] customer_name: Not used by Apigee.
        :param pulumi.Input[str] description: Description of the Apigee organization.
        :param pulumi.Input[pulumi.InputType['GoogleCloudApigeeV1PropertiesArgs']] properties: Properties defined in the Apigee organization profile.
        :param pulumi.Input[str] runtime_database_encryption_key_name: Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances. Update is not allowed after the organization is created. Required when [RuntimeType](#RuntimeType) is `CLOUD`. If not specified when [RuntimeType](#RuntimeType) is `TRIAL`, a Google-Managed encryption key will be used. For example: "projects/foo/locations/us/keyRings/bar/cryptoKeys/baz". **Note:** Not supported for Apigee hybrid.
        :param pulumi.Input[str] runtime_type: Required. Runtime type of the Apigee organization based on the Apigee subscription purchased.
        :param pulumi.Input[str] type: Not used by Apigee.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['analytics_region'] = analytics_region
            __props__['attributes'] = attributes
            __props__['authorized_network'] = authorized_network
            __props__['billing_type'] = billing_type
            __props__['customer_name'] = customer_name
            __props__['description'] = description
            __props__['display_name'] = display_name
            if organizations_id is None and not opts.urn:
                raise TypeError("Missing required property 'organizations_id'")
            __props__['organizations_id'] = organizations_id
            __props__['properties'] = properties
            __props__['runtime_database_encryption_key_name'] = runtime_database_encryption_key_name
            __props__['runtime_type'] = runtime_type
            __props__['type'] = type
            __props__['ca_certificate'] = None
            __props__['created_at'] = None
            __props__['environments'] = None
            __props__['expires_at'] = None
            __props__['last_modified_at'] = None
            __props__['name'] = None
            __props__['project_id'] = None
            __props__['state'] = None
            __props__['subscription_type'] = None
        super(Organization, __self__).__init__(
            'gcp-native:apigee/v1:Organization',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Organization':
        """
        Get an existing Organization resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["analytics_region"] = None
        __props__["attributes"] = None
        __props__["authorized_network"] = None
        __props__["billing_type"] = None
        __props__["ca_certificate"] = None
        __props__["created_at"] = None
        __props__["customer_name"] = None
        __props__["description"] = None
        __props__["display_name"] = None
        __props__["environments"] = None
        __props__["expires_at"] = None
        __props__["last_modified_at"] = None
        __props__["name"] = None
        __props__["project_id"] = None
        __props__["properties"] = None
        __props__["runtime_database_encryption_key_name"] = None
        __props__["runtime_type"] = None
        __props__["state"] = None
        __props__["subscription_type"] = None
        __props__["type"] = None
        return Organization(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="analyticsRegion")
    def analytics_region(self) -> pulumi.Output[str]:
        """
        Required. Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
        """
        return pulumi.get(self, "analytics_region")

    @property
    @pulumi.getter
    def attributes(self) -> pulumi.Output[Sequence[str]]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "attributes")

    @property
    @pulumi.getter(name="authorizedNetwork")
    def authorized_network(self) -> pulumi.Output[str]:
        """
        Compute Engine network used for Service Networking to be peered with Apigee runtime instances. See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started). Valid only when [RuntimeType](#RuntimeType) is set to `CLOUD`. The value must be set before the creation of a runtime instance and can be updated only when there are no runtime instances. For example: `default`. Apigee also supports shared VPC (that is, the host network project is not the same as the one that is peering with Apigee). See [Shared VPC overview](https://cloud.google.com/vpc/docs/shared-vpc). To use a shared VPC network, use the following format: `projects/{host-project-id}/{region}/networks/{network-name}`. For example: `projects/my-sharedvpc-host/global/networks/mynetwork` **Note:** Not supported for Apigee hybrid.
        """
        return pulumi.get(self, "authorized_network")

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> pulumi.Output[str]:
        """
        Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter(name="caCertificate")
    def ca_certificate(self) -> pulumi.Output[str]:
        """
        Base64-encoded public certificate for the root CA of the Apigee organization. Valid only when [RuntimeType](#RuntimeType) is `CLOUD`.
        """
        return pulumi.get(self, "ca_certificate")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        Time that the Apigee organization was created in milliseconds since epoch.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="customerName")
    def customer_name(self) -> pulumi.Output[str]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "customer_name")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the Apigee organization.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def environments(self) -> pulumi.Output[Sequence[str]]:
        """
        List of environments in the Apigee organization.
        """
        return pulumi.get(self, "environments")

    @property
    @pulumi.getter(name="expiresAt")
    def expires_at(self) -> pulumi.Output[str]:
        """
        Time that the Apigee organization is scheduled for deletion.
        """
        return pulumi.get(self, "expires_at")

    @property
    @pulumi.getter(name="lastModifiedAt")
    def last_modified_at(self) -> pulumi.Output[str]:
        """
        Time that the Apigee organization was last modified in milliseconds since epoch.
        """
        return pulumi.get(self, "last_modified_at")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the Apigee organization.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        Project ID associated with the Apigee organization.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def properties(self) -> pulumi.Output['outputs.GoogleCloudApigeeV1PropertiesResponse']:
        """
        Properties defined in the Apigee organization profile.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="runtimeDatabaseEncryptionKeyName")
    def runtime_database_encryption_key_name(self) -> pulumi.Output[str]:
        """
        Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances. Update is not allowed after the organization is created. Required when [RuntimeType](#RuntimeType) is `CLOUD`. If not specified when [RuntimeType](#RuntimeType) is `TRIAL`, a Google-Managed encryption key will be used. For example: "projects/foo/locations/us/keyRings/bar/cryptoKeys/baz". **Note:** Not supported for Apigee hybrid.
        """
        return pulumi.get(self, "runtime_database_encryption_key_name")

    @property
    @pulumi.getter(name="runtimeType")
    def runtime_type(self) -> pulumi.Output[str]:
        """
        Required. Runtime type of the Apigee organization based on the Apigee subscription purchased.
        """
        return pulumi.get(self, "runtime_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        State of the organization. Values other than ACTIVE means the resource is not ready to use.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionType")
    def subscription_type(self) -> pulumi.Output[str]:
        """
        DEPRECATED: This will eventually be replaced by BillingType. Subscription type of the Apigee organization. Valid values include trial (free, limited, and for evaluation purposes only) or paid (full subscription has been purchased). See [Apigee pricing](https://cloud.google.com/apigee/pricing/).
        """
        return pulumi.get(self, "subscription_type")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        Not used by Apigee.
        """
        return pulumi.get(self, "type")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

