# Generated by Django 2.2.16 on 2020-10-13 16:02

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import djangoldp.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('djangoldp_circle', '0023_auto_20200617_1817'),
        ('djangoldp_joboffer', '0007_auto_20200924_1937'),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('djangoldp_project', '0014_auto_20200903_1051'),
    ]

    operations = [
        migrations.CreateModel(
            name='Community',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('name', models.CharField(blank=True, max_length=255)),
                ('slug', models.SlugField(blank=True, null=True, unique=True)),
            ],
            options={
                'verbose_name': 'community',
                'verbose_name_plural': 'communities',
                'ordering': ['slug'],
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='CommunityProject',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('community', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='projects', to='djangoldp_community.Community')),
                ('project', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='communities', to='djangoldp_project.Project')),
            ],
            options={
                'verbose_name': 'community project',
                'verbose_name_plural': 'community projects',
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='CommunityMember',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('is_admin', models.BooleanField(default=False)),
                ('community', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='members', to='djangoldp_community.Community')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='communities', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'community member',
                'verbose_name_plural': 'community members',
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='CommunityJobOffer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('community', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='joboffers', to='djangoldp_community.Community')),
                ('joboffer', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='communities', to='djangoldp_joboffer.JobOffer')),
            ],
            options={
                'verbose_name': 'community job offer',
                'verbose_name_plural': 'community job offers',
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
        migrations.CreateModel(
            name='CommunityCircle',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('urlid', djangoldp.fields.LDPUrlField(blank=True, null=True, unique=True)),
                ('is_backlink', models.BooleanField(default=False, help_text='set automatically to indicate the Model is a backlink')),
                ('allow_create_backlink', models.BooleanField(default=True, help_text='set to False to disable backlink creation after Model save')),
                ('circle', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='communities', to='djangoldp_circle.Circle')),
                ('community', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='circles', to='djangoldp_community.Community')),
            ],
            options={
                'verbose_name': 'community circle',
                'verbose_name_plural': 'community circles',
                'abstract': False,
                'default_permissions': ('add', 'change', 'delete', 'view', 'control'),
            },
        ),
    ]
