"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MicroService = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_ec2_1 = require("@aws-cdk/aws-ec2");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const core_1 = require("@aws-cdk/core");
const autoScalingGroup_1 = require("./autoScalingGroup");
const deployment_1 = require("./deployment");
const network_1 = require("./network");
/**
 * @stability stable
 */
class MicroService extends core_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b, _c, _d, _e, _f, _g, _h, _j, _k, _l, _m;
        super(scope, id);
        this.instanceType = (_b = props === null || props === void 0 ? void 0 : props.instanceType) !== null && _b !== void 0 ? _b : 't3a.micro';
        this.appName = props === null || props === void 0 ? void 0 : props.appName;
        this.volumeSize = (_c = props === null || props === void 0 ? void 0 : props.volumeSize) !== null && _c !== void 0 ? _c : 15;
        this.asgMaxSize = (_d = props === null || props === void 0 ? void 0 : props.asgMaxSize) !== null && _d !== void 0 ? _d : '2';
        this.asgMinSize = (_e = props === null || props === void 0 ? void 0 : props.asgMinSize) !== null && _e !== void 0 ? _e : '1';
        this.env = props === null || props === void 0 ? void 0 : props.env;
        this.instanceLabels = props === null || props === void 0 ? void 0 : props.instanceLabels;
        this.healthCheckPath = (_f = props === null || props === void 0 ? void 0 : props.healthCheckPath) !== null && _f !== void 0 ? _f : '/v1/healthCheck';
        this.port = (_g = props.port) !== null && _g !== void 0 ? _g : undefined;
        this.protocol = (_h = props.protocol) !== null && _h !== void 0 ? _h : 'HTTP';
        this.diskSize = (_j = props.diskSize) !== null && _j !== void 0 ? _j : 8;
        this.vpc = props.vpc;
        this.subnetType = (_k = props.subnetClass) !== null && _k !== void 0 ? _k : aws_ec2_1.SubnetType.PRIVATE;
        this.role = props.role;
        this.tcpRules = props.tcpRules;
        this.subnets = props.subnets;
        this.sslEnabled = props.sslEnabled;
        this.host = props.host;
        this.lbArn = props.lbArn;
        this.sshKey = props.sshKey;
        this.createCodedeployApplication = props.createCodedeployApplication;
        const resourceNamePrefix = this.env + '-' + this.appName;
        const asg = new autoScalingGroup_1.AutoScaler(this, resourceNamePrefix + '-as', {
            asgName: resourceNamePrefix + '-ASG',
            maxSize: this.asgMaxSize,
            minSize: this.asgMinSize,
            tgProps: this.port ? {
                type: 'new',
                healthPath: this.healthCheckPath,
                protocol: this.protocol,
                port: this.port,
                name: ((resourceNamePrefix + '-TG').length >= 32) ? this.env + '-' + this.appName + '-TG' : resourceNamePrefix + '-TG',
                timeout: 10,
                thresholdCount: 2,
            } : undefined,
            templateProps: {
                instanceType: this.instanceType,
                detailedMonitoring: false,
                templateName: resourceNamePrefix + '-LT',
                amiImageId: (_l = props.ami) !== null && _l !== void 0 ? _l : 'Ubuntu Server 20.04 LTS (HVM), SSD Volume Type',
                type: 'new',
                blockDevice: {
                    size: this.diskSize,
                    name: '/dev/sda1',
                    type: aws_ec2_1.EbsDeviceVolumeType.GP3,
                },
                vpc: {
                    type: 'existing',
                    vpcName: this.vpc,
                    vpcSubnet: this.subnetType,
                },
                securityGroup: {
                    type: 'new',
                    allowAllOutbound: true,
                    securityGroupName: resourceNamePrefix + '-SG',
                    ingressRules: this.tcpRules,
                },
                role: {
                    type: 'existing',
                    roleArn: this.role,
                },
                sshKey: this.sshKey,
            },
            tags: props.instanceLabels,
            subnets: this.subnets,
        });
        const depRole = this.getDeploymentGroupRole();
        if (this.createCodedeployApplication) {
            const dep = new deployment_1.Deployment(this, resourceNamePrefix + '-cd', {
                asgNames: [resourceNamePrefix + '-ASG'],
                deploymentConfigName: 'CodeDeployDefault.OneAtATime',
                roleArn: depRole.roleArn,
                applicationProps: {
                    applicationName: this.appName + '-' + this.env,
                    type: 'new',
                    resourceType: 'Server',
                },
                deploymentGroupName: this.env,
                tgName: resourceNamePrefix + '-TG',
            });
            dep.node.addDependency(depRole);
        }
        if (this.host && this.lbArn && asg.targetGroupArn != '') {
            const lbEntry = new network_1.BalancerEntry(this, resourceNamePrefix + '-lb', {
                appName: this.appName,
                hostHeader: this.host,
                targetGroupArn: asg.targetGroupArn,
                lbArn: this.lbArn,
                sslEnabled: (_m = this.sslEnabled) !== null && _m !== void 0 ? _m : false,
            });
            lbEntry.node.addDependency(asg);
        }
    }
    getDeploymentGroupRole() {
        var role = new aws_iam_1.Role(this, this.appName + '-deployment-group-role', {
            assumedBy: new aws_iam_1.ServicePrincipal('codedeploy.amazonaws.com'),
            roleName: this.appName + '-deployment-group-role',
        });
        role.addToPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            resources: ['*'],
            actions: [
                'autoscaling:CompleteLifecycleAction',
                'autoscaling:DeleteLifecycleHook',
                'autoscaling:DescribeAutoScalingGroups',
                'autoscaling:DescribeLifecycleHooks',
                'autoscaling:PutLifecycleHook',
                'autoscaling:RecordLifecycleActionHeartbeat',
                'autoscaling:CreateAutoScalingGroup',
                'autoscaling:UpdateAutoScalingGroup',
                'autoscaling:EnableMetricsCollection',
                'autoscaling:DescribePolicies',
                'autoscaling:DescribeScheduledActions',
                'autoscaling:DescribeNotificationConfigurations',
                'autoscaling:SuspendProcesses',
                'autoscaling:ResumeProcesses',
                'autoscaling:AttachLoadBalancers',
                'autoscaling:AttachLoadBalancerTargetGroups',
                'autoscaling:PutScalingPolicy',
                'autoscaling:PutScheduledUpdateGroupAction',
                'autoscaling:PutNotificationConfiguration',
                'autoscaling:PutWarmPool',
                'autoscaling:DescribeScalingActivities',
                'autoscaling:DeleteAutoScalingGroup',
                'ec2:DescribeInstances',
                'ec2:DescribeInstanceStatus',
                'ec2:TerminateInstances',
                'tag:GetResources',
                'sns:Publish',
                'cloudwatch:DescribeAlarms',
                'cloudwatch:PutMetricAlarm',
                'elasticloadbalancing:DescribeLoadBalancers',
                'elasticloadbalancing:DescribeInstanceHealth',
                'elasticloadbalancing:RegisterInstancesWithLoadBalancer',
                'elasticloadbalancing:DeregisterInstancesFromLoadBalancer',
                'elasticloadbalancing:DescribeTargetGroups',
                'elasticloadbalancing:DescribeTargetHealth',
                'elasticloadbalancing:RegisterTargets',
                'elasticloadbalancing:DeregisterTargets',
                'ec2:CreateTags',
                'ec2:RunInstances',
                'iam:PassRole',
            ],
        }));
        return role;
    }
}
exports.MicroService = MicroService;
_a = JSII_RTTI_SYMBOL_1;
MicroService[_a] = { fqn: "@smallcase/aws-cdk-microservice.MicroService", version: "0.0.3" };
//# sourceMappingURL=data:application/json;base64,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