"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * (experimental) The image repository types.
 *
 * @experimental
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType = exports.ImageRepositoryType || (exports.ImageRepositoryType = {}));
/**
 * (experimental) The number of CPU units reserved for each instance of your App Runner service.
 *
 * @experimental
 */
class Cpu {
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * (experimental) Custom CPU unit.
     *
     * @param unit custom CPU unit.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     * @experimental
     */
    static of(unit) { return new Cpu(unit); }
}
exports.Cpu = Cpu;
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.0.0-alpha.9" };
/**
 * (experimental) 1 vCPU.
 *
 * @experimental
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * (experimental) 2 vCPU.
 *
 * @experimental
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
/**
 * (experimental) The amount of memory reserved for each instance of your App Runner service.
 *
 * @experimental
 */
class Memory {
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
    /**
     * (experimental) Custom Memory unit.
     *
     * @param unit custom Memory unit.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     * @experimental
     */
    static of(unit) { return new Memory(unit); }
}
exports.Memory = Memory;
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.0.0-alpha.9" };
/**
 * (experimental) 2 GB(for 1 vCPU).
 *
 * @experimental
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * (experimental) 3 GB(for 1 vCPU).
 *
 * @experimental
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * (experimental) 4 GB(for 1 or 2 vCPU).
 *
 * @experimental
 */
Memory.FOUR_GB = Memory.of('4 GB');
/**
 * (experimental) The code runtimes.
 *
 * @experimental
 */
class Runtime {
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
    /**
     * (experimental) Other runtimes.
     *
     * @param name runtime name.
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     * @experimental
     */
    static of(name) { return new Runtime(name); }
}
exports.Runtime = Runtime;
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.0.0-alpha.9" };
/**
 * (experimental) NodeJS 12.
 *
 * @experimental
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * (experimental) Python 3.
 *
 * @experimental
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * (experimental) Represents the App Runner service source.
 *
 * @experimental
 */
class Source {
    /**
     * (experimental) Source from the GitHub repository.
     *
     * @experimental
     */
    static fromGitHub(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        return new GithubSource(props);
    }
    /**
     * (experimental) Source from the ECR repository.
     *
     * @experimental
     */
    static fromEcr(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        return new EcrSource(props);
    }
    /**
     * (experimental) Source from the ECR Public repository.
     *
     * @experimental
     */
    static fromEcrPublic(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        return new EcrPublicSource(props);
    }
    /**
     * (experimental) Source from local assets.
     *
     * @experimental
     */
    static fromAsset(props) {
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        return new AssetSource(props);
    }
}
exports.Source = Source;
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.0.0-alpha.9" };
/**
 * (experimental) Represents the service source from a Github repository.
 *
 * @experimental
 */
class GithubSource extends Source {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        this.props = props;
    }
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope) {
        var _l;
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: (_l = this.props.branch) !== null && _l !== void 0 ? _l : 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
exports.GithubSource = GithubSource;
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.0.0-alpha.9" };
/**
 * (experimental) Represents the service source from ECR.
 *
 * @experimental
 */
class EcrSource extends Source {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        this.props = props;
    }
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTag(this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
exports.EcrSource = EcrSource;
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.0.0-alpha.9" };
/**
 * (experimental) Represents the service source from ECR Public.
 *
 * @experimental
 */
class EcrPublicSource extends Source {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        this.props = props;
    }
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
exports.EcrPublicSource = EcrPublicSource;
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.0.0-alpha.9" };
/**
 * (experimental) Represents the source from local assets.
 *
 * @experimental
 */
class AssetSource extends Source {
    /**
     * @experimental
     */
    constructor(props) {
        super();
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        this.props = props;
    }
    /**
     * (experimental) Called when the Job is initialized to allow this object to bind.
     *
     * @experimental
     */
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
exports.AssetSource = AssetSource;
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.0.0-alpha.9" };
/**
 * (experimental) The source of the App Runner configuration.
 *
 * @experimental
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType = exports.ConfigurationSourceType || (exports.ConfigurationSourceType = {}));
/**
 * (experimental) Represents the App Runner connection that enables the App Runner service to connect to a source repository.
 *
 * It's required for GitHub code repositories.
 *
 * @experimental
 */
class GitHubConnection {
    /**
     * @experimental
     */
    constructor(arn) {
        this.connectionArn = arn;
    }
    /**
     * (experimental) Using existing App Runner connection by specifying the connection ARN.
     *
     * @param arn connection ARN.
     * @returns Connection
     * @experimental
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
}
exports.GitHubConnection = GitHubConnection;
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.0.0-alpha.9" };
/**
 * (experimental) The App Runner Service.
 *
 * @experimental
 */
class Service extends cdk.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        var _l, _m, _o, _p, _q, _r;
        super(scope, id);
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        // generate an IAM role only when ImageRepositoryType is ECR and props.role is undefined
        this.accessRole = (((_l = this.source.imageRepository) === null || _l === void 0 ? void 0 : _l.imageRepositoryType) == ImageRepositoryType.ECR) ?
            this.props.accessRole ? this.props.accessRole : this.generateDefaultRole() : undefined;
        if (((_m = source.codeRepository) === null || _m === void 0 ? void 0 : _m.codeConfiguration.configurationSource) == ConfigurationSourceType.REPOSITORY && ((_o = source.codeRepository) === null || _o === void 0 ? void 0 : _o.codeConfiguration.configurationValues)) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            instanceConfiguration: {
                cpu: (_p = props.cpu) === null || _p === void 0 ? void 0 : _p.unit,
                memory: (_q = props.memory) === null || _q === void 0 ? void 0 : _q.unit,
                instanceRoleArn: (_r = props.instanceRole) === null || _r === void 0 ? void 0 : _r.roleArn,
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                imageRepository: source.imageRepository ? this.renderImageRepository() : undefined,
                codeRepository: source.codeRepository ? this.renderCodeConfiguration() : undefined,
            },
        });
        // grant required privileges for the role
        if (source.ecrRepository && this.accessRole) {
            source.ecrRepository.grantPull(this.accessRole);
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        this.serviceName = resource.ref;
    }
    /**
     * (experimental) Import from service name.
     *
     * @experimental
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Import from service attributes.
     *
     * @experimental
     */
    static fromServiceAttributes(scope, id, attrs) {
        jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    renderAuthenticationConfiguration() {
        var _l, _m, _o;
        return {
            accessRoleArn: (_l = this.accessRole) === null || _l === void 0 ? void 0 : _l.roleArn,
            connectionArn: (_o = (_m = this.source.codeRepository) === null || _m === void 0 ? void 0 : _m.connection) === null || _o === void 0 ? void 0 : _o.connectionArn,
        };
    }
    renderCodeConfiguration() {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(this.source.codeRepository.codeConfiguration.configurationValues) : undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        return {
            ...props,
            runtime: props.runtime.name,
        };
    }
    renderImageRepository() {
        var _l;
        const repo = this.source.imageRepository;
        if ((_l = repo.imageConfiguration) === null || _l === void 0 ? void 0 : _l.port) {
            // convert port from type number to string
            return Object.assign(repo, {
                imageConfiguration: {
                    port: repo.imageConfiguration.port.toString(),
                },
            });
        }
        else {
            return repo;
        }
    }
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
}
exports.Service = Service;
_k = JSII_RTTI_SYMBOL_1;
Service[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.0.0-alpha.9" };
//# sourceMappingURL=data:application/json;base64,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