/*
 * Decompiled with CFR 0.152.
 */
package com.sas.rio;

import com.sas.codepolicy.SASScope;
import com.sas.rio.Cache;
import com.sas.rio.Column;
import com.sas.rio.IRowCache;
import com.sas.rio.MVARow;
import com.sas.rio.MVASQLException;
import com.sas.rio.MessageCode;
import com.sas.rio.RIOUtil;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.jcip.annotations.Immutable;

@Immutable
@SASScope
public class MVASyntheticRowCache
implements IRowCache {
    private final Column[] _columns;
    private final Cache<MVARow> _rows;
    private int _cacheIdx;

    public MVASyntheticRowCache(Column[] columns, List<Object[]> rowData) throws SQLException {
        this._columns = columns;
        ArrayList<MVARow> mvaRows = new ArrayList<MVARow>(rowData.size());
        for (Object[] row : rowData) {
            MVARow mvaRow = new MVARow(row);
            mvaRows.add(mvaRow);
        }
        this._rows = new Cache(mvaRows);
        this._cacheIdx = -1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        if (row == 0) {
            this.beforeFirst();
            return false;
        }
        if (row > 0) {
            if (row > this._rows.size()) {
                this._cacheIdx = this._rows.size();
                return false;
            }
            this._cacheIdx = row - 1;
            return true;
        }
        int requestedCacheIdx = this._rows.size() + row;
        if (requestedCacheIdx < 0) {
            this._cacheIdx = -1;
            return false;
        }
        this._cacheIdx = requestedCacheIdx;
        return true;
    }

    @Override
    public void afterLast() throws SQLException {
        this._cacheIdx = this._rows.size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this._cacheIdx = -1;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new MVASQLException(MessageCode.MVAResultSet_readOnlyNotUpdatable, new Object[0]);
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public int getFetchSize() {
        return 0;
    }

    @Override
    public int getHashCode() {
        return -1;
    }

    @Override
    public RIOUtil getRioUtil() {
        return null;
    }

    @Override
    public int getRow() throws SQLException {
        int position = this.isBeforeFirst() || this.isAfterLast() ? 0 : this._cacheIdx + 1;
        return position;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        boolean afterLast = this._cacheIdx == this._rows.size();
        return afterLast;
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        boolean beforeFirst = this._cacheIdx == -1;
        return beforeFirst;
    }

    @Override
    public boolean isFirst() {
        if (this.isEmpty()) {
            return false;
        }
        boolean isFirst = this._cacheIdx == 0;
        return isFirst;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.isEmpty()) {
            return false;
        }
        boolean isLast = this._cacheIdx == this._rows.size() - 1;
        return isLast;
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(-1);
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isEmpty()) {
            this._cacheIdx = 0;
            return false;
        }
        if (this.isAfterLast()) {
            return false;
        }
        if (this._cacheIdx >= this._rows.size() - 1) {
            this._cacheIdx = this._rows.size();
            return false;
        }
        ++this._cacheIdx;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        if (this.isEmpty()) {
            this._cacheIdx = -1;
            return false;
        }
        if (this.isBeforeFirst()) {
            return false;
        }
        if (this._cacheIdx == 0) {
            this._cacheIdx = -1;
            return false;
        }
        --this._cacheIdx;
        return true;
    }

    @Override
    public void refresh() throws SQLException {
    }

    @Override
    public boolean relative(int rowOffset) throws SQLException {
        long newpos = (long)this._cacheIdx + 1L + (long)rowOffset;
        if (newpos > Integer.MAX_VALUE) {
            this.afterLast();
            return false;
        }
        if (newpos <= 0L) {
            return this.absolute(0);
        }
        boolean success = this.absolute((int)newpos);
        return success;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
    }

    @Override
    public void updateRow() throws SQLException {
        throw new MVASQLException(MessageCode.MVAResultSet_readOnlyNotUpdatable, new Object[0]);
    }

    @Override
    public void insertRow() throws SQLException {
        throw new MVASQLException(MessageCode.MVAResultSet_readOnlyNotUpdatable, new Object[0]);
    }

    @Override
    public boolean isEmpty() {
        boolean isEmpty = this._rows.size() == 0;
        return isEmpty;
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new MVASQLException(MessageCode.MVAResultSet_readOnlyNotUpdatable, new Object[0]);
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new MVASQLException(MessageCode.MVAResultSet_readOnlyNotUpdatable, new Object[0]);
    }

    @Override
    public Object getData(int column) throws SQLException {
        if (this.isEmpty()) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        if (this._cacheIdx < 0 || this._cacheIdx == this._rows.size()) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        MVARow mvaRow = (MVARow)this._rows.get(this._cacheIdx);
        if (mvaRow == null) {
            return null;
        }
        return mvaRow.getData(column - 1);
    }

    @Override
    public boolean getIsMissing(int column) throws SQLException {
        if (this.isEmpty()) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        if (this._cacheIdx < 0 || this._cacheIdx == this._rows.size()) {
            throw new MVASQLException(MessageCode.MVAResultSet_invalidRowPosition, new Object[0]);
        }
        MVARow row = (MVARow)this._rows.get(this._cacheIdx);
        return row.getMissing(column - 1);
    }

    @Override
    public Column[] getColumns() throws SQLException {
        return this._columns;
    }

    @Override
    public int getSqlType(int column) throws SQLException {
        int sqlType = this._columns[column - 1].getSqlType();
        return sqlType;
    }

    @Override
    public void updateData(int column, Object updateObj) throws SQLException {
        throw new MVASQLException(MessageCode.MVAResultSet_readOnlyNotUpdatable, new Object[0]);
    }

    @Override
    public void setMaxRows(int maxRows) {
    }

    @Override
    public void cancelUpdate() throws SQLException {
        throw new MVASQLException(MessageCode.MVAResultSet_readOnlyNotUpdatable, new Object[0]);
    }
}

