/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class StringToDateTransform
implements TransformInputOutputInterface {
    static final long serialVersionUID = -7670709939329023996L;
    protected Locale locale;
    protected DateFormat dateFormatter;
    protected String nullString = "null";
    protected String dotString = ".";
    public static final StringToDateTransform defaultInstance = new StringToDateTransform();

    public StringToDateTransform() {
        this(Locale.getDefault());
    }

    public StringToDateTransform(Locale locale) {
        this.locale = locale;
    }

    @Override
    public Object transform(Object input) throws TransformException {
        if (input != null) {
            if (this.dateFormatter == null) {
                this.dateFormatter = DateFormat.getDateTimeInstance(2, 2, this.locale);
            }
            try {
                return this.dateFormatter.parse((String)input);
            }
            catch (ParseException e) {
                TransformException te = new TransformException(e.getMessage());
                te.initCause(e);
                throw te;
            }
        }
        return this.nullString;
    }

    @Override
    public Class getInputClass() {
        return String.class;
    }

    @Override
    public Class getOutputClass() {
        return Date.class;
    }

    public DateFormat getDateFormatter() {
        return this.dateFormatter;
    }

    public void setDateFormatter(DateFormat dateFormatter) {
        this.dateFormatter = dateFormatter;
    }
}

