/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.util.ApplyInterface;
import com.sas.util.Command;

public class CompositeCommand
implements Command,
ApplyInterface {
    private Command _first;
    private Command _second;

    public CompositeCommand(Command first, Command second) {
        if (first == null || second == null) {
            throw new NullPointerException();
        }
        this._first = first;
        this._second = second;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Command getFirstCommand() {
        return this._first;
    }

    public Command getSecondCommand() {
        return this._second;
    }

    @Override
    public boolean isExecutable() {
        return this.getFirstCommand().isExecutable() || this.getSecondCommand().isExecutable();
    }

    @Override
    public void execute(Object obj) {
        this.getFirstCommand().execute(obj);
        this.getSecondCommand().execute(obj);
    }

    @Override
    public int apply(Object obj) {
        int rc = 0;
        Command first = this.getFirstCommand();
        if (first instanceof ApplyInterface) {
            rc = ((ApplyInterface)((Object)first)).apply(obj);
        } else {
            first.execute(obj);
        }
        if (rc == 0) {
            Command second = this.getSecondCommand();
            if (second instanceof ApplyInterface) {
                rc = ((ApplyInterface)((Object)second)).apply(obj);
            } else {
                second.execute(obj);
            }
        }
        return rc;
    }

    @Override
    public boolean isUndoable() {
        return this.getFirstCommand().isUndoable() && this.getSecondCommand().isUndoable();
    }

    @Override
    public void undo() {
        this.getSecondCommand().undo();
        this.getFirstCommand().undo();
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public void setText(String text) {
    }
}

