/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.DateValue;
import com.sas.text.SASFormatEntry;
import com.sas.text.SingleEntry;
import java.text.DateFormatSymbols;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

@SASScope
public class DateNameStringValue
extends DateValue {
    private static Object[] m_dateStringValueFormats;
    private IDateNameString dateNameString;

    public static Object[] getDefinedFormats(Locale locale) {
        Vector<SingleEntry> temp = new Vector<SingleEntry>(5, 3);
        String className = DateNameStringValue.class.getName();
        SingleEntry entry = new SingleEntry("NLSTRWKw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addPattern(20, 200, "EEEE", true);
        ((SASFormatEntry)entry).addPattern(1, 19, "EEE");
        temp.addElement(entry);
        entry = new SingleEntry("NLSTRMONw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addPattern(20, 200, "MMMM", true);
        ((SASFormatEntry)entry).addPattern(1, 19, "MMM");
        temp.addElement(entry);
        entry = new SingleEntry("NLSTRQTRw.d", className);
        entry.setFormatLocale(locale);
        ((SASFormatEntry)entry).addPattern(20, 200, "QQQ", true);
        ((SASFormatEntry)entry).addPattern(1, 19, "QQ");
        temp.addElement(entry);
        m_dateStringValueFormats = new Object[temp.size()];
        temp.copyInto(m_dateStringValueFormats);
        return m_dateStringValueFormats;
    }

    @Override
    public StringBuffer format(double date) {
        this.dateNameString = this.getDateNameString();
        if (this.dateNameString == null || !this.dateNameString.checkVaildRange(date)) {
            return this.getAsteriskArray(this.info.getWidth());
        }
        int i = (int)date;
        StringBuffer sb = this.dateNameString.format(i);
        if (sb.length() > this.info.getWidth()) {
            sb = this.getAsteriskArray(this.info.getWidth());
        } else if (sb.length() != 0) {
            this.insertLeadingBlanks(sb);
        }
        return sb;
    }

    @Override
    public StringBuffer format(Date value) {
        return this.getAsteriskArray(this.info.getWidth());
    }

    private StringBuffer getAsteriskArray(int width) {
        StringBuffer result = new StringBuffer(width);
        for (int i = 0; i < width; ++i) {
            result.append('*');
        }
        return result;
    }

    private IDateNameString getDateNameString() {
        String name = this.info.getBaseFormat().substring(5);
        if (name.equalsIgnoreCase("WK")) {
            return new WeekNameString();
        }
        if (name.equalsIgnoreCase("MON")) {
            return new MonthNameString();
        }
        if (name.equalsIgnoreCase("QTR")) {
            return new QuarterNameString();
        }
        return null;
    }

    @SASScope
    private class QuarterNameString
    implements IDateNameString {
        private final double QUARTER_MINIMUM = 1.0;
        private final double QUARTER_MAXIMNM = 4.0;

        private QuarterNameString() {
        }

        @Override
        public boolean checkVaildRange(double date) {
            return !(date < 1.0) && !(date > 4.0);
        }

        @Override
        public StringBuffer format(int iQtr) {
            StringBuffer sb = new StringBuffer();
            switch (DateNameStringValue.this.info.getDValue()) {
                case 0: {
                    String strQtr = DateNameStringValue.this.info.getEntry().getString("q" + iQtr);
                    DateNameStringValue.this.formatter.applyPattern(strQtr);
                    DateNameStringValue.this.formatter.format(DateNameStringValue.this.date, sb, DateNameStringValue.this.position);
                    break;
                }
                case 1: {
                    String strQtr = DateNameStringValue.this.info.getEntry().getString("q" + iQtr + "_s");
                    DateNameStringValue.this.formatter.applyPattern(strQtr);
                    DateNameStringValue.this.formatter.format(DateNameStringValue.this.date, sb, DateNameStringValue.this.position);
                    break;
                }
                case 2: {
                    String strQtr = DateNameStringValue.this.info.getEntry().getString("q" + iQtr);
                    DateNameStringValue.this.formatter.applyPattern(strQtr);
                    DateNameStringValue.this.formatter.format(DateNameStringValue.this.date, sb, DateNameStringValue.this.position);
                    String upstr = sb.toString().toUpperCase();
                    sb.setLength(0);
                    sb.append(upstr);
                    break;
                }
                case 3: {
                    String strQtr = DateNameStringValue.this.info.getEntry().getString("q" + iQtr + "_s");
                    DateNameStringValue.this.formatter.applyPattern(strQtr);
                    DateNameStringValue.this.formatter.format(DateNameStringValue.this.date, sb, DateNameStringValue.this.position);
                    String upstr = sb.toString().toUpperCase();
                    sb.setLength(0);
                    sb.append(upstr);
                    break;
                }
                default: {
                    sb.setLength(0);
                }
            }
            return sb;
        }
    }

    @SASScope
    private class MonthNameString
    implements IDateNameString {
        private final double MONTH_MINIMUM = 1.0;
        private final double MONTH_MAXIMNM = 12.0;

        private MonthNameString() {
        }

        @Override
        public boolean checkVaildRange(double date) {
            return !(date < 1.0) && !(date > 12.0);
        }

        @Override
        public StringBuffer format(int mon) {
            DateFormatSymbols dfs = DateNameStringValue.this.formatter.getDateFormatSymbols();
            StringBuffer sb = new StringBuffer();
            switch (DateNameStringValue.this.info.getDValue()) {
                case 0: {
                    sb.append(dfs.getMonths()[mon - 1]);
                    break;
                }
                case 1: {
                    sb.append(dfs.getShortMonths()[mon - 1]);
                    break;
                }
                case 2: {
                    sb.append(dfs.getMonths()[mon - 1].toUpperCase());
                    break;
                }
                case 3: {
                    sb.append(dfs.getShortMonths()[mon - 1].toUpperCase());
                    break;
                }
                default: {
                    sb.setLength(0);
                }
            }
            return sb;
        }
    }

    @SASScope
    private class WeekNameString
    implements IDateNameString {
        private final double WEEK_MINIMUM = 1.0;
        private final double WEEK_MAXIMNM = 7.0;

        private WeekNameString() {
        }

        @Override
        public boolean checkVaildRange(double date) {
            return !(date < 1.0) && !(date > 7.0);
        }

        @Override
        public StringBuffer format(int week) {
            DateFormatSymbols dfs = DateNameStringValue.this.formatter.getDateFormatSymbols();
            StringBuffer sb = new StringBuffer();
            switch (DateNameStringValue.this.info.getDValue()) {
                case 0: {
                    sb.append(dfs.getWeekdays()[week]);
                    break;
                }
                case 1: {
                    sb.append(dfs.getShortWeekdays()[week]);
                    break;
                }
                case 2: {
                    sb.append(dfs.getWeekdays()[week].toUpperCase());
                    break;
                }
                case 3: {
                    sb.append(dfs.getShortWeekdays()[week].toUpperCase());
                    break;
                }
                default: {
                    sb.setLength(0);
                }
            }
            return sb;
        }
    }

    @SASScope
    protected static interface IDateNameString {
        public boolean checkVaildRange(double var1);

        public StringBuffer format(int var1);
    }
}

