/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.codepolicy.SASScope;
import com.sas.text.SASFormat;
import com.sas.text.SASFormatEntry;
import com.sas.text.SASNumericFormat;
import com.sas.text.SingleEntry;

@SASScope
public class D
extends SASNumericFormat {
    private SASFormat[] fInstance = new SASFormat[33];
    private SASFormat bestInstance = null;
    private static Object[] dFormats;

    @Override
    protected void init() {
        super.init();
        if (this.info.getDValue() < 0) {
            this.info.setDValue(this.info.getWidth() > 3 ? 3 : 0);
        } else if (this.info.getDValue() > 16) {
            this.info.setDValue(16);
        }
        int w = this.info.getWidth();
        this.bestInstance = SASFormat.getInstance("BEST", w);
        this.bestInstance.setDFormat(true);
    }

    @Override
    public StringBuffer format(double value) {
        SASFormat fmt;
        int p;
        int w = this.info.getWidth();
        int d = this.zfmtd(value, w, p = this.info.getDValue());
        if (d >= 0 && p < 10) {
            fmt = this.fInstance[d];
            if (fmt == null) {
                this.fInstance[d] = fmt = SASFormat.getInstance("F", w, d);
            }
        } else if (w > 1 && w < 4) {
            if (w == 3 && p == 1) {
                fmt = this.bestInstance;
            } else {
                if (p == 4) {
                    p = 3;
                }
                if (p == 0) {
                    p = 3;
                }
                if ((fmt = this.fInstance[p]) == null) {
                    this.fInstance[p] = fmt = SASFormat.getInstance("F", w, p);
                }
            }
        } else {
            fmt = this.bestInstance;
        }
        StringBuffer formatedValue = new StringBuffer(fmt.format(new Double(value)));
        return formatedValue;
    }

    @Override
    public double informat(String value) {
        return -1.0;
    }

    protected int zfmtd(double value, int width, int precision) {
        int increment;
        int decimalPlace;
        int w;
        int extraPlaces;
        if (value == 0.0) {
            return 0;
        }
        if (precision < 1) {
            precision = 3;
        }
        if ((extraPlaces = (w = width - 2) - precision + 1) < 2) {
            return -Math.max(width - 7, 1);
        }
        int rightPlaces = extraPlaces / 2 - 1;
        int leftPlaces = w - decimalPlace;
        double absoluteValue = Math.abs(value);
        int magnitude = (int)Math.floor(Math.log10(absoluteValue));
        if (magnitude < 0) {
            if ((magnitude = precision - magnitude - 1) <= decimalPlace) {
                return decimalPlace;
            }
            return magnitude <= (decimalPlace += leftPlaces - 1) ? decimalPlace : -Math.max(width - 7, 1);
        }
        if (magnitude > w) {
            return -Math.max(width - 7, 1);
        }
        for (decimalPlace = rightPlaces + precision; decimalPlace != 0; decimalPlace -= increment) {
            if (magnitude < leftPlaces && (magnitude < leftPlaces - 1 || absoluteValue < Math.pow(10.0, leftPlaces) - 0.5 * Math.pow(10.0, leftPlaces - w))) {
                return decimalPlace;
            }
            extraPlaces = precision - leftPlaces;
            increment = extraPlaces > 0 ? decimalPlace - extraPlaces : decimalPlace;
            leftPlaces += increment;
        }
        return 0;
    }

    static Object[] getDefinedFormats() {
        if (dFormats == null) {
            SingleEntry entry = new SingleEntry("Dw.d", D.class.getName());
            ((SASFormatEntry)entry).addPattern(12, 32, null, true);
            ((SASFormatEntry)entry).addPattern(1, 11, null);
            dFormats = new Object[1];
            D.dFormats[0] = entry;
        }
        return dFormats;
    }
}

