/*
 * Decompiled with CFR 0.152.
 */
package com.sas.nls.dynamic.locales;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;

public final class ApplicationLocalizations {
    private static final String LOCALE_COUNT = "locale.count";
    private static final String KEY_PREFIX = "locale.";
    private static final String BUNDLE_NAME = "locales";
    private static final ResourceBundle RESOURCE_BUNDLE;
    private final Collection<String> locales;

    public ApplicationLocalizations() {
        this.locales = this.createCollection();
    }

    public ApplicationLocalizations(Properties props) {
        this.locales = this.createCollection(props);
    }

    public Collection<String> getLocales() {
        return this.locales;
    }

    public static Properties union(Properties props1, Properties props2) {
        String locale;
        int i;
        int num;
        HashSet<String> locs = new HashSet<String>();
        String count = props1.getProperty(LOCALE_COUNT);
        if (count != null) {
            num = Integer.parseInt(count);
            for (i = 0; i < num; ++i) {
                locale = props1.getProperty(KEY_PREFIX + i);
                if (locale == null || locale.length() <= 0) continue;
                locs.add(locale);
            }
        }
        if ((count = props2.getProperty(LOCALE_COUNT)) != null) {
            num = Integer.parseInt(count);
            for (i = 0; i < num; ++i) {
                locale = props2.getProperty(KEY_PREFIX + i);
                if (locale == null || locale.length() <= 0 || locs.contains(locale)) continue;
                locs.add(locale);
            }
        }
        return ApplicationLocalizations.makeIntoProperties(locs);
    }

    public static Properties intersection(Properties props1, Properties props2) {
        String locale;
        int i;
        int num;
        HashSet<String> locs = new HashSet<String>();
        HashSet<String> temp = new HashSet<String>();
        String count = props1.getProperty(LOCALE_COUNT);
        if (count != null) {
            num = Integer.parseInt(count);
            for (i = 0; i < num; ++i) {
                locale = props1.getProperty(KEY_PREFIX + i);
                if (locale == null || locale.length() <= 0) continue;
                temp.add(locale);
            }
        }
        if ((count = props2.getProperty(LOCALE_COUNT)) != null) {
            num = Integer.parseInt(count);
            for (i = 0; i < num; ++i) {
                locale = props2.getProperty(KEY_PREFIX + i);
                if (locale == null || locale.length() <= 0 || !temp.contains(locale)) continue;
                locs.add(locale);
            }
        }
        return ApplicationLocalizations.makeIntoProperties(locs);
    }

    private static Properties makeIntoProperties(Collection<String> locs) {
        Object[] loc = locs.toArray(new String[locs.size()]);
        Arrays.sort(loc);
        Properties props = new Properties();
        props.put(LOCALE_COUNT, Integer.toString(loc.length));
        for (int i = 0; i < loc.length; ++i) {
            props.put(KEY_PREFIX + i, loc[i]);
        }
        return props;
    }

    private Collection<String> createCollection(Properties props) {
        String count = props.getProperty(LOCALE_COUNT);
        if (count == null) {
            return null;
        }
        int num = Integer.parseInt(count);
        ArrayList<String> locs = new ArrayList<String>(num);
        for (int i = 0; i < num; ++i) {
            String locale = props.getProperty(KEY_PREFIX + i);
            if (locale == null || locale.length() <= 0) continue;
            locs.add(locale);
        }
        Object[] locarr = locs.toArray(new String[locs.size()]);
        Arrays.sort(locarr);
        return Collections.unmodifiableCollection(Arrays.asList(locarr));
    }

    private Collection<String> createCollection() {
        String count = this.getString(LOCALE_COUNT);
        if (count == null) {
            return null;
        }
        int num = Integer.parseInt(count);
        ArrayList<String> locs = new ArrayList<String>(num);
        for (int i = 0; i < num; ++i) {
            String locale = this.getString(KEY_PREFIX + i);
            if (locale == null || locale.length() <= 0) continue;
            locs.add(locale);
        }
        return Collections.unmodifiableCollection(locs);
    }

    private String getString(String key) {
        if (RESOURCE_BUNDLE == null) {
            return null;
        }
        try {
            return RESOURCE_BUNDLE.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    static {
        ResourceBundle bundle = null;
        try {
            bundle = ResourceBundle.getBundle(BUNDLE_NAME);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        RESOURCE_BUNDLE = bundle;
    }
}

