/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models.datasources;

import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.util.Strings;
import com.sas.util.Util;
import java.io.Serializable;

public class BaseDataSourceColumn
implements DataSourceColumnInterface,
Comparable,
Serializable {
    private DataSourceInterface dataSource;
    private String columnName;
    private String columnLabel;
    private long columnType;
    private static final long serialVersionUID = -8503803317498150092L;

    public BaseDataSourceColumn() {
    }

    public BaseDataSourceColumn(DataSourceInterface dataSource, String columnName, String columnLabel, long columnType) {
        this.dataSource = dataSource;
        this.columnName = columnName;
        this.columnLabel = columnLabel;
        this.columnType = columnType;
    }

    @Override
    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public String getColumnLabel() {
        if (this.columnLabel != null && this.columnLabel.length() > 0) {
            return this.columnLabel;
        }
        return this.getColumnName();
    }

    public void setColumnLabel(String columnLabel) {
        this.columnLabel = columnLabel;
    }

    @Override
    public DataSourceInterface getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSourceInterface dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public long getColumnType() {
        return this.columnType;
    }

    public void setColumnType(long columnType) {
        if (this.columnType != columnType) {
            this.columnType = columnType;
        }
    }

    public boolean equals(Object otherItem) {
        if (otherItem instanceof DataSourceColumnInterface) {
            DataSourceColumnInterface other = (DataSourceColumnInterface)otherItem;
            if (this.getColumnType() != other.getColumnType()) {
                return false;
            }
            if (!Strings.equal(this.getColumnName(), other.getColumnName(), false, false)) {
                return false;
            }
            if (!Strings.equal(this.getColumnLabel(), other.getColumnLabel(), false, false)) {
                return false;
            }
            return Util.equal(this.getDataSource(), other.getDataSource());
        }
        return false;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        BaseDataSourceColumn clone = (BaseDataSourceColumn)super.clone();
        clone.setColumnName(this.getColumnName());
        clone.setColumnLabel(this.getColumnLabel());
        clone.setColumnType(this.getColumnType());
        clone.setDataSource((DataSourceInterface)this.getDataSource().clone());
        return clone;
    }

    public String toString() {
        return this.getDataSource() + " :: " + this.getColumnName() + " :: " + this.getColumnLabel() + " :: " + this.getColumnType();
    }

    public int compareTo(DataSourceColumnInterface dsc) {
        String dsName2;
        String dsName;
        String colName2;
        String colName = this.getColumnName();
        int compare = colName.compareTo(colName2 = dsc.getColumnName());
        if (compare == 0) {
            dsName = this.getDataSource().getDataSourceLocation();
            dsName2 = dsc.getDataSource().getDataSourceLocation();
            compare = dsName.compareTo(dsName2);
        }
        if (compare == 0) {
            dsName = this.getColumnLabel();
            dsName2 = dsc.getColumnLabel();
            compare = dsName.compareTo(dsName2);
        }
        return compare;
    }

    public int compareTo(Object obj) {
        return this.compareTo((DataSourceColumnInterface)obj);
    }
}

