/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.collection.LongKeyDictionary;
import com.sas.models.CacheBase;
import com.sas.models.CacheException;
import com.sas.models.CacheMonitorInterface;
import com.sas.models.LongQueue;
import com.sas.models.RB;
import com.sas.models.StaticCacheInterface;
import com.sas.text.Message;
import java.util.NoSuchElementException;

public class SparseCache
extends CacheBase {
    public static final String RB_KEY = "SparseCache.";
    protected LongQueue idQueue;
    protected LongKeyDictionary dictionary;
    protected CacheMonitorInterface monitor;
    private transient boolean suppressMonitorQuery;
    private static final boolean debug = false;

    public SparseCache() {
        this(null, null);
    }

    public SparseCache(StaticCacheInterface secondaryCache) {
        this(secondaryCache, null);
    }

    public SparseCache(StaticCacheInterface secondaryCache, CacheMonitorInterface monitor) {
        this(secondaryCache, monitor, 128, 16, 0, 25);
    }

    public SparseCache(StaticCacheInterface secondaryCache, CacheMonitorInterface monitor, int maxSize, int lookAheadSize) {
        this(secondaryCache, null, maxSize, lookAheadSize, 0, 25);
        this.monitor = monitor;
    }

    public SparseCache(StaticCacheInterface secondaryCache, CacheMonitorInterface monitor, int maxSize, int lookAheadSize, int thresholdType, int thresholdValue) {
        super(secondaryCache, maxSize, lookAheadSize, maxSize, lookAheadSize);
        this.monitor = monitor;
        this.dictionary = new LongKeyDictionary(maxSize, 0.75f);
        this.idQueue = new LongQueue(maxSize);
    }

    public void setMonitor(CacheMonitorInterface newMonitor) {
        if (this.monitor != null && newMonitor != null) {
            throw new IllegalStateException(RB.getStringResource(RB_KEY, "oneMonitor.ex.txt"));
        }
        this.monitor = newMonitor;
    }

    public CacheMonitorInterface getMonitor() {
        return this.monitor;
    }

    protected final boolean inCache(long key) {
        return this.dictionary.containsKey(key);
    }

    @Override
    public synchronized Object getFromCache(long key) throws CacheException {
        if (this.inCache(key)) {
            return this.dictionary.get(key);
        }
        return this.getFromSecondaryCache(key);
    }

    protected synchronized Object getFromSecondaryCache(long key) throws CacheException {
        if (this.lookAheadEnabled()) {
            boolean disabled = false;
            try {
                disabled = this.disableLookAhead();
                long[] keys = this.computeCacheKeyRange(key, key, this.lookAheadSize);
                Object[] newValues = this.secondaryCache.getFromCache(keys, false);
                this.storeInCache(keys, newValues);
                int nKeys = Math.min(keys.length, newValues.length);
                for (int i = 0; i < nKeys; ++i) {
                    if (keys[i] != key) continue;
                    Object object = newValues[i];
                    return object;
                }
                throw new CacheException(Message.format(RB.getStringResource("keyNotInCache.ex.txt"), (Object)new Long(key)));
            }
            finally {
                if (disabled) {
                    this.enableLookAhead();
                }
            }
        }
        Object newValue = this.secondaryCache.getFromCache(key);
        this.storeInCache(key, newValue);
        return newValue;
    }

    @Override
    public synchronized Object[] getFromCache(long[] keys, boolean readFully) throws CacheException {
        boolean surpassedThreshold;
        int nFound = 0;
        int nKeys = keys.length;
        if (nKeys == 0) {
            return SparseCache.nullObjectArray();
        }
        for (int i = 0; i < nKeys; ++i) {
            long key = keys[i];
            if (!this.inCache(key)) continue;
            ++nFound;
        }
        int nMissing = nKeys - nFound;
        if (this.thresholdType == 1) {
            surpassedThreshold = nMissing > this.threshold;
        } else {
            boolean bl = surpassedThreshold = 100 * nMissing / nKeys > this.threshold;
        }
        if (surpassedThreshold) {
            Object[] result = this.secondaryCache.getFromCache(keys, readFully);
            this.storeInCache(keys, result);
            return result;
        }
        Object[] result = new Object[keys.length];
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            long key = keys[i];
            if (!this.inCache(key)) continue;
            result[i] = this.dictionary.get(key);
        }
        if (nFound == keys.length) {
            return result;
        }
        long[] subKeys = new long[nMissing];
        int[] indices = new int[nMissing];
        Object[] subResult = new Object[nMissing];
        int len2 = keys.length;
        int j = 0;
        for (int i = 0; i < len2; ++i) {
            long key = keys[i];
            if (this.inCache(key) || j >= nMissing) continue;
            subKeys[j] = key;
            indices[j] = i;
            ++j;
        }
        subResult = this.secondaryCache.getFromCache(subKeys, readFully);
        this.storeInCache(subKeys, subResult);
        for (int j2 = 0; j2 < nMissing; ++j2) {
            result[indices[j2]] = subResult[j2];
        }
        return result;
    }

    @Override
    public synchronized Object[] getFromCache(long startKey, long endKey, boolean readFully) throws CacheException {
        if (startKey == endKey && this.inCache(startKey)) {
            return new Object[]{this.dictionary.get(startKey)};
        }
        long[] keys = this.computeCacheKeyRange(startKey, endKey, readFully ? 0 : this.lookAheadSize);
        Object[] newValues = null;
        try {
            if (keys[0] == startKey && keys[keys.length - 1] == endKey) {
                newValues = this.getFromCache(keys, readFully);
                return newValues;
            }
            int start = this.find(startKey, keys, 0);
            int end = this.find(endKey, keys, start);
            if (start == -1 || end == -1) {
                long[] newKeys = this.computeCacheKeyRange(startKey, endKey, 0);
                newValues = this.getFromCache(newKeys, readFully);
            } else {
                Object[] subArray = new Object[end - start + 1];
                newValues = this.getFromCache(keys, readFully);
                System.arraycopy(newValues, start, subArray, 0, end - start + 1);
                newValues = subArray;
            }
        }
        catch (Exception e) {
            throw new CacheException(e.getMessage());
        }
        return newValues;
    }

    private int find(long key, long[] keys, int start) {
        int len = keys.length;
        for (int i = Math.max(start, 0); i < len; ++i) {
            if (keys[i] != key) continue;
            return i;
        }
        return -1;
    }

    @Override
    public synchronized long[] computeCacheKeyRange(long start, long end, int size) throws CacheException {
        return this.secondaryCache.computeCacheKeyRange(start, end, size);
    }

    @Override
    public synchronized long[] getCacheKeys() throws CacheException {
        return this.dictionary.getKeys();
    }

    public synchronized Object[] getCacheValues() {
        return this.dictionary.getValues();
    }

    @Override
    public synchronized boolean cacheContainsKey(long key) throws CacheException {
        return this.inCache(key);
    }

    @Override
    public synchronized void invalidateCache() {
        if (this.monitor != null && !this.idQueue.isEmpty()) {
            LongQueue q = this.idQueue;
            try {
                q = (LongQueue)this.idQueue.clone();
            }
            catch (Exception e) {
                // empty catch block
            }
            while (!q.isEmpty()) {
                try {
                    this.invalidateCache(q.dequeue());
                }
                catch (CacheException cacheException) {}
            }
        }
        this.count = 0;
        this.idQueue.removeAll();
        this.dictionary.removeAll();
    }

    @Override
    public synchronized void invalidateCache(long key) throws CacheException {
        if (this.cacheContainsKey(key)) {
            this.removeFromIdQueue(key);
            this.invalidateCacheQuickly(key);
        }
    }

    protected void removeFromIdQueue(long key) {
        for (int i = this.count; i > 0; --i) {
            long k = this.idQueue.dequeue();
            if (k == key) continue;
            this.idQueue.queue(k);
        }
    }

    protected synchronized void invalidateCacheQuickly(long key) {
        try {
            if (this.monitor != null) {
                Object item = this.dictionary.get(key);
                this.dictionary.removeAt(key);
                --this.count;
                this.monitor.noteCacheItemRemoved(item, key, this);
            } else {
                this.dictionary.removeAt(key);
                --this.count;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void storeInCache(long key, Object value) throws CacheException {
        if (this.cacheContainsKey(key)) {
            if (this.monitor != null) {
                Object item = this.dictionary.get(key);
                if (item == value) {
                    return;
                }
                this.dictionary.removeAt(key);
                this.monitor.noteCacheItemRemoved(item, key, this);
            }
            this.dictionary.set(key, value);
        } else {
            if (this.monitor == null && this.isFull()) {
                this.removeOneUnconditionally(this.idQueue.dequeue());
            } else {
                while (this.isFull()) {
                    int n = this.findRemovable(true);
                    boolean ignore = false;
                    if (n == 0) {
                        boolean bl = ignore = this.monitor != null && this.monitor.noteCacheFull(this.count, this);
                    }
                    if (!this.isFull()) continue;
                    if (!ignore && n != 0) {
                        this.findRemovable(true);
                    }
                    this.removeOneUnconditionally(this.idQueue.dequeue());
                }
            }
            this.dictionary.set(key, value);
            ++this.count;
            this.idQueue.queue(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOneUnconditionally(long key) {
        boolean prev = this.suppressMonitorQuery;
        try {
            this.suppressMonitorQuery = true;
            this.invalidateCacheQuickly(key);
        }
        finally {
            this.suppressMonitorQuery = prev;
        }
    }

    private int findRemovable(boolean stopWhenFound) {
        int n = 0;
        for (int i = 0; i < this.count(); ++i) {
            long key = this.idQueue.peek();
            Object item = this.dictionary.get(key);
            if (this.monitor == null || this.monitor.isCacheItemRemovable(item, key, this)) {
                if (stopWhenFound) {
                    return 1;
                }
                ++n;
            }
            this.idQueue.queue(this.idQueue.dequeue());
        }
        return n;
    }

    protected synchronized void storeInCache(long[] keys, Object[] newValues) throws CacheException {
        if (newValues.length == 0) {
            return;
        }
        int nKeys = keys.length;
        int size = Math.min(this.maxSize, keys.length);
        this.ensureCapacity(size, keys);
        for (int index = 0; index < size; ++index) {
            this.storeInCache(keys[index], newValues[index]);
        }
    }

    protected void ensureCapacity(int size, long[] keys) throws CacheException {
        int numToRemove;
        long key;
        int i;
        if (this.roomFor(size)) {
            return;
        }
        if (this.monitor == null) {
            for (i = keys.length - 1; i >= 0 && !this.roomFor(size); --i) {
                key = keys[i];
                if (!this.cacheContainsKey(key)) continue;
                this.removeFromIdQueue(key);
                this.invalidateCacheQuickly(key);
            }
        } else {
            for (i = keys.length - 1; i >= 0 && !this.roomFor(size); --i) {
                key = keys[i];
                if (!this.cacheContainsKey(key) || !this.monitor.isCacheItemRemovable(this.dictionary.get(key), key, this)) continue;
                this.removeFromIdQueue(key);
                this.invalidateCacheQuickly(key);
            }
        }
        if (this.roomFor(size)) {
            return;
        }
        if (this.monitor != null) {
            for (numToRemove = this.count() + size - this.maxSize; numToRemove > 0; --numToRemove) {
                int n = this.findRemovable(true);
                if (n == 0) continue;
                long key2 = this.idQueue.dequeue();
                this.removeOneUnconditionally(key2);
            }
        } else {
            while (numToRemove > 0) {
                key = this.idQueue.dequeue();
                this.removeOneUnconditionally(key);
                --numToRemove;
            }
        }
    }

    private String status(int size) throws CacheException {
        return "ensure " + size + ", contains " + this.count() + "/" + this.maxSize + ", " + (this.maxSize - this.count) + " free, need " + (this.maxSize - this.count < size ? size - (this.maxSize - this.count) : 0) + " more, next key in cache: " + (this.idQueue.isEmpty() ? "empty" : this.idQueue.peek() + "... in cache? " + this.cacheContainsKey(this.idQueue.peek()) + " monitored? " + (this.monitor != null));
    }

    private boolean roomFor(int numItems) {
        return this.count() + numItems <= this.maxSize;
    }

    @Override
    public synchronized void configureCache(int maxCacheSize, int bufferLookAhead, int thresholdType, int thresholdValue, int accessType) throws CacheException {
        if (maxCacheSize > -1 && maxCacheSize != this.maxSize) {
            int numToRemove;
            if (maxCacheSize >= this.count()) {
                numToRemove = 0;
            } else {
                if (this.monitor != null) {
                    int numRemovable = this.findRemovable(false);
                    int minCacheSize = this.count() - numRemovable;
                    maxCacheSize = Math.max(minCacheSize, maxCacheSize);
                }
                numToRemove = this.count() - maxCacheSize;
            }
            if (numToRemove > 0 || maxCacheSize != this.maxSize) {
                LongQueue newQueue = new LongQueue(maxCacheSize);
                LongQueue q = this.idQueue;
                try {
                    q = (LongQueue)this.idQueue.clone();
                }
                catch (Exception e) {
                    // empty catch block
                }
                while (!q.isEmpty()) {
                    boolean remove;
                    boolean bl = remove = numToRemove > 0;
                    if (remove && this.monitor != null) {
                        long key = q.peek();
                        Object item = this.dictionary.get(key);
                        remove = this.monitor.isCacheItemRemovable(item, key, this);
                    }
                    if (remove) {
                        this.removeOneUnconditionally(q.dequeue());
                        --numToRemove;
                        continue;
                    }
                    newQueue.queue(q.dequeue());
                }
                this.idQueue = newQueue;
            }
        }
        super.configureCache(maxCacheSize, bufferLookAhead, thresholdType, thresholdValue, accessType);
    }
}

