/*
 * Decompiled with CFR 0.152.
 */
package com.sas.measures;

import com.sas.codepolicy.SASScope;
import com.sas.measures.Measure;
import com.sas.measures.RB;
import com.sas.measures.UnitInfo;
import com.sas.text.Message;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope(value="ALL")
public class BaseDistance
extends Measure {
    public static final String RB_KEY = "Distance.";
    static final long serialVersionUID = 103288383102555192L;
    private static final double INCHES_PER_METER = 39.37;
    private static final double INCHES_PER_FOOT = 12.0;
    private static final double INCHES_PER_POINT = 0.013837000138370002;
    private static final double MM_PER_METER = 1000.0;
    private static final double MM_PER_POINT = 0.35146050643561094;
    private static final double MM_PER_ANGSTROM = 1.0E-7;
    private static final double MM_PER_NM = 1.0E-6;
    private static final double MM_PER_UM = 0.001;
    private static final double MM_PER_PICA = 4.2175260772273315;
    private static final double METER_PER_MM = 0.001;
    private static final double METER_PER_CM = 0.01;
    private static final double METER_PER_DM = 0.1;
    private static final double METER_PER_DAM = 10.0;
    private static final double METER_PER_HM = 100.0;
    private static final double METER_PER_KM = 1000.0;
    private static final double FEET_PER_INCH = 0.08333333333333333;
    private static final double FEET_PER_YARD = 3.0;
    private static final double FEET_PER_ROD = 16.5;
    private static final double FEET_PER_FURLONG = 660.0;
    private static final double FEET_PER_MILE = 5280.0;
    private static final double FEET_PER_NMILE = 6076.11549;
    private static final double FEET_PER_LEAGUE = 15840.0;
    private static final double FEET_PER_LINK = 0.66;
    private static final double FEET_PER_CHAIN = 66.0;
    private static final double MILES_PER_AU = 9.29E7;
    private static final double AU_PER_PARSEC = 206265.0;
    private static final double FEET_PER_METER = 3.2808333333333333;
    private static final double METER_PER_FOOT = 0.30480060960121924;
    private static final double FEET_PER_MM = 0.0032808333333333335;
    private static final double MM_PER_FOOT = 304.80060960121926;
    private static final double FEET_PER_AU = 4.90512E11;
    private static final double METER_PER_AU = 1.4950835661671326E11;
    private static final double MM_PER_AU = 1.4950835661671325E14;
    private static final double MILES_PER_FOOT = 1.893939393939394E-4;
    private static final double MILES_PER_METER = 6.213699494949494E-4;
    private static final double AU_PER_FOOT = 2.0386861075773886E-12;
    private static final double AU_PER_METER = 6.688589337943481E-12;
    private static final double AU_PER_MM = 6.688589337943481E-9;
    private static final double DEFAULT_DPI = 96.0;
    private static final int UM_ANGSTROM = 0;
    private static final int UM_NANOMETER = 1;
    private static final int UM_MICROMETER = 2;
    private static final int UM_MILLIMETER = 3;
    private static final int UM_POINT = 4;
    private static final int UM_PICA = 5;
    private static final int UM_MILLIMETERS = 5;
    private static final int UM_CENTIMETER = 6;
    private static final int UM_DECIMETER = 7;
    private static final int UM_METER = 8;
    private static final int UM_DEKAMETER = 9;
    private static final int UM_HECTOMETER = 10;
    private static final int UM_KILOMETER = 11;
    private static final int UM_METERS = 11;
    private static final int UM_INCH = 12;
    private static final int UM_F00T = 13;
    private static final int UM_YARD = 14;
    private static final int UM_ROD = 15;
    private static final int UM_FUR = 16;
    private static final int UM_MILE = 17;
    private static final int UM_NAUTICAL_MILE = 18;
    private static final int UM_LEAGUE = 19;
    private static final int UM_LINK = 20;
    private static final int UM_CHAIN = 21;
    private static final int UM_FEET = 21;
    private static final int UM_ASTRONOMICAL_UNIT = 22;
    private static final int UM_PARSEC = 23;
    private static final int UM_AUS = 23;
    private static final int FIXED = 23;
    private static final int UM_L_SPACE = 24;
    private static final int UM_M_SPACE = 25;
    private static final int UM_N_SPACE = 26;
    private static final int UM_X_HEIGHT = 27;
    private static final int UM_FIGURE_WIDTH = 28;
    private static final int UM_SPACE = 29;
    private static final int UM_CHARACTER_CELL = 30;
    private static final int UM_HT = 31;
    private static final int UM_DP = 32;
    private static final int UM_LN = 33;
    private static final int FONT = 33;
    private static final int UM_X_PIXEL = 34;
    private static final int UM_Y_PIXEL = 35;
    private static final int DEVICE = 35;
    public static int FIXED_UNITS = 1;
    public static int FONT_UNITS = 2;
    public static int DEVICE_UNITS = 8;
    private static final UnitInfo[] dunits = new UnitInfo[]{new UnitInfo("A", 0, 1.0E-7, RB.getStringResource("Distance.", "A.txt")), new UnitInfo("nm", 1, 1.0E-6, RB.getStringResource("Distance.", "nm.txt")), new UnitInfo("um", 2, 0.001, RB.getStringResource("Distance.", "um.txt")), new UnitInfo("mm", 3, 1.0, RB.getStringResource("Distance.", "mm.txt")), new UnitInfo("pt", 4, 0.35146050643561094, RB.getStringResource("Distance.", "pt.txt")), new UnitInfo("pica", 5, 4.2175260772273315, RB.getStringResource("Distance.", "pica.txt")), new UnitInfo("cm", 6, 0.01, RB.getStringResource("Distance.", "cm.txt")), new UnitInfo("dm", 7, 0.1, RB.getStringResource("Distance.", "dm.txt")), new UnitInfo("m", 8, 1.0, RB.getStringResource("Distance.", "m.txt")), new UnitInfo("dam", 9, 10.0, RB.getStringResource("Distance.", "dam.txt")), new UnitInfo("hm", 10, 100.0, RB.getStringResource("Distance.", "hm.txt")), new UnitInfo("km", 11, 1000.0, RB.getStringResource("Distance.", "km.txt")), new UnitInfo("in", 12, 0.08333333333333333, RB.getStringResource("Distance.", "in.txt")), new UnitInfo("ft", 13, 1.0, RB.getStringResource("Distance.", "ft.txt")), new UnitInfo("yd", 14, 3.0, RB.getStringResource("Distance.", "yd.txt")), new UnitInfo("rod", 15, 16.5, RB.getStringResource("Distance.", "rod.txt")), new UnitInfo("fur", 16, 660.0, RB.getStringResource("Distance.", "fur.txt")), new UnitInfo("mi", 17, 5280.0, RB.getStringResource("Distance.", "mi.txt")), new UnitInfo("nmi", 18, 6076.11549, RB.getStringResource("Distance.", "nmi.txt")), new UnitInfo("lg", 19, 15840.0, RB.getStringResource("Distance.", "lg.txt")), new UnitInfo("li", 20, 0.66, RB.getStringResource("Distance.", "li.txt")), new UnitInfo("ch", 21, 66.0, RB.getStringResource("Distance.", "ch.txt")), new UnitInfo("au", 22, 1.0, RB.getStringResource("Distance.", "au.txt")), new UnitInfo("pc", 23, 206265.0, RB.getStringResource("Distance.", "pc.txt")), new UnitInfo("el", 24, 0.0, RB.getStringResource("Distance.", "el.txt")), new UnitInfo("em", 25, 0.0, RB.getStringResource("Distance.", "em.txt")), new UnitInfo("en", 26, 0.0, RB.getStringResource("Distance.", "en.txt")), new UnitInfo("ex", 27, 0.0, RB.getStringResource("Distance.", "ex.txt")), new UnitInfo("fg", 28, 0.0, RB.getStringResource("Distance.", "fg.txt")), new UnitInfo("sp", 29, 0.0, RB.getStringResource("Distance.", "sp.txt")), new UnitInfo("cc", 30, 0.0, RB.getStringResource("Distance.", "cc.txt")), new UnitInfo("ht", 31, 0.0, RB.getStringResource("Distance.", "ht.txt")), new UnitInfo("dp", 32, 0.0, RB.getStringResource("Distance.", "dp.txt")), new UnitInfo("ln", 33, 0.0, RB.getStringResource("Distance.", "ln.txt")), new UnitInfo("px", 34, 1.0, RB.getStringResource("Distance.", "px.txt")), new UnitInfo("py", 35, 1.0, RB.getStringResource("Distance.", "py.txt"))};
    private static int[] mostCommonlyUsed = new int[]{3, 6, 8, 12, 13, 34, 35, 25, 26, 4, 5, 29, 24, 30, 31, 33, 28, 32, 27, 11, 7, 2, 17, 14, 22, 23, 18, 9, 10, 0, 1, 19, 20, 21, 15, 16};
    protected int unitIndex;

    public BaseDistance(double magnitude, String unit) {
        super(magnitude, unit);
    }

    @SASScope
    public BaseDistance(double magnitude, String unit, Locale locale) {
        super(magnitude, unit, locale);
    }

    public BaseDistance(String text) {
        this(text, null);
    }

    @SASScope
    public BaseDistance(String text, Locale locale) {
        super(text, locale);
    }

    @Override
    public double getMagnitude(Object unit) {
        int du_index = this.parseUnit(unit);
        if (du_index == -1) {
            throw new IllegalArgumentException(Message.format(RB.getStringResource("invalidUnit.ex.txt"), unit));
        }
        return this.internalGetEquivalent(dunits[this.unitIndex], dunits[du_index], this.magnitude, null);
    }

    public double getMagnitude(Object unit, Font font) {
        int du_index = this.parseUnit(unit);
        if (du_index == -1) {
            throw new IllegalArgumentException(Message.format(RB.getStringResource("invalidUnit.ex.txt"), unit));
        }
        System.out.println(RB.getStringResource(RB_KEY, "methodNotImplemented"));
        return this.internalGetEquivalent(dunits[this.unitIndex], dunits[du_index], this.magnitude, font);
    }

    @Override
    public Object getUnit() {
        return BaseDistance.dunits[this.unitIndex].name;
    }

    @Override
    public String getUnitName() {
        return BaseDistance.dunits[this.unitIndex].longName;
    }

    public int getUnitType() {
        if (BaseDistance.dunits[this.unitIndex].id <= 23) {
            return FIXED_UNITS;
        }
        if (BaseDistance.dunits[this.unitIndex].id <= 33) {
            return FONT_UNITS;
        }
        return DEVICE_UNITS;
    }

    @Override
    protected void initializeUnit(Object unit) {
        this.unitIndex = this.parseUnit(unit);
        if (this.unitIndex == -1) {
            throw new IllegalArgumentException(Message.format(RB.getStringResource("invalidUnit.ex.txt"), unit));
        }
    }

    public boolean validateUnit(String unit) {
        return this.parseUnit(unit) != -1;
    }

    private int parseUnit(Object unit) {
        for (int index = 0; index < dunits.length; ++index) {
            int i = mostCommonlyUsed[index];
            String dunit = BaseDistance.dunits[i].name;
            if (dunit == unit || dunit.equals(unit)) {
                return i;
            }
            dunit = BaseDistance.dunits[i].longName;
            if (dunit != unit && !dunit.equals(unit)) continue;
            return i;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    private double internalGetEquivalent(UnitInfo srcInfo, UnitInfo dstInfo, double magnitude, Font font) {
        if (dstInfo.name.equals(srcInfo.name)) {
            return magnitude;
        }
        double mag = magnitude * srcInfo.normf;
        if (dstInfo.id <= 5) {
            if (srcInfo.id <= 5) {
                return mag /= dstInfo.normf;
            }
            if (srcInfo.id <= 11) {
                return mag * 1000.0 / dstInfo.normf;
            }
            if (srcInfo.id <= 21) {
                return mag * 304.80060960121926 / dstInfo.normf;
            }
            if (srcInfo.id <= 23) {
                return mag * 1.4950835661671325E14 / dstInfo.normf;
            }
            if (srcInfo.id < 33) {
                System.out.println(RB.getStringResource(RB_KEY, "fontUnitConversionNotImplemented.txt"));
                return mag;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit == null) {
                System.out.println(RB.getStringResource(RB_KEY, "toolkitIsNull.txt"));
                return magnitude;
            }
            double dotsPerInch = 96.0;
            if (!GraphicsEnvironment.isHeadless()) {
                dotsPerInch = toolkit.getScreenResolution();
            }
            mag *= 1.0 / dotsPerInch * 0.08333333333333333;
            return mag * 304.80060960121926 / dstInfo.normf;
        }
        if (dstInfo.id <= 11) {
            if (srcInfo.id <= 5) {
                return mag * 0.001 / dstInfo.normf;
            }
            if (srcInfo.id <= 11) {
                return mag /= dstInfo.normf;
            }
            if (srcInfo.id <= 21) {
                return mag * 0.30480060960121924 / dstInfo.normf;
            }
            if (srcInfo.id <= 23) {
                return mag * 1.4950835661671326E11 / dstInfo.normf;
            }
            if (srcInfo.id <= 33) {
                System.out.println(RB.getStringResource(RB_KEY, "fontUnitConversionNotImplemented.txt"));
                return mag;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit == null) {
                System.out.println(RB.getStringResource(RB_KEY, "toolkitIsNull.txt"));
                return magnitude;
            }
            double dotsPerInch = 96.0;
            if (!GraphicsEnvironment.isHeadless()) {
                dotsPerInch = toolkit.getScreenResolution();
            }
            mag *= 1.0 / dotsPerInch * 0.08333333333333333;
            return mag * 0.30480060960121924 / dstInfo.normf;
        }
        if (dstInfo.id <= 21) {
            if (srcInfo.id <= 5) {
                return mag * 0.0032808333333333335 / dstInfo.normf;
            }
            if (srcInfo.id <= 11) {
                return mag * 3.2808333333333333 / dstInfo.normf;
            }
            if (srcInfo.id <= 21) {
                return mag /= dstInfo.normf;
            }
            if (srcInfo.id <= 23) {
                return mag * 4.90512E11 / dstInfo.normf;
            }
            if (srcInfo.id < 33) {
                System.out.println(RB.getStringResource(RB_KEY, "fontUnitConversionNotImplemented.txt"));
                return mag;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit == null) {
                System.out.println(RB.getStringResource(RB_KEY, "toolkitIsNull.txt"));
                return magnitude;
            }
            double dotsPerInch = 96.0;
            if (!GraphicsEnvironment.isHeadless()) {
                dotsPerInch = toolkit.getScreenResolution();
            }
            mag *= 1.0 / dotsPerInch * 0.08333333333333333;
            return mag /= dstInfo.normf;
        }
        if (dstInfo.id <= 23) {
            if (srcInfo.id <= 5) {
                return mag * 6.688589337943481E-9 / dstInfo.normf;
            }
            if (srcInfo.id <= 11) {
                return mag * 6.688589337943481E-12 / dstInfo.normf;
            }
            if (srcInfo.id <= 21) {
                return mag * 2.0386861075773886E-12 / dstInfo.normf;
            }
            if (srcInfo.id <= 23) {
                return mag /= dstInfo.normf;
            }
            if (srcInfo.id < 33) {
                System.out.println(RB.getStringResource(RB_KEY, "fontUnitConversionNotImplemented.txt"));
                return mag;
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit == null) {
                System.out.println(RB.getStringResource(RB_KEY, "toolkitIsNull.txt"));
                return magnitude;
            }
            double dotsPerInch = 96.0;
            if (!GraphicsEnvironment.isHeadless()) {
                dotsPerInch = toolkit.getScreenResolution();
            }
            mag *= 1.0 / dotsPerInch * 0.08333333333333333;
            return mag * 2.0386861075773886E-12 / dstInfo.normf;
        }
        if (dstInfo.id <= 33) {
            System.out.println(RB.getStringResource(RB_KEY, "fontUnitConversionNotImplemented.txt"));
            return mag;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        if (toolkit == null) {
            System.out.println(RB.getStringResource(RB_KEY, "toolkitIsNull.txt"));
            return magnitude;
        }
        double dotsPerInch = 96.0;
        if (!GraphicsEnvironment.isHeadless()) {
            dotsPerInch = toolkit.getScreenResolution();
        }
        if (dstInfo.id == 34) {
            if (srcInfo.id <= 5) {
                double XPIXEL_PER_MM = dotsPerInch * 12.0 * 0.0032808333333333335;
                return mag * XPIXEL_PER_MM / dstInfo.normf;
            }
            if (srcInfo.id <= 11) {
                double XPIXEL_PER_METER = dotsPerInch * 12.0 * 3.2808333333333333;
                return mag * XPIXEL_PER_METER / dstInfo.normf;
            }
            if (srcInfo.id <= 21) {
                double XPIXEL_PER_FOOT = dotsPerInch * 12.0;
                return mag * XPIXEL_PER_FOOT / dstInfo.normf;
            }
            if (srcInfo.id <= 23) {
                double XPIXEL_PER_AU = dotsPerInch * 12.0 * 4.90512E11;
                return mag * XPIXEL_PER_AU / dstInfo.normf;
            }
            if (srcInfo.id <= 33) {
                System.out.println(RB.getStringResource(RB_KEY, "fontUnitConversionNotImplemented.txt"));
                return mag;
            }
            if (srcInfo.id != 34) return mag / dstInfo.normf;
            return mag / dstInfo.normf;
        }
        if (dstInfo.id != 35) return mag;
        if (srcInfo.id <= 5) {
            double YPIXEL_PER_MM = dotsPerInch * 12.0 * 0.0032808333333333335;
            return mag * YPIXEL_PER_MM / dstInfo.normf;
        }
        if (srcInfo.id <= 11) {
            double YPIXEL_PER_METER = dotsPerInch * 12.0 * 3.2808333333333333;
            return mag * YPIXEL_PER_METER / dstInfo.normf;
        }
        if (srcInfo.id <= 21) {
            double YPIXEL_PER_FOOT = dotsPerInch * 12.0;
            return mag * YPIXEL_PER_FOOT / dstInfo.normf;
        }
        if (srcInfo.id <= 23) {
            double YPIXEL_PER_AU = dotsPerInch * 12.0 * 4.90512E11;
            return mag * YPIXEL_PER_AU / dstInfo.normf;
        }
        if (srcInfo.id < 33) {
            System.out.println(RB.getStringResource(RB_KEY, "fontUnitConversionNotImplemented.txt"));
            return mag;
        }
        if (srcInfo.id != 34) return mag / dstInfo.normf;
        return mag / dstInfo.normf;
    }

    public static Map makeUnitsMap(int id) {
        double d;
        UnitInfo info;
        int i;
        int l;
        HashMap<String, Double> aMap = new HashMap<String, Double>();
        BaseDistance meter = new BaseDistance(1.0, "m");
        if ((id & FIXED_UNITS) != 0) {
            l = dunits.length;
            for (i = 0; i <= 23 && i < l; ++i) {
                info = dunits[i];
                d = meter.getMagnitude(info.name);
                aMap.put(info.longName, new Double(1.0 / d));
            }
        }
        if ((id & FONT_UNITS) != 0) {
            l = dunits.length;
            for (i = 24; i <= 33 && i < l; ++i) {
                info = dunits[i];
                d = meter.getMagnitude(info.name);
                aMap.put(info.longName, new Double(1.0 / d));
            }
        }
        if ((id & DEVICE_UNITS) != 0) {
            l = dunits.length;
            for (i = 34; i <= 35 && i < l; ++i) {
                info = dunits[i];
                d = meter.getMagnitude(info.name);
                aMap.put(info.longName, new Double(1.0 / d));
            }
        }
        return aMap;
    }

    public static List makeUnitsJavaList(int id) {
        UnitInfo info;
        int i;
        int l;
        ArrayList<String> list = new ArrayList<String>();
        if ((id & FIXED_UNITS) != 0) {
            l = dunits.length;
            for (i = 0; i <= 23 && i < l; ++i) {
                info = dunits[i];
                list.add(info.longName);
            }
        }
        if ((id & FONT_UNITS) != 0) {
            l = dunits.length;
            for (i = 24; i <= 33 && i < l; ++i) {
                info = dunits[i];
                list.add(info.longName);
            }
        }
        if ((id & DEVICE_UNITS) != 0) {
            l = dunits.length;
            for (i = 34; i <= 35 && i < l; ++i) {
                info = dunits[i];
                list.add(info.longName);
            }
        }
        return list;
    }
}

