/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.RB;
import com.sas.datatypes.StringType;
import com.sas.util.ValueItem;
import java.text.MessageFormat;
import java.util.List;
import java.util.Locale;

@SASScope
public class StringRangeType
extends BaseRangeDataType {
    public static final StringRangeType DEFAULT_INSTANCE = new StringRangeType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 2) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            String toDecode = (String)inputValue;
            String[] minMaxValues = toDecode.split("--");
            if (minMaxValues.length == 2) {
                Object upper;
                minMaxValues[0] = minMaxValues[0].trim();
                minMaxValues[1] = minMaxValues[1].trim();
                String[] values = new String[2];
                Object lower = StringType.DEFAULT_INSTANCE.coerceValue(minMaxValues[0], inputLocale);
                if (lower instanceof String) {
                    values[0] = (String)lower;
                }
                if ((upper = StringType.DEFAULT_INSTANCE.coerceValue(minMaxValues[1], inputLocale)) instanceof String) {
                    values[1] = (String)upper;
                }
                return values;
            }
        } else if (inputValue instanceof Object[]) {
            Object[] toDecode = (Object[])inputValue;
            if (toDecode.length == 2) {
                Object upper;
                String[] values = new String[2];
                Object lower = StringType.DEFAULT_INSTANCE.coerceValue(toDecode[0], inputLocale);
                if (lower instanceof String) {
                    values[0] = (String)lower;
                }
                if ((upper = StringType.DEFAULT_INSTANCE.coerceValue(toDecode[1], inputLocale)) instanceof String) {
                    values[1] = (String)upper;
                }
                return values;
            }
        } else if (inputValue == null) {
            return null;
        }
        throw new IllegalArgumentException(MessageFormat.format(RB.getStringResource("StringRangeType.unableToConvert.fmt", inputLocale), this.formatValueForException(inputValue, inputLocale)));
    }

    @Override
    public int getSQLType() {
        return 12;
    }

    @Override
    public DataTypeInterface getRangeMinMaxDataType() {
        return StringType.DEFAULT_INSTANCE;
    }

    @Override
    public Object[] getRangeDefaultValue() {
        return new String[2];
    }

    @Override
    public Object coerceValueFromPersistedString(String input) throws IllegalArgumentException {
        return this.coerceValue(input, Locale.US);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (null != retVal && retVal instanceof String[] && retVal == value && ((String[])value).length == 2) {
            String[] castRetVal = (String[])retVal;
            String[] copiedRetVal = new String[]{castRetVal[0], castRetVal[1]};
            return copiedRetVal;
        }
        return retVal;
    }
}

