"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KubectlLayer = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const fs = require("fs");
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
/**
 * An AWS Lambda layer that includes `kubectl` and `helm`.
 */
class KubectlLayer extends lambda.LayerVersion {
    constructor(scope, id) {
        super(scope, id, {
            code: lambda.Code.fromAsset(path.join(__dirname, 'layer.zip'), {
                // we hash the Dockerfile (it contains the tools versions) because hashing the zip is non-deterministic
                assetHash: hashFile(path.join(__dirname, '..', 'layer', 'Dockerfile')),
            }),
            description: '/opt/kubectl/kubectl and /opt/helm/helm',
        });
    }
}
exports.KubectlLayer = KubectlLayer;
_a = JSII_RTTI_SYMBOL_1;
KubectlLayer[_a] = { fqn: "@aws-cdk/lambda-layer-kubectl.KubectlLayer", version: "1.155.0" };
function hashFile(fileName) {
    return crypto
        .createHash('sha256')
        .update(fs.readFileSync(fileName))
        .digest('hex');
}
//# sourceMappingURL=data:application/json;base64,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