# Copyright 2020 The Tekton Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Tekton

    Tekton Pipeline  # noqa: E501

    The version of the OpenAPI document: v0.17.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tekton.configuration import Configuration


class V1beta1PipelineTaskCondition(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'condition_ref': 'str',
        'params': 'list[V1beta1Param]',
        'resources': 'list[V1beta1PipelineTaskInputResource]'
    }

    attribute_map = {
        'condition_ref': 'conditionRef',
        'params': 'params',
        'resources': 'resources'
    }

    def __init__(self, condition_ref=None, params=None, resources=None, local_vars_configuration=None):  # noqa: E501
        """V1beta1PipelineTaskCondition - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._condition_ref = None
        self._params = None
        self._resources = None
        self.discriminator = None

        self.condition_ref = condition_ref
        if params is not None:
            self.params = params
        if resources is not None:
            self.resources = resources

    @property
    def condition_ref(self):
        """Gets the condition_ref of this V1beta1PipelineTaskCondition.  # noqa: E501

        ConditionRef is the name of the Condition to use for the conditionCheck  # noqa: E501

        :return: The condition_ref of this V1beta1PipelineTaskCondition.  # noqa: E501
        :rtype: str
        """
        return self._condition_ref

    @condition_ref.setter
    def condition_ref(self, condition_ref):
        """Sets the condition_ref of this V1beta1PipelineTaskCondition.

        ConditionRef is the name of the Condition to use for the conditionCheck  # noqa: E501

        :param condition_ref: The condition_ref of this V1beta1PipelineTaskCondition.  # noqa: E501
        :type: str
        """
        if self.local_vars_configuration.client_side_validation and condition_ref is None:  # noqa: E501
            raise ValueError("Invalid value for `condition_ref`, must not be `None`")  # noqa: E501

        self._condition_ref = condition_ref

    @property
    def params(self):
        """Gets the params of this V1beta1PipelineTaskCondition.  # noqa: E501

        Params declare parameters passed to this Condition  # noqa: E501

        :return: The params of this V1beta1PipelineTaskCondition.  # noqa: E501
        :rtype: list[V1beta1Param]
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this V1beta1PipelineTaskCondition.

        Params declare parameters passed to this Condition  # noqa: E501

        :param params: The params of this V1beta1PipelineTaskCondition.  # noqa: E501
        :type: list[V1beta1Param]
        """

        self._params = params

    @property
    def resources(self):
        """Gets the resources of this V1beta1PipelineTaskCondition.  # noqa: E501

        Resources declare the resources provided to this Condition as input  # noqa: E501

        :return: The resources of this V1beta1PipelineTaskCondition.  # noqa: E501
        :rtype: list[V1beta1PipelineTaskInputResource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this V1beta1PipelineTaskCondition.

        Resources declare the resources provided to this Condition as input  # noqa: E501

        :param resources: The resources of this V1beta1PipelineTaskCondition.  # noqa: E501
        :type: list[V1beta1PipelineTaskInputResource]
        """

        self._resources = resources

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1beta1PipelineTaskCondition):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1beta1PipelineTaskCondition):
            return True

        return self.to_dict() != other.to_dict()
