# Copyright 2020 The Tekton Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Tekton

    Tekton Pipeline  # noqa: E501

    The version of the OpenAPI document: v0.17.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from tekton.configuration import Configuration


class V1beta1PipelineTask(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'conditions': 'list[V1beta1PipelineTaskCondition]',
        'name': 'str',
        'params': 'list[V1beta1Param]',
        'resources': 'V1beta1PipelineTaskResources',
        'retries': 'int',
        'run_after': 'list[str]',
        'task_ref': 'V1beta1TaskRef',
        'task_spec': 'V1beta1EmbeddedTask',
        'timeout': 'V1Duration',
        'when': 'list[V1beta1WhenExpression]',
        'workspaces': 'list[V1beta1WorkspacePipelineTaskBinding]'
    }

    attribute_map = {
        'conditions': 'conditions',
        'name': 'name',
        'params': 'params',
        'resources': 'resources',
        'retries': 'retries',
        'run_after': 'runAfter',
        'task_ref': 'taskRef',
        'task_spec': 'taskSpec',
        'timeout': 'timeout',
        'when': 'when',
        'workspaces': 'workspaces'
    }

    def __init__(self, conditions=None, name=None, params=None, resources=None, retries=None, run_after=None, task_ref=None, task_spec=None, timeout=None, when=None, workspaces=None, local_vars_configuration=None):  # noqa: E501
        """V1beta1PipelineTask - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._conditions = None
        self._name = None
        self._params = None
        self._resources = None
        self._retries = None
        self._run_after = None
        self._task_ref = None
        self._task_spec = None
        self._timeout = None
        self._when = None
        self._workspaces = None
        self.discriminator = None

        if conditions is not None:
            self.conditions = conditions
        if name is not None:
            self.name = name
        if params is not None:
            self.params = params
        if resources is not None:
            self.resources = resources
        if retries is not None:
            self.retries = retries
        if run_after is not None:
            self.run_after = run_after
        if task_ref is not None:
            self.task_ref = task_ref
        if task_spec is not None:
            self.task_spec = task_spec
        if timeout is not None:
            self.timeout = timeout
        if when is not None:
            self.when = when
        if workspaces is not None:
            self.workspaces = workspaces

    @property
    def conditions(self):
        """Gets the conditions of this V1beta1PipelineTask.  # noqa: E501

        Conditions is a list of conditions that need to be true for the task to run Conditions are deprecated, use WhenExpressions instead  # noqa: E501

        :return: The conditions of this V1beta1PipelineTask.  # noqa: E501
        :rtype: list[V1beta1PipelineTaskCondition]
        """
        return self._conditions

    @conditions.setter
    def conditions(self, conditions):
        """Sets the conditions of this V1beta1PipelineTask.

        Conditions is a list of conditions that need to be true for the task to run Conditions are deprecated, use WhenExpressions instead  # noqa: E501

        :param conditions: The conditions of this V1beta1PipelineTask.  # noqa: E501
        :type: list[V1beta1PipelineTaskCondition]
        """

        self._conditions = conditions

    @property
    def name(self):
        """Gets the name of this V1beta1PipelineTask.  # noqa: E501

        Name is the name of this task within the context of a Pipeline. Name is used as a coordinate with the `from` and `runAfter` fields to establish the execution order of tasks relative to one another.  # noqa: E501

        :return: The name of this V1beta1PipelineTask.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this V1beta1PipelineTask.

        Name is the name of this task within the context of a Pipeline. Name is used as a coordinate with the `from` and `runAfter` fields to establish the execution order of tasks relative to one another.  # noqa: E501

        :param name: The name of this V1beta1PipelineTask.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def params(self):
        """Gets the params of this V1beta1PipelineTask.  # noqa: E501

        Parameters declares parameters passed to this task.  # noqa: E501

        :return: The params of this V1beta1PipelineTask.  # noqa: E501
        :rtype: list[V1beta1Param]
        """
        return self._params

    @params.setter
    def params(self, params):
        """Sets the params of this V1beta1PipelineTask.

        Parameters declares parameters passed to this task.  # noqa: E501

        :param params: The params of this V1beta1PipelineTask.  # noqa: E501
        :type: list[V1beta1Param]
        """

        self._params = params

    @property
    def resources(self):
        """Gets the resources of this V1beta1PipelineTask.  # noqa: E501


        :return: The resources of this V1beta1PipelineTask.  # noqa: E501
        :rtype: V1beta1PipelineTaskResources
        """
        return self._resources

    @resources.setter
    def resources(self, resources):
        """Sets the resources of this V1beta1PipelineTask.


        :param resources: The resources of this V1beta1PipelineTask.  # noqa: E501
        :type: V1beta1PipelineTaskResources
        """

        self._resources = resources

    @property
    def retries(self):
        """Gets the retries of this V1beta1PipelineTask.  # noqa: E501

        Retries represents how many times this task should be retried in case of task failure: ConditionSucceeded set to False  # noqa: E501

        :return: The retries of this V1beta1PipelineTask.  # noqa: E501
        :rtype: int
        """
        return self._retries

    @retries.setter
    def retries(self, retries):
        """Sets the retries of this V1beta1PipelineTask.

        Retries represents how many times this task should be retried in case of task failure: ConditionSucceeded set to False  # noqa: E501

        :param retries: The retries of this V1beta1PipelineTask.  # noqa: E501
        :type: int
        """

        self._retries = retries

    @property
    def run_after(self):
        """Gets the run_after of this V1beta1PipelineTask.  # noqa: E501

        RunAfter is the list of PipelineTask names that should be executed before this Task executes. (Used to force a specific ordering in graph execution.)  # noqa: E501

        :return: The run_after of this V1beta1PipelineTask.  # noqa: E501
        :rtype: list[str]
        """
        return self._run_after

    @run_after.setter
    def run_after(self, run_after):
        """Sets the run_after of this V1beta1PipelineTask.

        RunAfter is the list of PipelineTask names that should be executed before this Task executes. (Used to force a specific ordering in graph execution.)  # noqa: E501

        :param run_after: The run_after of this V1beta1PipelineTask.  # noqa: E501
        :type: list[str]
        """

        self._run_after = run_after

    @property
    def task_ref(self):
        """Gets the task_ref of this V1beta1PipelineTask.  # noqa: E501


        :return: The task_ref of this V1beta1PipelineTask.  # noqa: E501
        :rtype: V1beta1TaskRef
        """
        return self._task_ref

    @task_ref.setter
    def task_ref(self, task_ref):
        """Sets the task_ref of this V1beta1PipelineTask.


        :param task_ref: The task_ref of this V1beta1PipelineTask.  # noqa: E501
        :type: V1beta1TaskRef
        """

        self._task_ref = task_ref

    @property
    def task_spec(self):
        """Gets the task_spec of this V1beta1PipelineTask.  # noqa: E501


        :return: The task_spec of this V1beta1PipelineTask.  # noqa: E501
        :rtype: V1beta1EmbeddedTask
        """
        return self._task_spec

    @task_spec.setter
    def task_spec(self, task_spec):
        """Sets the task_spec of this V1beta1PipelineTask.


        :param task_spec: The task_spec of this V1beta1PipelineTask.  # noqa: E501
        :type: V1beta1EmbeddedTask
        """

        self._task_spec = task_spec

    @property
    def timeout(self):
        """Gets the timeout of this V1beta1PipelineTask.  # noqa: E501


        :return: The timeout of this V1beta1PipelineTask.  # noqa: E501
        :rtype: V1Duration
        """
        return self._timeout

    @timeout.setter
    def timeout(self, timeout):
        """Sets the timeout of this V1beta1PipelineTask.


        :param timeout: The timeout of this V1beta1PipelineTask.  # noqa: E501
        :type: V1Duration
        """

        self._timeout = timeout

    @property
    def when(self):
        """Gets the when of this V1beta1PipelineTask.  # noqa: E501

        WhenExpressions is a list of when expressions that need to be true for the task to run  # noqa: E501

        :return: The when of this V1beta1PipelineTask.  # noqa: E501
        :rtype: list[V1beta1WhenExpression]
        """
        return self._when

    @when.setter
    def when(self, when):
        """Sets the when of this V1beta1PipelineTask.

        WhenExpressions is a list of when expressions that need to be true for the task to run  # noqa: E501

        :param when: The when of this V1beta1PipelineTask.  # noqa: E501
        :type: list[V1beta1WhenExpression]
        """

        self._when = when

    @property
    def workspaces(self):
        """Gets the workspaces of this V1beta1PipelineTask.  # noqa: E501

        Workspaces maps workspaces from the pipeline spec to the workspaces declared in the Task.  # noqa: E501

        :return: The workspaces of this V1beta1PipelineTask.  # noqa: E501
        :rtype: list[V1beta1WorkspacePipelineTaskBinding]
        """
        return self._workspaces

    @workspaces.setter
    def workspaces(self, workspaces):
        """Sets the workspaces of this V1beta1PipelineTask.

        Workspaces maps workspaces from the pipeline spec to the workspaces declared in the Task.  # noqa: E501

        :param workspaces: The workspaces of this V1beta1PipelineTask.  # noqa: E501
        :type: list[V1beta1WorkspacePipelineTaskBinding]
        """

        self._workspaces = workspaces

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1beta1PipelineTask):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1beta1PipelineTask):
            return True

        return self.to_dict() != other.to_dict()
