"use strict";
/*
 * Copyright 2018-2022 Elyra Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeSnippetService = exports.CODE_SNIPPET_SCHEMA = exports.CODE_SNIPPET_SCHEMASPACE = void 0;
const services_1 = require("@elyra/services");
const apputils_1 = require("@jupyterlab/apputils");
exports.CODE_SNIPPET_SCHEMASPACE = 'code-snippets';
exports.CODE_SNIPPET_SCHEMA = 'code-snippet';
class CodeSnippetService {
    static findAll() {
        return __awaiter(this, void 0, void 0, function* () {
            return services_1.MetadataService.getMetadata(exports.CODE_SNIPPET_SCHEMASPACE);
        });
    }
    // TODO: Test this function
    static findByLanguage(language) {
        return __awaiter(this, void 0, void 0, function* () {
            try {
                const allCodeSnippets = yield this.findAll();
                const codeSnippetsByLanguage = [];
                for (const codeSnippet of allCodeSnippets) {
                    if (codeSnippet.metadata.language === language) {
                        codeSnippetsByLanguage.push(codeSnippet);
                    }
                }
                return codeSnippetsByLanguage;
            }
            catch (error) {
                return Promise.reject(error);
            }
        });
    }
    /**
     * Opens a dialog to confirm that the given code snippet
     * should be deleted, then sends a delete request to the metadata server.
     *
     * @param codeSnippet: code snippet to be deleted
     *
     * @returns A boolean promise that is true if the dialog confirmed
     * the deletion, and false if the deletion was cancelled.
     */
    static deleteCodeSnippet(codeSnippet) {
        return apputils_1.showDialog({
            title: `Delete snippet '${codeSnippet.display_name}'?`,
            buttons: [apputils_1.Dialog.cancelButton(), apputils_1.Dialog.okButton()]
        }).then((result) => {
            // Do nothing if the cancel button is pressed
            if (result.button.accept) {
                return services_1.MetadataService.deleteMetadata(exports.CODE_SNIPPET_SCHEMASPACE, codeSnippet.name).then(() => true);
            }
            else {
                return false;
            }
        });
    }
}
exports.CodeSnippetService = CodeSnippetService;
//# sourceMappingURL=CodeSnippetService.js.map