from __future__ import annotations

import typing as t

import numpy as np
from numpy.typing import NDArray

from .api import Params
from .api import Context

class AudioCapture:
    transcript: list[str]
    def __init__(self, length_ms: int) -> None: ...
    @t.overload
    def init_device(self) -> bool: ...
    @t.overload
    def init_device(self, device_id: int) -> bool: ...
    @t.overload
    def init_device(self, device_id: int, sample_rate: int) -> bool: ...
    @staticmethod
    def list_available_devices() -> list[int]: ...
    @t.overload
    def stream_transcribe(
        self, context: Context, params: Params
    ) -> t.Iterator[str]: ...
    @t.overload
    def stream_transcribe(
        self, context: Context, params: Params, step_ms: int = ...
    ) -> t.Iterator[str]: ...
    def resume(self) -> bool: ...
    def pause(self) -> bool: ...
    def clear(self) -> bool: ...
    def retrieve_audio(self, ms: int, audio: NDArray[np.float32]) -> None: ...
