# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['geostore',
 'geostore.check_files_checksums',
 'geostore.check_stac_metadata',
 'geostore.content_iterator',
 'geostore.dataset_versions',
 'geostore.datasets',
 'geostore.import_asset_file',
 'geostore.import_dataset',
 'geostore.import_metadata_file',
 'geostore.import_status',
 'geostore.notify_status_update',
 'geostore.populate_catalog',
 'geostore.update_dataset_catalog',
 'geostore.upload_status',
 'geostore.validation_summary']

package_data = \
{'': ['*'],
 'geostore.check_stac_metadata': ['geojson-spec/*',
                                  'projection/*',
                                  'projection/v1.0.0/*',
                                  'stac-spec/*',
                                  'stac-spec/dev/catalog-spec/json-schema/*',
                                  'stac-spec/dev/collection-spec/json-schema/*',
                                  'stac-spec/dev/item-spec/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/catalog-spec/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/collection-spec/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/checksum/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/collection-assets/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/datacube/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/eo/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/item-assets/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/label/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/pointcloud/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/projection/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/sar/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/sat/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/scientific/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/single-file-stac/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/tiled-assets/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/timestamps/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/version/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/extensions/view/json-schema/*',
                                  'stac-spec/v1.0.0-beta.2/item-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.1/catalog-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.1/collection-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.1/extensions/eo/json-schema/*',
                                  'stac-spec/v1.0.0-rc.1/extensions/projection/json-schema/*',
                                  'stac-spec/v1.0.0-rc.1/extensions/scientific/json-schema/*',
                                  'stac-spec/v1.0.0-rc.1/extensions/view/json-schema/*',
                                  'stac-spec/v1.0.0-rc.1/item-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.2/catalog-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.2/collection-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.2/item-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.3/catalog-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.3/collection-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.3/item-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.4/catalog-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.4/collection-spec/json-schema/*',
                                  'stac-spec/v1.0.0-rc.4/item-spec/json-schema/*',
                                  'stac-spec/v1.0.0/catalog-spec/json-schema/*',
                                  'stac-spec/v1.0.0/collection-spec/json-schema/*',
                                  'stac-spec/v1.0.0/item-spec/json-schema/*',
                                  'stac/*',
                                  'stac/v0.0.10/aerial-photo/*',
                                  'stac/v0.0.10/aerial-photo/examples/*',
                                  'stac/v0.0.10/aerial-photo/tests/*',
                                  'stac/v0.0.10/camera/*',
                                  'stac/v0.0.10/camera/examples/*',
                                  'stac/v0.0.10/camera/tests/*',
                                  'stac/v0.0.10/film/*',
                                  'stac/v0.0.10/film/examples/*',
                                  'stac/v0.0.10/film/tests/*',
                                  'stac/v0.0.10/historical-imagery/*',
                                  'stac/v0.0.10/historical-imagery/examples/*',
                                  'stac/v0.0.10/historical-imagery/tests/*',
                                  'stac/v0.0.10/linz/*',
                                  'stac/v0.0.10/linz/examples/*',
                                  'stac/v0.0.10/linz/tests/*',
                                  'stac/v0.0.10/quality/*',
                                  'stac/v0.0.10/quality/examples/*',
                                  'stac/v0.0.10/quality/tests/*',
                                  'stac/v0.0.10/scanning/*',
                                  'stac/v0.0.10/scanning/examples/*',
                                  'stac/v0.0.10/template/*',
                                  'stac/v0.0.10/template/examples/*',
                                  'stac/v0.0.10/template/tests/*',
                                  'stac/v0.0.2/camera/*',
                                  'stac/v0.0.2/camera/examples/*',
                                  'stac/v0.0.2/historical_imagery/*',
                                  'stac/v0.0.2/linz/*',
                                  'stac/v0.0.2/linz/examples/*',
                                  'stac/v0.0.2/quality/*',
                                  'stac/v0.0.2/quality/examples/*',
                                  'stac/v0.0.2/template/*',
                                  'stac/v0.0.2/template/examples/*',
                                  'stac/v0.0.3/camera/*',
                                  'stac/v0.0.3/camera/examples/*',
                                  'stac/v0.0.3/historical_imagery/*',
                                  'stac/v0.0.3/linz/*',
                                  'stac/v0.0.3/linz/examples/*',
                                  'stac/v0.0.3/quality/*',
                                  'stac/v0.0.3/quality/examples/*',
                                  'stac/v0.0.3/template/*',
                                  'stac/v0.0.3/template/examples/*',
                                  'stac/v0.0.4/camera/*',
                                  'stac/v0.0.4/camera/examples/*',
                                  'stac/v0.0.4/historical_imagery/*',
                                  'stac/v0.0.4/linz/*',
                                  'stac/v0.0.4/linz/examples/*',
                                  'stac/v0.0.4/quality/*',
                                  'stac/v0.0.4/quality/examples/*',
                                  'stac/v0.0.4/template/*',
                                  'stac/v0.0.4/template/examples/*',
                                  'stac/v0.0.5/aerial-photo/*',
                                  'stac/v0.0.5/aerial-photo/examples/*',
                                  'stac/v0.0.5/aerial-photo/non-examples/*',
                                  'stac/v0.0.5/camera/*',
                                  'stac/v0.0.5/camera/examples/*',
                                  'stac/v0.0.5/camera/non-examples/*',
                                  'stac/v0.0.5/film/*',
                                  'stac/v0.0.5/film/examples/*',
                                  'stac/v0.0.5/film/non-examples/*',
                                  'stac/v0.0.5/historical_imagery/*',
                                  'stac/v0.0.5/linz/*',
                                  'stac/v0.0.5/linz/examples/*',
                                  'stac/v0.0.5/linz/non-examples/*',
                                  'stac/v0.0.5/quality/*',
                                  'stac/v0.0.5/quality/examples/*',
                                  'stac/v0.0.5/quality/non-examples/*',
                                  'stac/v0.0.5/scanning/*',
                                  'stac/v0.0.5/scanning/examples/*',
                                  'stac/v0.0.5/template/*',
                                  'stac/v0.0.5/template/examples/*',
                                  'stac/v0.0.5/template/non-examples/*',
                                  'stac/v0.0.6/aerial-photo/*',
                                  'stac/v0.0.6/aerial-photo/examples/*',
                                  'stac/v0.0.6/aerial-photo/non-examples/*',
                                  'stac/v0.0.6/camera/*',
                                  'stac/v0.0.6/camera/examples/*',
                                  'stac/v0.0.6/camera/non-examples/*',
                                  'stac/v0.0.6/film/*',
                                  'stac/v0.0.6/film/examples/*',
                                  'stac/v0.0.6/film/non-examples/*',
                                  'stac/v0.0.6/historical_imagery/*',
                                  'stac/v0.0.6/linz/*',
                                  'stac/v0.0.6/linz/examples/*',
                                  'stac/v0.0.6/linz/non-examples/*',
                                  'stac/v0.0.6/quality/*',
                                  'stac/v0.0.6/quality/examples/*',
                                  'stac/v0.0.6/quality/non-examples/*',
                                  'stac/v0.0.6/scanning/*',
                                  'stac/v0.0.6/scanning/examples/*',
                                  'stac/v0.0.6/template/*',
                                  'stac/v0.0.6/template/examples/*',
                                  'stac/v0.0.6/template/non-examples/*',
                                  'stac/v0.0.7/aerial-photo/*',
                                  'stac/v0.0.7/aerial-photo/examples/*',
                                  'stac/v0.0.7/aerial-photo/non-examples/*',
                                  'stac/v0.0.7/camera/*',
                                  'stac/v0.0.7/camera/examples/*',
                                  'stac/v0.0.7/camera/tests/*',
                                  'stac/v0.0.7/film/*',
                                  'stac/v0.0.7/film/examples/*',
                                  'stac/v0.0.7/film/non-examples/*',
                                  'stac/v0.0.7/historical_imagery/*',
                                  'stac/v0.0.7/linz/*',
                                  'stac/v0.0.7/linz/examples/*',
                                  'stac/v0.0.7/linz/non-examples/*',
                                  'stac/v0.0.7/quality/*',
                                  'stac/v0.0.7/quality/examples/*',
                                  'stac/v0.0.7/quality/non-examples/*',
                                  'stac/v0.0.7/scanning/*',
                                  'stac/v0.0.7/scanning/examples/*',
                                  'stac/v0.0.7/template/*',
                                  'stac/v0.0.7/template/examples/*',
                                  'stac/v0.0.7/template/non-examples/*',
                                  'stac/v0.0.8/*',
                                  'stac/v0.0.8/aerial-photo/*',
                                  'stac/v0.0.8/aerial-photo/examples/*',
                                  'stac/v0.0.8/aerial-photo/tests/*',
                                  'stac/v0.0.8/camera/*',
                                  'stac/v0.0.8/camera/examples/*',
                                  'stac/v0.0.8/camera/tests/*',
                                  'stac/v0.0.8/film/*',
                                  'stac/v0.0.8/film/examples/*',
                                  'stac/v0.0.8/film/tests/*',
                                  'stac/v0.0.8/historical-imagery/*',
                                  'stac/v0.0.8/linz/*',
                                  'stac/v0.0.8/linz/examples/*',
                                  'stac/v0.0.8/linz/tests/*',
                                  'stac/v0.0.8/quality/*',
                                  'stac/v0.0.8/quality/examples/*',
                                  'stac/v0.0.8/quality/tests/*',
                                  'stac/v0.0.8/scanning/*',
                                  'stac/v0.0.8/scanning/examples/*',
                                  'stac/v0.0.8/template/*',
                                  'stac/v0.0.8/template/examples/*',
                                  'stac/v0.0.8/template/tests/*',
                                  'stac/v0.0.9/*',
                                  'stac/v0.0.9/aerial-photo/*',
                                  'stac/v0.0.9/aerial-photo/examples/*',
                                  'stac/v0.0.9/aerial-photo/tests/*',
                                  'stac/v0.0.9/camera/*',
                                  'stac/v0.0.9/camera/examples/*',
                                  'stac/v0.0.9/camera/tests/*',
                                  'stac/v0.0.9/film/*',
                                  'stac/v0.0.9/film/examples/*',
                                  'stac/v0.0.9/film/tests/*',
                                  'stac/v0.0.9/historical-imagery/*',
                                  'stac/v0.0.9/linz/*',
                                  'stac/v0.0.9/linz/examples/*',
                                  'stac/v0.0.9/linz/tests/*',
                                  'stac/v0.0.9/quality/*',
                                  'stac/v0.0.9/quality/examples/*',
                                  'stac/v0.0.9/quality/tests/*',
                                  'stac/v0.0.9/scanning/*',
                                  'stac/v0.0.9/scanning/examples/*',
                                  'stac/v0.0.9/template/*',
                                  'stac/v0.0.9/template/examples/*',
                                  'stac/v0.0.9/template/tests/*',
                                  'version/*',
                                  'version/v1.0.0/*']}

install_requires = \
['boto3', 'typer']

extras_require = \
{'cdk': ['aws-cdk.aws-dynamodb',
         'aws-cdk.aws-ec2',
         'aws-cdk.aws-ecr',
         'aws-cdk.aws-ecr_assets',
         'aws-cdk.aws-ecs',
         'aws-cdk.aws-events',
         'aws-cdk.aws-events-targets',
         'aws-cdk.aws-iam',
         'aws-cdk.aws-lambda',
         'aws-cdk.aws-lambda-event-sources',
         'aws-cdk.aws-lambda-python',
         'aws-cdk.aws-s3',
         'aws-cdk.aws-sns',
         'aws-cdk.aws-stepfunctions',
         'aws-cdk.aws-stepfunctions_tasks',
         'awscli',
         'cattrs'],
 'check_files_checksums': ['multihash', 'pynamodb', 'linz-logger'],
 'check_stac_metadata': ['jsonschema[format]',
                         'pynamodb',
                         'strict-rfc3339',
                         'linz-logger'],
 'content_iterator': ['jsonschema[format]', 'pynamodb', 'linz-logger'],
 'dataset_versions': ['jsonschema[format]',
                      'pynamodb',
                      'ulid-py',
                      'linz-logger'],
 'datasets': ['jsonschema[format]',
              'pynamodb',
              'pystac',
              'ulid-py',
              'linz-logger'],
 'import_asset_file': ['smart-open[s3]', 'linz-logger'],
 'import_dataset': ['jsonschema[format]',
                    'pynamodb',
                    'smart-open[s3]',
                    'ulid-py',
                    'linz-logger'],
 'import_metadata_file': ['linz-logger'],
 'import_status': ['jsonschema[format]', 'pynamodb', 'linz-logger'],
 'notify_status_update': ['jsonschema[format]',
                          'pynamodb',
                          'slack-sdk[webhook,models]',
                          'linz-logger'],
 'populate_catalog': ['jsonschema[format]', 'pystac', 'linz-logger'],
 'update_dataset_catalog': ['jsonschema[format]',
                            'pynamodb',
                            'ulid-py',
                            'linz-logger'],
 'upload_status': ['jsonschema[format]', 'pynamodb', 'linz-logger'],
 'validation_summary': ['jsonschema[format]', 'pynamodb', 'linz-logger']}

entry_points = \
{'console_scripts': ['geostore = geostore.cli:app']}

setup_kwargs = {
    'name': 'geostore',
    'version': '0.1.5',
    'description': 'Central storage, management and access for important geospatial datasets developed by LINZ',
    'long_description': '# Geostore\n\n[![Deploy](https://github.com/linz/geostore/actions/workflows/deploy.yml/badge.svg)](https://github.com/linz/geostore/actions/workflows/deploy.yml)\n[![Total alerts](https://img.shields.io/lgtm/alerts/g/linz/geostore.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/linz/geostore/alerts/)\n[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/linz/geostore.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/linz/geostore/context:python)\n[![CodeQL Analysis](https://github.com/linz/geostore/actions/workflows/codeql-analysis.yml/badge.svg)](https://github.com/linz/geostore/actions/workflows/codeql-analysis.yml)\n[![Code style: black](https://img.shields.io/badge/code%20style-black-000000.svg)](https://github.com/psf/black)\n[![Coverage: 100% branches](https://img.shields.io/badge/Coverage-100%25%20branches-brightgreen.svg)](https://pytest.org/)\n[![Dependabot Status](https://badgen.net/badge/Dependabot/enabled?labelColor=2e3a44&color=blue)](https://github.com/linz/geostore/network/updates)\n[![hadolint: passing](https://img.shields.io/badge/hadolint-passing-brightgreen)](https://github.com/hadolint/hadolint)\n[![Imports: isort](https://img.shields.io/badge/%20imports-isort-%231674b1?style=flat&labelColor=ef8336)](https://pycqa.github.io/isort/)\n[![Kodiak](https://badgen.net/badge/Kodiak/enabled?labelColor=2e3a44&color=F39938)](https://kodiakhq.com/)\n[![Checked with mypy](http://www.mypy-lang.org/static/mypy_badge.svg)](http://mypy-lang.org/)\n[![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg)](https://github.com/prettier/prettier)\n[![pylint: passing](https://img.shields.io/badge/pylint-passing-brightgreen)](https://www.pylint.org/)\n[![Python: 3.8](https://img.shields.io/badge/Python-3.8-blue)](https://www.python.org/)\n[![shellcheck: passing](https://img.shields.io/badge/shellcheck-passing-brightgreen)](https://www.shellcheck.net/)\n[![Conventional Commits](https://img.shields.io/badge/Conventional%20Commits-1.0.0-yellow.svg)](https://conventionalcommits.org)\n\nLINZ central storage, management and access solution for important geospatial datasets. Developed by\n[Land Information New Zealand](https://github.com/linz).\n\n## Prerequisites\n\n### Geostore VPC\n\nA Geostore VPC must exist in your AWS account before deploying this application. AT LINZ, VPCs are\nmanaged internally by the IT team. If you are deploying this application outside LINZ, you will need\nto create a VPC with the following tags:\n\n- "ApplicationName": "geostore"\n- "ApplicationLayer": "networking"\n\nYou can achieve this by adding the `networking_stack` (`infrastructure/networking_stack.py)` into\n`app.py` before deployment as a dependency of `application_stack`\n(`infrastructure/application_stack.py`).\n\n### Verify infrastructure settings\n\nThis infrastructure by default includes some Toitū Te Whenua-/LINZ-specific parts, controlled by\nsettings in cdk.json. To disable these, simply remove the context entries or set them to `false`.\nThe settings are:\n\n- `enableLDSAccess`: if true, gives LINZ Data Service/Koordinates read access to the storage bucket.\n- `enableOpenTopographyAccess`: if true, gives OpenTopography read access to the storage bucket.\n\n## Development setup\n\nOne-time setup which generally assumes that you\'re in the project directory.\n\n### Common\n\n1. [Install Docker](https://docs.docker.com/engine/install/ubuntu/)\n2. Configure Docker:\n   1. Add yourself to the "docker" group: `sudo usermod --append --groups=docker "$USER"`\n   2. Log out and back in to enable the new group\n\n### Ubuntu\n\n1. Install [`nvm`](https://github.com/nvm-sh/nvm#installing-and-updating):\n   ```bash\n   cd "$(mktemp --directory)"\n   wget https://raw.githubusercontent.com/nvm-sh/nvm/master/install.sh\n   echo \'b674516f001d331c517be63c1baeaf71de6cbb6d68a44112bf2cff39a6bc246a install.sh\' | sha256sum --check && bash install.sh\n   ```\n2. Install [Poetry](https://python-poetry.org/docs/master/#installation):\n   ```bash\n   cd "$(mktemp --directory)"\n   wget https://raw.githubusercontent.com/python-poetry/poetry/master/install-poetry.py\n   echo \'b35d059be6f343ac1f05ae56e8eaaaebb34da8c92424ee00133821d7f11e3a9c install-poetry.py\' | sha256sum --check && python3 install-poetry.py\n   ```\n3. Install [Pyenv](https://github.com/pyenv/pyenv#installation):\n   ```bash\n   sudo apt-get update\n   sudo apt-get install --no-install-recommends build-essential curl libbz2-dev libffi-dev liblzma-dev libncurses5-dev libreadline-dev libsqlite3-dev libssl-dev libxml2-dev libxmlsec1-dev llvm make tk-dev wget xz-utils zlib1g-dev\n   cd "$(mktemp --directory)"\n   wget https://github.com/pyenv/pyenv-installer/raw/master/bin/pyenv-installer\n   echo \'3aa49f2b3b77556272a80a01fe44d46733f4862dbbbc956002dc944c428bebd8 pyenv-installer\' | sha256sum --check && bash pyenv-installer\n   ```\n4. Enable the above by adding the following to your `~/.bashrc`:\n\n   ```bash\n   if [[ -e "${HOME}/.local/bin" ]]\n   then\n       PATH="${HOME}/.local/bin:${PATH}"\n   fi\n\n   # nvm <https://github.com/nvm-sh/nvm>\n   if [[ -d "${HOME}/.nvm" ]]\n   then\n       export NVM_DIR="${HOME}/.nvm"\n       # shellcheck source=/dev/null\n       [[ -s "${NVM_DIR}/nvm.sh" ]] && . "${NVM_DIR}/nvm.sh"\n       # shellcheck source=/dev/null\n       [[ -s "${NVM_DIR}/bash_completion" ]] && . "${NVM_DIR}/bash_completion"\n   fi\n\n   # Pyenv <https://github.com/pyenv/pyenv>\n   if [[ -e "${HOME}/.pyenv" ]]\n   then\n       PATH="${HOME}/.pyenv/bin:${PATH}"\n       eval "$(pyenv init --path)"\n       eval "$(pyenv init -)"\n       eval "$(pyenv virtualenv-init -)"\n   fi\n   ```\n\n5. Configure Docker:\n   1. Add yourself to the "docker" group: `sudo usermod --append --groups=docker "$USER"`\n   1. Log out and back in to enable the new group\n6. [Install project Node.js](https://github.com/nvm-sh/nvm#long-term-support): `nvm install`\n7. Run `./reset-dev-env.bash --all` to install packages.\n8. Enable the dev environment: `. activate-dev-env.bash`.\n9. Optional: Enable [Dependabot alerts by email](https://github.com/settings/notifications). (This\n   is optional since it currently can\'t be set per repository or organisation, so it affects any\n   repos where you have access to Dependabot alerts.)\n10. Install [`aws-azure-login`](https://github.com/sportradar/aws-azure-login#installation).\n\nRe-run `./reset-dev-env.bash` when packages change. One easy way to use it pretty much seamlessly is\nto run it before every workday, with a crontab entry like this template:\n\n```crontab\nHOME=\'/home/USERNAME\'\n0 2 * * 1-5 export PATH="${HOME}/.pyenv/shims:${HOME}/.pyenv/bin:${HOME}/.poetry/bin:/root/bin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin:/run/current-system/sw/bin" && cd "PATH_TO_GEOSTORE" && ./reset-dev-env.bash --all\n```\n\nReplace `USERNAME` and `PATH_TO_GEOSTORE` with your values, resulting in something like this:\n\n```crontab\nHOME=\'/home/jdoe\'\n0 2 * * 1-5 export PATH="${HOME}/.pyenv/shims:${HOME}/.pyenv/bin:${HOME}/.poetry/bin:/root/bin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin:/run/current-system/sw/bin" && cd "${HOME}/dev/geostore" && ./reset-dev-env.bash --all\n```\n\nRe-run `. activate-dev-env.bash` in each shell.\n\n### Nix\n\n1. Run `nix-shell`.\n1. Optional: Install and [configure](https://direnv.net/docs/hook.html) `direnv` and\n   `direnv allow .` to load the Nix shell whenever you `cd` into the project.\n\nRestart your `nix-shell` when packages change.\n\nWhen setting up the project SDK point it to `.run/python`, which is a symlink to the latest Nix\nshell Python executable.\n\n### Optional\n\nEnable [Dependabot alerts by email](https://github.com/settings/notifications). (This is optional\nsince it currently can\'t be set per repository or organisation, so it affects any repos where you\nhave access to Dependabot alerts.)\n\n## AWS Infrastructure deployment\n\n1. [Configure AWS](https://confluence.linz.govt.nz/display/GEOD/Login+to+AWS+Service+Accounts+via+Azure+in+Command+Line)\n1. Get AWS credentials (see: https://www.npmjs.com/package/aws-azure-login) for 12 hours:\n\n   ```bash\n   aws-azure-login --no-prompt --profile=<AWS-PROFILE-NAME>\n   ```\n\n1. Environment variables\n\n   - **`GEOSTORE_ENV_NAME`:** set deployment environment. For your personal development stack: set\n     GEOSTORE_ENV_NAME to your username.\n\n     ```bash\n     export GEOSTORE_ENV_NAME="$USER"\n     ```\n\n     Other values used by CI pipelines include: prod, nonprod, ci, dev or any string without spaces.\n     Default: test.\n\n   * **`RESOURCE_REMOVAL_POLICY`:** determines if resources containing user content like Geostore\n     Storage S3 bucket or application database tables will be preserved even if they are removed\n     from stack or stack is deleted. Supported values:\n     - DESTROY: destroy resource when removed from stack or stack is deleted (default)\n     - RETAIN: retain orphaned resource when removed from stack or stack is deleted\n\n   - **`GEOSTORE_SAML_IDENTITY_PROVIDER_ARN`:** SAML identity provider AWS ARN.\n\n1. Bootstrap CDK (only once per profile)\n\n   ```bash\n   cdk --profile=<AWS-PROFILE-NAME> bootstrap aws://unknown-account/ap-southeast-2\n   ```\n\n1. Deploy CDK stack\n\n   ```bash\n   cdk --profile=<AWS-PROFILE-NAME> deploy --all\n   ```\n\n   Once comfortable with CDK you can add `--require-approval=never` above to deploy\n   non-interactively.\n\nIf you `export AWS_PROFILE=<AWS-PROFILE-NAME>` you won\'t need the `--profile=<AWS-PROFILE-NAME>`\narguments above.\n\n## Development\n\n### Adding or updating Python dependencies\n\nTo add a development-only package: `poetry add --dev PACKAGE=\'*\'`\n\nTo add a production package:\n\n1. Install the package using `poetry add --optional PACKAGE=\'*\'`.\n1. Put the package in alphabetical order within the list.\n1. Mention the package in the relevant lists in `[tool.poetry.extras]`.\n\n- Make sure to update packages separately from adding packages. Basically, follow this process\n  before running `poetry add`, and do the equivalent when updating Node.js packages or changing\n  Docker base images:\n\n  1.  Check out a new branch on top of origin/master:\n      `git checkout -b update-python-packages origin/master`.\n  1.  Update the Python packages: `poetry update`. The rest of the steps are only necessary if this\n      step changes poetry.lock. Otherwise you can just change back to the original branch and delete\n      "update-python-packages".\n  1.  Commit, push and create pull request.\n  1.  Check out the branch where you originally wanted to run `poetry add`.\n  1.  Rebase the branch onto the package update branch: `git rebase update-python-packages`.\n\n  At this point any `poetry add` commands should not result in any package updates other than those\n  necessary to fulfil the new packages\' dependencies.\n\n  Rationale: Keeping upgrades and other packages changes apart is useful when reading/bisecting\n  history. It also makes code review easier.\n\n- When there\'s a merge conflict in poetry.lock, first check whether either or both commits contain a\n  package upgrade:\n\n  - If neither of them do, simply `git checkout --ours -- poetry.lock && poetry lock --no-update`.\n  - If one of them does, check out that file (`git checkout --ours -- poetry.lock` or\n    `git checkout --theirs -- poetry.lock`) and run `poetry lock --no-update` to regenerate\n    `poetry.lock` with the current package versions.\n  - If both of them do, manually merge `poetry.lock` and run `poetry lock --no-update`.\n\n  Rationale: This should avoid accidentally down- or upgrading when resolving a merge conflict.\n\n- Update the code coverage minimum in pyproject.toml and the badge above on branches which increase\n  it.\n\n  Rationale: By updating this continuously we avoid missing test regressions in new branches.\n\n### Upgrading Python version\n\nTo minimise the chance of discrepancies between environments it is important to run the same (or as\nclose as possible) version of Python in the development environment, in the pipeline, and in\ndeployed instances. At the moment the available versions are constrained by the following:\n\n- The\n  [Ubuntu packages](https://packages.ubuntu.com/search?keywords=python3&searchon=names&exact=1&suite=all&section=all)\n  used in the [Dockerfile](/linz/geostore/blob/master/geostore/Dockerfile)\n- The [AWS base images](https://docs.aws.amazon.com/lambda/latest/dg/python-image.html) used as\n  [Lambda runtimes](/linz/geostore/blob/master/infrastructure/constructs/lambda_config.py)\n- The [pyenv versions](https://github.com/pyenv/pyenv) used for\n  [local development](/linz/geostore/blob/master/.python-version)\n- The [supported Poetry versions](https://python-poetry.org/docs/#system-requirements) used for all\n  [dependencies](/linz/geostore/blob/master/pyproject.toml)\n\nWhen updating Python versions you have to check that all of the above can be kept at the same minor\nversion, and ideally at the same patch level.\n\n### Running tests\n\nPrerequisites:\n\n- Authenticated to a profile which has access to a deployed Geostore.\n\nTo launch full test suite, run `pytest`.\n\n### Debugging\n\nTo start debugging at a specific line, insert `import ipdb; ipdb.set_trace()`.\n\nTo debug a test run, add `--capture=no` to the `pytest` arguments. You can also automatically start\ndebugging at a test failure point with `--pdb --pdbcls=IPython.terminal.debugger:Pdb`.\n\n### Upgrading CI runner\n\n[`jobs.<job_id>.runs-on`](https://docs.github.com/en/free-pro-team@latest/actions/reference/workflow-syntax-for-github-actions#jobsjob_idruns-on)\nin .github sets the runner type per job. We should make sure all of these use the latest specific\n("ubuntu-YY.MM" as opposed to "ubuntu-latest") Ubuntu LTS version, to make sure the version changes\nonly when we\'re ready for it.\n\n### GitHub Actions cache clearing\n\nTo throw away the current cache (for example in case of a cache corruption), simply change the\n[`CACHE_SEED` repository "secret"](https://github.com/linz/geostore/settings/secrets/actions/CACHE_SEED),\nfor example to the current timestamp (`date +%s`). Subsequent jobs will then ignore the existing\ncache.\n',
    'author': 'Bill M. Nelson',
    'author_email': 'bmnelson@linz.govt.nz',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/linz/geostore',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
