from typing import List, NoReturn

from onepm.base import PackageManager


class Pipenv(PackageManager):
    name = "pipenv"

    def get_command(self) -> List[str]:
        return [self.find_executable(self.name)]

    def install(self, args: List[str]) -> NoReturn:
        self.execute_command(["install"] + list(args))

    def uninstall(self, args: List[str]) -> NoReturn:
        self.execute_command(["uninstall"] + list(args))

    def update(self, args: List[str]) -> NoReturn:
        self.execute_command(["update"] + list(args))

    def run(self, args: List[str]) -> NoReturn:
        self.execute_command(["run"] + list(args))
