# 
# !!! Load script generated by nmk-base plugin, don't edit !!!
#

__checkSysDeps() {
    local cmd="${1}"
    local packages="${2}"
    local url="${3}"
    
    # Command found?
    echo -n "Check ${cmd} "
    if test -z "$(which "${cmd}" 2>/dev/null || true)"; then
        echo "[missing]"
        if test -n "${packages}"; then
            # APT mode
            NMK_APT_DEPS="${NMK_APT_DEPS} ${packages}"
        else
            # URL mode
            echo "Please install from ${url}"
            MISSING_DEPS=1
        fi
    else
        echo "[OK]"
    fi
}
__installSysDeps() {
    # Something to install?
    if test -n "${NMK_APT_DEPS}"; then
        # Yes!
        echo "Installing missing packages:${NMK_APT_DEPS}"
        local sudo_prefix=""
        local install_suffix="-y"
        if test "$(id -u)" != "0"; then
            sudo_prefix="sudo "
            install_suffix=""
        fi
        
        # Repo refresh
        cmd="${sudo_prefix}apt update"
        echo "> ${cmd}"
        ${cmd} || return $?

        # Install
        cmd="${sudo_prefix}apt install${NMK_APT_DEPS} ${install_suffix}"
        unset NMK_APT_DEPS
        echo "> ${cmd}"
        ${cmd} || return $?
    fi
}

# Test for git-bash mode
if test -f /git-bash.exe; then
    # Windows-style venv
    IS_GIT_BASH=1
    VENV_DIR={{ venvName }}/Scripts
    PYTHON_EXE=python
else
    # Linux-style venv
    VENV_DIR={{ venvName }}/bin
    PYTHON_EXE={{ pythonForVenv }}
fi

# Create venv if not done yet
if test ! -f {{ venvName }}/venvOK; then
    # Check system dependencies
    if test -n "${IS_GIT_BASH}"; then
        # git-bash mode
        MISSING_DEPS=0
        {% for cmd in urlDeps.keys() %}__checkSysDeps {{ cmd }} "" "{{ urlDeps[cmd] }}"
        {% endfor %}
        # Stop if something is missing
        if test ${MISSING_DEPS} -ne 0; then
            return 1
        fi
    else
        # Linux mode
        {% for cmd in aptDeps.keys() %}__checkSysDeps {{ cmd }} "{{ aptDeps[cmd] }}"
        {% endfor %}
        # Perform installs if needed
        __installSysDeps || return $?
    fi

    # Create venv
    echo Create venv...
    rm -Rf {{ venvName }}
    ${PYTHON_EXE} -m venv {{ venvName }}

    # Load it
    source ${VENV_DIR}/activate
    
    # Bootstrap it
    python -m pip install pip wheel --upgrade

    # Install requirements (if present)
    if test -f "{{ venvRequirements }}"; then
        pip install -r {{ venvRequirements }} {{ venvPipArgs }}
    else
        # Default: only install nmk
        pip install nmk
    fi

    # Patch it for nmk completion
    echo ' ' >> ${VENV_DIR}/activate
    if test -n "${IS_GIT_BASH}"; then
        # On git bash, handle completion through temporary files rather than descriptors
        # see https://github.com/kislyuk/argcomplete#git-bash-support
        echo 'export ARGCOMPLETE_USE_TEMPFILES=1' >> ${VENV_DIR}/activate
    fi
    echo 'eval "$(register-python-argcomplete nmk)"' >> ${VENV_DIR}/activate

    # Done, mark venv as "ready"
    touch {{ venvName }}/venvOK
fi

# Finally load venv
source ${VENV_DIR}/activate

# Clean useless stuff from terminal context
unset __checkSysDeps
unset __installSysDeps
unset VENV_DIR
unset PYTHON_EXE
unset IS_GIT_BASH
unset MISSING_DEPS

# Run command specified as parameter, if any
"$@"

