# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMetricResult',
    'AwaitableGetMetricResult',
    'get_metric',
    'get_metric_output',
]

@pulumi.output_type
class GetMetricResult:
    """
    A collection of values returned by getMetric.
    """
    def __init__(__self__, description=None, event_key=None, id=None, is_active=None, is_numeric=None, key=None, kind=None, maintainer_id=None, name=None, project_key=None, selector=None, success_criteria=None, tags=None, unit=None, urls=None):
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if event_key and not isinstance(event_key, str):
            raise TypeError("Expected argument 'event_key' to be a str")
        pulumi.set(__self__, "event_key", event_key)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_active and not isinstance(is_active, bool):
            raise TypeError("Expected argument 'is_active' to be a bool")
        pulumi.set(__self__, "is_active", is_active)
        if is_numeric and not isinstance(is_numeric, bool):
            raise TypeError("Expected argument 'is_numeric' to be a bool")
        pulumi.set(__self__, "is_numeric", is_numeric)
        if key and not isinstance(key, str):
            raise TypeError("Expected argument 'key' to be a str")
        pulumi.set(__self__, "key", key)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if maintainer_id and not isinstance(maintainer_id, str):
            raise TypeError("Expected argument 'maintainer_id' to be a str")
        pulumi.set(__self__, "maintainer_id", maintainer_id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if project_key and not isinstance(project_key, str):
            raise TypeError("Expected argument 'project_key' to be a str")
        pulumi.set(__self__, "project_key", project_key)
        if selector and not isinstance(selector, str):
            raise TypeError("Expected argument 'selector' to be a str")
        pulumi.set(__self__, "selector", selector)
        if success_criteria and not isinstance(success_criteria, str):
            raise TypeError("Expected argument 'success_criteria' to be a str")
        pulumi.set(__self__, "success_criteria", success_criteria)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if unit and not isinstance(unit, str):
            raise TypeError("Expected argument 'unit' to be a str")
        pulumi.set(__self__, "unit", unit)
        if urls and not isinstance(urls, list):
            raise TypeError("Expected argument 'urls' to be a list")
        pulumi.set(__self__, "urls", urls)

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        The description of the metric's purpose.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eventKey")
    def event_key(self) -> Optional[str]:
        """
        The event key to watch for `custom` metrics.
        """
        return pulumi.get(self, "event_key")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isActive")
    def is_active(self) -> Optional[bool]:
        return pulumi.get(self, "is_active")

    @property
    @pulumi.getter(name="isNumeric")
    def is_numeric(self) -> Optional[bool]:
        return pulumi.get(self, "is_numeric")

    @property
    @pulumi.getter
    def key(self) -> str:
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def kind(self) -> Optional[str]:
        """
        The metric type. Available choices are `click`, `custom`, and `pageview`.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="maintainerId")
    def maintainer_id(self) -> str:
        return pulumi.get(self, "maintainer_id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the metric.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectKey")
    def project_key(self) -> str:
        """
        The metrics's project key.
        """
        return pulumi.get(self, "project_key")

    @property
    @pulumi.getter
    def selector(self) -> Optional[str]:
        """
        The CSS selector for `click` metrics.
        """
        return pulumi.get(self, "selector")

    @property
    @pulumi.getter(name="successCriteria")
    def success_criteria(self) -> Optional[str]:
        """
        The success criteria for numeric `custom` metrics.
        """
        return pulumi.get(self, "success_criteria")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence[str]]:
        """
        Set of tags associated with the metric.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def unit(self) -> Optional[str]:
        """
        The unit for numeric `custom` metrics.
        """
        return pulumi.get(self, "unit")

    @property
    @pulumi.getter
    def urls(self) -> Optional[Sequence['outputs.GetMetricUrlResult']]:
        """
        Which URLs the metric watches.
        """
        return pulumi.get(self, "urls")


class AwaitableGetMetricResult(GetMetricResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMetricResult(
            description=self.description,
            event_key=self.event_key,
            id=self.id,
            is_active=self.is_active,
            is_numeric=self.is_numeric,
            key=self.key,
            kind=self.kind,
            maintainer_id=self.maintainer_id,
            name=self.name,
            project_key=self.project_key,
            selector=self.selector,
            success_criteria=self.success_criteria,
            tags=self.tags,
            unit=self.unit,
            urls=self.urls)


def get_metric(description: Optional[str] = None,
               event_key: Optional[str] = None,
               is_active: Optional[bool] = None,
               is_numeric: Optional[bool] = None,
               key: Optional[str] = None,
               kind: Optional[str] = None,
               maintainer_id: Optional[str] = None,
               name: Optional[str] = None,
               project_key: Optional[str] = None,
               selector: Optional[str] = None,
               success_criteria: Optional[str] = None,
               tags: Optional[Sequence[str]] = None,
               unit: Optional[str] = None,
               urls: Optional[Sequence[pulumi.InputType['GetMetricUrlArgs']]] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMetricResult:
    """
    Provides a LaunchDarkly metric data source.

    This data source allows you to retrieve metric information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_metric(key="example-metric",
        project_key="example-project")
    ```


    :param str description: The description of the metric's purpose.
    :param str event_key: The event key to watch for `custom` metrics.
    :param str key: The metric's unique key.
    :param str kind: The metric type. Available choices are `click`, `custom`, and `pageview`.
    :param str name: The name of the metric.
    :param str project_key: The metric's project key.
    :param str selector: The CSS selector for `click` metrics.
    :param str success_criteria: The success criteria for numeric `custom` metrics.
    :param Sequence[str] tags: Set of tags associated with the metric.
    :param str unit: The unit for numeric `custom` metrics.
    :param Sequence[pulumi.InputType['GetMetricUrlArgs']] urls: Which URLs the metric watches.
    """
    __args__ = dict()
    __args__['description'] = description
    __args__['eventKey'] = event_key
    __args__['isActive'] = is_active
    __args__['isNumeric'] = is_numeric
    __args__['key'] = key
    __args__['kind'] = kind
    __args__['maintainerId'] = maintainer_id
    __args__['name'] = name
    __args__['projectKey'] = project_key
    __args__['selector'] = selector
    __args__['successCriteria'] = success_criteria
    __args__['tags'] = tags
    __args__['unit'] = unit
    __args__['urls'] = urls
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('launchdarkly:index/getMetric:getMetric', __args__, opts=opts, typ=GetMetricResult).value

    return AwaitableGetMetricResult(
        description=__ret__.description,
        event_key=__ret__.event_key,
        id=__ret__.id,
        is_active=__ret__.is_active,
        is_numeric=__ret__.is_numeric,
        key=__ret__.key,
        kind=__ret__.kind,
        maintainer_id=__ret__.maintainer_id,
        name=__ret__.name,
        project_key=__ret__.project_key,
        selector=__ret__.selector,
        success_criteria=__ret__.success_criteria,
        tags=__ret__.tags,
        unit=__ret__.unit,
        urls=__ret__.urls)


@_utilities.lift_output_func(get_metric)
def get_metric_output(description: Optional[pulumi.Input[Optional[str]]] = None,
                      event_key: Optional[pulumi.Input[Optional[str]]] = None,
                      is_active: Optional[pulumi.Input[Optional[bool]]] = None,
                      is_numeric: Optional[pulumi.Input[Optional[bool]]] = None,
                      key: Optional[pulumi.Input[str]] = None,
                      kind: Optional[pulumi.Input[Optional[str]]] = None,
                      maintainer_id: Optional[pulumi.Input[Optional[str]]] = None,
                      name: Optional[pulumi.Input[Optional[str]]] = None,
                      project_key: Optional[pulumi.Input[str]] = None,
                      selector: Optional[pulumi.Input[Optional[str]]] = None,
                      success_criteria: Optional[pulumi.Input[Optional[str]]] = None,
                      tags: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                      unit: Optional[pulumi.Input[Optional[str]]] = None,
                      urls: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMetricUrlArgs']]]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMetricResult]:
    """
    Provides a LaunchDarkly metric data source.

    This data source allows you to retrieve metric information from your LaunchDarkly organization.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_launchdarkly as launchdarkly

    example = launchdarkly.get_metric(key="example-metric",
        project_key="example-project")
    ```


    :param str description: The description of the metric's purpose.
    :param str event_key: The event key to watch for `custom` metrics.
    :param str key: The metric's unique key.
    :param str kind: The metric type. Available choices are `click`, `custom`, and `pageview`.
    :param str name: The name of the metric.
    :param str project_key: The metric's project key.
    :param str selector: The CSS selector for `click` metrics.
    :param str success_criteria: The success criteria for numeric `custom` metrics.
    :param Sequence[str] tags: Set of tags associated with the metric.
    :param str unit: The unit for numeric `custom` metrics.
    :param Sequence[pulumi.InputType['GetMetricUrlArgs']] urls: Which URLs the metric watches.
    """
    ...
