# SCOSpy

SCOSpy is a python library for the Satellite Control and Operation System 2000 (SCOS-2000) header written as hexadecimal string.

Current version is 0.2.2

## Library Installation
```bash
$ pip install SCOSpy
```
## Usage

``` python
from SCOS.SCOS import *
a = SCOS(packet)
```
where *packet* is the hexadecimal string rapresentation of the Telemetry packet.

## Limitation
at the moment the software works only for Telemetry and Telecommand packets (Packet Types 1 and 2) for the BepiColombo ESA Mission. In the next versions other missions will be implemented.

## Data Structure

The SCOS object contain:

* **Common Packet Header Structure (CPH)**

and one of the following sub-object:

* **Telemetry Packet Header (TMPH)**
* **Telecommand Packet Header (TCPH)**
* **Event Packet Header (EPH)**

### Common Packet Header Structure (CHP)


In the CHP are present the following fields.

<table>
<tr><th>Field</th><th>Description</th></tr>
<tr><th> CTree </th><td>Used in earlier version of SCOS-2000 by c-tree to support packets storing in files and be kept for backward compatibility.</td></tr>
<tr><th>AccessF</th><td>Storing mode, values are:

* 0 for an inserted packet;
* 1 for an update

</td></tr>
<tr><th>SimFlag</th><td>Simulated packet, values are:

* 0 for a non-simulated packet generated by the spacecraft
* 1 for a simulated packet generated by a Simulator or test tool.

</td></tr>
<tr><th>FilingTime</th><td>Filing Time. For TM this is the timestamp. For TCs, this is the release time.</td></tr>
<tr><th>CreationTime</th><td>Creation Time (in seconds since 1st Jan 1970 00:00:00) – this is a secondary retrieval key and for TM is the time at which the SCOS-2000 packet was
  created, which is also approximately the time that the packet was received by the MCS and stored.

  For TCs, this is its (estimated) execution time</td></tr>
  <tr><th>CreateID</th><td>Used by the old SCOS-2000 archive for generating a retrieval key and set by the application which generated the packet</td></tr>
  <tr><th>SCID</th><td>In the case of telemetry, Spacecraft ID. <br/>
    It has two fields:
    <table>
      <tr><td> ID </td><td> Numeric identificative</td><tr>
      <tr><td> Descriprion <td>Name of the Spacraft</td></tr>
    </table>
    The possible values are in the following table:
    <table>
      <tr><th>ID</th><th>Spacecraft</th></tr>
      <tr><td> 816 </td><td> BepiColombo, TM received over X-Band </td></tr>
      <tr><td> 817 </td><td> BepiColombo, TM received over Ka-Band </td></tr>
    </table>
    </td></tr>
    <tr><th>GSID</th><td> In the case of telemetry, the ID and name of the ground station which receives the frame containing this packet.<br/>
      It has two fields:
      <table>
        <tr><th>ID</th><td> Numeric identificative</td><tr>
        <tr><th>Station<td>Name of the Ground Station</td></tr>
      </table>
      The possible values are in the following table:
      <table>
        <tr><th>ID</th><th>Ground Station Name</th></tr>
        <tr><td> 21 </td><td> Kourou </td></tr>
        <tr><td> 22 </td><td> Perth </td></tr>
        <tr><td> 23 </td><td> New Norcia </td><tr>
        <tr><td> 24 </td><td> Cebreros </td></tr>
        <tr><td> 25 </td><td> Malargue </td></tr>
        <tr><td> 30 </td><td> Maspalomas </td></tr>
        <tr><td> 97 </td><td> Usuda </td></tr>
        <tr><td> 98 </td><td> Uchinoura </td><tr>
      </table>
    </td></tr>
    <tr><th>PSize</th><td>Packet Size. Size of the entire SCOS-2000 packet, including all headers and the packet data.</td></tr>
    <tr><th>PType</th><td>Determines the type of SCOS-2000 packet. See :ref:packet_type for details.
      <table>
        <tr><th>ID</th><th>Description</th></tr>
        <tr><td> 1 </td><td> Telemetry </td></tr>
        <tr><td> 2 </td><td> Telecommand </td></tr>
        <tr><td> 3 </td><td> Event </td></tr>
      </table>
    </td></tr>
    <tr><th>Version</th><td>The version of this packet structure.</td></tr>
    <tr><th>FilingFlag</th><td>Set to **1** if this packet is to be filed in the MCS archive, otherwise **0**.</td></tr>
    <tr><th>DistFlag</th><td>Set to : **1** if this packet is to be distributed to the MCS applications, otherwise **0**.</td></tr>
    <tr><th>TSPolicy</th><td>Determines the timestamp policy for spacecraft TM, i.e. what will be set in the Filing Time fields above:
      <table>
        <tr><th>0</th><td>packet is time-stamped with the creation time – i.e. SCOS-2000 packet creation</td></tr>
        <tr><th>1</th><td>that the packet is time-stamped with the time of transmission of the frame it was received in, i.e. Earth Reception Time minus the propagation delay (applicable to spacecraft TM only)</td></tr>
        <tr><th>2</th><td>the correlated SCET (for spacecraft TM only)</td></tr>
      </table>
    </td></tr>
    <tr><th>TQ</th><td>Time quality of the timestamp, used only if the TsPolicy is set to 2:
      <table>
        <tr><th>0</th><td>Good</td></tr>
        <tr><th>1</th><td>Inaccurate</td></tr>
        <tr><th>2</th><td>Bad</td></tr>
      </table>
    </td></tr>
    <tr><th>StreamID</th><td>The datastream identifier in the MCS, which for TM maps to VCs:
      <table>
        <tr><th>1000</th><td>VC0 Real-Time Non-Science (online)</td></tr>
        <tr><th>1001</th><td>VC1 Playback Non-Science (online)</td></tr>
        <tr><th>1002</th><td>VC2 Science (online)</td></tr>
        <tr><th>1003</th><td>VC3 File-Transfer (online)</td></tr>
        <tr><th>2000</th><td>VC0 Real-Time Non-Science (offline)</td></tr>
        <tr><th>2001</th><td>VC1 Playback Non-Science (offline)</td></tr>
        <tr><th>2002</th><td>VC1 Playback Non-Science (offline)</td></tr>
        <tr><th>2003</th><td>VC2 Science (offline)</td></tr>
        <tr><td colspan="2"> For TCs stream **1** is used.</td></tr>
        <tr><td colspan="2"> For EVs stream **1000** and **1001** is used.</td></tr>
        <tr><th>65535</th><td>is used for internal non spacecraft TM packets, which should be ignored by external users.</td></tr>
      </table>
    </td></tr>
    <tr><th>SeqCounter</th><td>Internal MCS counter used for detecting gaps – not related to the spacecraft source sequence count value in the PUS header</td></tr>
    <tr><th>SPID</th><td>the numerical packet ID which identifies the packet structure, and maps to packet definitions in the TM/TC MIB database. Note: For TC packets, SPIDs 100 and 200 are used.</td></tr>
    <tr><th>MissionID</th><td>For telemetry, the MCS mission identifier.
          <table>
        <tr><th>ID</th><th>Mission</th></tr>
        <tr> <td> **816** </td><td> BepiColombo </td></tr>
      </table>
    </td></tr>
</table>

### Telemetry Packet Header (TMPH)

If the _**CHP.PType**_ is equal to 1, the packet is a telemetry. In this case is present the TMPH onject.

The object has the following structure:
<table>
  <tr><th> Attribute </th><th>Description </th></tr>
  <tr><td>

  **TPSD**
  </td><td>Structure identifier for variable length packets.</td></tr>
  <tr><td>
  **RouteID** </td><td>The LSB of the RouteID field is used by SCOS-2000 to identify the Data Unit Type of Telemetry packet and its qualifier</td></tr>
  <tr><td> **PUSAPID** </td><td>The value of the 11-bit Application Process ID, copied from the spacecraft source packet’s primary header</td></tr>
  <tr><td>**PUSSSC**</td><td>The value of the 14-bit Source Sequence Count, copied from the spacecraft source packet’s primary header</td></tr>
  <tr><td>**PUSST**</td><td>The value of the 8-bit Service Type, copied from the spacecraft source packet’s secondary data field header</td></tr>
  <tr><td>**PUSSST**</td><td>The value of the 8-bit Service Sub-type, copied from the spacecraft source packet’s secondary data field header</td></tr>
</table>

### Telecommand Packet Header (TCPH)
If the _**CHP.PType**_ is equal to 2, the packet is a telecommand. In this case is present the TCPH onject.

The object has the following structure:
<table>
  <tr><th>Attribute</th><th>Descriprion</th></tr>
  <tr><td>

  **UplinkTime** </td><td> Uplink Time – initially set to the release time (FT), but updated with the timestamp copied from the radiation ground station response message providing the actual time of uplink from the antenna</td></tr>
  <tr> <td> **ExecTime** </td><td> Execution Time – For time-tagged commands this is the UTC user provided execution time. For immediate commands this is the release time + propagation delay and later updated to be Uplink time + propagation delay</td></tr>
  <tr><td> **LUTime** </td><td> Last Update Time, this is the MCS system time at which the TC packet was last updated with a change of status</td></tr>
  <tr><td> **RequestID** </td><td> Internal MCS identifier.</td></tr>
  <tr><td> **ReqElemIdx** </td><td> Internal MCS sub-identifier.</td><tr>
  <tr><td> **VarAddSz** </td><td> Combined size of the fixed and variable parts of the command details data.</td></tr>
  <tr><td> **PUSAPID** </td><td> The value of the 11-bit Application Process ID, copied from the spacecraft source packet’s primary header</td></tr>
  <tr><td> **PID** </td><td> Process ID</td></tr>
  <tr><td> **PCAT** </td><td> Packet Category</td></tr>
  <tr><td> **PUSSSC** </td><td> The value of the 14-bit Sequence Count, copied from the spacecraft source packet’s primary header</td></tr>
  <tr><td> **PUSST** </td><td> Service Type - The value of the 8-bit Service Type, copied from the spacecraft source
packet’s secondary data field header.</td></tr>
  <tr><td> **PUSSST** </td><td> Sub-Service Type - The value of the 8-bit Service Sub-type, copied from the spacecraft source packet’s secondary data field header</td></tr>
  <tr><td> **PUSAck** </td><td> The value of the 4-bit Ack, copied from the spacecraft source packet’s secondary data field header
  <table>
    <tr><td> **0** </td><td>No Acknowledge required for acceptance and execution</td></tr>
    <tr><td> **1** </td><td>Acknowledge required for acceptance </td></tr>
    <tr><td> **8** </td><td>Acknowledge required for execution </td></tr>
    <tr><td> **9** </td><td>Acknowledge required for acceptance and execution</td></tr>
  </table>
  </td></tr>
  <tr><td> **UplinkFlag** </td><td>
    <table>
      <tr><td> **1** </td><td> if the command is to be released (passed PTV)</td><tr>
      <tr><td> **0** </td><td> if the command is not to be released (failed PTV)</td></tr>
    </table>
  </td></tr>
  <tr><td> **SourceHost** </td><td> Numerical ID of the MCS machine running the command source.</td></tr>
  <tr><td> **SourceType** </td><td> Enumeration providing the type of the command source</td></tr>
  <tr><td> **ReqDetFixedSize** </td><td> Size of the fixed part of the command details data.</td></tr>
</table>

### Event Packet Header (EPH)
If the _**CHP.PType**_ is equal to 3, the packet is a event. In this case is present the EPH onject.

**NB:** the EPH is not yet implemented.

## Change Log

### Version 0.2.2
+ bug fix, old call to database removed
+ update of the user manual

### Version 0.2.1

+ minor bugs fixed

### Version 0.2.0

+ Introduced the TCHP
+ First version of the README file.
