import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackStorageContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_container#id DataAzurestackStorageContainer#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_container#metadata DataAzurestackStorageContainer#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_container#name DataAzurestackStorageContainer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_container#storage_account_name DataAzurestackStorageContainer#storage_account_name}
    */
    readonly storageAccountName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_container#timeouts DataAzurestackStorageContainer#timeouts}
    */
    readonly timeouts?: DataAzurestackStorageContainerTimeouts;
}
export interface DataAzurestackStorageContainerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_container#read DataAzurestackStorageContainer#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackStorageContainerTimeoutsToTerraform(struct?: DataAzurestackStorageContainerTimeoutsOutputReference | DataAzurestackStorageContainerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackStorageContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackStorageContainerTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackStorageContainerTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/storage_container azurestack_storage_container}
*/
export declare class DataAzurestackStorageContainer extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_storage_container";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/storage_container azurestack_storage_container} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackStorageContainerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackStorageContainerConfig);
    get containerAccessType(): string;
    get hasImmutabilityPolicy(): cdktf.IResolvable;
    get hasLegalHold(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _storageAccountName?;
    get storageAccountName(): string;
    set storageAccountName(value: string);
    get storageAccountNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurestackStorageContainerTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackStorageContainerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackStorageContainerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
