import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackStorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_account#id DataAzurestackStorageAccount#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_account#name DataAzurestackStorageAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_account#resource_group_name DataAzurestackStorageAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_account#timeouts DataAzurestackStorageAccount#timeouts}
    */
    readonly timeouts?: DataAzurestackStorageAccountTimeouts;
}
export interface DataAzurestackStorageAccountCustomDomain {
}
export declare function dataAzurestackStorageAccountCustomDomainToTerraform(struct?: DataAzurestackStorageAccountCustomDomain): any;
export declare class DataAzurestackStorageAccountCustomDomainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackStorageAccountCustomDomain | undefined;
    set internalValue(value: DataAzurestackStorageAccountCustomDomain | undefined);
    get name(): string;
}
export declare class DataAzurestackStorageAccountCustomDomainList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackStorageAccountCustomDomainOutputReference;
}
export interface DataAzurestackStorageAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/storage_account#read DataAzurestackStorageAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackStorageAccountTimeoutsToTerraform(struct?: DataAzurestackStorageAccountTimeoutsOutputReference | DataAzurestackStorageAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackStorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackStorageAccountTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackStorageAccountTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/storage_account azurestack_storage_account}
*/
export declare class DataAzurestackStorageAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_storage_account";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/storage_account azurestack_storage_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackStorageAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackStorageAccountConfig);
    get accountEncryptionSource(): string;
    get accountKind(): string;
    get accountReplicationType(): string;
    get accountTier(): string;
    private _customDomain;
    get customDomain(): DataAzurestackStorageAccountCustomDomainList;
    get enableBlobEncryption(): cdktf.IResolvable;
    get httpsTrafficOnlyEnabled(): cdktf.IResolvable;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryBlobConnectionString(): string;
    get primaryBlobEndpoint(): string;
    get primaryConnectionString(): string;
    get primaryFileEndpoint(): string;
    get primaryLocation(): string;
    get primaryQueueEndpoint(): string;
    get primaryTableEndpoint(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryBlobConnectionString(): string;
    get secondaryBlobEndpoint(): string;
    get secondaryConnectionString(): string;
    get secondaryLocation(): string;
    get secondaryQueueEndpoint(): string;
    get secondaryTableEndpoint(): string;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackStorageAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackStorageAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackStorageAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
