import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackResourceGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resource_group#id DataAzurestackResourceGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resource_group#name DataAzurestackResourceGroup#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resource_group#timeouts DataAzurestackResourceGroup#timeouts}
    */
    readonly timeouts?: DataAzurestackResourceGroupTimeouts;
}
export interface DataAzurestackResourceGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/resource_group#read DataAzurestackResourceGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackResourceGroupTimeoutsToTerraform(struct?: DataAzurestackResourceGroupTimeoutsOutputReference | DataAzurestackResourceGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackResourceGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackResourceGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackResourceGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/resource_group azurestack_resource_group}
*/
export declare class DataAzurestackResourceGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_resource_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/resource_group azurestack_resource_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackResourceGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackResourceGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackResourceGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackResourceGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackResourceGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
