import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackNetworkSecurityGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_security_group#id DataAzurestackNetworkSecurityGroup#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_security_group#name DataAzurestackNetworkSecurityGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_security_group#resource_group_name DataAzurestackNetworkSecurityGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_security_group#timeouts DataAzurestackNetworkSecurityGroup#timeouts}
    */
    readonly timeouts?: DataAzurestackNetworkSecurityGroupTimeouts;
}
export interface DataAzurestackNetworkSecurityGroupSecurityRule {
}
export declare function dataAzurestackNetworkSecurityGroupSecurityRuleToTerraform(struct?: DataAzurestackNetworkSecurityGroupSecurityRule): any;
export declare class DataAzurestackNetworkSecurityGroupSecurityRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackNetworkSecurityGroupSecurityRule | undefined;
    set internalValue(value: DataAzurestackNetworkSecurityGroupSecurityRule | undefined);
    get access(): string;
    get description(): string;
    get destinationAddressPrefix(): string;
    get destinationAddressPrefixes(): string[];
    get destinationPortRange(): string;
    get destinationPortRanges(): string[];
    get direction(): string;
    get name(): string;
    get priority(): number;
    get protocol(): string;
    get sourceAddressPrefix(): string;
    get sourceAddressPrefixes(): string[];
    get sourcePortRange(): string;
    get sourcePortRanges(): string[];
}
export declare class DataAzurestackNetworkSecurityGroupSecurityRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackNetworkSecurityGroupSecurityRuleOutputReference;
}
export interface DataAzurestackNetworkSecurityGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/network_security_group#read DataAzurestackNetworkSecurityGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackNetworkSecurityGroupTimeoutsToTerraform(struct?: DataAzurestackNetworkSecurityGroupTimeoutsOutputReference | DataAzurestackNetworkSecurityGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackNetworkSecurityGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackNetworkSecurityGroupTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackNetworkSecurityGroupTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/network_security_group azurestack_network_security_group}
*/
export declare class DataAzurestackNetworkSecurityGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_network_security_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/network_security_group azurestack_network_security_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackNetworkSecurityGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackNetworkSecurityGroupConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _securityRule;
    get securityRule(): DataAzurestackNetworkSecurityGroupSecurityRuleList;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackNetworkSecurityGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackNetworkSecurityGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackNetworkSecurityGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
