import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackLbConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb#id DataAzurestackLb#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb#name DataAzurestackLb#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb#resource_group_name DataAzurestackLb#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb#timeouts DataAzurestackLb#timeouts}
    */
    readonly timeouts?: DataAzurestackLbTimeouts;
}
export interface DataAzurestackLbFrontendIpConfiguration {
}
export declare function dataAzurestackLbFrontendIpConfigurationToTerraform(struct?: DataAzurestackLbFrontendIpConfiguration): any;
export declare class DataAzurestackLbFrontendIpConfigurationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataAzurestackLbFrontendIpConfiguration | undefined;
    set internalValue(value: DataAzurestackLbFrontendIpConfiguration | undefined);
    get id(): string;
    get name(): string;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
    get zones(): string;
}
export declare class DataAzurestackLbFrontendIpConfigurationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataAzurestackLbFrontendIpConfigurationOutputReference;
}
export interface DataAzurestackLbTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/lb#read DataAzurestackLb#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackLbTimeoutsToTerraform(struct?: DataAzurestackLbTimeoutsOutputReference | DataAzurestackLbTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackLbTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackLbTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackLbTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/lb azurestack_lb}
*/
export declare class DataAzurestackLb extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_lb";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/lb azurestack_lb} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackLbConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackLbConfig);
    private _frontendIpConfiguration;
    get frontendIpConfiguration(): DataAzurestackLbFrontendIpConfigurationList;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackLbTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackLbTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackLbTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
