import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurestackDnsZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/dns_zone#id DataAzurestackDnsZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/dns_zone#name DataAzurestackDnsZone#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/dns_zone#resource_group_name DataAzurestackDnsZone#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/dns_zone#timeouts DataAzurestackDnsZone#timeouts}
    */
    readonly timeouts?: DataAzurestackDnsZoneTimeouts;
}
export interface DataAzurestackDnsZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurestack/d/dns_zone#read DataAzurestackDnsZone#read}
    */
    readonly read?: string;
}
export declare function dataAzurestackDnsZoneTimeoutsToTerraform(struct?: DataAzurestackDnsZoneTimeoutsOutputReference | DataAzurestackDnsZoneTimeouts | cdktf.IResolvable): any;
export declare class DataAzurestackDnsZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataAzurestackDnsZoneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataAzurestackDnsZoneTimeouts | cdktf.IResolvable | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurestack/d/dns_zone azurestack_dns_zone}
*/
export declare class DataAzurestackDnsZone extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "azurestack_dns_zone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurestack/d/dns_zone azurestack_dns_zone} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurestackDnsZoneConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurestackDnsZoneConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get maxNumberOfRecordSets(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nameServers(): string[];
    get numberOfRecordSets(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    private _tags;
    get tags(): cdktf.StringMap;
    private _timeouts;
    get timeouts(): DataAzurestackDnsZoneTimeoutsOutputReference;
    putTimeouts(value: DataAzurestackDnsZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataAzurestackDnsZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
