/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.renderer;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.rdf.rdfxml.renderer.OWLOntologyXMLNamespaceManager;

public class RDFXMLNamespaceManager
extends OWLOntologyXMLNamespaceManager {
    public RDFXMLNamespaceManager(@Nonnull OWLOntology ontology, @Nonnull OWLDocumentFormat format) {
        super(ontology, format);
    }

    @Override
    @Nonnull
    protected Set<OWLEntity> getEntitiesThatRequireNamespaces() {
        HashSet<OWLEntity> entities = new HashSet<OWLEntity>();
        for (OWLObjectPropertyAssertionAxiom ax : this.getOntology().getAxioms(AxiomType.OBJECT_PROPERTY_ASSERTION)) {
            entities.addAll(((OWLObjectPropertyExpression)ax.getProperty()).getSignature());
        }
        for (OWLObjectPropertyAssertionAxiom ax : this.getOntology().getAxioms(AxiomType.DATA_PROPERTY_ASSERTION)) {
            entities.add((OWLEntity)((OWLDataPropertyExpression)ax.getProperty()).asOWLDataProperty());
        }
        entities.addAll(this.getOntology().getAnnotationPropertiesInSignature(Imports.INCLUDED));
        return entities;
    }

    @Nonnull
    public Set<OWLEntity> getEntitiesWithInvalidQNames() {
        HashSet<OWLEntity> result = new HashSet<OWLEntity>();
        for (OWLEntity entity : this.getEntitiesThatRequireNamespaces()) {
            if (entity.getIRI().getRemainder().isPresent()) continue;
            result.add(entity);
        }
        return result;
    }
}

